unit Unit2;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, VCL.TMSFNCTypes, VCL.TMSFNCUtils, VCL.TMSFNCGraphics, VCL.TMSFNCGraphicsTypes, VCL.TMSFNCMapsCommonTypes, VCL.TMSFNCCustomControl, VCL.TMSFNCWebBrowser,
  VCL.TMSFNCMaps, Vcl.ExtCtrls, Vcl.StdCtrls,
  VCL.TMSFNCLeaflet;



type

  T_MapPoint = record
    Latitude : double;
    Longitude : double;
  end;

  T_MapPoints = array of T_MapPoint;


  TForm2 = class(TForm)
    Panel1: TPanel;
    WebMap: TTMSFNCMaps;
    Button1: TButton;
    GoogleApi: TEdit;
    HereApi: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    RadioGroupService: TRadioGroup;
    Leaflet: TTMSFNCLeaflet;
    Button2: TButton;
    Splitter1: TSplitter;
    InsertPolylineBtn: TButton;
    InsertBtn: TButton;
    RadioGroupMap: TRadioGroup;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure RadioGroupServiceClick(Sender: TObject);
    procedure WebMapMapClick(Sender: TObject; AEventData: TTMSFNCMapsEventData);
    procedure Button2Click(Sender: TObject);
    procedure InsertBtnClick(Sender: TObject);
    procedure InsertPolylineBtnClick(Sender: TObject);
    procedure RadioGroupMapClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    MyMarkers : T_MapPoints;
    MyPolyPoints : T_MapPoints;
    fMapObject : TObject;

    function StrToDub(aStr: string): double;
    procedure LoadData;
    procedure InsertMarkers;
    procedure InsertPolyline;
    function Points2Coordinates(APoints: T_MapPoints): TTMSFNCMapsCoordinateRecArray;

    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.Button1Click(Sender: TObject);
begin
  if FormStyle = fsMDIChild then
    FormStyle := fsNormal
  else
    FormStyle := fsMDIChild;
end;

procedure TForm2.Button2Click(Sender: TObject);
const
  cTileHereMapsZakazy : string = 'https://maps.hereapi.com/v3/base/mc/{z}/{x}/{y}/png8?style=logistics.day&features=vehicle_restrictions:active_and_inactive,congestion_zones:all&apiKey=';
begin
  Leaflet.TileLayers.Clear;
  Leaflet.Options.AttributionText := '';
  Leaflet.AddTileLayer(cTileHereMapsZakazy+HereApi.Text);
//      Leaflet.Options.AttributionText := cHttpHere;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
//  WebMap.CacheFolderName := TGUID.NewGuid.ToString;
//  TMSFNCMaps1.apikey := '';
  inherited;
  LoadData;
  fMapObject := WebMap;
end;

procedure TForm2.FormShow(Sender: TObject);
begin
  RadioGroupMapClick(nil);
end;

procedure TForm2.InsertBtnClick(Sender: TObject);
begin
  InsertMarkers;
end;

procedure TForm2.InsertMarkers;
var i : integer;
begin
  if fMapObject = WebMap then
    begin
      WebMap.BeginUpdate;
      for i := 1 to length(MyMarkers) do
        begin
          WebMap.AddMarker(MyMarkers[i-1].Latitude, MyMarkers[i-1].Longitude,'Title');
        end;
      WebMap.EndUpdate;
    end;
  if fMapObject = Leaflet then
    begin
      Leaflet.BeginUpdate;
      for i := 1 to length(MyMarkers) do
        begin
          Leaflet.AddMarker(MyMarkers[i-1].Latitude, MyMarkers[i-1].Longitude,'Title');
        end;
      Leaflet.EndUpdate;
    end;
end;

procedure TForm2.InsertPolyline;
var i : integer;
begin
  if fMapObject = WebMap then
    begin
      WebMap.BeginUpdate;
      var Fnc_poly : TTMSFNCMapsPolyline;
      Fnc_poly := WebMap.AddPolyline(Points2Coordinates(MyPolyPoints));
    //  Fnc_poly.StrokeOpacity := 0.8;
      WebMap.EndUpdate;
    end;
  if fMapObject = Leaflet then
    begin
      Leaflet.BeginUpdate;
      var Leaflet_poly : TTMSFNCLeafletPolyline;
      Leaflet_poly:= Leaflet.AddPolyline(Points2Coordinates(MyPolyPoints));
      Leaflet.EndUpdate;
    end;
end;

procedure TForm2.InsertPolylineBtnClick(Sender: TObject);
begin
  InsertPolyline;
end;

procedure TForm2.LoadData;
var xStrList: TStringList;
  i : integer;
  xStr : string;
begin
  SetLength(MyMarkers, 0);
  SetLength(MyPolyPoints,0);

  if (FileExists('Points.txt')) then
    begin
      xStrList := TStringList.Create;
      xStrList.Loadfromfile('Points.txt');
      for i := 1 to xStrList.Count do
        begin
          xStr := xStrList[i-1];
          if xStr <> EmptyStr then
            begin
              SetLength(MyMarkers, Length(MyMarkers)+1);
              MyMarkers[Length(MyMarkers)-1].Longitude := StrToDub(copy(xStr,1,Pos(',',xStr)-1));
              MyMarkers[Length(MyMarkers)-1].Latitude := StrToDub(copy(xStr,Pos(',',xStr)+1,99));
            end;
        end;
      FreeAndNil(xStrList);
    end;
  if (FileExists('Polyline.txt')) then
    begin
      xStrList := TStringList.Create;
      xStrList.Loadfromfile('Polyline.txt');
      for i := 1 to xStrList.Count do
        begin
          xStr := xStrList[i-1];
          if xStr <> EmptyStr then
            begin
              SetLength(MyPolyPoints, Length(MyPolyPoints)+1);
              MyPolyPoints[Length(MyPolyPoints)-1].Latitude := StrToDub(copy(xStr,1,Pos(',',xStr)-1));
              MyPolyPoints[Length(MyPolyPoints)-1].Longitude := StrToDub(copy(xStr,Pos(',',xStr)+1,99));
            end;
        end;
      FreeAndNil(xStrList);
    end;
end;

function TForm2.Points2Coordinates(
  APoints: T_MapPoints): TTMSFNCMapsCoordinateRecArray;
var
  item: T_MapPoint;
  i: integer;
begin
  i := 0;
  SetLength(Result, Length(APoints));
  for item in APoints do
  begin
    Result[i].Latitude := item.Latitude;
    Result[i].Longitude := item.Longitude;
    inc(i);
  end;
end;

procedure TForm2.RadioGroupMapClick(Sender: TObject);
begin
  if RadioGroupMap.ItemIndex = 1 then
    begin
      fMapObject := WebMap;
      Leaflet.Visible := false;
      Leaflet.Align := alNone;
      WebMap.Visible := true;
      WebMap.Align := alClient;
      InsertBtnClick(nil);
      InsertPolylineBtnClick(nil);
    end;
  if RadioGroupMap.ItemIndex = 0 then
    begin
      fMapObject := Leaflet;
      WebMap.Visible := false;
      WebMap.Align := alNone;
      Leaflet.Visible := true;
      Leaflet.Align := alClient;
      Button2Click(nil);
      InsertBtnClick(nil);
      InsertPolylineBtnClick(nil);
    end;
end;

procedure TForm2.RadioGroupServiceClick(Sender: TObject);
begin
  if (RadioGroupService.ItemIndex = 0) then
    begin
      WebMap.Service := msOpenLayers;
    end
  else if (RadioGroupService.ItemIndex = 1) then
    begin
      WebMap.Service := msLeaflet;
    end
  else if (RadioGroupService.ItemIndex = 2) and (GoogleApi.text <> '') then
    begin
      WebMap.Service := msGoogleMaps;
      WebMap.ApiKey := GoogleApi.text;
    end
  else if (RadioGroupService.ItemIndex = 3) and (HereApi.text <> '') then
    begin
      WebMap.Service := msHere;
      WebMap.ApiKey := HereApi.text
    end
end;



function TForm2.StrToDub(aStr: string): double;
const
  Komma: TFormatSettings = (DecimalSeparator: ',');
    Dot: TFormatSettings = (DecimalSeparator: '.');
begin
  if not TryStrToFloat(aStr, Result, Komma) then
    if not TryStrToFloat(aStr, Result, Dot) then
      Result := 0.0;
end;

procedure TForm2.WebMapMapClick(Sender: TObject;
  AEventData: TTMSFNCMapsEventData);
begin

  if fMapObject = WebMap then
    begin
      WebMap.BeginUpdate;
      WebMap.AddMarker(AEventData.Coordinate.Latitude,AEventData.Coordinate.Longitude, 'Marker');
      WebMap.EndUpdate;
    end;
  if fMapObject = Leaflet then
    begin
      Leaflet.BeginUpdate;
      Leaflet.AddMarker(AEventData.Coordinate.Latitude,AEventData.Coordinate.Longitude, 'Marker');
      Leaflet.EndUpdate;
    end;
end;

end.
