unit Unit2;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, VCL.TMSFNCTypes, VCL.TMSFNCUtils, VCL.TMSFNCGraphics, VCL.TMSFNCGraphicsTypes, VCL.TMSFNCMapsCommonTypes, VCL.TMSFNCCustomControl, VCL.TMSFNCWebBrowser,
  VCL.TMSFNCMaps, Vcl.ExtCtrls, Vcl.StdCtrls,
  VCL.TMSFNCLeaflet;



type

  TForm2 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    WebMap: TTMSFNCMaps;
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure WebMapMapClick(Sender: TObject; AEventData: TTMSFNCMapsEventData);
    procedure RadioGroupMapClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    fMapObject : TObject;


    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form2: TForm2;

implementation

{$R *.dfm}

procedure TForm2.Button1Click(Sender: TObject);
begin
  if FormStyle = fsMDIChild then
    FormStyle := fsNormal
  else
    FormStyle := fsMDIChild;
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  inherited;
  fMapObject := WebMap;
end;

procedure TForm2.FormShow(Sender: TObject);
begin
  RadioGroupMapClick(nil);
end;

procedure TForm2.RadioGroupMapClick(Sender: TObject);
begin
    fMapObject := WebMap;
    WebMap.Visible := true;
    WebMap.Align := alClient;
end;

procedure TForm2.WebMapMapClick(Sender: TObject;
  AEventData: TTMSFNCMapsEventData);
begin

  if fMapObject = WebMap then
    begin
      WebMap.BeginUpdate;
      WebMap.AddMarker(AEventData.Coordinate.Latitude,AEventData.Coordinate.Longitude, 'Marker');
      WebMap.EndUpdate;
    end;
end;

end.
