program WebClient;

uses
  Vcl.Forms,
  WEBLib.Forms,
  Forms.Main in 'Forms.Main.pas' {Form1: TWebForm} {*.html},
  DataModule in 'DataModule.pas' {dmAuth: TWebDataModule},
  App.Types in 'App.Types.pas';

{$R *.res}
procedure DisplayLoginView(AMessage: string = ''); forward;
procedure DisplayMainView;

  procedure ConnectProc;
  begin
    if Assigned(Form1) then Form1.Free;
      TForm1.Display(@DisplayLoginView);
  end;

begin
    ConnectProc;
end;

procedure DisplayLoginView(AMessage: string);
begin
  dmAuth.SphinxWebLogin.Logout;
  if Assigned(Form1) then
    Form1.Free;
  dmAuth.SphinxWebLogin.Login;
end;

procedure UnauthorizedAccessProc(AMessage: string);
begin
  dmAuth.SphinxWebLogin.Login;
end;

procedure StartApplication;
begin
  if (not dmAuth.SphinxWebLogin.IsLoggedIn) then
    DisplayLoginView
  else
    DisplayMainView;
end;

begin
  Application.Initialize;
  Application.MainFormOnTaskbar := True;
  Application.CreateForm(TdmAuth, dmAuth);
  Application.Run;
  StartApplication;
end.
