unit Forms.Main;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.Controls, Vcl.StdCtrls, WEBLib.StdCtrls,
  Sparkle.Utils,
  Sphinx.WebLogin,App.Types;

type
  TForm1 = class(TWebForm)
    WebMemo1: TWebMemo;
    btLogin: TWebButton;
    btLogout: TWebButton;
    btCheckLogin: TWebButton;
    procedure btLoginClick(Sender: TObject);
    procedure btLogoutClick(Sender: TObject);
    procedure btCheckLoginClick(Sender: TObject);
  private
    FLogoutProc: TLogoutProc;
    procedure Log(const Msg: string);
    procedure LogUserInfo(Info: TAuthResult);
  public
    class procedure Display(LogoutProc: TLogoutProc);
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

uses DataModule;

procedure TForm1.btCheckLoginClick(Sender: TObject);
begin
  if dmauth.SphinxWebLogin.IsLoggedIn then
  begin
    Log('User already logged in.');
    LogUserInfo(dmauth.SphinxWebLogin.AuthResult);
  end
  else
    Log('User is not logged in.');
end;

procedure TForm1.btLoginClick(Sender: TObject);
begin
  dmauth.SphinxWebLogin.Login;
end;

procedure TForm1.btLogoutClick(Sender: TObject);
begin
  dmauth.SphinxWebLogin.Logout;
  Log('User logged out.');
end;

procedure TForm1.Log(const Msg: string);
begin
  WebMemo1.Lines.Add(Msg);
end;

procedure TForm1.LogUserInfo(Info: TAuthResult);
begin
  Log('==========');
  if Info.Profile <> nil then
    Log('Email: ' + Info.Profile.Email)
  else
    Log('No email information.');
  Log('Scope: ' + Info.Scope);
  Log('Token type: ' + Info.TokenType);
  Log('Expiration: ' + DateTimeToStr(Info.Expiration));
  Log('Is expired: ' + BoolToStr(Info.IsExpired, True));
  Log('Route at the time of login: ' + Info.AppState);
  Log('Id token: ' + Info.IdToken);
  Log('Access token: ' + Info.AccessToken);
  Log('==========');
end;

class procedure TForm1.Display(LogoutProc: TLogoutProc);
begin
   if Assigned(Form1) then
    Form1.Free;
  Form1 := TForm1.CreateNew;
  Form1.FLogoutProc := LogoutProc;

end;

end.
