unit Forms.Main;

// Uncomment the line below for an example of how to use embedded login form (instead of using external browser)
// It uses TEdgeBrowser component, thus you must have a Delphi version that supports such browser,
// and make sure you have WebView2Loader.dll in your executable output diretory.
{.$DEFINE USE_EDGEBROWSER}

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Sparkle.Http.Engine,
  Sphinx.Login, Vcl.ComCtrls, XData.Client, Data.DB, Aurelius.Bind.BaseDataset, Aurelius.Bind.Dataset,
  MusicEntities, Vcl.Grids, Vcl.DBGrids;

type
  TForm2 = class(TForm)
    btLogin: TButton;
    btLogout: TButton;
    btCheckLogin: TButton;
    SphinxLogin1: TSphinxLogin;
    PageControl1: TPageControl;
    tsAlbums: TTabSheet;
    tsLog: TTabSheet;
    Memo1: TMemo;
    adsAlbums: TAureliusDataset;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    adsAlbumsName: TStringField;
    adsAlbumsArtistName: TStringField;
    procedure btLoginClick(Sender: TObject);
    procedure btCheckLoginClick(Sender: TObject);
    procedure btLogoutClick(Sender: TObject);
    procedure SphinxLogin1UserLoggedIn(Args: TUserLoggedInArgs);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SphinxLogin1GetBrowser(Sender: TObject; var Browser: IBrowser);
  strict private
    ApiClient: TXDataClient;
    procedure ClientSendingRequest(Req: THttpRequest);
    procedure Log(const Msg: string);
    procedure LogUserInfo(Info: TAuthResult);
    procedure LoadAlbums;
  public
  end;

var
  Form2: TForm2;

implementation

{$IFDEF USE_EDGEBROWSER}
uses
  Sphinx.EmbeddedBrowser;
{$ENDIF}

{$R *.dfm}

procedure TForm2.btCheckLoginClick(Sender: TObject);
begin
  if SphinxLogin1.IsLoggedIn then
  begin
    Log('User already logged in.');
    LogUserInfo(SphinxLogin1.AuthResult);
  end
  else
    Log('User is not logged in.');
  tsLog.Show;
end;

procedure TForm2.btLoginClick(Sender: TObject);
begin
  SphinxLogin1.Login;
end;

procedure TForm2.btLogoutClick(Sender: TObject);
begin
  SphinxLogin1.Logout;
  adsAlbums.Close;
  Log('User logged out.');
end;

procedure TForm2.ClientSendingRequest(Req: THttpRequest);
begin
  if SphinxLogin1.AuthResult <> nil then
    Req.Headers.SetValue('Authorization', 'Bearer ' + SphinxLogin1.AuthResult.AccessToken);
end;

procedure TForm2.FormCreate(Sender: TObject);
begin
  ApiClient := TXDataClient.Create;
  ApiClient.Uri := 'http://localhost:2001/tms/music';
  ApiClient.HttpClient.OnSendingRequest := ClientSendingRequest;
  tsAlbums.Show;
end;

procedure TForm2.FormDestroy(Sender: TObject);
begin
  adsAlbums.Close;
  ApiClient.Free;
end;

procedure TForm2.LoadAlbums;
begin
  adsAlbums.Close;
  adsAlbums.SetSourceList(ApiClient.List<TAlbum>('$orderby=Name&$expand=Artist'), True);
  adsAlbums.Open;
end;

procedure TForm2.Log(const Msg: string);
begin
  Memo1.Lines.Add(Msg);
end;

procedure TForm2.LogUserInfo(Info: TAuthResult);
begin
  Log('==========');
  if Info.Profile <> nil then
    Log('Email: ' + Info.Profile.Email)
  else
    Log('No email information.');
  Log('Scope: ' + Info.Scope);
  Log('Token type: ' + Info.TokenType);
  Log('Expiration: ' + DateTimeToStr(Info.Expiration));
  Log('Is expired: ' + BoolToStr(Info.IsExpired, True));
  Log('Id token: ' + Info.IdToken);
  Log('Access token: ' + Info.AccessToken);
  Log('==========');
end;

procedure TForm2.SphinxLogin1GetBrowser(Sender: TObject; var Browser: IBrowser);
begin
{$IFDEF USE_EDGEBROWSER}
  Browser := TFormEmbeddedBrowser.Create;
{$ENDIF}
end;

procedure TForm2.SphinxLogin1UserLoggedIn(Args: TUserLoggedInArgs);
begin
  Log('User logged in successfully.');
  LogUserInfo(Args.LoginResult);
  LoadAlbums;
  tsAlbums.Show;
end;

end.
