unit ServerUtils;

interface

uses
  Sphinx.Context,
  Sphinx.Entities,
  Sphinx.UserManager;

procedure SeedUsers(Context: ISphinxContext);

implementation

procedure SeedUsers(Context: ISphinxContext);

  procedure CreateUser(const Name: string);
  var
    Email: string;
    Password: string;
    User: TUser;
  begin
    Email := Name + '@tmssoftware.local';
    if Context.UserManager.FindByEmail(Email) <> nil then
      Exit;

    User := Context.UserManager.CreateUserInstance;
    Context.AddOwnership(User);
    User.Email := Email;
    User.EmailConfirmed := True;
    Password := Name + '12345';
    Context.UserManager.CreateUser(User, Password);
  end;

begin
  CreateUser('Hans');
  CreateUser('Michael');
  CreateUser('Gabriel');
end;

end.
