unit MainForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, System.IOUtils,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,
  Bcl.Lang,
  Sphinx.Comp.Config, Sparkle.HttpServer.Module, Sparkle.HttpServer.Context, Sphinx.Server.Module, Aurelius.Drivers.Interfaces,
  Aurelius.Drivers.SQLite, Aurelius.Engine.DatabaseManager, Aurelius.Comp.DBSchema, Aurelius.Comp.Connection,
  XData.Comp.ConnectionPool, Sparkle.Comp.Server, Sparkle.Comp.HttpSysDispatcher, XData.Comp.Server, Sphinx.Comp.Server,
  Sparkle.Module.Static, Sparkle.Comp.StaticServer;

type
  TForm7 = class(TForm)
    SphinxServer1: TSphinxServer;
    Dispatcher: TSparkleHttpSysDispatcher;
    XDataConnectionPool1: TXDataConnectionPool;
    AureliusConnection1: TAureliusConnection;
    Memo1: TMemo;
    AureliusDBSchema1: TAureliusDBSchema;
    SphinxConfig1: TSphinxConfig;
    Button1: TButton;
    SparkleStaticServer1: TSparkleStaticServer;
    WebClientDispatcher: TSparkleHttpSysDispatcher;
    procedure FormCreate(Sender: TObject);
    procedure SphinxConfig1GetSigningData(Sender: TObject; Args: TGetSigningDataArgs);
    procedure SphinxConfig1GeneratePasswordResetToken(Sender: TObject; Args: TGeneratePasswordResetTokenArgs);
    procedure SphinxConfig1GenerateEmailConfirmationToken(Sender: TObject; Args: TGenerateEmailConfirmationTokenArgs);
    procedure Button1Click(Sender: TObject);
    procedure SphinxConfig1ConfigureToken(Sender: TObject; Args: TConfigureTokenArgs);
  strict private
    procedure ConfigureClients;
    procedure Log(const Msg: string);
  end;

var
  Form7: TForm7;

implementation

uses
  ServerUtils,
  WinApi.ShellAPI;

{$R *.dfm}

{ TForm7 }

procedure TForm7.Button1Click(Sender: TObject);
begin
  // Set folder location for web client HTML files and start serving those pages
  SparkleStaticServer1.RootDir := TPath.Combine(TPath.GetDirectoryName(ParamStr(0)), '..\..\..\WebClientFiles');
  WebClientDispatcher.Start;
  ShellExecute(0, PChar('open'), 'http://localhost:2001/tms/WebClient/', nil, nil, SW_NORMAL);
end;

procedure TForm7.ConfigureClients;
var
  Client: TSphinxClientApp;
begin
  // The following properties can be simply set at design-time using the TSphinxConfig.Clients property
  // We keep it in the code here for learning purposes

  // Create desktop client
  Client := SphinxConfig1.Clients.Add;
  Client.ClientId := 'desktop';
  Client.DisplayName := 'My App';
  Client.RedirectUris.Add('http://127.0.0.1');
  Client.RequireClientSecret := False;
  Client.AllowedGrantTypes := [TGrantType.gtAuthorizationCode];
  Client.ValidScopes.Add('openid');
  Client.ValidScopes.Add('email');

  // Create web client
  Client := SphinxConfig1.Clients.Add;
  Client.ClientId := 'web';
  Client.DisplayName := 'My App';
  Client.RedirectUris.Add('http://localhost:2001/tms/WebClient/');
  Client.RequireClientSecret := False;
  Client.AllowedGrantTypes := [TGrantType.gtAuthorizationCode];
  Client.ValidScopes.Add('openid');
  Client.ValidScopes.Add('email');
end;

procedure TForm7.FormCreate(Sender: TObject);
begin
  // Initialize the language engine
  TLang.Init;

  // Set the SQLite database location (same file name as .exe but with .db extension)
  AureliusConnection1.Params.Values['Database'] := ChangeFileExt(ParamStr(0), '.db');

  // Create all needed tables and fields in database
  AureliusDBSchema1.UpdateDatabase;

  // Manually create some users
  SeedUsers(SphinxServer1.CreateContext);

  // Start the server
  ConfigureClients;
  Dispatcher.Start;
  Log('Server started at ' + StringReplace(SphinxServer1.BaseUrl, '+', 'localhost', []));
  Log('Watch this space for email confirmation and password reset tokens.');
end;

procedure TForm7.Log(const Msg: string);
begin
  TThread.Queue(nil, procedure
    begin
      Memo1.Lines.Add(Msg);
    end);
end;

procedure TForm7.SphinxConfig1ConfigureToken(Sender: TObject; Args: TConfigureTokenArgs);
var
  TenantId: string;
  P: Integer;
begin
  TenantId := Args.User.Email.ValueOrDefault;
  P := Pos('@tmssoftware.local', TenantId);
  if P > 1 then
    TenantId := UpperCase(Copy(TenantId, 1, 1)) + Copy(TenantId, 2, P - 2);
  Args.Token.Claims.AddOrSet('tenantId', TenantId)
end;

procedure TForm7.SphinxConfig1GenerateEmailConfirmationToken(Sender: TObject; Args: TGenerateEmailConfirmationTokenArgs);
begin
  Log('Email confirmation token: ' + Args.Token);
end;

procedure TForm7.SphinxConfig1GeneratePasswordResetToken(Sender: TObject; Args: TGeneratePasswordResetTokenArgs);
begin
  Log('Password reset token: ' + Args.Token);
end;

procedure TForm7.SphinxConfig1GetSigningData(Sender: TObject; Args: TGetSigningDataArgs);
begin
  Args.Data.Key := TEncoding.UTF8.GetBytes('a secret that has the minimum length');
end;

end.
