unit Forms.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Sparkle.HttpServer.Module, Sparkle.HttpServer.Context, XData.Server.Module,
  Sparkle.Comp.Server, XData.Comp.Server, Sparkle.Comp.HttpSysDispatcher, Vcl.StdCtrls, Aurelius.Drivers.SQLite,
  Aurelius.Drivers.Interfaces, XData.Comp.ConnectionPool, Aurelius.Comp.Connection, Sparkle.Comp.TenantMiddleware,
  Sparkle.Middleware.Tenant, Aurelius.Mapping.FilterEnforcer, Aurelius.Mapping.Explorer, Sparkle.Comp.JwtMiddleware,
  Sparkle.Comp.CorsMiddleware;

type
  TForm3 = class(TForm)
    SparkleHttpSysDispatcher1: TSparkleHttpSysDispatcher;
    XDataServer1: TXDataServer;
    btStart: TButton;
    btStop: TButton;
    Memo1: TMemo;
    AureliusConnection1: TAureliusConnection;
    XDataConnectionPool1: TXDataConnectionPool;
    XDataServer1Tenant: TSparkleTenantMiddleware;
    XDataServer1JWT: TSparkleJwtMiddleware;
    XDataServer1CORS: TSparkleCorsMiddleware;
    procedure SparkleHttpSysDispatcher1Start(Sender: TObject);
    procedure SparkleHttpSysDispatcher1Stop(Sender: TObject);
    procedure btStartClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure XDataServer1ManagerCreate(Sender: TObject; Args: TManagerCreateArgs);
    procedure FormDestroy(Sender: TObject);
    procedure XDataServer1JWTGetSecretEx(Sender: TObject; const JWT: TJWT; Context: THttpServerContext;
      var Secret: TArray<System.Byte>);
  private
    Enforcer: TFilterEnforcer;
    procedure Log(const Msg: string);
  public
  end;

var
  Form3: TForm3;

implementation

uses
  DatabaseUtils;

{$R *.dfm}

procedure TForm3.btStartClick(Sender: TObject);
begin
  SparkleHttpSysDispatcher1.Start;
end;

procedure TForm3.btStopClick(Sender: TObject);
begin
  SparkleHttpSysDispatcher1.Stop;
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  UpdateDatabase(XDataConnectionPool1.GetPoolInterface.GetConnection);
  Enforcer := TFilterEnforcer.Create('Multitenant', 'TenantId', 'FTenantId');
  Enforcer.Activate(TMappingExplorer.Default);
end;

procedure TForm3.FormDestroy(Sender: TObject);
begin
  Enforcer.Deactivate(TMappingExplorer.Default);
  Enforcer.Free;
end;

procedure TForm3.Log(const Msg: string);
begin
  TThread.Queue(nil, procedure
    begin
      Memo1.Lines.Add(Msg);
    end);
end;

procedure TForm3.SparkleHttpSysDispatcher1Start(Sender: TObject);
begin
  Log('Server running at ' + StringReplace(XDataServer1.BaseUrl, '+', 'localhost', []));
end;

procedure TForm3.SparkleHttpSysDispatcher1Stop(Sender: TObject);
begin
  if not (csDestroying in ComponentState) then
    Log('Server stopped.');
end;

procedure TForm3.XDataServer1JWTGetSecretEx(Sender: TObject; const JWT: TJWT; Context: THttpServerContext;
  var Secret: TArray<System.Byte>);
begin
  Secret := TEncoding.UTF8.GetBytes('a secret that has the minimum length');
end;

procedure TForm3.XDataServer1ManagerCreate(Sender: TObject; Args: TManagerCreateArgs);
begin
  Args.Manager.EnableFilter('Multitenant')
    .SetParam('TenantId', Args.Handler.Context.RequiredItem<ITenant>.TenantId);
end;

end.
