unit Unit3;

interface

uses
  System.SysUtils,
  System.Types,
  System.UITypes,
  System.Classes,
  System.Variants,
  FMX.Types,
  FMX.Controls,
  FMX.Forms,
  FMX.Graphics,
  FMX.Dialogs,
  Data.Bind.Controls,
  Data.Bind.Components,
  Data.Bind.DBScope,
  Data.DB,
  Datasnap.DBClient,
  FMX.Layouts,
  Fmx.Bind.Navigator,
  FMX.Controls.Presentation,
  FMX.Edit,
  FMX.TMSFNCEdit,
  FMX.TMSFNCTypes,
  FMX.TMSFNCUtils,
  FMX.TMSFNCGraphics,
  FMX.TMSFNCGraphicsTypes,
  FMX.TMSFNCCustomComponent,
  FMX.TMSFNCDataBinding,
  FMX.TMSFNCCustomControl,
  FMX.TMSFNCListBox,
  FireDAC.Stan.Intf,
  FireDAC.Stan.Option,
  FireDAC.Stan.Param,
  FireDAC.Stan.Error,
  FireDAC.DatS,
  FireDAC.Phys.Intf,
  FireDAC.DApt.Intf,
  FireDAC.Comp.DataSet,
  FireDAC.Comp.Client,
  FMX.ListBox, FMX.StdCtrls, FMX.TMSFNCCustomPicker, FMX.TMSFNCDatePicker,
  FMX.EditBox, FMX.SpinBox, System.Rtti, FMX.TMSFNCDataGridCell,
  FMX.TMSFNCDataGridData, FMX.TMSFNCDataGridBase, FMX.TMSFNCDataGridCore,
  FMX.TMSFNCDataGridRenderer, FMX.TMSFNCDataGridDatabaseAdapter,
  FMX.TMSFNCDataGrid;

type
  TForm3 = class(TForm)
    edVorname: TTMSFNCEdit;
    BindNavigator1: TBindNavigator;
    DataSource1: TDataSource;
    BindSourceDB1: TBindSourceDB;
    TMSFNCListBox1: TTMSFNCListBox;
    TMSFNCDataBinder1: TTMSFNCDataBinder;
    FDMemTable1: TFDMemTable;
    FDMemTable1ID: TIntegerField;
    FDMemTable1Vorname: TStringField;
    FDMemTable1Zuname: TStringField;
    FDMemTable1GebDat: TDateField;
    edZuname: TTMSFNCEdit;
    lblVorname: TLabel;
    lblZuname: TLabel;
    dtGebDat: TTMSFNCDatePicker;
    spID: TSpinBox;
    grdData: TTMSFNCDataGrid;
    TMSFNCDataGridDatabaseAdapter: TTMSFNCDataGridDatabaseAdapter;
    DataSource: TDataSource;
    procedure BindControls;
    procedure CreateData;
    procedure FormCreate(Sender: TObject);
    procedure SetupGrid;
  private
  { Private-Deklarationen }
  public
  { Public-Deklarationen }
  end;

var
  Form3: TForm3;

implementation

{$R *.fmx}

procedure TForm3.BindControls;
begin
  TMSFNCDataBinder1.ConnectSingle(edVorname, DataSource1, 'Text', 'Vorname');
  TMSFNCDataBinder1.ConnectSingle(edZuname, DataSource1, 'Text', 'Zuname');
  TMSFNCDataBinder1.ConnectSingle(dtGebDat, DataSource1, 'SelectedDate', 'Gebdat');
  TMSFNCDataBinder1.ConnectSingle(spID, DataSource1, 'Text', 'ID');
  TMSFNCDataBinder1.ConnectList(TMSFNCListBox1, DataSource1, 'Items', ['Text'],['Zuname']);
  TMSFNCDataBinder1.Active := True;
end;

procedure TForm3.CreateData;
var
  I: Integer;
begin
  FDMemTable1.Open;
  for I := 1 to 20 do begin
    FDMemTable1.InsertRecord([100 + i, 'Bernd' + i.ToString, 'Maierhofer' + i.ToString, Now - 55 + i]);
    FDMemTable1.InsertRecord([200 + i, 'Oskar'+i.ToString, 'Test' + i.ToString, Now - 25 + i]);
  end;
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  CreateData;
  BindControls;
  SetupGrid;
  FDMemTable1.First;
end;

procedure TForm3.SetupGrid;
begin
grdData.Options.Sorting.Enabled := True;
grdData.AddButtonColumn(4,'Delete');
grdData.AddButton(2,3,'Delete');
end;

end.
