unit Unit3;

interface

uses
  System.SysUtils,
  System.Types,
  System.Classes,
  System.Variants,
  FMX.Types,
  FMX.Controls,
  FMX.Forms,
  FMX.Graphics,
  FMX.Dialogs,
  FMX.Controls.Presentation,
  FMX.StdCtrls,
  FMX.Objects,
  FMX.Edit,
  FMX.TMSFNCEdit,
  FMX.Memo.Types,
  FMX.ScrollBox,
  FMX.Memo,
  FMX.TMSFNCTypes,
  FMX.TMSFNCUtils,
  FMX.TMSFNCGraphics,
  FMX.TMSFNCGraphicsTypes,
  System.Rtti,
  FMX.TMSFNCDataGridCell,
  FMX.TMSFNCDataGridData,
  FMX.TMSFNCDataGridBase,
  FMX.TMSFNCDataGridCore,
  FMX.TMSFNCDataGridRenderer,
  FMX.TMSFNCDataGrid,
  FMX.TMSFNCCustomControl,
  FMX.TMSFNCListBox,
  FireDAC.Stan.Intf,
  FireDAC.Stan.Option,
  FireDAC.Stan.Param,
  FireDAC.Stan.Error,
  FireDAC.DatS,
  FireDAC.Phys.Intf,
  FireDAC.DApt.Intf,
  Data.DB,
  FireDAC.Comp.DataSet,
  FireDAC.Comp.Client,
  FMX.TMSFNCPageControl,
  FMX.TMSFNCTabSet,
  FMX.TabControl,
  FMX.TMSFNCDirectoryEdit,
  FMX.Effects,
  FMX.TMSFNCCustomComponent,
  FMX.TMSFNCDataGridDatabaseAdapter;

type
  TForm3 = class(TForm)
    rectDemo: TRectangle;
    btnStyle: TButton;
    rect1: TRectangle;
    rect2: TRectangle;
    edStyle: TTMSFNCEdit;
    ed2: TTMSFNCEdit;
    mlStyle: TMemo;
    lbDemo: TTMSFNCListBox;
    grdDemo: TTMSFNCDataGrid;
    memDemo: TFDMemTable;
    memDemoID: TIntegerField;
    memDemoName: TStringField;
    memDemoGebDat: TDateField;
    sbForm: TStyleBook;
    rectMain: TRectangle;
    dlgOpen: TOpenDialog;
    edOutside: TTMSFNCEdit;
    lbl12: TLabel;
    Panel: TPanel;
    TabControl: TTabControl;
    TabItem: TTabItem;
    TabItem1: TTabItem;
    TMSFNCPageControl: TTMSFNCPageControl;
    TMSFNCPageControl1Page0: TTMSFNCPageControlContainer;
    TMSFNCPageControl1Page1: TTMSFNCPageControlContainer;
    TMSFNCPageControl1Page2: TTMSFNCPageControlContainer;
    lbStyles: TTMSFNCListBox;
    TMSFNCDirectoryEdit: TTMSFNCDirectoryEdit;
    Memo: TMemo;
    rect: TRectangle;
    GroupBox: TGroupBox;
    ed: TTMSFNCEdit;
    ShadowEffect: TShadowEffect;
    gdaDemo: TTMSFNCDataGridDatabaseAdapter;
    dsDemo: TDataSource;
    procedure AddSampleData(memDemo: TFDMemTable);
    procedure FormCreate(Sender: TObject);
    procedure btnStyleClick(Sender: TObject);
    procedure lbStylesItemSelected(Sender: TObject; AItem: TTMSFNCListBoxItem);
    procedure LoadStyles(sPath: string);
    procedure InitialForm;
    procedure StyleGrid(aGrid: TTMSFNCDataGrid);
    procedure TMSFNCDirectoryEditDialogClose(Sender: TObject; var AResultPath: string; ASuccess: Boolean);
  private
  { Private-Deklarationen }
  public
  { Public-Deklarationen }
  end;

var
  Form3: TForm3;

implementation

uses
  FMX.Colors,
  System.UIConsts,
  System.IOUtils,
  uLayout,
  FMX.Layouts,
  FMX.Styles.Objects,
  RandomUtilsU,
  System.UITypes;

{$R *.fmx}

procedure DisableControls(dsData: TDataSet; p: TProc);
begin
  dsData.DisableControls;
  p;
  dsData.EnableControls;
end;

procedure TForm3.AddSampleData(memDemo: TFDMemTable);
begin
  DisableControls(
      memDemo,
      procedure
      begin
        for var i := 0 to 100 do begin
          memDemo.Append;
          memDemo.FieldByName('Name').AsString := GetRndFullName;
          memDemo.FieldByName('gebdat').AsDateTime := GetRndDate();
          memDemo.FieldByName('id').AsInteger := GetRndInteger(1);
          memDemo.Post;
        end;
      end
  );
end;

procedure TForm3.FormCreate(Sender: TObject);
begin
  InitialForm;
end;

procedure TForm3.btnStyleClick(Sender: TObject);
var
  ShadowEffect: TShadowEffect;
begin
  StyleGrid(grdDemo);
  TSetDesign.DefaultForm(Self);
  TSetDesign.RectangleBig(rectMain);
  TSetDesign.Rectangle([rectDemo, rect1, rect2]);

  ShadowEffect := TShadowEffect.Create(Self);
  ShadowEffect.Parent := edOutside;
  ShadowEffect.Enabled := true;
  ShadowEffect.ShadowColor := StringToAlphaColor('Crimson');
  ShadowEffect.Trigger := 'IsFocused=true';
  ShadowEffect := TShadowEffect.Create(Self);
  ShadowEffect.Name := 'eoShadowEffect';
end;

procedure TForm3.lbStylesItemSelected(Sender: TObject; AItem: TTMSFNCListBoxItem);
begin
  StyleBook := nil;
  sbForm.Clear;
  sbForm.LoadFromFile(AItem.Text);
  StyleBook := sbForm;
end;

procedure TForm3.LoadStyles(sPath: string);
var
  Files: TStringDynArray;
  List: TStringList;
  FileName: string;
begin
  lbStyles.Items.Clear;
  Files := TDirectory.GetFiles(sPath, '*.style');
  for FileName in Files do
    lbStyles.AddItem(FileName);
end;

procedure TForm3.InitialForm;
begin
  memDemo.Active := True;
  AddSampleData(memDemo);
end;

procedure TForm3.StyleGrid(aGrid: TTMSFNCDataGrid);
begin
  agrid.AdaptToStyle := True;
  agrid.Options.Sorting.Enabled := True;
  agrid.Options.Sorting.Row := 0;
  agrid.Footer.Bar.Visible := True;
  aGrid.Footer.Visible := True;
  aGrid.Options.Column.Stretching.Enabled := True;
  aGrid.Options.Banding.Enabled := True;
  aGrid.Options.Selection.mode:=gsmSingleRow;
  for var i := 0 to aGrid.RowCount - 1 do begin
    aGrid.FontStyles[i, 0] := aGrid.FontStyles[i, 0] + [TFontStyle.fsBold];
    aGrid.Colors[i,0]:=gcOrangered;
  end;
end;

procedure TForm3.TMSFNCDirectoryEditDialogClose(Sender: TObject; var AResultPath: string; ASuccess: Boolean);
begin
  if ASuccess then
    LoadStyles(aResultPath);
end;

end.
