unit uLayout;

interface

uses
  System.UIConsts,
  FMX.Types,
  System.UITypes,
  FMX.Objects,
  FMX.Forms;

type
  TSetDesign = class(TObject)
    class function DefaultBackGround: TAlphaColor;
    class function DefaultBorder: TAlphaColor;
    class procedure Rectangle(aRect: TRectangle); overload;
    class procedure Rectangle(aRectArray: array of TRectangle); overload;
    class procedure RectangleBig(aRect: TRectangle); overload;
    class procedure RectangleBig(aRectArray: array of TRectangle); overload;
    class function DefaultBackGroundBig: TAlphaColor;
    class procedure DefaultForm(aForm: TForm);
  end;

implementation

uses
  FMX.Graphics;

class function TSetDesign.DefaultBackGround: TAlphaColor;
begin
  Result := MakeColor(247, 254, 255, 255);
end;

class function TSetDesign.DefaultBorder: TAlphaColor;
begin
  Result := TAlphaColors.LightSkyblue;
end;

class procedure TSetdesign.Rectangle(aRectArray: array of TRectangle);
begin
  for var rect: TRectangle in aRectArray do begin
    Rectangle(rect);
  end;
end;

class function TSetDesign.DefaultBackGroundBig: TAlphaColor;
begin
  Result := TAlphaColors.LightBlue;
end;

class procedure TSetDesign.DefaultForm(aForm: TForm);
begin
  aForm.Fill.Kind:= TBrushKind.Gradient;
  aForm.Fill.Color := TAlphaColors.Aliceblue;
end;

class procedure TSetDesign.RectangleBig(aRectArray: array of TRectangle);
begin
  for var rect: TRectangle in aRectArray do begin
    RectangleBig(rect);
  end;
end;

class procedure TSetdesign.Rectangle(aRect: TRectangle);
begin
  arect.CornerType := TCornerType.Round;
  arect.XRadius := 5;
  arect.YRadius := 5;
//  arect.stroke.Kind := TBrushKind.None;
end;

class procedure TSetdesign.RectangleBig(aRect: TRectangle);
begin
  arect.CornerType := TCornerType.Round;
  arect.XRadius := 5;
  arect.YRadius := 5;
//  arect.stroke.Kind := TBrushKind.None;
end;

end.
