unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Param,
  FireDAC.Stan.Error, FireDAC.DatS, FireDAC.Phys.Intf, FireDAC.DApt.Intf,
  Data.DB, FireDAC.Comp.DataSet, FireDAC.Comp.Client, FMX.TMSFNCTypes,
  FMX.TMSFNCUtils, FMX.TMSFNCGraphics, FMX.TMSFNCGraphicsTypes, System.Rtti,
  FMX.TMSFNCDataGridCell, FMX.TMSFNCDataGridData, FMX.TMSFNCDataGridBase,
  FMX.TMSFNCDataGridCore, FMX.TMSFNCDataGridRenderer, FMX.TMSFNCCustomControl,
  FMX.TMSFNCDataGrid, FMX.TMSFNCCustomComponent,
  FMX.TMSFNCDataGridDatabaseAdapter, FMX.Controls.Presentation, FMX.StdCtrls;

type
  TForm1 = class(TForm)
    FDMemTable1: TFDMemTable;
    FDMemTable1id: TIntegerField;
    FDMemTable1name: TStringField;
    TMSFNCDataGridDatabaseAdapter1: TTMSFNCDataGridDatabaseAdapter;
    DataSource1: TDataSource;
    TMSFNCDataGrid1: TTMSFNCDataGrid;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}

procedure TForm1.Button1Click(Sender: TObject);
begin
  TMSFNCDataGridDatabaseAdapter1.LoadAllData;
  TMSFNCDataGridDatabaseAdapter1.Active := false;

  ShowMessage('try to scroll the grid... you will see empty rows now, and also try to edit a row with existing data');

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  FDMemTable1.Active := true;
  for var i := 0 to 200 do
    begin
      FDMemTable1.Append;
      FDMemTable1.Fields[0].Value := i;
      FDMemTable1.Fields[1].Value := 'name id: ' + i.ToString;
      FDMemTable1.Post;
    end;
  DataSource1.Enabled := true;
end;

end.
