unit frmMain;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  WinApi.ShellApi,
  Vcl.StdCtrls, dmServerContainer;

type
  TMainForm = class(TForm)
    mmInfo: TMemo;
    Button1: TButton;
    procedure FormCreate(ASender: TObject);
    procedure Button1Click(Sender: TObject);
  strict private
    procedure UpdateGUI;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

resourcestring
  SServerStarted = 'Servers running, endpoints at Urls:';
  SServerNotRunning = 'Server not running, some error happened';
const
  SUrl1 = 'http://localhost:2001/tms/default/';
  SUrl2 = 'http://localhost:2001/tms/model1/swaggerui';
  SUrl3 = 'http://localhost:2001/tms/model2/swaggerui';

{ TMainForm }

procedure TMainForm.Button1Click(Sender: TObject);
begin
  //ShellExecute(0, 'open', SUrl1, nil, nil, SW_SHOW);
  ShellExecute(0, 'open', SUrl2, nil, nil, SW_SHOW);
  ShellExecute(0, 'open', SUrl3, nil, nil, SW_SHOW);
end;

procedure TMainForm.FormCreate(ASender: TObject);
begin
  UpdateGUI;
end;

procedure TMainForm.UpdateGUI;
begin
  if ServerContainer.SparkleHttpSysDispatcher.Active then
  begin
    mmInfo.Lines.Add(SServerStarted);
    //mmInfo.Lines.Add(SUrl1);
    mmInfo.Lines.Add('SwaggerUI - OK');
    mmInfo.Lines.Add(SUrl2);
    mmInfo.Lines.Add('SwaggerUI - CRASH');
    mmInfo.Lines.Add(SUrl3);
  end
  else
    mmInfo.Lines.Add(SServerNotRunning);
end;

end.
