unit uGlobalLog;

interface

uses uGlobalVar, System.AnsiStrings, Winapi.Windows, System.SysUtils,
     Quick.Logger, System.DateUtils, StrUtils;//, uLoggerProConfig;

procedure WriteLogTime(Txt:string);
procedure WriteLogTime2(Txt:string);
procedure WriteLogTime3(Txt:string);
procedure WriteLogTime4(Txt:string);

implementation

procedure WriteLogTime(Txt:String);
Var
  h,m,s,ms : Word;
  fh : Integer;
  logFileName : string;
  LogFile: TextFile;
Begin
 fh := 0;

  //If Loging then
     Begin
       logFileName := ExtractFilePath(ParamStr(0))+'\log\emistr_'+GetEnvironmentVariable('COMPUTERNAME')+'.log';

       If Not FileExists(logFileName) then
        Begin
          try
            //fh:=FileCreate(ExtractFilePath(ParamStr(0))+'\emistr.log');
            fh:=FileCreate(logFileName);
          finally
            FileClose(fh);
          end;
        End;

       DecodeTime(now, H, M, S, MS);

        if Copy(Txt,1,5)='ERROR' then
          Logger.Error(Txt)
        else
          Logger.Info(Txt);

       Txt := FormatDateTime('hh:nn:ss.zzz',now()) + ' --> ' + Txt;

       try
         AssignFile(LogFile,logFileName);
         Append(LogFile);

         WriteLn(LogFile,Txt);
       finally
         CloseFile(LogFile);
       end;
     End;
End;

procedure WriteLogTime2(Txt:String);
Var
  h,m,s,ms : Word;
  LogFile: TextFile;
  fh : integer;
  logFileName : string;
Begin
   logFileName := ExtractFilePath(ParamStr(0))+'\log\emistr2_'+GetEnvironmentVariable('COMPUTERNAME')+'.log';

   //ForceDirectories(ExtractFilePath(ParamStr(0))+'\log');

   if LOGING then logFileName := ExtractFilePath(ParamStr(0))+'\log\emistr2_'+GetEnvironmentVariable('COMPUTERNAME')+StrUtils.IfThen(LOGING,FormatDateTime('_yyyy-mm-dd',Now),'')+'.log';

    try
     Begin
       If Not FileExists(logFileName) then
        Begin
          fh:=FileCreate(logFileName);
          FileClose(fh);
        End;
       DecodeTime(now, H, M, S, MS);

       //Txt := DateToStr(now)+' '+intToStr(h)+':'+intToStr(m)+':'+intToStr(s)+','+intToStr(ms)+ ' --> ' + Txt;
       Txt := DateToStr(now)+' '+Format('%.2d',[h])+':'+Format('%.2d',[m])+':'+Format('%.2d',[s])+','+Format('%.3d',[ms])+ ' --> ' + Txt;
       Txt := Txt + ';' + IntToStr(SecondsBetween(DEBUG_TIME, now));

       AssignFile(LogFile,logFileName);

       if not FileExists(logFileName) then
         Rewrite(LogFile)
       else
         Append(LogFile);

       WriteLn(LogFile,Txt);
       CloseFile(LogFile);
     End;
    except on e:exception do
      WriteLogTime(e.message);
    end;

End;


procedure WriteLogTime3(Txt:String);
Var
  h,m,s,ms : Word;
  LogFile: TextFile;
  fh : integer;
  logFileName : string;
Begin
   //ForceDirectories(ExtractFilePath(ParamStr(0))+'\log');

   logFileName := ExtractFilePath(ParamStr(0))+'\log\emistr3_'+GetEnvironmentVariable('COMPUTERNAME')+tmpPID+'.log';

    try
     Begin
       If Not FileExists(logFileName) then
        Begin
          fh:=FileCreate(logFileName);
          FileClose(fh);
        End;
       DecodeTime(now, H, M, S, MS);

       //Txt := DateToStr(now)+' '+intToStr(h)+':'+intToStr(m)+':'+intToStr(s)+','+intToStr(ms)+ ' --> ' + Txt;
       Txt := DateToStr(now)+' '+Format('%.2d',[h])+':'+Format('%.2d',[m])+':'+Format('%.2d',[s])+','+Format('%.3d',[ms])+ ' --> ' + Txt;

       //Txt := Txt + ';' + IntToStr(SecondsBetween(DEBUG_TIME, now));

       AssignFile(LogFile,logFileName);

       if not FileExists(logFileName) then
         Rewrite(LogFile)
       else
         Append(LogFile);

       WriteLn(LogFile,Txt);
       CloseFile(LogFile);
     End;
    except;
    end;
End;

//procedure WriteLogTime4(Txt:String);
//Var
//  h,m,s,ms : Word;
//  LogFile: TextFile;
//  fh : integer;
//  logFileName : string;
//Begin
////  LogP.Debug(Txt,'4');
////  exit;
//
//
//  fCS.Enter;
//  Try
//   logFileName := ExtractFilePath(ParamStr(0))+'\log\emistr4_'+GetEnvironmentVariable('COMPUTERNAME')+tmpPID+'.log';
//
//   //ForceDirectories(ExtractFilePath(ParamStr(0))+'\log');
//
//    try
//     Begin
//       If Not FileExists(logFileName) then
//        Begin
//          fh:=FileCreate(logFileName);
//          FileClose(fh);
//        End;
//       DecodeTime(now, H, M, S, MS);
//
//       //Txt := DateToStr(now)+' '+intToStr(h)+':'+intToStr(m)+':'+intToStr(s)+','+intToStr(ms)+ ' --> ' + Txt;
//       Txt := DateToStr(now)+' '+Format('%.2d',[h])+':'+Format('%.2d',[m])+':'+Format('%.2d',[s])+','+Format('%.3d',[ms])+ ' --> ' + Txt;
//
//       //Txt := Txt + ';' + IntToStr(SecondsBetween(DEBUG_TIME, now));
//
//       AssignFile(LogFile,logFileName);
//
//       if not FileExists(logFileName) then
//         Rewrite(LogFile)
//       else
//         Append(LogFile);
//
//       WriteLn(LogFile,Txt);
//       CloseFile(LogFile);
//     End;
//    except;
//    end;
//  finally
//    fCS.Leave;
//  End;
//End;

procedure WriteLogTime4(Txt:String);
Var
  h,m,s,ms : Word;
  LogFile: TextFile;
  fh : integer;
  logFileName : string;
Begin
  //LogP.Debug(Txt,'4');
  //exit;


   logFileName := ExtractFilePath(ParamStr(0))+'\log\emistr4_'+GetEnvironmentVariable('COMPUTERNAME')+tmpPID+'.log';

   //ForceDirectories(ExtractFilePath(ParamStr(0))+'\log');

    try
     Begin
       If Not FileExists(logFileName) then
        Begin
          fh:=FileCreate(logFileName);
          FileClose(fh);
        End;
       DecodeTime(now, H, M, S, MS);

       //Txt := DateToStr(now)+' '+intToStr(h)+':'+intToStr(m)+':'+intToStr(s)+','+intToStr(ms)+ ' --> ' + Txt;
       Txt := DateToStr(now)+' '+Format('%.2d',[h])+':'+Format('%.2d',[m])+':'+Format('%.2d',[s])+','+Format('%.3d',[ms])+ ' --> ' + Txt;

       //Txt := Txt + ';' + IntToStr(SecondsBetween(DEBUG_TIME, now));

       AssignFile(LogFile,logFileName);

       if not FileExists(logFileName) then
         Rewrite(LogFile)
       else
         Append(LogFile);

       WriteLn(LogFile,Txt);
       CloseFile(LogFile);
     End;
    except;
    end;

End;

end.
