unit uAureliusDict;

interface
 Uses System.Generics.Collections,Menus,eMISTRDataModel;

  type
    tTabulka = class (TObject)
      public
        Key, Value, TableName, FieldName, Caption : String;
        IsDoklad : boolean; // je doklad pro Pravidla selnch ad
        NeedsTypDokladu : integer; // Vznikajc doklad potebuje typ poloky, 0 ne, 1 prijemky 2 vydejky
        DestDoklady : TList<string>; // seznam monch vznikajcch doklad
        constructor create(const aKey, aValue, aTableName, aFieldName: string; aCaption: String = '';
                           aIsDoklad : boolean = False; aNeedsTypDokladu : integer = 0);
        procedure SetDestDoklady (aDestDoklady : array of string);
        destructor Destroy; override;
      end;
    TAureliusDict = class
      private
        MyDict : TDictionary<string, integer>;
        MyDictUserFieldsType : TDictionary<string, integer>;
        procedure VytvorMyDict;
        procedure VytvorMyDictUserFieldsType;
        procedure VytvorTabulkyStavyDokladu;
        procedure VytvorTabulkyCiselneRady;
      public
        TabulkyStavyDokladu : TObjectList<tTabulka>;
        TabulkyCiselneRady : TObjectList<tTabulka>;
        Constructor create;
        Destructor destroy; override;
        Function GetClassConst(aClassName : String) : Integer;
        Function GetUserFieldType(aType: String) : Integer;
        function GetTabulkyIdx(aKey: String; Tabulka: TObjectList<tTabulka>): Integer;

    end;


var
  AureliusDict : TAureliusDict;


type
    TAgendaRights = class (TObject)
      private
        fAgendaID : integer;   // identifiktor agendy, viz konstanty
        fAgendaName : string;  // nzev agendy, pvodn vracelo GetAgendaName
        fFormClass : TClass; // odkaz na formul agendy
        fEditFormClass : TClass; // odkaz na editan formul agendy
        fMainMenuItem : TMenuItem; // kde je v  hlavnm menu
        fSubMenuItem : TMenuItem;  // kde je v submenu
        fMainMenuItemName : string; // kde je v  hlavnm menu / nazev komponenty
        fSubMenuItemName : string;  // kde je v submenu /nazev komponenty
        fImageIndex : integer; // kd obrzku do dm.PopupMenuImages, pokud je SubMenuItem null - nap pro agendy poloek
        fAgendaText : string; // nzev agendy, pokud je SubMenuItem null - nap pro agendy poloek
        fParentAgendaID : integer; // ID agendy, kter je nadzen, ze kter se berou hodnoty prv
        fRights : TList<Integer>; // seznam monch prv v dan agend
        fEffectiveRights : TList<Integer>; // seznam skutench prv po naten rol
        fCanShow : boolean; // lze agendu zobrazit
        procedure UpdateMenus (MainMenu : TMainMenu);
      public
        Constructor Create (AAgendaID : integer; AAgendaName : string; AFormClass : TClass;
                            AMainMenuItemName : string; ASubMenuItemName : string; ARights : array of integer;
                            AParentAgendaID : integer; AAgendaText : string; AImageIndex : integer; AEditFormClass : TClass);
        Destructor Destroy; override;
        class function GetRegisteredAgendaName (AAgendaID : integer; AAgendaClass : TClass) : string;
        class function FindRegisteredAgenda (AAgendaID : integer; AAgendaClass : TClass; AAgendaName : string) : TAgendaRights;
        class function FindRegisteredAgendaByEditForm (AEditClass : TClass) : TAgendaRights;
        class procedure UpdateAllMenus (MainMenu : TMainMenu);
        class function AddAgenda(AAgendaID : integer; AAgendaName : string; AFormClass : TClass;
                                  AMainMenuItemName : string; ASubMenuItemName : string; ARights : array of integer;
                                  AParentAgendaID : integer; AAgendaText : string; AImageIndex : integer; AEditFormClass : TClass) : TAgendaRights;
        class function AgendsCount : integer;
        class function AgendaRight (i : integer) : TAgendaRights;
        class function GetRightName (idxRight : integer) : string;
        class function UserCanCreate (EditFormClass : TClass) : boolean;
        class function UserHasRightTo (agendaName : string; functionId : integer) : boolean;
        class procedure RegisterAgenda
               (AgendaId : integer; AgendaName : string; MainMenuItemName, SubMenuItemName : string; Rights : array of integer; EditFormClass : TClass = nil;
                ParentAgendaID : integer = 0; AgendaText : string = ''; ImageIndex : integer = 0);
        property AgendaName : string read fAgendaName;
        property AgendaID : integer read fAgendaID;
        property ParentAgendaID : integer read fParentAgendaID;
        property FormClass : TClass read fFormClass;
        property EditFormClass : TClass read fEditFormClass;
        property MainMenuItem : TMenuItem read fMainMenuItem;
        property SubMenuItem : TMenuItem read fSubMenuItem;
        property ImageIndex : integer read fImageIndex;
        property AgendaText : string read fAgendaText;
        property Rights : TList<integer> read fRights;
        property EffectiveRights : TList<integer> read fEffectiveRights;
        property CanShow : boolean read fCanShow write fCanShow;
    end;

var MainMenuList : TObjectList<TMenuItem>;
var AgendaRightsList : TObjectList<TAgendaRights>;

procedure RegisterMenu (mMenu : TMenuItem);
procedure RegisterNoAureliusAgends;

const
  CAgendaPrijemky = 'Prijemky';
  CAgendaVydejky = 'Vydejky';

const
  Cobjednavky_prijate  = 1;
  Cobjednavky_prijate_polozky  = 2;
  Cstavydokladu  = 3;
  Cobjednavky_prijate_doc  = 4;
  cDodaci_listy = 5;
  cDodaci_listy_polozky = 6;
  cDodaci_listy_doc = 7;
  Czpusob_dopravy = 8;
  Czpusob_platby = 9;
  Cuser_menu = 10;
  Cciselne_rady = 11;
  Cuser_view_settings = 12;
  Csklad_material_pohyb = 13;
  Csklad_material_prijemky_typy = 14;
  Csklad_material_vydejky_typy = 15;
  Crepair_type = 16;
  CPausal = 17;
  Cservis_typ = 18;
  Ccnc_group = 19;
  Cstroj_group = 20;
  Coperation_group = 21;
  Csklad_inventura_typ = 22;
  Csklad_skupiny = 23;
  CMaterialy = 24;
  Ccustomer_skupiny = 25;
  Ccustomer_osoby = 26;
  cep_simulace = 27;
  Ccustomer_adresy = 28;
  Ccustomer_udalosti = 29;
  Ccustomer = 30;
  Cep_collision = 31;
  Cukolmzda_typ = 32;
  Csklad_material_tvar = 33;
  Cuzamcene_obdobi = 34;
  Corder_stav = 35;
  Cdochazka_typy_operaci = 36;
  cep_schedulerresource = 37;
  cep_resource_plan_default = 38;
  Cschedulerresource = 39;
  Csklad_material_Readdata = 40;
  Csklad_material_prijemky = 41;
  Csklad_material_prijemky_doc = 42;
  Csklad_material_vydejky = 43;
  Csklad_material_vydejky_doc = 45;
  Cref_planjednotka_worker = 46;
  Cref_planjednotka_operation = 47;
  Cref_planjednotka_operation_group = 48;
  Cuser_menu_users = 49;
  Cref_ep_planjednotka_worker = 50;
  Cref_ep_planjednotka_operation = 51;
  Cref_ep_planjednotka_operation_group = 52;
  Coperation = 53;
  Cstroje = 54;
  CCNCStroje = 55;
  Cep_config = 56;
  Csklad_inventura = 57;
  Cref_operation_stroj = 58;
  Cref_operation_stroj_group = 59;
  CCidla = 60;
  Ckurz  = 61;
  CSklad_material = 62;
  CSklad_material_ean = 63;
  Csklad_material_dodavatele = 64;
  Csklad_material_doc = 65;
  Cc_order_doc = 66;
  Cobjednavky_doc = 67;
  Cc_order = 68;
  Cobjednavky = 69;
  Cglobal_settings_user_fields = 70;
  Cglobal_settings_user_fields_views = 71;
  Cobjednavky_polozky = 72;
  Cworker_workhours = 73;
  Cworker_skupina = 74;
  Cworker_pozice = 75;
  Cworker_profese = 76;
  Cworker_misto_prace = 77;
  CJednotky = 78;
  Cuser_roles = 79;
  Cref_users_user_roles = 80;
  Cref_user_roles_users = 81;
  Cuser_roles_forbiden_rights = 82;
  Cuser_import_button_settings = 83;
  Cref_operation_group_stroj = 84;
  Cdoc_create_path = 85;
  Cref_operation_group_cnc = 86;
  Cref_stroj_operation = 87;
  Cref_stroj_operation_group = 88;
  Cref_cnc_stroje_operation = 89;
  Cref_cnc_stroje_operation_group = 90;
  Ckurz_meny = 91;
  Cref_operation_worker = 92;
  Cref_operation_cnc = 93;
  Cciselne_rady_doklady_pravidla = 94;

const
  cDLTypPolozkyOrder = 0;
  cDLTypPolozkyText  = 1;
  cDLTypPolozkyPolozkaOP = 2;
  cDLTypPolozkyMaterial = 3;
const
  cTypMatJednoducha = 0;
  cTypMatSluzba = 1;
  cTypMatSada = 2;
  cTypMatKomplet = 3;
  cTypMatVyrobek =4;
  cTypMatNakupMaterial = 5;
  cTypMatNA = 6;
const
  cIACustomer = 1;
  cIAWorker = 2;
  cIASklad = 3;
  cIAOperation = 4;
  cIAOrder = 5;
  cIADodListy = 6;
  cIAPrijemky = 7;
  cIAVydejky = 8;
  cIAObjPrijate = 9;
  cIAObjVydane = 10;

const
  cIATypExe = 0;
  cIATypURL = 1;

const
  cIATypDokumentPath = False;
  cIATypDokumentFile = True;

const
  cOVTypPolozkyMaterial = 0;
  cOVTypPolozkySubdodavky = 1;
  cOVTypPolozkyBezVazby = 2;
  cOVTypPolozkyNaradi = 3;

const
  cDocTypeDOC = 1;
  cDocTypeCSV = 2;
  cDocTypeXLS = 3;
  cDocTypePDF = 4;

const
  cUserFieldTypeINT = 1;
  cUserFieldTypeDECIMAL = 2;
  cUserFieldTypeTINYINT = 3;
  cUserFieldTypeDATE = 4;
  cUserFieldTypeDATETIME = 5;
  cUserFieldTypeVARCHAR = 6;

const
  cWorkerTypeKmenovy = 0;
  cWorkerTypeZamDPP = 1;
  cWorkerTypeStudentPraxe = 2;
  cWorkerTypeStudentDPP = 3;
  cWorkerTypeAgenturni = 4;
  cWorkerTypeExteni = 5;

const
  cKoef_ukol_mzdy_typeZamestnanec = 0;
  cKoef_ukol_mzdy_typeExterni = 1;
  cKoef_ukol_mzdy_typeJine = 2;

const
  cUserTypBezny = 1;
  cUserTypAdmin = 2;
  cUserTypManager = 4;

// konstanty pro prva
const
  cRightNew      = 1;
  cRightEdit     = 2;
  cRightDelete   = 3;
  cRightView     = 4; // volba/nastaveni pohledu
  cRightPrint    = 5;

const
  cRightsAll  : array of integer = [cRightNew,cRightEdit,cRightDelete,cRightView,cRightPrint];

const
  cRightNewText      = 'Zaloit';
  cRightEditText     = 'Editovat (v. hromadn zmny)';
  cRightDeleteText   = 'Smazat';
  cRightViewText     = 'Vbr/Nastaven pohledu'; // volba/nastaveni pohledu
  cRightPrintText    = 'Tisk';

// identifiktory agend
const
  cAgObjednavkyPrijate = 1;
  cAgObjednavkyVydane = 2;
  cAgStroje = 3;
  cAgObjednavkyPrijatePolozky = 4;
  cAgObjednavkyPrijateDokumenty = 5;
  cAgObjednavkyVydanePolozky = 6;
  cAgObjednavkyVydaneDokumenty = 7;
  cAgDodaciListy = 8;
  cAgDodaciListyPolozky = 9;
  cAgDodaciListyDokumenty = 10;
  cAgStrojeOperationGroup = 11;
  cAgStrojeOperation = 12;
  cAgCustomer = 14;
  cAgCustomerZakazky = 15;
  cAgCustomerOsoby = 16;
  cAgCustomerUdalosti = 17;
  cAgCustomerAdresy = 18;
  cAgOperation = 19;
  cAgOperationStroje = 20;
  cAgOperationCNC = 21;
  cAgOperationWorker = 22;
  cAgCNC = 23;
  cAgCNCOperationGroup = 24;
  cAgCNCOperation = 25;
  cAgMonitoringReadData = 26;
  cAgWorker = 27;
  cAgWorkerOperation = 28;
  cAgCidla = 29;
  cAgCidlaReadData = 30;
  cAgSkladMaterial = 31;
  cAgSkladMaterialEAN = 32;
  cAgSkladMaterialAltDodavatele = 33;
  cAgSkladMaterialDoklady = 34;
  cAgSkladMaterialDokumenty = 35;
  cAgSkladMaterialCoef_unit = 36;
  cAgSkladMaterialReadData = 37;
  cAgPrijemky = 38;
  cAgVydejky = 39;
  cAgPrijemkyPolozky = 40;
  cAgVydejkyPolozky = 41;
  cAgPrijemkyDokumenty = 42;
  cAgVydejkyDokumenty = 43;
  cAgInventury = 44;
  cAgInventuryPrijemkaPolozky = 45;
  cAgInventuryVydejkaPolozky = 46;
  cAgInventuryPolozky = 47;
  cAgInventuryPrehled = 48;
  cAgInventuryEvidencniStav = 49;
  cAgPrijemkyPolozkyView = 41;
  cAgVydejkyPolozkyView = 42;
  cAgDodaciListyPolozkyView = 43;
  cAgObjPrijatePolozkyView = 44;
  cAgObjVydanePolozkyView = 45;
  cAgWorkerWorkHours = 46;
  cAgZakazky = 47;
  cAgZakazkySablony = 48;
  cAgNaradi = 49;
  cAgNaradiReadData = 50;
  cAgFormy = 51;
  cAgFormyReadData = 52;
  cagZamestnanciAktStav = 53;
  cagZamestnanciKalendar = 54;
  cagZamestnanciReadData = 55;
  cagZamestnanciGraf = 56;
  cagZamestnanciGrafDenni = 57;
  cagZamestnanciSkoleni = 58;
  cagZamestnanciSkoleniSeznam = 59;
  cAgDochazka = 60;
  cAgDochazkaGraf = 61;
  cAgDochazkaGrafDenni = 62;
  cAgDochazkaPritomnost = 63;
  cAgDochazkaPritomnostGraf = 64;
  cAgDochazkaPritomnostGrafDenni = 65;
  cAgSkladSCM = 66;
  cAgSkladPrepoctyStavu = 67;
  cAgSkladPrepoctyDilu = 68;
  cAgSkladPozice = 69;
  cAgSkladPoziceReadData = 70;
  cAgUkolySeznam = 71;
  cAgMonitoringStroju = 72;
  cAgDochazkaGrafDenniPuv = 73;


// textov id pro nzvy agend
const
  cAgNameObjednavkyPrijate = 'Objednavky_Prijate';
  cAgNameObjednavkyVydane = 'Objednavky_vydane';
  cAgNameStroje = 'Stroje';
  cAgNameObjednavkyPrijatePolozky = 'Objednavky_Prijate_Polozky';
  cAgNameObjednavkyPrijateDokumenty = 'objednavky_prijate_doc';
  cAgNameObjednavkyVydanePolozky = 'Objednavky_Vydane_Polozky';
  cAgNameObjednavkyVydaneDokumenty = 'objednavky_vydane_doc';
  cAgNameDodaciListy = 'Dodaci_Listy';
  cAgNameDodaciListyPolozky = 'Dodaci_Listy_Polozky';
  cAgNameDodaciListyDokumenty = 'dodaci_listy_doc';
  cAgNameStrojeOperationGroup = 'Ref_Stroje_Operation_Group';
  cAgNameStrojeOperation = 'Ref_Stroje_Operation';
  cAgNameCustomer = 'Customer';
  cAgNameCustomerZakazky = 'Customer_Zakazky';
  cAgNameCustomerOsoby = 'Customer_Osoby';
  cAgNameCustomerUdalosti = 'Customer_Udalosti';
  cAgNameCustomerAdresy = 'Customer_Adresy';
  cAgNameOperation = 'Operation';
  cAgNameOperationStroje = 'Ref_Operation_Stroje';
  cAgNameOperationCNC = 'Ref_Operation_CNC';
  cAgNameOperationWorker = 'Ref_Operation_Worker';
  cAgNameCNC = 'CNCStroje';
  cAgNameCNCOperationGroup = 'Ref_CNC_Operation_Group';
  cAgNameCNCOperation = 'Ref_CNC_Operation';
  cAgNameMonitoringReadData = 'Monitoring_readdata';
  cAgNameWorker = 'Worker';
  cAgNameWorkerOperation = 'Ref_Worker_Operation';
  cAgNameCidla = 'Cidla';
  cAgNameCidlaReadData = 'Cidla_read_data';
  cAgNameSkladMaterial = 'SkladMaterialu';
  cAgNameSkladMaterialEAN = 'Sklad_material_EAN';
  cAgNameSkladMaterialAltDodavatele = 'Sklad_material_Alt_dodavatele';
  cAgNameSkladMaterialDoklady = 'DokladySkladoveKarty';
  cAgNameSkladMaterialDokumenty = 'sklad_material_doc';
  cAgNameSkladMaterialCoef_unit = 'Sklad_material_coef_unit';
  cAgNameSkladMaterialReadData = 'Sklad_materialu_readdata';
  cAgNamePrijemky = 'Sklad_material_prijemky';
  cAgNameVydejky = 'Sklad_material_vydejky';
  cAgNamePrijemkyPolozky = 'Sklad_Material_Prijemky_Polozky';
  cAgNameVydejkyPolozky = 'Sklad_Material_Vydejky_Polozky';
  cAgNamePrijemkyDokumenty = 'sklad_material_prijemky_doc';
  cAgNameVydejkyDokumenty = 'sklad_material_vydejky_doc';
  cAgNameInventury = 'Sklad_Inventura';
  cAgNameInventuryPrijemkaPolozky = 'Sklad_Inventura_Prijemka_Polozky';
  cAgNameInventuryVydejkaPolozky = 'Sklad_Inventura_Vydejka_Polozky';
  cAgNameInventuryPolozky = 'Sklad_Inventura_Polozky';
  cAgNameInventuryPrehled = 'Sklad_Inventura_Prehled';
  cAgNameInventuryEvidencniStav = 'Sklad_Inventura_Soupisy';
  cAgNamePrijemkyPolozkyView = 'Sklad_Material_Prijemky_Polozky_View';
  cAgNameVydejkyPolozkyView = 'Sklad_Material_Vydejky_Polozky_View';
  cAgNameDodaciListyPolozkyView = 'Dodaci_listy_Polozky_View';
  cAgNameObjPrijatePolozkyView = 'Objednavky_Prijate_Polozky_View';
  cAgNameObjVydanePolozkyView = 'Objednavky_Polozky_View';
  cAgNameWorkerWorkHours = 'Worker_workhours';
  cAgNameZakazky = 'Zakazky';
  cAgNameZakazkySablony = 'Zakazky_sablony';
  cAgNameNaradi = 'Naradi';
  cAgNameNaradiReadData = 'Naradi_readdata';
  cAgNameFormy = 'Formy';
  cAgNameFormyReadData = 'Formy_readdata';
  cAgNameZamestnanciAktStav = 'Zamestnanci_AktStav';
  cAgNameZamestnanciKalendar = 'Zamestnanci_Kalendar';
  cAgNameZamestnanciReadData = 'Zamestnanci_Readdata';
  cAgNameZamestnanciGraf = 'Zamestnanci_Graf';
  cAgNameZamestnanciGrafDenni = 'Zamestnanci_Graf_Denni';
  cAgNameZamestnanciSkoleni = 'Zamestnanci_Skoleni';
  cAgNameZamestnanciSkoleniSeznam = 'Zamestnanci_Skoleni_Seznam';
  cAgNameDochazka = 'Dochazka';
  cAgNameDochazkaGraf = 'Dochazka_graf';
  cAgNameDochazkaGrafDenni = 'Dochazka_graf_Denni';
  cAgNameDochazkaPritomnost = 'Dochazka_Pritomnost';
  cAgNameDochazkaPritomnostGraf = 'Dochazka_Pritomnost_graf';
  cAgNameDochazkaPritomnostGrafDenni = 'Dochazka_Pritomnost_Graf_denni';
  cAgNameSkladSCM = 'Sklad';
  cAgNameSkladPrepoctyStavu = 'Sklad_Prepocty_stavu';
  cAgNameSkladPrepoctyDilu = 'Sklad_Prepocty_dilu';
  cAgNameSkladPozice = 'Sklad_Pozice';
  cAgNameSkladPoziceReadData = 'Sklad_Pozice_readData';
  cAgNameUkolySeznam = 'Ukoly_seznam';
  cAgNameMonitoringStroju = 'Monitoring_stroje';
  cAgNameDochazkaGrafDenniPuv = 'Dochazka_graf_Denni_Puv';

implementation

uses  System.SysUtils;


{ tTabulka }

constructor tTabulka.create(const aKey, aValue, aTableName, aFieldName: string;
  aCaption: String = '';  aIsDoklad : boolean = False; aNeedsTypDokladu : integer = 0);
begin
  Key := aKey;
  Value := stringReplace(aValue, '&', '', [rfReplaceALL]);
  TableName := aTableName;
  FieldName := aFieldName;
  if aCaption <> '' then
    Caption := aCaption
  else
    Caption := aValue;
  IsDoklad := aIsDoklad;
  NeedsTypDokladu := aNeedsTypDokladu;
end;

procedure tTabulka.SetDestDoklady (aDestDoklady : array of string);
begin
  DestDoklady := TList<string>.Create(aDestDoklady);
end;

destructor tTabulka.Destroy;
begin
  if DestDoklady <> nil then DestDoklady.Free;  
end;


{ TAureliusDict }

constructor TAureliusDict.create;
begin
  VytvorTabulkyStavyDokladu;
  VytvorTabulkyCiselneRady;
  VytvorMyDict;
  VytvorMyDictUserFieldsType;
end;

destructor TAureliusDict.destroy;
begin
  MyDict.Free;
  MyDictUserFieldsType.Free;
  TabulkyStavyDokladu.Free;
  TabulkyCiselneRady.Free;

  inherited;
end;

function TAureliusDict.GetClassConst(aClassName: String): Integer;
begin
  Result := -1;
  MyDict.TryGetValue(aClassName, Result);
end;

function TAureliusDict.GetTabulkyIdx(aKey: String;
  Tabulka: TObjectList<tTabulka>): Integer;
Var
  i : Integer;
begin
  Result := -1;
  for I := 0 to  Tabulka.Count - 1 do
    if SameText(Tabulka[i].Key, aKey) then
      begin
        Result := i;
        Break;
      end;
  assert(Result >= 0, 'Neznm tabulka');
end;

function TAureliusDict.GetUserFieldType(aType: String): Integer;
begin
  Result := -1;
  MyDictUserFieldsType.TryGetValue(aType, Result);
end;

procedure TAureliusDict.VytvorMyDict;
begin
  MyDict := TDictionary<string, integer>.Create;

  MyDict.Add('Tobjednavky_prijate', Cobjednavky_prijate);
  MyDict.Add('Tobjednavky_prijate_polozky', Cobjednavky_prijate_Polozky);
  MyDict.Add('Tstavydokladu', Cstavydokladu);
  MyDict.Add('Tobjednavky_prijate_doc', Cobjednavky_prijate_doc);
  MyDict.Add('Tdodaci_listy', Cdodaci_listy);
  MyDict.Add('Tdodaci_listy_polozky', Cdodaci_listy_Polozky);
  MyDict.Add('Tdodaci_listy_doc', Cdodaci_listy_doc);
  MyDict.Add('Tzpusob_dopravy', Czpusob_dopravy);
  MyDict.Add('Tzpusob_platby', Czpusob_platby);
  MyDict.Add('Tuser_menu', Cuser_menu);
  MyDict.Add('Tciselne_rady', Cciselne_rady);
  MyDict.Add('Tuser_view_settings', Cuser_view_settings);
  MyDict.Add('Tsklad_material_pohyb', Csklad_material_pohyb);
  MyDict.Add('Tsklad_material_prijemky_typy', Csklad_material_prijemky_typy);
  MyDict.Add('Tsklad_material_vydejky_typy', Csklad_material_vydejky_typy);
  MyDict.Add('Trepair_type', Crepair_type);
  MyDict.Add('Tpausal', Cpausal);
  MyDict.Add('Tservis_typ', Cservis_typ);
  MyDict.Add('Tcnc_group', Ccnc_group);
  MyDict.Add('Tstroj_group', Cstroj_group);
  MyDict.Add('Toperation_group', Coperation_group);
  MyDict.Add('Tsklad_inventura_typ', Csklad_inventura_typ);
  MyDict.Add('Tsklad_inventura', Csklad_inventura);
  MyDict.Add('Tsklad_skupiny', Csklad_skupiny);
  MyDict.Add('Tmaterialy', CMaterialy);
  MyDict.Add('Tcustomer_skupiny', Ccustomer_skupiny);
  MyDict.Add('Tcustomer_osoby', Ccustomer_osoby);
  MyDict.Add('Tep_simulace', Cep_simulace);
  MyDict.Add('Tcustomer_adresy', Ccustomer_adresy);
  MyDict.Add('Tcustomer_udalosti', Ccustomer_udalosti);
  MyDict.Add('Tcustomer', Ccustomer);
  MyDict.Add('Tep_collision', Cep_collision);
  MyDict.Add('Tukolmzda_typ', Cukolmzda_typ);
  MyDict.Add('Tsklad_material_tvar', Csklad_material_tvar);
  MyDict.Add('Tuzamcene_obdobi', Cuzamcene_obdobi);
  MyDict.Add('Torder_stav', Corder_stav);
  MyDict.Add('Tdochazka_typy_operaci', Cdochazka_typy_operaci);
  MyDict.Add('Tep_schedulerresource', cep_schedulerresource);
  MyDict.Add('Tep_resource_plan_default', cep_resource_plan_default);
  MyDict.Add('Tschedulerresource', CschedulerResource);
  MyDict.Add('Tsklad_material_readdata', Csklad_material_readdata);
  MyDict.Add('Tsklad_material_prijemky', Csklad_material_prijemky);
  MyDict.Add('Tsklad_material_prijemky_doc', Csklad_material_prijemky_doc);
  MyDict.Add('Tsklad_material_vydejky', Csklad_material_vydejky);
  MyDict.Add('Tsklad_material_vydejky_doc', Csklad_material_vydejky_doc);
  MyDict.Add('Tref_planjednotka_worker', Cref_planjednotka_worker);
  MyDict.Add('Tref_planjednotka_operation', Cref_planjednotka_operation);
  MyDict.Add('Tref_planjednotka_operation_group', Cref_planjednotka_operation_group);
  MyDict.Add('Tuser_menu_users', Cuser_menu_users);
  MyDict.Add('Tref_ep_planjednotka_worker', Cref_ep_planjednotka_worker);
  MyDict.Add('Tref_ep_planjednotka_operation', Cref_ep_planjednotka_operation);
  MyDict.Add('Tref_ep_planjednotka_operation_group', Cref_ep_planjednotka_operation_group);
  MyDict.Add('Toperation', Coperation);
  MyDict.Add('Tstroje', Cstroje);
  MyDict.Add('Tworker', CCNCSTroje);
  MyDict.Add('Tep_config', Cep_config);
  MyDict.Add('Tref_operation_stroj', Cref_operation_stroj);
  MyDict.Add('Tref_operation_stroj_group', Cref_operation_stroj_group);
  MyDict.Add('Tcidla', CCidla);
  MyDict.Add('Tkurz', Ckurz);
  MyDict.Add('Tsklad_material', CSklad_material);
  MyDict.Add('Tsklad_material_ean', CSklad_material_ean);
  MyDict.Add('Tsklad_material_dodavatele', Csklad_material_dodavatele);
  MyDict.Add('Tsklad_material_doc', Csklad_material_doc);
  MyDict.Add('Tc_order_doc', Cc_order_doc);
  MyDict.Add('Tobjednavky_doc', Cobjednavky_doc);
  MyDict.Add('Tc_order', Cc_order);
  MyDict.Add('Tobjednavky', Cobjednavky);
  MyDict.Add('Tglobal_settings_user_fields', Cglobal_settings_user_fields);
  MyDict.Add('Tglobal_settings_user_fields_views', Cglobal_settings_user_fields_views);
  MyDict.Add('Tobjednavky_polozky', Cobjednavky_polozky);
  MyDict.Add('Tworker_workhours', Cworker_workhours);
  MyDict.Add('Tworker_skupina', Cworker_skupina);
  MyDict.Add('Tworker_pozice', Cworker_pozice);
  MyDict.Add('Tworker_profese', Cworker_profese);
  MyDict.Add('Tworker_misto_prace', Cworker_misto_prace);
  MyDict.Add('Tjednotky', Cjednotky);
  MyDict.Add('Tuser_roles', Cuser_roles);
  MyDict.Add('Tref_users_user_roles', Cref_users_user_roles);
  MyDict.Add('Tref_user_roles_users', Cref_user_roles_users);
  MyDict.Add('Tuser_roles_forbiden_rights', Cuser_roles_forbiden_rights);
  MyDict.Add('Tuser_import_button_settings', Cuser_import_button_settings);
  MyDict.Add('Tref_operation_group_stroj', Cref_operation_group_stroj);
  MyDict.Add('Tdoc_create_path', Cdoc_create_path);
  MyDict.Add('Tref_operation_group_cnc', Cref_operation_group_cnc);
  MyDict.Add('Tref_stroj_operation', Cref_stroj_operation);
  MyDict.Add('Tref_stroj_operation_group', Cref_stroj_operation_group);
  MyDict.Add('Tref_cnc_stroje_operation', Cref_cnc_stroje_operation);
  MyDict.Add('Tref_cnc_stroje_operation_group', Cref_cnc_stroje_operation_group);
  MyDict.Add('Tkurz_meny', Ckurz_meny);
  MyDict.Add('Tref_operation_worker', Cref_operation_worker);
  MyDict.Add('Tref_operation_cnc', Cref_operation_cnc);
  MyDict.Add('Tciselne_rady_doklady_pravidla', Cciselne_rady_doklady_pravidla);

end;

procedure TAureliusDict.VytvorMyDictUserFieldsType;
begin
  MyDictUserFieldsType := TDictionary<string, integer>.Create;

  MyDictUserFieldsType.Add('INT', cUserFieldTypeINT);
  MyDictUserFieldsType.Add('DECIMAL', cUserFieldTypeDECIMAL);
  MyDictUserFieldsType.Add('TINYINT', cUserFieldTypeTINYINT);
  MyDictUserFieldsType.Add('DATE', cUserFieldTypeDATE);
  MyDictUserFieldsType.Add('DATETIME', cUserFieldTypeDATETIME);
  MyDictUserFieldsType.Add('VARCHAR', cUserFieldTypeVARCHAR);

end;

procedure TAureliusDict.VytvorTabulkyCiselneRady;
var
   idx : integer;
begin
  TabulkyCiselneRady := TObjectList<tTabulka>.Create;
  TabulkyCiselneRady.OwnsObjects := True;

  idx := TabulkyCiselneRady.Add(tTabulka.Create('Zakazky', 'Zakzky', 'c_order', 'ciselna_rada_id','',True));
  TabulkyCiselneRady[idx].SetDestDoklady(['Prijemky','Vydejky','Dodaci listy']);

  idx := TabulkyCiselneRady.Add(tTabulka.Create('Objednavky', 'Objednvky', 'objednavky','ciselna_rada_id', 'Objednvky vydan',True));
  TabulkyCiselneRady[idx].SetDestDoklady(['Prijemky']);

  idx := TabulkyCiselneRady.Add(tTabulka.Create('Objednavky prijate', 'Objednvky pijat', 'objednavky_prijate', 'ciselna_rada_id','',True));
  TabulkyCiselneRady[idx].SetDestDoklady(['Dodaci listy','Zakazky']);

  idx := TabulkyCiselneRady.Add(tTabulka.Create('Dodaci listy', 'Dodac listy', 'dodaci_listy', 'ciselna_rada_id', '',True));
  TabulkyCiselneRady[idx].SetDestDoklady(['Vydejky']);

  TabulkyCiselneRady.Add(tTabulka.Create('Prijemky', 'Pjemky', 'sklad_material_prijemky', 'ciselna_rada_id', '',False,1));
  TabulkyCiselneRady.Add(tTabulka.Create('Vydejky', 'Vdejky', 'sklad_material_vydejky', 'ciselna_rada_id', '',False,2));
  TabulkyCiselneRady.Add(tTabulka.Create('Sklad materialu', 'Sklad materilu', 'sklad_material', 'ciselna_rada_id'));
  TabulkyCiselneRady.Add(tTabulka.Create('Zakaznici', 'Zkaznci', 'customer', 'ciselna_rada_id'));
  TabulkyCiselneRady.Add(tTabulka.Create('Operace', 'Operace', 'operation', 'ciselna_rada_id'));
  TabulkyCiselneRady.Add(tTabulka.Create('Faktury', 'Faktury', 'faktury', ''));
  { MH 2025-01-30, #17043
  TabulkyCiselneRady.Add(tTabulka.Create('Vykres', 'Vkres', '', ''));
  TabulkyCiselneRady.Add(tTabulka.Create('Vyrobni prikaz', 'Vrobn pkaz', '', ''));}
  TabulkyCiselneRady.Add(tTabulka.Create('Inventury', 'Inventury', 'sklad_inventura', ''));
  TabulkyCiselneRady.Add(tTabulka.Create('Naradi sledovane', 'Nad sledovan', '', ''));
  TabulkyCiselneRady.Add(tTabulka.Create('Naradi spotrebni', 'Nad spotebn', '', ''));
  TabulkyCiselneRady.Add(tTabulka.Create('Seriova cis. zakazek', 'Sriov sla zakzek', '', ''));
    { MH 2025-01-30, #17045 }
  TabulkyCiselneRady.Add(tTabulka.Create('Zamestnanci', 'Zamstnanci', 'worker', ''));
  TabulkyCiselneRady.Add(tTabulka.Create('CNC Stroje', 'CNC Stroje', 'worker', 'ciselna_rada_id'));
end;

procedure TAureliusDict.VytvorTabulkyStavyDokladu;
begin
  TabulkyStavyDokladu := TObjectList<tTabulka>.Create;
  TabulkyStavyDokladu.OwnsObjects := True;
  TabulkyStavyDokladu.Add(tTabulka.Create('sklad_inventura', 'Inventura', 'sklad_inventura', 'stav'));
  TabulkyStavyDokladu.Add(tTabulka.Create('sklad_material_prijemky','Pjemky', 'sklad_material_prijemky', 'stavdokladu'));
  TabulkyStavyDokladu.Add(tTabulka.Create('sklad_material_vydejky', 'Vdejky', 'sklad_material_vydejky', 'stavdokladu'));
  TabulkyStavyDokladu.Add(tTabulka.Create('objednavky', 'Objednvky', 'objednavky', 'stavdokladu'));
  TabulkyStavyDokladu.Add(tTabulka.Create('objednavky_prijate', 'Objednvky pijat', 'objednavky_prijate', 'stavdokladu'));
  TabulkyStavyDokladu.Add(tTabulka.Create('dodaci_listy', 'Dodac listy', 'dodaci_listy', 'stavdokladu'));
end;

{ TAgendaRights }

Constructor TAgendaRights.Create (AAgendaID : integer; AAgendaName : string; AFormClass : TClass;
                                  AMainMenuItemName : string; ASubMenuItemName : string; ARights : array of integer;
                                  AParentAgendaID : integer; AAgendaText : string; AImageIndex : integer; AEditFormClass : TClass);
begin
  fRights := TList<integer>.Create;
  fRights.AddRange(ARights);
  fAgendaID := AAgendaID;
  fParentAgendaID := AParentAgendaID;
  fAgendaName := AAgendaName;
  fFormClass := AFormClass;
  fEditFormClass := AEditFormClass;
  fMainMenuItemName := AMainMenuItemName;
  fSubMenuItemName := ASubMenuItemName;
  fAgendaText := AAgendaText;
  fImageIndex := AImageIndex;
  fEffectiveRights := TList<integer>.Create;
  fCanShow := True;
end;

Destructor TAgendaRights.Destroy;
begin
  Rights.Free;
  EffectiveRights.Free;
end;


class function TAgendaRights.GetRegisteredAgendaName (AAgendaID : integer; AAgendaClass : TClass) : string;
var
   AgendaRights : TAgendaRights;
begin
  Result := '';
  AgendaRights := FindRegisteredAgenda (AAgendaID, AAgendaClass,'');
  if AgendaRights <> nil then
        Result := AgendaRights.AgendaName;
end;

class function TAgendaRights.FindRegisteredAgenda (AAgendaID : integer; AAgendaClass : TClass; AAgendaName : string) : TAgendaRights;
begin
  Result := nil;
  for var i := 0 to AgendaRightsList.Count -1 do
    if (AAgendaID <> 0) and (AgendaRightsList[i].AgendaID = AAgendaID) or
       (AAgendaClass <> nil) and (AgendaRightsList[i].FormClass = AAgendaClass) or
       (AAgendaName <> '') and SameText(AgendaRightsList[i].AgendaName,AAgendaName)
    then
      begin
        Result := AgendaRightsList[i];
        exit;
      end;
end;

class function TAgendaRights.FindRegisteredAgendaByEditForm (AEditClass : TClass) : TAgendaRights;
begin
  Result := nil;
  for var i := 0 to AgendaRightsList.Count -1 do
    if AgendaRightsList[i].EditFormClass = AEditClass then
      begin
        Result := AgendaRightsList[i];
        exit;
      end;
end;

procedure TAgendaRights.UpdateMenus (MainMenu : TMainMenu);
begin
  fMainMenuItem := MainMenu.Owner.FindComponent(fMainMenuItemName) as TMenuItem;
  fSubMenuItem := MainMenu.Owner.FindComponent(fSubMenuItemName) as TMenuItem;
  assert( not ( (fMainMenuItem <> nil) and (fSubMenuItem = nil)),'Chyba v definici menu '+fSubmenuItemName);
end;


class procedure TagendaRights.UpdateAllMenus (MainMenu : TMainMenu);
begin
  for var i := 0 to AgendaRightsList.Count -1 do
    AgendaRightsList[i].UpdateMenus(MainMenu)
end;

class function TAgendaRights.AddAgenda(AAgendaID : integer; AAgendaName : string; AFormClass : TClass;
                                  AMainMenuItemName : string; ASubMenuItemName : string; ARights : array of integer;
                                  AParentAgendaID : integer; AAgendaText : string; AImageIndex : integer; AEditFormClass : TClass) : TAgendaRights;
begin
  var Idx := AgendaRightsList.Add(TAgendaRights.Create(AAgendaID,AAgendaName,AFormClass,
                       AMainMenuItemName,ASubMenuItemName,ARights,AParentAgendaID,AAgendaText,AImageIndex,AEditFormClass));
  Result := AgendaRightsList[idx];
end;

class function TAgendaRights.AgendsCount : integer;
begin
  Result := AgendaRightsList.Count;
end;

class function TAgendaRights.AgendaRight (i : integer) : TAgendaRights;
begin
  Result := AgendaRightsList[i];
end;

class function TAgendaRights.GetRightName (idxRight : integer) : string;
begin
  case idxRight of
    cRightNew      : Result := cRightNewText;
    cRightEdit     : Result := cRightEditText;
    cRightDelete   : Result := cRightDeleteText;
    cRightView     : Result := cRightViewText; // volba/nastaveni pohledu
    cRightPrint    : Result := cRightPrintText;
    else Result := '';
  end;
end;


class function TAgendaRights.UserHasRightTo (agendaName : string; functionId : integer) : boolean;
var
   AgendaRights : TAgendaRights;
begin
  // v siutaci, kdy jsou prva pro uivatele u naten.
  Result := True;
  AgendaRights := TAgendaRights.FindRegisteredAgenda(0,nil,agendaName);
  if AgendaRights <> nil then
  begin
    if functionId = 0 then
       Result := AgendaRights.CanShow
    else
       Result := AgendaRights.EffectiveRights.IndexOf(functionID) <> -1;
  end;
end;

class function TAgendaRights.UserCanCreate (EditFormClass : TClass) : boolean;
var
   AgendaRights : TAgendaRights;
   AgendaName : string;
begin
  Result := True;
  AgendaRights := TAgendaRights.FindRegisteredAgendaByEditForm(EditFormClass);
  if AgendaRights <> nil then
  begin
    Result := UserHasRightTo(AgendaRights.AgendaName,0) and
              UserHasRightTo(AgendaRights.AgendaName,cRightNew);
  end;

end;

class procedure TagendaRights.RegisterAgenda
               (AgendaId : integer; AgendaName : string; MainMenuItemName, SubMenuItemName : string; Rights : array of integer; EditFormClass : TClass = nil;
                ParentAgendaID : integer = 0; AgendaText : string = ''; ImageIndex : integer = 0);
begin
  AddAgenda(AgendaId,AgendaName,self,MainMenuItemName,SUbMenuItemName,Rights,ParentAgendaID,AgendaText,ImageIndex,EditFormClass);
end;

procedure RegisterMenu (mMenu : TMenuItem);
begin
  MainMenuList.Add(mMenu);
end;

procedure RegisterNoAureliusAgends;
begin
  TAgendaRights.RegisterAgenda(cAgZakazky,cAgNameZakazky,'mmZakazky','miSeznamZakazek',[]);
  TAgendaRights.RegisterAgenda(cAgZakazkySablony,cAgNameZakazkySablony,'mmZakazky','miSablony',[]);
  TAgendaRights.RegisterAgenda(cAgNaradi,cAgNameNaradi,'mmTPV','miNaradi',[]);
  TAgendaRights.RegisterAgenda(cAgNaradiReadData,cAgNameNaradiReadData,'mmTPV','miNaradiNactenaData',[]);
  TAgendaRights.RegisterAgenda(cAgFormy,cAgNameFormy,'mmTPV','miFormy',[]);
  TAgendaRights.RegisterAgenda(cAgFormyReadData,cAgNameFormyReadData,'mmTPV','miFormyNactenaData',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciAktStav,cAgNameZamestnanciAktStav,'mmZamestnanci','miZamestnanciAKtualniStav2',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciKalendar,cAgNameZamestnanciKalendar,'mmZamestnanci','miPlanovaciKalendar',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciReadData,cAgNameZamestnanciReadData,'mmZamestnanci','miZamestnanciNactenaData',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciGraf,cAgNameZamestnanciGraf,'mmZamestnanci','miGrafickyPrehledOP',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciGrafDenni,cAgNameZamestnanciGrafDenni,'mmZamestnanci','miGrafickyPrehledOPDen',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciSkoleni,cAgNameZamestnanciSkoleni,'mmZamestnanci','miZamestnanciProskoleni',[]);
  TAgendaRights.RegisterAgenda(cAgZamestnanciSkoleniSeznam,cAgNameZamestnanciSkoleniSeznam,'mmZamestnanci','miProskoleniSeznam',[]);
  TAgendaRights.RegisterAgenda(cAgDochazka,cAgNameDochazka,'mmDochazka','miDochazka',[]);
  TAgendaRights.RegisterAgenda(cAgDochazkaGraf,cAgNameDochazkaGraf,'mmDochazka','miGrafickyPrehled',[]);
  TAgendaRights.RegisterAgenda(cAgDochazkaGrafDenni,cAgNameDochazkaGrafDenni,'mmDochazka','miGrafickyPrehledDenni',[]);
  TAgendaRights.RegisterAgenda(cAgDochazkaPritomnost,cAgNameDochazkaPritomnost,'mmDochazka','miEvidencePritomnosti',[]);
  TAgendaRights.RegisterAgenda(cAgDochazkaPritomnostGraf,cAgNameDochazkaPritomnostGraf ,'mmDochazka','miGrafickyPrehledEvidencePritomnosti',[]);
  TAgendaRights.RegisterAgenda(cAgDochazkaPritomnostGrafDenni,cAgNameDochazkaPritomnostGrafDenni,'mmDochazka','miGrafickyPrehledEvidencePritomnostiDenni',[]);
  TAgendaRights.RegisterAgenda(cAgSkladSCM,cAgNameSkladSCM,'mmSkladMaterialu','miSCM',[]);
  TAgendaRights.RegisterAgenda(cAgSkladPrepoctyStavu,cAgNameSkladPrepoctyStavu,'mmSkladMaterialu','miPrepoctyStavuSkladu',[]);
  TAgendaRights.RegisterAgenda(cAgSkladPrepoctyDilu,cAgNameSkladPrepoctyDilu,'mmSkladMaterialu','miPrepoctyVyrabenychDilu',[]);
  TAgendaRights.RegisterAgenda(cAgSkladPozice,cAgNameSkladPozice,'mmSkladMaterialu','miSkladovePozice',[]);
  TAgendaRights.RegisterAgenda(cAgSkladPoziceReadData,cAgNameSkladPoziceReadData,'mmSkladMaterialu','miSkladPoziceNactenaData',[]);
  TAgendaRights.RegisterAgenda(cAgUkolySeznam,cAgNameUkolySeznam,'mmUkoly','miUkoly',[]);
  TAgendaRights.RegisterAgenda(cAgDochazkaGrafDenniPuv,cAgNameDochazkaGrafDenniPuv,'mmDochazka','miGrafickyPrehledEvidencePritomnostiPuv',[]);
  TAgendaRights.RegisterAgenda(cAgMonitoringStroju,cAgNameMonitoringStroju,'mmStroje','miMonitoringStroju',[]);

end;

initialization
  AureliusDict := TAureliusDict.Create;
  AgendaRightsList := TObjectList<TAgendaRights>.Create;
  MainMenuList := TObjectList<TMenuItem>.Create(False);

finalization
  AureliusDict.Free;
  AgendaRightsList.Free;
  MainMenuList.Free;

end.