unit eMISTRDataModel;

interface

uses
  SysUtils,
  Generics.Collections,
  Aurelius.Mapping.Attributes,
  Aurelius.Mapping.Explorer,
  Aurelius.Mapping.Metadata,
  System.rtti,
  Aurelius.Types.Blob,
  Aurelius.Types.DynamicProperties,
  Aurelius.Types.Nullable,
  Aurelius.Types.Proxy,
  {$IFNDEF ETMSTEST}
    uTMSAGObject,
  {$ENDIF}
  Aurelius.Comp.Manager,
  Aurelius.Linq,
  System.Classes, System.Variants,
  Xdata.Model.Attributes,
  Bcl.Json.Attributes;

Const
  CascadeTypeNone = [];

function _GetDocType (isFile : boolean) : string;
function _GetExtensionType (path : string) : integer;

type
  Taktualni_stav = class;
  Taktualni_stav_details = class;
  Tauto_login = class;
  Tcalc = class;
  Tcalendar = class;
  Tcalendar_day = class;
  Tcidla = class;
  Tcidla_readdata = class;
  Tciselne_rady = class;
  Tcis_den = class;
  Tcis_frekvence = class;
  Tcis_pozice = class;
  Tcis_pracovni_skupina = class;
  Tcis_typ_provoz = class;
  Tcis_typ_smeny = class;
  Tcnc_group = class;
  Tcnc_import_casu = class;
  Tcolors = class;
  Tcolumns = class;
  Tcolumns_backup = class;
  Tcolumns_caption = class;
  Tcolumns_change_type = class;
  Tcolumns_log = class;
  Tconfig = class;
  Tcustomer = class;
  Tcustomer_adresy = class;
  Tcustomer_osoby = class;
  Tcustomer_skupiny = class;
  Tcustomer_udalosti = class;
  Tcustomer_udalosti_typy = class;
  Tc_order = class;
  Tc_order_calc = class;
  Tc_order_doc = class;
  Tc_order_parameters = class;
  Tc_order_parameters_def = class;
  Tdatum = class;
  Tdochazka = class;
  Tdochazka_mirror = class;
  Tdochazka_note = class;
  Tdochazka_typy_operaci = class;
  Tdochazka_verze = class;
  Tdodaci_listy = class;
  Tdodaci_listy_doc = class;
  Tdodaci_listy_polozky = class;
  Tdodaci_listy_zauctovano = class;
  Tdoklady_status_log = class;
  Tep_collision = class;
  Tep_config = class;
  Tep_resource_plan = class;
  Tep_resource_plan_default = class;
  Tep_resource_plan_typ = class;
  Tep_schedulerresource = class;
  Tep_simulace = class;
  Tep_simulace_c_order = class;
  Tep_simulace_order_work = class;
  Tep_typ_planu = class;
  Tfaktury = class;
  Tformy_skupina = class;
  Tform_caption_hook = class;
  Tgdpr_fields = class;
  Tgdpr_logs = class;
  Tgdpr_settings = class;
  Tglobal_settings = class;
  Tglobal_settings_global_fields = class;
  Tglobal_settings_user_fields = class;
  Thnizda = class;
  Thnizda_logins = class;
  Tinet_filters = class;
  Tjednotky = class;
  Tkraticka = class;
  Tkurz = class;
  Tkurz_meny = class;
  Tlog = class;
  Tmaterial = class;
  Tmaterialy = class;
  Tmaterial_predpokladany = class;
  Tmonitoring_readdata = class;
  Tmonitoring_senzory = class;
  Tmonitoring_senzory_typy = class;
  Tmonitoring_senzory_typy_parametry = class;
  Tmonitoring_stroje = class;
  Tnabidka_polozky = class;
  Tnaradi_skupina = class;
  Tnotifications = class;
  Tobjednavky = class;
  Tobjednavky_doc = class;
  Tobjednavky_polozky = class;
  Tobjednavky_prijate = class;
  Tobjednavky_prijate_doc = class;
  Tobjednavky_prijate_polozky = class;
  Toperation = class;
  Toperation_default = class;
  Toperation_group = class;
  Torder_calc_list = class;
  Torder_filter = class;
  Torder_priority_font = class;
  Torder_stav = class;
  Torder_urovne = class;
  Torder_work = class;
  Torder_work_plan = class;
  Tpackages = class;
  Tpausal = class;
  Tplan_group_smeny = class;
  Tplan_misto_prace = class;
  Tplan_na_den = class;
  Tplan_smena = class;
  Tplan_smena_na_den = class;
  Tplan_smena_skupina = class;
  Tplan_standardni_smena = class;
  Tplan_worker = class;
  Tplan_worker_skupina = class;
  Tpozice = class;
  Tprohlidky_stroje = class;
  Tpruv_list = class;
  Treaddata = class;
  Treaddata_ceny = class;
  Treaddata_doc = class;
  Treaddata_foto = class;
  Treaddata_stroj = class;
  Treader = class;
  Tref_operation_cnc = class;
  Tref_operation_worker = class;
  Tref_worker_operation = class;
  Tref_planjednotka_operation = class;
  Tref_planjednotka_operation_group = class;
  Tref_ep_planjednotka_operation_group = class;
  Tref_planjednotka_worker = class;
  Tref_ep_planjednotka_worker = class;
  Tref_ep_planjednotka_cnc = class;
  Tref_ep_planjednotka_operation = class;
  Tref_user_orderstav = class;
  Tref_user_ordertyp = class;
  Tref_users_user_roles = class;
  Tref_worker_cnc = class;
  Tref_worker_group = class;
  Tregistrace = class;
  Trepair_type = class;
  Tsablony_operation_group = class;
  Tsablony_sklad_group = class;
  TSCHEDULEREXCEPTION = class;
  Tschedulerresource = class;
  Tschedulertable = class;
  Tscript = class;
  Tserial_code = class;
  Tservis_typ = class;
  Tservis_typ_ref_stroje = class;
  Tsklady_materialu = class;
  Tsklad_formy = class;
  Tsklad_formy_pohyb = class;
  Tsklad_formy_readdata = class;
  Tsklad_inventura = class;
  Tsklad_inventura_log = class;
  Tsklad_inventura_polozky = class;
  Tsklad_inventura_soupisy = class;
  Tsklad_inventura_typ = class;
  Tsklad_material = class;
  Tsklad_material_ceniky = class;
  Tsklad_material_ceniky_polozky = class;
  Tsklad_material_coef_unit = class;
  Tsklad_material_doc = class;
  Tsklad_material_dodavatele = class;
  Tsklad_material_ean = class;
  Tsklad_material_pohyb = class;
  Tsklad_material_pozice = class;
  Tsklad_material_pozice_readdata = class;
  Tsklad_material_prijemky = class;
  Tsklad_material_prijemky_typy = class;
  Tsklad_material_prijemky_doc = class;
  Tsklad_material_readdata = class;
  Tsklad_material_tvar = class;
  Tsklad_material_vydejky = class;
  Tsklad_material_vydejky_typy = class;
  Tsklad_material_vydejky_doc = class;
  Tsklad_naradi = class;
  Tsklad_naradi_pohyb = class;
  Tsklad_naradi_readdata = class;
  Tsklad_naradi_stav = class;
  Tsklad_skupiny = class;
  Tsp_log = class;
  Tsp_settings = class;
  Tstavydokladu = class;
  Tstroje = class;
  Tstroje_stavy = class;
  Tstroj_group = class;
  Tsubdodavky = class;
  Tswterm_rozdel = class;
  Tsw_term = class;
  Tsystem = class;
  Tsystem_terminals = class;
  Tsystem_terminals_functions = class;
  Ttech_postup = class;
  Ttech_postup_polozky = class;
  Ttemp = class;
  Ttemp2 = class;
  Tterminal = class;
  Tterminal_typ = class;
  Ttisk_formulare = class;
  Ttisk_hlavicka = class;
  Ttisk_hlavicka_nazvy = class;
  Ttisk_prava = class;
  Ttyp_baleni = class;
  Ttyp_zasilky = class;
  Tukolmzda_typ = class;
  Tukoly = class;
  Tukoly_opakovani = class;
  Tukoly_podminky = class;
  Tukoly_stavy = class;
  Tuserlist = class;
  Tusers = class;
  Tuser_default_view_settings = class;
  Tuser_filter_settings = class;
  Tuser_menu = class;
  Tuser_menu_users = class;
  Tuser_print_settings = class;
  Tuser_roles = class;
  Tuser_roles_forbiden_rights = class;
  Tuser_settings = class;
  Tuser_settings_user_fields = class;
  Tuser_view_settings = class;
  Tuzamcene_obdobi = class;
  Tuzavreni_zakazek = class;
  Tvyrobni_calc = class;
  Tvyrobni_calc_material = class;
  Tworker = class;
  Tworker_cidla = class;
  Tworker_foto = class;
  Tworker_functions = class;
  Tworker_group = class;
  Tworker_pracovni_rezim = class;
  Tworker_prava = class;
  Tworker_prava_prirazeno = class;
  Tworker_prescasy = class;
  Tworker_prescasy_dochazka = class;
  Tworker_prescasy_prevod = class;
  Tworker_proskoleni = class;
  Tworker_proskoleni_druh = class;
  Tworker_proskoleni_readdata = class;
  Tworker_proskoleni_typ = class;
  Tworker_role = class;
  Tworker_smeny = class;
  Tworker_smeny_sablony = class;
  Tworker_smeny_sablony_smeny = class;
  Tworker_svatky = class;
  Tworker_workhours = class;
  Tzakazky_objednavky = class;
  Tzpusob_dopravy = class;
  Tzpusob_platby = class;
  Tref_operation_stroj = class;
  Tref_operation_group_stroj = class;
  Tref_operation_group_cnc = class;
  Tref_stroj_operation = class;
  Tref_stroj_operation_group = class;
  Tuser_import_button_settings = class;
  Tglobal_settings_user_fields_views = class;
  Tworker_skupina = class;
  Tworker_pozice = class;
  Tworker_profese = class;
  Tworker_misto_prace = class;
  Tcnc_stroje = class;
  Tref_cnc_stroje_operation = class;
  Tref_cnc_stroje_operation_group = class;
  Tciselne_rady_doklady_pravidla = class;

  TTMSAGObject = class
  private
    OldValues : TDictionary<string, Variant>;
    function getMyarManager: TAureliusManager;
  protected
    fMyarManager: TAureliusManager;
    Function GetHlavniMena_Prefill : TKurz_Meny;
    Function GetCiselnaRada_Prefill(aAgenda : String; defaultUserRada : integer) : TCiselne_rady;
    function GetDefaultJednotka : TJednotky;
    property MyarManager : TAureliusManager read getMyarManager write fMyarManager;
  public
    constructor Create; virtual;
    destructor Destroy; override;
    procedure Backup_OldValues;
    class procedure checkNewRecord; virtual; // K Overeni, ze je mozne objekt vytvorit, napr. existuje rada dokladu
    Function CanEditRecord(var AMessage : String) : Boolean; virtual; // Jestli se muze zaznam editovat
    Function CheckRecord(var aMessage : String) : Boolean; Virtual;
    Function CanDeleteRecord(var aMessage : String) : Boolean; Virtual;
    function GetBar_ID : String; virtual;
    function CheckRequiredFields : boolean; virtual;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); virtual;
    procedure SetMyarManager(const Value: TAureliusManager);
    class function create_Prefilled(aObjectType : TClass; aManager : TAureliusManager; aHeader_ID : integer = 0;
        aHeaderObject : TObject = nil; AgendaName : string = '') : TTMSAGObject;
    function GetID0 : Integer;
    Function Clone(aManager : TAureliusManager) : TTMSAGObject;
    procedure ClearManyValuedCollections;
  end;


  [Entity]
  [Table('aktualni_stav')]
  [Description('Tabulka aktulnho stavu')]
  [Id('Fworker_id', TIdGenerator.None)]
  Taktualni_stav = class(TTMSAGObject)
  private
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;

    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;

    [Column('order_id', [TColumnProp.Required], 25)]
    [Description('')]
    Forder_id: string;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('mnoz', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fmnoz: Double;

    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('worker_id2', [TColumnProp.Required])]
    [Description('')]
    Fworker_id2: Integer;
    
    [Column('stroj_id', [TColumnProp.Required])]
    [Description('')]
    Fstroj_id: Integer;
    
    [Column('order_group_id', [TColumnProp.Required])]
    [Description('')]
    Forder_group_id: Integer;
    
    [Column('readdata_id', [TColumnProp.Required])]
    [Description('')]
    Freaddata_id: Int64;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property order_id: string read Forder_id write Forder_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property mnoz: Double read Fmnoz write Fmnoz;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property poradi: Integer read Fporadi write Fporadi;
    property worker_id2: Integer read Fworker_id2 write Fworker_id2;
    property stroj_id: Integer read Fstroj_id write Fstroj_id;
    property order_group_id: Integer read Forder_group_id write Forder_group_id;
    property readdata_id: Int64 read Freaddata_id write Freaddata_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('aktualni_stav_details')]
  [Description('Tabulka aktulnho stavu detaily')]
  [Id('Fworker_id', TIdGenerator.None)]
  Taktualni_stav_details = class(TTMSAGObject)
  private
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;

    [Column('real_time_day', [TColumnProp.Required])]
    [Description('')]
    Freal_time_day: Int64;
    
    [Column('real_time_month', [TColumnProp.Required])]
    [Description('')]
    Freal_time_month: Int64;
    
    [Column('production_day', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fproduction_day: Double;
    
    [Column('production_month', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fproduction_month: Double;
    
    [Column('zmetku_day', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fzmetku_day: Double;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property real_time_day: Int64 read Freal_time_day write Freal_time_day;
    property real_time_month: Int64 read Freal_time_month write Freal_time_month;
    property production_day: Double read Fproduction_day write Fproduction_day;
    property production_month: Double read Fproduction_month write Fproduction_month;
    property zmetku_day: Double read Fzmetku_day write Fzmetku_day;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('auto_login')]
  [Description('Tabulka pro ulozeni posledniho prihlaseni')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tauto_login = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('pc', [TColumnProp.Required], 20)]
    [Description('')]
    Fpc: string;
    
    [Column('login', [TColumnProp.Required], 20)]
    [Description('')]
    Flogin: string;
    
    [Column('pass', [TColumnProp.Required], 20)]
    [Description('')]
    Fpass: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property pc: string read Fpc write Fpc;
    property login: string read Flogin write Flogin;
    property pass: string read Fpass write Fpass;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('calc')]
  [Description('Materilov kalkulaka')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcalc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    
    [Column('koeficient', [TColumnProp.Required], 9, 3)]
    [Description('')]
    Fkoeficient: Double;
    
    [Column('material_id2', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id2: Integer;
    
    [Column('koeficient2', [TColumnProp.Required], 9, 3)]
    [Description('')]
    Fkoeficient2: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property nazev: string read Fnazev write Fnazev;
    property koeficient: Double read Fkoeficient write Fkoeficient;
    property material_id2: Integer read Fmaterial_id2 write Fmaterial_id2;
    property koeficient2: Double read Fkoeficient2 write Fkoeficient2;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('calendar')]
  [Description('Pracovn kalend')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcalendar = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('year', [TColumnProp.Required])]
    [Description('')]
    Fyear: Integer;
    
    [Column('month', [TColumnProp.Required])]
    [Description('')]
    Fmonth: Integer;
    
    [Column('days', [TColumnProp.Required], 31)]
    [Description('')]
    Fdays: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property year: Integer read Fyear write Fyear;
    property month: Integer read Fmonth write Fmonth;
    property days: string read Fdays write Fdays;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('calendar_day')]
  [Description('')]
  [Id('Fcalendar_date', TIdGenerator.None)]
  [Id('Fcalendar_int', TIdGenerator.None)]
  [Id('Fcalendar_date_type', TIdGenerator.None)]
  Tcalendar_day = class(TTMSAGObject)
  private
    [Column('calendar_date', [TColumnProp.Required])]
    [Description('')]
    Fcalendar_date: TDateTime;
    
    [Column('calendar_date_type', [TColumnProp.Required], 1)]
    [Description('')]
    Fcalendar_date_type: string;
    
    [Column('calendar_int', [TColumnProp.Required])]
    [Description('')]
    Fcalendar_int: Integer;
    
    [Column('businessDays', [TColumnProp.Required])]
    [Description('')]
    FbusinessDays: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property calendar_date: TDateTime read Fcalendar_date write Fcalendar_date;
    property calendar_date_type: string read Fcalendar_date_type write Fcalendar_date_type;
    property calendar_int: Integer read Fcalendar_int write Fcalendar_int;
    property businessDays: Integer read FbusinessDays write FbusinessDays;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cidla')]
  [Description('Tabulka cidel')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcidla = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnote: TBlob;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property note: TBlob read Fnote write Fnote;
    property bar_id: string read Fbar_id write Fbar_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('cidla_readdata')]
  [Description('Nactena data cidel')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcidla_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('cas', [TColumnProp.Required])]
    [Description('')]
    Fcas: TDateTime;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('cidlo_id', [TColumnProp.Required])]
    [Description('')]
    Fcidlo_id: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnote: TBlob;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property cas: TDateTime read Fcas write Fcas;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property cidlo_id: Integer read Fcidlo_id write Fcidlo_id;
    property note: TBlob read Fnote write Fnote;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ciselne_rady')]
  [Description('Tabulka ciselnych rad')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tciselne_rady = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('prefix', [TColumnProp.Required], 20)]
    [Description('')]
    Fprefix: string;
    
    [Column('cislo', [TColumnProp.Required], 20)]
    [Description('')]
    Fcislo: string;
    
    [Column('agenda', [TColumnProp.Required], 30)]
    [Description('')]
    Fagenda: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('defaultni', [TColumnProp.Required])]
    [Description('')]
    Fdefaultni: Boolean;
    
    [Column('nazev', [TColumnProp.Required], 30)]
    [Description('')]
    Fnazev: string;

    [Column('oddelovac', [TColumnProp.Required], 20)]
    [Description('')]
    Foddelovac: string;
    
    [Column('sufix', [TColumnProp.Required], 20)]
    [Description('')]
    Fsufix: string;
    
    [Column('aktivni', [TColumnProp.Required])]
    [Description('')]
    Faktivni: Boolean;
    
    [Column('agenda_kod', [TColumnProp.Required], 20)]
    [Description('')]
    Fagenda_kod: string;

    [Column('vychozi_typ_pohybu', [TColumnProp.Required])]
    [Description('')]
    Fvychozi_typ_pohybu: Integer;
    
    [Column('isSablona', [TColumnProp.Required])]
    [Description('')]
    FisSablona: boolean;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property prefix: string read Fprefix write Fprefix;
    property cislo: string read Fcislo write Fcislo;
    property agenda: string read Fagenda write Fagenda;
    property note: string read Fnote write Fnote;
    property defaultni: Boolean read Fdefaultni write Fdefaultni;
    property nazev: string read Fnazev write Fnazev;
    property oddelovac: string read Foddelovac write Foddelovac;
    property sufix: string read Fsufix write Fsufix;
    property aktivni: Boolean read Faktivni write Faktivni;
    property agenda_kod: string read Fagenda_kod write Fagenda_kod;
    property vychozi_typ_pohybu: Integer read Fvychozi_typ_pohybu write Fvychozi_typ_pohybu;
    property isSablona: boolean read FisSablona write FisSablona;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ciselne_rady_doklady_pravidla')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tciselne_rady_doklady_pravidla = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id_vychozi', [], 'id')]
    [Description('')]
    Fciselna_rada_id_vychozi: proxy<Tciselne_rady>;

    [Column('doklad_vychozi', [], 20)]
    [Description('')]
    Fdoklad_vychozi : string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id_vznikajici', [], 'id')]
    [Description('')]
    Fciselna_rada_id_vznikajici: proxy<Tciselne_rady>;

    [Column('doklad_vznikajici', [], 20)]
    [Description('')]
    Fdoklad_vznikajici: string;

    [Column('typ_skladovy_doklad_id',[])]
    [Description('')]
    Ftyp_skladovy_doklad_id : integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('typ_skladovy_doklad_id', [], 'id')]
    [Description('')]
    Ftyp_prijemky_id : proxy<Tsklad_material_prijemky_typy>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('typ_skladovy_doklad_id', [], 'id')]
    [Description('')]
    Ftyp_vydejky_id : proxy<Tsklad_material_vydejky_typy>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getciselna_rada_id_vychozi: Tciselne_rady;
    procedure setciselna_rada_id_vychozi(const Value : Tciselne_rady);
    function getciselna_rada_id_vznikajici: Tciselne_rady;
    procedure setciselna_rada_id_vznikajici(const Value : Tciselne_rady);
    function gettyp_prijemky_id: Tsklad_material_prijemky_typy;
    procedure settyp_prijemky_id(const AValue : Tsklad_material_prijemky_typy);
    function gettyp_vydejky_id: Tsklad_material_vydejky_typy;
    procedure settyp_vydejky_id(const AValue : Tsklad_material_vydejky_typy);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    function CheckRecord(var aMessage: String): Boolean; override;
    property id: Integer read Fid write Fid;
    property ciselna_rada_id_vychozi : Tciselne_rady read getciselna_rada_id_vychozi write setciselna_rada_id_vychozi;
    property ciselna_rada_id_vznikajici : Tciselne_rady read getciselna_rada_id_vznikajici write setciselna_rada_id_vznikajici;
    property typ_prijemky_id : Tsklad_material_prijemky_typy read gettyp_prijemky_id write settyp_prijemky_id;
    property typ_vydejky_id : Tsklad_material_vydejky_typy read gettyp_vydejky_id write settyp_vydejky_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property doklad_vychozi : String read Fdoklad_vychozi write Fdoklad_vychozi;
    property doklad_vznikajici : String read Fdoklad_vznikajici write Fdoklad_vznikajici;
  end;

  [Entity]
  [Table('cis_den')]
  [Description('selnk dn')]
  [Id('Fid_den', TIdGenerator.IdentityOrSequence)]
  Tcis_den = class(TTMSAGObject)
  private
    [Column('id_den', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_den: Integer;

    [Column('nazev', [TColumnProp.Required], 15)]
    [Description('')]
    Fnazev: string;

    [Column('zkratka', [TColumnProp.Required], 2)]
    [Description('')]
    Fzkratka: string;

    [Column('typ', [TColumnProp.Required])]
    [Description('')]
    Ftyp: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_den: Integer read Fid_den write Fid_den;
    property nazev: string read Fnazev write Fnazev;
    property zkratka: string read Fzkratka write Fzkratka;
    property typ: Integer read Ftyp write Ftyp;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cis_frekvence')]
  [Description('CIS_FREKVENCE')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcis_frekvence = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('kod', [TColumnProp.Required])]
    [Description('')]
    Fkod: Integer;
    
    [Column('popis', [], 10)]
    [Description('')]
    Fpopis: Nullable<string>;
    
    [Column('zkratka', [TColumnProp.Required], 1)]
    [Description('')]
    Fzkratka: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property kod: Integer read Fkod write Fkod;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property zkratka: string read Fzkratka write Fzkratka;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cis_pozice')]
  [Description('selnk pracovnch pozic')]
  [Id('Fid_pozice', TIdGenerator.IdentityOrSequence)]
  Tcis_pozice = class(TTMSAGObject)
  private
    [Column('id_pozice', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_pozice: Integer;
    
    [Column('popis_funkce', [TColumnProp.Required], 120)]
    [Description('')]
    Fpopis_funkce: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_pozice: Integer read Fid_pozice write Fid_pozice;
    property popis_funkce: string read Fpopis_funkce write Fpopis_funkce;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cis_pracovni_skupina')]
  [Description('selnk pracovnch skupin')]
  [Id('Fid_pracovni_skupina', TIdGenerator.IdentityOrSequence)]
  Tcis_pracovni_skupina = class(TTMSAGObject)
  private
    [Column('id_pracovni_skupina', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_pracovni_skupina: Integer;

    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    
    [Column('vyroba', [TColumnProp.Required])]
    [Description('')]
    Fvyroba: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_pracovni_skupina: Integer read Fid_pracovni_skupina write Fid_pracovni_skupina;
    property nazev: string read Fnazev write Fnazev;
    property vyroba: Integer read Fvyroba write Fvyroba;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cis_typ_provoz')]
  [Description('selnk typ provoz')]
  [Id('Fid_typ_provoz', TIdGenerator.IdentityOrSequence)]
  Tcis_typ_provoz = class(TTMSAGObject)
  private
    [Column('id_typ_provoz', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_typ_provoz: Integer;
    
    [Column('nazev', [TColumnProp.Required], 15)]
    [Description('')]
    Fnazev: string;
    
    [Column('fond_hodin', [TColumnProp.Required], 5, 2)]
    [Description('')]
    Ffond_hodin: Double;
    
    [Column('denni_fond', [TColumnProp.Required], 5, 2)]
    [Description('')]
    Fdenni_fond: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_typ_provoz: Integer read Fid_typ_provoz write Fid_typ_provoz;
    property nazev: string read Fnazev write Fnazev;
    property fond_hodin: Double read Ffond_hodin write Ffond_hodin;
    property denni_fond: Double read Fdenni_fond write Fdenni_fond;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cis_typ_smeny')]
  [Description('selnk smn')]
  [Id('Fid_typ_smeny', TIdGenerator.IdentityOrSequence)]
  Tcis_typ_smeny = class(TTMSAGObject)
  private
    [Column('id_typ_smeny', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('zobrazit_v_planu', [TColumnProp.Required])]
    [Description('')]
    Fzobrazit_v_planu: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property zobrazit_v_planu: Integer read Fzobrazit_v_planu write Fzobrazit_v_planu;
    property poradi: Integer read Fporadi write Fporadi;
    property nazev: string read Fnazev write Fnazev;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('cnc_group')]
  [Description('Skupiny CNC stroju')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcnc_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('creator', [TColumnProp.Required], 50)]
    [Description('')]
    Fcreator: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user: string read Fuser write Fuser;
    property creator: string read Fcreator write Fcreator;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('cnc_import_casu')]
  [Description('Tabulka importovanch as pro CNC')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcnc_import_casu = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('cnc_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_id: Integer;
    
    [Column('cnc_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fcnc_name: string;
    
    [Column('order_id', [TColumnProp.Required], 100)]
    [Description('')]
    Forder_id: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('mnozstvi', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fmnozstvi: Double;
    
    [Column('note', [TColumnProp.Required], 255)]
    [Description('')]
    Fnote: string;
    
    [Column('processed', [TColumnProp.Required])]
    [Description('')]
    Fprocessed: Integer;
    
    [Column('imported', [TColumnProp.Required])]
    [Description('')]
    Fimported: Integer;
    
    [Column('imported_datetime', [])]
    [Description('')]
    Fimported_datetime: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property cnc_id: Integer read Fcnc_id write Fcnc_id;
    property cnc_name: string read Fcnc_name write Fcnc_name;
    property order_id: string read Forder_id write Forder_id;
    property operation_id: Integer read Foperation_id write Foperation_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property note: string read Fnote write Fnote;
    property processed: Integer read Fprocessed write Fprocessed;
    property imported: Integer read Fimported write Fimported;
    property imported_datetime: Nullable<TDateTime> read Fimported_datetime write Fimported_datetime;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('colors')]
  [Description('Tabulka nastaven uivatelskch barev')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcolors = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('color1', [TColumnProp.Required])]
    [Description('')]
    Fcolor1: Integer;
    
    [Column('color2', [TColumnProp.Required])]
    [Description('')]
    Fcolor2: Integer;
    
    [Column('color3', [TColumnProp.Required])]
    [Description('')]
    Fcolor3: Integer;
    
    [Column('color4', [TColumnProp.Required])]
    [Description('')]
    Fcolor4: Integer;
    
    [Column('color5', [TColumnProp.Required])]
    [Description('')]
    Fcolor5: Integer;
    
    [Column('color6', [TColumnProp.Required])]
    [Description('')]
    Fcolor6: Integer;
    
    [Column('color7', [TColumnProp.Required])]
    [Description('')]
    Fcolor7: Integer;
    
    [Column('color8', [TColumnProp.Required])]
    [Description('')]
    Fcolor8: Integer;
    
    [Column('color9', [TColumnProp.Required])]
    [Description('')]
    Fcolor9: Integer;
    
    [Column('color10', [TColumnProp.Required])]
    [Description('')]
    Fcolor10: Integer;
    
    [Column('color11', [TColumnProp.Required])]
    [Description('')]
    Fcolor11: Integer;
    
    [Column('color12', [TColumnProp.Required])]
    [Description('')]
    Fcolor12: Integer;
    
    [Column('color13', [TColumnProp.Required])]
    [Description('')]
    Fcolor13: Integer;
    
    [Column('color14', [TColumnProp.Required])]
    [Description('')]
    Fcolor14: Integer;
    
    [Column('color15', [TColumnProp.Required])]
    [Description('')]
    Fcolor15: Integer;
    
    [Column('color16', [TColumnProp.Required])]
    [Description('')]
    Fcolor16: Integer;
    
    [Column('color17', [TColumnProp.Required])]
    [Description('')]
    Fcolor17: Integer;
    
    [Column('color18', [TColumnProp.Required])]
    [Description('')]
    Fcolor18: Integer;
    
    [Column('color19', [TColumnProp.Required])]
    [Description('')]
    Fcolor19: Integer;
    
    [Column('color20', [TColumnProp.Required])]
    [Description('')]
    Fcolor20: Integer;
    
    [Column('color21', [TColumnProp.Required])]
    [Description('')]
    Fcolor21: Integer;
    
    [Column('color22', [TColumnProp.Required])]
    [Description('')]
    Fcolor22: Integer;
    
    [Column('color23', [TColumnProp.Required])]
    [Description('')]
    Fcolor23: Integer;
    
    [Column('color24', [TColumnProp.Required])]
    [Description('')]
    Fcolor24: Integer;
    
    [Column('color25', [TColumnProp.Required])]
    [Description('')]
    Fcolor25: Integer;
    
    [Column('color26', [TColumnProp.Required])]
    [Description('')]
    Fcolor26: Integer;
    
    [Column('color27', [TColumnProp.Required])]
    [Description('')]
    Fcolor27: Integer;
    
    [Column('color28', [TColumnProp.Required])]
    [Description('')]
    Fcolor28: Integer;
    
    [Column('color29', [TColumnProp.Required])]
    [Description('')]
    Fcolor29: Integer;
    
    [Column('color30', [TColumnProp.Required])]
    [Description('')]
    Fcolor30: Integer;
    
    [Column('color31', [TColumnProp.Required])]
    [Description('')]
    Fcolor31: Integer;
    
    [Column('color32', [TColumnProp.Required])]
    [Description('')]
    Fcolor32: Integer;
    
    [Column('color33', [TColumnProp.Required])]
    [Description('')]
    Fcolor33: Integer;
    
    [Column('color34', [TColumnProp.Required])]
    [Description('')]
    Fcolor34: Integer;
    
    [Column('color35', [TColumnProp.Required])]
    [Description('')]
    Fcolor35: Integer;
    
    [Column('color36', [TColumnProp.Required])]
    [Description('')]
    Fcolor36: Integer;
    
    [Column('color37', [TColumnProp.Required])]
    [Description('')]
    Fcolor37: Integer;
    
    [Column('color38', [TColumnProp.Required])]
    [Description('')]
    Fcolor38: Integer;
    
    [Column('color39', [TColumnProp.Required])]
    [Description('')]
    Fcolor39: Integer;
    
    [Column('color40', [TColumnProp.Required])]
    [Description('')]
    Fcolor40: Integer;
    
    [Column('color41', [TColumnProp.Required])]
    [Description('')]
    Fcolor41: Integer;
    
    [Column('color42', [TColumnProp.Required])]
    [Description('')]
    Fcolor42: Integer;
    
    [Column('color43', [TColumnProp.Required])]
    [Description('')]
    Fcolor43: Integer;
    
    [Column('color44', [TColumnProp.Required])]
    [Description('')]
    Fcolor44: Integer;
    
    [Column('color45', [TColumnProp.Required])]
    [Description('')]
    Fcolor45: Integer;
    
    [Column('color46', [TColumnProp.Required])]
    [Description('')]
    Fcolor46: Integer;
    
    [Column('color47', [TColumnProp.Required])]
    [Description('')]
    Fcolor47: Integer;
    
    [Column('color48', [TColumnProp.Required])]
    [Description('')]
    Fcolor48: Integer;
    
    [Column('color49', [TColumnProp.Required])]
    [Description('')]
    Fcolor49: Integer;
    
    [Column('color50', [TColumnProp.Required])]
    [Description('')]
    Fcolor50: Integer;
    
    [Column('color51', [TColumnProp.Required])]
    [Description('')]
    Fcolor51: Integer;
    
    [Column('color52', [TColumnProp.Required])]
    [Description('')]
    Fcolor52: Integer;
    
    [Column('color53', [TColumnProp.Required])]
    [Description('')]
    Fcolor53: Integer;
    
    [Column('color54', [TColumnProp.Required])]
    [Description('')]
    Fcolor54: Integer;
    
    [Column('color55', [TColumnProp.Required])]
    [Description('')]
    Fcolor55: Integer;
    
    [Column('color56', [TColumnProp.Required])]
    [Description('')]
    Fcolor56: Integer;
    
    [Column('color57', [TColumnProp.Required])]
    [Description('')]
    Fcolor57: Integer;
    
    [Column('color58', [TColumnProp.Required])]
    [Description('')]
    Fcolor58: Integer;
    
    [Column('color59', [TColumnProp.Required])]
    [Description('')]
    Fcolor59: Integer;

    [Column('color60', [TColumnProp.Required])]
    [Description('')]
    Fcolor60: Integer;
    
    [Column('color61', [TColumnProp.Required])]
    [Description('')]
    Fcolor61: Integer;
    
    [Column('color62', [TColumnProp.Required])]
    [Description('')]
    Fcolor62: Integer;
    
    [Column('color63', [TColumnProp.Required])]
    [Description('')]
    Fcolor63: Integer;
    
    [Column('color64', [TColumnProp.Required])]
    [Description('')]
    Fcolor64: Integer;
    
    [Column('color65', [TColumnProp.Required])]
    [Description('')]
    Fcolor65: Integer;
    
    [Column('color66', [TColumnProp.Required])]
    [Description('')]
    Fcolor66: Integer;
    
    [Column('color67', [TColumnProp.Required])]
    [Description('')]
    Fcolor67: Integer;
    
    [Column('color68', [TColumnProp.Required])]
    [Description('')]
    Fcolor68: Integer;
    
    [Column('color69', [TColumnProp.Required])]
    [Description('')]
    Fcolor69: Integer;
    
    [Column('color70', [TColumnProp.Required])]
    [Description('')]
    Fcolor70: Integer;
    
    [Column('color71', [TColumnProp.Required])]
    [Description('')]
    Fcolor71: Integer;
    
    [Column('color72', [TColumnProp.Required])]
    [Description('')]
    Fcolor72: Integer;
    
    [Column('color73', [TColumnProp.Required])]
    [Description('')]
    Fcolor73: Integer;
    
    [Column('color74', [TColumnProp.Required])]
    [Description('')]
    Fcolor74: Integer;
    
    [Column('color75', [TColumnProp.Required])]
    [Description('')]
    Fcolor75: Integer;
    
    [Column('color76', [TColumnProp.Required])]
    [Description('')]
    Fcolor76: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property color1: Integer read Fcolor1 write Fcolor1;
    property color2: Integer read Fcolor2 write Fcolor2;
    property color3: Integer read Fcolor3 write Fcolor3;
    property color4: Integer read Fcolor4 write Fcolor4;
    property color5: Integer read Fcolor5 write Fcolor5;
    property color6: Integer read Fcolor6 write Fcolor6;
    property color7: Integer read Fcolor7 write Fcolor7;
    property color8: Integer read Fcolor8 write Fcolor8;
    property color9: Integer read Fcolor9 write Fcolor9;
    property color10: Integer read Fcolor10 write Fcolor10;
    property color11: Integer read Fcolor11 write Fcolor11;
    property color12: Integer read Fcolor12 write Fcolor12;
    property color13: Integer read Fcolor13 write Fcolor13;
    property color14: Integer read Fcolor14 write Fcolor14;
    property color15: Integer read Fcolor15 write Fcolor15;
    property color16: Integer read Fcolor16 write Fcolor16;
    property color17: Integer read Fcolor17 write Fcolor17;
    property color18: Integer read Fcolor18 write Fcolor18;
    property color19: Integer read Fcolor19 write Fcolor19;
    property color20: Integer read Fcolor20 write Fcolor20;
    property color21: Integer read Fcolor21 write Fcolor21;
    property color22: Integer read Fcolor22 write Fcolor22;
    property color23: Integer read Fcolor23 write Fcolor23;
    property color24: Integer read Fcolor24 write Fcolor24;
    property color25: Integer read Fcolor25 write Fcolor25;
    property color26: Integer read Fcolor26 write Fcolor26;
    property color27: Integer read Fcolor27 write Fcolor27;
    property color28: Integer read Fcolor28 write Fcolor28;
    property color29: Integer read Fcolor29 write Fcolor29;
    property color30: Integer read Fcolor30 write Fcolor30;
    property color31: Integer read Fcolor31 write Fcolor31;
    property color32: Integer read Fcolor32 write Fcolor32;
    property color33: Integer read Fcolor33 write Fcolor33;
    property color34: Integer read Fcolor34 write Fcolor34;
    property color35: Integer read Fcolor35 write Fcolor35;
    property color36: Integer read Fcolor36 write Fcolor36;
    property color37: Integer read Fcolor37 write Fcolor37;
    property color38: Integer read Fcolor38 write Fcolor38;
    property color39: Integer read Fcolor39 write Fcolor39;
    property color40: Integer read Fcolor40 write Fcolor40;
    property color41: Integer read Fcolor41 write Fcolor41;
    property color42: Integer read Fcolor42 write Fcolor42;
    property color43: Integer read Fcolor43 write Fcolor43;
    property color44: Integer read Fcolor44 write Fcolor44;
    property color45: Integer read Fcolor45 write Fcolor45;
    property color46: Integer read Fcolor46 write Fcolor46;
    property color47: Integer read Fcolor47 write Fcolor47;
    property color48: Integer read Fcolor48 write Fcolor48;
    property color49: Integer read Fcolor49 write Fcolor49;
    property color50: Integer read Fcolor50 write Fcolor50;
    property color51: Integer read Fcolor51 write Fcolor51;
    property color52: Integer read Fcolor52 write Fcolor52;
    property color53: Integer read Fcolor53 write Fcolor53;
    property color54: Integer read Fcolor54 write Fcolor54;
    property color55: Integer read Fcolor55 write Fcolor55;
    property color56: Integer read Fcolor56 write Fcolor56;
    property color57: Integer read Fcolor57 write Fcolor57;
    property color58: Integer read Fcolor58 write Fcolor58;
    property color59: Integer read Fcolor59 write Fcolor59;
    property color60: Integer read Fcolor60 write Fcolor60;
    property color61: Integer read Fcolor61 write Fcolor61;
    property color62: Integer read Fcolor62 write Fcolor62;
    property color63: Integer read Fcolor63 write Fcolor63;
    property color64: Integer read Fcolor64 write Fcolor64;
    property color65: Integer read Fcolor65 write Fcolor65;
    property color66: Integer read Fcolor66 write Fcolor66;
    property color67: Integer read Fcolor67 write Fcolor67;
    property color68: Integer read Fcolor68 write Fcolor68;
    property color69: Integer read Fcolor69 write Fcolor69;
    property color70: Integer read Fcolor70 write Fcolor70;
    property color71: Integer read Fcolor71 write Fcolor71;
    property color72: Integer read Fcolor72 write Fcolor72;
    property color73: Integer read Fcolor73 write Fcolor73;
    property color74: Integer read Fcolor74 write Fcolor74;
    property color75: Integer read Fcolor75 write Fcolor75;
    property color76: Integer read Fcolor76 write Fcolor76;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('columns')]
  [Description('Rozloen sloupc dbgridu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcolumns = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;

    [Column('dochazka', [TColumnProp.Lazy])]
    [Description('')]
    Fdochazka: TBlob;
    
    [Column('worker', [TColumnProp.Lazy])]
    [Description('')]
    Fworker: TBlob;
    
    [Column('readdata', [TColumnProp.Lazy])]
    [Description('')]
    Freaddata: TBlob;
    
    [Column('skladmaterialu', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu: TBlob;
    
    [Column('customer', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer: TBlob;
    
    [Column('skladnaradi', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradi: TBlob;
    
    [Column('skladmaterialu_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_readdata: TBlob;
    
    [Column('stroje', [TColumnProp.Lazy])]
    [Description('')]
    Fstroje: TBlob;
    
    [Column('skladskupiny', [TColumnProp.Lazy])]
    [Description('')]
    Fskladskupiny: TBlob;
    
    [Column('skladnaradi_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradi_readdata: TBlob;
    
    [Column('skladnaradi_pohyb', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradi_pohyb: TBlob;

    [Column('skladmaterialu_prijemky1', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_prijemky1: TBlob;
    
    [Column('skladmaterialu_prijemky2', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_prijemky2: TBlob;
    
    [Column('repairtype', [TColumnProp.Lazy])]
    [Description('')]
    Frepairtype: TBlob;
    
    [Column('pausal', [TColumnProp.Lazy])]
    [Description('')]
    Fpausal: TBlob;
    
    [Column('orderwork_plan', [TColumnProp.Lazy])]
    [Description('')]
    Forderwork_plan: TBlob;
    
    [Column('orderstavy', [TColumnProp.Lazy])]
    [Description('')]
    Forderstavy: TBlob;
    
    [Column('operation_group', [TColumnProp.Lazy])]
    [Description('')]
    Foperation_group: TBlob;
    
    [Column('operation', [TColumnProp.Lazy])]
    [Description('')]
    Foperation: TBlob;
    
    [Column('cnc', [TColumnProp.Lazy])]
    [Description('')]
    Fcnc: TBlob;
    
    [Column('dodacilist1', [TColumnProp.Lazy])]
    [Description('')]
    Fdodacilist1: TBlob;
    
    [Column('dodacilist2', [TColumnProp.Lazy])]
    [Description('')]
    Fdodacilist2: TBlob;

    [Column('order_page1', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page1: TBlob;
    
    [Column('order_page2', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page2: TBlob;
    
    [Column('order_page3', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page3: TBlob;
    
    [Column('order_page4', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page4: TBlob;
    
    [Column('order_page5', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page5: TBlob;
    
    [Column('order_page6', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page6: TBlob;
    
    [Column('order_page7', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page7: TBlob;
    
    [Column('order_page8', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page8: TBlob;
    
    [Column('order_page9', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page9: TBlob;
    
    [Column('order_page10', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page10: TBlob;
    
    [Column('sort_settings', [TColumnProp.Lazy])]
    [Description('')]
    Fsort_settings: TBlob;

    [Column('application_setting', [TColumnProp.Lazy])]
    [Description('')]
    Fapplication_setting: TBlob;
    
    [Column('data_colection', [TColumnProp.Lazy])]
    [Description('')]
    Fdata_colection: TBlob;
    
    [Column('objednavky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky: TBlob;
    
    [Column('objednavky_polozky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozky: TBlob;
    
    [Column('objednavky_polozkyNaradi', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozkyNaradi: TBlob;
    
    [Column('materialy', [TColumnProp.Lazy])]
    [Description('')]
    Fmaterialy: TBlob;
    
    [Column('graficky_prehled', [TColumnProp.Lazy])]
    [Description('')]
    Fgraficky_prehled: TBlob;
    
    [Column('order_page11', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page11: TBlob;
    
    [Column('tech_postup', [TColumnProp.Lazy])]
    [Description('')]
    Ftech_postup: TBlob;
    
    [Column('tech_postup_polozky', [TColumnProp.Lazy])]
    [Description('')]
    Ftech_postup_polozky: TBlob;
    
    [Column('naradi_reader', [TColumnProp.Lazy])]
    [Description('')]
    Fnaradi_reader: TBlob;

    [Column('order_page12', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page12: TBlob;
    
    [Column('cidla_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fcidla_readdata: TBlob;
    
    [Column('sprava_zaznamu', [TColumnProp.Lazy])]
    [Description('')]
    Fsprava_zaznamu: TBlob;
    
    [Column('objednavky_prijate', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_prijate: TBlob;
    
    [Column('objednavky_prijate_polozky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_prijate_polozky: TBlob;
    
    [Column('order_page13', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page13: TBlob;
    
    [Column('touchTerminal', [TColumnProp.Lazy])]
    [Description('')]
    FtouchTerminal: TBlob;
    
    [Column('hromadnyVydej', [TColumnProp.Lazy])]
    [Description('')]
    FhromadnyVydej: TBlob;
    
    [Column('KDatuOrder', [TColumnProp.Lazy])]
    [Description('')]
    FKDatuOrder: TBlob;
    
    [Column('KDatuOrderWork', [TColumnProp.Lazy])]
    [Description('')]
    FKDatuOrderWork: TBlob;
    
    [Column('hromadnyPohybNar', [TColumnProp.Lazy])]
    [Description('')]
    FhromadnyPohybNar: TBlob;

    [Column('CNCGroup', [TColumnProp.Lazy])]
    [Description('')]
    FCNCGroup: TBlob;
    
    [Column('StrojGroup', [TColumnProp.Lazy])]
    [Description('')]
    FStrojGroup: TBlob;
    
    [Column('customer_order', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer_order: TBlob;
    
    [Column('customer_osoby', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer_osoby: TBlob;
    
    [Column('skladmaterialu_vydejky1', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_vydejky1: TBlob;
    
    [Column('skladmaterialu_vydejky2', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_vydejky2: TBlob;
    
    [Column('customer_udalosti', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer_udalosti: TBlob;
    
    [Column('agUlAdresyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlAdresyView: TBlob;
    
    [Column('agUlSkladView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlSkladView: TBlob;
    
    [Column('agUlZakazkyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlZakazkyView: TBlob;
    
    [Column('agUlOperaceView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlOperaceView: TBlob;

    [Column('agUlSarzeView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlSarzeView: TBlob;
    
    [Column('PPSkladBlokace', [TColumnProp.Lazy])]
    [Description('')]
    FPPSkladBlokace: TBlob;
    
    [Column('PPSkladVyroba', [TColumnProp.Lazy])]
    [Description('')]
    FPPSkladVyroba: TBlob;
    
    [Column('PPSkladObjednavky', [TColumnProp.Lazy])]
    [Description('')]
    FPPSkladObjednavky: TBlob;
    
    [Column('PPMatBlokace', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatBlokace: TBlob;
    
    [Column('PPMatVyroba', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatVyroba: TBlob;
    
    [Column('PPMatObjednavky', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatObjednavky: TBlob;
    
    [Column('PPMatPBlokace', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatPBlokace: TBlob;
    
    [Column('PPMatPVyroba', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatPVyroba: TBlob;
    
    [Column('PPMatPObjednavky', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatPObjednavky: TBlob;
    
    [Column('skladformy', [TColumnProp.Lazy])]
    [Description('')]
    Fskladformy: TBlob;

    [Column('skladformy_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fskladformy_readdata: TBlob;
    
    [Column('skladformy_pohyb', [TColumnProp.Lazy])]
    [Description('')]
    Fskladformy_pohyb: TBlob;
    
    [Column('SkladovePozice', [TColumnProp.Lazy])]
    [Description('')]
    FSkladovePozice: TBlob;
    
    [Column('SkladovePoziceReadData', [TColumnProp.Lazy])]
    [Description('')]
    FSkladovePoziceReadData: TBlob;
    
    [Column('SkladoveInventury', [TColumnProp.Lazy])]
    [Description('')]
    FSkladoveInventury: TBlob;
    
    [Column('SkladoveInventurySoupisy', [TColumnProp.Lazy])]
    [Description('')]
    FSkladoveInventurySoupisy: TBlob;
    
    [Column('SkladoveInventuryPolozky', [TColumnProp.Lazy])]
    [Description('')]
    FSkladoveInventuryPolozky: TBlob;
    
    [Column('agUlObjednavkyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlObjednavkyView: TBlob;
    
    [Column('PPZamDovednosti', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamDovednosti: TBlob;
    
    [Column('PPZamOperace', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamOperace: TBlob;
    
    [Column('PPZamCNC', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamCNC: TBlob;

    [Column('PPZamSkupiny', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamSkupiny: TBlob;
    
    [Column('PPStrojeDefTypySer', [TColumnProp.Lazy])]
    [Description('')]
    FPPStrojeDefTypySer: TBlob;
    
    [Column('PPStrojePlanServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPStrojePlanServisy: TBlob;
    
    [Column('PPStrojeProvServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPStrojeProvServisy: TBlob;
    
    [Column('PPCNCDefTypySer', [TColumnProp.Lazy])]
    [Description('')]
    FPPCNCDefTypySer: TBlob;
    
    [Column('PPCNCPlanServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPCNCPlanServisy: TBlob;
    
    [Column('PPCNCProvServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPCNCProvServisy: TBlob;
    
    [Column('PPOperaceZam', [TColumnProp.Lazy])]
    [Description('')]
    FPPOperaceZam: TBlob;
    
    [Column('PPOperaceStroje', [TColumnProp.Lazy])]
    [Description('')]
    FPPOperaceStroje: TBlob;
    
    [Column('PPOperaceCNC', [TColumnProp.Lazy])]
    [Description('')]
    FPPOperaceCNC: TBlob;
    
    [Column('Dochazka2015', [TColumnProp.Lazy])]
    [Description('')]
    FDochazka2015: TBlob;

    [Column('skladnaradisledovane', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradisledovane: TBlob;
    
    [Column('Dochazka2015_mesic', [TColumnProp.Lazy])]
    [Description('')]
    FDochazka2015_mesic: TBlob;
    
    [Column('agUlSkupinyOperaciView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlSkupinyOperaciView: TBlob;
    
    [Column('GrafickyPrehledDenOP', [TColumnProp.Lazy])]
    [Description('')]
    FGrafickyPrehledDenOP: TBlob;
    
    [Column('agUlWorkerView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlWorkerView: TBlob;
    
    [Column('agUlCNCView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlCNCView: TBlob;
    
    [Column('agUlObjednavkyPrijateView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlObjednavkyPrijateView: TBlob;
    
    [Column('agUlObjednavkyPrijatePolozkyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlObjednavkyPrijatePolozkyView: TBlob;
    
    [Column('objednavky_polozkyBezVazby', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozkyBezVazby: TBlob;
    
    [Column('objednavky_polozkySubdodavky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozkySubdodavky: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property dochazka: TBlob read Fdochazka write Fdochazka;
    property worker: TBlob read Fworker write Fworker;
    property readdata: TBlob read Freaddata write Freaddata;
    property skladmaterialu: TBlob read Fskladmaterialu write Fskladmaterialu;
    property customer: TBlob read Fcustomer write Fcustomer;
    property skladnaradi: TBlob read Fskladnaradi write Fskladnaradi;
    property skladmaterialu_readdata: TBlob read Fskladmaterialu_readdata write Fskladmaterialu_readdata;
    property stroje: TBlob read Fstroje write Fstroje;
    property skladskupiny: TBlob read Fskladskupiny write Fskladskupiny;
    property skladnaradi_readdata: TBlob read Fskladnaradi_readdata write Fskladnaradi_readdata;
    property skladnaradi_pohyb: TBlob read Fskladnaradi_pohyb write Fskladnaradi_pohyb;
    property skladmaterialu_prijemky1: TBlob read Fskladmaterialu_prijemky1 write Fskladmaterialu_prijemky1;
    property skladmaterialu_prijemky2: TBlob read Fskladmaterialu_prijemky2 write Fskladmaterialu_prijemky2;
    property repairtype: TBlob read Frepairtype write Frepairtype;
    property pausal: TBlob read Fpausal write Fpausal;
    property orderwork_plan: TBlob read Forderwork_plan write Forderwork_plan;
    property orderstavy: TBlob read Forderstavy write Forderstavy;
    property operation_group: TBlob read Foperation_group write Foperation_group;
    property operation: TBlob read Foperation write Foperation;
    property cnc: TBlob read Fcnc write Fcnc;
    property dodacilist1: TBlob read Fdodacilist1 write Fdodacilist1;
    property dodacilist2: TBlob read Fdodacilist2 write Fdodacilist2;
    property order_page1: TBlob read Forder_page1 write Forder_page1;
    property order_page2: TBlob read Forder_page2 write Forder_page2;
    property order_page3: TBlob read Forder_page3 write Forder_page3;
    property order_page4: TBlob read Forder_page4 write Forder_page4;
    property order_page5: TBlob read Forder_page5 write Forder_page5;
    property order_page6: TBlob read Forder_page6 write Forder_page6;
    property order_page7: TBlob read Forder_page7 write Forder_page7;
    property order_page8: TBlob read Forder_page8 write Forder_page8;
    property order_page9: TBlob read Forder_page9 write Forder_page9;
    property order_page10: TBlob read Forder_page10 write Forder_page10;
    property sort_settings: TBlob read Fsort_settings write Fsort_settings;
    property application_setting: TBlob read Fapplication_setting write Fapplication_setting;
    property data_colection: TBlob read Fdata_colection write Fdata_colection;
    property objednavky: TBlob read Fobjednavky write Fobjednavky;
    property objednavky_polozky: TBlob read Fobjednavky_polozky write Fobjednavky_polozky;
    property objednavky_polozkyNaradi: TBlob read Fobjednavky_polozkyNaradi write Fobjednavky_polozkyNaradi;
    property materialy: TBlob read Fmaterialy write Fmaterialy;
    property graficky_prehled: TBlob read Fgraficky_prehled write Fgraficky_prehled;
    property order_page11: TBlob read Forder_page11 write Forder_page11;
    property tech_postup: TBlob read Ftech_postup write Ftech_postup;
    property tech_postup_polozky: TBlob read Ftech_postup_polozky write Ftech_postup_polozky;
    property naradi_reader: TBlob read Fnaradi_reader write Fnaradi_reader;
    property order_page12: TBlob read Forder_page12 write Forder_page12;
    property cidla_readdata: TBlob read Fcidla_readdata write Fcidla_readdata;
    property sprava_zaznamu: TBlob read Fsprava_zaznamu write Fsprava_zaznamu;
    property objednavky_prijate: TBlob read Fobjednavky_prijate write Fobjednavky_prijate;
    property objednavky_prijate_polozky: TBlob read Fobjednavky_prijate_polozky write Fobjednavky_prijate_polozky;
    property order_page13: TBlob read Forder_page13 write Forder_page13;
    property touchTerminal: TBlob read FtouchTerminal write FtouchTerminal;
    property hromadnyVydej: TBlob read FhromadnyVydej write FhromadnyVydej;
    property KDatuOrder: TBlob read FKDatuOrder write FKDatuOrder;
    property KDatuOrderWork: TBlob read FKDatuOrderWork write FKDatuOrderWork;
    property hromadnyPohybNar: TBlob read FhromadnyPohybNar write FhromadnyPohybNar;
    property CNCGroup: TBlob read FCNCGroup write FCNCGroup;
    property StrojGroup: TBlob read FStrojGroup write FStrojGroup;
    property customer_order: TBlob read Fcustomer_order write Fcustomer_order;
    property customer_osoby: TBlob read Fcustomer_osoby write Fcustomer_osoby;
    property skladmaterialu_vydejky1: TBlob read Fskladmaterialu_vydejky1 write Fskladmaterialu_vydejky1;
    property skladmaterialu_vydejky2: TBlob read Fskladmaterialu_vydejky2 write Fskladmaterialu_vydejky2;
    property customer_udalosti: TBlob read Fcustomer_udalosti write Fcustomer_udalosti;
    property agUlAdresyView: TBlob read FagUlAdresyView write FagUlAdresyView;
    property agUlSkladView: TBlob read FagUlSkladView write FagUlSkladView;
    property agUlZakazkyView: TBlob read FagUlZakazkyView write FagUlZakazkyView;
    property agUlOperaceView: TBlob read FagUlOperaceView write FagUlOperaceView;
    property agUlSarzeView: TBlob read FagUlSarzeView write FagUlSarzeView;
    property PPSkladBlokace: TBlob read FPPSkladBlokace write FPPSkladBlokace;
    property PPSkladVyroba: TBlob read FPPSkladVyroba write FPPSkladVyroba;
    property PPSkladObjednavky: TBlob read FPPSkladObjednavky write FPPSkladObjednavky;
    property PPMatBlokace: TBlob read FPPMatBlokace write FPPMatBlokace;
    property PPMatVyroba: TBlob read FPPMatVyroba write FPPMatVyroba;
    property PPMatObjednavky: TBlob read FPPMatObjednavky write FPPMatObjednavky;
    property PPMatPBlokace: TBlob read FPPMatPBlokace write FPPMatPBlokace;
    property PPMatPVyroba: TBlob read FPPMatPVyroba write FPPMatPVyroba;
    property PPMatPObjednavky: TBlob read FPPMatPObjednavky write FPPMatPObjednavky;
    property skladformy: TBlob read Fskladformy write Fskladformy;
    property skladformy_readdata: TBlob read Fskladformy_readdata write Fskladformy_readdata;
    property skladformy_pohyb: TBlob read Fskladformy_pohyb write Fskladformy_pohyb;
    property SkladovePozice: TBlob read FSkladovePozice write FSkladovePozice;
    property SkladovePoziceReadData: TBlob read FSkladovePoziceReadData write FSkladovePoziceReadData;
    property SkladoveInventury: TBlob read FSkladoveInventury write FSkladoveInventury;
    property SkladoveInventurySoupisy: TBlob read FSkladoveInventurySoupisy write FSkladoveInventurySoupisy;
    property SkladoveInventuryPolozky: TBlob read FSkladoveInventuryPolozky write FSkladoveInventuryPolozky;
    property agUlObjednavkyView: TBlob read FagUlObjednavkyView write FagUlObjednavkyView;
    property PPZamDovednosti: TBlob read FPPZamDovednosti write FPPZamDovednosti;
    property PPZamOperace: TBlob read FPPZamOperace write FPPZamOperace;
    property PPZamCNC: TBlob read FPPZamCNC write FPPZamCNC;
    property PPZamSkupiny: TBlob read FPPZamSkupiny write FPPZamSkupiny;
    property PPStrojeDefTypySer: TBlob read FPPStrojeDefTypySer write FPPStrojeDefTypySer;
    property PPStrojePlanServisy: TBlob read FPPStrojePlanServisy write FPPStrojePlanServisy;
    property PPStrojeProvServisy: TBlob read FPPStrojeProvServisy write FPPStrojeProvServisy;
    property PPCNCDefTypySer: TBlob read FPPCNCDefTypySer write FPPCNCDefTypySer;
    property PPCNCPlanServisy: TBlob read FPPCNCPlanServisy write FPPCNCPlanServisy;
    property PPCNCProvServisy: TBlob read FPPCNCProvServisy write FPPCNCProvServisy;
    property PPOperaceZam: TBlob read FPPOperaceZam write FPPOperaceZam;
    property PPOperaceStroje: TBlob read FPPOperaceStroje write FPPOperaceStroje;
    property PPOperaceCNC: TBlob read FPPOperaceCNC write FPPOperaceCNC;
    property Dochazka2015: TBlob read FDochazka2015 write FDochazka2015;
    property skladnaradisledovane: TBlob read Fskladnaradisledovane write Fskladnaradisledovane;
    property Dochazka2015_mesic: TBlob read FDochazka2015_mesic write FDochazka2015_mesic;
    property agUlSkupinyOperaciView: TBlob read FagUlSkupinyOperaciView write FagUlSkupinyOperaciView;
    property GrafickyPrehledDenOP: TBlob read FGrafickyPrehledDenOP write FGrafickyPrehledDenOP;
    property agUlWorkerView: TBlob read FagUlWorkerView write FagUlWorkerView;
    property agUlCNCView: TBlob read FagUlCNCView write FagUlCNCView;
    property agUlObjednavkyPrijateView: TBlob read FagUlObjednavkyPrijateView write FagUlObjednavkyPrijateView;
    property agUlObjednavkyPrijatePolozkyView: TBlob read FagUlObjednavkyPrijatePolozkyView write FagUlObjednavkyPrijatePolozkyView;
    property objednavky_polozkyBezVazby: TBlob read Fobjednavky_polozkyBezVazby write Fobjednavky_polozkyBezVazby;
    property objednavky_polozkySubdodavky: TBlob read Fobjednavky_polozkySubdodavky write Fobjednavky_polozkySubdodavky;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('columns_backup')]
  [Description('Rozloen sloupc dbgridu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcolumns_backup = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('dochazka', [TColumnProp.Lazy])]
    [Description('')]
    Fdochazka: TBlob;
    
    [Column('worker', [TColumnProp.Lazy])]
    [Description('')]
    Fworker: TBlob;
    
    [Column('readdata', [TColumnProp.Lazy])]
    [Description('')]
    Freaddata: TBlob;
    
    [Column('skladmaterialu', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu: TBlob;
    
    [Column('customer', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer: TBlob;
    
    [Column('skladnaradi', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradi: TBlob;
    
    [Column('skladmaterialu_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_readdata: TBlob;
    
    [Column('stroje', [TColumnProp.Lazy])]
    [Description('')]
    Fstroje: TBlob;
    
    [Column('skladskupiny', [TColumnProp.Lazy])]
    [Description('')]
    Fskladskupiny: TBlob;
    
    [Column('skladnaradi_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradi_readdata: TBlob;
    
    [Column('skladnaradi_pohyb', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradi_pohyb: TBlob;
    
    [Column('skladmaterialu_prijemky1', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_prijemky1: TBlob;
    
    [Column('skladmaterialu_prijemky2', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_prijemky2: TBlob;
    
    [Column('repairtype', [TColumnProp.Lazy])]
    [Description('')]
    Frepairtype: TBlob;
    
    [Column('pausal', [TColumnProp.Lazy])]
    [Description('')]
    Fpausal: TBlob;
    
    [Column('orderwork_plan', [TColumnProp.Lazy])]
    [Description('')]
    Forderwork_plan: TBlob;
    
    [Column('orderstavy', [TColumnProp.Lazy])]
    [Description('')]
    Forderstavy: TBlob;
    
    [Column('operation_group', [TColumnProp.Lazy])]
    [Description('')]
    Foperation_group: TBlob;
    
    [Column('operation', [TColumnProp.Lazy])]
    [Description('')]
    Foperation: TBlob;
    
    [Column('cnc', [TColumnProp.Lazy])]
    [Description('')]
    Fcnc: TBlob;
    
    [Column('dodacilist1', [TColumnProp.Lazy])]
    [Description('')]
    Fdodacilist1: TBlob;
    
    [Column('dodacilist2', [TColumnProp.Lazy])]
    [Description('')]
    Fdodacilist2: TBlob;
    
    [Column('order_page1', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page1: TBlob;
    
    [Column('order_page2', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page2: TBlob;
    
    [Column('order_page3', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page3: TBlob;
    
    [Column('order_page4', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page4: TBlob;
    
    [Column('order_page5', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page5: TBlob;
    
    [Column('order_page6', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page6: TBlob;
    
    [Column('order_page7', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page7: TBlob;
    
    [Column('order_page8', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page8: TBlob;
    
    [Column('order_page9', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page9: TBlob;
    
    [Column('order_page10', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page10: TBlob;
    
    [Column('sort_settings', [TColumnProp.Lazy])]
    [Description('')]
    Fsort_settings: TBlob;
    
    [Column('application_setting', [TColumnProp.Lazy])]
    [Description('')]
    Fapplication_setting: TBlob;
    
    [Column('data_colection', [TColumnProp.Lazy])]
    [Description('')]
    Fdata_colection: TBlob;
    
    [Column('objednavky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky: TBlob;
    
    [Column('objednavky_polozky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozky: TBlob;
    
    [Column('objednavky_polozkyNaradi', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozkyNaradi: TBlob;
    
    [Column('materialy', [TColumnProp.Lazy])]
    [Description('')]
    Fmaterialy: TBlob;
    
    [Column('graficky_prehled', [TColumnProp.Lazy])]
    [Description('')]
    Fgraficky_prehled: TBlob;
    
    [Column('order_page11', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page11: TBlob;
    
    [Column('tech_postup', [TColumnProp.Lazy])]
    [Description('')]
    Ftech_postup: TBlob;
    
    [Column('tech_postup_polozky', [TColumnProp.Lazy])]
    [Description('')]
    Ftech_postup_polozky: TBlob;
    
    [Column('naradi_reader', [TColumnProp.Lazy])]
    [Description('')]
    Fnaradi_reader: TBlob;
    
    [Column('order_page12', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page12: TBlob;
    
    [Column('cidla_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fcidla_readdata: TBlob;
    
    [Column('sprava_zaznamu', [TColumnProp.Lazy])]
    [Description('')]
    Fsprava_zaznamu: TBlob;
    
    [Column('objednavky_prijate', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_prijate: TBlob;
    
    [Column('objednavky_prijate_polozky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_prijate_polozky: TBlob;
    
    [Column('order_page13', [TColumnProp.Lazy])]
    [Description('')]
    Forder_page13: TBlob;
    
    [Column('touchTerminal', [TColumnProp.Lazy])]
    [Description('')]
    FtouchTerminal: TBlob;
    
    [Column('hromadnyVydej', [TColumnProp.Lazy])]
    [Description('')]
    FhromadnyVydej: TBlob;
    
    [Column('KDatuOrder', [TColumnProp.Lazy])]
    [Description('')]
    FKDatuOrder: TBlob;
    
    [Column('KDatuOrderWork', [TColumnProp.Lazy])]
    [Description('')]
    FKDatuOrderWork: TBlob;
    
    [Column('hromadnyPohybNar', [TColumnProp.Lazy])]
    [Description('')]
    FhromadnyPohybNar: TBlob;
    
    [Column('CNCGroup', [TColumnProp.Lazy])]
    [Description('')]
    FCNCGroup: TBlob;
    
    [Column('StrojGroup', [TColumnProp.Lazy])]
    [Description('')]
    FStrojGroup: TBlob;
    
    [Column('customer_order', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer_order: TBlob;
    
    [Column('customer_osoby', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer_osoby: TBlob;
    
    [Column('skladmaterialu_vydejky1', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_vydejky1: TBlob;
    
    [Column('skladmaterialu_vydejky2', [TColumnProp.Lazy])]
    [Description('')]
    Fskladmaterialu_vydejky2: TBlob;
    
    [Column('customer_udalosti', [TColumnProp.Lazy])]
    [Description('')]
    Fcustomer_udalosti: TBlob;
    
    [Column('agUlAdresyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlAdresyView: TBlob;
    
    [Column('agUlSkladView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlSkladView: TBlob;
    
    [Column('agUlZakazkyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlZakazkyView: TBlob;
    
    [Column('agUlOperaceView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlOperaceView: TBlob;
    
    [Column('agUlSarzeView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlSarzeView: TBlob;
    
    [Column('PPSkladBlokace', [TColumnProp.Lazy])]
    [Description('')]
    FPPSkladBlokace: TBlob;
    
    [Column('PPSkladVyroba', [TColumnProp.Lazy])]
    [Description('')]
    FPPSkladVyroba: TBlob;
    
    [Column('PPSkladObjednavky', [TColumnProp.Lazy])]
    [Description('')]
    FPPSkladObjednavky: TBlob;
    
    [Column('PPMatBlokace', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatBlokace: TBlob;
    
    [Column('PPMatVyroba', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatVyroba: TBlob;
    
    [Column('PPMatObjednavky', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatObjednavky: TBlob;
    
    [Column('PPMatPBlokace', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatPBlokace: TBlob;
    
    [Column('PPMatPVyroba', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatPVyroba: TBlob;
    
    [Column('PPMatPObjednavky', [TColumnProp.Lazy])]
    [Description('')]
    FPPMatPObjednavky: TBlob;
    
    [Column('skladformy', [TColumnProp.Lazy])]
    [Description('')]
    Fskladformy: TBlob;
    
    [Column('skladformy_readdata', [TColumnProp.Lazy])]
    [Description('')]
    Fskladformy_readdata: TBlob;
    
    [Column('skladformy_pohyb', [TColumnProp.Lazy])]
    [Description('')]
    Fskladformy_pohyb: TBlob;
    
    [Column('SkladovePozice', [TColumnProp.Lazy])]
    [Description('')]
    FSkladovePozice: TBlob;
    
    [Column('SkladovePoziceReadData', [TColumnProp.Lazy])]
    [Description('')]
    FSkladovePoziceReadData: TBlob;
    
    [Column('SkladoveInventury', [TColumnProp.Lazy])]
    [Description('')]
    FSkladoveInventury: TBlob;
    
    [Column('SkladoveInventurySoupisy', [TColumnProp.Lazy])]
    [Description('')]
    FSkladoveInventurySoupisy: TBlob;
    
    [Column('SkladoveInventuryPolozky', [TColumnProp.Lazy])]
    [Description('')]
    FSkladoveInventuryPolozky: TBlob;
    
    [Column('agUlObjednavkyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlObjednavkyView: TBlob;
    
    [Column('PPZamDovednosti', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamDovednosti: TBlob;
    
    [Column('PPZamOperace', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamOperace: TBlob;
    
    [Column('PPZamCNC', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamCNC: TBlob;
    
    [Column('PPZamSkupiny', [TColumnProp.Lazy])]
    [Description('')]
    FPPZamSkupiny: TBlob;
    
    [Column('PPStrojeDefTypySer', [TColumnProp.Lazy])]
    [Description('')]
    FPPStrojeDefTypySer: TBlob;
    
    [Column('PPStrojePlanServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPStrojePlanServisy: TBlob;
    
    [Column('PPStrojeProvServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPStrojeProvServisy: TBlob;
    
    [Column('PPCNCDefTypySer', [TColumnProp.Lazy])]
    [Description('')]
    FPPCNCDefTypySer: TBlob;
    
    [Column('PPCNCPlanServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPCNCPlanServisy: TBlob;
    
    [Column('PPCNCProvServisy', [TColumnProp.Lazy])]
    [Description('')]
    FPPCNCProvServisy: TBlob;
    
    [Column('PPOperaceZam', [TColumnProp.Lazy])]
    [Description('')]
    FPPOperaceZam: TBlob;
    
    [Column('PPOperaceStroje', [TColumnProp.Lazy])]
    [Description('')]
    FPPOperaceStroje: TBlob;
    
    [Column('PPOperaceCNC', [TColumnProp.Lazy])]
    [Description('')]
    FPPOperaceCNC: TBlob;
    
    [Column('Dochazka2015', [TColumnProp.Lazy])]
    [Description('')]
    FDochazka2015: TBlob;
    
    [Column('skladnaradisledovane', [TColumnProp.Lazy])]
    [Description('')]
    Fskladnaradisledovane: TBlob;
    
    [Column('Dochazka2015_mesic', [TColumnProp.Lazy])]
    [Description('')]
    FDochazka2015_mesic: TBlob;
    
    [Column('agUlSkupinyOperaciView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlSkupinyOperaciView: TBlob;
    
    [Column('GrafickyPrehledDenOP', [TColumnProp.Lazy])]
    [Description('')]
    FGrafickyPrehledDenOP: TBlob;
    
    [Column('agUlWorkerView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlWorkerView: TBlob;
    
    [Column('agUlCNCView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlCNCView: TBlob;
    
    [Column('agUlObjednavkyPrijateView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlObjednavkyPrijateView: TBlob;
    
    [Column('agUlObjednavkyPrijatePolozkyView', [TColumnProp.Lazy])]
    [Description('')]
    FagUlObjednavkyPrijatePolozkyView: TBlob;
    
    [Column('objednavky_polozkyBezVazby', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozkyBezVazby: TBlob;
    
    [Column('objednavky_polozkySubdodavky', [TColumnProp.Lazy])]
    [Description('')]
    Fobjednavky_polozkySubdodavky: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property dochazka: TBlob read Fdochazka write Fdochazka;
    property worker: TBlob read Fworker write Fworker;
    property readdata: TBlob read Freaddata write Freaddata;
    property skladmaterialu: TBlob read Fskladmaterialu write Fskladmaterialu;
    property customer: TBlob read Fcustomer write Fcustomer;
    property skladnaradi: TBlob read Fskladnaradi write Fskladnaradi;
    property skladmaterialu_readdata: TBlob read Fskladmaterialu_readdata write Fskladmaterialu_readdata;
    property stroje: TBlob read Fstroje write Fstroje;
    property skladskupiny: TBlob read Fskladskupiny write Fskladskupiny;
    property skladnaradi_readdata: TBlob read Fskladnaradi_readdata write Fskladnaradi_readdata;
    property skladnaradi_pohyb: TBlob read Fskladnaradi_pohyb write Fskladnaradi_pohyb;
    property skladmaterialu_prijemky1: TBlob read Fskladmaterialu_prijemky1 write Fskladmaterialu_prijemky1;
    property skladmaterialu_prijemky2: TBlob read Fskladmaterialu_prijemky2 write Fskladmaterialu_prijemky2;
    property repairtype: TBlob read Frepairtype write Frepairtype;
    property pausal: TBlob read Fpausal write Fpausal;
    property orderwork_plan: TBlob read Forderwork_plan write Forderwork_plan;
    property orderstavy: TBlob read Forderstavy write Forderstavy;
    property operation_group: TBlob read Foperation_group write Foperation_group;
    property operation: TBlob read Foperation write Foperation;
    property cnc: TBlob read Fcnc write Fcnc;
    property dodacilist1: TBlob read Fdodacilist1 write Fdodacilist1;
    property dodacilist2: TBlob read Fdodacilist2 write Fdodacilist2;
    property order_page1: TBlob read Forder_page1 write Forder_page1;
    property order_page2: TBlob read Forder_page2 write Forder_page2;
    property order_page3: TBlob read Forder_page3 write Forder_page3;
    property order_page4: TBlob read Forder_page4 write Forder_page4;
    property order_page5: TBlob read Forder_page5 write Forder_page5;
    property order_page6: TBlob read Forder_page6 write Forder_page6;
    property order_page7: TBlob read Forder_page7 write Forder_page7;
    property order_page8: TBlob read Forder_page8 write Forder_page8;
    property order_page9: TBlob read Forder_page9 write Forder_page9;
    property order_page10: TBlob read Forder_page10 write Forder_page10;
    property sort_settings: TBlob read Fsort_settings write Fsort_settings;
    property application_setting: TBlob read Fapplication_setting write Fapplication_setting;
    property data_colection: TBlob read Fdata_colection write Fdata_colection;
    property objednavky: TBlob read Fobjednavky write Fobjednavky;
    property objednavky_polozky: TBlob read Fobjednavky_polozky write Fobjednavky_polozky;
    property objednavky_polozkyNaradi: TBlob read Fobjednavky_polozkyNaradi write Fobjednavky_polozkyNaradi;
    property materialy: TBlob read Fmaterialy write Fmaterialy;
    property graficky_prehled: TBlob read Fgraficky_prehled write Fgraficky_prehled;
    property order_page11: TBlob read Forder_page11 write Forder_page11;
    property tech_postup: TBlob read Ftech_postup write Ftech_postup;
    property tech_postup_polozky: TBlob read Ftech_postup_polozky write Ftech_postup_polozky;
    property naradi_reader: TBlob read Fnaradi_reader write Fnaradi_reader;
    property order_page12: TBlob read Forder_page12 write Forder_page12;
    property cidla_readdata: TBlob read Fcidla_readdata write Fcidla_readdata;
    property sprava_zaznamu: TBlob read Fsprava_zaznamu write Fsprava_zaznamu;
    property objednavky_prijate: TBlob read Fobjednavky_prijate write Fobjednavky_prijate;
    property objednavky_prijate_polozky: TBlob read Fobjednavky_prijate_polozky write Fobjednavky_prijate_polozky;
    property order_page13: TBlob read Forder_page13 write Forder_page13;
    property touchTerminal: TBlob read FtouchTerminal write FtouchTerminal;
    property hromadnyVydej: TBlob read FhromadnyVydej write FhromadnyVydej;
    property KDatuOrder: TBlob read FKDatuOrder write FKDatuOrder;
    property KDatuOrderWork: TBlob read FKDatuOrderWork write FKDatuOrderWork;
    property hromadnyPohybNar: TBlob read FhromadnyPohybNar write FhromadnyPohybNar;
    property CNCGroup: TBlob read FCNCGroup write FCNCGroup;
    property StrojGroup: TBlob read FStrojGroup write FStrojGroup;
    property customer_order: TBlob read Fcustomer_order write Fcustomer_order;
    property customer_osoby: TBlob read Fcustomer_osoby write Fcustomer_osoby;
    property skladmaterialu_vydejky1: TBlob read Fskladmaterialu_vydejky1 write Fskladmaterialu_vydejky1;
    property skladmaterialu_vydejky2: TBlob read Fskladmaterialu_vydejky2 write Fskladmaterialu_vydejky2;
    property customer_udalosti: TBlob read Fcustomer_udalosti write Fcustomer_udalosti;
    property agUlAdresyView: TBlob read FagUlAdresyView write FagUlAdresyView;
    property agUlSkladView: TBlob read FagUlSkladView write FagUlSkladView;
    property agUlZakazkyView: TBlob read FagUlZakazkyView write FagUlZakazkyView;
    property agUlOperaceView: TBlob read FagUlOperaceView write FagUlOperaceView;
    property agUlSarzeView: TBlob read FagUlSarzeView write FagUlSarzeView;
    property PPSkladBlokace: TBlob read FPPSkladBlokace write FPPSkladBlokace;
    property PPSkladVyroba: TBlob read FPPSkladVyroba write FPPSkladVyroba;
    property PPSkladObjednavky: TBlob read FPPSkladObjednavky write FPPSkladObjednavky;
    property PPMatBlokace: TBlob read FPPMatBlokace write FPPMatBlokace;
    property PPMatVyroba: TBlob read FPPMatVyroba write FPPMatVyroba;
    property PPMatObjednavky: TBlob read FPPMatObjednavky write FPPMatObjednavky;
    property PPMatPBlokace: TBlob read FPPMatPBlokace write FPPMatPBlokace;
    property PPMatPVyroba: TBlob read FPPMatPVyroba write FPPMatPVyroba;
    property PPMatPObjednavky: TBlob read FPPMatPObjednavky write FPPMatPObjednavky;
    property skladformy: TBlob read Fskladformy write Fskladformy;
    property skladformy_readdata: TBlob read Fskladformy_readdata write Fskladformy_readdata;
    property skladformy_pohyb: TBlob read Fskladformy_pohyb write Fskladformy_pohyb;
    property SkladovePozice: TBlob read FSkladovePozice write FSkladovePozice;
    property SkladovePoziceReadData: TBlob read FSkladovePoziceReadData write FSkladovePoziceReadData;
    property SkladoveInventury: TBlob read FSkladoveInventury write FSkladoveInventury;
    property SkladoveInventurySoupisy: TBlob read FSkladoveInventurySoupisy write FSkladoveInventurySoupisy;
    property SkladoveInventuryPolozky: TBlob read FSkladoveInventuryPolozky write FSkladoveInventuryPolozky;
    property agUlObjednavkyView: TBlob read FagUlObjednavkyView write FagUlObjednavkyView;
    property PPZamDovednosti: TBlob read FPPZamDovednosti write FPPZamDovednosti;
    property PPZamOperace: TBlob read FPPZamOperace write FPPZamOperace;
    property PPZamCNC: TBlob read FPPZamCNC write FPPZamCNC;
    property PPZamSkupiny: TBlob read FPPZamSkupiny write FPPZamSkupiny;
    property PPStrojeDefTypySer: TBlob read FPPStrojeDefTypySer write FPPStrojeDefTypySer;
    property PPStrojePlanServisy: TBlob read FPPStrojePlanServisy write FPPStrojePlanServisy;
    property PPStrojeProvServisy: TBlob read FPPStrojeProvServisy write FPPStrojeProvServisy;
    property PPCNCDefTypySer: TBlob read FPPCNCDefTypySer write FPPCNCDefTypySer;
    property PPCNCPlanServisy: TBlob read FPPCNCPlanServisy write FPPCNCPlanServisy;
    property PPCNCProvServisy: TBlob read FPPCNCProvServisy write FPPCNCProvServisy;
    property PPOperaceZam: TBlob read FPPOperaceZam write FPPOperaceZam;
    property PPOperaceStroje: TBlob read FPPOperaceStroje write FPPOperaceStroje;
    property PPOperaceCNC: TBlob read FPPOperaceCNC write FPPOperaceCNC;
    property Dochazka2015: TBlob read FDochazka2015 write FDochazka2015;
    property skladnaradisledovane: TBlob read Fskladnaradisledovane write Fskladnaradisledovane;
    property Dochazka2015_mesic: TBlob read FDochazka2015_mesic write FDochazka2015_mesic;
    property agUlSkupinyOperaciView: TBlob read FagUlSkupinyOperaciView write FagUlSkupinyOperaciView;
    property GrafickyPrehledDenOP: TBlob read FGrafickyPrehledDenOP write FGrafickyPrehledDenOP;
    property agUlWorkerView: TBlob read FagUlWorkerView write FagUlWorkerView;
    property agUlCNCView: TBlob read FagUlCNCView write FagUlCNCView;
    property agUlObjednavkyPrijateView: TBlob read FagUlObjednavkyPrijateView write FagUlObjednavkyPrijateView;
    property agUlObjednavkyPrijatePolozkyView: TBlob read FagUlObjednavkyPrijatePolozkyView write FagUlObjednavkyPrijatePolozkyView;
    property objednavky_polozkyBezVazby: TBlob read Fobjednavky_polozkyBezVazby write Fobjednavky_polozkyBezVazby;
    property objednavky_polozkySubdodavky: TBlob read Fobjednavky_polozkySubdodavky write Fobjednavky_polozkySubdodavky;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('columns_caption')]
  [Description('')]
  [Id('FformName', TIdGenerator.None)]
  [Id('FgridName', TIdGenerator.None)]
  [Id('FfieldName', TIdGenerator.None)]
  [Id('FlanguageCode', TIdGenerator.None)]
  Tcolumns_caption = class(TTMSAGObject)
  private
    [Column('formName', [TColumnProp.Required], 200)]
    [Description('')]
    FformName: string;
    
    [Column('gridName', [TColumnProp.Required], 200)]
    [Description('')]
    FgridName: string;
    
    [Column('fieldName', [TColumnProp.Required], 200)]
    [Description('')]
    FfieldName: string;
    
    [Column('languageCode', [TColumnProp.Required], 20)]
    [Description('')]
    FlanguageCode: string;
    
    [Column('columnCaption', [TColumnProp.Required], 200)]
    [Description('')]
    FcolumnCaption: string;
    
    [Column('columnHint', [TColumnProp.Required], 200)]
    [Description('')]
    FcolumnHint: string;
    
    [Column('columnCaptionUser', [TColumnProp.Required], 200)]
    [Description('')]
    FcolumnCaptionUser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property formName: string read FformName write FformName;
    property gridName: string read FgridName write FgridName;
    property fieldName: string read FfieldName write FfieldName;
    property languageCode: string read FlanguageCode write FlanguageCode;
    property columnCaption: string read FcolumnCaption write FcolumnCaption;
    property columnHint: string read FcolumnHint write FcolumnHint;
    property columnCaptionUser: string read FcolumnCaptionUser write FcolumnCaptionUser;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('columns_change_type')]
  [Description('Pevod cloupc z TDbGrid do cxGrid')]
  [Id('Fcolumnfieldname', TIdGenerator.None)]
  [Id('Fuser_id', TIdGenerator.None)]
  Tcolumns_change_type = class(TTMSAGObject)
  private
    [Column('columnfieldname', [TColumnProp.Required], 50)]
    [Description('')]
    Fcolumnfieldname: string;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('column_type', [TColumnProp.Required])]
    [Description('')]
    Fcolumn_type: Integer;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property columnfieldname: string read Fcolumnfieldname write Fcolumnfieldname;
    property user_id: Integer read Fuser_id write Fuser_id;
    property column_type: Integer read Fcolumn_type write Fcolumn_type;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('columns_log')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcolumns_log = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('qry_name', [], 50)]
    [Description('')]
    Fqry_name: Nullable<string>;
    
    [Column('datum_zmeny', [TColumnProp.Required])]
    [Description('')]
    Fdatum_zmeny: TDateTime;
    
    [Column('field_name', [], 50)]
    [Description('')]
    Ffield_name: Nullable<string>;
    
    [Column('original_caption', [], 80)]
    [Description('')]
    Foriginal_caption: Nullable<string>;
    
    [Column('actual_caption', [], 80)]
    [Description('')]
    Factual_caption: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property qry_name: Nullable<string> read Fqry_name write Fqry_name;
    property datum_zmeny: TDateTime read Fdatum_zmeny write Fdatum_zmeny;
    property field_name: Nullable<string> read Ffield_name write Ffield_name;
    property original_caption: Nullable<string> read Foriginal_caption write Foriginal_caption;
    property actual_caption: Nullable<string> read Factual_caption write Factual_caption;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('config')]
  [Description('Tabulka dochazky zamestnancu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tconfig = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('dochazka_format', [TColumnProp.Required], 20)]
    [Description('')]
    Fdochazka_format: string;
    
    [Column('dochazka_autobreak', [TColumnProp.Required], 20)]
    [Description('')]
    Fdochazka_autobreak: string;
    
    [Column('dochazka_autobreak_podmina', [TColumnProp.Required], 20)]
    [Description('')]
    Fdochazka_autobreak_podmina: string;
    
    [Column('price_calculate', [TColumnProp.Required], 20)]
    [Description('')]
    Fprice_calculate: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property dochazka_format: string read Fdochazka_format write Fdochazka_format;
    property dochazka_autobreak: string read Fdochazka_autobreak write Fdochazka_autobreak;
    property dochazka_autobreak_podmina: string read Fdochazka_autobreak_podmina write Fdochazka_autobreak_podmina;
    property price_calculate: string read Fprice_calculate write Fprice_calculate;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('customer')]
  [Description('Zakaznici')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcustomer = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('name', [TColumnProp.Required], 150)]
    [Description('')]
    Fname: string;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('adress', [TColumnProp.Required], 100)]
    [Description('')]
    Fadress: string;

    [Column('phone', [TColumnProp.Required], 50)]
    [Description('')]
    Fphone: string;
    
    [Column('fax', [TColumnProp.Required], 50)]
    [Description('')]
    Ffax: string;
    
    [Column('mobile', [TColumnProp.Required], 50)]
    [Description('')]
    Fmobile: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('fak_adress', [TColumnProp.Required], 100)]
    [Description('')]
    Ffak_adress: string;
    
    [Column('fak_psc', [TColumnProp.Required], 10)]
    [Description('')]
    Ffak_psc: string;
    
    [Column('fak_mesto', [TColumnProp.Required], 100)]
    [Description('')]
    Ffak_mesto: string;
    
    [Column('ico', [TColumnProp.Required], 20)]
    [Description('')]
    Fico: string;
    
    [Column('dic', [TColumnProp.Required], 20)]
    [Description('')]
    Fdic: string;
    
    [Column('osoba', [TColumnProp.Required], 100)]
    [Description('')]
    Fosoba: string;
    
    [Column('ucet', [TColumnProp.Required], 100)]
    [Description('')]
    Fucet: string;
    
    [Column('banka', [TColumnProp.Required], 100)]
    [Description('')]
    Fbanka: string;
    
    [Column('email', [TColumnProp.Required], 100)]
    [Description('')]
    Femail: string;
    
    [Column('web', [TColumnProp.Required], 100)]
    [Description('')]
    Fweb: string;
    
    [Column('typ', [TColumnProp.Required])]
    [Description('')]
    Ftyp: Integer;
    
    [Column('dod_psc', [TColumnProp.Required], 10)]
    [Description('')]
    Fdod_psc: string;
    
    [Column('dod_mesto', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_mesto: string;
    
    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;
    
    [Column('barvaPlanu', [])]
    [Description('')]
    FbarvaPlanu: Nullable<Integer>;
    
    [Column('dod_osoba', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_osoba: string;
    
    [Column('dod_stat', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_stat: string;

    [Column('fak_firma', [TColumnProp.Required], 150)]
    [Description('')]
    Ffak_firma: string;
    
    [Column('fak_osoba', [TColumnProp.Required], 100)]
    [Description('')]
    Ffak_osoba: string;
    
    [Column('dod_firma', [TColumnProp.Required], 150)]
    [Description('')]
    Fdod_firma: string;
    
    [Column('fak_oddeleni', [TColumnProp.Required], 100)]
    [Description('')]
    Ffak_oddeleni: string;
    
    [Column('dod_oddeleni', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_oddeleni: string;
    
    [Column('fak_phone', [TColumnProp.Required], 50)]
    [Description('')]
    Ffak_phone: string;
    
    [Column('fak_email', [TColumnProp.Required], 100)]
    [Description('')]
    Ffak_email: string;
    
    [Column('fak_stat', [TColumnProp.Required], 100)]
    [Description('')]
    Ffak_stat: string;
    
    [Column('email_odesilat', [TColumnProp.Required])]
    [Description('')]
    Femail_odesilat: Boolean;
    
    [Column('splatnost_dni', [TColumnProp.Required])]
    [Description('')]
    Fsplatnost_dni: Integer;
    
    [Column('doprava', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoprava: string;
    
    [Column('platba', [TColumnProp.Required], 50)]
    [Description('')]
    Fplatba: string;
    
    [Column('dorucenifaktury', [TColumnProp.Required], 50)]
    [Description('')]
    Fdorucenifaktury: string;
    
    [Column('forma', [], 10)]
    [Description('')]
    Fforma: string;
    
    [Column('gdpr_zbyva', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_zbyva: Boolean;
    
    [Column('gdpr_anonymizovano', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_anonymizovano: Boolean;
    
    [Column('prima_dodaci_adresa', [TColumnProp.Required])]
    [Description('')]
    Fprima_dodaci_adresa: Boolean;
    
    [Column('icdph', [TColumnProp.Required], 20)]
    [Description('')]
    Ficdph: string;
    
    [Column('oblast', [TColumnProp.Required])]
    [Description('')]
    Foblast: Integer;
    
    [Column('note2', [TColumnProp.Lazy])]
    [Description('')]
    Fnote2: string;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('doprava_id', [], 'id')]
    [Description('')]
    Fdoprava_id: proxy<Tzpusob_dopravy>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('platba_id', [], 'id')]
    [Description('')]
    Fplatba_id: proxy<Tzpusob_platby>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cm_mena', [], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('group_id', [], 'id')]
    [Description('')]
    Fgroup_id: proxy<Tcustomer_skupiny>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('nadrizena_id', [], 'id')]
    [Description('')]
    Fnadrizena_id: proxy<Tcustomer>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcustomer_id')]
    //  [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Foperation_id')]
    Fcustomer_adresyList: Proxy<TList<Tcustomer_adresy>>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcustomer_id')]
    Fcustomer_osobyList: Proxy<TList<Tcustomer_osoby>>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcustomer_id')]
    Fcustomer_udalostiList: Proxy<TList<Tcustomer_udalosti>>;
    function Getcustomer_adresyList: TList<Tcustomer_adresy>;
    function Getcustomer_osobyList: TList<Tcustomer_osoby>;
    function Getcustomer_udalostiList: TList<Tcustomer_udalosti>;
    function getdoprava_id: Tzpusob_dopravy;
    procedure setdoprava_id(const Value : Tzpusob_dopravy);
    function getplatba_id: Tzpusob_platby;
    procedure setplatba_id(const Value : Tzpusob_platby);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function getgroup_id: Tcustomer_skupiny;
    procedure setgroup_id(const Value : Tcustomer_skupiny);
    function getnadrizena_id: Tcustomer;
    procedure setnadrizena_id(const Value : Tcustomer);
    procedure setosoba(const Value : string);
    procedure setname(const Value : string);
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure checkNewRecord; override;
    function CheckRequiredFields : boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    property id: Int64 read Fid write Fid;
    property name: string read Fname write setname;
    property bar_id: string read Fbar_id write Fbar_id;
    property adress: string read Fadress write Fadress;
    property phone: string read Fphone write Fphone;
    property fax: string read Ffax write Ffax;
    property mobile: string read Fmobile write Fmobile;
    property note: string read Fnote write Fnote;
    property user: string read Fuser write Fuser;
    property fak_adress: string read Ffak_adress write Ffak_adress;
    property fak_psc: string read Ffak_psc write Ffak_psc;
    property fak_mesto: string read Ffak_mesto write Ffak_mesto;
    property ico: string read Fico write Fico;
    property dic: string read Fdic write Fdic;
    property osoba: string read Fosoba write setosoba;
    property ucet: string read Fucet write Fucet;
    property banka: string read Fbanka write Fbanka;
    property email: string read Femail write Femail;
    property web: string read Fweb write Fweb;
    property typ: Integer read Ftyp write Ftyp;
    property dod_psc: string read Fdod_psc write Fdod_psc;
    property dod_mesto: string read Fdod_mesto write Fdod_mesto;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property barvaPlanu: Nullable<Integer> read FbarvaPlanu write FbarvaPlanu;
    property dod_osoba: string read Fdod_osoba write Fdod_osoba;
    property dod_stat: string read Fdod_stat write Fdod_stat;
    property fak_firma: string read Ffak_firma write Ffak_firma;
    property fak_osoba: string read Ffak_osoba write Ffak_osoba;
    property dod_firma: string read Fdod_firma write Fdod_firma;
    property fak_oddeleni: string read Ffak_oddeleni write Ffak_oddeleni;
    property dod_oddeleni: string read Fdod_oddeleni write Fdod_oddeleni;
    property fak_phone: string read Ffak_phone write Ffak_phone;
    property fak_email: string read Ffak_email write Ffak_email;
    property fak_stat: string read Ffak_stat write Ffak_stat;
    property email_odesilat: Boolean read Femail_odesilat write Femail_odesilat;
    property splatnost_dni: Integer read Fsplatnost_dni write Fsplatnost_dni;
    property doprava: string read Fdoprava write Fdoprava;
    property platba: string read Fplatba write Fplatba;
    property dorucenifaktury: string read Fdorucenifaktury write Fdorucenifaktury;
    property forma: string read Fforma write Fforma;
    property gdpr_zbyva: Boolean read Fgdpr_zbyva write Fgdpr_zbyva;
    property gdpr_anonymizovano: Boolean read Fgdpr_anonymizovano write Fgdpr_anonymizovano;
    property prima_dodaci_adresa: Boolean read Fprima_dodaci_adresa write Fprima_dodaci_adresa;
    property icdph: string read Ficdph write Ficdph;
    property oblast: Integer read Foblast write Foblast;
    property note2: string read Fnote2 write Fnote2;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
    property doprava_id: Tzpusob_dopravy read getdoprava_id write setdoprava_id;
    property platba_id: Tzpusob_platby read getplatba_id write setplatba_id;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property group_id: Tcustomer_skupiny read getgroup_id write setgroup_id;
    property nadrizena_id: Tcustomer read getnadrizena_id write setnadrizena_id;
    property customer_adresyList: TList<Tcustomer_adresy> read Getcustomer_adresyList;
    property customer_osobyList: TList<Tcustomer_osoby> read Getcustomer_osobyList;
    property customer_udalostiList: TList<Tcustomer_udalosti> read Getcustomer_udalostiList;
  end;

  [Entity]
  [Table('customer_adresy')]
  [Description('Dodac adresy pro zkaznky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcustomer_adresy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('dod_osoba', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_osoba: string;
    
    [Column('dod_ulice', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_ulice: string;
    
    [Column('dod_mesto', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_mesto: string;

    [Column('dod_psc', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_psc: string;

    [Column('dod_stat', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_stat: string;

    [Column('dod_email', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_email: string;

    [Column('dod_telefon', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_telefon: string;

    [Column('dod_mobil', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_mobil: string;

    [Column('dod_fax', [TColumnProp.Required], 100)]
    [Description('')]
    Fdod_fax: string;

    [Column('dod_note', [TColumnProp.Required], 300)]
    [Description('')]
    Fdod_note: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('customer_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;

    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property dod_osoba: string read Fdod_osoba write Fdod_osoba;
    property dod_ulice: string read Fdod_ulice write Fdod_ulice;
    property dod_mesto: string read Fdod_mesto write Fdod_mesto;
    property dod_psc: string read Fdod_psc write Fdod_psc;
    property dod_stat : string read Fdod_stat write Fdod_stat;
    property dod_email: string read Fdod_email write Fdod_email;
    property dod_telefon: string read Fdod_telefon write Fdod_telefon;
    property dod_mobil: string read Fdod_mobil write Fdod_mobil;
    property dod_fax: string read Fdod_fax write Fdod_fax;
    property dod_note: string read Fdod_note write Fdod_note;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
  end;
  
  [Entity]
  [Table('customer_osoby')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcustomer_osoby = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('jmeno', [], 45)]
    [Description('')]
    Fjmeno: string;

    [Column('prijmeni', [], 45)]
    [Description('')]
    Fprijmeni: string;
    
    [Column('telefon', [], 45)]
    [Description('')]
    Ftelefon: Nullable<string>;
    
    [Column('email', [], 45)]
    [Description('')]
    Femail: Nullable<string>;
    
    [Column('poznamka', [], 250)]
    [Description('')]
    Fpoznamka: Nullable<string>;
    
    [Column('vychozi', [])]
    [Description('')]
    Fvychozi: Nullable<Integer>;
    
    [Column('hierarchie', [])]
    [Description('')]
    Fhierarchie: Nullable<Integer>;
    
    [Column('externi_id', [], 100)]
    [Description('')]
    Fexterni_id: Nullable<string>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('customer_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property jmeno: string read Fjmeno write Fjmeno;
    property prijmeni: string read Fprijmeni write Fprijmeni;
    property telefon: Nullable<string> read Ftelefon write Ftelefon;
    property email: Nullable<string> read Femail write Femail;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property vychozi: Nullable<Integer> read Fvychozi write Fvychozi;
    property hierarchie: Nullable<Integer> read Fhierarchie write Fhierarchie;
    property externi_id: Nullable<string> read Fexterni_id write Fexterni_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
  end;
  
  [Entity]
  [Table('customer_skupiny')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcustomer_skupiny = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;
    
    [Column('parent_id', [TColumnProp.Required])]
    [Description('')]
    Fparent_id: Integer;
    
    [Column('zkratka', [TColumnProp.Required], 200)]
    [Description('')]
    Fzkratka: string;
    
    [Column('note', [TColumnProp.Required], 1024)]
    [Description('')]
    Fnote: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    FDynCon: TDynamicProperties;
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property parent_id: Integer read Fparent_id write Fparent_id;
    property zkratka: string read Fzkratka write Fzkratka;
    property note: string read Fnote write Fnote;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('customer_udalosti')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcustomer_udalosti = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('typ', [])]
    [Description('')]
    Ftyp: Integer;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: Nullable<TDateTime>;

    [Column('predmet', [TColumnProp.Required], 45)]
    [Description('')]
    Fpredmet: string;

    [Column('popis', [], 500)]
    [Description('')]
    Fpopis: Nullable<string>;
    
    [Column('order_id', [], 100)]
    [Description('')]
    Forder_id: Nullable<string>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('customer_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
    function gettyp2 : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property typ: Integer read Ftyp write Ftyp;
    property typ2: string read gettyp2;
    property datum: Nullable<TDateTime> read Fdatum write Fdatum;
    property predmet: string read Fpredmet write Fpredmet;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property order_id: Nullable<string> read Forder_id write Forder_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
  end;
  
  [Entity]
  [Table('customer_udalosti_typy')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcustomer_udalosti_typy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 45)]
    [Description('')]
    Fnazev: string;
    
    [Column('popis', [], 45)]
    [Description('')]
    Fpopis: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('c_order')]
  [Description('Zakzky')]
  [UniqueKey('bar_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tc_order = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('parent_id', [TColumnProp.Required])]
    [Description('')]
    Fparent_id: Int64;
    
    [Column('code', [TColumnProp.Required], 100)]
    [Description('')]
    Fcode: string;
    
    [Column('customer_id', [TColumnProp.Required])]
    [Description('')]
    Fcustomer_id: Int64;
    
    [Column('note', [])]
    [Description('')]
    Fnote: string;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('customer_name', [TColumnProp.Required], 200)]
    [Description('')]
    Fcustomer_name: string;
    
    [Column('active', [TColumnProp.Required], 20)]
    [Description('')]
    Factive: string;
    
    [Column('user_time', [TColumnProp.Required])]
    [Description('')]
    Fuser_time: Integer;
    
    [Column('user_price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fuser_price: Double;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('typ', [TColumnProp.Required])]
    [Description('')]
    Ftyp: Integer;
    
    [Column('real_time', [TColumnProp.Required])]
    [Description('')]
    Freal_time: Integer;
    
    [Column('real_price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Freal_price: Double;
    
    [Column('created', [TColumnProp.Required], 50)]
    [Description('')]
    Fcreated: string;
    
    [Column('kusu', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkusu: Double;

    [Column('last_op', [TColumnProp.Required])]
    [Description('')]
    Flast_op: Int64;
    
    [Column('drawing', [TColumnProp.Required], 200)]
    [Description('')]
    Fdrawing: string;

    [Column('note2', [])]
    [Description('')]
    Fnote2: string;

    [Column('cislo_objednavky', [TColumnProp.Required], 25)]
    [Description('')]
    Fcislo_objednavky: string;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    [Column('montaz_date', [TColumnProp.Required])]
    [Description('')]
    Fmontaz_date: TDateTime;

    [Column('montaz_time', [TColumnProp.Required])]
    [Description('')]
    Fmontaz_time: Integer;

    [Column('prevedeno', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprevedeno: Double;
    
    [Column('expandovano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fexpandovano: Double;

    [Column('int_bar_id', [TColumnProp.Required])]
    [Description('')]
    Fint_bar_id: Int64;

    [Column('oken_unit', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Foken_unit: Double;

    [Column('user_time_order', [TColumnProp.Required])]
    [Description('')]
    Fuser_time_order: Integer;
    
    [Column('vypocteno_vyrobeno', [TColumnProp.Required])]
    [Description('')]
    Fvypocteno_vyrobeno: Integer;

    [Column('user_time_ks_second', [TColumnProp.Required])]
    [Description('')]
    Fuser_time_ks_second: Integer;
    
    [Column('note_nabidka', [])]
    [Description('')]
    Fnote_nabidka: string;

    [Column('price_ukony', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_ukony: Double;
    
    [Column('volitelna1', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna1: string;
    
    [Column('volitelna2', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna2: string;

    [Column('volitelna3', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna3: string;
    
    [Column('volitelna4', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna4: string;
    
    [Column('volitelna5', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna5: string;

    [Column('volitelna6', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna6: string;
    
    [Column('volitelna7', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna7: string;
    
    [Column('volitelna8', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna8: string;

    [Column('volitelna9', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna9: string;
    
    [Column('volitelna10', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna10: string;
    
    [Column('volitelna11', [], 200)]
    [Description('')]
    Fvolitelna11: Nullable<string>;

    [Column('volitelna12', [], 200)]
    [Description('')]
    Fvolitelna12: Nullable<string>;
    
    [Column('pocetKlt', [TColumnProp.Required])]
    [Description('')]
    FpocetKlt: Integer;
    
    [Column('user_price_mat', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fuser_price_mat: Double;

    [Column('user_price_sub', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fuser_price_sub: Double;
    
    [Column('user_price_work', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fuser_price_work: Double;
    
    [Column('ukon1_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon1_planks: Double;

    [Column('ukon2_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon2_planks: Double;

    [Column('ukon3_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon3_planks: Double;
    
    [Column('ukon4_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon4_planks: Double;

    [Column('ukon5_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon5_planks: Double;
    
    [Column('ukon6_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon6_planks: Double;
    
    [Column('ukon7_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon7_planks: Double;

    [Column('ukon8_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon8_planks: Double;
    
    [Column('ukon9_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon9_planks: Double;
    
    [Column('ukon10_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon10_planks: Double;

    [Column('ukon11_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon11_planks: Double;
    
    [Column('ukon12_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon12_planks: Double;
    
    [Column('ukon13_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon13_planks: Double;

    [Column('ukon14_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon14_planks: Double;
    
    [Column('ukon15_planks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon15_planks: Double;
    
    [Column('ukon1_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon1_vyrobenoks: Double;

    [Column('ukon2_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon2_vyrobenoks: Double;
    
    [Column('ukon3_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon3_vyrobenoks: Double;
    
    [Column('ukon4_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon4_vyrobenoks: Double;

    [Column('ukon5_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon5_vyrobenoks: Double;
    
    [Column('ukon6_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon6_vyrobenoks: Double;
    
    [Column('ukon7_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon7_vyrobenoks: Double;

    [Column('ukon8_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon8_vyrobenoks: Double;
    
    [Column('ukon9_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon9_vyrobenoks: Double;
    
    [Column('ukon10_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon10_vyrobenoks: Double;

    [Column('ukon11_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon11_vyrobenoks: Double;
    
    [Column('ukon12_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon12_vyrobenoks: Double;
    
    [Column('ukon13_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon13_vyrobenoks: Double;

    [Column('ukon14_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon14_vyrobenoks: Double;
    
    [Column('ukon15_vyrobenoks', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon15_vyrobenoks: Double;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('volitelna13', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna13: string;
    
    [Column('plan_kalendar', [TColumnProp.Required])]
    [Description('')]
    Fplan_kalendar: Integer;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;
    
    [Column('techpostup_id', [TColumnProp.Required])]
    [Description('')]
    Ftechpostup_id: Int64;
    
    [Column('ciselna_volitelna1', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fciselna_volitelna1: Double;

    [Column('ciselna_volitelna2', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fciselna_volitelna2: Double;
    
    [Column('unirec', [], 256)]
    [Description('')]
    Funirec: Nullable<string>;
    
    [Column('volitelna14', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna14: string;

    [Column('datumcaszmeny', [TColumnProp.Required])]
    [Description('')]
    Fdatumcaszmeny: TDateTime;
    
    [Column('datumova_volitelna1', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna1: TDateTime;
    
    [Column('datumova_volitelna2', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna2: TDateTime;

    [Column('datumova_volitelna3', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna3: TDateTime;
    
    [Column('datumova_volitelna4', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna4: TDateTime;
    
    [Column('koeficient_on', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fkoeficient_on: Double;

    [Column('odmeny_predpoklad', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fodmeny_predpoklad: Double;
    
    [Column('odmeny_vyuctovano', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fodmeny_vyuctovano: Double;
    
    [Column('externi_faktura', [], 100)]
    [Description('')]
    Fexterni_faktura: Nullable<string>;

    [Column('vykres_ze_souboru', [TColumnProp.Required])]
    [Description('')]
    Fvykres_ze_souboru: Integer;
    
    [Column('datumExpedice', [TColumnProp.Required])]
    [Description('')]
    FdatumExpedice: TDateTime;
    
    [Column('zpusob_dopravy_id', [TColumnProp.Required])]
    [Description('')]
    Fzpusob_dopravy_id: Int64;

    [Column('baliku1', [TColumnProp.Required])]
    [Description('')]
    Fbaliku1: Integer;
    
    [Column('baliku2', [TColumnProp.Required])]
    [Description('')]
    Fbaliku2: Integer;
    
    [Column('baliku3', [TColumnProp.Required])]
    [Description('')]
    Fbaliku3: Integer;

    [Column('email_upozornovat', [TColumnProp.Required])]
    [Description('')]
    Femail_upozornovat: Integer;
    
    [Column('sklad_group_id', [TColumnProp.Required])]
    [Description('')]
    Fsklad_group_id: Integer;
    
    [Column('operation_group_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_group_id: Integer;

    [Column('dispTree', [TColumnProp.Required], 72)]
    [Description('')]
    FdispTree: string;
    
    [Column('uroven', [TColumnProp.Required])]
    [Description('')]
    Furoven: Integer;
    
    [Column('masterOrderId', [TColumnProp.Required])]
    [Description('')]
    FmasterOrderId: Integer;
    
    [Column('customer_id_adresa', [TColumnProp.Required])]
    [Description('')]
    Fcustomer_id_adresa: Integer;
    
    [Column('ciselna_volitelna3', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fciselna_volitelna3: Double;

    [Column('id_pohoda', [TColumnProp.Required], 100)]
    [Description('')]
    Fid_pohoda: string;
    
    [Column('startVyroba', [TColumnProp.Required])]
    [Description('')]
    FstartVyroba: TDateTime;

    [Column('finishVyroba', [TColumnProp.Required])]
    [Description('')]
    FfinishVyroba: TDateTime;

    [Column('viceprace', [TColumnProp.Required])]
    [Description('')]
    Fviceprace: Integer;
    
    [Column('unit', [TColumnProp.Required])]
    [Description('')]
    Funit_: Integer;

    [Column('rozmer1', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Frozmer1: Double;

    [Column('rozmer2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Frozmer2: Double;

    [Column('rozmer3', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Frozmer3: Double;

    [Column('order_cena_jednotka', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Forder_cena_jednotka: Double;

    [Column('ciselna_volitelna4', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fciselna_volitelna4: Double;

    [Column('volitelna15', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna15: string;

    [Column('volitelna16', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna16: string;

    [Column('typ_vypoctu_ceny', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu_ceny: Integer;

    [Column('real_price2', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Freal_price2: Double;

    [Column('gdpr_zbyva', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_zbyva: Integer;

    [Column('gdpr_anonymizovano', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_anonymizovano: Integer;

    [Column('druha_mena_zkratka', [TColumnProp.Required], 50)]
    [Description('')]
    Fdruha_mena_zkratka: string;

    [Column('real_mzda', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Freal_mzda: Double;

    [Column('force_prepocet', [TColumnProp.Required])]
    [Description('')]
    Fforce_prepocet: Integer;

    [Column('id_ciselna_rada', [TColumnProp.Required])]
    [Description('')]
    Fid_ciselna_rada: Integer;

    [Column('prefix_ciselna_rada', [TColumnProp.Required], 50)]
    [Description('')]
    Fprefix_ciselna_rada: string;

    [Column('is_sablona', [TColumnProp.Required])]
    [Description('')]
    Fis_sablona: Integer;

    [Column('ciselna_volitelna5', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fciselna_volitelna5: Double;

    [Column('ciselna_volitelna6', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fciselna_volitelna6: Double;

    [Column('drawing_revision', [TColumnProp.Required], 20)]
    [Description('')]
    Fdrawing_revision: string;

    [Column('export_datetime', [TColumnProp.Required])]
    [Description('')]
    Fexport_datetime: TDateTime;

    [Column('sablony_kod', [TColumnProp.Required], 250)]
    [Description('')]
    Fsablony_kod: string;

    [Column('sablony_datetime', [])]
    [Description('')]
    Fsablony_datetime: Nullable<TDateTime>;

    [Column('use_orderwork_time', [TColumnProp.Required])]
    [Description('')]
    Fuse_orderwork_time: Integer;

    [Column('start_req', [TColumnProp.Required])]
    [Description('')]
    Fstart_req: TDateTime;

    [Column('finish_req', [TColumnProp.Required])]
    [Description('')]
    Ffinish_req: TDateTime;

    [Column('start_real', [TColumnProp.Required])]
    [Description('')]
    Fstart_real: TDateTime;

    [Column('finish_real', [TColumnProp.Required])]
    [Description('')]
    Ffinish_real: TDateTime;

    [Column('ep_typ_planu_ID', [TColumnProp.Required])]
    [Description('')]
    Fep_typ_planu_ID: Integer;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('created_mat_id', [TColumnProp.Required], 'id')]
    [Description('')]
    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    Fcreated_mat_id: proxy<Tsklad_material>;
    
    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Forder_id')]
    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    Forder_workList: Proxy<TList<Torder_work>>;

    function Getorder_workList: TList<Torder_work>;
    function getcreated_mat_id: Tsklad_material;
    procedure setcreated_mat_id(const Value : Tsklad_material);
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property parent_id: Int64 read Fparent_id write Fparent_id;
    property code: string read Fcode write Fcode;
    property customer_id: Int64 read Fcustomer_id write Fcustomer_id;
    property note: string read Fnote write Fnote;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property customer_name: string read Fcustomer_name write Fcustomer_name;
    property active: string read Factive write Factive;
    property user_time: Integer read Fuser_time write Fuser_time;
    property user_price: Double read Fuser_price write Fuser_price;
    property user: string read Fuser write Fuser;
    property typ: Integer read Ftyp write Ftyp;
    property real_time: Integer read Freal_time write Freal_time;
    property real_price: Double read Freal_price write Freal_price;
    property created: string read Fcreated write Fcreated;
    property kusu: Double read Fkusu write Fkusu;
    property last_op: Int64 read Flast_op write Flast_op;
    property drawing: string read Fdrawing write Fdrawing;
    property note2: string read Fnote2 write Fnote2;
    property cislo_objednavky: string read Fcislo_objednavky write Fcislo_objednavky;
    property has_docs: Integer read Fhas_docs write Fhas_docs;
    property montaz_date: TDateTime read Fmontaz_date write Fmontaz_date;
    property montaz_time: Integer read Fmontaz_time write Fmontaz_time;
    property prevedeno: Double read Fprevedeno write Fprevedeno;
    property expandovano: Double read Fexpandovano write Fexpandovano;
    property int_bar_id: Int64 read Fint_bar_id write Fint_bar_id;
    property oken_unit: Double read Foken_unit write Foken_unit;
    property user_time_order: Integer read Fuser_time_order write Fuser_time_order;
    property vypocteno_vyrobeno: Integer read Fvypocteno_vyrobeno write Fvypocteno_vyrobeno;
    property user_time_ks_second: Integer read Fuser_time_ks_second write Fuser_time_ks_second;
    property note_nabidka: string read Fnote_nabidka write Fnote_nabidka;
    property price_ukony: Double read Fprice_ukony write Fprice_ukony;
    property volitelna1: string read Fvolitelna1 write Fvolitelna1;
    property volitelna2: string read Fvolitelna2 write Fvolitelna2;
    property volitelna3: string read Fvolitelna3 write Fvolitelna3;
    property volitelna4: string read Fvolitelna4 write Fvolitelna4;
    property volitelna5: string read Fvolitelna5 write Fvolitelna5;
    property volitelna6: string read Fvolitelna6 write Fvolitelna6;
    property volitelna7: string read Fvolitelna7 write Fvolitelna7;
    property volitelna8: string read Fvolitelna8 write Fvolitelna8;
    property volitelna9: string read Fvolitelna9 write Fvolitelna9;
    property volitelna10: string read Fvolitelna10 write Fvolitelna10;
    property volitelna11: Nullable<string> read Fvolitelna11 write Fvolitelna11;
    property volitelna12: Nullable<string> read Fvolitelna12 write Fvolitelna12;
    property pocetKlt: Integer read FpocetKlt write FpocetKlt;
    property user_price_mat: Double read Fuser_price_mat write Fuser_price_mat;
    property user_price_sub: Double read Fuser_price_sub write Fuser_price_sub;
    property user_price_work: Double read Fuser_price_work write Fuser_price_work;
    property ukon1_planks: Double read Fukon1_planks write Fukon1_planks;
    property ukon2_planks: Double read Fukon2_planks write Fukon2_planks;
    property ukon3_planks: Double read Fukon3_planks write Fukon3_planks;
    property ukon4_planks: Double read Fukon4_planks write Fukon4_planks;
    property ukon5_planks: Double read Fukon5_planks write Fukon5_planks;
    property ukon6_planks: Double read Fukon6_planks write Fukon6_planks;
    property ukon7_planks: Double read Fukon7_planks write Fukon7_planks;
    property ukon8_planks: Double read Fukon8_planks write Fukon8_planks;
    property ukon9_planks: Double read Fukon9_planks write Fukon9_planks;
    property ukon10_planks: Double read Fukon10_planks write Fukon10_planks;
    property ukon11_planks: Double read Fukon11_planks write Fukon11_planks;
    property ukon12_planks: Double read Fukon12_planks write Fukon12_planks;
    property ukon13_planks: Double read Fukon13_planks write Fukon13_planks;
    property ukon14_planks: Double read Fukon14_planks write Fukon14_planks;
    property ukon15_planks: Double read Fukon15_planks write Fukon15_planks;
    property ukon1_vyrobenoks: Double read Fukon1_vyrobenoks write Fukon1_vyrobenoks;
    property ukon2_vyrobenoks: Double read Fukon2_vyrobenoks write Fukon2_vyrobenoks;
    property ukon3_vyrobenoks: Double read Fukon3_vyrobenoks write Fukon3_vyrobenoks;
    property ukon4_vyrobenoks: Double read Fukon4_vyrobenoks write Fukon4_vyrobenoks;
    property ukon5_vyrobenoks: Double read Fukon5_vyrobenoks write Fukon5_vyrobenoks;
    property ukon6_vyrobenoks: Double read Fukon6_vyrobenoks write Fukon6_vyrobenoks;
    property ukon7_vyrobenoks: Double read Fukon7_vyrobenoks write Fukon7_vyrobenoks;
    property ukon8_vyrobenoks: Double read Fukon8_vyrobenoks write Fukon8_vyrobenoks;
    property ukon9_vyrobenoks: Double read Fukon9_vyrobenoks write Fukon9_vyrobenoks;
    property ukon10_vyrobenoks: Double read Fukon10_vyrobenoks write Fukon10_vyrobenoks;
    property ukon11_vyrobenoks: Double read Fukon11_vyrobenoks write Fukon11_vyrobenoks;
    property ukon12_vyrobenoks: Double read Fukon12_vyrobenoks write Fukon12_vyrobenoks;
    property ukon13_vyrobenoks: Double read Fukon13_vyrobenoks write Fukon13_vyrobenoks;
    property ukon14_vyrobenoks: Double read Fukon14_vyrobenoks write Fukon14_vyrobenoks;
    property ukon15_vyrobenoks: Double read Fukon15_vyrobenoks write Fukon15_vyrobenoks;
    property priorita: Integer read Fpriorita write Fpriorita;
    property volitelna13: string read Fvolitelna13 write Fvolitelna13;
    property plan_kalendar: Integer read Fplan_kalendar write Fplan_kalendar;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property techpostup_id: Int64 read Ftechpostup_id write Ftechpostup_id;
    property ciselna_volitelna1: Double read Fciselna_volitelna1 write Fciselna_volitelna1;
    property ciselna_volitelna2: Double read Fciselna_volitelna2 write Fciselna_volitelna2;
    property unirec: Nullable<string> read Funirec write Funirec;
    property volitelna14: string read Fvolitelna14 write Fvolitelna14;
    property datumcaszmeny: TDateTime read Fdatumcaszmeny write Fdatumcaszmeny;
    property datumova_volitelna1: TDateTime read Fdatumova_volitelna1 write Fdatumova_volitelna1;
    property datumova_volitelna2: TDateTime read Fdatumova_volitelna2 write Fdatumova_volitelna2;
    property datumova_volitelna3: TDateTime read Fdatumova_volitelna3 write Fdatumova_volitelna3;
    property datumova_volitelna4: TDateTime read Fdatumova_volitelna4 write Fdatumova_volitelna4;
    property koeficient_on: Double read Fkoeficient_on write Fkoeficient_on;
    property odmeny_predpoklad: Double read Fodmeny_predpoklad write Fodmeny_predpoklad;
    property odmeny_vyuctovano: Double read Fodmeny_vyuctovano write Fodmeny_vyuctovano;
    property externi_faktura: Nullable<string> read Fexterni_faktura write Fexterni_faktura;
    property vykres_ze_souboru: Integer read Fvykres_ze_souboru write Fvykres_ze_souboru;
    property datumExpedice: TDateTime read FdatumExpedice write FdatumExpedice;
    property zpusob_dopravy_id: Int64 read Fzpusob_dopravy_id write Fzpusob_dopravy_id;
    property baliku1: Integer read Fbaliku1 write Fbaliku1;
    property baliku2: Integer read Fbaliku2 write Fbaliku2;
    property baliku3: Integer read Fbaliku3 write Fbaliku3;
    property email_upozornovat: Integer read Femail_upozornovat write Femail_upozornovat;
    property sklad_group_id: Integer read Fsklad_group_id write Fsklad_group_id;
    property operation_group_id: Integer read Foperation_group_id write Foperation_group_id;
    property dispTree: string read FdispTree write FdispTree;
    property uroven: Integer read Furoven write Furoven;
    property masterOrderId: Integer read FmasterOrderId write FmasterOrderId;
    property customer_id_adresa: Integer read Fcustomer_id_adresa write Fcustomer_id_adresa;
    property ciselna_volitelna3: Double read Fciselna_volitelna3 write Fciselna_volitelna3;
    property id_pohoda: string read Fid_pohoda write Fid_pohoda;
    property startVyroba: TDateTime read FstartVyroba write FstartVyroba;
    property finishVyroba: TDateTime read FfinishVyroba write FfinishVyroba;
    property viceprace: Integer read Fviceprace write Fviceprace;
    property unit_: Integer read Funit_ write Funit_;
    property rozmer1: Double read Frozmer1 write Frozmer1;
    property rozmer2: Double read Frozmer2 write Frozmer2;
    property rozmer3: Double read Frozmer3 write Frozmer3;
    property order_cena_jednotka: Double read Forder_cena_jednotka write Forder_cena_jednotka;
    property ciselna_volitelna4: Double read Fciselna_volitelna4 write Fciselna_volitelna4;
    property volitelna15: string read Fvolitelna15 write Fvolitelna15;
    property volitelna16: string read Fvolitelna16 write Fvolitelna16;
    property typ_vypoctu_ceny: Integer read Ftyp_vypoctu_ceny write Ftyp_vypoctu_ceny;
    property real_price2: Double read Freal_price2 write Freal_price2;
    property gdpr_zbyva: Integer read Fgdpr_zbyva write Fgdpr_zbyva;
    property gdpr_anonymizovano: Integer read Fgdpr_anonymizovano write Fgdpr_anonymizovano;
    property druha_mena_zkratka: string read Fdruha_mena_zkratka write Fdruha_mena_zkratka;
    property real_mzda: Double read Freal_mzda write Freal_mzda;
    property force_prepocet: Integer read Fforce_prepocet write Fforce_prepocet;
    property id_ciselna_rada: Integer read Fid_ciselna_rada write Fid_ciselna_rada;
    property prefix_ciselna_rada: string read Fprefix_ciselna_rada write Fprefix_ciselna_rada;
    property is_sablona: Integer read Fis_sablona write Fis_sablona;
    property ciselna_volitelna5: Double read Fciselna_volitelna5 write Fciselna_volitelna5;
    property ciselna_volitelna6: Double read Fciselna_volitelna6 write Fciselna_volitelna6;
    property drawing_revision: string read Fdrawing_revision write Fdrawing_revision;
    property export_datetime: TDateTime read Fexport_datetime write Fexport_datetime;
    property sablony_kod: string read Fsablony_kod write Fsablony_kod;
    property sablony_datetime: Nullable<TDateTime> read Fsablony_datetime write Fsablony_datetime;
    property use_orderwork_time: Integer read Fuse_orderwork_time write Fuse_orderwork_time;
    property start_req: TDateTime read Fstart_req write Fstart_req;
    property finish_req: TDateTime read Ffinish_req write Ffinish_req;
    property start_real: TDateTime read Fstart_real write Fstart_real;
    property finish_real: TDateTime read Ffinish_real write Ffinish_real;
    property ep_typ_planu_ID: Integer read Fep_typ_planu_ID write Fep_typ_planu_ID;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;

    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    property DynCon: TDynamicProperties read FDynCon;

    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    property created_mat_id: Tsklad_material read getcreated_mat_id write setcreated_mat_id;

    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    property order_workList: TList<Torder_work> read Getorder_workList;
  end;

  [Entity]
  [Table('c_order_calc')]
  [Description('c_order calculated data')]
  [UniqueKey('order_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tc_order_calc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id', [TColumnProp.Required], 100)]
    [Description('')]
    Forder_id: string;
    
    [Column('casZpodzak', [TColumnProp.Required])]
    [Description('')]
    FcasZpodzak: Int64;
    
    [Column('last_worker_id', [TColumnProp.Required])]
    [Description('')]
    Flast_worker_id: Integer;
    
    [Column('last_operation_id', [])]
    [Description('')]
    Flast_operation_id: Nullable<Integer>;
    
    [Column('last_start', [TColumnProp.Required])]
    [Description('')]
    Flast_start: TDateTime;
    
    [Column('last_finish', [TColumnProp.Required])]
    [Description('')]
    Flast_finish: TDateTime;
    
    [Column('min_cas', [TColumnProp.Required])]
    [Description('')]
    Fmin_cas: TDateTime;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    
    [Column('hodinova_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fhodinova_mzda: Double;
    
    [Column('KusyNaOperacich', [TColumnProp.Required], 15, 3)]
    [Description('')]
    FKusyNaOperacich: Double;
    
    [Column('CasNaOperacichOW', [TColumnProp.Required], 15, 3)]
    [Description('')]
    FCasNaOperacichOW: Double;
    
    [Column('ukonova_mzda_celkem', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukonova_mzda_celkem: Double;
    
    [Column('dispDiff2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    FdispDiff2: Double;
    
    [Column('dispDiff2Val', [TColumnProp.Required])]
    [Description('')]
    FdispDiff2Val: Integer;

    [Column('tot_op', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Ftot_op: Double;
    
    [Column('vydano_na_dodacichListech', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvydano_na_dodacichListech: Double;
    
    [Column('zauctovano_na_dodacichListech', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fzauctovano_na_dodacichListech: Double;
    
    [Column('ZmetkyNaOperacich', [TColumnProp.Required], 15, 3)]
    [Description('')]
    FZmetkyNaOperacich: Double;
    
    [Column('cena_mat', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_mat: Double;
    
    [Column('cena_mat_nakup', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_mat_nakup: Double;
    
    [Column('pohyb_vazena_cena_celkem', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fpohyb_vazena_cena_celkem: Double;
    
    [Column('cena_sub', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_sub: Double;
    
    [Column('cena_plan_sub', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_plan_sub: Double;
    
    [Column('user_price_subdodavky', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fuser_price_subdodavky: Double;
    
    [Column('cena_matpred', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_matpred: Double;
    
    [Column('predpoklad_cas_ukonu', [TColumnProp.Required])]
    [Description('')]
    Fpredpoklad_cas_ukonu: Integer;
    
    [Column('predpoklad_cena_ukonu', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fpredpoklad_cena_ukonu: Double;
    
    [Column('vyfakturovano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvyfakturovano: Double;

    [XDataExcludeProperty] // aby to vbec neeil v modelech/Swaggeru
    [JsonIgnore]           // aby to nelo do JSONu
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property casZpodzak: Int64 read FcasZpodzak write FcasZpodzak;
    property last_worker_id: Integer read Flast_worker_id write Flast_worker_id;
    property last_operation_id: Nullable<Integer> read Flast_operation_id write Flast_operation_id;
    property last_start: TDateTime read Flast_start write Flast_start;
    property last_finish: TDateTime read Flast_finish write Flast_finish;
    property min_cas: TDateTime read Fmin_cas write Fmin_cas;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property hodinova_mzda: Double read Fhodinova_mzda write Fhodinova_mzda;
    property KusyNaOperacich: Double read FKusyNaOperacich write FKusyNaOperacich;
    property CasNaOperacichOW: Double read FCasNaOperacichOW write FCasNaOperacichOW;
    property ukonova_mzda_celkem: Double read Fukonova_mzda_celkem write Fukonova_mzda_celkem;
    property dispDiff2: Double read FdispDiff2 write FdispDiff2;
    property dispDiff2Val: Integer read FdispDiff2Val write FdispDiff2Val;
    property tot_op: Double read Ftot_op write Ftot_op;
    property vydano_na_dodacichListech: Double read Fvydano_na_dodacichListech write Fvydano_na_dodacichListech;
    property zauctovano_na_dodacichListech: Double read Fzauctovano_na_dodacichListech write Fzauctovano_na_dodacichListech;
    property ZmetkyNaOperacich: Double read FZmetkyNaOperacich write FZmetkyNaOperacich;
    property cena_mat: Double read Fcena_mat write Fcena_mat;
    property cena_mat_nakup: Double read Fcena_mat_nakup write Fcena_mat_nakup;
    property pohyb_vazena_cena_celkem: Double read Fpohyb_vazena_cena_celkem write Fpohyb_vazena_cena_celkem;
    property cena_sub: Double read Fcena_sub write Fcena_sub;
    property cena_plan_sub: Double read Fcena_plan_sub write Fcena_plan_sub;
    property user_price_subdodavky: Double read Fuser_price_subdodavky write Fuser_price_subdodavky;
    property cena_matpred: Double read Fcena_matpred write Fcena_matpred;
    property predpoklad_cas_ukonu: Integer read Fpredpoklad_cas_ukonu write Fpredpoklad_cas_ukonu;
    property predpoklad_cena_ukonu: Double read Fpredpoklad_cena_ukonu write Fpredpoklad_cena_ukonu;
    property vyfakturovano: Double read Fvyfakturovano write Fvyfakturovano;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('c_order_doc')]
  [Description('Dokumenty k zakzkm')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tc_order_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('isFile', [TColumnProp.Required])]
    [Description('')]
    FisFile: boolean;

    [Column('zobrazitNahled', [TColumnProp.Required])]
    [Description('')]
    FzobrazitNahled: Integer;

    [Column('external_list_type', [TColumnProp.Required], 10)]
    [Description('')]
    Fexternal_list_type: string;

    [Column('external_list_id_record', [TColumnProp.Required])]
    [Description('')]
    Fexternal_list_id_record: Integer;

    [Column('defaultDocument', [TColumnProp.Required])]
    [Description('')]
    FdefaultDocument: boolean;

    [Column('print_with_document', [TColumnProp.Required])]
    [Description('')]
    Fprint_with_document: Integer;

    [Column('print_with_document_landscape', [TColumnProp.Required])]
    [Description('')]
    Fprint_with_document_landscape: Integer;
    FDynCon: TDynamicProperties;
    function getextensionType : integer;
    function getdoctype : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isFile: boolean read FisFile write FisFile;
    property zobrazitNahled: Integer read FzobrazitNahled write FzobrazitNahled;
    property external_list_type: string read Fexternal_list_type write Fexternal_list_type;
    property external_list_id_record: Integer read Fexternal_list_id_record write Fexternal_list_id_record;
    property defaultDocument: boolean read FdefaultDocument write FdefaultDocument;
    property print_with_document: Integer read Fprint_with_document write Fprint_with_document;
    property print_with_document_landscape: Integer read Fprint_with_document_landscape write Fprint_with_document_landscape;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('c_order_parameters')]
  [Description('parametry zakzek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tc_order_parameters = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('param_id', [])]
    [Description('')]
    Fparam_id: Nullable<Integer>;
    
    [Column('param_value', [TColumnProp.Required], 4096)]
    [Description('')]
    Fparam_value: string;
    
    [Column('order_id', [TColumnProp.Required], 200)]
    [Description('')]
    Forder_id: string;
    
    [Column('param_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fparam_name: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property param_id: Nullable<Integer> read Fparam_id write Fparam_id;
    property param_value: string read Fparam_value write Fparam_value;
    property order_id: string read Forder_id write Forder_id;
    property param_name: string read Fparam_name write Fparam_name;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('c_order_parameters_def')]
  [Description('parametry zakzek definice')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tc_order_parameters_def = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('param_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fparam_name: string;
    
    [Column('param_type', [TColumnProp.Required], 255)]
    [Description('')]
    Fparam_type: string;
    
    [Column('param_default', [TColumnProp.Required], 255)]
    [Description('')]
    Fparam_default: string;
    
    [Column('param_caption', [TColumnProp.Required], 255)]
    [Description('')]
    Fparam_caption: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property param_name: string read Fparam_name write Fparam_name;
    property param_type: string read Fparam_type write Fparam_type;
    property param_default: string read Fparam_default write Fparam_default;
    property param_caption: string read Fparam_caption write Fparam_caption;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('datum')]
  [Description('Tiskova tabulka dochazky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdatum = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;
    
    [Column('pc', [TColumnProp.Required], 20)]
    [Description('')]
    Fpc: string;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property datum: TDateTime read Fdatum write Fdatum;
    property pc: string read Fpc write Fpc;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('dochazka')]
  [Description('Tabulka dochazky zamestnancu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdochazka = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('dovolena', [TColumnProp.Required])]
    [Description('')]
    Fdovolena: Integer;
    
    [Column('nemoc', [TColumnProp.Required])]
    [Description('')]
    Fnemoc: Integer;
    
    [Column('ostatni', [TColumnProp.Required])]
    [Description('')]
    Fostatni: Integer;
    
    [Column('svatek', [TColumnProp.Required])]
    [Description('')]
    Fsvatek: Integer;

    [Column('propustka', [TColumnProp.Required])]
    [Description('')]
    Fpropustka: Integer;
    
    [Column('odpracovano', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano: Integer;
    
    [Column('fond', [TColumnProp.Required])]
    [Description('')]
    Ffond: Integer;
    
    [Column('placeno', [TColumnProp.Required])]
    [Description('')]
    Fplaceno: Integer;
    
    [Column('neodpracovano', [TColumnProp.Required])]
    [Description('')]
    Fneodpracovano: Integer;
    
    [Column('prescas', [TColumnProp.Required])]
    [Description('')]
    Fprescas: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('real_odprac', [TColumnProp.Required])]
    [Description('')]
    Freal_odprac: Integer;
    
    [Column('smena', [TColumnProp.Required], 25)]
    [Description('')]
    Fsmena: string;
    
    [Column('typ_vypoctu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu: Integer;
    
    [Column('ostatni_korekce', [TColumnProp.Required])]
    [Description('')]
    Fostatni_korekce: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    FNote : string;
    
    [Column('nahrvolno', [TColumnProp.Required])]
    [Description('')]
    Fnahrvolno: Integer;
    
    [Column('ocr', [TColumnProp.Required])]
    [Description('')]
    Focr: Integer;
    
    [Column('prestavka', [TColumnProp.Required])]
    [Description('')]
    Fprestavka: Integer;
    
    [Column('vikend', [TColumnProp.Required])]
    [Description('')]
    Fvikend: Integer;
    
    [Column('placvolno', [TColumnProp.Required])]
    [Description('')]
    Fplacvolno: Integer;

    [Column('absence', [TColumnProp.Required])]
    [Description('')]
    Fabsence: Integer;
    
    [Column('svatek_nahr', [TColumnProp.Required])]
    [Description('')]
    Fsvatek_nahr: Integer;
    
    [Column('prostoj', [TColumnProp.Required])]
    [Description('')]
    Fprostoj: Integer;
    
    [Column('neplac_volno', [TColumnProp.Required])]
    [Description('')]
    Fneplac_volno: Integer;
    
    [Column('ostatni_nahr', [TColumnProp.Required])]
    [Description('')]
    Fostatni_nahr: Integer;
    
    [Column('nocni', [TColumnProp.Required])]
    [Description('')]
    Fnocni: Integer;
    
    [Column('saldo_prescas', [TColumnProp.Required])]
    [Description('')]
    Fsaldo_prescas: Integer;
    
    [Column('verze', [TColumnProp.Required], 20)]
    [Description('')]
    Fverze: string;
    
    [Column('cas_vypoctu', [])]
    [Description('')]
    Fcas_vypoctu: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('verze_id', [TColumnProp.Required])]
    [Description('')]
    Fverze_id: Integer;
    
    [Column('karantena', [TColumnProp.Required])]
    [Description('')]
    Fkarantena: Integer;

    [Column('smena_id', [TColumnProp.Required])]
    [Description('')]
    Fsmena_id: Integer;
    
    [Column('odpracovano_prestavka', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano_prestavka: Integer;
    
    [Column('odpracovano_na_zakazku', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano_na_zakazku: Integer;
    
    [Column('odpracovano_bez_zakazky', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano_bez_zakazky: Integer;
    
    [Column('odpracovano_Rezie', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano_Rezie: Integer;
    
    [Column('odpracovano_ostatni', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano_ostatni: Integer;
    
    [Column('propustka_bez', [TColumnProp.Required])]
    [Description('')]
    Fpropustka_bez: Integer;
    
    [Column('prekazka_zamestnanec_s', [TColumnProp.Required])]
    [Description('')]
    Fprekazka_zamestnanec_s: Integer;
    
    [Column('prekazka_zamestnanec_bez', [TColumnProp.Required])]
    [Description('')]
    Fprekazka_zamestnanec_bez: Integer;
    
    [Column('prekazka_pocasi', [TColumnProp.Required])]
    [Description('')]
    Fprekazka_pocasi: Integer;
    
    [Column('prekazka_nezamestnanost', [TColumnProp.Required])]
    [Description('')]
    Fprekazka_nezamestnanost: Integer;

    [Column('prekazka_ostatni', [TColumnProp.Required])]
    [Description('')]
    Fprekazka_ostatni: Integer;
    
    [Column('prescas_fond', [TColumnProp.Required])]
    [Description('')]
    Fprescas_fond: Integer;
    
    [Column('prescas_proplatit', [TColumnProp.Required])]
    [Description('')]
    Fprescas_proplatit: Integer;
    
    [Column('prescas_proplatit_fond', [TColumnProp.Required])]
    [Description('')]
    Fprescas_proplatit_fond: Integer;
    
    [Column('zamceno', [TColumnProp.Required])]
    [Description('')]
    Fzamceno: Integer;
    
    [Column('odpoledni', [TColumnProp.Required])]
    [Description('')]
    Fodpoledni: Integer;
    
    [Column('nadpracovani', [TColumnProp.Required])]
    [Description('')]
    Fnadpracovani: Integer;
    
    [Column('user_zmena', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_zmena: string;
    
    [Column('ts_zmena', [TColumnProp.Required])]
    [Description('')]
    Fts_zmena: TDateTime;
    
    [Column('user_zamceno', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_zamceno: string;
    
    [Column('ts_zamceno', [TColumnProp.Required])]
    [Description('')]
    Fts_zamceno: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property dovolena: Integer read Fdovolena write Fdovolena;
    property nemoc: Integer read Fnemoc write Fnemoc;
    property ostatni: Integer read Fostatni write Fostatni;
    property svatek: Integer read Fsvatek write Fsvatek;
    property propustka: Integer read Fpropustka write Fpropustka;
    property odpracovano: Integer read Fodpracovano write Fodpracovano;
    property fond: Integer read Ffond write Ffond;
    property placeno: Integer read Fplaceno write Fplaceno;
    property neodpracovano: Integer read Fneodpracovano write Fneodpracovano;
    property prescas: Integer read Fprescas write Fprescas;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property real_odprac: Integer read Freal_odprac write Freal_odprac;
    property smena: string read Fsmena write Fsmena;
    property typ_vypoctu: Integer read Ftyp_vypoctu write Ftyp_vypoctu;
    property ostatni_korekce: Integer read Fostatni_korekce write Fostatni_korekce;
    property note: string read Fnote write Fnote;
    property nahrvolno: Integer read Fnahrvolno write Fnahrvolno;
    property ocr: Integer read Focr write Focr;
    property prestavka: Integer read Fprestavka write Fprestavka;
    property vikend: Integer read Fvikend write Fvikend;
    property placvolno: Integer read Fplacvolno write Fplacvolno;
    property absence: Integer read Fabsence write Fabsence;
    property svatek_nahr: Integer read Fsvatek_nahr write Fsvatek_nahr;
    property prostoj: Integer read Fprostoj write Fprostoj;
    property neplac_volno: Integer read Fneplac_volno write Fneplac_volno;
    property ostatni_nahr: Integer read Fostatni_nahr write Fostatni_nahr;
    property nocni: Integer read Fnocni write Fnocni;
    property saldo_prescas: Integer read Fsaldo_prescas write Fsaldo_prescas;
    property verze: string read Fverze write Fverze;
    property cas_vypoctu: Nullable<TDateTime> read Fcas_vypoctu write Fcas_vypoctu;
    property user: string read Fuser write Fuser;
    property verze_id: Integer read Fverze_id write Fverze_id;
    property karantena: Integer read Fkarantena write Fkarantena;
    property smena_id: Integer read Fsmena_id write Fsmena_id;
    property odpracovano_prestavka: Integer read Fodpracovano_prestavka write Fodpracovano_prestavka;
    property odpracovano_na_zakazku: Integer read Fodpracovano_na_zakazku write Fodpracovano_na_zakazku;
    property odpracovano_bez_zakazky: Integer read Fodpracovano_bez_zakazky write Fodpracovano_bez_zakazky;
    property odpracovano_Rezie: Integer read Fodpracovano_Rezie write Fodpracovano_Rezie;
    property odpracovano_ostatni: Integer read Fodpracovano_ostatni write Fodpracovano_ostatni;
    property propustka_bez: Integer read Fpropustka_bez write Fpropustka_bez;
    property prekazka_zamestnanec_s: Integer read Fprekazka_zamestnanec_s write Fprekazka_zamestnanec_s;
    property prekazka_zamestnanec_bez: Integer read Fprekazka_zamestnanec_bez write Fprekazka_zamestnanec_bez;
    property prekazka_pocasi: Integer read Fprekazka_pocasi write Fprekazka_pocasi;
    property prekazka_nezamestnanost: Integer read Fprekazka_nezamestnanost write Fprekazka_nezamestnanost;
    property prekazka_ostatni: Integer read Fprekazka_ostatni write Fprekazka_ostatni;
    property prescas_fond: Integer read Fprescas_fond write Fprescas_fond;
    property prescas_proplatit: Integer read Fprescas_proplatit write Fprescas_proplatit;
    property prescas_proplatit_fond: Integer read Fprescas_proplatit_fond write Fprescas_proplatit_fond;
    property zamceno: Integer read Fzamceno write Fzamceno;
    property odpoledni: Integer read Fodpoledni write Fodpoledni;
    property nadpracovani: Integer read Fnadpracovani write Fnadpracovani;
    property user_zmena: string read Fuser_zmena write Fuser_zmena;
    property ts_zmena: TDateTime read Fts_zmena write Fts_zmena;
    property user_zamceno: string read Fuser_zamceno write Fuser_zamceno;
    property ts_zamceno: TDateTime read Fts_zamceno write Fts_zamceno;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('dochazka_mirror')]
  [Description('Tabulka pro ukladani dochazky zamestnancu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdochazka_mirror = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('dovolena', [TColumnProp.Required])]
    [Description('')]
    Fdovolena: Integer;
    
    [Column('nemoc', [TColumnProp.Required])]
    [Description('')]
    Fnemoc: Integer;
    
    [Column('ostatni', [TColumnProp.Required])]
    [Description('')]
    Fostatni: Integer;

    [Column('svatek', [TColumnProp.Required])]
    [Description('')]
    Fsvatek: Integer;
    
    [Column('propustka', [TColumnProp.Required])]
    [Description('')]
    Fpropustka: Integer;
    
    [Column('odpracovano', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano: Integer;
    
    [Column('fond', [TColumnProp.Required])]
    [Description('')]
    Ffond: Integer;
    
    [Column('placeno', [TColumnProp.Required])]
    [Description('')]
    Fplaceno: Integer;
    
    [Column('neodpracovano', [TColumnProp.Required])]
    [Description('')]
    Fneodpracovano: Integer;
    
    [Column('prescas', [TColumnProp.Required])]
    [Description('')]
    Fprescas: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('real_odprac', [TColumnProp.Required])]
    [Description('')]
    Freal_odprac: Integer;
    
    [Column('smena', [TColumnProp.Required], 25)]
    [Description('')]
    Fsmena: string;
    
    [Column('typ_vypoctu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu: Integer;
    
    [Column('ostatni_korekce', [TColumnProp.Required])]
    [Description('')]
    Fostatni_korekce: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('nahrvolno', [TColumnProp.Required])]
    [Description('')]
    Fnahrvolno: Integer;
    
    [Column('ocr', [TColumnProp.Required])]
    [Description('')]
    Focr: Integer;
    
    [Column('prestavka', [TColumnProp.Required])]
    [Description('')]
    Fprestavka: Integer;
    
    [Column('vikend', [TColumnProp.Required])]
    [Description('')]
    Fvikend: Integer;

    [Column('placvolno', [TColumnProp.Required])]
    [Description('')]
    Fplacvolno: Integer;
    
    [Column('absence', [TColumnProp.Required])]
    [Description('')]
    Fabsence: Integer;
    
    [Column('svatek_nahr', [TColumnProp.Required])]
    [Description('')]
    Fsvatek_nahr: Integer;
    
    [Column('prostoj', [TColumnProp.Required])]
    [Description('')]
    Fprostoj: Integer;
    
    [Column('neplac_volno', [TColumnProp.Required])]
    [Description('')]
    Fneplac_volno: Integer;
    
    [Column('ostatni_nahr', [TColumnProp.Required])]
    [Description('')]
    Fostatni_nahr: Integer;
    
    [Column('nocni', [TColumnProp.Required])]
    [Description('')]
    Fnocni: Integer;
    
    [Column('saldo_prescas', [TColumnProp.Required])]
    [Description('')]
    Fsaldo_prescas: Integer;
    
    [Column('verze', [TColumnProp.Required], 20)]
    [Description('')]
    Fverze: string;
    
    [Column('cas_vypoctu', [])]
    [Description('')]
    Fcas_vypoctu: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property dovolena: Integer read Fdovolena write Fdovolena;
    property nemoc: Integer read Fnemoc write Fnemoc;
    property ostatni: Integer read Fostatni write Fostatni;
    property svatek: Integer read Fsvatek write Fsvatek;
    property propustka: Integer read Fpropustka write Fpropustka;
    property odpracovano: Integer read Fodpracovano write Fodpracovano;
    property fond: Integer read Ffond write Ffond;
    property placeno: Integer read Fplaceno write Fplaceno;
    property neodpracovano: Integer read Fneodpracovano write Fneodpracovano;
    property prescas: Integer read Fprescas write Fprescas;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property real_odprac: Integer read Freal_odprac write Freal_odprac;
    property smena: string read Fsmena write Fsmena;
    property typ_vypoctu: Integer read Ftyp_vypoctu write Ftyp_vypoctu;
    property ostatni_korekce: Integer read Fostatni_korekce write Fostatni_korekce;
    property note: string read Fnote write Fnote;
    property nahrvolno: Integer read Fnahrvolno write Fnahrvolno;
    property ocr: Integer read Focr write Focr;
    property prestavka: Integer read Fprestavka write Fprestavka;
    property vikend: Integer read Fvikend write Fvikend;
    property placvolno: Integer read Fplacvolno write Fplacvolno;
    property absence: Integer read Fabsence write Fabsence;
    property svatek_nahr: Integer read Fsvatek_nahr write Fsvatek_nahr;
    property prostoj: Integer read Fprostoj write Fprostoj;
    property neplac_volno: Integer read Fneplac_volno write Fneplac_volno;
    property ostatni_nahr: Integer read Fostatni_nahr write Fostatni_nahr;
    property nocni: Integer read Fnocni write Fnocni;
    property saldo_prescas: Integer read Fsaldo_prescas write Fsaldo_prescas;
    property verze: string read Fverze write Fverze;
    property cas_vypoctu: Nullable<TDateTime> read Fcas_vypoctu write Fcas_vypoctu;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('dochazka_note')]
  [Description('Poznmka dochzky za obdob')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdochazka_note = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('note', [], 300)]
    [Description('')]
    Fnote: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property note: Nullable<string> read Fnote write Fnote;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('dochazka_typy_operaci')]
  [Description('definice operaci dochazky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdochazka_typy_operaci = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('barva', [TColumnProp.Required])]
    [Description('')]
    Fbarva: Integer;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('seznam_operaci', [TColumnProp.Required], 200)]
    [Description('')]
    Fseznam_operaci: string;
    
    [Column('graf', [TColumnProp.Required])]
    [Description('')]
    Fgraf: Integer;
    
    [Column('sloupec', [TColumnProp.Required], 50)]
    [Description('')]
    Fsloupec: string;
    
    [Column('system', [TColumnProp.Required])]
    [Description('')]
    Fsystem: Boolean;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: Boolean;
    
    [Column('seznam_skupin', [TColumnProp.Required], 200)]
    [Description('')]
    Fseznam_skupin: string;
    
    [Column('vazba_na_zakazku', [TColumnProp.Required])]
    [Description('')]
    Fvazba_na_zakazku: Integer;
    
    [Column('negenerovat_prichod_odchod', [TColumnProp.Required])]
    [Description('')]
    Fnegenerovat_prichod_odchod: Boolean;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_changed', [])]
    [Description('')]
    Fts_changed: Nullable<TDateTime>;

    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;

    [Column('nutnost_zadosti', [TColumnProp.Required])]
    [Description('')]
    Fnutnost_zadosti: Boolean;

    [Column('vterinova_zadost', [TColumnProp.Required])]
    [Description('')]
    Fvterinova_zadost: Boolean;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property barva: Integer read Fbarva write Fbarva;
    property priorita: Integer read Fpriorita write Fpriorita;
    property seznam_operaci: string read Fseznam_operaci write Fseznam_operaci;
    property graf: Integer read Fgraf write Fgraf;
    property sloupec: string read Fsloupec write Fsloupec;
    property system: Boolean read Fsystem write Fsystem;
    property active: Boolean read Factive write Factive;
    property seznam_skupin: string read Fseznam_skupin write Fseznam_skupin;
    property vazba_na_zakazku: Integer read Fvazba_na_zakazku write Fvazba_na_zakazku;
    property negenerovat_prichod_odchod: Boolean read Fnegenerovat_prichod_odchod write Fnegenerovat_prichod_odchod;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_changed: Nullable<TDateTime> read Fts_changed write Fts_changed;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property nutnost_zadosti: Boolean read Fnutnost_zadosti write Fnutnost_zadosti;
    property vterinova_zadost: Boolean read Fvterinova_zadost write Fvterinova_zadost;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('dochazka_verze')]
  [Description('Tabulka verz dochzky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdochazka_verze = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('editovat', [TColumnProp.Required])]
    [Description('')]
    Feditovat: Integer;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: Integer;
    
    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Integer;
    
    [Column('barva', [TColumnProp.Required])]
    [Description('')]
    Fbarva: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property editovat: Integer read Feditovat write Feditovat;
    property active: Integer read Factive write Factive;
    property vychozi: Integer read Fvychozi write Fvychozi;
    property barva: Integer read Fbarva write Fbarva;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('dodaci_listy')]
  [Description('Tabulka dadacch list')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdodaci_listy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('vystaveno', [TColumnProp.Required])]
    [Description('')]
    Fvystaveno: TDateTime;
    
    [Column('code', [TColumnProp.Required], 25)]
    [Description('')]
    Fcode: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('externi_id', [], 100)]
    [Description('')]
    Fexterni_id: Nullable<string>;
    
    [Column('cisloFaktury', [TColumnProp.Required], 100)]
    [Description('')]
    FcisloFaktury: string;
    
    [Column('splatnostDni', [TColumnProp.Required])]
    [Description('')]
    FsplatnostDni: Integer;
    
    [Column('splatnostDatum', [TColumnProp.Required])]
    [Description('')]
    FsplatnostDatum: TDateTime;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('usercreated', [TColumnProp.Required], 50)]
    [Description('')]
    Fusercreated: string;
    
    [Column('cm_kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_kurz: Double;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;
    
    [Association([TAssociationProp.Lazy ], CascadeTypeNone)]
    [JoinColumn('customer_id', [], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('dodaciadresa', [], 'id')]
    [Description('')]
    Fdodaciadresa: proxy<Tcustomer_adresy>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('zpusob_platby', [], 'id')]
    [Description('')]
    Fzpusob_platby: proxy<Tzpusob_platby>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('stavdokladu', [], 'id')]
    [Description('')]
    Fstavdokladu: proxy<Tstavydokladu>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('doprava_id', [], 'id')]
    [Description('')]
    Fdoprava_id: proxy<Tzpusob_dopravy>;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cm_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('hlavni_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fhlavni_mena: proxy<Tkurz_meny>;

    [Column('name', [], 100)]
    [Description('')]
    Fname: string;

    [Column('price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice: Double;

    [Column('cm_price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcm_price: Double;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fdodaci_list_id')]
    Fdodaci_listy_polozkyList: Proxy<TList<Tdodaci_listy_polozky>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fdodaci_list_id')]
    Fdodaci_listy_docList: Proxy<TList<Tdodaci_listy_doc>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fdodaci_list_id')]
    Fdodaci_listy_zauctovanoList: Proxy<TList<Tdodaci_listy_zauctovano>>;
    function Getdodaci_listy_polozkyList: TList<Tdodaci_listy_polozky>;
    function Getdodaci_listy_docList: TList<Tdodaci_listy_doc>;
    function Getdodaci_listy_zauctovanoList: TList<Tdodaci_listy_zauctovano>;
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
    function getdodaciadresa: Tcustomer_adresy;
    procedure setdodaciadresa(const Value : Tcustomer_adresy);
    function getzpusob_platby: Tzpusob_platby;
    procedure setzpusob_platby(const Value : Tzpusob_platby);
    function getstavdokladu: Tstavydokladu;
    procedure setstavdokladu(const Value : Tstavydokladu);
    function getdoprava_id: Tzpusob_dopravy;
    procedure setdoprava_id(const Value : Tzpusob_dopravy);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function gethlavni_mena: Tkurz_meny;
    procedure sethlavni_mena(const Value : Tkurz_meny);
    function getcm_kurz: Double;
    procedure setcm_kurz(const Value: Double);
    procedure setvystaveno(const Value: TDateTime);
    procedure setsplatnostDni(const Value: integer);

  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    class procedure checkNewRecord; override; // K Overeni, ze je mozne objekt vytvorit, napr. existuje rada dokladu
    function GetBar_ID : String; override;

    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property user: string read Fuser write Fuser;
    property vystaveno: TDateTime read Fvystaveno write setvystaveno;
    property code: string read Fcode write Fcode;
    property note: string read Fnote write Fnote;
    property externi_id: Nullable<string> read Fexterni_id write Fexterni_id;
    property cisloFaktury: string read FcisloFaktury write FcisloFaktury;
    property splatnostDni: Integer read FsplatnostDni write setsplatnostDni;
    property splatnostDatum: TDateTime read FsplatnostDatum write FsplatnostDatum;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property usercreated: string read Fusercreated write Fusercreated;
    property cm_kurz: Double read getcm_kurz write setcm_kurz;
    property DynCon: TDynamicProperties read FDynCon;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
    property dodaciadresa: Tcustomer_adresy read getdodaciadresa write setdodaciadresa;
    property zpusob_platby: Tzpusob_platby read getzpusob_platby write setzpusob_platby;
    property stavdokladu: Tstavydokladu read getstavdokladu write setstavdokladu;
    property doprava_id: Tzpusob_dopravy read getdoprava_id write setdoprava_id;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property hlavni_mena: Tkurz_meny read gethlavni_mena write sethlavni_mena;
    property dodaci_listy_polozkyList: TList<Tdodaci_listy_polozky> read Getdodaci_listy_polozkyList;
    property dodaci_listy_docList: TList<Tdodaci_listy_doc> read Getdodaci_listy_docList;
    property dodaci_listy_zauctovanoList: TList<Tdodaci_listy_zauctovano> read Getdodaci_listy_zauctovanoList;
    property name: string read fname write fname;
    property cm_price: Double read Fcm_price write Fcm_price;
    property price: Double read Fprice write Fprice;
    property has_docs: Integer read Fhas_docs write Fhas_docs;
  end;

  [Entity]
  [Table('dodaci_listy_doc')]
  [Description('dokumenty dodacich listu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdodaci_listy_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('isfile', [TColumnProp.Required])]
    [Description('')]
    Fisfile: Boolean;

    [Column('defaultdocument', [TColumnProp.Required])]
    [Description('')]
    Fdefaultdocument: Boolean;

    [Column('user', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 200)]
    [Description('')]
    Fusercreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('dodaci_list_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fdodaci_list_id: proxy<Tdodaci_listy>;

    function getextensionType : integer;
    function getdoctype : string;
    function getdodaci_list_id: Tdodaci_listy;
    procedure setdodaci_list_id(const Value : Tdodaci_listy);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isfile: Boolean read Fisfile write Fisfile;
    property defaultdocument: Boolean read Fdefaultdocument write Fdefaultdocument;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property dodaci_list_id: Tdodaci_listy read getdodaci_list_id write setdodaci_list_id;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
  end;

  [Entity]
  [Table('dodaci_listy_polozky')]
  [Description('Tabulka poloek dodacch list')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdodaci_listy_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('kusu', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fkusu: Double;
    
    [Column('unit_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Funit_price: Double;
    
    [Column('prevod_mat_id', [TColumnProp.Required])]
    [Description('')]
    Fprevod_mat_id: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('vydej_id', [TColumnProp.Required])]
    [Description('')]
    Fvydej_id: Integer;
    
    [Column('externi_id', [], 100)]
    [Description('')]
    Fexterni_id: Nullable<string>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('serial_id', [], 'id')]
    [Description('')]
    Fserial_id: proxy<Tserial_code>;

    [Column('zpracovano', [TColumnProp.Required])]
    [Description('')]
    Fzpracovano: Integer;

    [Column('pripravaVyrobyCheck', [TColumnProp.Required])]
    [Description('')]
    FpripravaVyrobyCheck: Integer;

    [Column('pripravaVyroby', [TColumnProp.Required], 15, 4)]
    [Description('')]
    FpripravaVyroby: Double;

    [Column('pripravaPredlohyCheck', [TColumnProp.Required])]
    [Description('')]
    FpripravaPredlohyCheck: Integer;

    [Column('pripravaPredlohy', [TColumnProp.Required], 15, 4)]
    [Description('')]
    FpripravaPredlohy: Double;

    [Column('ineCheck', [TColumnProp.Required])]
    [Description('')]
    FineCheck: Integer;

    [Column('ine', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fine: Double;

    [Column('dodaciAdresa', [TColumnProp.Required])]
    [Description('')]
    FdodaciAdresa: Integer;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 50)]
    [Description('')]
    Fusercreated: string;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fprice: Double;
    
    [Column('price_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fprice_mj: Double;

    [Column('cm_price_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_price_mj: Double;

    [Column('kusu_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fkusu_mj: Double;

    [Column('coef_unit', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcoef_unit: Double;

    [Column('typ_polozky', [TColumnProp.Required])]
    [Description('')]
    Ftyp_polozky: Integer;

    [Column('cm_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_price: Double;

    [Column('cm_unit_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_unit_price: Double;

    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('dodaci_list_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fdodaci_list_id: proxy<Tdodaci_listy>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<Tjednotky>;

    [Association([], CascadeTypeNone)] //TAssociationProp.Lazy
    [JoinColumn('order_id', [], 'bar_id')]
    [Description('')]
//    Forder_id: proxy<Tc_order>;
    Forder_id: Tc_order;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('polozka_prijate_objednavky_id', [], 'id')]
    [Description('')]
    Fpolozka_prijate_objednavky_id: proxy<Tobjednavky_prijate_polozky>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_id', [], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAll, 'Fpolozka_dodlist_id')]
    Fsklad_material_readdataList: Proxy<TList<Tsklad_material_readdata>>;
    function Getsklad_material_readdataList: TList<Tsklad_material_readdata>;
    function getdodaci_list_id: Tdodaci_listy;
    procedure setdodaci_list_id(const Value : Tdodaci_listy);
    function getunit_: Tjednotky;
    procedure setunit_(const Value : Tjednotky);
    function getorder_id: Tc_order;
    procedure setorder_id(const Value : Tc_order);
    function getpolozka_prijate_objednavky_id: Tobjednavky_prijate_polozky;
    procedure setpolozka_prijate_objednavky_id(const Value : Tobjednavky_prijate_polozky);
    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    procedure setkusu_mj(const Value: Double);
    procedure setcoef_unit(const Value: Double);
    function getcoef_unit: Double;
    procedure setkusu (const Value: Double);
    procedure setcm_price_mj (const Value: Double);
    procedure setcm_price (const Value: Double);
    procedure setprice (const Value: Double);
    procedure setcm_unit_price (const Value: Double);
    procedure setunit_price (const Value: Double);
    procedure setprice_mj (const Value: Double);
    procedure settyp_polozky(const Value: Integer);
    function getserial_id : Tserial_code;
    procedure setserial_id (const Value : Tserial_code);
    function gettyp_polozky_nazev : string;
    function getdoklad_bar_id: string;
    function getdoklad_name: string;
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CheckRecord(var aMessage : String) : Boolean; override;

    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write FName;
    property prevod_mat_id: Integer read Fprevod_mat_id write Fprevod_mat_id;
    property note: string read Fnote write Fnote;
    property vydej_id: Integer read Fvydej_id write Fvydej_id;
    property externi_id: Nullable<string> read Fexterni_id write Fexterni_id;
    property serial_id: Tserial_code read getserial_id write setserial_id;
    property zpracovano: Integer read Fzpracovano write Fzpracovano;
    property pripravaVyrobyCheck: Integer read FpripravaVyrobyCheck write FpripravaVyrobyCheck;
    property pripravaVyroby: Double read FpripravaVyroby write FpripravaVyroby;
    property pripravaPredlohyCheck: Integer read FpripravaPredlohyCheck write FpripravaPredlohyCheck;
    property pripravaPredlohy: Double read FpripravaPredlohy write FpripravaPredlohy;
    property ineCheck: Integer read FineCheck write FineCheck;
    property ine: Double read Fine write Fine;
    property dodaciAdresa: Integer read FdodaciAdresa write FdodaciAdresa;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property cm_price_mj: Double read Fcm_price_mj write setcm_price_mj;
    property kusu_mj: Double read Fkusu_mj write setkusu_mj;
    property poradi: Integer read Fporadi write Fporadi;
    property typ_polozky: Integer read Ftyp_polozky write settyp_polozky;
    property DynCon: TDynamicProperties read FDynCon;
    property dodaci_list_id: Tdodaci_listy read getdodaci_list_id write setdodaci_list_id;
    property unit_: Tjednotky read getunit_ write setunit_;
    property order_id: Tc_order read getorder_id write setorder_id;
    property polozka_prijate_objednavky_id: Tobjednavky_prijate_polozky read getpolozka_prijate_objednavky_id write setpolozka_prijate_objednavky_id;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property sklad_material_readdataList: TList<Tsklad_material_readdata> read Getsklad_material_readdataList;
    property typ_polozky_nazev : string read gettyp_polozky_nazev;
    property doklad_bar_ID : string read getdoklad_bar_ID;
    property doklad_name : string read getdoklad_name;
    //RO
    property kusu: Double read Fkusu; // write setkusu;
    property unit_price: Double read Funit_price; // write Funit_price;
    property price: Double read Fprice; // write setprice;
    property price_mj: Double read Fprice_mj; // write Fprice_mj;
    property coef_unit: Double read getcoef_unit; // write setcoef_unit;
    property cm_price: Double read Fcm_price; // write setcm_price;
    property cm_unit_price: Double read Fcm_unit_price; // write Fcm_unit_price;
  end;

  [Entity]
  [Table('dodaci_listy_zauctovano')]
  [Description('Tabulka zauctovani dodacich listu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdodaci_listy_zauctovano = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('doklad', [], 50)]
    [Description('')]
    Fdoklad: Nullable<string>;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('dodaci_list_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fdodaci_list_id: proxy<Tdodaci_listy>;
    function getdodaci_list_id: Tdodaci_listy;
    procedure setdodaci_list_id(const Value : Tdodaci_listy);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Int64 read Fid write Fid;
    property doklad: Nullable<string> read Fdoklad write Fdoklad;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property dodaci_list_id: Tdodaci_listy read getdodaci_list_id write setdodaci_list_id;
  end;
  
  [Entity]
  [Table('doklady_status_log')]
  [Description('zmeny statusu dokladu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdoklady_status_log = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('tablename', [TColumnProp.Required], 100)]
    [Description('')]
    Ftablename: string;
    
    [Column('doklad_id', [TColumnProp.Required], 255)]
    [Description('')]
    Fdoklad_id: string;
    
    [Column('status', [TColumnProp.Required], 255)]
    [Description('')]
    Fstatus: string;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property tablename: string read Ftablename write Ftablename;
    property doklad_id: string read Fdoklad_id write Fdoklad_id;
    property status: string read Fstatus write Fstatus;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ep_collision')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_collision = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: boolean;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('color', [TColumnProp.Required])]
    [Description('')]
    Fcolor: Integer;
    
    [Column('`sql`', [TColumnProp.Required, TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fsql: TBlob;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('usercreated', [], 200)]
    [Description('')]
    Fusercreated: Nullable<string>;
    
    [Column('user', [], 200)]
    [Description('')]
    Fuser: Nullable<string>;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('ep_typ_planu_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fep_typ_planu_id: proxy<Tep_typ_planu>;
    function getep_typ_planu_id: Tep_typ_planu;
    procedure setep_typ_planu_id(const Value : Tep_typ_planu);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property active: boolean read Factive write Factive;
    property priorita: Integer read Fpriorita write Fpriorita;
    property color: Integer read Fcolor write Fcolor;
    property sql: TBlob read Fsql write Fsql;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property usercreated: Nullable<string> read Fusercreated write Fusercreated;
    property user: Nullable<string> read Fuser write Fuser;
    property note: string read Fnote write Fnote;
    property DynCon: TDynamicProperties read FDynCon;
    property ep_typ_planu_id: Tep_typ_planu read getep_typ_planu_id write setep_typ_planu_id;
  end;

  [Entity]
  [Table('ep_config')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_config = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('mezioperacni_cas', [])]
    [Description('')]
    Fmezioperacni_cas : integer;

    [Column('pracovni_rezim', [])]
    [Description('')]
    Fpracovni_rezim : integer;

    [Column('show_weekends', [])]
    [Description('')]
    Fshow_weekends : boolean;

    [Column('pocet_dni', [])]
    [Description('')]
    Fpocet_dni : Integer;

    [Column('plan_jednotek_operation_show', [])]
    [Description('')]
    Fplan_jednotek_operation_show : boolean;

    [Column('logovat', [])]
    [Description('')]
    Flogovat : boolean;

    [Column('engine_response_timeout', [])]
    [Description('')]
    Fengine_response_timeout : Integer;

    [Column('parametry_vypoctu', [])]
    [Description('')]
    Fparametry_vypoctu : boolean;

    [Column('plan_hodin_dle_workers', [])]
    [Description('')]
    Fplan_hodin_dle_workers : boolean;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property mezioperacni_cas: Integer read Fmezioperacni_cas write Fmezioperacni_cas;
    property pracovni_rezim: Integer read Fpracovni_rezim write Fpracovni_rezim;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property pocet_dni: Integer read Fpocet_dni write Fpocet_dni;
    property engine_response_timeout: Integer read Fengine_response_timeout write Fengine_response_timeout;
    property show_weekends: boolean read Fshow_weekends write Fshow_weekends;
    property plan_jednotek_operation_show : boolean read Fplan_jednotek_operation_show write Fplan_jednotek_operation_show;
    property logovat : boolean read Flogovat write Flogovat;
    property parametry_vypoctu: boolean read Fparametry_vypoctu write Fparametry_vypoctu;
    property plan_hodin_dle_workers: boolean read Fplan_hodin_dle_workers write Fplan_hodin_dle_workers;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ep_resource_plan')]
  [Description('Pln pro plnovac jednotky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_resource_plan = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('Resource_id', [TColumnProp.Required])]
    [Description('')]
    FResource_id: Int64;
    
    [Column('ep_simulace_id', [TColumnProp.Required])]
    [Description('')]
    Fep_simulace_id: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('hodin', [TColumnProp.Required], 11, 3)]
    [Description('')]
    Fhodin: Double;
    
    [Column('note', [TColumnProp.Required], 200)]
    [Description('')]
    Fnote: string;

    [Column('default', [TColumnProp.Required])]
    [Description('')]
    Fdefault: Integer;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property Resource_id: Int64 read FResource_id write FResource_id;
    property ep_simulace_id: Integer read Fep_simulace_id write Fep_simulace_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property hodin: Double read Fhodin write Fhodin;
    property note: string read Fnote write Fnote;
    property default: Integer read Fdefault write Fdefault;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ep_resource_plan_default')]
  [Description('Pln pro plnovac jednotky default')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_resource_plan_default = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('ep_resource_plan_typ_id', [TColumnProp.Required])]
    [Description('')]
    Fep_resource_plan_typ_id: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('hodin', [TColumnProp.Required], 11, 3)]
    [Description('')]
    Fhodin: Double;
    
    [Column('note', [TColumnProp.Required], 200)]
    [Description('')]
    Fnote: string;
    
    [Column('dayofweek', [TColumnProp.Required])]
    [Description('')]
    Fdayofweek: Integer;
    
    [Column('user_created', [], 200)]
    [Description('')]
    Fuser_created: Nullable<string>;
    
    [Column('user_lastchange', [], 200)]
    [Description('')]
    Fuser_lastchange: Nullable<string>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('Resource_id', [TColumnProp.Required], 'ID')]
    [Description('')]
    FResource_id: proxy<Tep_schedulerresource>;
    function getResource_id: Tep_schedulerresource;
    procedure setResource_id(const Value : Tep_schedulerresource);
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property ep_resource_plan_typ_id: Integer read Fep_resource_plan_typ_id write Fep_resource_plan_typ_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property hodin: Double read Fhodin write Fhodin;
    property note: string read Fnote write Fnote;
    property dayofweek: Integer read Fdayofweek write Fdayofweek;
    property user_created: Nullable<string> read Fuser_created write Fuser_created;
    property user_lastchange: Nullable<string> read Fuser_lastchange write Fuser_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property Resource_id: Tep_schedulerresource read getResource_id write setResource_id;
  end;
  
  [Entity]
  [Table('ep_resource_plan_typ')]
  [Description('Typ default plnu pro plnovac jednotky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_resource_plan_typ = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 30)]
    [Description('')]
    Fname: string;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ep_schedulerresource')]
  [Description('Jednotky planovaciho kalendare')]
  [Id('FID', TIdGenerator.IdentityOrSequence)]
  Tep_schedulerresource = class(TTMSAGObject)
  private
    [Column('ID', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    FID: Int64;
    
    [Column('Color', [TColumnProp.Required])]
    [Description('')]
    FColor: Integer;
    
    [Column('Name', [TColumnProp.Required], 50)]
    [Description('')]
    FName: string;
    
    [Column('master_id', [])]
    [Description('')]
    Fmaster_id: Nullable<Integer>;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('usercreated', [], 200)]
    [Description('')]
    Fusercreated: Nullable<string>;
    
    [Column('user', [], 200)]
    [Description('')]
    Fuser: Nullable<string>;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('parent_id', [], 'ID')]
    [Description('')]
    Fparent_id: proxy<Tep_schedulerresource>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'FResource_id')]
    Fep_resource_plan_defaultList: Proxy<TList<Tep_resource_plan_default>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_ep_planjednotka_workerList: Proxy<TList<Tref_ep_planjednotka_worker>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_ep_planjednotka_operationList: Proxy<TList<Tref_ep_planjednotka_operation>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_ep_planjednotka_operation_groupList: Proxy<TList<Tref_ep_planjednotka_operation_group>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_ep_planjednotka_CNCList: Proxy<TList<Tref_ep_planjednotka_cnc>>;

    function Getep_resource_plan_defaultList: TList<Tep_resource_plan_default>;
    function Getref_ep_planjednotka_workerList: TList<Tref_ep_planjednotka_worker>;
    function Getref_ep_planjednotka_operationList: TList<Tref_ep_planjednotka_operation>;
    function Getref_ep_planjednotka_operation_groupList: TList<Tref_ep_planjednotka_operation_group>;
    function Getref_ep_planjednotka_CNCList: TList<Tref_ep_planjednotka_cnc>;

    function getparent_id: Tep_schedulerresource;
    procedure setparent_id(const Value : Tep_schedulerresource);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    property ID: Int64 read FID write FID;
    property Color: Integer read FColor write FColor;
    property Name: string read FName write FName;
    property master_id: Nullable<Integer> read Fmaster_id write Fmaster_id;
    property priorita: Integer read Fpriorita write Fpriorita;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property usercreated: Nullable<string> read Fusercreated write Fusercreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property parent_id: Tep_schedulerresource read getparent_id write setparent_id;
    property ep_resource_plan_defaultList: TList<Tep_resource_plan_default> read Getep_resource_plan_defaultList;
    property ref_ep_planjednotka_workerList: TList<Tref_ep_planjednotka_worker> read Getref_ep_planjednotka_workerList;
    property ref_ep_planjednotka_operationList: TList<Tref_ep_planjednotka_operation> read Getref_ep_planjednotka_operationList;
    property ref_ep_planjednotka_operation_groupList: TList<Tref_ep_planjednotka_operation_group> read Getref_ep_planjednotka_operation_groupList;
    property ref_ep_planjednotka_CNCList: TList<Tref_ep_planjednotka_cnc> read Getref_ep_planjednotka_CNCList;

  end;

  [Entity]
  [Table('ep_simulace')]
  [Description('Tabulka variant simulac')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_simulace = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    
    [Column('note', [TColumnProp.Required], 200)]
    [Description('')]
    Fnote: string;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;

    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ep_typ_planu_id', [], 'id')]
    [Description('')]
    Fep_typ_planu_id: proxy<Tep_typ_planu>;
    function getep_typ_planu_id: Tep_typ_planu;
    procedure setep_typ_planu_id(const Value : Tep_typ_planu);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    Function CanEditRecord(var aMessage : String): Boolean; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property nazev: string read Fnazev write Fnazev;
    property note: string read Fnote write Fnote;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property ep_typ_planu_id: Tep_typ_planu read getep_typ_planu_id write setep_typ_planu_id;
  end;
  
  [Entity]
  [Table('ep_simulace_c_order')]
  [Description('Kopie c_order pro varianty pro simulaci')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_simulace_c_order = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('order_id', [TColumnProp.Required])]
    [Description('')]
    Forder_id: Int64;
    
    [Column('ep_simulace_id', [TColumnProp.Required])]
    [Description('')]
    Fep_simulace_id: Integer;
    
    [Column('ep_typ_planu_ID', [TColumnProp.Required])]
    [Description('')]
    Fep_typ_planu_ID: Integer;
    
    [Column('start_req', [TColumnProp.Required])]
    [Description('')]
    Fstart_req: TDateTime;
    
    [Column('finish_req', [TColumnProp.Required])]
    [Description('')]
    Ffinish_req: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property order_id: Int64 read Forder_id write Forder_id;
    property ep_simulace_id: Integer read Fep_simulace_id write Fep_simulace_id;
    property ep_typ_planu_ID: Integer read Fep_typ_planu_ID write Fep_typ_planu_ID;
    property start_req: TDateTime read Fstart_req write Fstart_req;
    property finish_req: TDateTime read Ffinish_req write Ffinish_req;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ep_simulace_order_work')]
  [Description('Kopie order_work pro varianty pro simulac')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_simulace_order_work = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('order_work_id', [TColumnProp.Required])]
    [Description('')]
    Forder_work_id: Integer;
    
    [Column('ep_simulace_id', [TColumnProp.Required])]
    [Description('')]
    Fep_simulace_id: Integer;
    
    [Column('ep_typ_planu_ID', [TColumnProp.Required])]
    [Description('')]
    Fep_typ_planu_ID: Integer;
    
    [Column('start_req', [TColumnProp.Required])]
    [Description('')]
    Fstart_req: TDateTime;
    
    [Column('finish_req', [TColumnProp.Required])]
    [Description('')]
    Ffinish_req: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property order_work_id: Integer read Forder_work_id write Forder_work_id;
    property ep_simulace_id: Integer read Fep_simulace_id write Fep_simulace_id;
    property ep_typ_planu_ID: Integer read Fep_typ_planu_ID write Fep_typ_planu_ID;
    property start_req: TDateTime read Fstart_req write Fstart_req;
    property finish_req: TDateTime read Ffinish_req write Ffinish_req;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ep_typ_planu')]
  [Description('Tabulka verz plnovae')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tep_typ_planu = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    
    [Column('smer', [])]
    [Description('')]
    Fsmer: Nullable<Integer>;
    
    [Column('fixace', [])]
    [Description('')]
    Ffixace: Nullable<Integer>;
    
    [Column('color', [TColumnProp.Required])]
    [Description('')]
    Fcolor: Integer;
    
    [Column('aktivni', [TColumnProp.Required])]
    [Description('')]
    Faktivni: Integer;
    
    [Column('note', [TColumnProp.Required], 1000)]
    [Description('')]
    Fnote: string;
    
    [Column('verze', [TColumnProp.Required])]
    [Description('')]
    Fverze: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property smer: Nullable<Integer> read Fsmer write Fsmer;
    property fixace: Nullable<Integer> read Ffixace write Ffixace;
    property color: Integer read Fcolor write Fcolor;
    property aktivni: Integer read Faktivni write Faktivni;
    property note: string read Fnote write Fnote;
    property verze: Integer read Fverze write Fverze;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('faktury')]
  [Description('Faktury k zakzkm')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tfaktury = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('cislo', [TColumnProp.Required], 50)]
    [Description('')]
    Fcislo: string;
    
    [Column('popis', [TColumnProp.Required], 200)]
    [Description('')]
    Fpopis: string;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;
    
    [Column('castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka: Double;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('datum_platby', [TColumnProp.Required])]
    [Description('')]
    Fdatum_platby: TDateTime;
    
    [Column('castka_dph', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka_dph: Double;
    
    [Column('sazba_dph', [TColumnProp.Required], 5, 2)]
    [Description('')]
    Fsazba_dph: Double;
    
    [Column('use_zaklad', [TColumnProp.Required])]
    [Description('')]
    Fuse_zaklad: Integer;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property cislo: string read Fcislo write Fcislo;
    property popis: string read Fpopis write Fpopis;
    property datum: TDateTime read Fdatum write Fdatum;
    property castka: Double read Fcastka write Fcastka;
    property user: string read Fuser write Fuser;
    property datum_platby: TDateTime read Fdatum_platby write Fdatum_platby;
    property castka_dph: Double read Fcastka_dph write Fcastka_dph;
    property sazba_dph: Double read Fsazba_dph write Fsazba_dph;
    property use_zaklad: Integer read Fuse_zaklad write Fuse_zaklad;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('formy_skupina')]
  [Description('Skupiny forem')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tformy_skupina = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 255)]
    [Description('')]
    Fname: string;
    
    [Column('parent_id', [TColumnProp.Required])]
    [Description('')]
    Fparent_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property parent_id: Integer read Fparent_id write Fparent_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('form_caption_hook')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tform_caption_hook = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('FormName', [], 100)]
    [Description('')]
    FFormName: Nullable<string>;
    
    [Column('ComponentType', [], 100)]
    [Description('')]
    FComponentType: Nullable<string>;
    
    [Column('ComponentName', [], 100)]
    [Description('')]
    FComponentName: Nullable<string>;
    
    [Column('ComponentProperty', [], 100)]
    [Description('')]
    FComponentProperty: Nullable<string>;
    
    [Column('Value', [], 100)]
    [Description('')]
    FValue: Nullable<string>;
    
    [Column('Language', [], 100)]
    [Description('')]
    FLanguage: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property FormName: Nullable<string> read FFormName write FFormName;
    property ComponentType: Nullable<string> read FComponentType write FComponentType;
    property ComponentName: Nullable<string> read FComponentName write FComponentName;
    property ComponentProperty: Nullable<string> read FComponentProperty write FComponentProperty;
    property Value: Nullable<string> read FValue write FValue;
    property Language: Nullable<string> read FLanguage write FLanguage;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('gdpr_fields')]
  [Description('Tabulka GDPR poloek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tgdpr_fields = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('table_name', [], 100)]
    [Description('')]
    Ftable_name: Nullable<string>;
    
    [Column('field_name', [], 100)]
    [Description('')]
    Ffield_name: Nullable<string>;
    
    [Column('description', [], 150)]
    [Description('')]
    Fdescription: Nullable<string>;
    
    [Column('selected', [])]
    [Description('')]
    Fselected: Nullable<Integer>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property table_name: Nullable<string> read Ftable_name write Ftable_name;
    property field_name: Nullable<string> read Ffield_name write Ffield_name;
    property description: Nullable<string> read Fdescription write Fdescription;
    property selected: Nullable<Integer> read Fselected write Fselected;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('gdpr_logs')]
  [Description('Tabulka GDPR log')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tgdpr_logs = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('time_stamp', [TColumnProp.Required])]
    [Description('')]
    Ftime_stamp: TDateTime;
    
    [Column('table_name', [], 100)]
    [Description('')]
    Ftable_name: Nullable<string>;
    
    [Column('field_name', [], 100)]
    [Description('')]
    Ffield_name: Nullable<string>;
    
    [Column('description', [], 150)]
    [Description('')]
    Fdescription: Nullable<string>;
    
    [Column('oldvalue', [], 255)]
    [Description('')]
    Foldvalue: Nullable<string>;
    
    [Column('newvalue', [], 255)]
    [Description('')]
    Fnewvalue: Nullable<string>;
    
    [Column('username', [], 50)]
    [Description('')]
    Fusername: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property time_stamp: TDateTime read Ftime_stamp write Ftime_stamp;
    property table_name: Nullable<string> read Ftable_name write Ftable_name;
    property field_name: Nullable<string> read Ffield_name write Ffield_name;
    property description: Nullable<string> read Fdescription write Fdescription;
    property oldvalue: Nullable<string> read Foldvalue write Foldvalue;
    property newvalue: Nullable<string> read Fnewvalue write Fnewvalue;
    property username: Nullable<string> read Fusername write Fusername;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('gdpr_settings')]
  [Description('Tabulka nastaven pro GDPR')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tgdpr_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('aktivni', [TColumnProp.Required])]
    [Description('')]
    Faktivni: Integer;
    
    [Column('dny_keep_zakaznik', [TColumnProp.Required])]
    [Description('')]
    Fdny_keep_zakaznik: Integer;
    
    [Column('dny_keep_zamestnanec', [TColumnProp.Required])]
    [Description('')]
    Fdny_keep_zamestnanec: Integer;
    
    [Column('dny_keep_auditlog', [TColumnProp.Required])]
    [Description('')]
    Fdny_keep_auditlog: Integer;
    
    [Column('dny_keep_systemlog', [TColumnProp.Required])]
    [Description('')]
    Fdny_keep_systemlog: Integer;
    
    [Column('dny_keep_printlog', [TColumnProp.Required])]
    [Description('')]
    Fdny_keep_printlog: Integer;
    
    [Column('dny_keep_otherlogs', [TColumnProp.Required])]
    [Description('')]
    Fdny_keep_otherlogs: Integer;
    
    [Column('zablok_prihlas', [TColumnProp.Required])]
    [Description('')]
    Fzablok_prihlas: Integer;
    
    [Column('zablok_prihlas_pocet', [TColumnProp.Required])]
    [Description('')]
    Fzablok_prihlas_pocet: Integer;
    
    [Column('zablok_prihlas_mail', [TColumnProp.Required])]
    [Description('')]
    Fzablok_prihlas_mail: Integer;
    
    [Column('zablok_prihlas_server', [TColumnProp.Required], 128)]
    [Description('')]
    Fzablok_prihlas_server: string;
    
    [Column('zablok_prihlas_user', [TColumnProp.Required], 128)]
    [Description('')]
    Fzablok_prihlas_user: string;
    
    [Column('zablok_prihlas_password', [TColumnProp.Required], 256)]
    [Description('')]
    Fzablok_prihlas_password: string;
    
    [Column('heslo_vyzadovat_min_delku', [TColumnProp.Required])]
    [Description('')]
    Fheslo_vyzadovat_min_delku: Integer;
    
    [Column('heslo_min_delka', [TColumnProp.Required])]
    [Description('')]
    Fheslo_min_delka: Integer;
    
    [Column('heslo_jine_nez_user', [TColumnProp.Required])]
    [Description('')]
    Fheslo_jine_nez_user: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property aktivni: Integer read Faktivni write Faktivni;
    property dny_keep_zakaznik: Integer read Fdny_keep_zakaznik write Fdny_keep_zakaznik;
    property dny_keep_zamestnanec: Integer read Fdny_keep_zamestnanec write Fdny_keep_zamestnanec;
    property dny_keep_auditlog: Integer read Fdny_keep_auditlog write Fdny_keep_auditlog;
    property dny_keep_systemlog: Integer read Fdny_keep_systemlog write Fdny_keep_systemlog;
    property dny_keep_printlog: Integer read Fdny_keep_printlog write Fdny_keep_printlog;
    property dny_keep_otherlogs: Integer read Fdny_keep_otherlogs write Fdny_keep_otherlogs;
    property zablok_prihlas: Integer read Fzablok_prihlas write Fzablok_prihlas;
    property zablok_prihlas_pocet: Integer read Fzablok_prihlas_pocet write Fzablok_prihlas_pocet;
    property zablok_prihlas_mail: Integer read Fzablok_prihlas_mail write Fzablok_prihlas_mail;
    property zablok_prihlas_server: string read Fzablok_prihlas_server write Fzablok_prihlas_server;
    property zablok_prihlas_user: string read Fzablok_prihlas_user write Fzablok_prihlas_user;
    property zablok_prihlas_password: string read Fzablok_prihlas_password write Fzablok_prihlas_password;
    property heslo_vyzadovat_min_delku: Integer read Fheslo_vyzadovat_min_delku write Fheslo_vyzadovat_min_delku;
    property heslo_min_delka: Integer read Fheslo_min_delka write Fheslo_min_delka;
    property heslo_jine_nez_user: Integer read Fheslo_jine_nez_user write Fheslo_jine_nez_user;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('global_settings')]
  [Description('Tabulka nastaveni')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tglobal_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('vyber_prijemky', [TColumnProp.Required])]
    [Description('')]
    Fvyber_prijemky: Integer;
    
    [Column('komentar_do_predpokladmat', [TColumnProp.Required])]
    [Description('')]
    Fkomentar_do_predpokladmat: Integer;
    
    [Column('ukony_komentar_ukonu', [TColumnProp.Required])]
    [Description('')]
    Fukony_komentar_ukonu: Integer;
    
    [Column('slozka_fotky', [TColumnProp.Required], 128)]
    [Description('')]
    Fslozka_fotky: string;
    
    [Column('use_importmoney', [TColumnProp.Required])]
    [Description('')]
    Fuse_importmoney: Integer;
    
    [Column('slozka_money', [TColumnProp.Required], 128)]
    [Description('')]
    Fslozka_money: string;
    
    [Column('initdir_skladmatedit', [TColumnProp.Required], 255)]
    [Description('')]
    Finitdir_skladmatedit: string;
    
    [Column('initdir_prijemka', [TColumnProp.Required], 255)]
    [Description('')]
    Finitdir_prijemka: string;
    
    [Column('initdir_dokument', [TColumnProp.Required], 255)]
    [Description('')]
    Finitdir_dokument: string;
    
    [Column('nazevprijemky_dle_souboru', [TColumnProp.Required])]
    [Description('')]
    Fnazevprijemky_dle_souboru: Integer;
    
    [Column('order_ciselnavolitelna1_popis', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_ciselnavolitelna1_popis: string;
    
    [Column('order_ciselnavolitelna2_popis', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_ciselnavolitelna2_popis: string;
    
    [Column('wc_pauza_barid', [TColumnProp.Required], 64)]
    [Description('')]
    Fwc_pauza_barid: string;
    
    [Column('wc_pauza_limit', [TColumnProp.Required])]
    [Description('')]
    Fwc_pauza_limit: Integer;
    
    [Column('zakazky_kod_nazev', [TColumnProp.Required])]
    [Description('')]
    Fzakazky_kod_nazev: Integer;
    
    [Column('vyskladnovat_s_pevnou_cenou', [TColumnProp.Required])]
    [Description('')]
    Fvyskladnovat_s_pevnou_cenou: Integer;
    
    [Column('defaultni_marze', [TColumnProp.Required],15,3)]
    [Description('')]
    Fdefaultni_marze: double;
    
    [Column('dochazka_typ', [TColumnProp.Required])]
    [Description('')]
    Fdochazka_typ: Integer;
    
    [Column('dochazka_zaokrouhlovat_na', [TColumnProp.Required])]
    [Description('')]
    Fdochazka_zaokrouhlovat_na: Integer;
    
    [Column('dochazka_sumy_ve_dnech', [TColumnProp.Required])]
    [Description('')]
    Fdochazka_sumy_ve_dnech: Integer;
    
    [Column('dochazka_rozpoznavat_smeny', [TColumnProp.Required])]
    [Description('')]
    Fdochazka_rozpoznavat_smeny: Integer;
    
    [Column('zauctovano_zakazky_stav', [TColumnProp.Required])]
    [Description('')]
    Fzauctovano_zakazky_stav: Integer;
    
    [Column('money_vychozi_stav_id', [TColumnProp.Required])]
    [Description('')]
    Fmoney_vychozi_stav_id: Integer;
    
    [Column('vychozi_typ_ceny_ukonu', [TColumnProp.Required])]
    [Description('')]
    Fvychozi_typ_ceny_ukonu: Integer;
    
    [Column('zak_bez_marze', [TColumnProp.Required])]
    [Description('')]
    Fzak_bez_marze: Integer;
    
    [Column('users_columns', [TColumnProp.Required])]
    [Description('')]
    Fusers_columns: Integer;
    
    [Column('faktura_zakazky_stav_1', [TColumnProp.Required])]
    [Description('')]
    Ffaktura_zakazky_stav_1: Integer;
    
    [Column('faktura_zakazky_stav_2', [TColumnProp.Required])]
    [Description('')]
    Ffaktura_zakazky_stav_2: Integer;
    
    [Column('probiha_klon', [TColumnProp.Required])]
    [Description('')]
    Fprobiha_klon: Integer;
    
    [Column('delit_dochazku', [TColumnProp.Required])]
    [Description('')]
    Fdelit_dochazku: Integer;
    
    [Column('print_podpis', [TColumnProp.Required], 255)]
    [Description('')]
    Fprint_podpis: string;
    
    [Column('use_dph', [TColumnProp.Required])]
    [Description('')]
    Fuse_dph: Integer;
    
    [Column('one_prijm_for_obj', [TColumnProp.Required])]
    [Description('')]
    Fone_prijm_for_obj: Integer;
    
    [Column('edt_smr_from_ord', [TColumnProp.Required])]
    [Description('')]
    Fedt_smr_from_ord: Integer;
    
    [Column('ord_ins_nonsklad', [TColumnProp.Required])]
    [Description('')]
    Ford_ins_nonsklad: Integer;
    
    [Column('ord_sum_uprice', [TColumnProp.Required])]
    [Description('')]
    Ford_sum_uprice: Integer;
    
    [Column('ocr_bar_id', [TColumnProp.Required], 64)]
    [Description('')]
    Focr_bar_id: string;
    
    [Column('ord_only_work_day_left', [TColumnProp.Required])]
    [Description('')]
    Ford_only_work_day_left: Integer;
    
    [Column('def_pay_fak', [TColumnProp.Required])]
    [Description('')]
    Fdef_pay_fak: Integer;
    
    [Column('fr_exportdir', [TColumnProp.Required], 256)]
    [Description('')]
    Ffr_exportdir: string;
    
    [Column('fr_savestyl', [TColumnProp.Required])]
    [Description('')]
    Ffr_savestyl: Integer;
    
    [Column('ord_iq_filtr_rd', [TColumnProp.Required])]
    [Description('')]
    Ford_iq_filtr_rd: Integer;
    
    [Column('doch_no_comm', [TColumnProp.Required])]
    [Description('')]
    Fdoch_no_comm: Integer;
    
    [Column('doch_break_round', [TColumnProp.Required])]
    [Description('')]
    Fdoch_break_round: Integer;
    
    [Column('doch_break_bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoch_break_bar_id: string;
    
    [Column('lck_time_use', [TColumnProp.Required])]
    [Description('')]
    Flck_time_use: Integer;
    
    [Column('ord_show_koop', [TColumnProp.Required])]
    [Description('')]
    Ford_show_koop: Integer;
    
    [Column('doch_spec_prescas', [TColumnProp.Required])]
    [Description('')]
    Fdoch_spec_prescas: Integer;
    
    [Column('prijm_noch_edit_price', [TColumnProp.Required])]
    [Description('')]
    Fprijm_noch_edit_price: Integer;
    
    [Column('WebService_PIN_Auth', [TColumnProp.Required])]
    [Description('')]
    FWebService_PIN_Auth: Integer;
    
    [Column('vychozi_stav_zakazky', [TColumnProp.Required])]
    [Description('')]
    Fvychozi_stav_zakazky: Integer;
    
    [Column('prijm_sil_ctecka', [TColumnProp.Required])]
    [Description('')]
    Fprijm_sil_ctecka: Integer;
    
    [Column('ord_uspora', [TColumnProp.Required])]
    [Description('')]
    Ford_uspora: Integer;
    
    [Column('doch_neuk_back', [TColumnProp.Required])]
    [Description('')]
    Fdoch_neuk_back: Integer;
    
    [Column('default_unit', [TColumnProp.Required])]
    [Description('')]
    Fdefault_unit: Integer;
    
    [Column('cazer_sklad_id', [TColumnProp.Required])]
    [Description('')]
    Fcazer_sklad_id: Integer;
    
    [Column('use_fastreport', [TColumnProp.Required])]
    [Description('')]
    Fuse_fastreport: Integer;
    
    [Column('grafickyprehled_refresh', [TColumnProp.Required])]
    [Description('')]
    Fgrafickyprehled_refresh: Integer;
    
    [Column('zobrazit_cely_sklad', [TColumnProp.Required])]
    [Description('')]
    Fzobrazit_cely_sklad: Integer;
    
    [Column('import_ext', [TColumnProp.Required])]
    [Description('')]
    Fimport_ext: Integer;
    
    [Column('import_ext_caption', [TColumnProp.Required], 30)]
    [Description('')]
    Fimport_ext_caption: string;
    
    [Column('import_ext_exec', [TColumnProp.Required], 150)]
    [Description('')]
    Fimport_ext_exec: string;
    
    [Column('import_ext_params', [TColumnProp.Required], 150)]
    [Description('')]
    Fimport_ext_params: string;
    
    [Column('aktualni_stav_novy', [TColumnProp.Required])]
    [Description('')]
    Faktualni_stav_novy: Integer;
    
    [Column('KontrolaMnozstvi', [TColumnProp.Required])]
    [Description('')]
    FKontrolaMnozstvi: Integer;
    
    [Column('KontrolaMnozstviOperaceTyp', [TColumnProp.Required])]
    [Description('')]
    FKontrolaMnozstviOperaceTyp: Integer;
    
    [Column('KontrolaMnozstviOperacePrekroceni', [TColumnProp.Required])]
    [Description('')]
    FKontrolaMnozstviOperacePrekroceni: Integer;
    
    [Column('KontrolaMnozstviNesmiPrekrocitZakazku', [TColumnProp.Required])]
    [Description('')]
    FKontrolaMnozstviNesmiPrekrocitZakazku: Integer;
    
    [Column('KontrolaMnozstviOperaceHodnota', [TColumnProp.Required], 8, 0)]
    [Description('')]
    FKontrolaMnozstviOperaceHodnota: Double;
    
    [Column('url_prefix_image', [TColumnProp.Required], 2048)]
    [Description('')]
    Furl_prefix_image: string;
    
    [Column('objednavky_prijate_enabled', [TColumnProp.Required])]
    [Description('')]
    Fobjednavky_prijate_enabled: Integer;
    
    [Column('efektivita_order_work', [TColumnProp.Required])]
    [Description('')]
    Fefektivita_order_work: Integer;
    
    [Column('limit_zaznamu', [TColumnProp.Required])]
    [Description('')]
    Flimit_zaznamu: Integer;
    
    [Column('limit_zaznamu_pocet', [TColumnProp.Required])]
    [Description('')]
    Flimit_zaznamu_pocet: Integer;
    
    [Column('stav_zasob_do_minusu', [TColumnProp.Required])]
    [Description('')]
    Fstav_zasob_do_minusu: Integer;
    
    [Column('zobrazovat_detail_adres', [TColumnProp.Required])]
    [Description('')]
    Fzobrazovat_detail_adres: Integer;
    
    [Column('zobrazovat_zbyvajici_cas_readdata', [TColumnProp.Required])]
    [Description('')]
    Fzobrazovat_zbyvajici_cas_readdata: Integer;
    
    [Column('plac_volno_bar_id', [TColumnProp.Required], 64)]
    [Description('')]
    Fplac_volno_bar_id: string;
    
    [Column('cazer_sklad_pct', [TColumnProp.Required])]
    [Description('')]
    Fcazer_sklad_pct: Integer;
    
    [Column('vychozi_jazyk', [TColumnProp.Required], 10)]
    [Description('')]
    Fvychozi_jazyk: string;
    
    [Column('order_work_priprava_vypocet', [TColumnProp.Required])]
    [Description('')]
    Forder_work_priprava_vypocet: Integer;
    
    [Column('url_intranet', [TColumnProp.Required], 200)]
    [Description('')]
    Furl_intranet: string;
    
    [Column('cazer_sklad_pct_montaz', [TColumnProp.Required])]
    [Description('')]
    Fcazer_sklad_pct_montaz: Integer;
    
    [Column('cazer_sklad_pct_sprava', [TColumnProp.Required])]
    [Description('')]
    Fcazer_sklad_pct_sprava: Integer;
    
    [Column('orderwork_nove_poradi', [TColumnProp.Required])]
    [Description('')]
    Forderwork_nove_poradi: Integer;
    
    [Column('orderwork_delete_used', [TColumnProp.Required])]
    [Description('')]
    Forderwork_delete_used: Integer;
    
    [Column('order_dokonceno_procent_kusy', [TColumnProp.Required])]
    [Description('')]
    Forder_dokonceno_procent_kusy: Integer;
    
    [Column('CAS_DEF_SKLAD_GROUP_DILY', [TColumnProp.Required], 50)]
    [Description('')]
    FCAS_DEF_SKLAD_GROUP_DILY: string;
    
    [Column('doch_absence_bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoch_absence_bar_id: string;
    
    [Column('operation_pct_up', [TColumnProp.Required])]
    [Description('')]
    Foperation_pct_up: Integer;
    
    [Column('order_ciselnavolitelna3_popis', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_ciselnavolitelna3_popis: string;
    
    [Column('cas_klon', [TColumnProp.Required])]
    [Description('')]
    Fcas_klon: TDateTime;
    
    [Column('dl_pocitat_mnozstvi', [TColumnProp.Required])]
    [Description('')]
    Fdl_pocitat_mnozstvi: Integer;
    
    [Column('dl_vytvorit_vydejku', [TColumnProp.Required])]
    [Description('')]
    Fdl_vytvorit_vydejku: Integer;
    
    [Column('dl_pocitat_mnozstvi_from', [TColumnProp.Required])]
    [Description('')]
    Fdl_pocitat_mnozstvi_from: Integer;
    
    [Column('ow_vicenasobne_poradi', [TColumnProp.Required])]
    [Description('')]
    Fow_vicenasobne_poradi: Integer;
    
    [Column('ow_vicenasobne_only_first', [TColumnProp.Required])]
    [Description('')]
    Fow_vicenasobne_only_first: Integer;
    
    [Column('koeficienty_dle_skupin', [TColumnProp.Required])]
    [Description('')]
    Fkoeficienty_dle_skupin: Integer;
    
    [Column('create_dir_order', [TColumnProp.Required])]
    [Description('')]
    Fcreate_dir_order: Integer;
    
    [Column('create_dir_order_path', [TColumnProp.Required], 255)]
    [Description('')]
    Fcreate_dir_order_path: string;
    
    [Column('order_ciselnavolitelna4_popis', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_ciselnavolitelna4_popis: string;
    
    [Column('import_ext_dl', [TColumnProp.Required])]
    [Description('')]
    Fimport_ext_dl: Integer;
    
    [Column('import_ext_dl_caption', [TColumnProp.Required], 30)]
    [Description('')]
    Fimport_ext_dl_caption: string;
    
    [Column('import_ext_dl_exec', [TColumnProp.Required], 150)]
    [Description('')]
    Fimport_ext_dl_exec: string;
    
    [Column('import_ext_dl_params', [TColumnProp.Required], 150)]
    [Description('')]
    Fimport_ext_dl_params: string;
    
    [Column('orderEditCalc', [TColumnProp.Required])]
    [Description('')]
    ForderEditCalc: Integer;
    
    [Column('orderEditCalcFunctionName', [TColumnProp.Required], 50)]
    [Description('')]
    ForderEditCalcFunctionName: string;
    
    [Column('orderEditCalcScript', [TColumnProp.Required], 4096)]
    [Description('')]
    ForderEditCalcScript: string;
    
    [Column('ORDER_PODZAKAZKA_SUFIX_FROM_DEFAULT', [TColumnProp.Required])]
    [Description('')]
    FORDER_PODZAKAZKA_SUFIX_FROM_DEFAULT: Integer;
    
    [Column('DL_CASTECNE_VYDANE_DO_PODZAKAZKY', [TColumnProp.Required])]
    [Description('')]
    FDL_CASTECNE_VYDANE_DO_PODZAKAZKY: Integer;
    
    [Column('ORDER_BUTTON_SAVE_RECALCULATE', [TColumnProp.Required])]
    [Description('')]
    FORDER_BUTTON_SAVE_RECALCULATE: Integer;
    
    [Column('PRINTWORKER_SKUPINY_CHANGE', [TColumnProp.Required])]
    [Description('')]
    FPRINTWORKER_SKUPINY_CHANGE: Integer;
    
    [Column('OBJEDNAVKY_NESESKUPOVAT_MATERIAL', [TColumnProp.Required])]
    [Description('')]
    FOBJEDNAVKY_NESESKUPOVAT_MATERIAL: Integer;
    
    [Column('OBJEDNAVKY_PREBIRAT_ZAKAZKU', [TColumnProp.Required])]
    [Description('')]
    FOBJEDNAVKY_PREBIRAT_ZAKAZKU: Integer;
    
    [Column('create_subdir_order', [TColumnProp.Required])]
    [Description('')]
    Fcreate_subdir_order: Integer;

    [Column('create_subdir_order_path', [TColumnProp.Required], 512)]
    [Description('')]
    Fcreate_subdir_order_path: string;
    
    [Column('newcolumnselector', [TColumnProp.Required])]
    [Description('')]
    Fnewcolumnselector: Integer;
    
    [Column('orderstavdirectorychange', [TColumnProp.Required])]
    [Description('')]
    Forderstavdirectorychange: Integer;
    
    [Column('orderstavdirectorychangepath', [TColumnProp.Required], 200)]
    [Description('')]
    Forderstavdirectorychangepath: string;
    
    [Column('orderstavdirectorychangeactive', [TColumnProp.Required])]
    [Description('')]
    Forderstavdirectorychangeactive: Integer;
    
    [Column('skladpouzitvychozipohyby', [TColumnProp.Required])]
    [Description('')]
    Fskladpouzitvychozipohyby: Integer;

    [Column('skladpouzitvychozipohyby_prijemka', [TColumnProp.Required])]
    [Description('')]
    Fskladpouzitvychozipohyby_prijemka: Integer;
    
    [Column('skladpouzitvychozipohyby_vydejka', [TColumnProp.Required])]
    [Description('')]
    Fskladpouzitvychozipohyby_vydejka: Integer;
    
    [Column('usetisktable', [TColumnProp.Required])]
    [Description('')]
    Fusetisktable: Integer;
    
    [Column('orderwork_neprepocitavat_poradi', [TColumnProp.Required])]
    [Description('')]
    Forderwork_neprepocitavat_poradi: Integer;
    
    [Column('ORDER_SABLONA_VOLITELNE_POLOZKY', [TColumnProp.Required])]
    [Description('')]
    FORDER_SABLONA_VOLITELNE_POLOZKY: Integer;
    
    [Column('ORDER_SABLONA_TYP_ZAKAZKY', [TColumnProp.Required])]
    [Description('')]
    FORDER_SABLONA_TYP_ZAKAZKY: Integer;
    
    [Column('ORDER_SABLONA_CAS_MONTAZE', [TColumnProp.Required])]
    [Description('')]
    FORDER_SABLONA_CAS_MONTAZE: Integer;
    
    [Column('ORDER_SABLONA_KOMENTAR_OBCHODNI', [TColumnProp.Required])]
    [Description('')]
    FORDER_SABLONA_KOMENTAR_OBCHODNI: Integer;
    
    [Column('ORDER_SABLONA_ROZMERY', [TColumnProp.Required])]
    [Description('')]
    FORDER_SABLONA_ROZMERY: Integer;

    [Column('orderWorkEditCalc', [TColumnProp.Required])]
    [Description('')]
    ForderWorkEditCalc: Integer;
    
    [Column('orderWorkEditCalcFunctionName', [TColumnProp.Required], 50)]
    [Description('')]
    ForderWorkEditCalcFunctionName: string;
    
    [Column('orderWorkEditCalcScript', [TColumnProp.Required], 4096)]
    [Description('')]
    ForderWorkEditCalcScript: string;
    
    [Column('naskladneno_zakazky_stav', [TColumnProp.Required])]
    [Description('')]
    Fnaskladneno_zakazky_stav: Integer;
    
    [Column('typ_vypoctu_ceny', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu_ceny: Integer;
    
    [Column('nova_ukol_mzda', [TColumnProp.Required])]
    [Description('')]
    Fnova_ukol_mzda: Integer;
    
    [Column('order_prijem_final_vyrobek', [TColumnProp.Required])]
    [Description('')]
    Forder_prijem_final_vyrobek: Integer;
    
    [Column('order_klon_text', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_klon_text: string;
    
    [Column('sklad_material_cena_celkem_typ', [TColumnProp.Required])]
    [Description('')]
    Fsklad_material_cena_celkem_typ: Integer;
    
    [Column('main_form_buttons_show', [TColumnProp.Required])]
    [Description('')]
    Fmain_form_buttons_show: Integer;
    
    [Column('ORD_INS_NONSKLAD_TYP', [TColumnProp.Required])]
    [Description('')]
    FORD_INS_NONSKLAD_TYP: Integer;
    
    [Column('DEFAULT_MENA', [TColumnProp.Required], 50)]
    [Description('')]
    FDEFAULT_MENA: string;
    
    [Column('MENA_ZKRATKA', [TColumnProp.Required], 50)]
    [Description('')]
    FMENA_ZKRATKA: string;
    
    [Column('CIZI_MENA', [TColumnProp.Required])]
    [Description('')]
    FCIZI_MENA: Integer;
    
    [Column('SKLAD_MATERIAL_VRATKA_POHYB', [TColumnProp.Required])]
    [Description('')]
    FSKLAD_MATERIAL_VRATKA_POHYB: Integer;

    [Column('DL_CHECK_ORDER_BARID_IN_CODE', [TColumnProp.Required])]
    [Description('')]
    FDL_CHECK_ORDER_BARID_IN_CODE: Integer;
    
    [Column('dl_zauctovano_zakazky_stav', [TColumnProp.Required])]
    [Description('')]
    Fdl_zauctovano_zakazky_stav: Integer;
    
    [Column('objednavky_subdodavky_datum', [TColumnProp.Required])]
    [Description('')]
    Fobjednavky_subdodavky_datum: Integer;
    
    [Column('objednavky_subdodavky_cena', [TColumnProp.Required])]
    [Description('')]
    Fobjednavky_subdodavky_cena: Integer;
    
    [Column('dl_vytvoreno_zakazky_stav', [TColumnProp.Required])]
    [Description('')]
    Fdl_vytvoreno_zakazky_stav: Integer;

    [Column('useStavyDokladu', [TColumnProp.Required])]
    [Description('')]
    FuseStavyDokladu: Integer;
    
    [Column('useSkladovePozice', [TColumnProp.Required])]
    [Description('')]
    FuseSkladovePozice: Integer;
    
    [Column('useSkladoveSkupinyBatchOut', [TColumnProp.Required])]
    [Description('')]
    FuseSkladoveSkupinyBatchOut: Integer;
    
    [Column('create_subdir_order_add_name', [TColumnProp.Required])]
    [Description('')]
    Fcreate_subdir_order_add_name: Integer;
    
    [Column('sklad_rozpad_materialu_show', [TColumnProp.Required])]
    [Description('')]
    Fsklad_rozpad_materialu_show: Integer;
    
    [Column('worker_koeficient_default', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fworker_koeficient_default: Double;
    
    [Column('worker_mzda_default', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fworker_mzda_default: Double;
    
    [Column('orderedit_typ_vypoctu_visible', [TColumnProp.Required])]
    [Description('')]
    Forderedit_typ_vypoctu_visible: Integer;
    
    [Column('order_klon_all_operation_planned', [TColumnProp.Required])]
    [Description('')]
    Forder_klon_all_operation_planned: Integer;
    
    [Column('newsqllike', [TColumnProp.Required])]
    [Description('')]
    Fnewsqllike: Integer;
    
    [Column('ordercallintranet', [TColumnProp.Required])]
    [Description('')]
    Fordercallintranet: Integer;
    
    [Column('ordercallintranet_url', [TColumnProp.Required], 500)]
    [Description('')]
    Fordercallintranet_url: string;
    
    [Column('filterreplacecomma', [TColumnProp.Required])]
    [Description('')]
    Ffilterreplacecomma: Integer;
    
    [Column('cnc_cena_default', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcnc_cena_default: Double;
    
    [Column('order_sablona_objednavky', [TColumnProp.Required])]
    [Description('')]
    Forder_sablona_objednavky: Integer;
    
    [Column('worker_use_koeficient2', [TColumnProp.Required])]
    [Description('')]
    Fworker_use_koeficient2: Integer;
    
    [Column('sklad_material_dodavatele_show', [TColumnProp.Required])]
    [Description('')]
    Fsklad_material_dodavatele_show: Integer;
    
    [Column('sklad_material_inventury_show', [TColumnProp.Required])]
    [Description('')]
    Fsklad_material_inventury_show: Integer;
    
    [Column('order_ciselnavolitelna5_popis', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_ciselnavolitelna5_popis: string;
    
    [Column('order_gridCenyCasy', [TColumnProp.Required])]
    [Description('')]
    Forder_gridCenyCasy: Integer;
    
    [Column('operation_usercode_enabled', [TColumnProp.Required])]
    [Description('')]
    Foperation_usercode_enabled: Integer;
    
    [Column('order_ciselnavolitelna6_popis', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_ciselnavolitelna6_popis: string;
    
    [Column('order_subdodavka_prebirat_pocet_mj', [TColumnProp.Required])]
    [Description('')]
    Forder_subdodavka_prebirat_pocet_mj: Integer;
    
    [Column('orderwork_new_poradi_enabled', [TColumnProp.Required])]
    [Description('')]
    Forderwork_new_poradi_enabled: Integer;
    
    [Column('right_panel_show_pozice', [TColumnProp.Required])]
    [Description('')]
    Fright_panel_show_pozice: Integer;
    
    [Column('price_calculate', [TColumnProp.Required])]
    [Description('')]
    Fprice_calculate: Integer;
    
    [Column('order_rozdel_defskupinastavu', [TColumnProp.Required], 100)]
    [Description('')]
    Forder_rozdel_defskupinastavu: string;
    
    [Column('mp_vicenasobne', [TColumnProp.Required])]
    [Description('')]
    Fmp_vicenasobne: Integer;
    
    [Column('use_telemetry', [TColumnProp.Required])]
    [Description('')]
    Fuse_telemetry: Integer;

    [Column('use_poznamka_rtf_format', [TColumnProp.Required])]
    [Description('')]
    Fuse_poznamka_rtf_format: Integer;
    
    [Column('sklad_material_limit_check', [TColumnProp.Required])]
    [Description('')]
    Fsklad_material_limit_check: Integer;
    
    [Column('sklad_material_vydejky_header_autocreate', [TColumnProp.Required])]
    [Description('')]
    Fsklad_material_vydejky_header_autocreate: Integer;
    
    [Column('sklad_material_prijemky_aktualizovat_ceny', [TColumnProp.Required])]
    [Description('')]
    Fsklad_material_prijemky_aktualizovat_ceny: Integer;
    
    [Column('orderwork_edit_operation_change', [TColumnProp.Required])]
    [Description('')]
    Forderwork_edit_operation_change: Integer;
    
    [Column('orderwork_edit_operation_change_recalculate', [TColumnProp.Required])]
    [Description('')]
    Forderwork_edit_operation_change_recalculate: Integer;
    
    [Column('id_skupiny_obedy', [TColumnProp.Required])]
    [Description('')]
    Fid_skupiny_obedy: Integer;
    
    [Column('dochazka_new', [TColumnProp.Required])]
    [Description('')]
    Fdochazka_new: Integer;
    
    [Column('orderwork_edit_operation_fix', [TColumnProp.Required])]
    [Description('')]
    Forderwork_edit_operation_fix: Integer;
    
    [Column('limit_zaznamu_combo_pocet', [TColumnProp.Required])]
    [Description('')]
    Flimit_zaznamu_combo_pocet: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property vyber_prijemky: Integer read Fvyber_prijemky write Fvyber_prijemky;
    property komentar_do_predpokladmat: Integer read Fkomentar_do_predpokladmat write Fkomentar_do_predpokladmat;
    property ukony_komentar_ukonu: Integer read Fukony_komentar_ukonu write Fukony_komentar_ukonu;
    property slozka_fotky: string read Fslozka_fotky write Fslozka_fotky;
    property use_importmoney: Integer read Fuse_importmoney write Fuse_importmoney;
    property slozka_money: string read Fslozka_money write Fslozka_money;
    property initdir_skladmatedit: string read Finitdir_skladmatedit write Finitdir_skladmatedit;
    property initdir_prijemka: string read Finitdir_prijemka write Finitdir_prijemka;
    property initdir_dokument: string read Finitdir_dokument write Finitdir_dokument;
    property nazevprijemky_dle_souboru: Integer read Fnazevprijemky_dle_souboru write Fnazevprijemky_dle_souboru;
    property order_ciselnavolitelna1_popis: string read Forder_ciselnavolitelna1_popis write Forder_ciselnavolitelna1_popis;
    property order_ciselnavolitelna2_popis: string read Forder_ciselnavolitelna2_popis write Forder_ciselnavolitelna2_popis;
    property wc_pauza_barid: string read Fwc_pauza_barid write Fwc_pauza_barid;
    property wc_pauza_limit: Integer read Fwc_pauza_limit write Fwc_pauza_limit;
    property zakazky_kod_nazev: Integer read Fzakazky_kod_nazev write Fzakazky_kod_nazev;
    property vyskladnovat_s_pevnou_cenou: Integer read Fvyskladnovat_s_pevnou_cenou write Fvyskladnovat_s_pevnou_cenou;
    property defaultni_marze: double read Fdefaultni_marze write Fdefaultni_marze;
    property dochazka_typ: Integer read Fdochazka_typ write Fdochazka_typ;
    property dochazka_zaokrouhlovat_na: Integer read Fdochazka_zaokrouhlovat_na write Fdochazka_zaokrouhlovat_na;
    property dochazka_sumy_ve_dnech: Integer read Fdochazka_sumy_ve_dnech write Fdochazka_sumy_ve_dnech;
    property dochazka_rozpoznavat_smeny: Integer read Fdochazka_rozpoznavat_smeny write Fdochazka_rozpoznavat_smeny;
    property zauctovano_zakazky_stav: Integer read Fzauctovano_zakazky_stav write Fzauctovano_zakazky_stav;
    property money_vychozi_stav_id: Integer read Fmoney_vychozi_stav_id write Fmoney_vychozi_stav_id;
    property vychozi_typ_ceny_ukonu: Integer read Fvychozi_typ_ceny_ukonu write Fvychozi_typ_ceny_ukonu;
    property zak_bez_marze: Integer read Fzak_bez_marze write Fzak_bez_marze;
    property users_columns: Integer read Fusers_columns write Fusers_columns;
    property faktura_zakazky_stav_1: Integer read Ffaktura_zakazky_stav_1 write Ffaktura_zakazky_stav_1;
    property faktura_zakazky_stav_2: Integer read Ffaktura_zakazky_stav_2 write Ffaktura_zakazky_stav_2;
    property probiha_klon: Integer read Fprobiha_klon write Fprobiha_klon;
    property delit_dochazku: Integer read Fdelit_dochazku write Fdelit_dochazku;
    property print_podpis: string read Fprint_podpis write Fprint_podpis;
    property use_dph: Integer read Fuse_dph write Fuse_dph;
    property one_prijm_for_obj: Integer read Fone_prijm_for_obj write Fone_prijm_for_obj;
    property edt_smr_from_ord: Integer read Fedt_smr_from_ord write Fedt_smr_from_ord;
    property ord_ins_nonsklad: Integer read Ford_ins_nonsklad write Ford_ins_nonsklad;
    property ord_sum_uprice: Integer read Ford_sum_uprice write Ford_sum_uprice;
    property ocr_bar_id: string read Focr_bar_id write Focr_bar_id;
    property ord_only_work_day_left: Integer read Ford_only_work_day_left write Ford_only_work_day_left;
    property def_pay_fak: Integer read Fdef_pay_fak write Fdef_pay_fak;
    property fr_exportdir: string read Ffr_exportdir write Ffr_exportdir;
    property fr_savestyl: Integer read Ffr_savestyl write Ffr_savestyl;
    property ord_iq_filtr_rd: Integer read Ford_iq_filtr_rd write Ford_iq_filtr_rd;
    property doch_no_comm: Integer read Fdoch_no_comm write Fdoch_no_comm;
    property doch_break_round: Integer read Fdoch_break_round write Fdoch_break_round;
    property doch_break_bar_id: string read Fdoch_break_bar_id write Fdoch_break_bar_id;
    property lck_time_use: Integer read Flck_time_use write Flck_time_use;
    property ord_show_koop: Integer read Ford_show_koop write Ford_show_koop;
    property doch_spec_prescas: Integer read Fdoch_spec_prescas write Fdoch_spec_prescas;
    property prijm_noch_edit_price: Integer read Fprijm_noch_edit_price write Fprijm_noch_edit_price;
    property WebService_PIN_Auth: Integer read FWebService_PIN_Auth write FWebService_PIN_Auth;
    property vychozi_stav_zakazky: Integer read Fvychozi_stav_zakazky write Fvychozi_stav_zakazky;
    property prijm_sil_ctecka: Integer read Fprijm_sil_ctecka write Fprijm_sil_ctecka;
    property ord_uspora: Integer read Ford_uspora write Ford_uspora;
    property doch_neuk_back: Integer read Fdoch_neuk_back write Fdoch_neuk_back;
    property default_unit: Integer read Fdefault_unit write Fdefault_unit;
    property cazer_sklad_id: Integer read Fcazer_sklad_id write Fcazer_sklad_id;
    property use_fastreport: Integer read Fuse_fastreport write Fuse_fastreport;
    property grafickyprehled_refresh: Integer read Fgrafickyprehled_refresh write Fgrafickyprehled_refresh;
    property zobrazit_cely_sklad: Integer read Fzobrazit_cely_sklad write Fzobrazit_cely_sklad;
    property import_ext: Integer read Fimport_ext write Fimport_ext;
    property import_ext_caption: string read Fimport_ext_caption write Fimport_ext_caption;
    property import_ext_exec: string read Fimport_ext_exec write Fimport_ext_exec;
    property import_ext_params: string read Fimport_ext_params write Fimport_ext_params;
    property aktualni_stav_novy: Integer read Faktualni_stav_novy write Faktualni_stav_novy;
    property KontrolaMnozstvi: Integer read FKontrolaMnozstvi write FKontrolaMnozstvi;
    property KontrolaMnozstviOperaceTyp: Integer read FKontrolaMnozstviOperaceTyp write FKontrolaMnozstviOperaceTyp;
    property KontrolaMnozstviOperacePrekroceni: Integer read FKontrolaMnozstviOperacePrekroceni write FKontrolaMnozstviOperacePrekroceni;
    property KontrolaMnozstviNesmiPrekrocitZakazku: Integer read FKontrolaMnozstviNesmiPrekrocitZakazku write FKontrolaMnozstviNesmiPrekrocitZakazku;
    property KontrolaMnozstviOperaceHodnota: Double read FKontrolaMnozstviOperaceHodnota write FKontrolaMnozstviOperaceHodnota;
    property url_prefix_image: string read Furl_prefix_image write Furl_prefix_image;
    property objednavky_prijate_enabled: Integer read Fobjednavky_prijate_enabled write Fobjednavky_prijate_enabled;
    property efektivita_order_work: Integer read Fefektivita_order_work write Fefektivita_order_work;
    property limit_zaznamu: Integer read Flimit_zaznamu write Flimit_zaznamu;
    property limit_zaznamu_pocet: Integer read Flimit_zaznamu_pocet write Flimit_zaznamu_pocet;
    property stav_zasob_do_minusu: Integer read Fstav_zasob_do_minusu write Fstav_zasob_do_minusu;
    property zobrazovat_detail_adres: Integer read Fzobrazovat_detail_adres write Fzobrazovat_detail_adres;
    property zobrazovat_zbyvajici_cas_readdata: Integer read Fzobrazovat_zbyvajici_cas_readdata write Fzobrazovat_zbyvajici_cas_readdata;
    property plac_volno_bar_id: string read Fplac_volno_bar_id write Fplac_volno_bar_id;
    property cazer_sklad_pct: Integer read Fcazer_sklad_pct write Fcazer_sklad_pct;
    property vychozi_jazyk: string read Fvychozi_jazyk write Fvychozi_jazyk;
    property order_work_priprava_vypocet: Integer read Forder_work_priprava_vypocet write Forder_work_priprava_vypocet;
    property url_intranet: string read Furl_intranet write Furl_intranet;
    property cazer_sklad_pct_montaz: Integer read Fcazer_sklad_pct_montaz write Fcazer_sklad_pct_montaz;
    property cazer_sklad_pct_sprava: Integer read Fcazer_sklad_pct_sprava write Fcazer_sklad_pct_sprava;
    property orderwork_nove_poradi: Integer read Forderwork_nove_poradi write Forderwork_nove_poradi;
    property orderwork_delete_used: Integer read Forderwork_delete_used write Forderwork_delete_used;
    property order_dokonceno_procent_kusy: Integer read Forder_dokonceno_procent_kusy write Forder_dokonceno_procent_kusy;
    property CAS_DEF_SKLAD_GROUP_DILY: string read FCAS_DEF_SKLAD_GROUP_DILY write FCAS_DEF_SKLAD_GROUP_DILY;
    property doch_absence_bar_id: string read Fdoch_absence_bar_id write Fdoch_absence_bar_id;
    property operation_pct_up: Integer read Foperation_pct_up write Foperation_pct_up;
    property order_ciselnavolitelna3_popis: string read Forder_ciselnavolitelna3_popis write Forder_ciselnavolitelna3_popis;
    property cas_klon: TDateTime read Fcas_klon write Fcas_klon;
    property dl_pocitat_mnozstvi: Integer read Fdl_pocitat_mnozstvi write Fdl_pocitat_mnozstvi;
    property dl_vytvorit_vydejku: Integer read Fdl_vytvorit_vydejku write Fdl_vytvorit_vydejku;
    property dl_pocitat_mnozstvi_from: Integer read Fdl_pocitat_mnozstvi_from write Fdl_pocitat_mnozstvi_from;
    property ow_vicenasobne_poradi: Integer read Fow_vicenasobne_poradi write Fow_vicenasobne_poradi;
    property ow_vicenasobne_only_first: Integer read Fow_vicenasobne_only_first write Fow_vicenasobne_only_first;
    property koeficienty_dle_skupin: Integer read Fkoeficienty_dle_skupin write Fkoeficienty_dle_skupin;
    property create_dir_order: Integer read Fcreate_dir_order write Fcreate_dir_order;
    property create_dir_order_path: string read Fcreate_dir_order_path write Fcreate_dir_order_path;
    property order_ciselnavolitelna4_popis: string read Forder_ciselnavolitelna4_popis write Forder_ciselnavolitelna4_popis;
    property import_ext_dl: Integer read Fimport_ext_dl write Fimport_ext_dl;
    property import_ext_dl_caption: string read Fimport_ext_dl_caption write Fimport_ext_dl_caption;
    property import_ext_dl_exec: string read Fimport_ext_dl_exec write Fimport_ext_dl_exec;
    property import_ext_dl_params: string read Fimport_ext_dl_params write Fimport_ext_dl_params;
    property orderEditCalc: Integer read ForderEditCalc write ForderEditCalc;
    property orderEditCalcFunctionName: string read ForderEditCalcFunctionName write ForderEditCalcFunctionName;
    property orderEditCalcScript: string read ForderEditCalcScript write ForderEditCalcScript;
    property ORDER_PODZAKAZKA_SUFIX_FROM_DEFAULT: Integer read FORDER_PODZAKAZKA_SUFIX_FROM_DEFAULT write FORDER_PODZAKAZKA_SUFIX_FROM_DEFAULT;
    property DL_CASTECNE_VYDANE_DO_PODZAKAZKY: Integer read FDL_CASTECNE_VYDANE_DO_PODZAKAZKY write FDL_CASTECNE_VYDANE_DO_PODZAKAZKY;
    property ORDER_BUTTON_SAVE_RECALCULATE: Integer read FORDER_BUTTON_SAVE_RECALCULATE write FORDER_BUTTON_SAVE_RECALCULATE;
    property PRINTWORKER_SKUPINY_CHANGE: Integer read FPRINTWORKER_SKUPINY_CHANGE write FPRINTWORKER_SKUPINY_CHANGE;
    property OBJEDNAVKY_NESESKUPOVAT_MATERIAL: Integer read FOBJEDNAVKY_NESESKUPOVAT_MATERIAL write FOBJEDNAVKY_NESESKUPOVAT_MATERIAL;
    property OBJEDNAVKY_PREBIRAT_ZAKAZKU: Integer read FOBJEDNAVKY_PREBIRAT_ZAKAZKU write FOBJEDNAVKY_PREBIRAT_ZAKAZKU;
    property create_subdir_order: Integer read Fcreate_subdir_order write Fcreate_subdir_order;
    property create_subdir_order_path: string read Fcreate_subdir_order_path write Fcreate_subdir_order_path;
    property newcolumnselector: Integer read Fnewcolumnselector write Fnewcolumnselector;
    property orderstavdirectorychange: Integer read Forderstavdirectorychange write Forderstavdirectorychange;
    property orderstavdirectorychangepath: string read Forderstavdirectorychangepath write Forderstavdirectorychangepath;
    property orderstavdirectorychangeactive: Integer read Forderstavdirectorychangeactive write Forderstavdirectorychangeactive;
    property skladpouzitvychozipohyby: Integer read Fskladpouzitvychozipohyby write Fskladpouzitvychozipohyby;
    property skladpouzitvychozipohyby_prijemka: Integer read Fskladpouzitvychozipohyby_prijemka write Fskladpouzitvychozipohyby_prijemka;
    property skladpouzitvychozipohyby_vydejka: Integer read Fskladpouzitvychozipohyby_vydejka write Fskladpouzitvychozipohyby_vydejka;
    property usetisktable: Integer read Fusetisktable write Fusetisktable;
    property orderwork_neprepocitavat_poradi: Integer read Forderwork_neprepocitavat_poradi write Forderwork_neprepocitavat_poradi;
    property ORDER_SABLONA_VOLITELNE_POLOZKY: Integer read FORDER_SABLONA_VOLITELNE_POLOZKY write FORDER_SABLONA_VOLITELNE_POLOZKY;
    property ORDER_SABLONA_TYP_ZAKAZKY: Integer read FORDER_SABLONA_TYP_ZAKAZKY write FORDER_SABLONA_TYP_ZAKAZKY;
    property ORDER_SABLONA_CAS_MONTAZE: Integer read FORDER_SABLONA_CAS_MONTAZE write FORDER_SABLONA_CAS_MONTAZE;
    property ORDER_SABLONA_KOMENTAR_OBCHODNI: Integer read FORDER_SABLONA_KOMENTAR_OBCHODNI write FORDER_SABLONA_KOMENTAR_OBCHODNI;
    property ORDER_SABLONA_ROZMERY: Integer read FORDER_SABLONA_ROZMERY write FORDER_SABLONA_ROZMERY;
    property orderWorkEditCalc: Integer read ForderWorkEditCalc write ForderWorkEditCalc;
    property orderWorkEditCalcFunctionName: string read ForderWorkEditCalcFunctionName write ForderWorkEditCalcFunctionName;
    property orderWorkEditCalcScript: string read ForderWorkEditCalcScript write ForderWorkEditCalcScript;
    property naskladneno_zakazky_stav: Integer read Fnaskladneno_zakazky_stav write Fnaskladneno_zakazky_stav;
    property typ_vypoctu_ceny: Integer read Ftyp_vypoctu_ceny write Ftyp_vypoctu_ceny;
    property nova_ukol_mzda: Integer read Fnova_ukol_mzda write Fnova_ukol_mzda;
    property order_prijem_final_vyrobek: Integer read Forder_prijem_final_vyrobek write Forder_prijem_final_vyrobek;
    property order_klon_text: string read Forder_klon_text write Forder_klon_text;
    property sklad_material_cena_celkem_typ: Integer read Fsklad_material_cena_celkem_typ write Fsklad_material_cena_celkem_typ;
    property main_form_buttons_show: Integer read Fmain_form_buttons_show write Fmain_form_buttons_show;
    property ORD_INS_NONSKLAD_TYP: Integer read FORD_INS_NONSKLAD_TYP write FORD_INS_NONSKLAD_TYP;
    property DEFAULT_MENA: string read FDEFAULT_MENA write FDEFAULT_MENA;
    property MENA_ZKRATKA: string read FMENA_ZKRATKA write FMENA_ZKRATKA;
    property CIZI_MENA: Integer read FCIZI_MENA write FCIZI_MENA;
    property SKLAD_MATERIAL_VRATKA_POHYB: Integer read FSKLAD_MATERIAL_VRATKA_POHYB write FSKLAD_MATERIAL_VRATKA_POHYB;
    property DL_CHECK_ORDER_BARID_IN_CODE: Integer read FDL_CHECK_ORDER_BARID_IN_CODE write FDL_CHECK_ORDER_BARID_IN_CODE;
    property dl_zauctovano_zakazky_stav: Integer read Fdl_zauctovano_zakazky_stav write Fdl_zauctovano_zakazky_stav;
    property objednavky_subdodavky_datum: Integer read Fobjednavky_subdodavky_datum write Fobjednavky_subdodavky_datum;
    property objednavky_subdodavky_cena: Integer read Fobjednavky_subdodavky_cena write Fobjednavky_subdodavky_cena;
    property dl_vytvoreno_zakazky_stav: Integer read Fdl_vytvoreno_zakazky_stav write Fdl_vytvoreno_zakazky_stav;
    property useStavyDokladu: Integer read FuseStavyDokladu write FuseStavyDokladu;
    property useSkladovePozice: Integer read FuseSkladovePozice write FuseSkladovePozice;
    property useSkladoveSkupinyBatchOut: Integer read FuseSkladoveSkupinyBatchOut write FuseSkladoveSkupinyBatchOut;
    property create_subdir_order_add_name: Integer read Fcreate_subdir_order_add_name write Fcreate_subdir_order_add_name;
    property sklad_rozpad_materialu_show: Integer read Fsklad_rozpad_materialu_show write Fsklad_rozpad_materialu_show;
    property worker_koeficient_default: Double read Fworker_koeficient_default write Fworker_koeficient_default;
    property worker_mzda_default: Double read Fworker_mzda_default write Fworker_mzda_default;
    property orderedit_typ_vypoctu_visible: Integer read Forderedit_typ_vypoctu_visible write Forderedit_typ_vypoctu_visible;
    property order_klon_all_operation_planned: Integer read Forder_klon_all_operation_planned write Forder_klon_all_operation_planned;
    property newsqllike: Integer read Fnewsqllike write Fnewsqllike;
    property ordercallintranet: Integer read Fordercallintranet write Fordercallintranet;
    property ordercallintranet_url: string read Fordercallintranet_url write Fordercallintranet_url;
    property filterreplacecomma: Integer read Ffilterreplacecomma write Ffilterreplacecomma;
    property cnc_cena_default: Double read Fcnc_cena_default write Fcnc_cena_default;
    property order_sablona_objednavky: Integer read Forder_sablona_objednavky write Forder_sablona_objednavky;
    property worker_use_koeficient2: Integer read Fworker_use_koeficient2 write Fworker_use_koeficient2;
    property sklad_material_dodavatele_show: Integer read Fsklad_material_dodavatele_show write Fsklad_material_dodavatele_show;
    property sklad_material_inventury_show: Integer read Fsklad_material_inventury_show write Fsklad_material_inventury_show;
    property order_ciselnavolitelna5_popis: string read Forder_ciselnavolitelna5_popis write Forder_ciselnavolitelna5_popis;
    property order_gridCenyCasy: Integer read Forder_gridCenyCasy write Forder_gridCenyCasy;
    property operation_usercode_enabled: Integer read Foperation_usercode_enabled write Foperation_usercode_enabled;
    property order_ciselnavolitelna6_popis: string read Forder_ciselnavolitelna6_popis write Forder_ciselnavolitelna6_popis;
    property order_subdodavka_prebirat_pocet_mj: Integer read Forder_subdodavka_prebirat_pocet_mj write Forder_subdodavka_prebirat_pocet_mj;
    property orderwork_new_poradi_enabled: Integer read Forderwork_new_poradi_enabled write Forderwork_new_poradi_enabled;
    property right_panel_show_pozice: Integer read Fright_panel_show_pozice write Fright_panel_show_pozice;
    property price_calculate: Integer read Fprice_calculate write Fprice_calculate;
    property order_rozdel_defskupinastavu: string read Forder_rozdel_defskupinastavu write Forder_rozdel_defskupinastavu;
    property mp_vicenasobne: Integer read Fmp_vicenasobne write Fmp_vicenasobne;
    property use_telemetry: Integer read Fuse_telemetry write Fuse_telemetry;
    property use_poznamka_rtf_format: Integer read Fuse_poznamka_rtf_format write Fuse_poznamka_rtf_format;
    property sklad_material_limit_check: Integer read Fsklad_material_limit_check write Fsklad_material_limit_check;
    property sklad_material_vydejky_header_autocreate: Integer read Fsklad_material_vydejky_header_autocreate write Fsklad_material_vydejky_header_autocreate;
    property sklad_material_prijemky_aktualizovat_ceny: Integer read Fsklad_material_prijemky_aktualizovat_ceny write Fsklad_material_prijemky_aktualizovat_ceny;
    property orderwork_edit_operation_change: Integer read Forderwork_edit_operation_change write Forderwork_edit_operation_change;
    property orderwork_edit_operation_change_recalculate: Integer read Forderwork_edit_operation_change_recalculate write Forderwork_edit_operation_change_recalculate;
    property id_skupiny_obedy: Integer read Fid_skupiny_obedy write Fid_skupiny_obedy;
    property dochazka_new: Integer read Fdochazka_new write Fdochazka_new;
    property orderwork_edit_operation_fix: Integer read Forderwork_edit_operation_fix write Forderwork_edit_operation_fix;
    property limit_zaznamu_combo_pocet: Integer read Flimit_zaznamu_combo_pocet write Flimit_zaznamu_combo_pocet;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('global_settings_global_fields')]
  [Description('definice uzivatelskych poli')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tglobal_settings_global_fields = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('section', [TColumnProp.Required], 100)]
    [Description('')]
    Fsection: string;
    
    [Column('type', [TColumnProp.Required], 20)]
    [Description('')]
    Ftype_: string;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('caption', [TColumnProp.Required], 150)]
    [Description('')]
    Fcaption: string;
    
    [Column('value', [TColumnProp.Required], 150)]
    [Description('')]
    Fvalue: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property section: string read Fsection write Fsection;
    property type_: string read Ftype_ write Ftype_;
    property name: string read Fname write Fname;
    property caption: string read Fcaption write Fcaption;
    property value: string read Fvalue write Fvalue;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('global_settings_user_fields')]
  [Description('definice uzivatelskych poli')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tglobal_settings_user_fields = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('section', [TColumnProp.Required], 100)]
    [Description('')]
    Fsection: string;

    [Column('type', [TColumnProp.Required], 20)]
    [Description('')]
    Ftype_: string;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('caption', [TColumnProp.Required], 150)]
    [Description('')]
    Fcaption: string;

    [Column('value', [TColumnProp.Required], 150)]
    [Description('')]
    Fvalue: string;

    [Column('useinaurelius', [TColumnProp.Required])]
    [Description('')]
    Fuseinaurelius: Boolean;

    [Column('itemorder', [TColumnProp.Required])]
    [Description('')]
    Fitemorder: Integer;

    [Column('field_length', [TColumnProp.Required])]
    [Description('')]
    Ffield_length: Integer;

    [Column('field_precission', [TColumnProp.Required])]
    [Description('')]
    Ffield_precission: Integer;

    [Column('show_to_edit', [TColumnProp.Required])]
    [Description('')]
    Fshow_to_edit: Boolean;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property section: string read Fsection write Fsection;
    property type_: string read Ftype_ write Ftype_;
    property name: string read Fname write Fname;
    property caption: string read Fcaption write Fcaption;
    property value: string read Fvalue write Fvalue;
    property useinaurelius: Boolean read Fuseinaurelius write Fuseinaurelius;
    property itemorder: Integer read Fitemorder write Fitemorder;
    property field_length: Integer read Ffield_length write Ffield_length;
    property field_precission: Integer read Ffield_precission write Ffield_precission;
    property show_to_edit: Boolean read Fshow_to_edit write Fshow_to_edit;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;

    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('global_settings_user_fields_views')]
  [Description('definice uzivatelskych poli pro pohledy')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tglobal_settings_user_fields_views = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('agenda_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fagenda_name: string;

    [Column('field_name', [TColumnProp.Required], 100)]
    [Description('')]
    Ffield_name: string;

    [Column('field_name_as', [TColumnProp.Required], 300)]
    [Description('')]
    Ffield_name_as: string;

    [Column('caption', [TColumnProp.Required], 150)]
    [Description('')]
    Fcaption: string;

    [Column('display_format', [TColumnProp.Required], 100)]
    [Description('')]
    Fdisplay_format: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property agenda_name: string read Fagenda_name write Fagenda_name;
    property field_name: string read Ffield_name write Ffield_name;
    property field_name_as: string read Ffield_name_as write Ffield_name_as;
    property caption: string read Fcaption write Fcaption;
    property display_format: string read Fdisplay_format write Fdisplay_format;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;

    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('hnizda')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Thnizda = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('cislo', [TColumnProp.Required])]
    [Description('')]
    Fcislo: Integer;
    
    [Column('jmeno', [TColumnProp.Required], 100)]
    [Description('')]
    Fjmeno: string;
    
    [Column('poznamka', [], 255)]
    [Description('')]
    Fpoznamka: Nullable<string>;

    [Column('datumzalozeni', [TColumnProp.Required])]
    [Description('')]
    Fdatumzalozeni: TDateTime;

    [Column('datumzruseni', [TColumnProp.Required])]
    [Description('')]
    Fdatumzruseni: TDateTime;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property cislo: Integer read Fcislo write Fcislo;
    property jmeno: string read Fjmeno write Fjmeno;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property datumzalozeni: TDateTime read Fdatumzalozeni write Fdatumzalozeni;
    property datumzruseni: TDateTime read Fdatumzruseni write Fdatumzruseni;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('hnizda_logins')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Thnizda_logins = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('id_hnizdo', [TColumnProp.Required])]
    [Description('')]
    Fid_hnizdo: Integer;
    
    [Column('id_worker', [TColumnProp.Required])]
    [Description('')]
    Fid_worker: Integer;
    
    [Column('prihlaseni', [TColumnProp.Required])]
    [Description('')]
    Fprihlaseni: TDateTime;
    
    [Column('odhlaseni', [TColumnProp.Required])]
    [Description('')]
    Fodhlaseni: TDateTime;
    
    [Column('je_vedouci', [TColumnProp.Required])]
    [Description('')]
    Fje_vedouci: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property id_hnizdo: Integer read Fid_hnizdo write Fid_hnizdo;
    property id_worker: Integer read Fid_worker write Fid_worker;
    property prihlaseni: TDateTime read Fprihlaseni write Fprihlaseni;
    property odhlaseni: TDateTime read Fodhlaseni write Fodhlaseni;
    property je_vedouci: Integer read Fje_vedouci write Fje_vedouci;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('inet_filters')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tinet_filters = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('id_operation_group', [TColumnProp.Required])]
    [Description('')]
    Fid_operation_group: Integer;
    
    [Column('id_category', [TColumnProp.Required])]
    [Description('')]
    Fid_category: Integer;
    
    [Column('values', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fvalues: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property id_operation_group: Integer read Fid_operation_group write Fid_operation_group;
    property id_category: Integer read Fid_category write Fid_category;
    property values: TBlob read Fvalues write Fvalues;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('jednotky')]
  [Description('Seznam jednotek')]
  [UniqueKey('id_correct')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tjednotky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [], 50)]
    [Description('')]
    Fnazev: Nullable<string>;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('visible', [TColumnProp.Required])]
    [Description('')]
    Fvisible: boolean;
    
    [Column('systemovy', [TColumnProp.Required])]
    [Description('')]
    Fsystemovy : boolean;

    [Column('id_correct', [TColumnProp.Required])]
    [Description('')]
    Fid_correct: Integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    Function CanEditRecord (var aMessage : String): Boolean; override;
    property id: Integer read Fid write Fid;
    property nazev: Nullable<string> read Fnazev write Fnazev;
    property poradi: Integer read Fporadi write Fporadi;
    property visible: boolean read Fvisible write Fvisible;
    property systemovy: boolean read Fsystemovy write Fsystemovy ;
    property id_correct: Integer read Fid_correct write Fid_correct;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('kraticka')]
  [Description('Prevodova tabulka kraticky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tkraticka = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('prurez_min', [TColumnProp.Required])]
    [Description('')]
    Fprurez_min: Integer;
    
    [Column('prurez_max', [TColumnProp.Required])]
    [Description('')]
    Fprurez_max: Integer;
    
    [Column('delka_min', [TColumnProp.Required])]
    [Description('')]
    Fdelka_min: Integer;

    [Column('delka_max', [TColumnProp.Required])]
    [Description('')]
    Fdelka_max: Integer;
    
    [Column('norma', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fnorma: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property prurez_min: Integer read Fprurez_min write Fprurez_min;
    property prurez_max: Integer read Fprurez_max write Fprurez_max;
    property delka_min: Integer read Fdelka_min write Fdelka_min;
    property delka_max: Integer read Fdelka_max write Fdelka_max;
    property norma: Double read Fnorma write Fnorma;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('kurz')]
  [Description('Tabulka zmen kurzu cizi meny')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tkurz = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fkurz: Double;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('zkratka', [], 'zkratka')]
    [Description('')]
    Fzkratka: proxy<Tkurz_meny>;

    [Column('mnozstvi', [TColumnProp.Required])]
    [Description('')]
    Fmnozstvi: Integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    FDynCon: TDynamicProperties;
    function getzkratka: Tkurz_meny;
    procedure setzkratka(const Value : Tkurz_meny);

  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property kurz: Double read Fkurz write Fkurz;
    property start: TDateTime read Fstart write Fstart;
    property user: string read Fuser write Fuser;
    property zkratka: Tkurz_meny read getzkratka write setzkratka;
    property mnozstvi: Integer read Fmnozstvi write Fmnozstvi;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('kurz_meny')]
  [Description('Povolen funkce terminl u zamstnanc')]
  [UniqueKey('zkratka')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tkurz_meny = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('zkratka', [TColumnProp.Required], 10)]
    [Description('')]
    Fzkratka: string;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Required], 50)]
    [Description('')]
    Fnote: string;
    
    [Column('is_default', [TColumnProp.Required])]
    [Description('')]
    Fis_default: Boolean;

    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: Boolean;
    [Column('ts_created', [])]

    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property zkratka: string read Fzkratka write Fzkratka;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property is_default: Boolean read Fis_default write Fis_default;
    property active: Boolean read Factive write Factive;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('log')]
  [Description('Tabulka pro logovani prace s eMISTR')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tlog = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('ip', [TColumnProp.Required], 150)]
    [Description('')]
    Fip: string;
    
    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnote: TBlob;
    
    [Column('user', [TColumnProp.Required], 75)]
    [Description('')]
    Fuser: string;
    
    [Column('typ', [TColumnProp.Required], 150)]
    [Description('')]
    Ftyp: string;
    
    [Column('keyword1', [TColumnProp.Required], 150)]
    [Description('')]
    Fkeyword1: string;
    
    [Column('keyword2', [TColumnProp.Required], 250)]
    [Description('')]
    Fkeyword2: string;
    
    [Column('udalost', [TColumnProp.Required], 75)]
    [Description('')]
    Fudalost: string;
    
    [Column('verzevyron', [TColumnProp.Required], 75)]
    [Description('')]
    Fverzevyron: string;
    
    [Column('loglevel', [TColumnProp.Required])]
    [Description('')]
    Floglevel: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property ip: string read Fip write Fip;
    property date: TDateTime read Fdate write Fdate;
    property note: TBlob read Fnote write Fnote;
    property user: string read Fuser write Fuser;
    property typ: string read Ftyp write Ftyp;
    property keyword1: string read Fkeyword1 write Fkeyword1;
    property keyword2: string read Fkeyword2 write Fkeyword2;
    property udalost: string read Fudalost write Fudalost;
    property verzevyron: string read Fverzevyron write Fverzevyron;
    property loglevel: Integer read Floglevel write Floglevel;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('material')]
  [Description('Material k zakzkm')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmaterial = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;
    
    [Column('jednotka', [TColumnProp.Required])]
    [Description('')]
    Fjednotka: Integer;
    
    [Column('cena_jednotka', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_jednotka: Double;
    
    [Column('cena_celkem', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_celkem: Double;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('worker', [TColumnProp.Required], 30)]
    [Description('')]
    Fworker: string;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Int64;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('readdata_id', [TColumnProp.Required])]
    [Description('')]
    Freaddata_id: Int64;
    
    [Column('change_price', [TColumnProp.Required])]
    [Description('')]
    Fchange_price: Integer;
    
    [Column('cena_jednotka_nakup', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_jednotka_nakup: Double;
    
    [Column('cena_celkem_nakup', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_celkem_nakup: Double;
    
    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;
    
    [Column('vazena_cena', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvazena_cena: Double;

    [Column('pohyb_vazena_cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpohyb_vazena_cena: Double;
    
    [Column('last_nakup_cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Flast_nakup_cena: Double;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property name: string read Fname write Fname;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property jednotka: Integer read Fjednotka write Fjednotka;
    property cena_jednotka: Double read Fcena_jednotka write Fcena_jednotka;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property user: string read Fuser write Fuser;
    property worker: string read Fworker write Fworker;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property worker_id: Int64 read Fworker_id write Fworker_id;
    property bar_id: string read Fbar_id write Fbar_id;
    property readdata_id: Int64 read Freaddata_id write Freaddata_id;
    property change_price: Integer read Fchange_price write Fchange_price;
    property cena_jednotka_nakup: Double read Fcena_jednotka_nakup write Fcena_jednotka_nakup;
    property cena_celkem_nakup: Double read Fcena_celkem_nakup write Fcena_celkem_nakup;
    property date: TDateTime read Fdate write Fdate;
    property vazena_cena: Double read Fvazena_cena write Fvazena_cena;
    property pohyb_vazena_cena: Double read Fpohyb_vazena_cena write Fpohyb_vazena_cena;
    property last_nakup_cena: Double read Flast_nakup_cena write Flast_nakup_cena;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('materialy')]
  [Description('Materily a hustoty')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmaterialy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('nazev', [TColumnProp.Required], 25)]
    [Description('')]
    Fnazev: string;

    [Column('hustota', [TColumnProp.Required])]
    [Description('')]
    Fhustota: Integer;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Int64 read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property hustota: Integer read Fhustota write Fhustota;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('material_predpokladany')]
  [Description('Pedpokladan materil k zakzkm')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmaterial_predpokladany = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;

    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;
    
    [Column('jednotka', [TColumnProp.Required])]
    [Description('')]
    Fjednotka: Integer;
    
    [Column('cena_jednotka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_jednotka: Double;
    
    [Column('cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_celkem: Double;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('par1', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpar1: Double;
    
    [Column('par2', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpar2: Double;
    
    [Column('par3', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpar3: Double;
    
    [Column('par4', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpar4: Double;
    
    [Column('par5', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpar5: Double;
    
    [Column('par6', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fpar6: Double;
    
    [Column('par_typ', [TColumnProp.Required])]
    [Description('')]
    Fpar_typ: Int64;
    
    [Column('vyteznost', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvyteznost: Double;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;
    
    [Column('objednavka_id', [TColumnProp.Required])]
    [Description('')]
    Fobjednavka_id: Integer;
    
    [Column('objednavka', [TColumnProp.Required], 100)]
    [Description('')]
    Fobjednavka: string;
    
    [Column('poradi', [])]
    [Description('')]
    Fporadi: Nullable<Integer>;
    
    [Column('DatePriprava', [TColumnProp.Required])]
    [Description('')]
    FDatePriprava: TDateTime;
    
    [Column('DateFinish', [TColumnProp.Required])]
    [Description('')]
    FDateFinish: TDateTime;
    
    [Column('mnozstvi_po_odecteni', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_po_odecteni: Double;
    
    [Column('mnozstvi_zakazky', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_zakazky: Double;
    
    [Column('mnozstvi_prvotni', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_prvotni: Double;
    
    [Column('calculated', [TColumnProp.Required])]
    [Description('')]
    Fcalculated: Integer;
    
    [Column('user_created', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser_created: string;
    
    [Column('mnozstvi_vydane_na_podzakazky', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_vydane_na_podzakazky: Double;
    
    [Column('mnozstvi_predpokladane', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_predpokladane: Double;
    
    [Column('mnozstvi_predpokladane_koeficient', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fmnozstvi_predpokladane_koeficient: Double;

    [Column('orderwork_id', [TColumnProp.Required])]
    [Description('')]
    Forderwork_id: Integer;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property jednotka: Integer read Fjednotka write Fjednotka;
    property cena_jednotka: Double read Fcena_jednotka write Fcena_jednotka;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property user: string read Fuser write Fuser;
    property par1: Double read Fpar1 write Fpar1;
    property par2: Double read Fpar2 write Fpar2;
    property par3: Double read Fpar3 write Fpar3;
    property par4: Double read Fpar4 write Fpar4;
    property par5: Double read Fpar5 write Fpar5;
    property par6: Double read Fpar6 write Fpar6;
    property par_typ: Int64 read Fpar_typ write Fpar_typ;
    property vyteznost: Double read Fvyteznost write Fvyteznost;
    property note: string read Fnote write Fnote;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property objednavka_id: Integer read Fobjednavka_id write Fobjednavka_id;
    property objednavka: string read Fobjednavka write Fobjednavka;
    property poradi: Nullable<Integer> read Fporadi write Fporadi;
    property DatePriprava: TDateTime read FDatePriprava write FDatePriprava;
    property DateFinish: TDateTime read FDateFinish write FDateFinish;
    property mnozstvi_po_odecteni: Double read Fmnozstvi_po_odecteni write Fmnozstvi_po_odecteni;
    property mnozstvi_zakazky: Double read Fmnozstvi_zakazky write Fmnozstvi_zakazky;
    property mnozstvi_prvotni: Double read Fmnozstvi_prvotni write Fmnozstvi_prvotni;
    property calculated: Integer read Fcalculated write Fcalculated;
    property user_created: string read Fuser_created write Fuser_created;
    property mnozstvi_vydane_na_podzakazky: Double read Fmnozstvi_vydane_na_podzakazky write Fmnozstvi_vydane_na_podzakazky;
    property mnozstvi_predpokladane: Double read Fmnozstvi_predpokladane write Fmnozstvi_predpokladane;
    property mnozstvi_predpokladane_koeficient: Double read Fmnozstvi_predpokladane_koeficient write Fmnozstvi_predpokladane_koeficient;
    property orderwork_id: Integer read Forderwork_id write Forderwork_id;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('monitoring_readdata')]
  [Description('monitoring readdata')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmonitoring_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('senzor_id', [], 'id')]
    [Description('')]
    Fsenzor_id: proxy<Tmonitoring_senzory>;

    [Column('read_datetime', [])]
    [Description('')]
    Fread_datetime: Nullable<TDateTime>;

    [Column('value_type', [TColumnProp.Required])]
    [Description('')]
    Fvalue_type: Integer;
    
    [Column('value', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fvalue: Double;
    FDynCon: TDynamicProperties;
    function getsenzor_id: Tmonitoring_senzory;
    procedure setsenzor_id(const Value : Tmonitoring_senzory);
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property senzor_id: Tmonitoring_senzory read getsenzor_id write setsenzor_id;
    property read_datetime: Nullable<TDateTime> read Fread_datetime write Fread_datetime;
    property value_type: Integer read Fvalue_type write Fvalue_type;
    property value: Double read Fvalue write Fvalue;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('monitoring_senzory')]
  [Description('monitoring senzory')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmonitoring_senzory = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('typ', [], 'id')]
    [Description('')]
    Ftyp : proxy<Tmonitoring_senzory_typy>;

    [Column('ip', [TColumnProp.Required], 100)]
    [Description('')]
    Fip: string;
    
    [Column('username', [TColumnProp.Required], 100)]
    [Description('')]
    Fusername: string;
    
    [Column('password', [TColumnProp.Required], 100)]
    [Description('')]
    Fpassword: string;
    
    [Column('comment', [TColumnProp.Required], 100)]
    [Description('')]
    Fcomment: string;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: boolean;

    [Column('last_up', [])]
    [Description('')]
    Flast_up: Nullable<TDateTime>;

    [Column('authentication', [TColumnProp.Required])]
    [Description('')]
    Fauthentication: boolean;
    
    [Column('last_processed', [])]
    [Description('')]
    Flast_processed: Nullable<TDateTime>;
    
    [Column('param_def', [TColumnProp.Required], 4000)]
    [Description('')]
    Fparam_def: string;

    [Association([TAssociationProp.Lazy], CascadeTypeAllButRemove)]
    [JoinColumn('ref_mon_stroj_id', [], 'id')]
    [Description('')]
    Fref_mon_stroj_id : proxy<Tmonitoring_stroje>;

    FDynCon: TDynamicProperties;

    function gettyp: Tmonitoring_senzory_typy;
    procedure settyp (const Value : Tmonitoring_senzory_typy);
    function getref_mon_stroj_id : Tmonitoring_stroje;
    procedure setref_mon_stroj_id (const Value : Tmonitoring_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property typ: Tmonitoring_senzory_typy read gettyp write settyp;
    property ip: string read Fip write Fip;
    property username: string read Fusername write Fusername;
    property password: string read Fpassword write Fpassword;
    property comment: string read Fcomment write Fcomment;
    property active: boolean read Factive write Factive;
    property last_up: Nullable<TDateTime> read Flast_up write Flast_up;
    property authentication: boolean read Fauthentication write Fauthentication;
    property last_processed: Nullable<TDateTime> read Flast_processed write Flast_processed;
    property param_def: string read Fparam_def write Fparam_def;
    property ref_mon_stroj_id: Tmonitoring_stroje read getref_mon_stroj_id write setref_mon_stroj_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('monitoring_senzory_typy')]
  [Description('monitoring senzory typy')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmonitoring_senzory_typy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('unit', [TColumnProp.Required])]
    [Description('')]
    Funit_: Integer;
    
    [Column('precision', [TColumnProp.Required])]
    [Description('')]
    Fprecision: Integer;
    
    [Column('note', [], 200)]
    [Description('')]
    Fnote: Nullable<string>;
    
    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;
    
    [Column('communication_type', [TColumnProp.Required], 200)]
    [Description('')]
    Fcommunication_type: string;
    
    [Column('parameters_definition', [TColumnProp.Required], 1024)]
    [Description('')]
    Fparameters_definition: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property unit_: Integer read Funit_ write Funit_;
    property precision: Integer read Fprecision write Fprecision;
    property note: Nullable<string> read Fnote write Fnote;
    property name: string read Fname write Fname;
    property communication_type: string read Fcommunication_type write Fcommunication_type;
    property parameters_definition: string read Fparameters_definition write Fparameters_definition;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('monitoring_senzory_typy_parametry')]
  [Description('Typy parametr senzor pro monitoring')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmonitoring_senzory_typy_parametry = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('type_id', [TColumnProp.Required])]
    [Description('')]
    Ftype_id: Integer;
    
    [Column('param_type', [TColumnProp.Required], 50)]
    [Description('')]
    Fparam_type: string;
    
    [Column('param_path', [TColumnProp.Required], 1000)]
    [Description('')]
    Fparam_path: string;
    
    [Column('note', [TColumnProp.Required], 150)]
    [Description('')]
    Fnote: string;
    
    [Column('param_isexpression', [TColumnProp.Required])]
    [Description('')]
    Fparam_isexpression: Integer;
    
    [Column('param_id', [TColumnProp.Required])]
    [Description('')]
    Fparam_id: Integer;
    
    [Column('param_isembedded', [TColumnProp.Required])]
    [Description('')]
    Fparam_isembedded: Integer;
    
    [Column('param_type_def', [TColumnProp.Required], 1500)]
    [Description('')]
    Fparam_type_def: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property type_id: Integer read Ftype_id write Ftype_id;
    property param_type: string read Fparam_type write Fparam_type;
    property param_path: string read Fparam_path write Fparam_path;
    property note: string read Fnote write Fnote;
    property param_isexpression: Integer read Fparam_isexpression write Fparam_isexpression;
    property param_id: Integer read Fparam_id write Fparam_id;
    property param_isembedded: Integer read Fparam_isembedded write Fparam_isembedded;
    property param_type_def: string read Fparam_type_def write Fparam_type_def;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('monitoring_stroje')]
  [Description('Vazba senzoru na stroj/CNC')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tmonitoring_stroje = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('typ_stroje', [TColumnProp.Required])]
    [Description('')]
    Ftyp_stroje: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cnc_id', [])]
    [Description('')]
    Fcnc_id: proxy<Tcnc_stroje>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('stroj_id', [], 'id')]
    [Description('')]
    Fstroj_id: proxy<Tstroje>;

    [Column('idle', [])]
    [Description('')]
    Fidle: Nullable<Integer>;

    [Column('load', [])]
    [Description('')]
    Fload: Nullable<Integer>;
    
    [Column('high', [])]
    [Description('')]
    Fhigh: Nullable<Integer>;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    FDynCon: TDynamicProperties;
    function getstroj_id: Tstroje;
    procedure setstroj_id(const Value : Tstroje);
    function getcnc_id: Tcnc_stroje;
    procedure setcnc_id(const Value : Tcnc_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property typ_stroje: Integer read Ftyp_stroje write Ftyp_stroje;
    property cnc_id: Tcnc_stroje read getcnc_id write setcnc_id;
    property stroj_id: Tstroje read getstroj_id write setstroj_id;
    property idle: Nullable<Integer> read Fidle write Fidle;
    property load: Nullable<Integer> read Fload write Fload;
    property high: Nullable<Integer> read Fhigh write Fhigh;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('nabidka_polozky')]
  [Description('Polozky nabidky zakazky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tnabidka_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    
    [Column('cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena: Double;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    
    [Column('dph', [TColumnProp.Required])]
    [Description('')]
    Fdph: Integer;
    
    [Column('sleva', [TColumnProp.Required])]
    [Description('')]
    Fsleva: Integer;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('unit', [TColumnProp.Required])]
    [Description('')]
    Funit_: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_celkem: Double;
    
    [Column('cislo', [TColumnProp.Required])]
    [Description('')]
    Fcislo: Integer;
    
    [Column('cena_nakup', [], 15, 2)]
    [Description('')]
    Fcena_nakup: Nullable<Double>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property cena: Double read Fcena write Fcena;
    property mnoz: Double read Fmnoz write Fmnoz;
    property dph: Integer read Fdph write Fdph;
    property sleva: Integer read Fsleva write Fsleva;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property order_id: string read Forder_id write Forder_id;
    property unit_: Integer read Funit_ write Funit_;
    property note: string read Fnote write Fnote;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property cislo: Integer read Fcislo write Fcislo;
    property cena_nakup: Nullable<Double> read Fcena_nakup write Fcena_nakup;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('naradi_skupina')]
  [Description('Stavy zakazek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tnaradi_skupina = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 255)]
    [Description('')]
    Fname: string;
    
    [Column('parent_id', [TColumnProp.Required])]
    [Description('')]
    Fparent_id: Integer;
    
    [Column('naradiType', [TColumnProp.Required])]
    [Description('')]
    FnaradiType: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property parent_id: Integer read Fparent_id write Fparent_id;
    property naradiType: Integer read FnaradiType write FnaradiType;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('notifications')]
  [Description('Tabulka notifikac k odesln')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tnotifications = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('time_stamp', [TColumnProp.Required])]
    [Description('')]
    Ftime_stamp: TDateTime;
    
    [Column('notification_type', [])]
    [Description('')]
    Fnotification_type: Nullable<Integer>;
    
    [Column('sender', [], 255)]
    [Description('')]
    Fsender: Nullable<string>;

    [Column('recipient', [], 255)]
    [Description('')]
    Frecipient: Nullable<string>;
    
    [Column('body', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fbody: TBlob;
    
    [Column('ts_processed', [])]
    [Description('')]
    Fts_processed: Nullable<TDateTime>;
    
    [Column('status', [])]
    [Description('')]
    Fstatus: Nullable<Integer>;
    
    [Column('status_text', [], 255)]
    [Description('')]
    Fstatus_text: Nullable<string>;
    
    [Column('subject', [], 255)]
    [Description('')]
    Fsubject: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property time_stamp: TDateTime read Ftime_stamp write Ftime_stamp;
    property notification_type: Nullable<Integer> read Fnotification_type write Fnotification_type;
    property sender: Nullable<string> read Fsender write Fsender;
    property recipient: Nullable<string> read Frecipient write Frecipient;
    property body: TBlob read Fbody write Fbody;
    property ts_processed: Nullable<TDateTime> read Fts_processed write Fts_processed;
    property status: Nullable<Integer> read Fstatus write Fstatus;
    property status_text: Nullable<string> read Fstatus_text write Fstatus_text;
    property subject: Nullable<string> read Fsubject write Fsubject;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('objednavky')]
  [Description('Tabulka objednavek')]
  [UniqueKey('bar_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tobjednavky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('vystaveno', [TColumnProp.Required])]
    [Description('')]
    Fvystaveno: TDateTime;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('customer_id', [], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;

    [Association([], CascadeTypeNone)] // TAssociationProp.Lazy
    [JoinColumn('order_id', [], 'bar_id')]
    [Description('')]
//    Forder_id: proxy<Tc_order>;
    Forder_id: Tc_order;

    [Column('dodani', [TColumnProp.Required])]
    [Description('')]
    Fdodani: TDateTime;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('doprava_id', [], 'id')]
    [Description('')]
    Fdoprava_id: proxy<Tzpusob_dopravy>;

    [Column('doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoklad: string;
    
    [Column('doklad2', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoklad2: string;

    [Column('splatno', [TColumnProp.Required])]
    [Description('')]
    Fsplatno: TDateTime;
    
    [Column('vykryto', [TColumnProp.Required])]
    [Description('')]
    Fvykryto: Integer;
    
    [Column('vykryto_date', [])]
    [Description('')]
    Fvykryto_date: Nullable<TDateTime>;
    
    [Column('externi_id', [], 100)]
    [Description('')]
    Fexterni_id: Nullable<string>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('StavDokladu', [], 'id')]
    [Description('')]
    FStavDokladu: proxy<Tstavydokladu>;

    [Column('drawing', [TColumnProp.Required], 200)]
    [Description('')]
    Fdrawing: string;
    
    [Column('volitelna1', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna1: string;
    
    [Column('volitelna2', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna2: string;

    [Column('volitelna3', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna3: string;
    
    [Column('volitelna4', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna4: string;
    
    [Column('ciselna_volitelna1', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna1: Double;
    
    [Column('ciselna_volitelna2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna2: Double;

    [Column('ciselna_volitelna3', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna3: Double;
    
    [Column('ciselna_volitelna4', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna4: Double;
    
    [Column('datumova_volitelna1', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna1: TDateTime;
    
    [Column('datumova_volitelna2', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna2: TDateTime;
    
    [Column('datumova_volitelna3', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna3: TDateTime;

    [Column('datumova_volitelna4', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna4: TDateTime;

    [Column('potvrzeni_date', [])]
    [Description('')]
    Fpotvrzeni_date: Nullable<TDateTime>;
    
    [Column('cm_castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcm_castka: Double;

    [Column('cm_kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_kurz: Double;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cm_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('zpusob_platby_id', [], 'id')]
    [Description('')]
    Fzpusob_platby_id: proxy<Tzpusob_platby>;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    [Column('castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka: Double;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('hlavni_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fhlavni_mena: proxy<Tkurz_meny>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fobjednavka_id')]
    Fobjednavky_docList: Proxy<TList<Tobjednavky_doc>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fobjednavka_id')]
    Fobjednavky_polozkyList: Proxy<TList<Tobjednavky_polozky>>;

    FDynCon: TDynamicProperties;

    function getdoprava_id: Tzpusob_dopravy;
    procedure setdoprava_id(const Value : Tzpusob_dopravy);
    function getorder_id: Tc_order;
    procedure setorder_id(const Value : Tc_order);
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
    function getzpusob_platby_id: Tzpusob_platby;
    procedure setzpusob_platby_id(const Value : Tzpusob_platby);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function getStavDokladu: Tstavydokladu;
    procedure setStavDokladu(const Value : Tstavydokladu);
    function gethlavni_mena: Tkurz_meny;
    procedure sethlavni_mena(const Value : Tkurz_meny);
    function Getobjednavky_docList: TList<Tobjednavky_doc>;
    function Getobjednavky_polozkyList: TList<Tobjednavky_polozky>;
    function getcm_kurz: Double;
    procedure setcm_kurz(const Value: Double);
    procedure setvystaveno(const Value: TDateTime);
    procedure setdodani(const Value: TDateTime);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    class procedure checkNewRecord; override; // K Overeni, ze je mozne objekt vytvorit, napr. existuje rada dokladu
    Function CheckRecord(var aMessage : String) : Boolean; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property note: string read Fnote write Fnote;
    property vystaveno: TDateTime read Fvystaveno write setvystaveno;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property name: string read Fname write Fname;
    property customer_id: TCustomer read getcustomer_id write setcustomer_id;
    property order_id: TC_order read getorder_id write setorder_id;
    property dodani: TDateTime read Fdodani write setdodani;
    property doprava_id: TZpusob_dopravy read getdoprava_id write setdoprava_id;
    property doklad: string read Fdoklad write Fdoklad;
    property doklad2: string read Fdoklad2 write Fdoklad2;
    property splatno: TDateTime read Fsplatno write Fsplatno;
    property vykryto: Integer read Fvykryto write Fvykryto;
    property vykryto_date: Nullable<TDateTime> read Fvykryto_date write Fvykryto_date;
    property externi_id: Nullable<string> read Fexterni_id write Fexterni_id;
    property StavDokladu: TStavydokladu read getStavDokladu write setStavDokladu;
    property drawing: string read Fdrawing write Fdrawing;
    property volitelna1: string read Fvolitelna1 write Fvolitelna1;
    property volitelna2: string read Fvolitelna2 write Fvolitelna2;
    property volitelna3: string read Fvolitelna3 write Fvolitelna3;
    property volitelna4: string read Fvolitelna4 write Fvolitelna4;
    property ciselna_volitelna1: Double read Fciselna_volitelna1 write Fciselna_volitelna1;
    property ciselna_volitelna2: Double read Fciselna_volitelna2 write Fciselna_volitelna2;
    property ciselna_volitelna3: Double read Fciselna_volitelna3 write Fciselna_volitelna3;
    property ciselna_volitelna4: Double read Fciselna_volitelna4 write Fciselna_volitelna4;
    property datumova_volitelna1: TDateTime read Fdatumova_volitelna1 write Fdatumova_volitelna1;
    property datumova_volitelna2: TDateTime read Fdatumova_volitelna2 write Fdatumova_volitelna2;
    property datumova_volitelna3: TDateTime read Fdatumova_volitelna3 write Fdatumova_volitelna3;
    property datumova_volitelna4: TDateTime read Fdatumova_volitelna4 write Fdatumova_volitelna4;
    property potvrzeni_date: Nullable<TDateTime> read Fpotvrzeni_date write Fpotvrzeni_date;
    property cm_castka: Double read Fcm_castka write Fcm_castka;
    property cm_kurz: Double read getcm_kurz write setcm_kurz;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property zpusob_platby_id: Tzpusob_platby read getzpusob_platby_id write setzpusob_platby_id;
    property has_docs: Integer read Fhas_docs write Fhas_docs;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property castka: Double read Fcastka write Fcastka;
    property hlavni_mena: Tkurz_meny read gethlavni_mena write sethlavni_mena;
    property objednavky_docList: TList<Tobjednavky_doc> read Getobjednavky_docList;
    property objednavky_polozkyList: TList<Tobjednavky_polozky> read Getobjednavky_polozkyList;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('objednavky_doc')]
  [Description('dokumenty objednavek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tobjednavky_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('objednavka_typ', [TColumnProp.Required])]
    [Description('')]
    Fobjednavka_typ: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('isfile', [TColumnProp.Required])]
    [Description('')]
    Fisfile: boolean;

    [Column('defaultdocument', [TColumnProp.Required])]
    [Description('')]
    Fdefaultdocument: boolean;

    [Column('user', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 200)]
    [Description('')]
    Fusercreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('objednavka_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fobjednavka_id: proxy<Tobjednavky>;
    function getobjednavka_id: Tobjednavky;
    procedure setobjednavka_id(const Value : Tobjednavky);
    function getextensionType : integer;
    function getdoctype : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Integer read Fid write Fid;
    property objednavka_id: TObjednavky read getobjednavka_id write setobjednavka_id;
    property objednavka_typ: Integer read Fobjednavka_typ write Fobjednavka_typ;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isfile: boolean read Fisfile write Fisfile;
    property defaultdocument: boolean read Fdefaultdocument write Fdefaultdocument;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('objednavky_polozky')]
  [Description('Tabulka poloek objednvek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tobjednavky_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('objednavka_id', [], 'id')]
    [Description('')]
    Fobjednavka_id: proxy<Tobjednavky>;

    [Column('kusu', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkusu: Double;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<Tjednotky>;

    [Column('price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice: Double;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('naradi_id', [],'id')]
    [Description('')]
    Fnaradi_id: proxy<TSklad_naradi>;

    [Column('unitprice', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Funitprice: Double;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('dodat_do', [TColumnProp.Required])]
    [Description('')]
    Fdodat_do: TDateTime;
    
    [Association([], CascadeTypeNone)] // TAssociationProp.Lazy
    [JoinColumn('order_id', [], 'bar_id')]
    [Description('')]
//    Forder_id: proxy<Tc_order>;
    Forder_id: Tc_order;

    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;
    
    [Column('bez_vazby', [TColumnProp.Required])]
    [Description('')]
    Fbez_vazby: Integer;
    
    [Column('vykryto_bez_vazby', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fvykryto_bez_vazby: Double;
    
    [Column('vykryto', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvykryto: Double;
    
    [Column('vykryto_date', [])]
    [Description('')]
    Fvykryto_date: Nullable<TDateTime>;

    [Association([], CascadeTypeNone)]
    [JoinColumn('subdodavka_id', [],'id')]
    [Description('')]
    Fsubdodavka_id: proxy<TSubdodavky>;
    
    [Column('forma_id', [TColumnProp.Required])]
    [Description('')]
    Fforma_id: Integer;
    
    [Column('externi_id', [], 100)]
    [Description('')]
    Fexterni_id: Nullable<string>;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('volitelna1', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna1: string;
    
    [Column('volitelna2', [TColumnProp.Required], 200)]
    [Description('')]
    Fvolitelna2: string;
    
    [Column('ciselna_volitelna1', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna1: Double;

    [Column('ciselna_volitelna2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna2: Double;
    
    [Column('datumova_volitelna1', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna1: TDateTime;
    
    [Column('datumova_volitelna2', [TColumnProp.Required])]
    [Description('')]
    Fdatumova_volitelna2: TDateTime;

    [Column('cm_price', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcm_price: Double;

    [Column('cm_unitprice', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcm_unitprice: Double;

    [Column('vykryto_subdodavky', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvykryto_subdodavky: Double;

    [Column('vykryto_vse', [TColumnProp.Required])]
    [Description('')]
    Fvykryto_vse: Integer;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('price_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fprice_mj: Double;

    [Column('cm_price_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_price_mj: Double;

    [Column('kusu_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fkusu_mj: Double;

    [Column('coef_unit', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcoef_unit: Double;

    [Column('typ_polozky', [TColumnProp.Required])]
    [Description('')]
    Ftyp_polozky: Integer;

    [Column('user', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 200)]
    [Description('')]
    Fusercreated: string;

    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_id', [], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getnaradi_id: Tsklad_naradi;
    procedure setnaradi_id(const Value : Tsklad_naradi);
    function getsubdodavka_id: Tsubdodavky;
    procedure setsubdodavka_id(const Value : Tsubdodavky);
    function getobjednavka_id: Tobjednavky;
    procedure setobjednavka_id(const Value : Tobjednavky);
    function getorder_id: Tc_order;
    procedure setorder_id(const Value : Tc_order);
    function getunit_: Tjednotky;
    procedure setunit_(const Value : Tjednotky);
    function getcoef_unit: Double;
    procedure setcoef_unit(const Value: Double);
    procedure setkusu_mj(const Value: Double);
    procedure setcm_price(const Value: Double);
    procedure setcm_price_mj(const Value: Double);
    procedure settyp_polozky(const Value : integer);
    procedure setunitprice(const Value: Double);
    procedure setcm_unitprice(const Value: Double);
    procedure setprice_mj(const Value: Double);
    procedure setprice(const Value: Double);
    procedure setkusu(const Value: Double);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    Function CheckRecord(var aMessage : String) : Boolean; override;
    property id: Integer read Fid write Fid;
    property objednavka_id: TObjednavky read getobjednavka_id write setobjednavka_id;
    property unit_: TJednotky read getunit_ write setunit_;
    property naradi_id: TSklad_naradi read getnaradi_id write setnaradi_id;
    property note: string read Fnote write Fnote;
    property dodat_do: TDateTime read Fdodat_do write Fdodat_do;
    property order_id: Tc_order read getorder_id write setorder_id;
    property name: string read Fname write Fname;
    property bez_vazby: Integer read Fbez_vazby write Fbez_vazby;
    property vykryto_bez_vazby: Double read Fvykryto_bez_vazby write Fvykryto_bez_vazby;
    property vykryto: Double read Fvykryto write Fvykryto;
    property vykryto_date: Nullable<TDateTime> read Fvykryto_date write Fvykryto_date;
    property subdodavka_id: TSubdodavky read getsubdodavka_id write setsubdodavka_id;
    property forma_id: Integer read Fforma_id write Fforma_id;
    property externi_id: Nullable<string> read Fexterni_id write Fexterni_id;
    property poradi: Integer read Fporadi write Fporadi;
    property volitelna1: string read Fvolitelna1 write Fvolitelna1;
    property volitelna2: string read Fvolitelna2 write Fvolitelna2;
    property ciselna_volitelna1: Double read Fciselna_volitelna1 write Fciselna_volitelna1;
    property ciselna_volitelna2: Double read Fciselna_volitelna2 write Fciselna_volitelna2;
    property datumova_volitelna1: TDateTime read Fdatumova_volitelna1 write Fdatumova_volitelna1;
    property datumova_volitelna2: TDateTime read Fdatumova_volitelna2 write Fdatumova_volitelna2;
    property kusu_mj: Double read Fkusu_mj write setkusu_mj;
    property cm_price_mj: Double read Fcm_price_mj write setcm_price_mj;
    property typ_polozky: Integer read Ftyp_polozky write settyp_polozky;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property vykryto_subdodavky: Double read Fvykryto_subdodavky write Fvykryto_subdodavky;
    property vykryto_vse: Integer read Fvykryto_vse write Fvykryto_vse;
    // RO
    property price: Double read Fprice;// write setprice;
    property unitprice: Double read Funitprice; // write Funitprice;
    property kusu: Double read Fkusu; // write setkusu;
    property cm_price: Double read Fcm_price; // write setcm_price;
    property cm_unitprice: Double read Fcm_unitprice; // write Fcm_unitprice;
    property price_mj: Double read Fprice_mj; // write Fprice_mj;
    property coef_unit: Double read getcoef_unit; // write setcoef_unit;
  end;

  [Entity]
  [Table('objednavky_prijate')]
  [Description('Tabulka prijatych objednavek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tobjednavky_prijate = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('vystaveno', [TColumnProp.Required])]
    [Description('')]
    Fvystaveno: TDateTime;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;

    [Column('dodat', [TColumnProp.Required])]
    [Description('')]
    Fdodat: TDateTime;

    [Column('cm_kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_kurz: Double;

    [Column('doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoklad: string;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('externi_id', [TColumnProp.Required], 150)]
    [Description('')]
    Fexterni_id: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('doprava_id', [], 'id')]
    [Description('')]
    Fdoprava_id: proxy<Tzpusob_dopravy>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('customer_id', [], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('StavDokladu', [], 'id')]
    [Description('')]
    FStavDokladu: proxy<Tstavydokladu>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('dodaciadresa', [], 'id')]
    [Description('')]
    Fdodaciadresa: proxy<Tcustomer_adresy>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cm_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('hlavni_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fhlavni_mena: proxy<Tkurz_meny>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fobjednavka_id')]
    Fobjednavky_prijate_polozkyList: Proxy<TList<Tobjednavky_prijate_polozky>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fobjednavka_prijata_id')]
    Fobjednavky_prijate_docList: Proxy<TList<Tobjednavky_prijate_doc>>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('zpusob_platby_id', [], 'id')]
    [Description('')]
    Fzpusob_platby_id: proxy<Tzpusob_platby>;

    [Column('cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_celkem: Double;

    [Column('cm_cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcm_cena_celkem: Double;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    function Getobjednavky_prijate_polozkyList: TList<Tobjednavky_prijate_polozky>;
    function Getobjednavky_prijate_docList: TList<Tobjednavky_prijate_doc>;
    function getdoprava_id: Tzpusob_dopravy;
    procedure setdoprava_id(const Value : Tzpusob_dopravy);
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
    function getStavDokladu: Tstavydokladu;
    procedure setStavDokladu(const Value : Tstavydokladu);
    function getdodaciadresa: Tcustomer_adresy;
    procedure setdodaciadresa(const Value : Tcustomer_adresy);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function gethlavni_mena: Tkurz_meny;
    procedure sethlavni_mena(const Value : Tkurz_meny);
    function getzpusob_platby_id: Tzpusob_platby;
    procedure setzpusob_platby_id(const Value : Tzpusob_platby);
    function getcm_kurz: Double;
    procedure setcm_kurz(const Value: Double);
    procedure setvystaveno(const Value: TDateTime);
    procedure setdodat(const Value: TDateTime);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    class procedure checkNewRecord; override; // K Overeni, ze je mozne objekt vytvorit, napr. existuje rada dokladu
    Function CheckRecord(var aMessage : String) : Boolean; override;

    function GetBar_ID : String; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property note: string read Fnote write Fnote;
    property vystaveno: TDateTime read Fvystaveno write setvystaveno;
    property user: string read Fuser write Fuser;
    property name: string read Fname write Fname;
    property dodat: TDateTime read Fdodat write setdodat;
    property cm_kurz: Double read getcm_kurz write setcm_kurz;
    property doklad: string read Fdoklad write Fdoklad;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property DynCon: TDynamicProperties read FDynCon;
    property doprava_id: Tzpusob_dopravy read getdoprava_id write setdoprava_id;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
    property StavDokladu: Tstavydokladu read getStavDokladu write setStavDokladu;
    property dodaciadresa: Tcustomer_adresy read getdodaciadresa write setdodaciadresa;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property hlavni_mena: Tkurz_meny read gethlavni_mena write sethlavni_mena;
    property objednavky_prijate_polozkyList: TList<Tobjednavky_prijate_polozky> read Getobjednavky_prijate_polozkyList;
    property objednavky_prijate_docList: TList<Tobjednavky_prijate_doc> read Getobjednavky_prijate_docList;
    property zpusob_platby_id: Tzpusob_platby read getzpusob_platby_id write setzpusob_platby_id;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property cm_cena_celkem: Double read Fcm_cena_celkem write Fcm_cena_celkem;
    property has_docs: Integer read Fhas_docs write Fhas_docs;

  end;

  [Entity]
  [Table('objednavky_prijate_doc')]
  [Description('dokumenty objednavek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tobjednavky_prijate_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('isfile', [TColumnProp.Required])]
    [Description('')]
    Fisfile: Boolean;

    [Column('defaultdocument', [TColumnProp.Required])]
    [Description('')]
    Fdefaultdocument: Boolean;
    
    [Column('user', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 200)]
    [Description('')]
    Fusercreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('objednavka_prijata_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fobjednavka_prijata_id: proxy<Tobjednavky_prijate>;
    function getobjednavka_prijata_id: Tobjednavky_prijate;
    procedure setobjednavka_prijata_id(const Value : Tobjednavky_prijate);
    function getextensionType : integer;
    function getdoctype : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function GetBar_ID : String; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isfile: Boolean read Fisfile write Fisfile;
    property defaultdocument: Boolean read Fdefaultdocument write Fdefaultdocument;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property objednavka_prijata_id: Tobjednavky_prijate read getobjednavka_prijata_id write setobjednavka_prijata_id;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
  end;

  [Entity]
  [Table('objednavky_prijate_polozky')]
  [Description('Tabulka poloek pijatch objednvek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tobjednavky_prijate_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('kusu', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fkusu: Double;

    [Column('price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fprice: Double;
    
    [Column('unitprice', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Funitprice: Double;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('pozice', [TColumnProp.Required], 20)]
    [Description('')]
    Fpozice: string;

    [Column('pozadovene_datum', [TColumnProp.Required])]
    [Description('')]
    Fpozadovene_datum: TDateTime;
    
    [Column('potvrzene_datum', [TColumnProp.Required])]
    [Description('')]
    Fpotvrzene_datum: TDateTime;
    
    [Column('potvrzena_cena_jednotka', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fpotvrzena_cena_jednotka: Double;
    
    [Column('potvrzena_cena', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fpotvrzena_cena: Double;
    
    [Column('sell_price_unit', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fsell_price_unit: Double;
    
    [Column('sell_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fsell_price: Double;
    
    [Column('cm_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_price: Double;
    
    [Column('cm_unitprice', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_unitprice: Double;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('externi_id', [TColumnProp.Required], 150)]
    [Description('')]
    Fexterni_id: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('kusu_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fkusu_mj: Double;

    [Column('coef_unit', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcoef_unit: Double;

    [Column('potvrzena_cena_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fpotvrzena_cena_mj: Double;

    [Column('sell_price_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fsell_price_mj: Double;

    [Column('typ_polozky', [TColumnProp.Required])]
    [Description('')]
    Ftyp_polozky: Integer;

    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;

    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('objednavka_id', [], 'id')]
    [Description('')]
    Fobjednavka_id: proxy<Tobjednavky_prijate>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_id', [], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<Tjednotky>;

    [Column('cm_potvrzena_cena_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_potvrzena_cena_mj: Double;

    [Column('cm_potvrzena_cena_jednotka', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_potvrzena_cena_jednotka: Double;

    [Column('cm_potvrzena_cena', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcm_potvrzena_cena: Double;

    function getobjednavka_id: Tobjednavky_prijate;
    procedure setobjednavka_id(const Value : Tobjednavky_prijate);
    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getunit_: Tjednotky;
    procedure setunit_(const Value : Tjednotky);
    procedure setkusu_mj(const Value: Double);
    function getcoef_unit: Double;
    procedure setcoef_unit(const Value: Double);
    procedure setkusu(const Value: Double);
    procedure setsell_price_unit(const Value: Double);
    procedure setcm_potvrzena_cena_mj(const Value: Double);
    procedure setcm_potvrzena_cena(const Value: Double);
    procedure setpotvrzena_cena(const Value: Double);
    procedure setpotvrzena_cena_jednotka(const Value: Double);
    procedure setpotvrzena_cena_mj(const Value: Double);
    procedure setsell_price_mj(const Value: Double);
    procedure setsell_price(const Value: Double);
    procedure setcm_potvrzena_cena_jednotka(const Value: Double);
    procedure settyp_polozky(const Value : integer);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    Function CheckRecord(var aMessage : String) : Boolean; override;
    function GetBar_ID : String; override;
    property DynCon: TDynamicProperties read FDynCon;
    property id: Integer read Fid write Fid;
    property objednavka_id: Tobjednavky_prijate read getobjednavka_id write setobjednavka_id;
    property poradi: Integer read Fporadi write Fporadi;
    property potvrzene_datum: TDateTime read Fpotvrzene_datum write Fpotvrzene_datum;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property kusu_mj: Double read Fkusu_mj write setkusu_mj;
    property unit_: Tjednotky read getunit_ write setunit_;
    property cm_potvrzena_cena_mj: Double read Fcm_potvrzena_cena_mj write setcm_potvrzena_cena_mj;
    property note: string read Fnote write Fnote;
    property pozice: string read Fpozice write Fpozice;

    property pozadovene_datum: TDateTime read Fpozadovene_datum write Fpozadovene_datum;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property typ_polozky: Integer read ftyp_polozky write settyp_polozky;
    property name: string read Fname write Fname;

    // RO
    property cm_potvrzena_cena_jednotka: Double read Fcm_potvrzena_cena_jednotka; // write Fcm_potvrzena_cena_jednotka;
    property cm_potvrzena_cena: Double read Fcm_potvrzena_cena; // write setcm_potvrzena_cena;
    property sell_price_unit: Double read Fsell_price_unit; // write setsell_price_unit;
    property sell_price: Double read Fsell_price; // write Fsell_price;
    property sell_price_mj: Double read Fsell_price_mj; // write Fsell_price_mj;
    property potvrzena_cena_mj: Double read Fpotvrzena_cena_mj; // write Fpotvrzena_cena_mj;
    property kusu: Double read Fkusu;// write setkusu;
    property potvrzena_cena_jednotka: Double read Fpotvrzena_cena_jednotka; // write Fpotvrzena_cena_jednotka;
    property potvrzena_cena: Double read Fpotvrzena_cena; // write setpotvrzena_cena;
    property cm_price: Double read Fcm_price; // write Fcm_price;
    property cm_unitprice: Double read Fcm_unitprice; // write Fcm_unitprice;
    property coef_unit: Double read getcoef_unit; // write setcoef_unit;

    // Zrusit
    property price: Double read Fprice write Fprice;
    property unitprice: Double read Funitprice write Funitprice;

  end;

  [Entity]
  [Table('operation')]
  [Description('Operace')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Toperation = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('group_id', [], 'id')]
    [Description('')]
    Fgroup_id: proxy<Toperation_group>;

    [Column('group_name', [], 50)]
    [Description('')]
    Fgroup_name: Nullable<string>;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('machine_name', [], 100)]
    [Description('')]
    Fmachine_name: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('id_employee', [])]
    [Description('')]
    Fid_employee: proxy<Tworker>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<TJednotky>;

    [Column('unitcount', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Funitcount: Double;

    [Column('unit_price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Funit_price: Double;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('open_door', [TColumnProp.Required])]
    [Description('')]
    Fopen_door: boolean;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('orderstav_id', [])]
    [Description('')]
    Forderstav_id: proxy<Torder_stav>;

    [Column('ukolova_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukolova_mzda: Double;

    [Column('auto_writte', [TColumnProp.Required])]
    [Description('')]
    Fauto_writte: Boolean;


    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cnc_id', [])]
    [Description('')]
    Fcnc_id: proxy<Tcnc_stroje>;

    [Column('cena_mzdove_polozky', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_mzdove_polozky: Double;

    [Column('maxmin_za_den', [TColumnProp.Required])]
    [Description('')]
    Fmaxmin_za_den: Integer;

    [Column('planovano_min', [TColumnProp.Required])]
    [Description('')]
    Fplanovano_min: Integer;

    [Column('resource_id', [TColumnProp.Required])]
    [Description('')]
    Fresource_id: Integer;

    [Column('take_photo', [TColumnProp.Required])]
    [Description('')]
    Ftake_photo: boolean;

    [Column('operace_predchazejici_id', [])]
    [Description('')]
    Foperace_predchazejici_id: Nullable<Integer>;

    [Column('operace_predchazejici_cas', [])]
    [Description('')]
    Foperace_predchazejici_cas: Nullable<Integer>;

    [Column('operace_predchazejici_fix', [])]
    [Description('')]
    Foperace_predchazejici_fix: Nullable<Integer>;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('priprava', [TColumnProp.Required])]
    [Description('')]
    Fpriprava: Boolean;

    [Column('pripravaCas', [TColumnProp.Required])]
    [Description('')]
    FpripravaCas: Integer;

    [Column('pripravaInterval', [TColumnProp.Required])]
    [Description('')]
    FpripravaInterval: Integer;

    [Column('cena_faktura', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_faktura: Double;

    [Column('cena_rezie', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_rezie: Double;

    [Column('koeficient_mzdy', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoeficient_mzdy: Double;

    [Column('sklad_skupina_id', [TColumnProp.Required])]
    [Description('')]
    Fsklad_skupina_id: Integer;

    [Column('cena_mj_odmeny', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_mj_odmeny: Double;

    [Column('cena_mj_operace', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_mj_operace: Double;

    [Column('is_cnc', [TColumnProp.Required])]
    [Description('')]
    Fis_cnc: Boolean;

    [Column('is_dochazka', [TColumnProp.Required])]
    [Description('')]
    Fis_dochazka: Boolean;

    [Column('userCode', [TColumnProp.Required], 100)]
    [Description('')]
    FuserCode: string;

    [Column('is_fixed', [TColumnProp.Required])]
    [Description('')]
    Fis_fixed: Boolean;

    [Column('is_servis', [TColumnProp.Required])]
    [Description('')]
    Fis_servis: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('typ_vypoctu', [],'id')]
    [Description('')]
    Ftyp_vypoctu: proxy<Tukolmzda_typ>;

    [Column('ep_typ_planu_ID', [TColumnProp.Required])]
    [Description('')]
    Fep_typ_planu_ID: Integer;

    [Column('tech_prestavka_minut', [TColumnProp.Required])]
    [Description('')]
    Ftech_prestavka_minut: Integer;

    [Column('tech_prestavka_dni', [TColumnProp.Required])]
    [Description('')]
    Ftech_prestavka_dni: Integer;

    [Column('is_zakazka_povinna', [TColumnProp.Required])]
    [Description('')]
    Fis_zakazka_povinna: Boolean;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    [Column('post_operation_time', [], 11)]
    [Description('')]
    Fpost_operation_time : integer;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Foperation_id')]
    Foperation_strojeList: Proxy<TList<Tref_operation_stroj>>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Foperation_id')]
    Foperation_cncList: Proxy<TList<Tref_operation_cnc>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Foperation_id')]
    Fref_operation_workerList: Proxy<TList<Tref_operation_worker>>;

    FDynCon: TDynamicProperties;

    function Getref_operation_workerList: TList<Tref_operation_worker>;
    function Getoperation_strojeList: TList<Tref_operation_stroj>;
    function Getoperation_cncList: TList<Tref_operation_cnc>;
    function getgroup_id: Toperation_group;
    procedure setgroup_id(const Value : Toperation_group);
    function getid_employee: Tworker;
    procedure setid_employee(const Value : Tworker);
    function getunit_: TJednotky;
    procedure setunit_(const Value : TJednotky);
    function getorderstav_id: Torder_stav;
    procedure setorderstav_id(const Value : Torder_stav);
    function getcnc_id: Tcnc_stroje;
    procedure setcnc_id(const Value : Tcnc_stroje);
    function gettyp_vypoctu: Tukolmzda_typ;
    procedure settyp_vypoctu(const Value : Tukolmzda_typ);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure checkNewRecord; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Int64 read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property group_id: Toperation_group read getgroup_id write setgroup_id;
    property group_name: Nullable<string> read Fgroup_name write Fgroup_name;
    property note: string read Fnote write Fnote;
    property machine_name: string read Fmachine_name write Fmachine_name;
    property id_employee: Tworker read getid_employee write setid_employee;
    property unit_: TJednotky read getunit_ write setunit_;
    property unitcount: Double read Funitcount write Funitcount;
    property unit_price: Double read Funit_price write Funit_price;
    property user: string read Fuser write Fuser;
    property open_door: Boolean read Fopen_door write Fopen_door;
    property orderstav_id: Torder_stav read getorderstav_id write setorderstav_id;
    property ukolova_mzda: Double read Fukolova_mzda write Fukolova_mzda;
    property auto_writte: Boolean read Fauto_writte write Fauto_writte;
    property cnc_id: Tcnc_stroje read getcnc_id write setcnc_id;
    property cena_mzdove_polozky: Double read Fcena_mzdove_polozky write Fcena_mzdove_polozky;
    property maxmin_za_den: Integer read Fmaxmin_za_den write Fmaxmin_za_den;
    property planovano_min: Integer read Fplanovano_min write Fplanovano_min;
    property resource_id: Integer read Fresource_id write Fresource_id;
    property take_photo: boolean read Ftake_photo write Ftake_photo;
    property operace_predchazejici_id: Nullable<Integer> read Foperace_predchazejici_id write Foperace_predchazejici_id;
    property operace_predchazejici_cas: Nullable<Integer> read Foperace_predchazejici_cas write Foperace_predchazejici_cas;
    property operace_predchazejici_fix: Nullable<Integer> read Foperace_predchazejici_fix write Foperace_predchazejici_fix;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property priprava: Boolean read Fpriprava write Fpriprava;
    property pripravaCas: Integer read FpripravaCas write FpripravaCas;
    property pripravaInterval: Integer read FpripravaInterval write FpripravaInterval;
    property cena_faktura: Double read Fcena_faktura write Fcena_faktura;
    property cena_rezie: Double read Fcena_rezie write Fcena_rezie;
    property koeficient_mzdy: Double read Fkoeficient_mzdy write Fkoeficient_mzdy;
    property sklad_skupina_id: Integer read Fsklad_skupina_id write Fsklad_skupina_id;
    property cena_mj_odmeny: Double read Fcena_mj_odmeny write Fcena_mj_odmeny;
    property cena_mj_operace: Double read Fcena_mj_operace write Fcena_mj_operace;
    property is_cnc: Boolean read Fis_cnc write Fis_cnc;
    property is_dochazka: Boolean read Fis_dochazka write Fis_dochazka;
    property userCode: string read FuserCode write FuserCode;
    property is_fixed: Boolean read Fis_fixed write Fis_fixed;
    property is_servis: Integer read Fis_servis write Fis_servis;
    property typ_vypoctu: Tukolmzda_typ read gettyp_vypoctu write settyp_vypoctu;
    property ep_typ_planu_ID: Integer read Fep_typ_planu_ID write Fep_typ_planu_ID;
    property tech_prestavka_minut: Integer read Ftech_prestavka_minut write Ftech_prestavka_minut;
    property tech_prestavka_dni: Integer read Ftech_prestavka_dni write Ftech_prestavka_dni;
    property is_zakazka_povinna: Boolean read Fis_zakazka_povinna write Fis_zakazka_povinna;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property userCreated: string read FuserCreated write FuserCreated;
    property operation_strojeList: TList<Tref_operation_stroj> read Getoperation_strojeList;
    property operation_cncList: TList<Tref_operation_cnc> read Getoperation_cncList;
    property ref_operation_workerList: TList<Tref_operation_worker> read Getref_operation_workerList;
    property DynCon: TDynamicProperties read FDynCon;

  end;

  [Entity]
  [Table('operation_default')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Toperation_default = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('operation_id', [])]
    [Description('')]
    Foperation_id: Nullable<Integer>;
    
    [Column('pausal_id', [])]
    [Description('')]
    Fpausal_id: Nullable<Integer>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property operation_id: Nullable<Integer> read Foperation_id write Foperation_id;
    property pausal_id: Nullable<Integer> read Fpausal_id write Fpausal_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('operation_group')]
  [Description('Skupiny operaci')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Toperation_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('cislo', [TColumnProp.Required], 25)]
    [Description('')]
    Fcislo: string;
    
    [Column('zkratka', [TColumnProp.Required], 30)]
    [Description('')]
    Fzkratka: string;
    
    [Column('isObedy', [TColumnProp.Required])]
    [Description('')]
    FisObedy: Boolean;
    
    [Column('isCnc', [TColumnProp.Required])]
    [Description('')]
    FisCnc: Boolean;
    
    [Column('isNoTime', [TColumnProp.Required])]
    [Description('')]
    FisNoTime: Boolean;
    
    [Column('isDochazka', [TColumnProp.Required])]
    [Description('')]
    FisDochazka: Boolean;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Foperation_group_id')]
    Foperation_group_strojeList: Proxy<TList<Tref_operation_group_stroj>>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Foperation_group_id')]
    Foperation_group_cncList: Proxy<TList<Tref_operation_group_cnc>>;

    FDynCon: TDynamicProperties;
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function Getoperation_group_strojeList: TList<Tref_operation_group_stroj>;
    function Getoperation_group_cncList: TList<Tref_operation_group_cnc>;

  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user: string read Fuser write Fuser;
    property cislo: string read Fcislo write Fcislo;
    property zkratka: string read Fzkratka write Fzkratka;
    property isObedy: Boolean read FisObedy write FisObedy;
    property isCnc: Boolean read FisCnc write FisCnc;
    property isNoTime: Boolean read FisNoTime write FisNoTime;
    property isDochazka: Boolean read FisDochazka write FisDochazka;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property operation_group_strojeList: TList<Tref_operation_group_stroj> read Getoperation_group_strojeList;
    property operation_group_cncList: TList<Tref_operation_group_cnc> read Getoperation_group_cncList;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('order_calc_list')]
  [Description('')]
  [Id('ForderId', TIdGenerator.None)]
  Torder_calc_list = class(TTMSAGObject)
  private
    [Column('orderId', [TColumnProp.Required], 255)]
    [Description('')]
    ForderId: string;
    
    [Column('date', [])]
    [Description('')]
    Fdate: Nullable<TDateTime>;
    
    [Column('zdroj', [TColumnProp.Required], 255)]
    [Description('')]
    Fzdroj: string;
    
    [Column('action', [TColumnProp.Required], 20)]
    [Description('')]
    Faction: string;
    
    [Column('table_name', [TColumnProp.Required], 100)]
    [Description('')]
    Ftable_name: string;
    
    [Column('source_id', [TColumnProp.Required])]
    [Description('')]
    Fsource_id: Int64;
    
    [Column('old_value', [], 100)]
    [Description('')]
    Fold_value: Nullable<string>;
    
    [Column('new_value', [], 100)]
    [Description('')]
    Fnew_value: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property orderId: string read ForderId write ForderId;
    property date: Nullable<TDateTime> read Fdate write Fdate;
    property zdroj: string read Fzdroj write Fzdroj;
    property action: string read Faction write Faction;
    property table_name: string read Ftable_name write Ftable_name;
    property source_id: Int64 read Fsource_id write Fsource_id;
    property old_value: Nullable<string> read Fold_value write Fold_value;
    property new_value: Nullable<string> read Fnew_value write Fnew_value;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('order_filter')]
  [Description('Tabulka uloench filtr zakzek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Torder_filter = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('cislo', [TColumnProp.Required])]
    [Description('')]
    Fcislo: Integer;
    
    [Column('nazev', [TColumnProp.Required], 32)]
    [Description('')]
    Fnazev: string;
    
    [Column('textove_polozky', [TColumnProp.Required], 256)]
    [Description('')]
    Ftextove_polozky: string;
    
    [Column('stavy', [TColumnProp.Required], 256)]
    [Description('')]
    Fstavy: string;
    
    [Column('typy', [TColumnProp.Required], 256)]
    [Description('')]
    Ftypy: string;
    
    [Column('use_zadano', [TColumnProp.Required], 32)]
    [Description('')]
    Fuse_zadano: string;
    
    [Column('zadano_do', [TColumnProp.Required])]
    [Description('')]
    Fzadano_do: TDateTime;
    
    [Column('zadano_od', [TColumnProp.Required])]
    [Description('')]
    Fzadano_od: TDateTime;
    
    [Column('posouvat_zadano', [TColumnProp.Required], 32)]
    [Description('')]
    Fposouvat_zadano: string;
    
    [Column('use_dokonceni', [TColumnProp.Required], 32)]
    [Description('')]
    Fuse_dokonceni: string;
    
    [Column('dokonceni_od', [TColumnProp.Required])]
    [Description('')]
    Fdokonceni_od: TDateTime;
    
    [Column('dokonceni_do', [TColumnProp.Required])]
    [Description('')]
    Fdokonceni_do: TDateTime;
    
    [Column('posouvat_dokonceni', [TColumnProp.Required], 32)]
    [Description('')]
    Fposouvat_dokonceni: string;
    
    [Column('ulozeno', [TColumnProp.Required])]
    [Description('')]
    Fulozeno: TDateTime;
    
    [Column('use_zmenastavu', [TColumnProp.Required], 32)]
    [Description('')]
    Fuse_zmenastavu: string;
    
    [Column('posouvat_zmenustavu', [TColumnProp.Required], 32)]
    [Description('')]
    Fposouvat_zmenustavu: string;
    
    [Column('zmenastavu_od', [TColumnProp.Required])]
    [Description('')]
    Fzmenastavu_od: TDateTime;
    
    [Column('zmenastavu_do', [TColumnProp.Required])]
    [Description('')]
    Fzmenastavu_do: TDateTime;
    
    [Column('zmenastavu', [TColumnProp.Required], 256)]
    [Description('')]
    Fzmenastavu: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property cislo: Integer read Fcislo write Fcislo;
    property nazev: string read Fnazev write Fnazev;
    property textove_polozky: string read Ftextove_polozky write Ftextove_polozky;
    property stavy: string read Fstavy write Fstavy;
    property typy: string read Ftypy write Ftypy;
    property use_zadano: string read Fuse_zadano write Fuse_zadano;
    property zadano_do: TDateTime read Fzadano_do write Fzadano_do;
    property zadano_od: TDateTime read Fzadano_od write Fzadano_od;
    property posouvat_zadano: string read Fposouvat_zadano write Fposouvat_zadano;
    property use_dokonceni: string read Fuse_dokonceni write Fuse_dokonceni;
    property dokonceni_od: TDateTime read Fdokonceni_od write Fdokonceni_od;
    property dokonceni_do: TDateTime read Fdokonceni_do write Fdokonceni_do;
    property posouvat_dokonceni: string read Fposouvat_dokonceni write Fposouvat_dokonceni;
    property ulozeno: TDateTime read Fulozeno write Fulozeno;
    property use_zmenastavu: string read Fuse_zmenastavu write Fuse_zmenastavu;
    property posouvat_zmenustavu: string read Fposouvat_zmenustavu write Fposouvat_zmenustavu;
    property zmenastavu_od: TDateTime read Fzmenastavu_od write Fzmenastavu_od;
    property zmenastavu_do: TDateTime read Fzmenastavu_do write Fzmenastavu_do;
    property zmenastavu: string read Fzmenastavu write Fzmenastavu;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('order_priority_font')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Torder_priority_font = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('priorita_id', [TColumnProp.Required])]
    [Description('')]
    Fpriorita_id: Integer;

    [Column('size', [TColumnProp.Required])]
    [Description('')]
    Fsize: Integer;
    
    [Column('pismo', [TColumnProp.Required], 50)]
    [Description('')]
    Fpismo: string;
    
    [Column('underline', [TColumnProp.Required])]
    [Description('')]
    Funderline: Integer;
    
    [Column('bold', [TColumnProp.Required])]
    [Description('')]
    Fbold: Integer;
    
    [Column('italic', [TColumnProp.Required])]
    [Description('')]
    Fitalic: Integer;
    
    [Column('crossline', [TColumnProp.Required])]
    [Description('')]
    Fcrossline: Integer;
    
    [Column('color_pen', [TColumnProp.Required])]
    [Description('')]
    Fcolor_pen: Integer;
    
    [Column('color_brush', [TColumnProp.Required])]
    [Description('')]
    Fcolor_brush: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property priorita_id: Integer read Fpriorita_id write Fpriorita_id;
    property size: Integer read Fsize write Fsize;
    property pismo: string read Fpismo write Fpismo;
    property underline: Integer read Funderline write Funderline;
    property bold: Integer read Fbold write Fbold;
    property italic: Integer read Fitalic write Fitalic;
    property crossline: Integer read Fcrossline write Fcrossline;
    property color_pen: Integer read Fcolor_pen write Fcolor_pen;
    property color_brush: Integer read Fcolor_brush write Fcolor_brush;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('order_stav')]
  [Description('Stavy zakazek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Torder_stav = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('group_name', [TColumnProp.Required], 20)]
    [Description('')]
    Fgroup_name: string;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('change_operation_id', [TColumnProp.Required])]
    [Description('')]
    Fchange_operation_id: Int64;
    
    [Column('cislo', [TColumnProp.Required], 25)]
    [Description('')]
    Fcislo: string;
    
    [Column('pocitat_plan', [TColumnProp.Required])]
    [Description('')]
    Fpocitat_plan: Boolean;
    
    [Column('in_print', [TColumnProp.Required])]
    [Description('')]
    Fin_print: Boolean;
    
    [Column('prepocitavat', [TColumnProp.Required])]
    [Description('')]
    Fprepocitavat: Boolean;

    [Column('blokace_mat', [TColumnProp.Required])]
    [Description('')]
    Fblokace_mat: Boolean;
    
    [Column('barevne_oznaceni', [TColumnProp.Required])]
    [Description('')]
    Fbarevne_oznaceni: Boolean;
    
    [Column('barva', [TColumnProp.Required])]
    [Description('')]
    Fbarva: Integer;
    
    [Column('stav_vyroba', [TColumnProp.Required])]
    [Description('')]
    Fstav_vyroba: Integer;
    
    [Column('FinalStatus', [TColumnProp.Required])]
    [Description('')]
    FFinalStatus: Integer;
    
    [Column('FillSeznam', [TColumnProp.Required])]
    [Description('')]
    FFillSeznam: Boolean;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property group_name: string read Fgroup_name write Fgroup_name;
    property poradi: Integer read Fporadi write Fporadi;
    property change_operation_id: Int64 read Fchange_operation_id write Fchange_operation_id;
    property cislo: string read Fcislo write Fcislo;
    property pocitat_plan: Boolean read Fpocitat_plan write Fpocitat_plan;
    property in_print: Boolean read Fin_print write Fin_print;
    property prepocitavat: Boolean read Fprepocitavat write Fprepocitavat;
    property blokace_mat: Boolean read Fblokace_mat write Fblokace_mat;
    property barevne_oznaceni: Boolean read Fbarevne_oznaceni write Fbarevne_oznaceni;
    property barva: Integer read Fbarva write Fbarva;
    property stav_vyroba: Integer read Fstav_vyroba write Fstav_vyroba;
    property FinalStatus: Integer read FFinalStatus write FFinalStatus;
    property FillSeznam: Boolean read FFillSeznam write FFillSeznam;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('order_urovne')]
  [Description('Popisy rovn zakzek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Torder_urovne = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('glyph_id', [TColumnProp.Required])]
    [Description('')]
    Fglyph_id: Integer;
    
    [Column('nazev', [TColumnProp.Required], 30)]
    [Description('')]
    Fnazev: string;
    
    [Column('barva_pozadi', [TColumnProp.Required], 30)]
    [Description('')]
    Fbarva_pozadi: string;

    [Column('barva_fontu', [TColumnProp.Required], 30)]
    [Description('')]
    Fbarva_fontu: string;
    
    [Column('styl_fontu', [TColumnProp.Required], 30)]
    [Description('')]
    Fstyl_fontu: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property glyph_id: Integer read Fglyph_id write Fglyph_id;
    property nazev: string read Fnazev write Fnazev;
    property barva_pozadi: string read Fbarva_pozadi write Fbarva_pozadi;
    property barva_fontu: string read Fbarva_fontu write Fbarva_fontu;
    property styl_fontu: string read Fstyl_fontu write Fstyl_fontu;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('order_work')]
  [Description('Tabulka normovanych operaci k jednotlivym zakazkam')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Torder_work = class(TTMSAGObject)
  private
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('user_time', [TColumnProp.Required])]
    [Description('')]
    Fuser_time: Integer;
    
    [Column('user_price', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fuser_price: Double;
    
    [Column('units', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Funits: Double;
    
    [Column('ukolova_mzda', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fukolova_mzda: Double;
    
    [Column('typ_vypoctu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('comment', [TColumnProp.Required, TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fcomment: TBlob;
    
    [Column('user_time_ks_second', [TColumnProp.Required])]
    [Description('')]
    Fuser_time_ks_second: Integer;
    
    [Column('koeficient_vyroby', [TColumnProp.Required])]
    [Description('')]
    Fkoeficient_vyroby: Integer;
    
    [Column('odpracovano', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano: Integer;
    
    [Column('real_time', [TColumnProp.Required])]
    [Description('')]
    Freal_time: Integer;
    
    [Column('real_price', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Freal_price: Double;
    
    [Column('vyrobenocelkem', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvyrobenocelkem: Double;
    
    [Column('zmetku_celkem', [TColumnProp.Required], 11, 3)]
    [Description('')]
    Fzmetku_celkem: Double;

    [Column('plan_kalendar', [TColumnProp.Required])]
    [Description('')]
    Fplan_kalendar: Integer;
    
    [Column('operace_predchazejici_id', [TColumnProp.Required])]
    [Description('')]
    Foperace_predchazejici_id: Integer;
    
    [Column('operace_predchazejici_cas', [TColumnProp.Required])]
    [Description('')]
    Foperace_predchazejici_cas: Integer;
    
    [Column('operace_predchazejici_fix', [TColumnProp.Required])]
    [Description('')]
    Foperace_predchazejici_fix: Integer;
    
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;
    
    [Column('priznaky', [TColumnProp.Required])]
    [Description('')]
    Fpriznaky: Integer;
    
    [Column('operace_predchazejici_added', [TColumnProp.Required])]
    [Description('')]
    Foperace_predchazejici_added: Integer;
    
    [Column('priprava', [TColumnProp.Required])]
    [Description('')]
    Fpriprava: Integer;
    
    [Column('pripravaCas', [TColumnProp.Required])]
    [Description('')]
    FpripravaCas: Integer;
    
    [Column('pripravaKoeficient', [TColumnProp.Required])]
    [Description('')]
    FpripravaKoeficient: Integer;
    
    [Column('pripravaInterval', [TColumnProp.Required])]
    [Description('')]
    FpripravaInterval: Integer;
    
    [Column('start_req', [TColumnProp.Required])]
    [Description('')]
    Fstart_req: TDateTime;
    
    [Column('finish_req', [TColumnProp.Required])]
    [Description('')]
    Ffinish_req: TDateTime;
    
    [Column('forma1_id', [TColumnProp.Required])]
    [Description('')]
    Fforma1_id: Integer;

    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('poradi_techpostup', [TColumnProp.Required])]
    [Description('')]
    Fporadi_techpostup: Integer;
    
    [Column('forma1_mnozstvi_cyklus', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fforma1_mnozstvi_cyklus: Double;
    
    [Column('forma1_material_cyklus', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fforma1_material_cyklus: Double;
    
    [Column('vyplneno_ukolova_mzda', [TColumnProp.Required])]
    [Description('')]
    Fvyplneno_ukolova_mzda: Integer;
    
    [Column('unit', [TColumnProp.Required])]
    [Description('')]
    Funit_: Integer;

    [Column('op_unit_price', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_unit_price: Double;
    
    [Column('op_ukolova_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_ukolova_mzda: Double;
    
    [Column('op_cena_faktura', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_cena_faktura: Double;
    
    [Column('op_cena_rezie', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_cena_rezie: Double;
    
    [Column('op_cena_mj_odmeny', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_cena_mj_odmeny: Double;
    
    [Column('op_stroj_id', [TColumnProp.Required])]
    [Description('')]
    Fop_stroj_id: Integer;
    
    [Column('op_stroj_cena', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_stroj_cena: Double;
    
    [Column('op_cena_mj', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_cena_mj: Double;

    [Column('ts_Calculated', [TColumnProp.Required])]
    [Description('')]
    Fts_Calculated: Integer;
    
    [Column('days_before_finish', [TColumnProp.Required])]
    [Description('')]
    Fdays_before_finish: Integer;
    
    [Column('isFixed', [TColumnProp.Required])]
    [Description('')]
    FisFixed: Integer;
    
    [Column('user_create', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser_create: string;
    
    [Column('start_real', [TColumnProp.Required])]
    [Description('')]
    Fstart_real: TDateTime;
    
    [Column('finish_real', [TColumnProp.Required])]
    [Description('')]
    Ffinish_real: TDateTime;
    
    [Column('ep_typ_planu_ID', [TColumnProp.Required])]
    [Description('')]
    Fep_typ_planu_ID: Integer;
    
    [Column('tech_prestavka_minut', [TColumnProp.Required])]
    [Description('')]
    Ftech_prestavka_minut: Integer;
    
    [Column('tech_prestavka_dni', [TColumnProp.Required])]
    [Description('')]
    Ftech_prestavka_dni: Integer;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_lastCalculated', [])]
    [Description('')]
    Fts_lastCalculated: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Column('post_operation_time', [], 11)]
    [Description('')]
    Fpost_operation_time : integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('order_id', [TColumnProp.Required], 'bar_id')]
    [Description('')]
    Forder_id: proxy<Tc_order>;

    function getorder_id: Tc_order;
    procedure setorder_id(const Value : Tc_order);
  public
    constructor Create; override;
    destructor Destroy; override;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property user_time: Integer read Fuser_time write Fuser_time;
    property user_price: Double read Fuser_price write Fuser_price;
    property units: Double read Funits write Funits;
    property ukolova_mzda: Double read Fukolova_mzda write Fukolova_mzda;
    property typ_vypoctu: Integer read Ftyp_vypoctu write Ftyp_vypoctu;
    property poradi: Integer read Fporadi write Fporadi;
    property comment: TBlob read Fcomment write Fcomment;
    property user_time_ks_second: Integer read Fuser_time_ks_second write Fuser_time_ks_second;
    property koeficient_vyroby: Integer read Fkoeficient_vyroby write Fkoeficient_vyroby;
    property odpracovano: Integer read Fodpracovano write Fodpracovano;
    property real_time: Integer read Freal_time write Freal_time;
    property real_price: Double read Freal_price write Freal_price;
    property vyrobenocelkem: Double read Fvyrobenocelkem write Fvyrobenocelkem;
    property zmetku_celkem: Double read Fzmetku_celkem write Fzmetku_celkem;
    property plan_kalendar: Integer read Fplan_kalendar write Fplan_kalendar;
    property operace_predchazejici_id: Integer read Foperace_predchazejici_id write Foperace_predchazejici_id;
    property operace_predchazejici_cas: Integer read Foperace_predchazejici_cas write Foperace_predchazejici_cas;
    property operace_predchazejici_fix: Integer read Foperace_predchazejici_fix write Foperace_predchazejici_fix;
    property id: Integer read Fid write Fid;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property priznaky: Integer read Fpriznaky write Fpriznaky;
    property operace_predchazejici_added: Integer read Foperace_predchazejici_added write Foperace_predchazejici_added;
    property priprava: Integer read Fpriprava write Fpriprava;
    property pripravaCas: Integer read FpripravaCas write FpripravaCas;
    property pripravaKoeficient: Integer read FpripravaKoeficient write FpripravaKoeficient;
    property pripravaInterval: Integer read FpripravaInterval write FpripravaInterval;
    property start_req: TDateTime read Fstart_req write Fstart_req;
    property finish_req: TDateTime read Ffinish_req write Ffinish_req;
    property forma1_id: Integer read Fforma1_id write Fforma1_id;
    property priorita: Integer read Fpriorita write Fpriorita;
    property poradi_techpostup: Integer read Fporadi_techpostup write Fporadi_techpostup;
    property forma1_mnozstvi_cyklus: Double read Fforma1_mnozstvi_cyklus write Fforma1_mnozstvi_cyklus;
    property forma1_material_cyklus: Double read Fforma1_material_cyklus write Fforma1_material_cyklus;
    property vyplneno_ukolova_mzda: Integer read Fvyplneno_ukolova_mzda write Fvyplneno_ukolova_mzda;
    property unit_: Integer read Funit_ write Funit_;
    property op_unit_price: Double read Fop_unit_price write Fop_unit_price;
    property op_ukolova_mzda: Double read Fop_ukolova_mzda write Fop_ukolova_mzda;
    property op_cena_faktura: Double read Fop_cena_faktura write Fop_cena_faktura;
    property op_cena_rezie: Double read Fop_cena_rezie write Fop_cena_rezie;
    property op_cena_mj_odmeny: Double read Fop_cena_mj_odmeny write Fop_cena_mj_odmeny;
    property op_stroj_id: Integer read Fop_stroj_id write Fop_stroj_id;
    property op_stroj_cena: Double read Fop_stroj_cena write Fop_stroj_cena;
    property op_cena_mj: Double read Fop_cena_mj write Fop_cena_mj;
    property ts_Calculated: Integer read Fts_Calculated write Fts_Calculated;
    property days_before_finish: Integer read Fdays_before_finish write Fdays_before_finish;
    property isFixed: Integer read FisFixed write FisFixed;
    property user_create: string read Fuser_create write Fuser_create;
    property start_real: TDateTime read Fstart_real write Fstart_real;
    property finish_real: TDateTime read Ffinish_real write Ffinish_real;
    property ep_typ_planu_ID: Integer read Fep_typ_planu_ID write Fep_typ_planu_ID;
    property tech_prestavka_minut: Integer read Ftech_prestavka_minut write Ftech_prestavka_minut;
    property tech_prestavka_dni: Integer read Ftech_prestavka_dni write Ftech_prestavka_dni;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_lastCalculated: Nullable<TDateTime> read Fts_lastCalculated write Fts_lastCalculated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property order_id: Tc_order read getorder_id write setorder_id;
  end;
  
  [Entity]
  [Table('order_work_plan')]
  [Description('Uspora asu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Torder_work_plan = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;

    [Column('plan_time', [TColumnProp.Required])]
    [Description('')]
    Fplan_time: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property plan_time: Integer read Fplan_time write Fplan_time;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('packages')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tpackages = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('bar_id', [], 50)]
    [Description('')]
    Fbar_id: Nullable<string>;
    
    [Column('spedition_id', [])]
    [Description('')]
    Fspedition_id: Nullable<Int64>;
    
    [Column('vytvoren', [])]
    [Description('')]
    Fvytvoren: Nullable<TDateTime>;
    
    [Column('zabalen', [])]
    [Description('')]
    Fzabalen: Nullable<TDateTime>;
    
    [Column('readdata_id', [])]
    [Description('')]
    Freaddata_id: Nullable<Int64>;
    
    [Column('order_id', [], 50)]
    [Description('')]
    Forder_id: Nullable<string>;
    
    [Column('hnizdo', [TColumnProp.Required])]
    [Description('')]
    Fhnizdo: Integer;

    [Column('customer_id', [])]
    [Description('')]
    Fcustomer_id: Nullable<Integer>;
    
    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('vytisteno_dne', [])]
    [Description('')]
    Fvytisteno_dne: Nullable<TDateTime>;
    
    [Column('expedice', [])]
    [Description('')]
    Fexpedice: Nullable<TDateTime>;
    
    [Column('tisk', [TColumnProp.Required])]
    [Description('')]
    Ftisk: Integer;
    
    [Column('soubor_exp', [], 120)]
    [Description('')]
    Fsoubor_exp: Nullable<string>;
    
    [Column('odeslan', [])]
    [Description('')]
    Fodeslan: Nullable<TDateTime>;
    
    [Column('expedice_bar', [], 50)]
    [Description('')]
    Fexpedice_bar: Nullable<string>;
    
    [Column('poznamka', [], 100)]
    [Description('')]
    Fpoznamka: Nullable<string>;
    
    [Column('hmotnost', [TColumnProp.Required])]
    [Description('')]
    Fhmotnost: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property bar_id: Nullable<string> read Fbar_id write Fbar_id;
    property spedition_id: Nullable<Int64> read Fspedition_id write Fspedition_id;
    property vytvoren: Nullable<TDateTime> read Fvytvoren write Fvytvoren;
    property zabalen: Nullable<TDateTime> read Fzabalen write Fzabalen;
    property readdata_id: Nullable<Int64> read Freaddata_id write Freaddata_id;
    property order_id: Nullable<string> read Forder_id write Forder_id;
    property hnizdo: Integer read Fhnizdo write Fhnizdo;
    property customer_id: Nullable<Integer> read Fcustomer_id write Fcustomer_id;
    property stav: Integer read Fstav write Fstav;
    property poradi: Integer read Fporadi write Fporadi;
    property vytisteno_dne: Nullable<TDateTime> read Fvytisteno_dne write Fvytisteno_dne;
    property expedice: Nullable<TDateTime> read Fexpedice write Fexpedice;
    property tisk: Integer read Ftisk write Ftisk;
    property soubor_exp: Nullable<string> read Fsoubor_exp write Fsoubor_exp;
    property odeslan: Nullable<TDateTime> read Fodeslan write Fodeslan;
    property expedice_bar: Nullable<string> read Fexpedice_bar write Fexpedice_bar;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property hmotnost: Integer read Fhmotnost write Fhmotnost;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('pausal')]
  [Description('Pausalni operace')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tpausal = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('time', [TColumnProp.Required])]
    [Description('')]
    Ftime: TDateTime;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_id: proxy<Toperation>;
    function getoperation_id: Toperation;
    procedure setoperation_id(const Value : Toperation);
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property bar_id: string read Fbar_id write Fbar_id;
    property time: TDateTime read Ftime write Ftime;
    property user: string read Fuser write Fuser;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
    property operation_id: Toperation read getoperation_id write setoperation_id;
  end;
  
  [Entity]
  [Table('plan_group_smeny')]
  [Description('Pln msto prce')]
  [Id('Fid_standardni_smena', TIdGenerator.None)]
  [Id('Fid_smena', TIdGenerator.None)]
  [Id('Fid_den', TIdGenerator.None)]
  [Id('Fmisto_prace', TIdGenerator.None)]
  [Id('Ftyp_smeny', TIdGenerator.None)]
  [Id('Fid_plan_smena_skupina', TIdGenerator.None)]
  [Id('Fid_plan_smena', TIdGenerator.None)]
  [Id('Fid_misto_prace', TIdGenerator.None)]
  [Id('Fid_typ_smeny', TIdGenerator.None)]
  [Id('Fid_pracovni_skupina', TIdGenerator.None)]
  Tplan_group_smeny = class(TTMSAGObject)
  private
    [Column('id_standardni_smena', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_standardni_smena: Integer;
    
    [Column('id_smena', [TColumnProp.Required])]
    [Description('')]
    Fid_smena: Integer;
    
    [Column('id_den', [TColumnProp.Required])]
    [Description('')]
    Fid_den: Integer;
    
    [Column('misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fmisto_prace: Integer;
    
    [Column('typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Ftyp_smeny: Integer;
    
    [Column('id_plan_smena_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_plan_smena_skupina: Integer;
    
    [Column('id_plan_smena', [TColumnProp.Required])]
    [Description('')]
    Fid_plan_smena: Integer;
    
    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('id_typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('id_pracovni_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_pracovni_skupina: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_standardni_smena: Integer read Fid_standardni_smena write Fid_standardni_smena;
    property id_smena: Integer read Fid_smena write Fid_smena;
    property id_den: Integer read Fid_den write Fid_den;
    property misto_prace: Integer read Fmisto_prace write Fmisto_prace;
    property typ_smeny: Integer read Ftyp_smeny write Ftyp_smeny;
    property id_plan_smena_skupina: Integer read Fid_plan_smena_skupina write Fid_plan_smena_skupina;
    property id_plan_smena: Integer read Fid_plan_smena write Fid_plan_smena;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property id_pracovni_skupina: Integer read Fid_pracovni_skupina write Fid_pracovni_skupina;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('plan_misto_prace')]
  [Description('Pln msto prce')]
  [Id('Fid_misto_prace', TIdGenerator.IdentityOrSequence)]
  Tplan_misto_prace = class(TTMSAGObject)
  private
    [Column('id_misto_prace', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('popis', [TColumnProp.Required], 100)]
    [Description('')]
    Fpopis: string;
    
    [Column('ma_mit_plan', [TColumnProp.Required])]
    [Description('')]
    Fma_mit_plan: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property popis: string read Fpopis write Fpopis;
    property ma_mit_plan: Integer read Fma_mit_plan write Fma_mit_plan;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_na_den')]
  [Description('Pln na den')]
  [Id('Fid_plan_den', TIdGenerator.IdentityOrSequence)]
  Tplan_na_den = class(TTMSAGObject)
  private
    [Column('id_plan_den', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_plan_den: Integer;
    
    [Column('id_worker', [TColumnProp.Required])]
    [Description('')]
    Fid_worker: Integer;
    
    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('id_typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('den_v_kalendari', [TColumnProp.Required])]
    [Description('')]
    Fden_v_kalendari: TDateTime;
    
    [Column('worker_kapacita_den', [TColumnProp.Required], 5, 2)]
    [Description('')]
    Fworker_kapacita_den: Double;
    
    [Column('worker_stav', [TColumnProp.Required])]
    [Description('')]
    Fworker_stav: Integer;

    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Integer;
    
    [Column('poznamka', [], 200)]
    [Description('')]
    Fpoznamka: Nullable<string>;
    
    [Column('Nepritomnost_cas', [TColumnProp.Required], 5, 2)]
    [Description('')]
    FNepritomnost_cas: Double;
    
    [Column('readdata_id', [TColumnProp.Required])]
    [Description('')]
    Freaddata_id: Int64;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('start', [])]
    [Description('')]
    Fstart: Nullable<TDateTime>;
    
    [Column('finish', [])]
    [Description('')]
    Ffinish: Nullable<TDateTime>;
    
    [Column('prestavka_po', [TColumnProp.Required])]
    [Description('')]
    Fprestavka_po: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_plan_den: Integer read Fid_plan_den write Fid_plan_den;
    property id_worker: Integer read Fid_worker write Fid_worker;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property den_v_kalendari: TDateTime read Fden_v_kalendari write Fden_v_kalendari;
    property worker_kapacita_den: Double read Fworker_kapacita_den write Fworker_kapacita_den;
    property worker_stav: Integer read Fworker_stav write Fworker_stav;
    property operation_id: Integer read Foperation_id write Foperation_id;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property Nepritomnost_cas: Double read FNepritomnost_cas write FNepritomnost_cas;
    property readdata_id: Int64 read Freaddata_id write Freaddata_id;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property start: Nullable<TDateTime> read Fstart write Fstart;
    property finish: Nullable<TDateTime> read Ffinish write Ffinish;
    property prestavka_po: Integer read Fprestavka_po write Fprestavka_po;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_smena')]
  [Description('Pln msto prce')]
  [Id('Fid_plan_smena', TIdGenerator.None)]
  [Id('Fid_typ_provoz', TIdGenerator.None)]
  [Id('Fid_typ_smeny', TIdGenerator.None)]
  [Id('Fid_misto_prace', TIdGenerator.None)]
  Tplan_smena = class(TTMSAGObject)
  private
    [Column('id_plan_smena', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_plan_smena: Integer;
    
    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('id_typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('id_typ_provoz', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_provoz: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_plan_smena: Integer read Fid_plan_smena write Fid_plan_smena;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property id_typ_provoz: Integer read Fid_typ_provoz write Fid_typ_provoz;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_smena_na_den')]
  [Description('Pln na den')]
  [Id('Fid_plan_smena_na_den', TIdGenerator.None)]
  [Id('Fid_plan_smena', TIdGenerator.None)]
  [Id('Fid_typ_provoz', TIdGenerator.None)]
  [Id('Fid_typ_smeny', TIdGenerator.None)]
  [Id('Fid_misto_prace', TIdGenerator.None)]
  Tplan_smena_na_den = class(TTMSAGObject)
  private
    [Column('id_plan_smena_na_den', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_plan_smena_na_den: Integer;
    
    [Column('id_plan_smena', [TColumnProp.Required])]
    [Description('')]
    Fid_plan_smena: Integer;
    
    [Column('id_typ_provoz', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_provoz: Integer;
    
    [Column('id_typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('den_v_kalendari', [TColumnProp.Required])]
    [Description('')]
    Fden_v_kalendari: TDateTime;
    
    [Column('kapacita_na_den', [TColumnProp.Required], 9, 2)]
    [Description('')]
    Fkapacita_na_den: Double;
    
    [Column('kapacita_naplnena', [TColumnProp.Required], 9, 2)]
    [Description('')]
    Fkapacita_naplnena: Double;

    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_plan_smena_na_den: Integer read Fid_plan_smena_na_den write Fid_plan_smena_na_den;
    property id_plan_smena: Integer read Fid_plan_smena write Fid_plan_smena;
    property id_typ_provoz: Integer read Fid_typ_provoz write Fid_typ_provoz;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property den_v_kalendari: TDateTime read Fden_v_kalendari write Fden_v_kalendari;
    property kapacita_na_den: Double read Fkapacita_na_den write Fkapacita_na_den;
    property kapacita_naplnena: Double read Fkapacita_naplnena write Fkapacita_naplnena;
    property stav: Integer read Fstav write Fstav;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_smena_skupina')]
  [Description('Pln smn skupiny')]
  [Id('Fid_plan_smena_skupina', TIdGenerator.None)]
  [Id('Fid_plan_smena', TIdGenerator.None)]
  [Id('Fid_misto_prace', TIdGenerator.None)]
  [Id('Fid_typ_smeny', TIdGenerator.None)]
  [Id('Fid_pracovni_skupina', TIdGenerator.None)]
  Tplan_smena_skupina = class(TTMSAGObject)
  private
    [Column('id_plan_smena_skupina', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_plan_smena_skupina: Integer;
    
    [Column('id_plan_smena', [TColumnProp.Required])]
    [Description('')]
    Fid_plan_smena: Integer;
    
    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('id_typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('id_pracovni_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_pracovni_skupina: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_plan_smena_skupina: Integer read Fid_plan_smena_skupina write Fid_plan_smena_skupina;
    property id_plan_smena: Integer read Fid_plan_smena write Fid_plan_smena;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property id_pracovni_skupina: Integer read Fid_pracovni_skupina write Fid_pracovni_skupina;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_standardni_smena')]
  [Description('selnk pln standardnch smn')]
  [Id('Fid_standardni_smena', TIdGenerator.None)]
  [Id('Fden_v_tydnu', TIdGenerator.None)]
  [Id('Fid_plan_smena_skupina', TIdGenerator.None)]
  [Id('Fid_plan_smena', TIdGenerator.None)]
  [Id('Fid_misto_prace', TIdGenerator.None)]
  [Id('Fid_typ_smeny', TIdGenerator.None)]
  [Id('Fid_pracovni_skupina', TIdGenerator.None)]
  Tplan_standardni_smena = class(TTMSAGObject)
  private
    [Column('id_standardni_smena', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_standardni_smena: Integer;
    
    [Column('id_plan_smena_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_plan_smena_skupina: Integer;
    
    [Column('id_plan_smena', [TColumnProp.Required])]
    [Description('')]
    Fid_plan_smena: Integer;

    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('id_typ_smeny', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_smeny: Integer;
    
    [Column('id_pracovni_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_pracovni_skupina: Integer;
    
    [Column('den_v_tydnu', [TColumnProp.Required])]
    [Description('')]
    Fden_v_tydnu: Integer;
    
    [Column('fond_hodin', [TColumnProp.Required], 5, 2)]
    [Description('')]
    Ffond_hodin: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_standardni_smena: Integer read Fid_standardni_smena write Fid_standardni_smena;
    property id_plan_smena_skupina: Integer read Fid_plan_smena_skupina write Fid_plan_smena_skupina;
    property id_plan_smena: Integer read Fid_plan_smena write Fid_plan_smena;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property id_typ_smeny: Integer read Fid_typ_smeny write Fid_typ_smeny;
    property id_pracovni_skupina: Integer read Fid_pracovni_skupina write Fid_pracovni_skupina;
    property den_v_tydnu: Integer read Fden_v_tydnu write Fden_v_tydnu;
    property fond_hodin: Double read Ffond_hodin write Ffond_hodin;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_worker')]
  [Description('Pln worker')]
  [Id('Fid_worker', TIdGenerator.IdentityOrSequence)]
  Tplan_worker = class(TTMSAGObject)
  private
    [Column('id_worker', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_worker: Integer;
    
    [Column('dovolena', [TColumnProp.Required])]
    [Description('')]
    Fdovolena: Integer;
    
    [Column('prescas', [TColumnProp.Required])]
    [Description('')]
    Fprescas: Integer;

    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_worker: Integer read Fid_worker write Fid_worker;
    property dovolena: Integer read Fdovolena write Fdovolena;
    property prescas: Integer read Fprescas write Fprescas;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('plan_worker_skupina')]
  [Description('Pln msto prce')]
  [Id('Fid_worker_skupina', TIdGenerator.IdentityOrSequence)]
  Tplan_worker_skupina = class(TTMSAGObject)
  private
    [Column('id_worker_skupina', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_worker_skupina: Integer;
    
    [Column('popis', [TColumnProp.Required], 100)]
    [Description('')]
    Fpopis: string;
    
    [Column('ma_mit_plan', [TColumnProp.Required])]
    [Description('')]
    Fma_mit_plan: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_worker_skupina: Integer read Fid_worker_skupina write Fid_worker_skupina;
    property popis: string read Fpopis write Fpopis;
    property ma_mit_plan: Integer read Fma_mit_plan write Fma_mit_plan;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('pozice')]
  [Description('Pozice materialu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tpozice = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('sklad_id', [TColumnProp.Required])]
    [Description('')]
    Fsklad_id: Integer;
    
    [Column('pozice', [TColumnProp.Required], 50)]
    [Description('')]
    Fpozice: string;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property sklad_id: Integer read Fsklad_id write Fsklad_id;
    property pozice: string read Fpozice write Fpozice;
    property mnoz: Double read Fmnoz write Fmnoz;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('prohlidky_stroje')]
  [Description('Sevisni prohlidny jednotlivych stroju')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tprohlidky_stroje = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('stroj_id', [TColumnProp.Required])]
    [Description('')]
    Fstroj_id: Integer;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;

    [Column('stav_hodin', [TColumnProp.Required])]
    [Description('')]
    Fstav_hodin: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('typ_id', [TColumnProp.Required])]
    [Description('')]
    Ftyp_id: Integer;
    
    [Column('stroj_typ', [TColumnProp.Required])]
    [Description('')]
    Fstroj_typ: Integer;
    
    [Column('readdata_id', [TColumnProp.Required])]
    [Description('')]
    Freaddata_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('provedl', [TColumnProp.Required], 200)]
    [Description('')]
    Fprovedl: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property stroj_id: Integer read Fstroj_id write Fstroj_id;
    property datum: TDateTime read Fdatum write Fdatum;
    property stav_hodin: Integer read Fstav_hodin write Fstav_hodin;
    property note: string read Fnote write Fnote;
    property typ_id: Integer read Ftyp_id write Ftyp_id;
    property stroj_typ: Integer read Fstroj_typ write Fstroj_typ;
    property readdata_id: Integer read Freaddata_id write Freaddata_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property provedl: string read Fprovedl write Fprovedl;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('pruv_list')]
  [Description('pruvodni list zakazek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tpruv_list = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Int64;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;
    
    [Column('mnoz', [TColumnProp.Required], 9, 3)]
    [Description('')]
    Fmnoz: Double;
    
    [Column('zmetku', [TColumnProp.Required], 9, 3)]
    [Description('')]
    Fzmetku: Double;
    
    [Column('rucnizmena', [TColumnProp.Required])]
    [Description('')]
    Frucnizmena: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property worker_id: Int64 read Fworker_id write Fworker_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property order_id: string read Forder_id write Forder_id;
    property date: TDateTime read Fdate write Fdate;
    property mnoz: Double read Fmnoz write Fmnoz;
    property zmetku: Double read Fzmetku write Fzmetku;
    property rucnizmena: Integer read Frucnizmena write Frucnizmena;
    property note: string read Fnote write Fnote;
    property datum: TDateTime read Fdatum write Fdatum;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('readdata')]
  [Description('Nactena data prace zamestnancu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Treaddata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('repair_type', [TColumnProp.Required])]
    [Description('')]
    Frepair_type: Integer;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('calculated', [TColumnProp.Required])]
    [Description('')]
    Fcalculated: Integer;

    [Column('order_group_id', [TColumnProp.Required])]
    [Description('')]
    Forder_group_id: Integer;
    
    [Column('calculated_machine', [TColumnProp.Required])]
    [Description('')]
    Fcalculated_machine: Integer;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    
    [Column('ukonova_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukonova_mzda: Double;

    [Column('added_price', [TColumnProp.Required])]
    [Description('')]
    Fadded_price: Integer;
    
    [Column('naklady', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fnaklady: Double;

    [Column('serial_id', [TColumnProp.Required])]
    [Description('')]
    Fserial_id: Int64;
    
    [Column('exportovano', [TColumnProp.Required])]
    [Description('')]
    Fexportovano: Integer;
    
    [Column('ukon_mzda', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fukon_mzda: Double;
    
    [Column('typ_ukon_mzdy', [TColumnProp.Required])]
    [Description('')]
    Ftyp_ukon_mzdy: Integer;
    
    [Column('zmetku', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fzmetku: Double;
    
    [Column('worker_id2', [TColumnProp.Required])]
    [Description('')]
    Fworker_id2: Integer;

    [Column('volitelna1', [TColumnProp.Required])]
    [Description('')]
    Fvolitelna1: Integer;

    [Column('kusy_zapocteno', [TColumnProp.Required])]
    [Description('')]
    Fkusy_zapocteno: Integer;
    
    [Column('calculated_orderwork', [TColumnProp.Required])]
    [Description('')]
    Fcalculated_orderwork: Integer;
    
    [Column('calculated_kalendar', [TColumnProp.Required])]
    [Description('')]
    Fcalculated_kalendar: Integer;
    
    [Column('photo_count', [TColumnProp.Required])]
    [Description('')]
    Fphoto_count: Integer;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('dodaci_list_polozka_id', [TColumnProp.Required])]
    [Description('')]
    Fdodaci_list_polozka_id: Integer;
    
    [Column('volitelna2', [TColumnProp.Required], 7, 2)]
    [Description('')]
    Fvolitelna2: Double;

    [Column('serial_id_str', [], 50)]
    [Description('')]
    Fserial_id_str: Nullable<string>;
    
    [Column('hnizdo', [])]
    [Description('')]
    Fhnizdo: Nullable<Integer>;
    
    [Column('poradi_operace', [TColumnProp.Required])]
    [Description('')]
    Fporadi_operace: Integer;
    
    [Column('orderwork_id', [])]
    [Description('')]
    Forderwork_id: Nullable<Integer>;
    
    [Column('zamceno', [TColumnProp.Required])]
    [Description('')]
    Fzamceno: Integer;
    
    [Column('zamceno_cas', [TColumnProp.Required])]
    [Description('')]
    Fzamceno_cas: TDateTime;
    
    [Column('zamceno_id_user', [TColumnProp.Required])]
    [Description('')]
    Fzamceno_id_user: Integer;

    [Column('sarze', [TColumnProp.Required], 255)]
    [Description('')]
    Fsarze: string;
    
    [Column('naklady_vstup', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fnaklady_vstup: Double;
    
    [Column('locked', [TColumnProp.Required])]
    [Description('')]
    Flocked: Integer;
    
    [Column('cena_worker', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_worker: Double;

    [Column('cena_worker2', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_worker2: Double;
    
    [Column('cena_operation', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_operation: Double;

    [Column('cena_cnc', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_cnc: Double;

    [Column('cena_stroj', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_stroj: Double;
    
    [Column('faktura_id', [])]
    [Description('')]
    Ffaktura_id: Nullable<Integer>;
    
    [Column('faktura_doklad', [], 150)]
    [Description('')]
    Ffaktura_doklad: Nullable<string>;
    
    [Column('cena_MJ', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcena_MJ: Double;
    
    [Column('typ_vypoctu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu: Integer;
    
    [Column('prepocitano', [TColumnProp.Required])]
    [Description('')]
    Fprepocitano: Integer;
    
    [Column('naklady_worker', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fnaklady_worker: Double;

    [Column('naklady_order', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fnaklady_order: Double;
    
    [Column('naklady_operation', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fnaklady_operation: Double;
    
    [Column('um_uznano', [])]
    [Description('')]
    Fum_uznano: Nullable<Integer>;
    
    [Column('um_fond_odpis', [])]
    [Description('')]
    Fum_fond_odpis: Nullable<Integer>;
    
    [Column('um_fond_zbyva', [])]
    [Description('')]
    Fum_fond_zbyva: Nullable<Integer>;
    
    [Column('um_uznano_datum', [])]
    [Description('')]
    Fum_uznano_datum: Nullable<TDateTime>;
    
    [Column('um_uznano_user', [], 100)]
    [Description('')]
    Fum_uznano_user: Nullable<string>;

    [Column('externi_id', [], 100)]
    [Description('')]
    Fexterni_id: Nullable<string>;
    
    [Column('ceny_added', [TColumnProp.Required])]
    [Description('')]
    Fceny_added: Integer;
    
    [Column('terminal_ip', [TColumnProp.Required], 64)]
    [Description('')]
    Fterminal_ip: string;
    
    [Column('stroj_id', [TColumnProp.Required])]
    [Description('')]
    Fstroj_id: Integer;
    
    [Column('vydano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvydano: Double;
    
    [Column('priznak1', [TColumnProp.Required])]
    [Description('')]
    Fpriznak1: Integer;
    
    [Column('priznak2', [TColumnProp.Required])]
    [Description('')]
    Fpriznak2: Integer;

    [Column('note2', [TColumnProp.Lazy])]
    [Description('')]
    Fnote2: string;
    
    [Column('note2_transferred', [TColumnProp.Required])]
    [Description('')]
    Fnote2_transferred: Integer;
    
    [Column('worker_group_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_group_id: Int64;
    
    [Column('produktivita', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fproduktivita: Double;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property order_id: string read Forder_id write Forder_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property repair_type: Integer read Frepair_type write Frepair_type;
    property note: string read Fnote write Fnote;
    property user: string read Fuser write Fuser;
    property calculated: Integer read Fcalculated write Fcalculated;
    property order_group_id: Integer read Forder_group_id write Forder_group_id;
    property calculated_machine: Integer read Fcalculated_machine write Fcalculated_machine;
    property mnoz: Double read Fmnoz write Fmnoz;
    property ukonova_mzda: Double read Fukonova_mzda write Fukonova_mzda;
    property added_price: Integer read Fadded_price write Fadded_price;
    property naklady: Double read Fnaklady write Fnaklady;
    property serial_id: Int64 read Fserial_id write Fserial_id;
    property exportovano: Integer read Fexportovano write Fexportovano;
    property ukon_mzda: Double read Fukon_mzda write Fukon_mzda;
    property typ_ukon_mzdy: Integer read Ftyp_ukon_mzdy write Ftyp_ukon_mzdy;
    property zmetku: Double read Fzmetku write Fzmetku;
    property worker_id2: Integer read Fworker_id2 write Fworker_id2;
    property volitelna1: Integer read Fvolitelna1 write Fvolitelna1;
    property kusy_zapocteno: Integer read Fkusy_zapocteno write Fkusy_zapocteno;
    property calculated_orderwork: Integer read Fcalculated_orderwork write Fcalculated_orderwork;
    property calculated_kalendar: Integer read Fcalculated_kalendar write Fcalculated_kalendar;
    property photo_count: Integer read Fphoto_count write Fphoto_count;
    property priorita: Integer read Fpriorita write Fpriorita;
    property dodaci_list_polozka_id: Integer read Fdodaci_list_polozka_id write Fdodaci_list_polozka_id;
    property volitelna2: Double read Fvolitelna2 write Fvolitelna2;
    property serial_id_str: Nullable<string> read Fserial_id_str write Fserial_id_str;
    property hnizdo: Nullable<Integer> read Fhnizdo write Fhnizdo;
    property poradi_operace: Integer read Fporadi_operace write Fporadi_operace;
    property orderwork_id: Nullable<Integer> read Forderwork_id write Forderwork_id;
    property zamceno: Integer read Fzamceno write Fzamceno;
    property zamceno_cas: TDateTime read Fzamceno_cas write Fzamceno_cas;
    property zamceno_id_user: Integer read Fzamceno_id_user write Fzamceno_id_user;
    property sarze: string read Fsarze write Fsarze;
    property naklady_vstup: Double read Fnaklady_vstup write Fnaklady_vstup;
    property locked: Integer read Flocked write Flocked;
    property cena_worker: Double read Fcena_worker write Fcena_worker;
    property cena_worker2: Double read Fcena_worker2 write Fcena_worker2;
    property cena_operation: Double read Fcena_operation write Fcena_operation;
    property cena_cnc: Double read Fcena_cnc write Fcena_cnc;
    property cena_stroj: Double read Fcena_stroj write Fcena_stroj;
    property faktura_id: Nullable<Integer> read Ffaktura_id write Ffaktura_id;
    property faktura_doklad: Nullable<string> read Ffaktura_doklad write Ffaktura_doklad;
    property cena_MJ: Double read Fcena_MJ write Fcena_MJ;
    property typ_vypoctu: Integer read Ftyp_vypoctu write Ftyp_vypoctu;
    property prepocitano: Integer read Fprepocitano write Fprepocitano;
    property naklady_worker: Double read Fnaklady_worker write Fnaklady_worker;
    property naklady_order: Double read Fnaklady_order write Fnaklady_order;
    property naklady_operation: Double read Fnaklady_operation write Fnaklady_operation;
    property um_uznano: Nullable<Integer> read Fum_uznano write Fum_uznano;
    property um_fond_odpis: Nullable<Integer> read Fum_fond_odpis write Fum_fond_odpis;
    property um_fond_zbyva: Nullable<Integer> read Fum_fond_zbyva write Fum_fond_zbyva;
    property um_uznano_datum: Nullable<TDateTime> read Fum_uznano_datum write Fum_uznano_datum;
    property um_uznano_user: Nullable<string> read Fum_uznano_user write Fum_uznano_user;
    property externi_id: Nullable<string> read Fexterni_id write Fexterni_id;
    property ceny_added: Integer read Fceny_added write Fceny_added;
    property terminal_ip: string read Fterminal_ip write Fterminal_ip;
    property stroj_id: Integer read Fstroj_id write Fstroj_id;
    property vydano: Double read Fvydano write Fvydano;
    property priznak1: Integer read Fpriznak1 write Fpriznak1;
    property priznak2: Integer read Fpriznak2 write Fpriznak2;
    property note2: string read Fnote2 write Fnote2;
    property note2_transferred: Integer read Fnote2_transferred write Fnote2_transferred;
    property worker_group_id: Int64 read Fworker_group_id write Fworker_group_id;
    property produktivita: Double read Fproduktivita write Fproduktivita;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('readdata_ceny')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Treaddata_ceny = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('id_readdata', [TColumnProp.Required])]
    [Description('')]
    Fid_readdata: Int64;
    
    [Column('cena_worker', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_worker: Double;
    
    [Column('cena_worker_naklad', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_worker_naklad: Double;
    
    [Column('cena_worker_faktura', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_worker_faktura: Double;
    
    [Column('cena_worker2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_worker2: Double;
    
    [Column('cena_worker2_naklad', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_worker2_naklad: Double;
    
    [Column('cena_worker2_faktura', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_worker2_faktura: Double;
    
    [Column('cena_operation', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_operation: Double;

    [Column('cena_operation_mj', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_operation_mj: Double;
    
    [Column('cena_ow_operation', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_ow_operation: Double;
    
    [Column('cena_ow_operation_mj', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_ow_operation_mj: Double;
    
    [Column('cena_stroj', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_stroj: Double;
    
    [Column('cena_cnc', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_cnc: Double;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('time_stamp', [TColumnProp.Required])]
    [Description('')]
    Ftime_stamp: TDateTime;

    [Column('verze', [TColumnProp.Required], 50)]
    [Description('')]
    Fverze: string;
    
    [Column('worker_koef_skut_nakl', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fworker_koef_skut_nakl: Double;

    [Column('worker2_koef_skut_nakl', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fworker2_koef_skut_nakl: Double;
    
    [Column('typ_vypoctu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu: Integer;
    
    [Column('added', [TColumnProp.Required])]
    [Description('')]
    Fadded: Integer;
    
    [Column('calculated', [TColumnProp.Required])]
    [Description('')]
    Fcalculated: Integer;
    
    [Column('worker_price_sat', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fworker_price_sat: Double;
    
    [Column('worker2_price_sat', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fworker2_price_sat: Double;
    
    [Column('worker_price_sun', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fworker_price_sun: Double;
    
    [Column('worker2_price_sun', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fworker2_price_sun: Double;
    
    [Column('mzda', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fmzda: Double;
    
    [Column('naklad', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fnaklad: Double;
    
    [Column('op_cena_rezie', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fop_cena_rezie: Double;
    
    [Column('ow_ukolova_mzda', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fow_ukolova_mzda: Double;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('worker_id2', [TColumnProp.Required])]
    [Description('')]
    Fworker_id2: Integer;
    
    [Column('mzda_hod', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fmzda_hod: Double;
    
    [Column('mzda_ukol', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fmzda_ukol: Double;

    [Column('odvody', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fodvody: Double;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    
    [Column('ts_calculated', [TColumnProp.Required])]
    [Description('')]
    Fts_calculated: TDateTime;
    
    [Column('op_ukol_mzda', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fop_ukol_mzda: Double;
    
    [Column('op_cena_mj_odmena', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_cena_mj_odmena: Double;
    
    [Column('rezie', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Frezie: Double;
    
    [Column('ow_cena_rezie', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fow_cena_rezie: Double;

    [Column('ow_unit_price', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fow_unit_price: Double;
    
    [Column('op_cena_mj', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fop_cena_mj: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property id_readdata: Int64 read Fid_readdata write Fid_readdata;
    property cena_worker: Double read Fcena_worker write Fcena_worker;
    property cena_worker_naklad: Double read Fcena_worker_naklad write Fcena_worker_naklad;
    property cena_worker_faktura: Double read Fcena_worker_faktura write Fcena_worker_faktura;
    property cena_worker2: Double read Fcena_worker2 write Fcena_worker2;
    property cena_worker2_naklad: Double read Fcena_worker2_naklad write Fcena_worker2_naklad;
    property cena_worker2_faktura: Double read Fcena_worker2_faktura write Fcena_worker2_faktura;
    property cena_operation: Double read Fcena_operation write Fcena_operation;
    property cena_operation_mj: Double read Fcena_operation_mj write Fcena_operation_mj;
    property cena_ow_operation: Double read Fcena_ow_operation write Fcena_ow_operation;
    property cena_ow_operation_mj: Double read Fcena_ow_operation_mj write Fcena_ow_operation_mj;
    property cena_stroj: Double read Fcena_stroj write Fcena_stroj;
    property cena_cnc: Double read Fcena_cnc write Fcena_cnc;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property time_stamp: TDateTime read Ftime_stamp write Ftime_stamp;
    property verze: string read Fverze write Fverze;
    property worker_koef_skut_nakl: Double read Fworker_koef_skut_nakl write Fworker_koef_skut_nakl;
    property worker2_koef_skut_nakl: Double read Fworker2_koef_skut_nakl write Fworker2_koef_skut_nakl;
    property typ_vypoctu: Integer read Ftyp_vypoctu write Ftyp_vypoctu;
    property added: Integer read Fadded write Fadded;
    property calculated: Integer read Fcalculated write Fcalculated;
    property worker_price_sat: Double read Fworker_price_sat write Fworker_price_sat;
    property worker2_price_sat: Double read Fworker2_price_sat write Fworker2_price_sat;
    property worker_price_sun: Double read Fworker_price_sun write Fworker_price_sun;
    property worker2_price_sun: Double read Fworker2_price_sun write Fworker2_price_sun;
    property mzda: Double read Fmzda write Fmzda;
    property naklad: Double read Fnaklad write Fnaklad;
    property op_cena_rezie: Double read Fop_cena_rezie write Fop_cena_rezie;
    property ow_ukolova_mzda: Double read Fow_ukolova_mzda write Fow_ukolova_mzda;
    property mnoz: Double read Fmnoz write Fmnoz;
    property order_id: string read Forder_id write Forder_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property worker_id2: Integer read Fworker_id2 write Fworker_id2;
    property mzda_hod: Double read Fmzda_hod write Fmzda_hod;
    property mzda_ukol: Double read Fmzda_ukol write Fmzda_ukol;
    property odvody: Double read Fodvody write Fodvody;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property ts_calculated: TDateTime read Fts_calculated write Fts_calculated;
    property op_ukol_mzda: Double read Fop_ukol_mzda write Fop_ukol_mzda;
    property op_cena_mj_odmena: Double read Fop_cena_mj_odmena write Fop_cena_mj_odmena;
    property rezie: Double read Frezie write Frezie;
    property ow_cena_rezie: Double read Fow_cena_rezie write Fow_cena_rezie;
    property ow_unit_price: Double read Fow_unit_price write Fow_unit_price;
    property op_cena_mj: Double read Fop_cena_mj write Fop_cena_mj;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('readdata_doc')]
  [Description('dokumenty nactenych dat')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Treaddata_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('id_readdata', [TColumnProp.Required])]
    [Description('')]
    Fid_readdata: Integer;
    
    [Column('type', [TColumnProp.Required], 6)]
    [Description('')]
    Ftype_: string;
    
    [Column('content', [TColumnProp.Required, TColumnProp.Lazy])]
    [Description('')]
    Fcontent: TBlob;

    [Column('exported', [TColumnProp.Required])]
    [Description('')]
    Fexported: Integer;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('processed', [TColumnProp.Required])]
    [Description('')]
    Fprocessed: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property id_readdata: Integer read Fid_readdata write Fid_readdata;
    property type_: string read Ftype_ write Ftype_;
    property content: TBlob read Fcontent write Fcontent;
    property exported: Integer read Fexported write Fexported;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property processed: Integer read Fprocessed write Fprocessed;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('readdata_foto')]
  [Description('Tabulka odkazu na snimky')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Treaddata_foto = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('readdata_id', [TColumnProp.Required])]
    [Description('')]
    Freaddata_id: Int64;
    
    [Column('foto_path', [TColumnProp.Required], 256)]
    [Description('')]
    Ffoto_path: string;
    
    [Column('isFile', [TColumnProp.Required])]
    [Description('')]
    FisFile: Integer;
    
    [Column('foto_Data', [TColumnProp.Lazy])]
    [Description('')]
    Ffoto_Data: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property readdata_id: Int64 read Freaddata_id write Freaddata_id;
    property foto_path: string read Ffoto_path write Ffoto_path;
    property isFile: Integer read FisFile write FisFile;
    property foto_Data: TBlob read Ffoto_Data write Ffoto_Data;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('readdata_stroj')]
  [Description('Naten data stroj z monitoringu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Treaddata_stroj = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('worker_id2', [TColumnProp.Required])]
    [Description('')]
    Fworker_id2: Integer;
    
    [Column('stroj_id', [TColumnProp.Required])]
    [Description('')]
    Fstroj_id: Integer;
    
    [Column('status_id', [TColumnProp.Required])]
    [Description('')]
    Fstatus_id: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property mnoz: Double read Fmnoz write Fmnoz;
    property order_id: string read Forder_id write Forder_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property worker_id2: Integer read Fworker_id2 write Fworker_id2;
    property stroj_id: Integer read Fstroj_id write Fstroj_id;
    property status_id: Integer read Fstatus_id write Fstatus_id;
    property note: string read Fnote write Fnote;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('reader')]
  [Description('???')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Treader = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;
    
    [Column('code', [TColumnProp.Required], 20)]
    [Description('')]
    Fcode: string;
    
    [Column('processed', [TColumnProp.Required])]
    [Description('')]
    Fprocessed: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property date: TDateTime read Fdate write Fdate;
    property code: string read Fcode write Fcode;
    property processed: Integer read Fprocessed write Fprocessed;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ref_operation_cnc')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_operation_cnc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_id: proxy<Toperation>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cnc_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fcnc_id: proxy<Tcnc_stroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_id: Toperation;
    procedure setoperation_id(const Value : Toperation);
    function getcnc_id: Tcnc_stroje;
    procedure setcnc_id(const Value : Tcnc_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property operation_id: Toperation read getoperation_id write setoperation_id;
    property cnc_id: Tcnc_stroje read getcnc_id write setcnc_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_operation_worker')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_operation_worker = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<TWorker>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('operation_id', [], 'id')]
    [Description('')]
    Foperation_id: proxy<TOperation>;

    [Column('worker_cena', [TColumnProp.Required], 23)]
    [Description('')]
    Fworker_cena: Double;

    [Column('operation_cena', [TColumnProp.Required], 23)]
    [Description('')]
    Foperation_cena: Double;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_id: TOperation;
    procedure setoperation_id(const Value: Toperation);
    function getworker_id: TWorker;
    procedure setworker_id(const Value : TWorker);

  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property worker_id: Tworker read getworker_id write setworker_id;
    property operation_id: Toperation read getoperation_id write setoperation_id;
    property worker_cena: Double read Fworker_cena write Fworker_cena;
    property operation_cena: Double read Foperation_cena write Foperation_cena;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_operation_worker')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_worker_operation = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<TWorker>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('operation_id', [], 'id')]
    [Description('')]
    Foperation_id: proxy<TOperation>;

    [Column('worker_cena', [TColumnProp.Required], 23)]
    [Description('')]
    Fworker_cena: Double;

    [Column('operation_cena', [TColumnProp.Required], 23)]
    [Description('')]
    Foperation_cena: Double;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_id: TOperation;
    procedure setoperation_id(const Value: Toperation);
    function getworker_id: TWorker;
    procedure setworker_id(const Value : TWorker);

  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property worker_id: Tworker read getworker_id write setworker_id;
    property operation_id: Toperation read getoperation_id write setoperation_id;
    property worker_cena: Double read Fworker_cena write Fworker_cena;
    property operation_cena: Double read Foperation_cena write Foperation_cena;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_operation_cnc')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_cnc_stroje_operation = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_id: proxy<Toperation>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cnc_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fcnc_id: proxy<Tcnc_stroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_id: Toperation;
    procedure setoperation_id(const Value : Toperation);
    function getcnc_id: Tcnc_stroje;
    procedure setcnc_id(const Value : Tcnc_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property operation_id: Toperation read getoperation_id write setoperation_id;
    property cnc_id: Tcnc_stroje read getcnc_id write setcnc_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;

    property DynCon: TDynamicProperties read FDynCon;
  end;


  [Entity]
  [Table('ref_planjednotka_operation')]
  [Description('referencni tabulka planovaci jednotka - operation')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_planjednotka_operation = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'ResourceID')]
    [Description('')]
    Fplanjednotka_id: proxy<Tschedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [], 'id')]
    [Description('')]
    Foperation_id: proxy<TOperation>;

    [Column('operation_type', [TColumnProp.Required])]
    [Description('')]
    Foperation_type: Integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tschedulerresource;
    procedure setplanjednotka_id(const Value : Tschedulerresource);
    function getoperation_id: TOperation;
    procedure setoperation_id(const Value : TOperation);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
     function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tschedulerresource read getplanjednotka_id write setplanjednotka_id;
    property operation_id: TOperation read getoperation_id write setoperation_id;
    property operation_type: Integer read Foperation_type write Foperation_type;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_planjednotka_operation_group')]
  [Description('referencni tabulka planovaci jednotka - operation_group')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_planjednotka_operation_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'ResourceID')]
    [Description('')]
    Fplanjednotka_id: proxy<Tschedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_group_id', [], 'id')]
    [Description('')]
    Foperation_group_id: proxy<TOperation_group>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tschedulerresource;
    procedure setplanjednotka_id(const Value : Tschedulerresource);
    function getoperation_group_id: TOperation_group;
    procedure setoperation_group_id(const Value : TOperation_group);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tschedulerresource read getplanjednotka_id write setplanjednotka_id;
    property operation_group_id: TOperation_group read getoperation_group_id write setoperation_group_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_planjednotka_worker')]
  [Description('referencni tabulka planovaci jednotka - worker')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_planjednotka_worker = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'ResourceID')]
    [Description('')]
    Fplanjednotka_id: proxy<Tschedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<TWorker>;

    [Column('worker_type', [TColumnProp.Required])]
    [Description('')]
    Fworker_type: Integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tschedulerresource;
    procedure setplanjednotka_id(const Value : Tschedulerresource);
    function getworker_id: TWorker;
    procedure setworker_id(const Value : TWorker);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tschedulerresource read getplanjednotka_id write setplanjednotka_id;
    property worker_id: TWorker read getworker_id write setworker_id;
    property worker_type: Integer read Fworker_type write Fworker_type;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_ep_planjednotka_worker')]
  [Description('referencni tabulka planovaci jednotka - worker')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_ep_planjednotka_worker = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'id')]
    [Description('')]
    Fplanjednotka_id: proxy<Tep_schedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<TWorker>;

    [Column('worker_type', [TColumnProp.Required])]
    [Description('')]
    Fworker_type: Integer;
    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tep_schedulerresource;
    procedure setplanjednotka_id(const Value : Tep_schedulerresource);
    function getworker_id: TWorker;
    procedure setworker_id(const Value : TWorker);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tep_schedulerresource read getplanjednotka_id write setplanjednotka_id;
    property worker_id: TWorker read getworker_id write setworker_id;
    property worker_type: Integer read Fworker_type write Fworker_type;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_ep_planjednotka_worker')]
  [Description('referencni tabulka planovaci jednotka - cnc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_ep_planjednotka_cnc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'id')]
    [Description('')]
    Fplanjednotka_id: proxy<Tep_schedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<Tcnc_stroje>;

    [Column('worker_type', [TColumnProp.Required])]
    [Description('')]
    Fworker_type: Integer;
    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tep_schedulerresource;
    procedure setplanjednotka_id(const Value : Tep_schedulerresource);
    function getworker_id: Tcnc_stroje;
    procedure setworker_id(const Value : Tcnc_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tep_schedulerresource read getplanjednotka_id write setplanjednotka_id;
    property worker_id: Tcnc_stroje read getworker_id write setworker_id;
    property worker_type: Integer read Fworker_type write Fworker_type;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_ep_planjednotka_operation')]
  [Description('referencni tabulka planovaci jednotka ep - operation')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_ep_planjednotka_operation = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'id')]
    [Description('')]
    Fplanjednotka_id: proxy<Tep_schedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [], 'id')]
    [Description('')]
    Foperation_id: proxy<TOperation>;


    [Column('operation_type', [TColumnProp.Required])]
    [Description('')]
    Foperation_type: Integer;
    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tep_schedulerresource;
    procedure setplanjednotka_id(const Value : Tep_schedulerresource);
    function getoperation_id: TOperation;
    procedure setoperation_id(const Value : TOperation);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tep_schedulerresource read getplanjednotka_id write setplanjednotka_id;
    property operation_id: TOperation read getoperation_id write setoperation_id;
    property operation_type: Integer read Foperation_type write Foperation_type;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_ep_planjednotka_operation_group')]
  [Description('referencni tabulka planovaci jednotka ep - operation_group')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_ep_planjednotka_operation_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('planjednotka_id', [], 'id')]
    [Description('')]
    Fplanjednotka_id: proxy<Tep_schedulerresource>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_group_id', [], 'id')]
    [Description('')]
    Foperation_group_id: proxy<TOperation_group>;


    FDynCon: TDynamicProperties;
    function getplanjednotka_id: Tep_schedulerresource;
    procedure setplanjednotka_id(const Value : Tep_schedulerresource);
    function getoperation_group_id: TOperation_group;
    procedure setoperation_group_id(const Value : TOperation_group);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property planjednotka_id: Tep_schedulerresource read getplanjednotka_id write setplanjednotka_id;
    property operation_group_id: TOperation_group read getoperation_group_id write setoperation_group_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;


  [Entity]
  [Table('ref_user_orderstav')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_user_orderstav = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;

    [Column('order_stav', [TColumnProp.Required])]
    [Description('')]
    Forder_stav: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property order_stav: Integer read Forder_stav write Forder_stav;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_user_ordertyp')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_user_ordertyp = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;

    [Column('order_typ', [TColumnProp.Required])]
    [Description('')]
    Forder_typ: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property order_typ: Integer read Forder_typ write Forder_typ;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_users_user_roles')]
  [Description('Referenn tabulka propojen uivatele a role, vstup z uivatele')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_users_user_roles = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('user_id', [], 'id')]
    [Description('')]
    Fuser_id: proxy<Tusers>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('role_id', [], 'id')]
    [Description('')]
    Frole_id: proxy<Tuser_roles>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    procedure setuser_id (const AValue : Tusers);
    function getuser_id : Tusers;
    procedure setrole_id (const AValue : Tuser_roles);
    function getrole_id : Tuser_roles;

  public
    constructor Create; override;
    destructor Destroy; override;
    procedure  Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    function CheckRequiredFields : Boolean; override;
    property id: Integer read Fid write Fid;
    property user_id : Tusers read getuser_id write setuser_id;
    property role_id : Tuser_roles read getrole_id write setrole_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_users_user_roles')]
  [Description('Referenn tabulka propojen uivatele a role, vstup z role')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_user_roles_users = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('user_id', [], 'id')]
    [Description('')]
    Fuser_id: proxy<Tusers>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('role_id', [], 'id')]
    [Description('')]
    Frole_id: proxy<Tuser_roles>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    procedure setuser_id (const AValue : Tusers);
    function getuser_id : Tusers;
    procedure setrole_id (const AValue : Tuser_roles);
    function getrole_id : Tuser_roles;

  public
    constructor Create; override;
    destructor Destroy; override;
    procedure  Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    function CheckRequiredFields : Boolean; override;
    property id: Integer read Fid write Fid;
    property user_id : Tusers read getuser_id write setuser_id;
    property role_id : Tuser_roles read getrole_id write setrole_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;


  [Entity]
  [Table('ref_worker_cnc')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_worker_cnc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('cnc_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property cnc_id: Integer read Fcnc_id write Fcnc_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ref_worker_group')]
  [Description('reference na skupiny zamestnancu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_worker_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('is_master', [TColumnProp.Required])]
    [Description('')]
    Fis_master: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property is_master: Integer read Fis_master write Fis_master;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('registrace')]
  [Description('registrace')]
  [Id('Fhwnumber', TIdGenerator.None)]
  Tregistrace = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('cnt', [TColumnProp.Lazy])]
    [Description('')]
    Fcnt: TBlob;
    
    [Column('data', [TColumnProp.Lazy])]
    [Description('')]
    Fdata: TBlob;
    
    [Column('hwnumber', [TColumnProp.Required], 150)]
    [Description('')]
    Fhwnumber: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property cnt: TBlob read Fcnt write Fcnt;
    property data: TBlob read Fdata write Fdata;
    property hwnumber: string read Fhwnumber write Fhwnumber;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('repair_type')]
  [Description('Typy oprav')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Trepair_type = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Required], 255)]
    [Description('')]
    Fnote: string;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('Special1', [TColumnProp.Required])]
    [Description('')]
    FSpecial1: Boolean;

    [Column('Special2', [TColumnProp.Required])]
    [Description('')]
    FSpecial2: Boolean;
    
    [Column('Zmetek', [TColumnProp.Required])]
    [Description('')]
    FZmetek: Boolean;
    
    [Column('stroj_typ', [])]
    [Description('')]
    Fstroj_typ: Nullable<Integer>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('stroj_id', [], 'id')]
    [Description('')]
    Fstroj_id: proxy<Tstroje>;
    function getstroj_id: Tstroje;
    procedure setstroj_id(const Value : Tstroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property bar_id: string read Fbar_id write Fbar_id;
    property user: string read Fuser write Fuser;
    property Special1: Boolean read FSpecial1 write FSpecial1;
    property Special2: Boolean read FSpecial2 write FSpecial2;
    property Zmetek: Boolean read FZmetek write FZmetek;
    property stroj_typ: Nullable<Integer> read Fstroj_typ write Fstroj_typ;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
    property stroj_id: Tstroje read getstroj_id write setstroj_id;
  end;
  
  [Entity]
  [Table('sablony_operation_group')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsablony_operation_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sablony_sklad_group')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsablony_sklad_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('SCHEDULEREXCEPTION')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  TSCHEDULEREXCEPTION = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;
    
    [Column('worker_id', [])]
    [Description('')]
    Fworker_id: Nullable<Integer>;
    
    [Column('resource_id', [])]
    [Description('')]
    Fresource_id: Nullable<Integer>;
    
    [Column('move_type', [TColumnProp.Required])]
    [Description('')]
    Fmove_type: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property datum: TDateTime read Fdatum write Fdatum;
    property worker_id: Nullable<Integer> read Fworker_id write Fworker_id;
    property resource_id: Nullable<Integer> read Fresource_id write Fresource_id;
    property move_type: Integer read Fmove_type write Fmove_type;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('schedulerresource')]
  [Description('Jednotky planovaciho kalendare')]
  [Id('FResourceID', TIdGenerator.IdentityOrSequence)]
  Tschedulerresource = class(TTMSAGObject)
  private
    [Column('ResourceID', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    FResourceID: Int64;
    
    [Column('ResourceColor', [TColumnProp.Required])]
    [Description('')]
    FResourceColor: Integer;

    [Column('ResourceName', [TColumnProp.Required], 50)]
    [Description('')]
    FResourceName: string;

    [Column('Fond', [TColumnProp.Required], 11, 3)]
    [Description('')]
    FFond: Double;

    [Column('PoStart', [TColumnProp.Required])]
    [Description('')]
    FPoStart: TDateTime;

    [Column('PoFinish', [TColumnProp.Required])]
    [Description('')]
    FPoFinish: TDateTime;

    [Column('UtStart', [TColumnProp.Required])]
    [Description('')]
    FUtStart: TDateTime;

    [Column('UtFinish', [TColumnProp.Required])]
    [Description('')]
    FUtFinish: TDateTime;

    [Column('StStart', [TColumnProp.Required])]
    [Description('')]
    FStStart: TDateTime;

    [Column('StFinish', [TColumnProp.Required])]
    [Description('')]
    FStFinish: TDateTime;

    [Column('CtStart', [TColumnProp.Required])]
    [Description('')]
    FCtStart: TDateTime;

    [Column('CtFinish', [TColumnProp.Required])]
    [Description('')]
    FCtFinish: TDateTime;

    [Column('PaStart', [TColumnProp.Required])]
    [Description('')]
    FPaStart: TDateTime;

    [Column('PaFinish', [TColumnProp.Required])]
    [Description('')]
    FPaFinish: TDateTime;

    [Column('SoStart', [TColumnProp.Required])]
    [Description('')]
    FSoStart: TDateTime;

    [Column('SoFinish', [TColumnProp.Required])]
    [Description('')]
    FSoFinish: TDateTime;

    [Column('NeStart', [TColumnProp.Required])]
    [Description('')]
    FNeStart: TDateTime;

    [Column('NeFinish', [TColumnProp.Required])]
    [Description('')]
    FNeFinish: TDateTime;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('parent_id', [], 'ResourceID')]
    [Description('')]
    Fparent_id: proxy<Tschedulerresource>;

    [Column('master_id', [TColumnProp.Required])]
    [Description('')]
    Fmaster_id: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('smena_id', [], 'id')]
    [Description('')]
    Fsmena_id: proxy<Tworker_smeny>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_planjednotka_workerList: Proxy<TList<Tref_planjednotka_worker>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_planjednotka_operationList: Proxy<TList<Tref_planjednotka_operation>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fplanjednotka_id')]
    Fref_planjednotka_operation_groupList: Proxy<TList<Tref_planjednotka_operation_group>>;

    function Getref_planjednotka_workerList: TList<Tref_planjednotka_worker>;
    function Getref_planjednotka_operationList: TList<Tref_planjednotka_operation>;
    function Getref_planjednotka_operation_groupList: TList<Tref_planjednotka_operation_group>;

    function getparent_id: Tschedulerresource;
    procedure setparent_id(const Value : Tschedulerresource);
    function getsmena_id: Tworker_smeny;
    procedure setsmena_id(const Value : Tworker_smeny);
    procedure setResourceID (const Value : Int64);

  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property ResourceID: Int64 read FResourceID write setResourceID;
    property ResourceColor: Integer read FResourceColor write FResourceColor;
    property ResourceName: string read FResourceName write FResourceName;
    property Fond: Double read FFond write FFond;
    property PoStart: TDateTime read FPoStart write FPoStart;
    property PoFinish: TDateTime read FPoFinish write FPoFinish;
    property UtStart: TDateTime read FUtStart write FUtStart;
    property UtFinish: TDateTime read FUtFinish write FUtFinish;
    property StStart: TDateTime read FStStart write FStStart;
    property StFinish: TDateTime read FStFinish write FStFinish;
    property CtStart: TDateTime read FCtStart write FCtStart;
    property CtFinish: TDateTime read FCtFinish write FCtFinish;
    property PaStart: TDateTime read FPaStart write FPaStart;
    property PaFinish: TDateTime read FPaFinish write FPaFinish;
    property SoStart: TDateTime read FSoStart write FSoStart;
    property SoFinish: TDateTime read FSoFinish write FSoFinish;
    property NeStart: TDateTime read FNeStart write FNeStart;
    property NeFinish: TDateTime read FNeFinish write FNeFinish;
    property parent_id: Tschedulerresource read getparent_id write setparent_id;
    property master_id: Integer read Fmaster_id write Fmaster_id;
    property smena_id: Tworker_smeny read getsmena_id write setsmena_id;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property ref_planjednotka_workerList: TList<Tref_planjednotka_worker> read Getref_planjednotka_workerList;
    property ref_planjednotka_operationList: TList<Tref_planjednotka_operation> read Getref_planjednotka_operationList;
    property ref_planjednotka_operation_groupList: TList<Tref_planjednotka_operation_group> read Getref_planjednotka_operation_groupList;

    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('schedulertable')]
  [Description('Planovaci kalendar')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tschedulertable = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('LabelColor', [])]
    [Description('')]
    FLabelColor: Nullable<Integer>;
    
    [Column('Caption', [], 256)]
    [Description('')]
    FCaption: Nullable<string>;
    
    [Column('EventType', [])]
    [Description('')]
    FEventType: Nullable<Integer>;
    
    [Column('Finish', [TColumnProp.Required])]
    [Description('')]
    FFinish: TDateTime;
    
    [Column('Location', [], 25)]
    [Description('')]
    FLocation: Nullable<string>;
    
    [Column('Options', [])]
    [Description('')]
    FOptions: Nullable<Integer>;
    
    [Column('ResourceID', [])]
    [Description('')]
    FResourceID: Nullable<Integer>;
    
    [Column('Start', [TColumnProp.Required])]
    [Description('')]
    FStart: TDateTime;
    
    [Column('State', [])]
    [Description('')]
    FState: Nullable<Integer>;
    
    [Column('order_id', [], 50)]
    [Description('')]
    Forder_id: Nullable<string>;
    
    [Column('operation_id', [], 10)]
    [Description('')]
    Foperation_id: Nullable<string>;
    
    [Column('Message', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    FMessage: TBlob;
    
    [Column('cas_na_kus', [])]
    [Description('')]
    Fcas_na_kus: Nullable<Integer>;
    
    [Column('plan_ks', [], 11, 2)]
    [Description('')]
    Fplan_ks: Nullable<Double>;
    
    [Column('plan_cas', [])]
    [Description('')]
    Fplan_cas: Nullable<Integer>;
    
    [Column('readdata_id', [TColumnProp.Required])]
    [Description('')]
    Freaddata_id: Int64;
    
    [Column('worker_id', [], 10)]
    [Description('')]
    Fworker_id: Nullable<string>;
    
    [Column('LabelColor2', [])]
    [Description('')]
    FLabelColor2: Nullable<Integer>;
    
    [Column('odprac_cas', [])]
    [Description('')]
    Fodprac_cas: Nullable<Integer>;
    
    [Column('vyteznost', [TColumnProp.Required])]
    [Description('')]
    Fvyteznost: Integer;
    
    [Column('zaplanovano', [])]
    [Description('')]
    Fzaplanovano: Nullable<Integer>;

    [Column('LabelColor3', [])]
    [Description('')]
    FLabelColor3: Nullable<Integer>;
    
    [Column('typ_kolize', [])]
    [Description('')]
    Ftyp_kolize: Nullable<Integer>;
    
    [Column('LabelColor4', [])]
    [Description('')]
    FLabelColor4: Nullable<Integer>;
    
    [Column('fixed', [TColumnProp.Required])]
    [Description('')]
    Ffixed: Integer;
    
    [Column('floating', [TColumnProp.Required])]
    [Description('')]
    Ffloating: Integer;
    
    [Column('erasable', [TColumnProp.Required])]
    [Description('')]
    Ferasable: Integer;
    
    [Column('visible', [TColumnProp.Required])]
    [Description('')]
    Fvisible: Integer;
    
    [Column('source', [TColumnProp.Required], 100)]
    [Description('')]
    Fsource: string;
    
    [Column('movecounter', [TColumnProp.Required])]
    [Description('')]
    Fmovecounter: Integer;
    
    [Column('mindatetime', [])]
    [Description('')]
    Fmindatetime: Nullable<TDateTime>;
    
    [Column('maxdatetime', [])]
    [Description('')]
    Fmaxdatetime: Nullable<TDateTime>;
    
    [Column('ep_simulace_id', [TColumnProp.Required])]
    [Description('')]
    Fep_simulace_id: Integer;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('binding_id', [TColumnProp.Required])]
    [Description('')]
    Fbinding_id: Int64;
    
    [Column('ukol_id', [TColumnProp.Required])]
    [Description('')]
    Fukol_id: Int64;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property LabelColor: Nullable<Integer> read FLabelColor write FLabelColor;
    property Caption: Nullable<string> read FCaption write FCaption;
    property EventType: Nullable<Integer> read FEventType write FEventType;
    property Finish: TDateTime read FFinish write FFinish;
    property Location: Nullable<string> read FLocation write FLocation;
    property Options: Nullable<Integer> read FOptions write FOptions;
    property ResourceID: Nullable<Integer> read FResourceID write FResourceID;
    property Start: TDateTime read FStart write FStart;
    property State: Nullable<Integer> read FState write FState;
    property order_id: Nullable<string> read Forder_id write Forder_id;
    property operation_id: Nullable<string> read Foperation_id write Foperation_id;
    property Message: TBlob read FMessage write FMessage;
    property cas_na_kus: Nullable<Integer> read Fcas_na_kus write Fcas_na_kus;
    property plan_ks: Nullable<Double> read Fplan_ks write Fplan_ks;
    property plan_cas: Nullable<Integer> read Fplan_cas write Fplan_cas;
    property readdata_id: Int64 read Freaddata_id write Freaddata_id;
    property worker_id: Nullable<string> read Fworker_id write Fworker_id;
    property LabelColor2: Nullable<Integer> read FLabelColor2 write FLabelColor2;
    property odprac_cas: Nullable<Integer> read Fodprac_cas write Fodprac_cas;
    property vyteznost: Integer read Fvyteznost write Fvyteznost;
    property zaplanovano: Nullable<Integer> read Fzaplanovano write Fzaplanovano;
    property LabelColor3: Nullable<Integer> read FLabelColor3 write FLabelColor3;
    property typ_kolize: Nullable<Integer> read Ftyp_kolize write Ftyp_kolize;
    property LabelColor4: Nullable<Integer> read FLabelColor4 write FLabelColor4;
    property fixed: Integer read Ffixed write Ffixed;
    property floating: Integer read Ffloating write Ffloating;
    property erasable: Integer read Ferasable write Ferasable;
    property visible: Integer read Fvisible write Fvisible;
    property source: string read Fsource write Fsource;
    property movecounter: Integer read Fmovecounter write Fmovecounter;
    property mindatetime: Nullable<TDateTime> read Fmindatetime write Fmindatetime;
    property maxdatetime: Nullable<TDateTime> read Fmaxdatetime write Fmaxdatetime;
    property ep_simulace_id: Integer read Fep_simulace_id write Fep_simulace_id;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property binding_id: Int64 read Fbinding_id write Fbinding_id;
    property ukol_id: Int64 read Fukol_id write Fukol_id;
    property poradi: Integer read Fporadi write Fporadi;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('script')]
  [Description('Tabulka skript pro customizaci programu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tscript = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('events', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fevents: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property events: TBlob read Fevents write Fevents;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('serial_code')]
  [Description('Seriova cisla')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tserial_code = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('note', [TColumnProp.Required], 512)]
    [Description('')]
    Fnote: string;
    
    [Column('oznaceni', [TColumnProp.Required], 50)]
    [Description('')]
    Foznaceni: string;
    
    [Column('radek', [TColumnProp.Required])]
    [Description('')]
    Fradek: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property order_id: string read Forder_id write Forder_id;
    property note: string read Fnote write Fnote;
    property oznaceni: string read Foznaceni write Foznaceni;
    property radek: Integer read Fradek write Fradek;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('servis_typ')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tservis_typ = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;
    
    [Column('agenda_id', [TColumnProp.Required])]
    [Description('')]
    Fagenda_id: Integer;
    
    [Column('zodpovida', [TColumnProp.Required], 200)]
    [Description('')]
    Fzodpovida: string;
    
    [Column('note', [TColumnProp.Required], 1024)]
    [Description('')]
    Fnote: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property agenda_id: Integer read Fagenda_id write Fagenda_id;
    property zodpovida: string read Fzodpovida write Fzodpovida;
    property note: string read Fnote write Fnote;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('servis_typ_ref_stroje')]
  [Description('')]
  [Id('Fstroj_id', TIdGenerator.None)]
  [Id('Fstroj_typ', TIdGenerator.None)]
  [Id('Foperation_id', TIdGenerator.None)]
  Tservis_typ_ref_stroje = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required])]
    [Description('')]
    Fid: Integer;
    
    [Column('stroj_id', [TColumnProp.Required])]
    [Description('')]
    Fstroj_id: Integer;
    
    [Column('stroj_typ', [TColumnProp.Required])]
    [Description('')]
    Fstroj_typ: Integer;
    
    [Column('typ_id', [TColumnProp.Required])]
    [Description('')]
    Ftyp_id: Integer;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Integer;
    
    [Column('servis_interval_cas', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_cas: Integer;
    
    [Column('servis_interval_mj', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_mj: Integer;
    
    [Column('servis_interval_typ', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_typ: Integer;
    
    [Column('servis_interval_obdobi', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_obdobi: Integer;
    
    [Column('servis_interval_obdobi_typ', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_obdobi_typ: Integer;
    
    [Column('servis_operation_id', [TColumnProp.Required])]
    [Description('')]
    Fservis_operation_id: Integer;
    
    [Column('servis_note', [TColumnProp.Lazy])]
    [Description('')]
    Fservis_note: string;

    [Column('servis_interval_obdobi_odstavka', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_obdobi_odstavka: Integer;
    
    [Column('servis_interval_obdobi_delka', [TColumnProp.Required])]
    [Description('')]
    Fservis_interval_obdobi_delka: Integer;
    
    [Column('servis_upozorneni_dny', [TColumnProp.Required])]
    [Description('')]
    Fservis_upozorneni_dny: Integer;
    
    [Column('servis_upozorneni_mail', [TColumnProp.Required])]
    [Description('')]
    Fservis_upozorneni_mail: boolean;
    
    [Column('servis_pristi_date', [TColumnProp.Required])]
    [Description('')]
    Fservis_pristi_date: TDateTime;
    
    [Column('servis_upozorneni_mail_vyroba', [TColumnProp.Required])]
    [Description('')]
    Fservis_upozorneni_mail_vyroba: Integer;
    
    [Column('servis_upozorneni_mj', [TColumnProp.Required])]
    [Description('')]
    Fservis_upozorneni_mj: Integer;
    
    [Column('servis_upozorneni_h', [TColumnProp.Required])]
    [Description('')]
    Fservis_upozorneni_h: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property stroj_id: Integer read Fstroj_id write Fstroj_id;
    property stroj_typ: Integer read Fstroj_typ write Fstroj_typ;
    property typ_id: Integer read Ftyp_id write Ftyp_id;
    property operation_id: Integer read Foperation_id write Foperation_id;
    property servis_interval_cas: Integer read Fservis_interval_cas write Fservis_interval_cas;
    property servis_interval_mj: Integer read Fservis_interval_mj write Fservis_interval_mj;
    property servis_interval_typ: Integer read Fservis_interval_typ write Fservis_interval_typ;
    property servis_interval_obdobi: Integer read Fservis_interval_obdobi write Fservis_interval_obdobi;
    property servis_interval_obdobi_typ: Integer read Fservis_interval_obdobi_typ write Fservis_interval_obdobi_typ;
    property servis_operation_id: Integer read Fservis_operation_id write Fservis_operation_id;
    property servis_note: string read Fservis_note write Fservis_note;
    property servis_interval_obdobi_odstavka: Integer read Fservis_interval_obdobi_odstavka write Fservis_interval_obdobi_odstavka;
    property servis_interval_obdobi_delka: Integer read Fservis_interval_obdobi_delka write Fservis_interval_obdobi_delka;
    property servis_upozorneni_dny: Integer read Fservis_upozorneni_dny write Fservis_upozorneni_dny;
    property servis_upozorneni_mail: boolean read Fservis_upozorneni_mail write Fservis_upozorneni_mail;
    property servis_pristi_date: TDateTime read Fservis_pristi_date write Fservis_pristi_date;
    property servis_upozorneni_mail_vyroba: Integer read Fservis_upozorneni_mail_vyroba write Fservis_upozorneni_mail_vyroba;
    property servis_upozorneni_mj: Integer read Fservis_upozorneni_mj write Fservis_upozorneni_mj;
    property servis_upozorneni_h: Integer read Fservis_upozorneni_h write Fservis_upozorneni_h;
    property poradi: Integer read Fporadi write Fporadi;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklady_materialu')]
  [Description('Sklady materialu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklady_materialu = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('name', [], 100)]
    [Description('')]
    Fname: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property name: Nullable<string> read Fname write Fname;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_formy')]
  [Description('Sklad forem')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_formy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('nakup', [TColumnProp.Required])]
    [Description('')]
    Fnakup: TDateTime;
    
    [Column('servis', [TColumnProp.Required])]
    [Description('')]
    Fservis: TDateTime;
    
    [Column('delay_servis_date', [TColumnProp.Required])]
    [Description('')]
    Fdelay_servis_date: TDateTime;
    
    [Column('delay_servis_time', [TColumnProp.Required])]
    [Description('')]
    Fdelay_servis_time: Integer;
    
    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('odpracovano', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano: Integer;
    
    [Column('cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena: Double;
    
    [Column('mnozstvi', [TColumnProp.Required])]
    [Description('')]
    Fmnozstvi: Integer;
    
    [Column('mnozstvi_init', [TColumnProp.Required])]
    [Description('')]
    Fmnozstvi_init: Integer;
    
    [Column('skupina', [TColumnProp.Required], 50)]
    [Description('')]
    Fskupina: string;
    
    [Column('objednano', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fobjednano: Double;
    
    [Column('pocatecnistav', [TColumnProp.Required])]
    [Description('')]
    Fpocatecnistav: Integer;
    
    [Column('vyrobni_c', [TColumnProp.Required], 50)]
    [Description('')]
    Fvyrobni_c: string;
    
    [Column('last_finish', [TColumnProp.Required])]
    [Description('')]
    Flast_finish: TDateTime;
    
    [Column('termin_zaruky', [TColumnProp.Required])]
    [Description('')]
    Ftermin_zaruky: TDateTime;

    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;
    
    [Column('dodavatel_id', [TColumnProp.Required])]
    [Description('')]
    Fdodavatel_id: Integer;
    
    [Column('mnozstvi_cyklus', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_cyklus: Double;
    
    [Column('material_cyklus', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmaterial_cyklus: Double;
    
    [Column('material_cyklus_unit', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_cyklus_unit: Integer;
    
    [Column('zbytky_cyklus', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fzbytky_cyklus: Double;
    
    [Column('zbytky_cyklus_unit', [TColumnProp.Required])]
    [Description('')]
    Fzbytky_cyklus_unit: Integer;
    
    [Column('pocet_cyklu', [TColumnProp.Required])]
    [Description('')]
    Fpocet_cyklu: Integer;
    
    [Column('pocet_cyklu_upozorneni', [TColumnProp.Required])]
    [Description('')]
    Fpocet_cyklu_upozorneni: Integer;
    
    [Column('userindex', [TColumnProp.Required], 50)]
    [Description('')]
    Fuserindex: string;
    
    [Column('customer', [TColumnProp.Required], 50)]
    [Description('')]
    Fcustomer: string;
    
    [Column('customer_id', [TColumnProp.Required])]
    [Description('')]
    Fcustomer_id: Integer;
    
    [Column('articleNumber', [TColumnProp.Required], 50)]
    [Description('')]
    FarticleNumber: string;
    
    [Column('hmotnost', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fhmotnost: Double;
    
    [Column('rating', [TColumnProp.Required], 50)]
    [Description('')]
    Frating: string;
    
    [Column('volitelna1', [TColumnProp.Required], 100)]
    [Description('')]
    Fvolitelna1: string;
    
    [Column('volitelna2', [TColumnProp.Required], 100)]
    [Description('')]
    Fvolitelna2: string;
    
    [Column('ciselna_volitelna1', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna1: Double;
    
    [Column('ciselna_volitelna2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna2: Double;
    
    [Column('ciselna_volitelna3', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna3: Double;
    
    [Column('ciselna_volitelna4', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna4: Double;
    
    [Column('ciselna_volitelna5', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna5: Double;
    
    [Column('ciselna_volitelna6', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fciselna_volitelna6: Double;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property nakup: TDateTime read Fnakup write Fnakup;
    property servis: TDateTime read Fservis write Fservis;
    property delay_servis_date: TDateTime read Fdelay_servis_date write Fdelay_servis_date;
    property delay_servis_time: Integer read Fdelay_servis_time write Fdelay_servis_time;
    property stav: Integer read Fstav write Fstav;
    property user: string read Fuser write Fuser;
    property odpracovano: Integer read Fodpracovano write Fodpracovano;
    property cena: Double read Fcena write Fcena;
    property mnozstvi: Integer read Fmnozstvi write Fmnozstvi;
    property mnozstvi_init: Integer read Fmnozstvi_init write Fmnozstvi_init;
    property skupina: string read Fskupina write Fskupina;
    property objednano: Double read Fobjednano write Fobjednano;
    property pocatecnistav: Integer read Fpocatecnistav write Fpocatecnistav;
    property vyrobni_c: string read Fvyrobni_c write Fvyrobni_c;
    property last_finish: TDateTime read Flast_finish write Flast_finish;
    property termin_zaruky: TDateTime read Ftermin_zaruky write Ftermin_zaruky;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property dodavatel_id: Integer read Fdodavatel_id write Fdodavatel_id;
    property mnozstvi_cyklus: Double read Fmnozstvi_cyklus write Fmnozstvi_cyklus;
    property material_cyklus: Double read Fmaterial_cyklus write Fmaterial_cyklus;
    property material_cyklus_unit: Integer read Fmaterial_cyklus_unit write Fmaterial_cyklus_unit;
    property zbytky_cyklus: Double read Fzbytky_cyklus write Fzbytky_cyklus;
    property zbytky_cyklus_unit: Integer read Fzbytky_cyklus_unit write Fzbytky_cyklus_unit;
    property pocet_cyklu: Integer read Fpocet_cyklu write Fpocet_cyklu;
    property pocet_cyklu_upozorneni: Integer read Fpocet_cyklu_upozorneni write Fpocet_cyklu_upozorneni;
    property userindex: string read Fuserindex write Fuserindex;
    property customer: string read Fcustomer write Fcustomer;
    property customer_id: Integer read Fcustomer_id write Fcustomer_id;
    property articleNumber: string read FarticleNumber write FarticleNumber;
    property hmotnost: Double read Fhmotnost write Fhmotnost;
    property rating: string read Frating write Frating;
    property volitelna1: string read Fvolitelna1 write Fvolitelna1;
    property volitelna2: string read Fvolitelna2 write Fvolitelna2;
    property ciselna_volitelna1: Double read Fciselna_volitelna1 write Fciselna_volitelna1;
    property ciselna_volitelna2: Double read Fciselna_volitelna2 write Fciselna_volitelna2;
    property ciselna_volitelna3: Double read Fciselna_volitelna3 write Fciselna_volitelna3;
    property ciselna_volitelna4: Double read Fciselna_volitelna4 write Fciselna_volitelna4;
    property ciselna_volitelna5: Double read Fciselna_volitelna5 write Fciselna_volitelna5;
    property ciselna_volitelna6: Double read Fciselna_volitelna6 write Fciselna_volitelna6;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_formy_pohyb')]
  [Description('Typy pohyby naradi z a do skladu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_formy_pohyb = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('typ_pohybu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_pohybu: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property typ_pohybu: Integer read Ftyp_pohybu write Ftyp_pohybu;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_formy_readdata')]
  [Description('Nactena data skladu forem')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_formy_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('forma_id', [TColumnProp.Required])]
    [Description('')]
    Fforma_id: Integer;
    
    [Column('pohyb_id', [TColumnProp.Required])]
    [Description('')]
    Fpohyb_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('calculated', [TColumnProp.Required])]
    [Description('')]
    Fcalculated: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('count', [TColumnProp.Required])]
    [Description('')]
    Fcount: Integer;
    
    [Column('stav_skladu', [TColumnProp.Required])]
    [Description('')]
    Fstav_skladu: Integer;
    
    [Column('isActual', [TColumnProp.Required])]
    [Description('')]
    FisActual: Integer;
    
    [Column('polozka_objednavky_id', [TColumnProp.Required])]
    [Description('')]
    Fpolozka_objednavky_id: Integer;

    [Column('castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka: Double;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property forma_id: Integer read Fforma_id write Fforma_id;
    property pohyb_id: Integer read Fpohyb_id write Fpohyb_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property note: string read Fnote write Fnote;
    property calculated: Integer read Fcalculated write Fcalculated;
    property user: string read Fuser write Fuser;
    property count: Integer read Fcount write Fcount;
    property stav_skladu: Integer read Fstav_skladu write Fstav_skladu;
    property isActual: Integer read FisActual write FisActual;
    property polozka_objednavky_id: Integer read Fpolozka_objednavky_id write Fpolozka_objednavky_id;
    property castka: Double read Fcastka write Fcastka;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_inventura')]
  [Description('Tabulka skladovch inventur')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_inventura = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('datum_inventura', [TColumnProp.Required])]
    [Description('')]
    Fdatum_inventura: TDateTime;
    
    [Column('datum_evidenci_stav', [TColumnProp.Required])]
    [Description('')]
    Fdatum_evidenci_stav: TDateTime;
    
    [Column('datum_uzavreni', [TColumnProp.Required])]
    [Description('')]
    Fdatum_uzavreni: TDateTime;
    
    [Column('poznamka', [TColumnProp.Required], 250)]
    [Description('')]
    Fpoznamka: string;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('stav', [], 'id')]
    [Description('')]
    Fstav: proxy<Tstavydokladu>;

    [Column('typ_sklad_filter', [TColumnProp.Required])]
    [Description('')]
    Ftyp_sklad_filter: Integer;
    
    [Column('sklad_filter_list', [TColumnProp.Required], 200)]
    [Description('')]
    Fsklad_filter_list: string;
    
    [Column('id_typ_inventura', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_inventura: Integer;
    
    [Column('id_prijemka', [TColumnProp.Required])]
    [Description('')]
    Fid_prijemka: Integer;
    
    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('id_typ_prijemka', [TColumnProp.Required], 'id')]
    [Description('')]
    Fid_typ_prijemka: proxy<Tsklad_material_prijemky_typy>;

    [Column('id_vydejka', [TColumnProp.Required])]
    [Description('')]
    Fid_vydejka: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('id_typ_vydejka', [TColumnProp.Required], 'id')]
    [Description('')]
    Fid_typ_vydejka: proxy<Tsklad_material_vydejky_typy>;

    [Column('nazev', [TColumnProp.Required], 200)]
    [Description('')]
    Fnazev: string;

    [Column('skupina_filter_list', [TColumnProp.Required], 300)]
    [Description('')]
    Fskupina_filter_list: string;

    [Column('inventura_doklad', [TColumnProp.Required], 100)]
    [Description('')]
    Finventura_doklad: string;
    
    [Column('inventura_nazev', [TColumnProp.Required], 200)]
    [Description('')]
    Finventura_nazev: string;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;

    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('cvicna', [TColumnProp.Required])]
    [Description('')]
    Fcvicna: Boolean;
    
    [Column('vytvoril_user_id', [TColumnProp.Required])]
    [Description('')]
    Fvytvoril_user_id: Integer;
    
    [Column('uzavrel_user_id', [TColumnProp.Required])]
    [Description('')]
    Fuzavrel_user_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('id_prijemka2', [TColumnProp.Required])]
    [Description('')]
    Fid_prijemka2: Integer;

    [Column('id_vydejka2', [TColumnProp.Required])]
    [Description('')]
    Fid_vydejka2: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;
    FDynCon: TDynamicProperties;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fid_inventura')]
    Fsklad_inventura_soupisyList: Proxy<TList<Tsklad_inventura_soupisy>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fid_inventura')]
    Fsklad_inventura_polozkyList: Proxy<TList<Tsklad_inventura_polozky>>;

    function Getsklad_inventura_soupisyList: TList<Tsklad_inventura_soupisy>;
    function Getsklad_inventura_polozkyList: TList<Tsklad_inventura_polozky>;
    function getstav: Tstavydokladu;
    procedure setstav(const Value : Tstavydokladu);
    function getid_typ_prijemka:  Tsklad_material_prijemky_typy;
    procedure setid_typ_prijemka(const Value : Tsklad_material_prijemky_typy);
    function getid_typ_vydejka:  Tsklad_material_vydejky_typy;
    procedure setid_typ_vydejka(const Value :  Tsklad_material_vydejky_typy);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    class procedure checkNewRecord; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property datum_inventura: TDateTime read Fdatum_inventura write Fdatum_inventura;
    property datum_evidenci_stav: TDateTime read Fdatum_evidenci_stav write Fdatum_evidenci_stav;
    property datum_uzavreni: TDateTime read Fdatum_uzavreni write Fdatum_uzavreni;
    property poznamka: string read Fpoznamka write Fpoznamka;
    property stav: Tstavydokladu read getstav write setstav;
    property typ_sklad_filter: Integer read Ftyp_sklad_filter write Ftyp_sklad_filter;
    property sklad_filter_list: string read Fsklad_filter_list write Fsklad_filter_list;
    property id_typ_inventura: Integer read Fid_typ_inventura write Fid_typ_inventura;
    property id_prijemka: Integer read Fid_prijemka write Fid_prijemka;
    property id_typ_prijemka: Tsklad_material_prijemky_typy read getid_typ_prijemka write setid_typ_prijemka;
    property id_vydejka: Integer read Fid_vydejka write Fid_vydejka;
    property id_typ_vydejka: Tsklad_material_vydejky_typy read getid_typ_vydejka write setid_typ_vydejka;
    property nazev: string read Fnazev write Fnazev;
    property skupina_filter_list: string read Fskupina_filter_list write Fskupina_filter_list;
    property inventura_doklad: string read Finventura_doklad write Finventura_doklad;
    property inventura_nazev: string read Finventura_nazev write Finventura_nazev;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property cvicna: Boolean read Fcvicna write Fcvicna;
    property vytvoril_user_id: Integer read Fvytvoril_user_id write Fvytvoril_user_id;
    property uzavrel_user_id: Integer read Fuzavrel_user_id write Fuzavrel_user_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property id_prijemka2: Integer read Fid_prijemka2 write Fid_prijemka2;
    property id_vydejka2: Integer read Fid_vydejka2 write Fid_vydejka2;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property sklad_inventura_soupisyList: TList<Tsklad_inventura_soupisy> read Getsklad_inventura_soupisyList;
    property sklad_inventura_polozkyList: TList<Tsklad_inventura_polozky> read Getsklad_inventura_polozkyList;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_inventura_log')]
  [Description('Tabulka logovn zmn skladovch inventur')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_inventura_log = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('inventura_id', [TColumnProp.Required])]
    [Description('')]
    Finventura_id: Integer;
    
    [Column('Popis', [TColumnProp.Required], 200)]
    [Description('')]
    FPopis: string;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('kdy', [TColumnProp.Required])]
    [Description('')]
    Fkdy: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property inventura_id: Integer read Finventura_id write Finventura_id;
    property Popis: string read FPopis write FPopis;
    property user_id: Integer read Fuser_id write Fuser_id;
    property kdy: TDateTime read Fkdy write Fkdy;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_inventura_polozky')]
  [Description('Tabulka kolov mzdy')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_inventura_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('id_inventura', [], 'id')]
    [Description('')]
    Fid_inventura: proxy<Tsklad_inventura>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_id', [], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;


    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('pozice_id', [], 'id')]
    [Description('')]
    Fpozice_id: proxy<Tsklad_material_pozice>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: nullable<TDateTime>;
    FDynCon: TDynamicProperties;
    function getid_inventura: Tsklad_inventura;
    procedure setid_inventura(const Value : Tsklad_inventura);
    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getpozice_id: Tsklad_material_pozice;
    procedure setpozice_id(const Value : Tsklad_material_pozice);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property id_inventura: Tsklad_inventura read getid_inventura write setid_inventura;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property pozice_id: Tsklad_material_pozice read getpozice_id write setpozice_id;
    property ts_created: nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_inventura_soupisy')]
  [Description('Tabulka kolov mzdy')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_inventura_soupisy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('id_inventura', [], 'id')]
    [Description('')]
    Fid_inventura: proxy<Tsklad_inventura>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_id', [], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;
    
    [Column('cenaMJ', [TColumnProp.Required], 15, 3)]
    [Description('')]
    FcenaMJ: Double;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;

    [Column('mnozstvi_skutecnost', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_skutecnost: Double;
    
    [Column('neplatna', [TColumnProp.Required])]
    [Description('')]
    Fneplatna: Integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created:  Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
    function getid_inventura: Tsklad_inventura;
    procedure setid_inventura(const Value : Tsklad_inventura);
    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property id_inventura: Tsklad_inventura read getid_inventura write setid_inventura;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property cenaMJ: Double read FcenaMJ write FcenaMJ;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property mnozstvi_skutecnost: Double read Fmnozstvi_skutecnost write Fmnozstvi_skutecnost;
    property neplatna: Integer read Fneplatna write Fneplatna;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_inventura_typ')]
  [Description('stavy inventur')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_inventura_typ = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_material')]
  [Description('Sklad materilu')]
  [UniqueKey('bar_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('count', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcount: Double;
    
    [Column('price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fprice: Double;

    [Column('note', [], 1024)]
    [Description('')]
    Fnote: Nullable<string>;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('limit_count', [TColumnProp.Required],15,4)]
    [Description('')]
    Flimit_count: double;

    [Column('id_pohoda', [TColumnProp.Required], 100)]
    [Description('')]
    Fid_pohoda: string;
    
    [Column('sell_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fsell_price: Double;

    [Column('typ_mat', [TColumnProp.Required])]
    [Description('')]
    Ftyp_mat: Integer;
    
    [Column('blokovano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fblokovano: Double;
    
    [Column('planovano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fplanovano: Double;
    
    [Column('objednano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fobjednano: Double;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_from_id', [], 'id')]
    [Description('')]
    Fmaterial_from_id: proxy<Tmaterialy>;

    [Column('avg_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Favg_price: Double;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('second_unit', [], 'id_correct')]
    [Description('')]
    Fsecond_unit: proxy<Tjednotky>;

    [Column('marze', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmarze: Double;

    [Column('ean', [TColumnProp.Required], 50)]
    [Description('')]
    Fean: string;

    [Column('vykres', [TColumnProp.Required], 200)]
    [Description('')]
    Fvykres: string;

    [Column('umisteni1', [TColumnProp.Required], 100)]
    [Description('')]
    Fumisteni1: string;

    [Column('text1', [TColumnProp.Required], 100)]
    [Description('')]
    Ftext1: string;

    [Column('text2', [TColumnProp.Required], 100)]
    [Description('')]
    Ftext2: string;

    [Column('dil_na', [], 500)]
    [Description('')]
    Fdil_na: Nullable<string>;

    [Column('rozmer1', [], 15, 3)]
    [Description('')]
    Frozmer1: Nullable<Double>;

    [Column('rozmer2', [], 15, 3)]
    [Description('')]
    Frozmer2: Nullable<Double>;

    [Column('delka', [], 15, 3)]
    [Description('')]
    Fdelka: Nullable<Double>;

    [Column('vazena_cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fvazena_cena: Double;
    
    [Column('hodnota_vazena_cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fhodnota_vazena_cena: Double;
    
    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;
    
    [Column('coef_unit21', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcoef_unit21: Double;
    
    [Column('rozmer3', [], 15, 3)]
    [Description('')]
    Frozmer3: Nullable<Double>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('tvar_id', [], 'id')]
    [Description('')]
    FTvar_id: proxy<Tsklad_material_tvar>;

    [Column('id_moneyAgenda', [TColumnProp.Required])]
    [Description('')]
    Fid_moneyAgenda: Integer;

    [Column('zbytky_material_id', [TColumnProp.Required])]
    [Description('')]
    Fzbytky_material_id: Integer;

    [Column('zbytky_koeficient', [], 15, 4)]
    [Description('')]
    Fzbytky_koeficient: Nullable<Double>;

    [Column('hmotnost', [], 15, 3)]
    [Description('')]
    Fhmotnost: Nullable<Double>;
    
    [Column('skryta', [TColumnProp.Required])]
    [Description('')]
    Fskryta: Integer;
    
    [Column('coef_unit22', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcoef_unit22: Double;

    [Column('coef_unit23', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcoef_unit23: Double;
    
    [Column('limit_max_count', [TColumnProp.Required], 15,4)]
    [Description('')]
    Flimit_max_count: Double;
    
    [Column('kod_objednaci', [TColumnProp.Required], 100)]
    [Description('')]
    Fkod_objednaci: string;
    
    [Column('text_objednaci', [TColumnProp.Required], 100)]
    [Description('')]
    Ftext_objednaci: string;

    [Column('dodaci_doba', [TColumnProp.Required], 15, 0)]
    [Description('')]
    Fdodaci_doba: Double;

    [Column('objednanoprijate', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fobjednanoprijate: Double;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('balici_mnozstvi', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fbalici_mnozstvi: Double;


    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('min_order_production_count', [TColumnProp.Required],15,4)]
    [Description('')]
    Fmin_order_production_count: Double;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('sklad_id', [], 'id')]
    [Description('')]
    Fsklad_id: proxy<Tsklad_skupiny>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<Tjednotky>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('dodavatel_id', [], 'id')]
    [Description('')]
    Fdodavatel_id: proxy<Tcustomer>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('Ciselna_rada_id', [TColumnProp.Required], 'id')]
    [Description('')]
    FCiselna_rada_id: proxy<Tciselne_rady>;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fmaterial_id')]
    Fobjednavky_polozkyList: Proxy<TList<Tobjednavky_polozky>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fmaterial_id')]
    Fsklad_material_EANList : Proxy<TList<Tsklad_material_ean>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fmaterial_id')]
    Fsklad_material_AltDodavateleList : Proxy<TList<Tsklad_material_dodavatele>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fmaterial_id')]
    Fsklad_material_docList: Proxy<TList<Tsklad_material_doc>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fmaterial_id')]
    Fsklad_material_CoefUnitList : Proxy<TList<Tsklad_material_coef_unit>>;

    function getSklad_id: Tsklad_skupiny;
    procedure setSklad_id(const Value : Tsklad_skupiny);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getDodavatel_id: Tcustomer;
    procedure setDodavatel_id(const Value : Tcustomer);
    function getTvar_id: TSklad_material_tvar;
    procedure setTvar_id(const Value : TSklad_material_tvar);
    function getMaterial_from_id: Tmaterialy;
    procedure setMaterial_from_id(const Value : Tmaterialy);
    function Getobjednavky_polozkyList: TList<Tobjednavky_polozky>;
    function Getsklad_material_EANList: TList<Tsklad_material_EAN>;
    function Getsklad_material_AltDodavateleList: TList<Tsklad_material_dodavatele>;
    function Getsklad_material_docList: TList<Tsklad_material_doc>;
    function Getsklad_material_CoefUnitList: TList<Tsklad_material_coef_unit>;
    function getunit_: Tjednotky;
    procedure setunit_(const Value : Tjednotky);
    function getSecond_unit: Tjednotky;
    procedure setSecond_unit (const Value : Tjednotky);
    procedure setprice (const Value : double);
    procedure setmarze (const Value : double);
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    Function CheckRecord(var aMessage : String) : Boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function GetCoef_unit(aUnit : TJednotky) : Double;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    property id: Int64 read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property count: Double read Fcount write Fcount;
    property price: Double read Fprice write setprice;
    property note: Nullable<string> read Fnote write Fnote;
    property user: string read Fuser write Fuser;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property limit_count: double read Flimit_count write Flimit_count;
    property id_pohoda: string read Fid_pohoda write Fid_pohoda;
    property sell_price: Double read Fsell_price write Fsell_price;
    property typ_mat: Integer read Ftyp_mat write Ftyp_mat;
    property sklad_id: Tsklad_skupiny read getSklad_id write setSklad_id;
    property blokovano: Double read Fblokovano write Fblokovano;
    property planovano: Double read Fplanovano write Fplanovano;
    property objednano: Double read Fobjednano write Fobjednano;
    property material_from_id: TMaterialy read getMaterial_from_id write setMaterial_from_id;
    property avg_price: Double read Favg_price write Favg_price;
    property marze: Double read Fmarze write setmarze;
    property ean: string read Fean write Fean;
    property vykres: string read Fvykres write Fvykres;
    property umisteni1: string read Fumisteni1 write Fumisteni1;
    property text1: string read Ftext1 write Ftext1;
    property text2: string read Ftext2 write Ftext2;
    property dil_na: Nullable<string> read Fdil_na write Fdil_na;
    property rozmer1: Nullable<Double> read Frozmer1 write Frozmer1;
    property rozmer2: Nullable<Double> read Frozmer2 write Frozmer2;
    property delka: Nullable<Double> read Fdelka write Fdelka;
    property vazena_cena: Double read Fvazena_cena write Fvazena_cena;
    property hodnota_vazena_cena: Double read Fhodnota_vazena_cena write Fhodnota_vazena_cena;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property coef_unit21: Double read Fcoef_unit21 write Fcoef_unit21;
    property dodavatel_id: Tcustomer read getdodavatel_id write setdodavatel_id;
    property rozmer3: Nullable<Double> read Frozmer3 write Frozmer3;
    property tvar_id: TSklad_material_tvar read gettvar_id write settvar_id;
    property id_moneyAgenda: Integer read Fid_moneyAgenda write Fid_moneyAgenda;
    property zbytky_material_id: Integer read Fzbytky_material_id write Fzbytky_material_id;
    property zbytky_koeficient: Nullable<Double> read Fzbytky_koeficient write Fzbytky_koeficient;
    property hmotnost: Nullable<Double> read Fhmotnost write Fhmotnost;
    property skryta: Integer read Fskryta write Fskryta;
    property coef_unit22: Double read Fcoef_unit22 write Fcoef_unit22;
    property coef_unit23: Double read Fcoef_unit23 write Fcoef_unit23;
    property limit_max_count: Double read Flimit_max_count write Flimit_max_count;
    property kod_objednaci: string read Fkod_objednaci write Fkod_objednaci;
    property text_objednaci: string read Ftext_objednaci write Ftext_objednaci;
    property dodaci_doba: Double read Fdodaci_doba write Fdodaci_doba;
    property objednanoprijate: Double read Fobjednanoprijate write Fobjednanoprijate;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property balici_mnozstvi: Double read Fbalici_mnozstvi write Fbalici_mnozstvi;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property unit_: Tjednotky read getunit_ write setunit_;
    property second_unit: Tjednotky read getSecond_unit write setSecond_unit;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property objednavky_polozkyList: TList<Tobjednavky_polozky> read Getobjednavky_polozkyList;
    property sklad_material_EANList : TList<Tsklad_material_ean> read Getsklad_material_EANList;
    property sklad_material_AltDodavateleList : TList<Tsklad_material_dodavatele> read Getsklad_material_AltDodavateleList;
    property sklad_material_CoefUnitList : TList<Tsklad_material_coef_unit> read Getsklad_material_CoefUnitList;
    property min_order_production_count: double read Fmin_order_production_count write Fmin_order_production_count;
    property sklad_material_docList: TList<Tsklad_material_doc> read Getsklad_material_docList;
    property has_docs: Integer read Fhas_docs write Fhas_docs;

  end;

  [Entity]
  [Table('sklad_material_ceniky')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_ceniky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('typ_ceniku_id', [TColumnProp.Required])]
    [Description('')]
    Ftyp_ceniku_id: Integer;

    [Column('customer_id', [])]
    [Description('')]
    Fcustomer_id: Nullable<Int64>;
    
    [Column('name', [TColumnProp.Required], 255)]
    [Description('')]
    Fname: string;
    
    [Column('platnost_od', [])]
    [Description('')]
    Fplatnost_od: Nullable<TDateTime>;
    
    [Column('platnost_do', [])]
    [Description('')]
    Fplatnost_do: Nullable<TDateTime>;
    
    [Column('mena', [TColumnProp.Required], 50)]
    [Description('')]
    Fmena: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property typ_ceniku_id: Integer read Ftyp_ceniku_id write Ftyp_ceniku_id;
    property customer_id: Nullable<Int64> read Fcustomer_id write Fcustomer_id;
    property name: string read Fname write Fname;
    property platnost_od: Nullable<TDateTime> read Fplatnost_od write Fplatnost_od;
    property platnost_do: Nullable<TDateTime> read Fplatnost_do write Fplatnost_do;
    property mena: string read Fmena write Fmena;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_material_ceniky_polozky')]
  [Description('')]
  [UniqueKey('cenik_id, material_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_ceniky_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('cenik_id', [TColumnProp.Required])]
    [Description('')]
    Fcenik_id: Int64;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('sell_price', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fsell_price: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property cenik_id: Int64 read Fcenik_id write Fcenik_id;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property sell_price: Double read Fsell_price write Fsell_price;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_material_doc')]
  [Description('Tabulka dokument skladovch karet')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('material_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fmaterial_id: proxy<TSklad_material>;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;
    
    [Column('isFile', [TColumnProp.Required])]
    [Description('')]
    FisFile: boolean;
    
    [Column('zobrazitNahled', [TColumnProp.Required])]
    [Description('')]
    FzobrazitNahled: Integer;
    
    [Column('external_list_type', [TColumnProp.Required], 10)]
    [Description('')]
    Fexternal_list_type: string;
    
    [Column('external_list_id_record', [TColumnProp.Required])]
    [Description('')]
    Fexternal_list_id_record: Integer;

    [Column('defaultDocument', [TColumnProp.Required])]
    [Description('')]
    FdefaultDocument: boolean;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;

    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getextensionType : integer;
    function getdoctype : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Integer read Fid write Fid;
    property material_id: TSklad_material read getmaterial_id write setmaterial_id;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isFile: boolean read FisFile write FisFile;
    property zobrazitNahled: Integer read FzobrazitNahled write FzobrazitNahled;
    property external_list_type: string read Fexternal_list_type write Fexternal_list_type;
    property external_list_id_record: Integer read Fexternal_list_id_record write Fexternal_list_id_record;
    property defaultDocument: boolean read FdefaultDocument write FdefaultDocument;
    property user: Nullable<string> read Fuser write Fuser;
    property userCreated: Nullable<string>read FuserCreated write FuserCreated;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_material_dodavatele')]
  [Description('sklad_material_dodavatele')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_dodavatele = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('dodavatel_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fdodavatel_id: proxy<TCustomer>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('material_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [Column('cena', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena: Double;

    [Column('kod_objednaci', [TColumnProp.Required], 100)]
    [Description('')]
    Fkod_objednaci: string;
    
    [Column('text_objednaci', [TColumnProp.Required], 100)]
    [Description('')]
    Ftext_objednaci: string;
    
    [Column('poznamka', [TColumnProp.Required], 500)]
    [Description('')]
    Fpoznamka: string;
    
    [Column('cena1', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena1: Double;

    [Column('limit_mnozstvi1', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Flimit_mnozstvi1: Double;
    
    [Column('cena2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena2: Double;
    
    [Column('limit_mnozstvi2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Flimit_mnozstvi2: Double;
    
    [Column('kod_carovy', [TColumnProp.Required], 100)]
    [Description('')]
    Fkod_carovy: string;
    FDynCon: TDynamicProperties;

    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getdodavatel_id: TCustomer;
    procedure setdodavatel_id(const Value : TCustomer);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property dodavatel_id: TCustomer read getdodavatel_id write setdodavatel_id;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property cena: Double read Fcena write Fcena;
    property kod_objednaci: string read Fkod_objednaci write Fkod_objednaci;
    property text_objednaci: string read Ftext_objednaci write Ftext_objednaci;
    property poznamka: string read Fpoznamka write Fpoznamka;
    property cena1: Double read Fcena1 write Fcena1;
    property limit_mnozstvi1: Double read Flimit_mnozstvi1 write Flimit_mnozstvi1;
    property cena2: Double read Fcena2 write Fcena2;
    property limit_mnozstvi2: Double read Flimit_mnozstvi2 write Flimit_mnozstvi2;
    property kod_carovy: string read Fkod_carovy write Fkod_carovy;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_material_ean')]
  [Description('Sklad materilu seznam rovch kd')]
  [UniqueKey('material_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_ean = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('ean_code', [TColumnProp.Required], 255)]
    [Description('')]
    Fean_code: string;

    [Column('type', [TColumnProp.Required])]
    [Description('')]
    Ftype_: Integer;

    [Column('unit_count', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Funit_count: Double;

    [Column('unit', [])]
    [Description('')]
    Funit_: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('material_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    FDynCon: TDynamicProperties;
    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property ean_code: string read Fean_code write Fean_code;
    property type_: Integer read Ftype_ write Ftype_;
    property unit_count: Double read Funit_count write Funit_count;
    property unit_: Integer read Funit_ write Funit_;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_material_pohyb')]
  [Description('Typy pohybu materialu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_pohyb = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('aktivni', [TColumnProp.Required])]
    [Description('')]
    Faktivni: Boolean;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [Column('do_skladu_id', [TColumnProp.Required])]
    [Description('')]
    Fdo_skladu_id: integer;
    
    [Column('ze_skladu_id', [TColumnProp.Required])]
    [Description('')]
    Fze_skladu_id: integer;

    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Boolean;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property bar_id: string read Fbar_id write Fbar_id;
    property aktivni: Boolean read Faktivni write Faktivni;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property do_skladu_id: integer read Fdo_skladu_id write Fdo_skladu_id;
    property ze_skladu_id: integer read Fze_skladu_id write Fze_skladu_id;
    property vychozi: Boolean read fVychozi write fVychozi;
  end;
  
  [Entity]
  [Table('sklad_material_pozice')]
  [Description('Skladov pozice')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_pozice = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('pozice_bar_id', [TColumnProp.Required], 10)]
    [Description('')]
    Fpozice_bar_id: string;
    
    [Column('full', [TColumnProp.Required])]
    [Description('')]
    Ffull: Integer;
    
    [Column('sklad_id', [TColumnProp.Required])]
    [Description('')]
    Fsklad_id: Integer;
    
    [Column('parent_id', [TColumnProp.Required])]
    [Description('')]
    Fparent_id: Integer;
    
    [Column('note', [TColumnProp.Required], 255)]
    [Description('')]
    Fnote: string;
    
    [Column('datum_prijem', [TColumnProp.Required])]
    [Description('')]
    Fdatum_prijem: TDateTime;
    
    [Column('datum_vydej', [TColumnProp.Required])]
    [Description('')]
    Fdatum_vydej: TDateTime;
    
    [Column('pozice_n1', [TColumnProp.Required])]
    [Description('')]
    Fpozice_n1: Integer;
    
    [Column('pozice_n2', [TColumnProp.Required])]
    [Description('')]
    Fpozice_n2: Integer;
    
    [Column('pozice_n3', [TColumnProp.Required])]
    [Description('')]
    Fpozice_n3: Integer;
    
    [Column('pozice_n4', [TColumnProp.Required])]
    [Description('')]
    Fpozice_n4: Integer;
    
    [Column('prefix_pozice', [TColumnProp.Required], 1)]
    [Description('')]
    Fprefix_pozice: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property pozice_bar_id: string read Fpozice_bar_id write Fpozice_bar_id;
    property full: Integer read Ffull write Ffull;
    property sklad_id: Integer read Fsklad_id write Fsklad_id;
    property parent_id: Integer read Fparent_id write Fparent_id;
    property note: string read Fnote write Fnote;
    property datum_prijem: TDateTime read Fdatum_prijem write Fdatum_prijem;
    property datum_vydej: TDateTime read Fdatum_vydej write Fdatum_vydej;
    property pozice_n1: Integer read Fpozice_n1 write Fpozice_n1;
    property pozice_n2: Integer read Fpozice_n2 write Fpozice_n2;
    property pozice_n3: Integer read Fpozice_n3 write Fpozice_n3;
    property pozice_n4: Integer read Fpozice_n4 write Fpozice_n4;
    property prefix_pozice: string read Fprefix_pozice write Fprefix_pozice;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_material_pozice_readdata')]
  [Description('Skladov pozice naten data')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_pozice_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: Integer;
    
    [Column('pozice_id', [TColumnProp.Required])]
    [Description('')]
    Fpozice_id: Integer;
    
    [Column('pozice_id_sub', [TColumnProp.Required])]
    [Description('')]
    Fpozice_id_sub: Integer;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;

    [Column('vaha', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvaha: Double;
    
    [Column('sklad_readdata_id', [TColumnProp.Required])]
    [Description('')]
    Fsklad_readdata_id: Int64;
    
    [Column('pohyb_datetime', [TColumnProp.Required])]
    [Description('')]
    Fpohyb_datetime: TDateTime;
    
    [Column('pohyb_datetime_out', [TColumnProp.Required])]
    [Description('')]
    Fpohyb_datetime_out: TDateTime;
    
    [Column('pohyb', [], 15, 3)]
    [Description('')]
    Fpohyb: Nullable<Double>;
    
    [Column('pohyb_typ', [], 50)]
    [Description('')]
    Fpohyb_typ: Nullable<string>;
    
    [Column('note', [], 255)]
    [Description('')]
    Fnote: Nullable<string>;
    
    [Column('user_id_in', [TColumnProp.Required])]
    [Description('')]
    Fuser_id_in: Integer;
    
    [Column('user_id_out', [TColumnProp.Required])]
    [Description('')]
    Fuser_id_out: Integer;
    
    [Column('paleta_id', [TColumnProp.Required])]
    [Description('')]
    Fpaleta_id: Integer;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('request_id', [TColumnProp.Required])]
    [Description('')]
    Frequest_id: Integer;
    
    [Column('sarze', [TColumnProp.Required], 255)]
    [Description('')]
    Fsarze: string;
    
    [Column('pohyb_group_id', [TColumnProp.Required])]
    [Description('')]
    Fpohyb_group_id: Integer;
    
    [Column('printed', [TColumnProp.Required])]
    [Description('')]
    Fprinted: Integer;
    
    [Column('printed_datetime', [TColumnProp.Required])]
    [Description('')]
    Fprinted_datetime: TDateTime;
    
    [Column('exported', [TColumnProp.Required])]
    [Description('')]
    Fexported: Integer;
    
    [Column('exported_datetime', [TColumnProp.Required])]
    [Description('')]
    Fexported_datetime: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property active: Integer read Factive write Factive;
    property pozice_id: Integer read Fpozice_id write Fpozice_id;
    property pozice_id_sub: Integer read Fpozice_id_sub write Fpozice_id_sub;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property vaha: Double read Fvaha write Fvaha;
    property sklad_readdata_id: Int64 read Fsklad_readdata_id write Fsklad_readdata_id;
    property pohyb_datetime: TDateTime read Fpohyb_datetime write Fpohyb_datetime;
    property pohyb_datetime_out: TDateTime read Fpohyb_datetime_out write Fpohyb_datetime_out;
    property pohyb: Nullable<Double> read Fpohyb write Fpohyb;
    property pohyb_typ: Nullable<string> read Fpohyb_typ write Fpohyb_typ;
    property note: Nullable<string> read Fnote write Fnote;
    property user_id_in: Integer read Fuser_id_in write Fuser_id_in;
    property user_id_out: Integer read Fuser_id_out write Fuser_id_out;
    property paleta_id: Integer read Fpaleta_id write Fpaleta_id;
    property order_id: string read Forder_id write Forder_id;
    property request_id: Integer read Frequest_id write Frequest_id;
    property sarze: string read Fsarze write Fsarze;
    property pohyb_group_id: Integer read Fpohyb_group_id write Fpohyb_group_id;
    property printed: Integer read Fprinted write Fprinted;
    property printed_datetime: TDateTime read Fprinted_datetime write Fprinted_datetime;
    property exported: Integer read Fexported write Fexported;
    property exported_datetime: TDateTime read Fexported_datetime write Fexported_datetime;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_material_prijemky')]
  [Description('SKLAD_MATERIAL_PRIJEMKY')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_prijemky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoklad: string;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;

//    [Column('castka', [TColumnProp.Required], 15, 2)]
//    [Description('')]
//    Fcastka: Double;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_celkem: Double;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('oznaceni', [TColumnProp.Required], 50)]
    [Description('')]
    Foznaceni: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('path2', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath2: string;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('rozpustene_naklady', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Frozpustene_naklady: Double;

    [Column('prijaty_doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fprijaty_doklad: string;

    [Association([], CascadeTypeNone)] // TAssociationProp.Lazy
    [JoinColumn('order_id', [], 'bar_id')]
    [Description('')]
//    Forder_id: proxy<Tc_order>;
    Forder_id: Tc_order;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('customer_id', [], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;

    [Column('dodaciListPrijaty', [TColumnProp.Required], 50)]
    [Description('')]
    FdodaciListPrijaty: string;

    [Column('fakturaPrijata', [TColumnProp.Required], 50)]
    [Description('')]
    FfakturaPrijata: string;

    [Column('fakturaPrijataDatum', [])]
    [Description('')]
    FfakturaPrijataDatum: Nullable<TDateTime>;

    [Column('customer_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fcustomer_name: string;

    [Column('customer_ico', [TColumnProp.Required], 20)]
    [Description('')]
    Fcustomer_ico: string;

    [Column('export_poradi', [TColumnProp.Required])]
    [Description('')]
    Fexport_poradi: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('pohyb_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fpohyb_id: proxy<Tsklad_material_pohyb>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('typ', [TColumnProp.Required], 'id')]
    [Description('')]
    Ftyp: proxy<Tsklad_material_prijemky_typy>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('stavdokladu', [], 'id')]
    [Description('')]
    Fstavdokladu: proxy<Tstavydokladu>;

    [Column('exported', [TColumnProp.Required])]
    [Description('')]
    Fexported: Boolean;

    [Column('exportedDatetime', [])]
    [Description('')]
    FexportedDatetime: Nullable<TDateTime>;

//    [Column('cm_castka', [TColumnProp.Required], 15, 3)]
//    [Description('')]
//    Fcm_castka: Double;
//
    [Column('cm_cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcm_cena_celkem: Double;

    [Column('cm_kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_kurz: Double;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cm_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Column('usercreated', [TColumnProp.Required], 50)]
    [Description('')]
    Fusercreated: string;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('Ciselna_rada_id', [TColumnProp.Required], 'id')]
    [Description('')]
    FCiselna_rada_id: proxy<Tciselne_rady>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fprijem_id')]
    Fsklad_material_prijemky_docList: Proxy<TList<Tsklad_material_prijemky_doc>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fprijem_id')]
    Fsklad_material_readdataList: Proxy<TList<Tsklad_material_readdata>>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('hlavni_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fhlavni_mena: proxy<Tkurz_meny>;

    function Getsklad_material_prijemky_docList: TList<Tsklad_material_prijemky_doc>;
    function Getsklad_material_readdataList: TList<Tsklad_material_readdata>;
    function getorder_id: Tc_order;
    procedure setorder_id(const Value : Tc_order);
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
    function getpohyb_id: Tsklad_material_pohyb;
    procedure setpohyb_id(const Value : Tsklad_material_pohyb);
    function gettyp: Tsklad_material_prijemky_typy;
    procedure settyp(const Value : Tsklad_material_prijemky_typy);
    function getstavdokladu: Tstavydokladu;
    procedure setstavdokladu(const Value : Tstavydokladu);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function getCiselna_rada_id: Tciselne_rady;
    procedure setCiselna_rada_id(const Value : Tciselne_rady);
    function gethlavni_mena: Tkurz_meny;
    procedure sethlavni_mena(const Value : Tkurz_meny);
    procedure setcm_kurz(const Value: Double);
    procedure setdate(const Value: TDateTime);
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure checkNewRecord; override;
    function CheckRequiredFields : boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    property id: Int64 read Fid write Fid;
    property doklad: string read Fdoklad write Fdoklad;
    property name: string read Fname write Fname;
    property date: TDateTime read Fdate write setdate;
//    property castka: Double read Fcastka write Fcastka;
    property note: string read Fnote write Fnote;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property user: string read Fuser write Fuser;
    property oznaceni: string read Foznaceni write Foznaceni;
    property path: string read Fpath write Fpath;
    property path2: string read Fpath2 write Fpath2;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property rozpustene_naklady: Double read Frozpustene_naklady write Frozpustene_naklady;
    property prijaty_doklad: string read Fprijaty_doklad write Fprijaty_doklad;
    property order_id: Tc_order read getorder_id write setorder_id;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
    property dodaciListPrijaty: string read FdodaciListPrijaty write FdodaciListPrijaty;
    property fakturaPrijata: string read FfakturaPrijata write FfakturaPrijata;
    property fakturaPrijataDatum: Nullable<TDateTime> read FfakturaPrijataDatum write FfakturaPrijataDatum;
    property customer_name: string read Fcustomer_name write Fcustomer_name;
    property customer_ico: string read Fcustomer_ico write Fcustomer_ico;
    property export_poradi: Integer read Fexport_poradi write Fexport_poradi;
    property pohyb_id: Tsklad_material_pohyb read getpohyb_id write setpohyb_id;
    property typ: Tsklad_material_prijemky_typy read gettyp write settyp;
    property stavdokladu: Tstavydokladu read getstavdokladu write setstavdokladu;
    property exported: Boolean read Fexported write Fexported;
    property exportedDatetime: Nullable<TDateTime> read FexportedDatetime write FexportedDatetime;
//    property cm_castka: Double read Fcm_castka write Fcm_castka;
    property cm_cena_celkem: Double read Fcm_cena_celkem write Fcm_cena_celkem;
    property cm_kurz: Double read Fcm_kurz write setcm_kurz;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property sklad_material_prijemky_docList: TList<Tsklad_material_prijemky_doc> read Getsklad_material_prijemky_docList;
    property Ciselna_rada_id: Tciselne_rady read getCiselna_rada_id write setCiselna_rada_id;
    property usercreated: string read Fusercreated write Fusercreated;
    property sklad_material_readdataList: TList<Tsklad_material_readdata> read Getsklad_material_readdataList;
    property hlavni_mena: Tkurz_meny read gethlavni_mena write sethlavni_mena;
    property has_docs: Integer read Fhas_docs write Fhas_docs;
  end;

  [Entity]
  [Table('sklad_material_prijemky_typy')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_prijemky_typy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('zkratka', [TColumnProp.Required], 50)]
    [Description('')]
    Fzkratka: string;
    
    [Column('popis', [], 50)]
    [Description('')]
    Fpopis: Nullable<string>;
    
    [Column('zkratka_export', [TColumnProp.Required], 50)]
    [Description('')]
    Fzkratka_export: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('id_sklad_pohyb', [TColumnProp.Required], 'id')]
    [Description('')]
    Fid_sklad_pohyb: proxy<Tsklad_material_pohyb>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('Ciselna_rada_id', [], 'id')]
    [Description('')]
    FCiselna_rada_id: proxy<Tciselne_rady>;

    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Boolean;

    [Column('interni_doklad', [TColumnProp.Required])]
    [Description('')]
    Finterni_doklad: Boolean;

    [Column('aktivni', [TColumnProp.Required])]
    [Description('')]
    Faktivni: Boolean;

    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getid_sklad_pohyb: Tsklad_material_pohyb;
    procedure setid_sklad_pohyb(const Value : Tsklad_material_pohyb);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanEditRecord(var aMessage : String): Boolean; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property zkratka: string read Fzkratka write Fzkratka;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property zkratka_export: string read Fzkratka_export write Fzkratka_export;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property id_sklad_pohyb: Tsklad_material_pohyb read getid_sklad_pohyb write setid_sklad_pohyb;
    property vychozi: Boolean read fVychozi write fVychozi;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property interni_doklad: Boolean read Finterni_doklad write Finterni_doklad;
    property aktivni : Boolean read Faktivni write Faktivni;
  end;
  
  [Entity]
  [Table('sklad_material_readdata')]
  [Description('Naten data ze skladu materilu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;

    [Column('count', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcount: Double;

    [Column('count_mj', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcount_mj: Double;

    [Column('calculated', [TColumnProp.Required])]
    [Description('')]
    Fcalculated: Boolean;

    [Column('added', [TColumnProp.Required])]
    [Description('')]
    Fadded: Boolean;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('exported', [TColumnProp.Required])]
    [Description('')]
    Fexported: Boolean;

    [Column('castka', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcastka: Double;

    [Column('note', [])]
    [Description('')]
    Fnote: string;

    [Column('stav_skladu', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fstav_skladu: Double;

    [Column('prevod_nasklad', [TColumnProp.Required])]
    [Description('')]
    Fprevod_nasklad: Integer;


    [Column('ulozeno', [TColumnProp.Required])]
    [Description('')]
    Fulozeno: TDateTime;

    [Column('ExtObj', [], 256)]
    [Description('')]
    FExtObj: Nullable<string>;

    [Column('ExtDL', [], 256)]
    [Description('')]
    FExtDL: Nullable<string>;

    [Column('unirec', [], 256)]
    [Description('')]
    Funirec: Nullable<string>;

    [Column('delka_prirezu', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fdelka_prirezu: Double;

    [Column('prorez', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprorez: Double;

    [Column('count2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcount2: Double;

    [Column('zbytkovy_material', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fzbytkovy_material: Double;

    [Column('cislo', [], 256)]
    [Description('')]
    Fcislo: Nullable<string>;

    [Column('vazena_cena', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fvazena_cena: Double;

    [Column('pohyb_vazena_cena', [TColumnProp.Required], 20, 6)]
    [Description('')]
    Fpohyb_vazena_cena: Double;

    [Column('last_nakup_cena', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Flast_nakup_cena: Double;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('exportvydejka_id', [])]
    [Description('')]
    Fexportvydejka_id: Nullable<Integer>;

    [Column('rozpustene_naklady', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Frozpustene_naklady: Double;

    [Column('zdroj_order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fzdroj_order_id: string;

    [Column('sarze', [TColumnProp.Required], 255)]
    [Description('')]
    Fsarze: string;

    [Column('printed', [TColumnProp.Required])]
    [Description('')]
    Fprinted: Boolean;

    [Column('printed_datetime', [TColumnProp.Required])]
    [Description('')]
    Fprinted_datetime: TDateTime;

    [Column('exported_datetime', [TColumnProp.Required])]
    [Description('')]
    Fexported_datetime: TDateTime;

    [Column('cm_castka', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_castka: Double;

    [Column('cm_castka_mj', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_castka_mj: Double;

    [Column('cm_kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_kurz: Double;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cm_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Column('cm_celkem', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_celkem: Double;

    [Column('celkem', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcelkem: Double;

    [Column('castka_mj', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcastka_mj: Double;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Column('usercreated', [TColumnProp.Required], 50)]
    [Description('')]
    Fusercreated: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<TWorker>;

    [Association([], CascadeTypeNone)] //TAssociationProp.Lazy
    [JoinColumn('order_id', [], 'bar_id')]
    [Description('')]
//    Forder_id: proxy<Tc_order>;
    Forder_id: Tc_order;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('polozka_objednavky_id', [], 'id')]
    [Description('')]
    Fpolozka_objednavky_id: proxy<TObjednavky_polozky>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('pohyb_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fpohyb_id: proxy<Tsklad_material_pohyb>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('prijem_id', [], 'id')]
    [Description('')]
    Fprijem_id: proxy<Tsklad_material_prijemky>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('polozka_dodlist_id', [], 'id')]
    [Description('')]
    Fpolozka_dodlist_id: proxy<Tdodaci_listy_polozky>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('vydej_id', [], 'id')]
    [Description('')]
    Fvydej_id: proxy<Tsklad_material_vydejky>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('material_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('hlavni_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    FHlavni_mena: proxy<TKurz_meny>;

    [Column('coef_unit', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcoef_unit: Double;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<Tjednotky>;

    function getworker_id: TWorker;
    procedure setworker_id(const Value : TWorker);
    function getorder_id: Tc_order;
    procedure setorder_id(const Value : Tc_order);
    function getpolozka_objednavky_id: TObjednavky_polozky;
    procedure setpolozka_objednavky_id(const Value : TObjednavky_polozky);
    function getpohyb_id: Tsklad_material_pohyb;
    procedure setpohyb_id(const Value : Tsklad_material_pohyb);
    function getprijem_id: Tsklad_material_prijemky;
    procedure setprijem_id(const Value : Tsklad_material_prijemky);
    function getpolozka_dodlist_id: Tdodaci_listy_polozky;
    procedure setpolozka_dodlist_id(const Value : Tdodaci_listy_polozky);
    function getvydej_id: Tsklad_material_vydejky;
    procedure setvydej_id(const Value : Tsklad_material_vydejky);
    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getHlavni_mena: TKurz_meny;
    procedure setHlavni_mena(const Value : TKurz_meny);
    function getunit_: Tjednotky;
    procedure setunit_(const Value : Tjednotky);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function getcount: Double;
    function getcount_mj: Double;
    procedure setcount_mj(const Value: Double);
    procedure setCastka_mj(const Value: Double);
    procedure setcoef_unit(const Value: Double);
    procedure setcm_Castka_mj(const Value: Double);
    procedure setcm_Castka(const Value: Double);
    procedure setcm_kurz(const Value: Double);
    procedure setcm_celkem(const Value: Double);
    procedure setcelkem(const Value: Double);
    function getdate_date: TDateTime;
    function getdate_time: TDateTime;
    procedure setdate_date(const Value: TDateTime);
    procedure setdate_time(const Value: TDateTime);
    procedure setcount(const Value: Double);
    procedure setcastka(const Value: Double);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    function CheckRecord(var aMessage: String): Boolean; override;
    property id: Int64 read Fid write Fid;
    property date: TDateTime read Fdate write Fdate;
    property date_date: TDateTime read getdate_date write setdate_date;
    property date_time: TDateTime read getdate_time write setdate_time;
    property count_mj: Double read getcount_mj write setcount_mj;
    property cm_castka_mj: Double read Fcm_castka_mj write setcm_castka_mj;
    property calculated: Boolean read Fcalculated write Fcalculated;
    property added: Boolean read Fadded write Fadded;
    property user: string read Fuser write Fuser;
    property exported: Boolean read Fexported write Fexported;
    property note: string read Fnote write Fnote;
    property stav_skladu: Double read Fstav_skladu write Fstav_skladu;
    property prevod_nasklad: Integer read Fprevod_nasklad write Fprevod_nasklad;
    property ulozeno: TDateTime read Fulozeno write Fulozeno;
    property ExtObj: Nullable<string> read FExtObj write FExtObj;
    property ExtDL: Nullable<string> read FExtDL write FExtDL;
    property unirec: Nullable<string> read Funirec write Funirec;
    property delka_prirezu: Double read Fdelka_prirezu write Fdelka_prirezu;
    property prorez: Double read Fprorez write Fprorez;
    property count2: Double read Fcount2 write Fcount2;
    property zbytkovy_material: Double read Fzbytkovy_material write Fzbytkovy_material;
    property cislo: Nullable<string> read Fcislo write Fcislo;
    property vazena_cena: Double read Fvazena_cena write Fvazena_cena;
    property pohyb_vazena_cena: Double read Fpohyb_vazena_cena write Fpohyb_vazena_cena;
    property last_nakup_cena: Double read Flast_nakup_cena write Flast_nakup_cena;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property exportvydejka_id: Nullable<Integer> read Fexportvydejka_id write Fexportvydejka_id;
    property rozpustene_naklady: Double read Frozpustene_naklady write Frozpustene_naklady;
    property zdroj_order_id: string read Fzdroj_order_id write Fzdroj_order_id;
    property sarze: string read Fsarze write Fsarze;
    property printed: Boolean read Fprinted write Fprinted;
    property printed_datetime: TDateTime read Fprinted_datetime write Fprinted_datetime;
    property exported_datetime: TDateTime read Fexported_datetime write Fexported_datetime;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property usercreated: string read Fusercreated write Fusercreated;
    property worker_id: TWorker read getworker_id write setworker_id;
    property order_id: Tc_order read getorder_id write setorder_id;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property prijem_id: Tsklad_material_prijemky read getprijem_id write setprijem_id;
    property vydej_id: Tsklad_material_vydejky read getvydej_id write setvydej_id;
    property polozka_dodlist_id: Tdodaci_listy_polozky read getpolozka_dodlist_id write setpolozka_dodlist_id;
    property Hlavni_mena: TKurz_meny read getHlavni_mena write setHlavni_mena;
    property polozka_objednavky_id: TObjednavky_polozky read getpolozka_objednavky_id write setpolozka_objednavky_id;
    property pohyb_id: Tsklad_material_pohyb read getpohyb_id write setpohyb_id;
    property unit_: Tjednotky read getunit_ write setunit_;
    //RO
    property count: Double read getcount; // write setcount;
    property castka_mj: Double read Fcastka_mj; // write setcastka_mj;
    property celkem: Double read Fcelkem; // write setcelkem;
    property coef_unit: Double read Fcoef_unit; // write setcoef_unit;
    property cm_castka: Double read Fcm_castka; // write fcm_castka;
    property cm_kurz: Double read Fcm_kurz; // write setcm_kurz;
    property cm_celkem: Double read Fcm_celkem; // write setcm_celkem;
    property castka: Double read Fcastka; // write Fcastka;
  end;

  [Entity]
  [Table('sklad_material_tvar')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_tvar = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Int64 read Fid write Fid;
    property name: string read Fname write Fname;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_material_vydejky')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_vydejky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoklad: string;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('date', [TColumnProp.Required])]
    [Description('')]
    Fdate: TDateTime;

    [Column('castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka: Double;

    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_celkem: Double;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('oznaceni', [TColumnProp.Required], 50)]
    [Description('')]
    Foznaceni: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('path2', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath2: string;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('prijaty_doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fprijaty_doklad: string;

    [Association([], CascadeTypeNone)] // TAssociationProp.Lazy
    [JoinColumn('order_id', [], 'bar_id')]
    [Description('')]
//    Forder_id: proxy<Tc_order>;
    Forder_id: Tc_order;

    [Column('dodaciListVydany', [TColumnProp.Required], 50)]
    [Description('')]
    FdodaciListVydany: string;
    
    [Column('fakturaVydana', [TColumnProp.Required], 50)]
    [Description('')]
    FfakturaVydana: string;
    
    [Column('fakturaVydanaDatum', [TColumnProp.Required])]
    [Description('')]
    FfakturaVydanaDatum: TDateTime;
    
    [Column('customer_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fcustomer_name: string;
    
    [Column('customer_ico', [TColumnProp.Required], 100)]
    [Description('')]
    Fcustomer_ico: string;
    
    [Column('export_poradi', [TColumnProp.Required])]
    [Description('')]
    Fexport_poradi: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('pohyb_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fpohyb_id: proxy<TSklad_material_pohyb>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('typ', [TColumnProp.Required], 'id')]
    [Description('')]
    Ftyp: proxy<TSklad_material_Vydejky_Typy>;
    
    [Column('printed', [TColumnProp.Required])]
    [Description('')]
    Fprinted: Boolean;
    
    [Column('printed_datetime', [TColumnProp.Required])]
    [Description('')]
    Fprinted_datetime: TDateTime;

    [Column('exported', [TColumnProp.Required])]
    [Description('')]
    Fexported: Boolean;
    
    [Column('exported_datetime', [TColumnProp.Required])]
    [Description('')]
    Fexported_datetime: TDateTime;
    
    [Column('cm_castka', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcm_castka: Double;
    
    [Column('cm_cena_celkem', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcm_cena_celkem: Double;

    [Column('cm_kurz', [TColumnProp.Required], 15, 5)]
    [Description('')]
    Fcm_kurz: Double;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('cm_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fcm_mena: proxy<Tkurz_meny>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('customer_id', [], 'id')]
    [Description('')]
    Fcustomer_id: proxy<Tcustomer>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('StavDokladu', [], 'id')]
    [Description('')]
    FStavDokladu: proxy<Tstavydokladu>;

    [Column('usercreated', [TColumnProp.Required], 50)]
    [Description('')]
    Fusercreated: string;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('Ciselna_rada_id', [TColumnProp.Required], 'id')]
    [Description('')]
    FCiselna_rada_id: proxy<Tciselne_rady>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('hlavni_mena', [TColumnProp.Required], 'zkratka')]
    [Description('')]
    Fhlavni_mena: proxy<Tkurz_meny>;

    [Column('has_docs', [TColumnProp.Required])]
    [Description('')]
    Fhas_docs: Integer;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAll, 'Fvydej_id')]
    Fsklad_material_readdataList: Proxy<TList<Tsklad_material_readdata>>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fvydej_id')]
    Fsklad_material_vydejky_docList: Proxy<TList<Tsklad_material_vydejky_doc>>;

    function Getsklad_material_readdataList: TList<Tsklad_material_readdata>;
    function Getsklad_material_vydejky_docList: TList<Tsklad_material_vydejky_doc>;
    function getpohyb_id: TSklad_material_pohyb;
    procedure setpohyb_id(const Value : TSklad_material_pohyb);
    function gettyp: TSklad_material_Vydejky_Typy;
    procedure settyp(const Value : TSklad_material_Vydejky_Typy);
    function getcm_mena: Tkurz_meny;
    procedure setcm_mena(const Value : Tkurz_meny);
    function getcustomer_id: Tcustomer;
    procedure setcustomer_id(const Value : Tcustomer);
    function getStavDokladu: Tstavydokladu;
    procedure setStavDokladu(const Value : Tstavydokladu);
    function getCiselna_rada_id: Tciselne_rady;
    procedure setCiselna_rada_id(const Value : Tciselne_rady);
    function gethlavni_mena: Tkurz_meny;
    procedure sethlavni_mena(const Value : Tkurz_meny);
    function getorder_id: Tc_order;
    procedure setorder_id(const Value: Tc_order);
    procedure setcm_kurz(const Value: Double);
    procedure setdate(const Value: TDateTime);
  public
    constructor Create; override;
    destructor Destroy; override;
    class procedure checkNewRecord; override;
    function CheckRequiredFields : boolean; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRecord(var aMessage: String): Boolean; override;
    property id: Int64 read Fid write Fid;
    property doklad: string read Fdoklad write Fdoklad;
    property name: string read Fname write Fname;
    property date: TDateTime read Fdate write setdate;
//    property castka: Double read Fcastka write Fcastka;
    property note: string read Fnote write Fnote;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property user: string read Fuser write Fuser;
    property oznaceni: string read Foznaceni write Foznaceni;
    property path: string read Fpath write Fpath;
    property path2: string read Fpath2 write Fpath2;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property prijaty_doklad: string read Fprijaty_doklad write Fprijaty_doklad;
    property order_id: Tc_order read getorder_id write setorder_id;
    property customer_id: Tcustomer read getcustomer_id write setcustomer_id;
    property dodaciListVydany: string read FdodaciListVydany write FdodaciListVydany;
    property fakturaVydana: string read FfakturaVydana write FfakturaVydana;
    property fakturaVydanaDatum: TDateTime read FfakturaVydanaDatum write FfakturaVydanaDatum;
    property customer_name: string read Fcustomer_name write Fcustomer_name;
    property customer_ico: string read Fcustomer_ico write Fcustomer_ico;
    property export_poradi: Integer read Fexport_poradi write Fexport_poradi;
    property pohyb_id: TSklad_material_pohyb read getpohyb_id write setpohyb_id;
    property printed: Boolean read Fprinted write Fprinted;
    property printed_datetime: TDateTime read Fprinted_datetime write Fprinted_datetime;
    property exported: Boolean read Fexported write Fexported;
    property exported_datetime: TDateTime read Fexported_datetime write Fexported_datetime;
//    property cm_castka: Double read Fcm_castka write Fcm_castka;
    property cm_cena_celkem: Double read Fcm_cena_celkem write Fcm_cena_celkem;
    property cm_kurz: Double read Fcm_kurz write setcm_kurz;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
    property cm_mena: Tkurz_meny read getcm_mena write setcm_mena;
    property StavDokladu: Tstavydokladu read getStavDokladu write setStavDokladu;
    property Ciselna_rada_id: Tciselne_rady read getCiselna_rada_id write setCiselna_rada_id;
    property sklad_material_readdataList: TList<Tsklad_material_readdata> read Getsklad_material_readdataList;
    property typ: TSklad_material_Vydejky_Typy read gettyp write settyp;
    property sklad_material_vydejky_docList: TList<Tsklad_material_vydejky_doc> read Getsklad_material_vydejky_docList;
    property usercreated: string read Fusercreated write Fusercreated;
    property hlavni_mena: Tkurz_meny read gethlavni_mena write sethlavni_mena;
    property has_docs: Integer read Fhas_docs write Fhas_docs;
  end;

  [Entity]
  [Table('sklad_material_vydejky_typy')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_vydejky_typy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('zkratka', [TColumnProp.Required], 50)]
    [Description('')]
    Fzkratka: string;
    
    [Column('popis', [], 50)]
    [Description('')]
    Fpopis: Nullable<string>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('id_sklad_pohyb', [TColumnProp.Required], 'id')]
    [Description('')]
    Fid_sklad_pohyb: proxy<Tsklad_material_pohyb>;

    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Boolean;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('Ciselna_rada_id', [], 'id')]
    [Description('')]
    FCiselna_rada_id: proxy<Tciselne_rady>;

    [Column('interni_doklad', [TColumnProp.Required])]
    [Description('')]
    Finterni_doklad: Boolean;

    [Column('aktivni', [TColumnProp.Required])]
    [Description('')]
    Faktivni: Boolean;

    function getid_sklad_pohyb: Tsklad_material_pohyb;
    procedure setid_sklad_pohyb(const Value : Tsklad_material_pohyb);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanEditRecord (var aMessage : String): Boolean; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property zkratka: string read Fzkratka write Fzkratka;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property id_sklad_pohyb: Tsklad_material_pohyb read getid_sklad_pohyb write setid_sklad_pohyb;
    property vychozi: Boolean read fVychozi write fVychozi;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property interni_doklad: Boolean read Finterni_doklad write Finterni_doklad;
    property aktivni : Boolean read Faktivni write Faktivni;
  end;
  
  [Entity]
  [Table('sklad_naradi')]
  [Description('Sklad drobnho nad')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_naradi = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 250)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('nakup', [TColumnProp.Required])]
    [Description('')]
    Fnakup: TDateTime;
    
    [Column('servis', [TColumnProp.Required])]
    [Description('')]
    Fservis: TDateTime;
    
    [Column('delay_servis_date', [TColumnProp.Required])]
    [Description('')]
    Fdelay_servis_date: TDateTime;
    
    [Column('delay_servis_time', [TColumnProp.Required])]
    [Description('')]
    Fdelay_servis_time: Integer;
    
    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('odpracovano', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano: Integer;

    [Column('cena', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena: Double;
    
    [Column('mnozstvi', [TColumnProp.Required])]
    [Description('')]
    Fmnozstvi: Integer;
    
    [Column('mnozstvi_init', [TColumnProp.Required])]
    [Description('')]
    Fmnozstvi_init: Integer;
    
    [Column('skupina', [TColumnProp.Required], 50)]
    [Description('')]
    Fskupina: string;
    
    [Column('objednano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fobjednano: Double;
    
    [Column('pocatecnistav', [TColumnProp.Required])]
    [Description('')]
    Fpocatecnistav: Integer;
    
    [Column('vyrobni_c', [TColumnProp.Required], 100)]
    [Description('')]
    Fvyrobni_c: string;
    
    [Column('last_finish', [TColumnProp.Required])]
    [Description('')]
    Flast_finish: TDateTime;
    
    [Column('termin_zaruky', [TColumnProp.Required])]
    [Description('')]
    Ftermin_zaruky: TDateTime;
    
    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;
    
    [Column('dodavatel_id', [TColumnProp.Required])]
    [Description('')]
    Fdodavatel_id: Integer;
    
    [Column('typ_naradi', [TColumnProp.Required])]
    [Description('')]
    Ftyp_naradi: Integer;
    
    [Column('ukonceni_interval', [TColumnProp.Required])]
    [Description('')]
    Fukonceni_interval: Integer;
    
    [Column('stavKarty', [TColumnProp.Required])]
    [Description('')]
    FstavKarty: Integer;
    
    [Column('mnozstvi_limit', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_limit: Double;
    
    [Column('zarukaDelka', [TColumnProp.Required])]
    [Description('')]
    FzarukaDelka: Integer;
    
    [Column('katalog', [TColumnProp.Required], 100)]
    [Description('')]
    Fkatalog: string;
    
    [Column('sledovat_vyrobni_cisla', [TColumnProp.Required])]
    [Description('')]
    Fsledovat_vyrobni_cisla: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property nakup: TDateTime read Fnakup write Fnakup;
    property servis: TDateTime read Fservis write Fservis;
    property delay_servis_date: TDateTime read Fdelay_servis_date write Fdelay_servis_date;
    property delay_servis_time: Integer read Fdelay_servis_time write Fdelay_servis_time;
    property stav: Integer read Fstav write Fstav;
    property user: string read Fuser write Fuser;
    property odpracovano: Integer read Fodpracovano write Fodpracovano;
    property cena: Double read Fcena write Fcena;
    property mnozstvi: Integer read Fmnozstvi write Fmnozstvi;
    property mnozstvi_init: Integer read Fmnozstvi_init write Fmnozstvi_init;
    property skupina: string read Fskupina write Fskupina;
    property objednano: Double read Fobjednano write Fobjednano;
    property pocatecnistav: Integer read Fpocatecnistav write Fpocatecnistav;
    property vyrobni_c: string read Fvyrobni_c write Fvyrobni_c;
    property last_finish: TDateTime read Flast_finish write Flast_finish;
    property termin_zaruky: TDateTime read Ftermin_zaruky write Ftermin_zaruky;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property dodavatel_id: Integer read Fdodavatel_id write Fdodavatel_id;
    property typ_naradi: Integer read Ftyp_naradi write Ftyp_naradi;
    property ukonceni_interval: Integer read Fukonceni_interval write Fukonceni_interval;
    property stavKarty: Integer read FstavKarty write FstavKarty;
    property mnozstvi_limit: Double read Fmnozstvi_limit write Fmnozstvi_limit;
    property zarukaDelka: Integer read FzarukaDelka write FzarukaDelka;
    property katalog: string read Fkatalog write Fkatalog;
    property sledovat_vyrobni_cisla: Integer read Fsledovat_vyrobni_cisla write Fsledovat_vyrobni_cisla;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_naradi_pohyb')]
  [Description('Typy pohyby naradi z a do skladu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_naradi_pohyb = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;
    
    [Column('typ_pohybu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_pohybu: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('stavId', [TColumnProp.Required])]
    [Description('')]
    FstavId: Integer;
    
    [Column('AutoWrite', [TColumnProp.Required])]
    [Description('')]
    FAutoWrite: Integer;
    
    [Column('stavChange', [TColumnProp.Required])]
    [Description('')]
    FstavChange: Integer;
    
    [Column('naradiType', [TColumnProp.Required])]
    [Description('')]
    FnaradiType: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property typ_pohybu: Integer read Ftyp_pohybu write Ftyp_pohybu;
    property user: string read Fuser write Fuser;
    property stavId: Integer read FstavId write FstavId;
    property AutoWrite: Integer read FAutoWrite write FAutoWrite;
    property stavChange: Integer read FstavChange write FstavChange;
    property naradiType: Integer read FnaradiType write FnaradiType;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_naradi_readdata')]
  [Description('Nactena data skladu drobneho naradi')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_naradi_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('naradi_id', [TColumnProp.Required])]
    [Description('')]
    Fnaradi_id: Integer;
    
    [Column('pohyb_id', [TColumnProp.Required])]
    [Description('')]
    Fpohyb_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Column('calculated', [TColumnProp.Required])]
    [Description('')]
    Fcalculated: Integer;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('count', [TColumnProp.Required])]
    [Description('')]
    Fcount: Integer;
    
    [Column('stav_skladu', [TColumnProp.Required])]
    [Description('')]
    Fstav_skladu: Integer;
    
    [Column('isActual', [TColumnProp.Required])]
    [Description('')]
    FisActual: Integer;
    
    [Column('polozka_objednavky_id', [TColumnProp.Required])]
    [Description('')]
    Fpolozka_objednavky_id: Integer;
    
    [Column('castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka: Double;
    
    [Column('order_id', [TColumnProp.Required], 150)]
    [Description('')]
    Forder_id: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property naradi_id: Integer read Fnaradi_id write Fnaradi_id;
    property pohyb_id: Integer read Fpohyb_id write Fpohyb_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property start: TDateTime read Fstart write Fstart;
    property finish: TDateTime read Ffinish write Ffinish;
    property note: string read Fnote write Fnote;
    property calculated: Integer read Fcalculated write Fcalculated;
    property user: string read Fuser write Fuser;
    property count: Integer read Fcount write Fcount;
    property stav_skladu: Integer read Fstav_skladu write Fstav_skladu;
    property isActual: Integer read FisActual write FisActual;
    property polozka_objednavky_id: Integer read Fpolozka_objednavky_id write Fpolozka_objednavky_id;
    property castka: Double read Fcastka write Fcastka;
    property order_id: string read Forder_id write Forder_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sklad_naradi_stav')]
  [Description('Tabulka stav karet nad')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_naradi_stav = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('tabulka', [TColumnProp.Required], 100)]
    [Description('')]
    Ftabulka: string;
    
    [Column('note', [TColumnProp.Required], 255)]
    [Description('')]
    Fnote: string;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: Integer;
    
    [Column('groupId', [TColumnProp.Required])]
    [Description('')]
    FgroupId: Integer;

    [Column('time_stamp', [TColumnProp.Required])]
    [Description('')]
    Ftime_stamp: TDateTime;

    [Column('created', [TColumnProp.Required])]
    [Description('')]
    Fcreated: TDateTime;

    [Column('changeItemCount', [TColumnProp.Required])]
    [Description('')]
    FchangeItemCount: Integer;

    [Column('is_default', [TColumnProp.Required])]
    [Description('')]
    Fis_default: Boolean;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property poradi: Integer read Fporadi write Fporadi;
    property name: string read Fname write Fname;
    property tabulka: string read Ftabulka write Ftabulka;
    property note: string read Fnote write Fnote;
    property active: Integer read Factive write Factive;
    property groupId: Integer read FgroupId write FgroupId;
    property time_stamp: TDateTime read Ftime_stamp write Ftime_stamp;
    property created: TDateTime read Fcreated write Fcreated;
    property changeItemCount: Integer read FchangeItemCount write FchangeItemCount;
    property is_default: Boolean read Fis_default write Fis_default;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_skupiny')]
  [Description('Stavy zakazek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_skupiny = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 255)]
    [Description('')]
    Fname: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('id_pohoda', [TColumnProp.Required], 100)]
    [Description('')]
    Fid_pohoda: string;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;
    
    [Column('prefix_pozice', [TColumnProp.Required], 1)]
    [Description('')]
    Fprefix_pozice: string;
    
    [Column('vychozi_marze', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fvychozi_marze: Double;
    
    [Column('vypocet_ceny', [TColumnProp.Required])]
    [Description('')]
    Fvypocet_ceny: Integer;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('parent_id', [], 'id')]
    [Description('')]
    Fparent_id: proxy<Tsklad_skupiny>;
    
    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('operation_id_batchout', [], 'id')]
    [Description('')]
    Foperation_id_batchout: proxy<Toperation>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('default_unit', [], 'id_correct')]
    [Description('')]
    Fdefault_unit : proxy<Tjednotky>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    function getparent_id: Tsklad_skupiny;
    procedure setparent_id(const Value : Tsklad_skupiny);
    function getoperation_id_batchout: Toperation;
    procedure setoperation_id_batchout(const Value : Toperation);
    function getdefault_unit: Tjednotky;
    procedure setdefault_unit(const Value : Tjednotky);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user: string read Fuser write Fuser;
    property id_pohoda: string read Fid_pohoda write Fid_pohoda;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property prefix_pozice: string read Fprefix_pozice write Fprefix_pozice;
    property vychozi_marze: Double read Fvychozi_marze write Fvychozi_marze;
    property vypocet_ceny: Integer read Fvypocet_ceny write Fvypocet_ceny;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property parent_id: Tsklad_skupiny read getparent_id write setparent_id;
    property operation_id_batchout: Toperation read getoperation_id_batchout write setoperation_id_batchout;
    property default_unit: Tjednotky read getdefault_unit write setdefault_unit;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
  end;

  [Entity]
  [Table('sp_log')]
  [Description('Tabulka logovn uloench procedur')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsp_log = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('time_stamp', [TColumnProp.Required])]
    [Description('')]
    Ftime_stamp: TDateTime;
    
    [Column('level', [], 20)]
    [Description('')]
    Flevel: Nullable<string>;
    
    [Column('sp_name', [], 255)]
    [Description('')]
    Fsp_name: Nullable<string>;
    
    [Column('message', [], 512)]
    [Description('')]
    Fmessage: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property time_stamp: TDateTime read Ftime_stamp write Ftime_stamp;
    property level: Nullable<string> read Flevel write Flevel;
    property sp_name: Nullable<string> read Fsp_name write Fsp_name;
    property message: Nullable<string> read Fmessage write Fmessage;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sp_settings')]
  [Description('Tabulka nastaven uloench procedur')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsp_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('sp_name', [], 255)]
    [Description('')]
    Fsp_name: Nullable<string>;
    
    [Column('enabled', [])]
    [Description('')]
    Fenabled: Nullable<Integer>;
    
    [Column('log_level', [], 20)]
    [Description('')]
    Flog_level: Nullable<string>;
    
    [Column('locked', [])]
    [Description('')]
    Flocked: Nullable<Integer>;
    
    [Column('locked_timestamp', [TColumnProp.Required])]
    [Description('')]
    Flocked_timestamp: TDateTime;

    [Column('sp_alias', [], 255)]
    [Description('')]
    Fsp_alias: Nullable<string>;
    
    [Column('visible', [TColumnProp.Required])]
    [Description('')]
    Fvisible: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property sp_name: Nullable<string> read Fsp_name write Fsp_name;
    property enabled: Nullable<Integer> read Fenabled write Fenabled;
    property log_level: Nullable<string> read Flog_level write Flog_level;
    property locked: Nullable<Integer> read Flocked write Flocked;
    property locked_timestamp: TDateTime read Flocked_timestamp write Flocked_timestamp;
    property sp_alias: Nullable<string> read Fsp_alias write Fsp_alias;
    property visible: Integer read Fvisible write Fvisible;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('stavydokladu')]
  [Description('Tabulka stav doklad')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tstavydokladu = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('tabulka', [TColumnProp.Required], 100)]
    [Description('')]
    Ftabulka: string;
    
    [Column('note', [TColumnProp.Required], 255)]
    [Description('')]
    Fnote: string;
    
    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive: boolean;
    
    [Column('groupId', [TColumnProp.Required])]
    [Description('')]
    FgroupId: Integer;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('isFinal', [TColumnProp.Required])]
    [Description('')]
    FisFinal: Boolean;
    
    [Column('finalAction', [TColumnProp.Required])]
    [Description('')]
    FfinalAction: Integer;
    
    [Column('closeAction', [TColumnProp.Required])]
    [Description('')]
    FcloseAction: Integer;
    
    [Column('use_for_calculation', [TColumnProp.Required])]
    [Description('')]
    Fuse_for_calculation: boolean;
    
    [Column('use_as_default', [TColumnProp.Required])]
    [Description('')]
    Fuse_as_default: boolean;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property poradi: Integer read Fporadi write Fporadi;
    property name: string read Fname write Fname;
    property tabulka: string read Ftabulka write Ftabulka;
    property note: string read Fnote write Fnote;
    property active: boolean read Factive write Factive;
    property groupId: Integer read FgroupId write FgroupId;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property isFinal: Boolean read FisFinal write FisFinal;
    property finalAction: Integer read FfinalAction write FfinalAction;
    property closeAction: Integer read FcloseAction write FcloseAction;
    property use_for_calculation: boolean read Fuse_for_calculation write Fuse_for_calculation;
    property use_as_default: boolean read Fuse_as_default write Fuse_as_default;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('stroje')]
  [Description('Databaze stroju')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tstroje = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('datum_nakup', [TColumnProp.Required])]
    [Description('')]
    Fdatum_nakup: TDateTime;
    
    [Column('odpracovano', [TColumnProp.Required])]
    [Description('')]
    Fodpracovano: Integer;
    
    [Column('cena_hodina', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_hodina: Double;
    
    [Column('servis_delay', [TColumnProp.Required])]
    [Description('')]
    Fservis_delay: Integer;
    
    [Column('servis', [TColumnProp.Required])]
    [Description('')]
    Fservis: TDateTime;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    Fnote: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('group_id', [], 'id')]
    [Description('')]
    Fgroup_id: proxy<Tstroj_group>;

    [Column('termin_zaruky', [TColumnProp.Required])]
    [Description('')]
    Ftermin_zaruky: TDateTime;

    [Column('termin_vyrazeni', [TColumnProp.Required])]
    [Description('')]
    Ftermin_vyrazeni: TDateTime;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('zodpovida', [], 'id')]
    [Description('')]
    Fzodpovida: proxy<Tworker>;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fstroj_id')]
    Fstroje_operationList: Proxy<TList<Tref_stroj_operation>>;
    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fstroj_id')]
    Fstroje_operationGroupList: Proxy<TList<Tref_stroj_operation_group>>;

    FDynCon: TDynamicProperties;

    function Getstroje_operationList: TList<Tref_stroj_operation>;
    function Getstroje_operationGroupList: TList<Tref_stroj_operation_group>;

    function getgroup_id: Tstroj_group;
    procedure setgroup_id(const Value : Tstroj_group);
    function getzodpovida: Tworker;
    procedure setzodpovida(const Value : Tworker);
 public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property datum_nakup: TDateTime read Fdatum_nakup write Fdatum_nakup;
    property odpracovano: Integer read Fodpracovano write Fodpracovano;
    property cena_hodina: Double read Fcena_hodina write Fcena_hodina;
    property servis_delay: Integer read Fservis_delay write Fservis_delay;
    property servis: TDateTime read Fservis write Fservis;
    property user: string read Fuser write Fuser;
    property note: string read Fnote write Fnote;
    property group_id: Tstroj_group read getgroup_id write setgroup_id;
    property termin_zaruky: TDateTime read Ftermin_zaruky write Ftermin_zaruky;
    property termin_vyrazeni: TDateTime read Ftermin_vyrazeni write Ftermin_vyrazeni;
    property zodpovida: Tworker read getzodpovida write setzodpovida;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property stroje_operationList: TList<Tref_stroj_operation> read Getstroje_operationList;
    property stroje_operationGroupList: TList<Tref_stroj_operation_group> read Getstroje_operationGroupList;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('stroje_stavy')]
  [Description('Stavy stroj pro monitoring')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tstroje_stavy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('color', [TColumnProp.Required])]
    [Description('')]
    Fcolor: Integer;
    
    [Column('is_running', [TColumnProp.Required])]
    [Description('')]
    Fis_running: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property color: Integer read Fcolor write Fcolor;
    property is_running: Integer read Fis_running write Fis_running;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('stroj_group')]
  [Description('Skupiny CNC stroju')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tstroj_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('creator', [TColumnProp.Required], 50)]
    [Description('')]
    Fcreator: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user: string read Fuser write Fuser;
    property creator: string read Fcreator write Fcreator;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('subdodavky')]
  [Description('Subdodavky zakazek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsubdodavky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id', [TColumnProp.Required], 200)]
    [Description('')]
    Forder_id: string;
    
    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;
    
    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;
    
    [Column('jednotka', [TColumnProp.Required])]
    [Description('')]
    Fjednotka: Integer;
    
    [Column('cena_jednotka', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_jednotka: Double;
    
    [Column('cena_celkem', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcena_celkem: Double;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('doklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fdoklad: string;
    
    [Column('cislo', [TColumnProp.Required])]
    [Description('')]
    Fcislo: Integer;
    
    [Column('planovana', [TColumnProp.Required])]
    [Description('')]
    Fplanovana: Integer;
    
    [Column('datum_realizace', [TColumnProp.Required])]
    [Description('')]
    Fdatum_realizace: TDateTime;
    
    [Column('datum_vytvoreni', [TColumnProp.Required])]
    [Description('')]
    Fdatum_vytvoreni: TDateTime;
    
    [Column('dokladMoney', [TColumnProp.Required], 50)]
    [Description('')]
    FdokladMoney: string;
    
    [Column('user_price', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fuser_price: Double;
    
    [Column('note', [TColumnProp.Required], 4096)]
    [Description('')]
    Fnote: string;
    
    [Column('Create_fak', [TColumnProp.Required])]
    [Description('')]
    FCreate_fak: TDateTime;
    
    [Column('dodavatelName', [TColumnProp.Required], 150)]
    [Description('')]
    FdodavatelName: string;
    
    [Column('dodavatelId', [TColumnProp.Required])]
    [Description('')]
    FdodavatelId: Integer;
    
    [Column('id_pohoda', [TColumnProp.Required], 100)]
    [Description('')]
    Fid_pohoda: string;
    
    [Column('Predp_datum_dodani', [TColumnProp.Required])]
    [Description('')]
    FPredp_datum_dodani: TDateTime;
    
    [Column('Datum_dodani', [TColumnProp.Required])]
    [Description('')]
    FDatum_dodani: TDateTime;
    
    [Column('realizovana', [TColumnProp.Required])]
    [Description('')]
    Frealizovana: Integer;
    
    [Column('misto_doruceni', [TColumnProp.Required], 150)]
    [Description('')]
    Fmisto_doruceni: string;
    
    [Column('mnozstvi_real', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_real: Double;
    
    [Column('mnozstvi_vydano', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi_vydano: Double;
    
    [Column('datum_vydano', [TColumnProp.Required])]
    [Description('')]
    Fdatum_vydano: TDateTime;
    
    [Column('doklad2', [TColumnProp.Required], 100)]
    [Description('')]
    Fdoklad2: string;
    
    [Column('print_count', [TColumnProp.Required])]
    [Description('')]
    Fprint_count: Integer;
    
    [Column('printed', [TColumnProp.Required])]
    [Description('')]
    Fprinted: Integer;
    
    [Column('printed_datetime', [TColumnProp.Required])]
    [Description('')]
    Fprinted_datetime: TDateTime;
    
    [Column('user_created', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser_created: string;
    
    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id: string read Forder_id write Forder_id;
    property name: string read Fname write Fname;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property jednotka: Integer read Fjednotka write Fjednotka;
    property cena_jednotka: Double read Fcena_jednotka write Fcena_jednotka;
    property cena_celkem: Double read Fcena_celkem write Fcena_celkem;
    property user: string read Fuser write Fuser;
    property doklad: string read Fdoklad write Fdoklad;
    property cislo: Integer read Fcislo write Fcislo;
    property planovana: Integer read Fplanovana write Fplanovana;
    property datum_realizace: TDateTime read Fdatum_realizace write Fdatum_realizace;
    property datum_vytvoreni: TDateTime read Fdatum_vytvoreni write Fdatum_vytvoreni;
    property dokladMoney: string read FdokladMoney write FdokladMoney;
    property user_price: Double read Fuser_price write Fuser_price;
    property note: string read Fnote write Fnote;
    property Create_fak: TDateTime read FCreate_fak write FCreate_fak;
    property dodavatelName: string read FdodavatelName write FdodavatelName;
    property dodavatelId: Integer read FdodavatelId write FdodavatelId;
    property id_pohoda: string read Fid_pohoda write Fid_pohoda;
    property Predp_datum_dodani: TDateTime read FPredp_datum_dodani write FPredp_datum_dodani;
    property Datum_dodani: TDateTime read FDatum_dodani write FDatum_dodani;
    property realizovana: Integer read Frealizovana write Frealizovana;
    property misto_doruceni: string read Fmisto_doruceni write Fmisto_doruceni;
    property mnozstvi_real: Double read Fmnozstvi_real write Fmnozstvi_real;
    property mnozstvi_vydano: Double read Fmnozstvi_vydano write Fmnozstvi_vydano;
    property datum_vydano: TDateTime read Fdatum_vydano write Fdatum_vydano;
    property doklad2: string read Fdoklad2 write Fdoklad2;
    property print_count: Integer read Fprint_count write Fprint_count;
    property printed: Integer read Fprinted write Fprinted;
    property printed_datetime: TDateTime read Fprinted_datetime write Fprinted_datetime;
    property user_created: string read Fuser_created write Fuser_created;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('swterm_rozdel')]
  [Description('SW terminal rozdeleni ukonu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tswterm_rozdel = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Int64;
    
    [Column('order_id', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('cas', [TColumnProp.Required])]
    [Description('')]
    Fcas: TDateTime;
    
    [Column('procent', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprocent: Double;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    
    [Column('ukon_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fukon_mzda: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Int64 read Fuser_id write Fuser_id;
    property order_id: string read Forder_id write Forder_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property cas: TDateTime read Fcas write Fcas;
    property procent: Double read Fprocent write Fprocent;
    property start: TDateTime read Fstart write Fstart;
    property mnoz: Double read Fmnoz write Fmnoz;
    property ukon_mzda: Double read Fukon_mzda write Fukon_mzda;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('sw_term')]
  [Description('Tabulka s ip adresama na kterych je spusteny sw terminal')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsw_term = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('ip', [TColumnProp.Required], 50)]
    [Description('')]
    Fip: string;
    
    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property ip: string read Fip write Fip;
    property start: TDateTime read Fstart write Fstart;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('system')]
  [Description('Systemova tabulka')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsystem = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('version', [TColumnProp.Required], 20)]
    [Description('')]
    Fversion: string;
    
    [Column('table_version', [TColumnProp.Required], 20)]
    [Description('')]
    Ftable_version: string;
    
    [Column('program_id', [TColumnProp.Required], 30)]
    [Description('')]
    Fprogram_id: string;
    
    [Column('last_repair', [TColumnProp.Required])]
    [Description('')]
    Flast_repair: TDateTime;
    
    [Column('last_optimize', [TColumnProp.Required])]
    [Description('')]
    Flast_optimize: TDateTime;
    
    [Column('limit_sw_term', [TColumnProp.Required])]
    [Description('')]
    Flimit_sw_term: Integer;
    
    [Column('last_backup', [TColumnProp.Required])]
    [Description('')]
    Flast_backup: TDateTime;
    
    [Column('upgrade_locktables', [TColumnProp.Required])]
    [Description('')]
    Fupgrade_locktables: Integer;
    
    [Column('limit_vmt_term', [TColumnProp.Required])]
    [Description('')]
    Flimit_vmt_term: Integer;
    
    [Column('limit_smt_term', [TColumnProp.Required])]
    [Description('')]
    Flimit_smt_term: Integer;
    
    [Column('use_telemetry', [TColumnProp.Required])]
    [Description('')]
    Fuse_telemetry: Integer;
    
    [Column('betachannel', [TColumnProp.Required])]
    [Description('')]
    Fbetachannel: Integer;
    
    [Column('language_version', [TColumnProp.Required], 20)]
    [Description('')]
    Flanguage_version: string;
    
    [Column('bgs_last_run', [TColumnProp.Required])]
    [Description('')]
    Fbgs_last_run: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property version: string read Fversion write Fversion;
    property table_version: string read Ftable_version write Ftable_version;
    property program_id: string read Fprogram_id write Fprogram_id;
    property last_repair: TDateTime read Flast_repair write Flast_repair;
    property last_optimize: TDateTime read Flast_optimize write Flast_optimize;
    property limit_sw_term: Integer read Flimit_sw_term write Flimit_sw_term;
    property last_backup: TDateTime read Flast_backup write Flast_backup;
    property upgrade_locktables: Integer read Fupgrade_locktables write Fupgrade_locktables;
    property limit_vmt_term: Integer read Flimit_vmt_term write Flimit_vmt_term;
    property limit_smt_term: Integer read Flimit_smt_term write Flimit_smt_term;
    property use_telemetry: Integer read Fuse_telemetry write Fuse_telemetry;
    property betachannel: Integer read Fbetachannel write Fbetachannel;
    property language_version: string read Flanguage_version write Flanguage_version;
    property bgs_last_run: TDateTime read Fbgs_last_run write Fbgs_last_run;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('system_terminals')]
  [Description('Povolen funkce terminl u zamstnanc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsystem_terminals = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Required], 50)]
    [Description('')]
    Fnote: string;
    
    [Column('is_default', [TColumnProp.Required])]
    [Description('')]
    Fis_default: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property bar_id: string read Fbar_id write Fbar_id;
    property name: string read Fname write Fname;
    property note: string read Fnote write Fnote;
    property is_default: Integer read Fis_default write Fis_default;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('system_terminals_functions')]
  [Description('Povolen funkce terminl')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsystem_terminals_functions = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('terminal', [TColumnProp.Required], 50)]
    [Description('')]
    Fterminal: string;
    
    [Column('module', [TColumnProp.Required], 50)]
    [Description('')]
    Fmodule: string;
    
    [Column('enabled', [TColumnProp.Required])]
    [Description('')]
    Fenabled: Integer;
    
    [Column('note', [TColumnProp.Required], 300)]
    [Description('')]
    Fnote: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property terminal: string read Fterminal write Fterminal;
    property module: string read Fmodule write Fmodule;
    property enabled: Integer read Fenabled write Fenabled;
    property note: string read Fnote write Fnote;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('tech_postup')]
  [Description('Tabulka technologickych postupu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Ttech_postup = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnote: TBlob;

    [Column('cas_jednotky', [TColumnProp.Required])]
    [Description('')]
    Fcas_jednotky: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property note: TBlob read Fnote write Fnote;
    property cas_jednotky: Integer read Fcas_jednotky write Fcas_jednotky;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('tech_postup_polozky')]
  [Description('Tabulka polozek technologickych postupu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Ttech_postup_polozky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('postup_id', [TColumnProp.Required])]
    [Description('')]
    Fpostup_id: Int64;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('mnozstvi', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnozstvi: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property postup_id: Int64 read Fpostup_id write Fpostup_id;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property mnozstvi: Double read Fmnozstvi write Fmnozstvi;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('temp')]
  [Description('Pomocn tabulka')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Ttemp = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('int_value', [TColumnProp.Required])]
    [Description('')]
    Fint_value: Integer;
    
    [Column('int_value2', [TColumnProp.Required])]
    [Description('')]
    Fint_value2: Integer;
    
    [Column('int_value3', [TColumnProp.Required])]
    [Description('')]
    Fint_value3: Integer;
    
    [Column('int_value4', [TColumnProp.Required])]
    [Description('')]
    Fint_value4: Integer;
    
    [Column('int_value5', [TColumnProp.Required])]
    [Description('')]
    Fint_value5: Integer;
    
    [Column('int_value6', [TColumnProp.Required])]
    [Description('')]
    Fint_value6: Integer;
    
    [Column('int_value7', [TColumnProp.Required])]
    [Description('')]
    Fint_value7: Integer;
    
    [Column('int_value8', [TColumnProp.Required])]
    [Description('')]
    Fint_value8: Integer;
    
    [Column('int_value9', [TColumnProp.Required])]
    [Description('')]
    Fint_value9: Integer;
    
    [Column('int_value10', [TColumnProp.Required])]
    [Description('')]
    Fint_value10: Integer;
    
    [Column('int_value11', [TColumnProp.Required])]
    [Description('')]
    Fint_value11: Integer;
    
    [Column('int_value12', [TColumnProp.Required])]
    [Description('')]
    Fint_value12: Integer;
    
    [Column('int_value13', [TColumnProp.Required])]
    [Description('')]
    Fint_value13: Integer;
    
    [Column('int_value14', [TColumnProp.Required])]
    [Description('')]
    Fint_value14: Integer;
    
    [Column('int_value15', [TColumnProp.Required])]
    [Description('')]
    Fint_value15: Integer;
    
    [Column('int_value16', [TColumnProp.Required])]
    [Description('')]
    Fint_value16: Integer;
    
    [Column('int_value17', [TColumnProp.Required])]
    [Description('')]
    Fint_value17: Integer;
    
    [Column('int_value18', [TColumnProp.Required])]
    [Description('')]
    Fint_value18: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property int_value: Integer read Fint_value write Fint_value;
    property int_value2: Integer read Fint_value2 write Fint_value2;
    property int_value3: Integer read Fint_value3 write Fint_value3;
    property int_value4: Integer read Fint_value4 write Fint_value4;
    property int_value5: Integer read Fint_value5 write Fint_value5;
    property int_value6: Integer read Fint_value6 write Fint_value6;
    property int_value7: Integer read Fint_value7 write Fint_value7;
    property int_value8: Integer read Fint_value8 write Fint_value8;
    property int_value9: Integer read Fint_value9 write Fint_value9;
    property int_value10: Integer read Fint_value10 write Fint_value10;
    property int_value11: Integer read Fint_value11 write Fint_value11;
    property int_value12: Integer read Fint_value12 write Fint_value12;
    property int_value13: Integer read Fint_value13 write Fint_value13;
    property int_value14: Integer read Fint_value14 write Fint_value14;
    property int_value15: Integer read Fint_value15 write Fint_value15;
    property int_value16: Integer read Fint_value16 write Fint_value16;
    property int_value17: Integer read Fint_value17 write Fint_value17;
    property int_value18: Integer read Fint_value18 write Fint_value18;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('temp2')]
  [Description('Pomocn tabulka')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Ttemp2 = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('s1', [TColumnProp.Required], 200)]
    [Description('')]
    Fs1: string;
    
    [Column('s2', [TColumnProp.Required], 200)]
    [Description('')]
    Fs2: string;
    
    [Column('s3', [TColumnProp.Required], 200)]
    [Description('')]
    Fs3: string;
    
    [Column('s4', [TColumnProp.Required], 200)]
    [Description('')]
    Fs4: string;
    
    [Column('s5', [TColumnProp.Required], 200)]
    [Description('')]
    Fs5: string;
    
    [Column('s6', [TColumnProp.Required], 200)]
    [Description('')]
    Fs6: string;
    
    [Column('s7', [TColumnProp.Required], 100)]
    [Description('')]
    Fs7: string;
    
    [Column('s8', [TColumnProp.Required], 100)]
    [Description('')]
    Fs8: string;
    
    [Column('s9', [TColumnProp.Required], 100)]
    [Description('')]
    Fs9: string;
    
    [Column('s10', [TColumnProp.Required], 100)]
    [Description('')]
    Fs10: string;
    
    [Column('s11', [TColumnProp.Required], 100)]
    [Description('')]
    Fs11: string;
    
    [Column('s12', [TColumnProp.Required], 100)]
    [Description('')]
    Fs12: string;
    
    [Column('s13', [TColumnProp.Required], 100)]
    [Description('')]
    Fs13: string;
    
    [Column('s14', [TColumnProp.Required], 100)]
    [Description('')]
    Fs14: string;
    
    [Column('s15', [TColumnProp.Required], 100)]
    [Description('')]
    Fs15: string;
    
    [Column('s16', [TColumnProp.Required], 100)]
    [Description('')]
    Fs16: string;
    
    [Column('s17', [TColumnProp.Required], 100)]
    [Description('')]
    Fs17: string;
    
    [Column('s18', [TColumnProp.Required], 100)]
    [Description('')]
    Fs18: string;

    [Column('s19', [TColumnProp.Required], 100)]
    [Description('')]
    Fs19: string;
    
    [Column('s20', [TColumnProp.Required], 100)]
    [Description('')]
    Fs20: string;
    
    [Column('s21', [TColumnProp.Required], 100)]
    [Description('')]
    Fs21: string;
    
    [Column('s22', [TColumnProp.Required], 100)]
    [Description('')]
    Fs22: string;
    
    [Column('s23', [TColumnProp.Required], 100)]
    [Description('')]
    Fs23: string;
    
    [Column('s24', [TColumnProp.Required], 100)]
    [Description('')]
    Fs24: string;
    
    [Column('s25', [TColumnProp.Required], 100)]
    [Description('')]
    Fs25: string;
    
    [Column('s26', [TColumnProp.Required], 100)]
    [Description('')]
    Fs26: string;
    
    [Column('s27', [TColumnProp.Required], 100)]
    [Description('')]
    Fs27: string;
    
    [Column('s28', [TColumnProp.Required], 100)]
    [Description('')]
    Fs28: string;
    
    [Column('s29', [TColumnProp.Required], 100)]
    [Description('')]
    Fs29: string;
    
    [Column('s30', [TColumnProp.Required], 100)]
    [Description('')]
    Fs30: string;
    
    [Column('s31', [TColumnProp.Required], 100)]
    [Description('')]
    Fs31: string;
    
    [Column('s32', [TColumnProp.Required], 100)]
    [Description('')]
    Fs32: string;
    
    [Column('s33', [TColumnProp.Required], 100)]
    [Description('')]
    Fs33: string;
    
    [Column('s34', [TColumnProp.Required], 100)]
    [Description('')]
    Fs34: string;
    
    [Column('s35', [TColumnProp.Required], 100)]
    [Description('')]
    Fs35: string;
    
    [Column('s36', [TColumnProp.Required], 100)]
    [Description('')]
    Fs36: string;
    
    [Column('s37', [TColumnProp.Required], 100)]
    [Description('')]
    Fs37: string;
    
    [Column('s38', [TColumnProp.Required], 100)]
    [Description('')]
    Fs38: string;
    
    [Column('s39', [TColumnProp.Required], 100)]
    [Description('')]
    Fs39: string;
    
    [Column('s40', [TColumnProp.Required], 100)]
    [Description('')]
    Fs40: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property s1: string read Fs1 write Fs1;
    property s2: string read Fs2 write Fs2;
    property s3: string read Fs3 write Fs3;
    property s4: string read Fs4 write Fs4;
    property s5: string read Fs5 write Fs5;
    property s6: string read Fs6 write Fs6;
    property s7: string read Fs7 write Fs7;
    property s8: string read Fs8 write Fs8;
    property s9: string read Fs9 write Fs9;
    property s10: string read Fs10 write Fs10;
    property s11: string read Fs11 write Fs11;
    property s12: string read Fs12 write Fs12;
    property s13: string read Fs13 write Fs13;
    property s14: string read Fs14 write Fs14;
    property s15: string read Fs15 write Fs15;
    property s16: string read Fs16 write Fs16;
    property s17: string read Fs17 write Fs17;
    property s18: string read Fs18 write Fs18;
    property s19: string read Fs19 write Fs19;
    property s20: string read Fs20 write Fs20;
    property s21: string read Fs21 write Fs21;
    property s22: string read Fs22 write Fs22;
    property s23: string read Fs23 write Fs23;
    property s24: string read Fs24 write Fs24;
    property s25: string read Fs25 write Fs25;
    property s26: string read Fs26 write Fs26;
    property s27: string read Fs27 write Fs27;
    property s28: string read Fs28 write Fs28;
    property s29: string read Fs29 write Fs29;
    property s30: string read Fs30 write Fs30;
    property s31: string read Fs31 write Fs31;
    property s32: string read Fs32 write Fs32;
    property s33: string read Fs33 write Fs33;
    property s34: string read Fs34 write Fs34;
    property s35: string read Fs35 write Fs35;
    property s36: string read Fs36 write Fs36;
    property s37: string read Fs37 write Fs37;
    property s38: string read Fs38 write Fs38;
    property s39: string read Fs39 write Fs39;
    property s40: string read Fs40 write Fs40;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('terminal')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tterminal = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('ip', [], 15)]
    [Description('')]
    Fip: Nullable<string>;
    
    [Column('typ_terminalu', [])]
    [Description('')]
    Ftyp_terminalu: Nullable<Integer>;
    
    [Column('worker_id', [])]
    [Description('')]
    Fworker_id: Nullable<Integer>;
    
    [Column('povolit_prijemky', [TColumnProp.Required])]
    [Description('')]
    Fpovolit_prijemky: Integer;
    
    [Column('povolit_vydejky', [TColumnProp.Required])]
    [Description('')]
    Fpovolit_vydejky: Integer;
    
    [Column('vytvaret_zakazku', [TColumnProp.Required])]
    [Description('')]
    Fvytvaret_zakazku: Integer;
    
    [Column('SerialNumber', [TColumnProp.Required], 100)]
    [Description('')]
    FSerialNumber: string;
    
    [Column('APIkey', [TColumnProp.Required], 100)]
    [Description('')]
    FAPIkey: string;
    
    [Column('HASHcode', [TColumnProp.Required], 100)]
    [Description('')]
    FHASHcode: string;
    
    [Column('note', [TColumnProp.Required], 250)]
    [Description('')]
    Fnote: string;
    
    [Column('terminalName', [TColumnProp.Required], 100)]
    [Description('')]
    FterminalName: string;
    
    [Column('BasicConfiguration', [TColumnProp.Required], 2048)]
    [Description('')]
    FBasicConfiguration: string;
    
    [Column('FullConfiguration', [TColumnProp.Lazy])]
    [Description('')]
    FFullConfiguration: TBlob;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property ip: Nullable<string> read Fip write Fip;
    property typ_terminalu: Nullable<Integer> read Ftyp_terminalu write Ftyp_terminalu;
    property worker_id: Nullable<Integer> read Fworker_id write Fworker_id;
    property povolit_prijemky: Integer read Fpovolit_prijemky write Fpovolit_prijemky;
    property povolit_vydejky: Integer read Fpovolit_vydejky write Fpovolit_vydejky;
    property vytvaret_zakazku: Integer read Fvytvaret_zakazku write Fvytvaret_zakazku;
    property SerialNumber: string read FSerialNumber write FSerialNumber;
    property APIkey: string read FAPIkey write FAPIkey;
    property HASHcode: string read FHASHcode write FHASHcode;
    property note: string read Fnote write Fnote;
    property terminalName: string read FterminalName write FterminalName;
    property BasicConfiguration: string read FBasicConfiguration write FBasicConfiguration;
    property FullConfiguration: TBlob read FFullConfiguration write FFullConfiguration;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('terminal_typ')]
  [Description('typy terminl')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tterminal_typ = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('typ', [TColumnProp.Required], 50)]
    [Description('')]
    Ftyp: string;
    
    [Column('note', [TColumnProp.Required], 50)]
    [Description('')]
    Fnote: string;
    
    [Column('licenci', [TColumnProp.Required])]
    [Description('')]
    Flicenci: Integer;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_changed', [TColumnProp.Required])]
    [Description('')]
    Fts_changed: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property typ: string read Ftyp write Ftyp;
    property note: string read Fnote write Fnote;
    property licenci: Integer read Flicenci write Flicenci;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_changed: TDateTime read Fts_changed write Fts_changed;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('tisk_formulare')]
  [Description('Formule tiskovch sestav')]
  [Id('Fid', TIdGenerator.None)]
  [Id('Fidhlavicka', TIdGenerator.None)]
  Ttisk_formulare = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('idhlavicka', [TColumnProp.Required])]
    [Description('')]
    Fidhlavicka: Integer;
    
    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    
    [Column('cesta', [TColumnProp.Required], 500)]
    [Description('')]
    Fcesta: string;
    
    [Column('kmen', [TColumnProp.Required])]
    [Description('')]
    Fkmen: Integer;
    
    [Column('typ', [TColumnProp.Required], 1)]
    [Description('')]
    Ftyp: string;
    
    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property idhlavicka: Integer read Fidhlavicka write Fidhlavicka;
    property nazev: string read Fnazev write Fnazev;
    property cesta: string read Fcesta write Fcesta;
    property kmen: Integer read Fkmen write Fkmen;
    property typ: string read Ftyp write Ftyp;
    property stav: Integer read Fstav write Fstav;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('tisk_hlavicka')]
  [Description('Hlaviky tiskovch sestav')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Ttisk_hlavicka = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nadpis', [TColumnProp.Required], 100)]
    [Description('')]
    Fnadpis: string;
    
    [Column('slozka', [TColumnProp.Required], 150)]
    [Description('')]
    Fslozka: string;
    
    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nadpis: string read Fnadpis write Fnadpis;
    property slozka: string read Fslozka write Fslozka;
    property stav: Integer read Fstav write Fstav;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('tisk_hlavicka_nazvy')]
  [Description('Peklad pro lidi nzv adres tisk')]
  [Id('Fslozka', TIdGenerator.None)]
  Ttisk_hlavicka_nazvy = class(TTMSAGObject)
  private
    [Column('slozka', [TColumnProp.Required], 100)]
    [Description('')]
    Fslozka: string;
    
    [Column('nazev_cz', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev_cz: string;
    
    [Column('nazev_en', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev_en: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property slozka: string read Fslozka write Fslozka;
    property nazev_cz: string read Fnazev_cz write Fnazev_cz;
    property nazev_en: string read Fnazev_en write Fnazev_en;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('tisk_prava')]
  [Description('Prva tiskovch sestav')]
  [Id('Fid', TIdGenerator.None)]
  [Id('Ftisk_id', TIdGenerator.None)]
  Ttisk_prava = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('tisk_id', [TColumnProp.Required])]
    [Description('')]
    Ftisk_id: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;
    
    [Column('profese_id', [TColumnProp.Required])]
    [Description('')]
    Fprofese_id: Integer;
    
    [Column('obecne', [TColumnProp.Required], 100)]
    [Description('')]
    Fobecne: string;
    
    [Column('stav', [TColumnProp.Required])]
    [Description('')]
    Fstav: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property tisk_id: Integer read Ftisk_id write Ftisk_id;
    property user_id: Integer read Fuser_id write Fuser_id;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property profese_id: Integer read Fprofese_id write Fprofese_id;
    property obecne: string read Fobecne write Fobecne;
    property stav: Integer read Fstav write Fstav;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('typ_baleni')]
  [Description('')]
  [Id('Fid_typbaleni', TIdGenerator.IdentityOrSequence)]
  Ttyp_baleni = class(TTMSAGObject)
  private
    [Column('id_typbaleni', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_typbaleni: Integer;
    
    [Column('typ_dopravy', [])]
    [Description('')]
    Ftyp_dopravy: Nullable<Integer>;
    
    [Column('kod', [], 3)]
    [Description('')]
    Fkod: Nullable<string>;
    
    [Column('popis', [], 50)]
    [Description('')]
    Fpopis: Nullable<string>;
    
    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_typbaleni: Integer read Fid_typbaleni write Fid_typbaleni;
    property typ_dopravy: Nullable<Integer> read Ftyp_dopravy write Ftyp_dopravy;
    property kod: Nullable<string> read Fkod write Fkod;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property vychozi: Integer read Fvychozi write Fvychozi;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('typ_zasilky')]
  [Description('')]
  [Id('Fid_typdopravy', TIdGenerator.IdentityOrSequence)]
  Ttyp_zasilky = class(TTMSAGObject)
  private
    [Column('id_typdopravy', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid_typdopravy: Integer;
    
    [Column('id_doprava', [])]
    [Description('')]
    Fid_doprava: Nullable<Integer>;
    
    [Column('popis', [], 50)]
    [Description('')]
    Fpopis: Nullable<string>;
    
    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id_typdopravy: Integer read Fid_typdopravy write Fid_typdopravy;
    property id_doprava: Nullable<Integer> read Fid_doprava write Fid_doprava;
    property popis: Nullable<string> read Fpopis write Fpopis;
    property vychozi: Integer read Fvychozi write Fvychozi;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ukolmzda_typ')]
  [Description('Tabulka kolov mzdy')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tukolmzda_typ = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('typ_vypoctu', [TColumnProp.Required])]
    [Description('')]
    Ftyp_vypoctu: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;
    
    [Column('nazev', [TColumnProp.Required], 255)]
    [Description('')]
    Fnazev: string;
    
    [Column('popis', [TColumnProp.Required], 255)]
    [Description('')]
    Fpopis: string;
    
    [Column('vzorec', [TColumnProp.Required], 255)]
    [Description('')]
    Fvzorec: string;
    
    [Column('w_p', [TColumnProp.Required])]
    [Description('')]
    Fw_p: Boolean;
    
    [Column('wk_p', [TColumnProp.Required])]
    [Description('')]
    Fwk_p: Boolean;
    
    [Column('ph_p', [TColumnProp.Required])]
    [Description('')]
    Fph_p: Boolean;
    
    [Column('pj_p', [TColumnProp.Required])]
    [Description('')]
    Fpj_p: Boolean;
    
    [Column('oh_p', [TColumnProp.Required])]
    [Description('')]
    Foh_p: Boolean;
    
    [Column('oj_p', [TColumnProp.Required])]
    [Description('')]
    Foj_p: Boolean;
    
    [Column('st_p', [TColumnProp.Required])]
    [Description('')]
    Fst_p: Boolean;
    
    [Column('visible', [TColumnProp.Required])]
    [Description('')]
    Fvisible: Boolean;
    
    [Column('readonly', [TColumnProp.Required])]
    [Description('')]
    Freadonly: Integer;
    
    [Column('call_external', [TColumnProp.Required])]
    [Description('')]
    Fcall_external: Boolean;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    property id: Integer read Fid write Fid;
    property typ_vypoctu: Integer read Ftyp_vypoctu write Ftyp_vypoctu;
    property poradi: Integer read Fporadi write Fporadi;
    property nazev: string read Fnazev write Fnazev;
    property popis: string read Fpopis write Fpopis;
    property vzorec: string read Fvzorec write Fvzorec;
    property w_p: Boolean read Fw_p write Fw_p;
    property wk_p: Boolean read Fwk_p write Fwk_p;
    property ph_p: Boolean read Fph_p write Fph_p;
    property pj_p: Boolean read Fpj_p write Fpj_p;
    property oh_p: Boolean read Foh_p write Foh_p;
    property oj_p: Boolean read Foj_p write Foj_p;
    property st_p: Boolean read Fst_p write Fst_p;
    property visible: Boolean read Fvisible write Fvisible;
    property readonly: Integer read Freadonly write Freadonly;
    property call_external: Boolean read Fcall_external write Fcall_external;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ukoly')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tukoly = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 255)]
    [Description('')]
    Fnazev: string;
    
    [Column('termin', [TColumnProp.Required])]
    [Description('')]
    Ftermin: TDateTime;
    
    [Column('resitel_id', [TColumnProp.Required])]
    [Description('')]
    Fresitel_id: Integer;
    
    [Column('zadavatel_id', [TColumnProp.Required])]
    [Description('')]
    Fzadavatel_id: Integer;
    
    [Column('popis', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fpopis: TBlob;
    
    [Column('reakce', [], 255)]
    [Description('')]
    Freakce: Nullable<string>;
    
    [Column('stav_id', [TColumnProp.Required])]
    [Description('')]
    Fstav_id: Integer;
    
    [Column('opakovani_id', [TColumnProp.Required])]
    [Description('')]
    Fopakovani_id: Integer;
    
    [Column('opakovani_interval', [TColumnProp.Required], 100)]
    [Description('')]
    Fopakovani_interval: string;
    
    [Column('opakovani_param1', [TColumnProp.Required], 100)]
    [Description('')]
    Fopakovani_param1: string;
    
    [Column('podminka_id', [TColumnProp.Required])]
    [Description('')]
    Fpodminka_id: Integer;
    
    [Column('podminka_param1', [TColumnProp.Required], 100)]
    [Description('')]
    Fpodminka_param1: string;
    
    [Column('podminka_param2', [TColumnProp.Required], 100)]
    [Description('')]
    Fpodminka_param2: string;
    
    [Column('podminka_param3', [TColumnProp.Required], 100)]
    [Description('')]
    Fpodminka_param3: string;
    
    [Column('zmena', [TColumnProp.Required])]
    [Description('')]
    Fzmena: TDateTime;
    
    [Column('cnc_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_id: Integer;
    
    [Column('picture', [TColumnProp.Required], 100)]
    [Description('')]
    Fpicture: string;

    [Column('urceno', [TColumnProp.Required], 100)]
    [Description('')]
    Furceno: string;

    [Column('zmenil_stav', [TColumnProp.Required])]
    [Description('')]
    Fzmenil_stav: Integer;

    [Column('schvalit', [TColumnProp.Required])]
    [Description('')]
    Fschvalit: Integer;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('user_time', [TColumnProp.Required])]
    [Description('')]
    Fuser_time: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property termin: TDateTime read Ftermin write Ftermin;
    property resitel_id: Integer read Fresitel_id write Fresitel_id;
    property zadavatel_id: Integer read Fzadavatel_id write Fzadavatel_id;
    property popis: TBlob read Fpopis write Fpopis;
    property reakce: Nullable<string> read Freakce write Freakce;
    property stav_id: Integer read Fstav_id write Fstav_id;
    property opakovani_id: Integer read Fopakovani_id write Fopakovani_id;
    property opakovani_interval: string read Fopakovani_interval write Fopakovani_interval;
    property opakovani_param1: string read Fopakovani_param1 write Fopakovani_param1;
    property podminka_id: Integer read Fpodminka_id write Fpodminka_id;
    property podminka_param1: string read Fpodminka_param1 write Fpodminka_param1;
    property podminka_param2: string read Fpodminka_param2 write Fpodminka_param2;
    property podminka_param3: string read Fpodminka_param3 write Fpodminka_param3;
    property zmena: TDateTime read Fzmena write Fzmena;
    property cnc_id: Integer read Fcnc_id write Fcnc_id;
    property picture: string read Fpicture write Fpicture;
    property urceno: string read Furceno write Furceno;
    property zmenil_stav: Integer read Fzmenil_stav write Fzmenil_stav;
    property schvalit: Integer read Fschvalit write Fschvalit;
    property priorita: Integer read Fpriorita write Fpriorita;
    property user_time: Integer read Fuser_time write Fuser_time;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ukoly_opakovani')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tukoly_opakovani = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    
    [Column('interval', [TColumnProp.Required], 100)]
    [Description('')]
    Finterval: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property interval: string read Finterval write Finterval;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ukoly_podminky')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tukoly_podminky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    
    [Column('kod', [TColumnProp.Required], 50)]
    [Description('')]
    Fkod: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property kod: string read Fkod write Fkod;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('ukoly_stavy')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tukoly_stavy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    
    [Column('aktivni', [TColumnProp.Required], 1)]
    [Description('')]
    Faktivni: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property aktivni: string read Faktivni write Faktivni;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('userlist')]
  [Description('Pihlen uivatel')]
  [Id('FcomputerId', TIdGenerator.None)]
  [Id('Fuser', TIdGenerator.None)]
  Tuserlist = class(TTMSAGObject)
  private
    [Column('computerId', [TColumnProp.Required], 50)]
    [Description('')]
    FcomputerId: string;
    
    [Column('user', [TColumnProp.Required], 255)]
    [Description('')]
    Fuser: string;
    
    [Column('computerName', [TColumnProp.Required], 40)]
    [Description('')]
    FcomputerName: string;
    
    [Column('loginTime', [TColumnProp.Required])]
    [Description('')]
    FloginTime: TDateTime;
    
    [Column('lastActivity', [TColumnProp.Required])]
    [Description('')]
    FlastActivity: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property computerId: string read FcomputerId write FcomputerId;
    property user: string read Fuser write Fuser;
    property computerName: string read FcomputerName write FcomputerName;
    property loginTime: TDateTime read FloginTime write FloginTime;
    property lastActivity: TDateTime read FlastActivity write FlastActivity;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('users')]
  [Description('Uzivatele s pravem prihlaseni k aplikaci')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tusers = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 30)]
    [Description('')]
    Fname: string;
    
    [Column('password', [TColumnProp.Required], 15)]
    [Description('')]
    Fpassword: string;
    
    [Column('acess', [])]
    [Description('')]
    Facess: Integer;
    
    [Column('prv_01', [TColumnProp.Required])]
    [Description('')]
    Fprv_01: Int64;
    
    [Column('set_01', [TColumnProp.Required])]
    [Description('')]
    Fset_01: Int64;
    
    [Column('prv_02', [TColumnProp.Required])]
    [Description('')]
    Fprv_02: Int64;
    
    [Column('set_02', [TColumnProp.Required])]
    [Description('')]
    Fset_02: Int64;
    
    [Column('prv_03', [TColumnProp.Required])]
    [Description('')]
    Fprv_03: Int64;
    
    [Column('set_03', [TColumnProp.Required])]
    [Description('')]
    Fset_03: Int64;
    
    [Column('prv_04', [TColumnProp.Required])]
    [Description('')]
    Fprv_04: Int64;
    
    [Column('set_04', [TColumnProp.Required])]
    [Description('')]
    Fset_04: Int64;
    
    [Column('prv_05', [TColumnProp.Required])]
    [Description('')]
    Fprv_05: Int64;
    
    [Column('set_05', [TColumnProp.Required])]
    [Description('')]
    Fset_05: Int64;
    
    [Column('prv_06', [TColumnProp.Required])]
    [Description('')]
    Fprv_06: Int64;

    [Column('set_06', [TColumnProp.Required])]
    [Description('')]
    Fset_06: Int64;
    
    [Column('prv_07', [TColumnProp.Required])]
    [Description('')]
    Fprv_07: Int64;
    
    [Column('set_07', [TColumnProp.Required])]
    [Description('')]
    Fset_07: Int64;
    
    [Column('prv_08', [TColumnProp.Required])]
    [Description('')]
    Fprv_08: Int64;
    
    [Column('set_08', [TColumnProp.Required])]
    [Description('')]
    Fset_08: Int64;
    
    [Column('prv_09', [TColumnProp.Required])]
    [Description('')]
    Fprv_09: Int64;
    
    [Column('set_09', [TColumnProp.Required])]
    [Description('')]
    Fset_09: Int64;
    
    [Column('prv_10', [TColumnProp.Required])]
    [Description('')]
    Fprv_10: Int64;
    
    [Column('set_10', [TColumnProp.Required])]
    [Description('')]
    Fset_10: Int64;
    
    [Column('prv_11', [TColumnProp.Required])]
    [Description('')]
    Fprv_11: Int64;
    
    [Column('set_11', [TColumnProp.Required])]
    [Description('')]
    Fset_11: Int64;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('use_worker_id', [], 'id')]
    Fuse_worker_id: proxy<Tworker>;

    [Column('vedouci_skupiny', [TColumnProp.Required], 512)]
    [Description('')]
    Fvedouci_skupiny: string;
    
    [Column('mistr', [TColumnProp.Required], 1024)]
    [Description('')]
    Fmistr: string;
    
    [Column('stavy', [TColumnProp.Required], 1024)]
    [Description('')]
    Fstavy: string;
    
    [Column('prv_12', [TColumnProp.Required])]
    [Description('')]
    Fprv_12: Int64;
    
    [Column('set_12', [TColumnProp.Required])]
    [Description('')]
    Fset_12: Int64;
    
    [Column('prv_13', [TColumnProp.Required])]
    [Description('')]
    Fprv_13: Int64;
    
    [Column('set_13', [TColumnProp.Required])]
    [Description('')]
    Fset_13: Int64;
    
    [Column('prv_14', [TColumnProp.Required])]
    [Description('')]
    Fprv_14: Int64;
    
    [Column('set_14', [TColumnProp.Required])]
    [Description('')]
    Fset_14: Int64;
    
    [Column('prv_15', [TColumnProp.Required])]
    [Description('')]
    Fprv_15: Int64;
    
    [Column('set_15', [TColumnProp.Required])]
    [Description('')]
    Fset_15: Int64;
    
    [Column('prv_16', [TColumnProp.Required])]
    [Description('')]
    Fprv_16: Int64;
    
    [Column('set_16', [TColumnProp.Required])]
    [Description('')]
    Fset_16: Int64;
    
    [Column('gdpr_group', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_group: Integer;
    
    [Column('password2', [TColumnProp.Required], 128)]
    [Description('')]
    Fpassword2: string;
    
    [Column('password2change', [TColumnProp.Required])]
    [Description('')]
    Fpassword2change: TDateTime;
    
    [Column('login_counter', [TColumnProp.Required])]
    [Description('')]
    Flogin_counter: Integer;

    [Column('pristup_sm_readdata', [TColumnProp.Required])]
    [Description('')]
    Fpristup_sm_readdata: Integer;
    
    [Column('pristup_zakazky', [TColumnProp.Required])]
    [Description('')]
    Fpristup_zakazky: Integer;
    
    [Column('EditaceStavu', [TColumnProp.Required], 1024)]
    [Description('')]
    FEditaceStavu: string;

    [Column('prv_17', [TColumnProp.Required])]
    [Description('')]
    Fprv_17: Int64;
    
    [Column('prv_18', [TColumnProp.Required])]
    [Description('')]
    Fprv_18: Int64;
    
    [Column('prv_19', [TColumnProp.Required])]
    [Description('')]
    Fprv_19: Int64;
    
    [Column('prv_20', [TColumnProp.Required])]
    [Description('')]
    Fprv_20: Int64;
    
    [Column('prv_21', [TColumnProp.Required])]
    [Description('')]
    Fprv_21: Int64;
    
    [Column('prv_22', [TColumnProp.Required])]
    [Description('')]
    Fprv_22: Int64;
    
    [Column('prv_23', [TColumnProp.Required])]
    [Description('')]
    Fprv_23: Int64;
    
    [Column('prv_24', [TColumnProp.Required])]
    [Description('')]
    Fprv_24: Int64;
    
    [Column('prv_25', [TColumnProp.Required])]
    [Description('')]
    Fprv_25: Int64;
    
    [Column('prv_26', [TColumnProp.Required])]
    [Description('')]
    Fprv_26: Int64;
    
    [Column('prv_27', [TColumnProp.Required])]
    [Description('')]
    Fprv_27: Int64;
    
    [Column('prv_28', [TColumnProp.Required])]
    [Description('')]
    Fprv_28: Int64;
    
    [Column('prv_29', [TColumnProp.Required])]
    [Description('')]
    Fprv_29: Int64;
    
    [Column('prv_30', [TColumnProp.Required])]
    [Description('')]
    Fprv_30: Int64;
    
    [Column('prv_31', [TColumnProp.Required])]
    [Description('')]
    Fprv_31: Int64;
    
    [Column('prv_32', [TColumnProp.Required])]
    [Description('')]
    Fprv_32: Int64;

    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive : boolean;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fuser_id')]
    Fref_users_user_rolesList: Proxy<TList<Tref_users_user_roles>>;

    FDynCon: TDynamicProperties;
    function getRef_users_user_rolesList : TList<Tref_users_user_roles>;
    procedure setuse_worker_id (const AValue : Tworker);
    function getuse_worker_id : Tworker;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property password: string read Fpassword write Fpassword;
    property acess: Integer read Facess write Facess;
    property prv_01: Int64 read Fprv_01 write Fprv_01;
    property set_01: Int64 read Fset_01 write Fset_01;
    property prv_02: Int64 read Fprv_02 write Fprv_02;
    property set_02: Int64 read Fset_02 write Fset_02;
    property prv_03: Int64 read Fprv_03 write Fprv_03;
    property set_03: Int64 read Fset_03 write Fset_03;
    property prv_04: Int64 read Fprv_04 write Fprv_04;
    property set_04: Int64 read Fset_04 write Fset_04;
    property prv_05: Int64 read Fprv_05 write Fprv_05;
    property set_05: Int64 read Fset_05 write Fset_05;
    property prv_06: Int64 read Fprv_06 write Fprv_06;
    property set_06: Int64 read Fset_06 write Fset_06;
    property prv_07: Int64 read Fprv_07 write Fprv_07;
    property set_07: Int64 read Fset_07 write Fset_07;
    property prv_08: Int64 read Fprv_08 write Fprv_08;
    property set_08: Int64 read Fset_08 write Fset_08;
    property prv_09: Int64 read Fprv_09 write Fprv_09;
    property set_09: Int64 read Fset_09 write Fset_09;
    property prv_10: Int64 read Fprv_10 write Fprv_10;
    property set_10: Int64 read Fset_10 write Fset_10;
    property prv_11: Int64 read Fprv_11 write Fprv_11;
    property set_11: Int64 read Fset_11 write Fset_11;
    property use_worker_id: Tworker read getuse_worker_id  write setuse_worker_id;
    property vedouci_skupiny: string read Fvedouci_skupiny write Fvedouci_skupiny;
    property mistr: string read Fmistr write Fmistr;
    property stavy: string read Fstavy write Fstavy;
    property prv_12: Int64 read Fprv_12 write Fprv_12;
    property set_12: Int64 read Fset_12 write Fset_12;
    property prv_13: Int64 read Fprv_13 write Fprv_13;
    property set_13: Int64 read Fset_13 write Fset_13;
    property prv_14: Int64 read Fprv_14 write Fprv_14;
    property set_14: Int64 read Fset_14 write Fset_14;
    property prv_15: Int64 read Fprv_15 write Fprv_15;
    property set_15: Int64 read Fset_15 write Fset_15;
    property prv_16: Int64 read Fprv_16 write Fprv_16;
    property set_16: Int64 read Fset_16 write Fset_16;
    property gdpr_group: Integer read Fgdpr_group write Fgdpr_group;
    property password2: string read Fpassword2 write Fpassword2;
    property password2change: TDateTime read Fpassword2change write Fpassword2change;
    property login_counter: Integer read Flogin_counter write Flogin_counter;
    property pristup_sm_readdata: Integer read Fpristup_sm_readdata write Fpristup_sm_readdata;
    property pristup_zakazky: Integer read Fpristup_zakazky write Fpristup_zakazky;
    property EditaceStavu: string read FEditaceStavu write FEditaceStavu;
    property prv_17: Int64 read Fprv_17 write Fprv_17;
    property prv_18: Int64 read Fprv_18 write Fprv_18;
    property prv_19: Int64 read Fprv_19 write Fprv_19;
    property prv_20: Int64 read Fprv_20 write Fprv_20;
    property prv_21: Int64 read Fprv_21 write Fprv_21;
    property prv_22: Int64 read Fprv_22 write Fprv_22;
    property prv_23: Int64 read Fprv_23 write Fprv_23;
    property prv_24: Int64 read Fprv_24 write Fprv_24;
    property prv_25: Int64 read Fprv_25 write Fprv_25;
    property prv_26: Int64 read Fprv_26 write Fprv_26;
    property prv_27: Int64 read Fprv_27 write Fprv_27;
    property prv_28: Int64 read Fprv_28 write Fprv_28;
    property prv_29: Int64 read Fprv_29 write Fprv_29;
    property prv_30: Int64 read Fprv_30 write Fprv_30;
    property prv_31: Int64 read Fprv_31 write Fprv_31;
    property prv_32: Int64 read Fprv_32 write Fprv_32;
    property active: boolean read Factive write Factive;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ref_users_user_rolesList: TList<Tref_users_user_roles> read getRef_users_user_rolesList;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('user_default_view_settings')]
  [Description('Nastaven vchozch pohled')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_default_view_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('agenda', [TColumnProp.Required], 80)]
    [Description('')]
    Fagenda: string;
    
    [Column('pohled_id', [TColumnProp.Required])]
    [Description('')]
    Fpohled_id: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property agenda: string read Fagenda write Fagenda;
    property pohled_id: Integer read Fpohled_id write Fpohled_id;
    property user_id: Integer read Fuser_id write Fuser_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('user_filter_settings')]
  [Description('nastaven filtr')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_filter_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('form_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fform_name: string;
    
    [Column('ts_name', [TColumnProp.Required], 100)]
    [Description('')]
    Fts_name: string;
    
    [Column('definition', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fdefinition: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property form_name: string read Fform_name write Fform_name;
    property ts_name: string read Fts_name write Fts_name;
    property definition: TBlob read Fdefinition write Fdefinition;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('user_menu')]
  [Description('')]
  [Id('FID', TIdGenerator.IdentityOrSequence)]
  Tuser_menu = class(TTMSAGObject)
  private
    [Column('ID', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    FID: Integer;

    [Column('menu', [TColumnProp.Required], 50)]
    [Description('')]
    Fmenu: string;

    [Column('shortcut', [TColumnProp.Required], 50)]
    [Description('')]
    Fshortcut: string;

    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;

    [Column('url', [TColumnProp.Required], 200)]
    [Description('')]
    Furl: string;

    [Column('all_users', [TColumnProp.Required])]
    [Description('')]
    Fall_users: boolean;

    [Column('targettype', [TColumnProp.Required])]
    [Description('')]
    Ftargettype: Integer;

    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;

    [Column('end_group', [TColumnProp.Required])]
    [Description('')]
    Fend_group: Boolean;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('user_view_id', [], 'id')]
    [Description('')]
    Fuser_view_id: proxy<Tuser_view_settings>;

    [ManyValuedAssociation([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeAllRemoveOrphan, 'Fuser_menu_id')]
    Fuser_menu_usersList: Proxy<TList<Tuser_menu_users>>;
    function Getuser_menu_usersList: TList<Tuser_menu_users>;
    function getuser_view_id: Tuser_view_settings;
    procedure setuser_view_id(const Value : Tuser_view_settings);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property ID: Integer read FID write FID;
    property menu: string read Fmenu write Fmenu;
    property shortcut: string read Fshortcut write Fshortcut;
    property name: string read Fname write Fname;
    property url: string read Furl write Furl;
    property all_users: boolean read Fall_users write Fall_users;
    property targettype: Integer read Ftargettype write Ftargettype;
    property poradi: Integer read Fporadi write Fporadi;
    property end_group: Boolean read Fend_group write Fend_group;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property user_view_id: Tuser_view_settings read getuser_view_id write setuser_view_id;
    property user_menu_usersList: TList<Tuser_menu_users> read Getuser_menu_usersList;
  end;

  [Entity]
  [Table('user_menu_users')]
  [Description('')]
  [Id('FID', TIdGenerator.IdentityOrSequence)]
  Tuser_menu_users = class(TTMSAGObject)
  private
    [Column('ID', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    FID: Integer;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('user_menu_id', [], 'ID')]
    [Description('')]
    Fuser_menu_id: proxy<Tuser_menu>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('user_id', [], 'id')]
    [Description('')]
    Fuser_id: proxy<Tusers>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    function getuser_menu_id: Tuser_menu;
    procedure setuser_menu_id(const Value : Tuser_menu);
    function getuser_id: Tusers;
    procedure setuser_id(const Value : Tusers);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property ID: Integer read FID write FID;
    property DynCon: TDynamicProperties read FDynCon;
    property user_menu_id: Tuser_menu read getuser_menu_id write setuser_menu_id;
    property user_id: Tusers read getuser_id write setuser_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
  end;
  
  [Entity]
  [Table('user_print_settings')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_print_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('ts_name', [], 150)]
    [Description('')]
    Fts_name: Nullable<string>;
    
    [Column('printer_name', [], 100)]
    [Description('')]
    Fprinter_name: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property user_id: Integer read Fuser_id write Fuser_id;
    property ts_name: Nullable<string> read Fts_name write Fts_name;
    property printer_name: Nullable<string> read Fprinter_name write Fprinter_name;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('user_roles')]
  [Description('Uivatelsk role')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_roles = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 30)]
    [Description('')]
    Fname: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Frole_id')]
    Fref_users_user_rolesList: Proxy<TList<Tref_user_roles_users>>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Frole_id')]
    Fuser_roles_forbiden_rightsList: Proxy<TList<Tuser_roles_forbiden_rights>>;

    function getRef_users_user_rolesList : TList<Tref_user_roles_users>;
    function getuser_roles_forbiden_rightsList: TList<Tuser_roles_forbiden_rights>;

  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    function CheckRecord(var aMessage: String): Boolean; override;
    function CanDeleteRecord (var aMessage : string) : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
    property ref_users_user_rolesList: TList<Tref_user_roles_users> read getref_users_user_rolesList;
    property user_roles_forbiden_rightsList: TList<Tuser_roles_forbiden_rights> read getuser_roles_forbiden_rightsList;
  end;

  [Entity]
  [Table('user_roles_forbiden_rights')]
  [Description('Tabulka zakzanch prv rolm')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_roles_forbiden_rights = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('role_id', [], 'id')]
    [Description('')]
    Frole_id: proxy<Tuser_roles>;

    [Column('agenda', [TColumnProp.Required], 30)]
    [Description('')]
    Fagenda: string;

    [Column('function_id', [TColumnProp.Required])]
    [Description('')]
    Ffunction_id: integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;

    procedure setrole_id (const AValue : Tuser_roles);
    function getrole_id : Tuser_roles;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property role_id: Tuser_roles read getrole_id write setrole_id;
    property agenda: string read Fagenda write Fagenda;
    property function_id: integer read Ffunction_id write Ffunction_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('user_settings')]
  [Description('Tabulka nastaveni')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('format_hodin', [TColumnProp.Required], 32)]
    [Description('')]
    Fformat_hodin: string;

    [Column('zakazka_timeout', [TColumnProp.Required], 32)]
    [Description('')]
    Fzakazka_timeout: string;

    [Column('auto_select_group', [TColumnProp.Required], 32)]
    [Description('')]
    Fauto_select_group: string;

    [Column('show_datacol_toppan', [TColumnProp.Required], 32)]
    [Description('')]
    Fshow_datacol_toppan: string;

    [Column('order_stavyrazeni', [TColumnProp.Required], 32)]
    [Description('')]
    Forder_stavyrazeni: string;
    
    [Column('btn_import', [TColumnProp.Required], 32)]
    [Description('')]
    Fbtn_import: string;
    
    [Column('btn_calc', [TColumnProp.Required], 32)]
    [Description('')]
    Fbtn_calc: string;
    
    [Column('bar_format', [TColumnProp.Required], 32)]
    [Description('')]
    Fbar_format: string;
    
    [Column('proskrtavat_dochazku', [TColumnProp.Required], 32)]
    [Description('')]
    Fproskrtavat_dochazku: string;
    
    [Column('proskrtavaci_znak', [TColumnProp.Required], 32)]
    [Description('')]
    Fproskrtavaci_znak: string;

    [Column('sberdat_odprac', [TColumnProp.Required], 32)]
    [Description('')]
    Fsberdat_odprac: string;
    
    [Column('des_oddelovac', [TColumnProp.Required], 32)]
    [Description('')]
    Fdes_oddelovac: string;
    
    [Column('print_default', [TColumnProp.Required], 64)]
    [Description('')]
    Fprint_default: string;
    
    [Column('print_copyes', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_copyes: string;
    
    [Column('print_all', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_all: string;
    
    [Column('print_savepozice', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_savepozice: string;
    
    [Column('print_offset_x', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_offset_x: string;
    
    [Column('print_offset_y', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_offset_y: string;
    
    [Column('rezerva', [TColumnProp.Required], 32)]
    [Description('')]
    Frezerva: string;
    
    [Column('ctecka_rizeni_toku', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_rizeni_toku: string;

    [Column('ctecka_port', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_port: string;
    
    [Column('ctecka_stopbit', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_stopbit: string;
    
    [Column('ctecka_databit', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_databit: string;
    
    [Column('ctecka_laser', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_laser: string;
    
    [Column('ctecka_autocheck', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_autocheck: string;
    
    [Column('popup_datumy', [TColumnProp.Required], 32)]
    [Description('')]
    Fpopup_datumy: string;
    
    [Column('barvy', [TColumnProp.Required], 1024)]
    [Description('')]
    Fbarvy: string;
    
    [Column('styly', [TColumnProp.Required], 1024)]
    [Description('')]
    Fstyly: string;
    
    [Column('color_pasive_active', [TColumnProp.Required], 32)]
    [Description('')]
    Fcolor_pasive_active: string;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('select_group_oper', [TColumnProp.Required], 50)]
    [Description('')]
    Fselect_group_oper: string;
    
    [Column('last_selected_orderwork', [TColumnProp.Required], 100)]
    [Description('')]
    Flast_selected_orderwork: string;
    
    [Column('last_selected_orderwork_group', [TColumnProp.Required], 50)]
    [Description('')]
    Flast_selected_orderwork_group: string;
    
    [Column('auto_neukoncene_prichody', [TColumnProp.Required], 10)]
    [Description('')]
    Fauto_neukoncene_prichody: string;
    
    [Column('vyber_tisku', [TColumnProp.Required], 512)]
    [Description('')]
    Fvyber_tisku: string;
    
    [Column('print_default_brothers', [TColumnProp.Required], 64)]
    [Description('')]
    Fprint_default_brothers: string;
    
    [Column('print_brothers_use', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_brothers_use: string;
    
    [Column('print_barcode_use', [TColumnProp.Required], 32)]
    [Description('')]
    Fprint_barcode_use: string;
    
    [Column('auto_select_group_sklad', [TColumnProp.Required], 32)]
    [Description('')]
    Fauto_select_group_sklad: string;
    
    [Column('select_group_sklad', [TColumnProp.Required], 50)]
    [Description('')]
    Fselect_group_sklad: string;
    
    [Column('zmena_na_stav', [TColumnProp.Required], 32)]
    [Description('')]
    Fzmena_na_stav: string;
    
    [Column('popisgrafprehled', [TColumnProp.Required])]
    [Description('')]
    Fpopisgrafprehled: Integer;
    
    [Column('last_selected_kusu', [TColumnProp.Required], 50)]
    [Description('')]
    Flast_selected_kusu: string;
    
    [Column('btn_stavyzak', [TColumnProp.Required], 32)]
    [Description('')]
    Fbtn_stavyzak: string;
    
    [Column('last_selected_predmat_group', [TColumnProp.Required], 50)]
    [Description('')]
    Flast_selected_predmat_group: string;
    
    [Column('last_selected_predmat_id', [TColumnProp.Required], 50)]
    [Description('')]
    Flast_selected_predmat_id: string;
    
    [Column('auto_select_last_predpmat', [TColumnProp.Required], 32)]
    [Description('')]
    Fauto_select_last_predpmat: string;
    
    [Column('order_userfiltr', [TColumnProp.Required], 64)]
    [Description('')]
    Forder_userfiltr: string;
    
    [Column('rychla_mys', [TColumnProp.Required])]
    [Description('')]
    Frychla_mys: Integer;

    [Column('chk_mater', [TColumnProp.Required])]
    [Description('')]
    Fchk_mater: Integer;
    
    [Column('print_podpis', [TColumnProp.Required], 255)]
    [Description('')]
    Fprint_podpis: string;
    
    [Column('use_akt_date_ord', [TColumnProp.Required])]
    [Description('')]
    Fuse_akt_date_ord: Integer;
    
    [Column('start_akt_date_ord', [TColumnProp.Required])]
    [Description('')]
    Fstart_akt_date_ord: TDateTime;
    
    [Column('fin_akt_date_ord', [TColumnProp.Required])]
    [Description('')]
    Ffin_akt_date_ord: TDateTime;
    
    [Column('use_chk_ow_time', [TColumnProp.Required])]
    [Description('')]
    Fuse_chk_ow_time: Integer;
    
    [Column('print_doc', [TColumnProp.Required])]
    [Description('')]
    Fprint_doc: Integer;
    
    [Column('use_clipboard', [TColumnProp.Required])]
    [Description('')]
    Fuse_clipboard: Integer;
    
    [Column('ord_show_btntoday', [TColumnProp.Required])]
    [Description('')]
    Ford_show_btntoday: Integer;
    
    [Column('ord_chkmater_vzdy', [TColumnProp.Required])]
    [Description('')]
    Ford_chkmater_vzdy: Integer;
    
    [Column('prn_adv_vyk_yisk', [TColumnProp.Required])]
    [Description('')]
    Fprn_adv_vyk_yisk: Integer;
    
    [Column('use_def_orderstav', [TColumnProp.Required])]
    [Description('')]
    Fuse_def_orderstav: Integer;
    
    [Column('ord_templ_name', [TColumnProp.Required])]
    [Description('')]
    Ford_templ_name: Integer;

    [Column('ord_sablona_sett', [TColumnProp.Required], 10)]
    [Description('')]
    Ford_sablona_sett: string;
    
    [Column('ow_def_poradi', [TColumnProp.Required])]
    [Description('')]
    Fow_def_poradi: Integer;
    
    [Column('ord_bold_master', [TColumnProp.Required])]
    [Description('')]
    Ford_bold_master: Integer;
    
    [Column('ord_color_master', [TColumnProp.Required])]
    [Description('')]
    Ford_color_master: Integer;
    
    [Column('ctecka_prijemka_port', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_prijemka_port: string;
    
    [Column('ctecka_prijemka_autocheck', [TColumnProp.Required])]
    [Description('')]
    Fctecka_prijemka_autocheck: Integer;
    
    [Column('ctecka_vydejka_port', [TColumnProp.Required], 32)]
    [Description('')]
    Fctecka_vydejka_port: string;
    
    [Column('ctecka_vydejka_autocheck', [TColumnProp.Required])]
    [Description('')]
    Fctecka_vydejka_autocheck: Integer;
    
    [Column('ctecka_sklad_ms5145', [TColumnProp.Required])]
    [Description('')]
    Fctecka_sklad_ms5145: Integer;

    [Column('operace_prekroceny_cas_prebarvit', [TColumnProp.Required])]
    [Description('')]
    Foperace_prekroceny_cas_prebarvit: Integer;
    
    [Column('operace_prekroceny_cas_barva', [TColumnProp.Required])]
    [Description('')]
    Foperace_prekroceny_cas_barva: Integer;
    
    [Column('zak_detail_1', [TColumnProp.Required])]
    [Description('')]
    Fzak_detail_1: Integer;
    
    [Column('zak_detail_2', [TColumnProp.Required])]
    [Description('')]
    Fzak_detail_2: Integer;
    
    [Column('zak_detail_3', [TColumnProp.Required])]
    [Description('')]
    Fzak_detail_3: Integer;
    
    [Column('zak_detail_4', [TColumnProp.Required])]
    [Description('')]
    Fzak_detail_4: Integer;
    
    [Column('zak_detail_5', [TColumnProp.Required])]
    [Description('')]
    Fzak_detail_5: Integer;

    [Column('zak_detail_6', [TColumnProp.Required])]
    [Description('')]
    Fzak_detail_6: Integer;
    
    [Column('zak_height_det_1', [TColumnProp.Required])]
    [Description('')]
    Fzak_height_det_1: Integer;
    
    [Column('zak_height_det_2', [TColumnProp.Required])]
    [Description('')]
    Fzak_height_det_2: Integer;
    
    [Column('zak_height_det_4', [TColumnProp.Required])]
    [Description('')]
    Fzak_height_det_4: Integer;
    
    [Column('zak_height_det_6', [TColumnProp.Required])]
    [Description('')]
    Fzak_height_det_6: Integer;
    
    [Column('zak_height_det_3', [TColumnProp.Required])]
    [Description('')]
    Fzak_height_det_3: Integer;
    
    [Column('zak_height_det_5', [TColumnProp.Required])]
    [Description('')]
    Fzak_height_det_5: Integer;
    
    [Column('graf_prehled_zak_left', [TColumnProp.Required])]
    [Description('')]
    Fgraf_prehled_zak_left: Integer;
    
    [Column('graf_prehled_zak_boot1', [TColumnProp.Required])]
    [Description('')]
    Fgraf_prehled_zak_boot1: Integer;
    
    [Column('graf_prehled_zak_boot2', [TColumnProp.Required])]
    [Description('')]
    Fgraf_prehled_zak_boot2: Integer;
    
    [Column('cas_klon', [TColumnProp.Required])]
    [Description('')]
    Fcas_klon: TDateTime;
    
    [Column('auto_akt_date_ord', [TColumnProp.Required])]
    [Description('')]
    Fauto_akt_date_ord: Integer;
    
    [Column('use_akt_date_sklad', [TColumnProp.Required])]
    [Description('')]
    Fuse_akt_date_sklad: Integer;
    
    [Column('start_akt_date_sklad', [TColumnProp.Required])]
    [Description('')]
    Fstart_akt_date_sklad: TDateTime;
    
    [Column('fin_akt_date_sklad', [TColumnProp.Required])]
    [Description('')]
    Ffin_akt_date_sklad: TDateTime;
    
    [Column('auto_akt_date_sklad', [TColumnProp.Required])]
    [Description('')]
    Fauto_akt_date_sklad: Integer;
    
    [Column('varianta_autoposun', [TColumnProp.Required])]
    [Description('')]
    Fvarianta_autoposun: Integer;
    
    [Column('kontrola_konec_obdobi_min', [TColumnProp.Required])]
    [Description('')]
    Fkontrola_konec_obdobi_min: Integer;
    
    [Column('sklad_detail_1', [TColumnProp.Required])]
    [Description('')]
    Fsklad_detail_1: Integer;
    
    [Column('sklad_detail_2', [TColumnProp.Required])]
    [Description('')]
    Fsklad_detail_2: Integer;
    
    [Column('sklad_detail_3', [TColumnProp.Required])]
    [Description('')]
    Fsklad_detail_3: Integer;
    
    [Column('sklad_height_det_1', [TColumnProp.Required])]
    [Description('')]
    Fsklad_height_det_1: Integer;
    
    [Column('sklad_height_det_2', [TColumnProp.Required])]
    [Description('')]
    Fsklad_height_det_2: Integer;
    
    [Column('sklad_height_det_3', [TColumnProp.Required])]
    [Description('')]
    Fsklad_height_det_3: Integer;
    
    [Column('sklad_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fsklad_pravy_panel: Integer;
    
    [Column('sklad_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Fsklad_pravy_panel_width: Integer;
    
    [Column('excel_export_varianta', [TColumnProp.Required])]
    [Description('')]
    Fexcel_export_varianta: Integer;
    
    [Column('excel_export_cesta', [TColumnProp.Required], 250)]
    [Description('')]
    Fexcel_export_cesta: string;
    
    [Column('excel_export_otevrit', [TColumnProp.Required])]
    [Description('')]
    Fexcel_export_otevrit: Integer;

    [Column('zak_material_prehled_width', [TColumnProp.Required])]
    [Description('')]
    Fzak_material_prehled_width: Integer;
    
    [Column('zak_pred_material_prehled_width', [TColumnProp.Required])]
    [Description('')]
    Fzak_pred_material_prehled_width: Integer;
    
    [Column('sklad_prehled_width', [TColumnProp.Required])]
    [Description('')]
    Fsklad_prehled_width: Integer;
    
    [Column('zak_material_prehled_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fzak_material_prehled_pravy_panel: Integer;
    
    [Column('zak_material_pred_prehled_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fzak_material_pred_prehled_pravy_panel: Integer;
    
    [Column('aktivmi_zakazky_hromadne_blokace', [TColumnProp.Required])]
    [Description('')]
    Faktivmi_zakazky_hromadne_blokace: Integer;
    
    [Column('corder_autorefresh', [TColumnProp.Required])]
    [Description('')]
    Fcorder_autorefresh: Integer;
    
    [Column('corder_autorefresh_interval', [TColumnProp.Required])]
    [Description('')]
    Fcorder_autorefresh_interval: Integer;
    
    [Column('corder_predpokladany_cas_zdroj', [TColumnProp.Required])]
    [Description('')]
    Fcorder_predpokladany_cas_zdroj: Integer;
    
    [Column('dashboard_show', [TColumnProp.Required])]
    [Description('')]
    Fdashboard_show: Integer;
    
    [Column('userEmail', [TColumnProp.Required], 255)]
    [Description('')]
    FuserEmail: string;
    
    [Column('userPhone', [TColumnProp.Required], 255)]
    [Description('')]
    FuserPhone: string;
    
    [Column('userNOS_order', [TColumnProp.Required])]
    [Description('')]
    FuserNOS_order: Integer;
    
    [Column('userRealName', [TColumnProp.Required], 255)]
    [Description('')]
    FuserRealName: string;
    
    [Column('auto_akt_date_ord_before', [TColumnProp.Required])]
    [Description('')]
    Fauto_akt_date_ord_before: Integer;
    
    [Column('auto_akt_date_ord_after', [TColumnProp.Required])]
    [Description('')]
    Fauto_akt_date_ord_after: Integer;
    
    [Column('order_auto_query_refresh_list_back', [TColumnProp.Required])]
    [Description('')]
    Forder_auto_query_refresh_list_back: Integer;
    
    [Column('order_type', [TColumnProp.Required])]
    [Description('')]
    Forder_type: Integer;
    
    [Column('order_rada', [TColumnProp.Required])]
    [Description('')]
    Forder_rada: Integer;

    [Column('order_finish_null', [TColumnProp.Required])]
    [Description('')]
    Forder_finish_null: Integer;
    
    [Column('order_settings', [TColumnProp.Required])]
    [Description('')]
    Forder_settings: Integer;
    
    [Column('user_language', [TColumnProp.Required], 10)]
    [Description('')]
    Fuser_language: string;
    
    [Column('operace_top5_days', [TColumnProp.Required])]
    [Description('')]
    Foperace_top5_days: Integer;
    
    [Column('colorize_grid_cell', [TColumnProp.Required])]
    [Description('')]
    Fcolorize_grid_cell: Integer;
    
    [Column('use_def_ordertyp', [TColumnProp.Required])]
    [Description('')]
    Fuse_def_ordertyp: Integer;

    [Column('filtrace_enter_order', [TColumnProp.Required])]
    [Description('')]
    Ffiltrace_enter_order: Integer;
    
    [Column('filtrace_order_active_control', [TColumnProp.Required])]
    [Description('')]
    Ffiltrace_order_active_control: Integer;
    
    [Column('filtrace_enter_global', [TColumnProp.Required])]
    [Description('')]
    Ffiltrace_enter_global: Integer;
    
    [Column('zak_seznam_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fzak_seznam_pravy_panel: Integer;

    [Column('zak_seznam_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Fzak_seznam_pravy_panel_width: Integer;
    
    [Column('zak_operace_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fzak_operace_pravy_panel: Integer;
    
    [Column('zak_operace_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Fzak_operace_pravy_panel_width: Integer;
    
    [Column('zam_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fzam_pravy_panel: Integer;

    [Column('zam_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Fzam_pravy_panel_width: Integer;
    
    [Column('stroje_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fstroje_pravy_panel: Integer;
    
    [Column('stroje_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Fstroje_pravy_panel_width: Integer;
    
    [Column('cnc_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Fcnc_pravy_panel: Integer;
    
    [Column('cnc_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Fcnc_pravy_panel_width: Integer;
    
    [Column('operace_pravy_panel', [TColumnProp.Required])]
    [Description('')]
    Foperace_pravy_panel: Integer;
    
    [Column('operace_pravy_panel_width', [TColumnProp.Required])]
    [Description('')]
    Foperace_pravy_panel_width: Integer;
    
    [Column('dashboard_panel1', [TColumnProp.Required], 200)]
    [Description('')]
    Fdashboard_panel1: string;
    
    [Column('dashboard_panel2', [TColumnProp.Required], 200)]
    [Description('')]
    Fdashboard_panel2: string;
    
    [Column('dashboard_panel3', [TColumnProp.Required], 200)]
    [Description('')]
    Fdashboard_panel3: string;
    
    [Column('dashboard_panel4', [TColumnProp.Required], 200)]
    [Description('')]
    Fdashboard_panel4: string;
    
    [Column('dashboard_panel5', [TColumnProp.Required], 200)]
    [Description('')]
    Fdashboard_panel5: string;
    
    [Column('dashboard_panel6', [TColumnProp.Required], 200)]
    [Description('')]
    Fdashboard_panel6: string;
    
    [Column('sklad_detail_4', [TColumnProp.Required])]
    [Description('')]
    Fsklad_detail_4: Integer;
    
    [Column('sklad_height_det_4', [TColumnProp.Required])]
    [Description('')]
    Fsklad_height_det_4: Integer;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property format_hodin: string read Fformat_hodin write Fformat_hodin;
    property zakazka_timeout: string read Fzakazka_timeout write Fzakazka_timeout;
    property auto_select_group: string read Fauto_select_group write Fauto_select_group;
    property show_datacol_toppan: string read Fshow_datacol_toppan write Fshow_datacol_toppan;
    property order_stavyrazeni: string read Forder_stavyrazeni write Forder_stavyrazeni;
    property btn_import: string read Fbtn_import write Fbtn_import;
    property btn_calc: string read Fbtn_calc write Fbtn_calc;
    property bar_format: string read Fbar_format write Fbar_format;
    property proskrtavat_dochazku: string read Fproskrtavat_dochazku write Fproskrtavat_dochazku;
    property proskrtavaci_znak: string read Fproskrtavaci_znak write Fproskrtavaci_znak;
    property sberdat_odprac: string read Fsberdat_odprac write Fsberdat_odprac;
    property des_oddelovac: string read Fdes_oddelovac write Fdes_oddelovac;
    property print_default: string read Fprint_default write Fprint_default;
    property print_copyes: string read Fprint_copyes write Fprint_copyes;
    property print_all: string read Fprint_all write Fprint_all;
    property print_savepozice: string read Fprint_savepozice write Fprint_savepozice;
    property print_offset_x: string read Fprint_offset_x write Fprint_offset_x;
    property print_offset_y: string read Fprint_offset_y write Fprint_offset_y;
    property rezerva: string read Frezerva write Frezerva;
    property ctecka_rizeni_toku: string read Fctecka_rizeni_toku write Fctecka_rizeni_toku;
    property ctecka_port: string read Fctecka_port write Fctecka_port;
    property ctecka_stopbit: string read Fctecka_stopbit write Fctecka_stopbit;
    property ctecka_databit: string read Fctecka_databit write Fctecka_databit;
    property ctecka_laser: string read Fctecka_laser write Fctecka_laser;
    property ctecka_autocheck: string read Fctecka_autocheck write Fctecka_autocheck;
    property popup_datumy: string read Fpopup_datumy write Fpopup_datumy;
    property barvy: string read Fbarvy write Fbarvy;
    property styly: string read Fstyly write Fstyly;
    property color_pasive_active: string read Fcolor_pasive_active write Fcolor_pasive_active;
    property user_id: Integer read Fuser_id write Fuser_id;
    property select_group_oper: string read Fselect_group_oper write Fselect_group_oper;
    property last_selected_orderwork: string read Flast_selected_orderwork write Flast_selected_orderwork;
    property last_selected_orderwork_group: string read Flast_selected_orderwork_group write Flast_selected_orderwork_group;
    property auto_neukoncene_prichody: string read Fauto_neukoncene_prichody write Fauto_neukoncene_prichody;
    property vyber_tisku: string read Fvyber_tisku write Fvyber_tisku;
    property print_default_brothers: string read Fprint_default_brothers write Fprint_default_brothers;
    property print_brothers_use: string read Fprint_brothers_use write Fprint_brothers_use;
    property print_barcode_use: string read Fprint_barcode_use write Fprint_barcode_use;
    property auto_select_group_sklad: string read Fauto_select_group_sklad write Fauto_select_group_sklad;
    property select_group_sklad: string read Fselect_group_sklad write Fselect_group_sklad;
    property zmena_na_stav: string read Fzmena_na_stav write Fzmena_na_stav;
    property popisgrafprehled: Integer read Fpopisgrafprehled write Fpopisgrafprehled;
    property last_selected_kusu: string read Flast_selected_kusu write Flast_selected_kusu;
    property btn_stavyzak: string read Fbtn_stavyzak write Fbtn_stavyzak;
    property last_selected_predmat_group: string read Flast_selected_predmat_group write Flast_selected_predmat_group;
    property last_selected_predmat_id: string read Flast_selected_predmat_id write Flast_selected_predmat_id;
    property auto_select_last_predpmat: string read Fauto_select_last_predpmat write Fauto_select_last_predpmat;
    property order_userfiltr: string read Forder_userfiltr write Forder_userfiltr;
    property rychla_mys: Integer read Frychla_mys write Frychla_mys;
    property chk_mater: Integer read Fchk_mater write Fchk_mater;
    property print_podpis: string read Fprint_podpis write Fprint_podpis;
    property use_akt_date_ord: Integer read Fuse_akt_date_ord write Fuse_akt_date_ord;
    property start_akt_date_ord: TDateTime read Fstart_akt_date_ord write Fstart_akt_date_ord;
    property fin_akt_date_ord: TDateTime read Ffin_akt_date_ord write Ffin_akt_date_ord;
    property use_chk_ow_time: Integer read Fuse_chk_ow_time write Fuse_chk_ow_time;
    property print_doc: Integer read Fprint_doc write Fprint_doc;
    property use_clipboard: Integer read Fuse_clipboard write Fuse_clipboard;
    property ord_show_btntoday: Integer read Ford_show_btntoday write Ford_show_btntoday;
    property ord_chkmater_vzdy: Integer read Ford_chkmater_vzdy write Ford_chkmater_vzdy;
    property prn_adv_vyk_yisk: Integer read Fprn_adv_vyk_yisk write Fprn_adv_vyk_yisk;
    property use_def_orderstav: Integer read Fuse_def_orderstav write Fuse_def_orderstav;
    property ord_templ_name: Integer read Ford_templ_name write Ford_templ_name;
    property ord_sablona_sett: string read Ford_sablona_sett write Ford_sablona_sett;
    property ow_def_poradi: Integer read Fow_def_poradi write Fow_def_poradi;
    property ord_bold_master: Integer read Ford_bold_master write Ford_bold_master;
    property ord_color_master: Integer read Ford_color_master write Ford_color_master;
    property ctecka_prijemka_port: string read Fctecka_prijemka_port write Fctecka_prijemka_port;
    property ctecka_prijemka_autocheck: Integer read Fctecka_prijemka_autocheck write Fctecka_prijemka_autocheck;
    property ctecka_vydejka_port: string read Fctecka_vydejka_port write Fctecka_vydejka_port;
    property ctecka_vydejka_autocheck: Integer read Fctecka_vydejka_autocheck write Fctecka_vydejka_autocheck;
    property ctecka_sklad_ms5145: Integer read Fctecka_sklad_ms5145 write Fctecka_sklad_ms5145;
    property operace_prekroceny_cas_prebarvit: Integer read Foperace_prekroceny_cas_prebarvit write Foperace_prekroceny_cas_prebarvit;
    property operace_prekroceny_cas_barva: Integer read Foperace_prekroceny_cas_barva write Foperace_prekroceny_cas_barva;
    property zak_detail_1: Integer read Fzak_detail_1 write Fzak_detail_1;
    property zak_detail_2: Integer read Fzak_detail_2 write Fzak_detail_2;
    property zak_detail_3: Integer read Fzak_detail_3 write Fzak_detail_3;
    property zak_detail_4: Integer read Fzak_detail_4 write Fzak_detail_4;
    property zak_detail_5: Integer read Fzak_detail_5 write Fzak_detail_5;
    property zak_detail_6: Integer read Fzak_detail_6 write Fzak_detail_6;
    property zak_height_det_1: Integer read Fzak_height_det_1 write Fzak_height_det_1;
    property zak_height_det_2: Integer read Fzak_height_det_2 write Fzak_height_det_2;
    property zak_height_det_4: Integer read Fzak_height_det_4 write Fzak_height_det_4;
    property zak_height_det_6: Integer read Fzak_height_det_6 write Fzak_height_det_6;
    property zak_height_det_3: Integer read Fzak_height_det_3 write Fzak_height_det_3;
    property zak_height_det_5: Integer read Fzak_height_det_5 write Fzak_height_det_5;
    property graf_prehled_zak_left: Integer read Fgraf_prehled_zak_left write Fgraf_prehled_zak_left;
    property graf_prehled_zak_boot1: Integer read Fgraf_prehled_zak_boot1 write Fgraf_prehled_zak_boot1;
    property graf_prehled_zak_boot2: Integer read Fgraf_prehled_zak_boot2 write Fgraf_prehled_zak_boot2;
    property cas_klon: TDateTime read Fcas_klon write Fcas_klon;
    property auto_akt_date_ord: Integer read Fauto_akt_date_ord write Fauto_akt_date_ord;
    property use_akt_date_sklad: Integer read Fuse_akt_date_sklad write Fuse_akt_date_sklad;
    property start_akt_date_sklad: TDateTime read Fstart_akt_date_sklad write Fstart_akt_date_sklad;
    property fin_akt_date_sklad: TDateTime read Ffin_akt_date_sklad write Ffin_akt_date_sklad;
    property auto_akt_date_sklad: Integer read Fauto_akt_date_sklad write Fauto_akt_date_sklad;
    property varianta_autoposun: Integer read Fvarianta_autoposun write Fvarianta_autoposun;
    property kontrola_konec_obdobi_min: Integer read Fkontrola_konec_obdobi_min write Fkontrola_konec_obdobi_min;
    property sklad_detail_1: Integer read Fsklad_detail_1 write Fsklad_detail_1;
    property sklad_detail_2: Integer read Fsklad_detail_2 write Fsklad_detail_2;
    property sklad_detail_3: Integer read Fsklad_detail_3 write Fsklad_detail_3;
    property sklad_height_det_1: Integer read Fsklad_height_det_1 write Fsklad_height_det_1;
    property sklad_height_det_2: Integer read Fsklad_height_det_2 write Fsklad_height_det_2;
    property sklad_height_det_3: Integer read Fsklad_height_det_3 write Fsklad_height_det_3;
    property sklad_pravy_panel: Integer read Fsklad_pravy_panel write Fsklad_pravy_panel;
    property sklad_pravy_panel_width: Integer read Fsklad_pravy_panel_width write Fsklad_pravy_panel_width;
    property excel_export_varianta: Integer read Fexcel_export_varianta write Fexcel_export_varianta;
    property excel_export_cesta: string read Fexcel_export_cesta write Fexcel_export_cesta;
    property excel_export_otevrit: Integer read Fexcel_export_otevrit write Fexcel_export_otevrit;
    property zak_material_prehled_width: Integer read Fzak_material_prehled_width write Fzak_material_prehled_width;
    property zak_pred_material_prehled_width: Integer read Fzak_pred_material_prehled_width write Fzak_pred_material_prehled_width;
    property sklad_prehled_width: Integer read Fsklad_prehled_width write Fsklad_prehled_width;
    property zak_material_prehled_pravy_panel: Integer read Fzak_material_prehled_pravy_panel write Fzak_material_prehled_pravy_panel;
    property zak_material_pred_prehled_pravy_panel: Integer read Fzak_material_pred_prehled_pravy_panel write Fzak_material_pred_prehled_pravy_panel;
    property aktivmi_zakazky_hromadne_blokace: Integer read Faktivmi_zakazky_hromadne_blokace write Faktivmi_zakazky_hromadne_blokace;
    property corder_autorefresh: Integer read Fcorder_autorefresh write Fcorder_autorefresh;
    property corder_autorefresh_interval: Integer read Fcorder_autorefresh_interval write Fcorder_autorefresh_interval;
    property corder_predpokladany_cas_zdroj: Integer read Fcorder_predpokladany_cas_zdroj write Fcorder_predpokladany_cas_zdroj;
    property dashboard_show: Integer read Fdashboard_show write Fdashboard_show;
    property userEmail: string read FuserEmail write FuserEmail;
    property userPhone: string read FuserPhone write FuserPhone;
    property userNOS_order: Integer read FuserNOS_order write FuserNOS_order;
    property userRealName: string read FuserRealName write FuserRealName;
    property auto_akt_date_ord_before: Integer read Fauto_akt_date_ord_before write Fauto_akt_date_ord_before;
    property auto_akt_date_ord_after: Integer read Fauto_akt_date_ord_after write Fauto_akt_date_ord_after;
    property order_auto_query_refresh_list_back: Integer read Forder_auto_query_refresh_list_back write Forder_auto_query_refresh_list_back;
    property order_type: Integer read Forder_type write Forder_type;
    property order_rada: Integer read Forder_rada write Forder_rada;
    property order_finish_null: Integer read Forder_finish_null write Forder_finish_null;
    property order_settings: Integer read Forder_settings write Forder_settings;
    property user_language: string read Fuser_language write Fuser_language;
    property operace_top5_days: Integer read Foperace_top5_days write Foperace_top5_days;
    property colorize_grid_cell: Integer read Fcolorize_grid_cell write Fcolorize_grid_cell;
    property use_def_ordertyp: Integer read Fuse_def_ordertyp write Fuse_def_ordertyp;
    property filtrace_enter_order: Integer read Ffiltrace_enter_order write Ffiltrace_enter_order;
    property filtrace_order_active_control: Integer read Ffiltrace_order_active_control write Ffiltrace_order_active_control;
    property filtrace_enter_global: Integer read Ffiltrace_enter_global write Ffiltrace_enter_global;
    property zak_seznam_pravy_panel: Integer read Fzak_seznam_pravy_panel write Fzak_seznam_pravy_panel;
    property zak_seznam_pravy_panel_width: Integer read Fzak_seznam_pravy_panel_width write Fzak_seznam_pravy_panel_width;
    property zak_operace_pravy_panel: Integer read Fzak_operace_pravy_panel write Fzak_operace_pravy_panel;
    property zak_operace_pravy_panel_width: Integer read Fzak_operace_pravy_panel_width write Fzak_operace_pravy_panel_width;
    property zam_pravy_panel: Integer read Fzam_pravy_panel write Fzam_pravy_panel;
    property zam_pravy_panel_width: Integer read Fzam_pravy_panel_width write Fzam_pravy_panel_width;
    property stroje_pravy_panel: Integer read Fstroje_pravy_panel write Fstroje_pravy_panel;
    property stroje_pravy_panel_width: Integer read Fstroje_pravy_panel_width write Fstroje_pravy_panel_width;
    property cnc_pravy_panel: Integer read Fcnc_pravy_panel write Fcnc_pravy_panel;
    property cnc_pravy_panel_width: Integer read Fcnc_pravy_panel_width write Fcnc_pravy_panel_width;
    property operace_pravy_panel: Integer read Foperace_pravy_panel write Foperace_pravy_panel;
    property operace_pravy_panel_width: Integer read Foperace_pravy_panel_width write Foperace_pravy_panel_width;
    property dashboard_panel1: string read Fdashboard_panel1 write Fdashboard_panel1;
    property dashboard_panel2: string read Fdashboard_panel2 write Fdashboard_panel2;
    property dashboard_panel3: string read Fdashboard_panel3 write Fdashboard_panel3;
    property dashboard_panel4: string read Fdashboard_panel4 write Fdashboard_panel4;
    property dashboard_panel5: string read Fdashboard_panel5 write Fdashboard_panel5;
    property dashboard_panel6: string read Fdashboard_panel6 write Fdashboard_panel6;
    property sklad_detail_4: Integer read Fsklad_detail_4 write Fsklad_detail_4;
    property sklad_height_det_4: Integer read Fsklad_height_det_4 write Fsklad_height_det_4;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('user_settings_user_fields')]
  [Description('definice uzivatelskych poli')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_settings_user_fields = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('section', [TColumnProp.Required], 100)]
    [Description('')]
    Fsection: string;

    [Column('type', [TColumnProp.Required], 20)]
    [Description('')]
    Ftype_: string;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('caption', [TColumnProp.Required], 150)]
    [Description('')]
    Fcaption: string;
    
    [Column('value', [TColumnProp.Required], 150)]
    [Description('')]
    Fvalue: string;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('posindex', [TColumnProp.Required])]
    [Description('')]
    Fposindex: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property section: string read Fsection write Fsection;
    property type_: string read Ftype_ write Ftype_;
    property name: string read Fname write Fname;
    property caption: string read Fcaption write Fcaption;
    property value: string read Fvalue write Fvalue;
    property user_id: Integer read Fuser_id write Fuser_id;
    property posindex: Integer read Fposindex write Fposindex;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('user_view_settings')]
  [Description('Nastaven pohled')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_view_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('agenda', [TColumnProp.Required], 80)]
    [Description('')]
    Fagenda: string;
    
    [Column('name', [TColumnProp.Required], 150)]
    [Description('')]
    Fname: string;
    
    [Column('vychozi', [TColumnProp.Required])]
    [Description('')]
    Fvychozi: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    
    [Column('nastaveni', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnastaveni: TBlob;
    
    [Column('nastaveni_json', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnastaveni_json: TBlob;
    
    [Column('view_sql', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fview_sql: TBlob;
    
    [Column('pouzit_web', [TColumnProp.Required])]
    [Description('')]
    Fpouzit_web: Boolean;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_changed', [])]
    [Description('')]
    Fts_changed: Nullable<TDateTime>;

    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;
    
    [Column('web_column_line', [TColumnProp.Required])]
    [Description('')]
    Fweb_column_line: boolean;
    
    [Column('web_sort_filter', [TColumnProp.Required])]
    [Description('')]
    Fweb_sort_filter: boolean;
    
    [Column('web_column_auto_lenght', [TColumnProp.Required])]
    [Description('')]
    Fweb_column_auto_lenght: boolean;
    
    [Column('systemovy', [TColumnProp.Required])]
    [Description('')]
    Fsystemovy: boolean;
    
    [Column('note', [], 255)]
    [Description('')]
    Fnote: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property agenda: string read Fagenda write Fagenda;
    property name: string read Fname write Fname;
    property vychozi: Integer read Fvychozi write Fvychozi;
    property user_id: Integer read Fuser_id write Fuser_id;
    property nastaveni: TBlob read Fnastaveni write Fnastaveni;
    property nastaveni_json: TBlob read Fnastaveni_json write Fnastaveni_json;
    property view_sql: TBlob read Fview_sql write Fview_sql;
    property pouzit_web: Boolean read Fpouzit_web write Fpouzit_web;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_changed: Nullable<TDateTime> read Fts_changed write Fts_changed;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property priorita: Integer read Fpriorita write Fpriorita;
    property web_column_line: boolean read Fweb_column_line write Fweb_column_line;
    property web_sort_filter: boolean read Fweb_sort_filter write Fweb_sort_filter;
    property web_column_auto_lenght: boolean read Fweb_column_auto_lenght write Fweb_column_auto_lenght;
    property systemovy: boolean read Fsystemovy write Fsystemovy;
    property note: Nullable<string> read Fnote write Fnote;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('uzamcene_obdobi')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuzamcene_obdobi = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('datumKonecObdobi', [TColumnProp.Required])]
    [Description('')]
    FdatumKonecObdobi: TDateTime;
    
    [Column('datumUzamceni', [TColumnProp.Required])]
    [Description('')]
    FdatumUzamceni: TDateTime;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;
    
    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;
    
    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Integer read Fid write Fid;
    property datumKonecObdobi: TDateTime read FdatumKonecObdobi write FdatumKonecObdobi;
    property datumUzamceni: TDateTime read FdatumUzamceni write FdatumUzamceni;
    property user: string read Fuser write Fuser;
    property userCreated: string read FuserCreated write FuserCreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('uzavreni_zakazek')]
  [Description('Uzavreni zakazek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuzavreni_zakazek = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('order_id_from', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id_from: string;
    
    [Column('order_id_to', [TColumnProp.Required], 50)]
    [Description('')]
    Forder_id_to: string;
    
    [Column('operation_id', [TColumnProp.Required])]
    [Description('')]
    Foperation_id: Int64;
    
    [Column('kusu', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkusu: Double;
    
    [Column('prevedeno', [TColumnProp.Required])]
    [Description('')]
    Fprevedeno: TDateTime;
    
    [Column('ke_dni', [TColumnProp.Required])]
    [Description('')]
    Fke_dni: TDateTime;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property order_id_from: string read Forder_id_from write Forder_id_from;
    property order_id_to: string read Forder_id_to write Forder_id_to;
    property operation_id: Int64 read Foperation_id write Foperation_id;
    property kusu: Double read Fkusu write Fkusu;
    property prevedeno: TDateTime read Fprevedeno write Fprevedeno;
    property ke_dni: TDateTime read Fke_dni write Fke_dni;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('vyrobni_calc')]
  [Description('Vyrobni kalkulacka')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tvyrobni_calc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('vyrobni_calc_material')]
  [Description('Vyrobni kalkulacka materialy')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tvyrobni_calc_material = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;
    
    [Column('calc_id', [TColumnProp.Required])]
    [Description('')]
    Fcalc_id: Integer;
    
    [Column('material_id', [TColumnProp.Required])]
    [Description('')]
    Fmaterial_id: Int64;
    
    [Column('mnoz', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fmnoz: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property calc_id: Integer read Fcalc_id write Fcalc_id;
    property material_id: Int64 read Fmaterial_id write Fmaterial_id;
    property mnoz: Double read Fmnoz write Fmnoz;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker')]
  [Description('Zamstnanci')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('comment', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fcomment: TBlob;

    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;

    [Column('active', [TColumnProp.Required], 20)]
    [Description('')]
    Factive: string;

    [Column('finish', [])]
    [Description('')]
    Ffinish: TDateTime;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('workerprice', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fworkerprice: Double;

    [Column('price_sat', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_sat: Double;

    [Column('price_sun', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_sun: Double;

    [Column('type', [])]
    [Description('')]
    Ftype_: Integer;

    [Column('cnc', [TColumnProp.Required])]
    [Description('')]
    Fcnc: Integer;

    [Column('card', [TColumnProp.Required], 20)]
    [Description('')]
    Fcard: string;

    [Column('group_name', [TColumnProp.Required], 50)]
    [Description('')]
    Fgroup_name: string;

    [Column('profese', [TColumnProp.Required], 50)]
    [Description('')]
    Fprofese: string;

    [Column('misto_prace', [TColumnProp.Required], 50)]
    [Description('')]
    Fmisto_prace: string;

    [Column('smena', [TColumnProp.Required], 50)]
    [Description('')]
    Fsmena: string;

    [Column('dostupne_smeny', [TColumnProp.Required], 256)]
    [Description('')]
    Fdostupne_smeny: string;

    [Column('cnc_start_operation_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_start_operation_id: Integer;

    [Column('cnc_end_operation_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_end_operation_id: Integer;

    [Column('cnc_operation_prihlaseni', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_prihlaseni: Integer;

    [Column('cnc_operation_kontrola', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_kontrola: Integer;

    [Column('cnc_operation_servis', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_servis: Integer;

    [Column('cnc_operation_odevzdaniks', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_odevzdaniks: Integer;

    [Column('cnc_operation_idle', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_idle: Integer;

    [Column('cnc_operation_alarm', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_alarm: Integer;

    [Column('cnc_operation_sing', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_sing: Integer;

    [Column('cnc_operation_feed', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_feed: Integer;

    [Column('cnc_operation_busy', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_busy: Integer;

    [Column('card_dmr', [TColumnProp.Required], 64)]
    [Description('')]
    Fcard_dmr: string;

    [Column('cnc_operation_udrzba', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_udrzba: Integer;

    [Column('stavCnc', [TColumnProp.Required], 50)]
    [Description('')]
    FstavCnc: string;

    [Column('busyStart', [TColumnProp.Required])]
    [Description('')]
    FbusyStart: TDateTime;

    [Column('lastCycle', [TColumnProp.Required])]
    [Description('')]
    FlastCycle: TDateTime;
    
    [Column('cnc_operation_konec', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_konec: Integer;
    
    [Column('cnc_operation_nedefinovano', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_nedefinovano: Integer;
    
    [Column('cnc_operation_waitkontrola', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_waitkontrola: Integer;
    
    [Column('alias', [TColumnProp.Required], 50)]
    [Description('')]
    Falias: string;
    
    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;

    [Column('cena_fakturace', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_fakturace: Double;
    
    [Column('use_cena_fakturace', [TColumnProp.Required])]
    [Description('')]
    Fuse_cena_fakturace: Integer;

    [Column('user_pin', [TColumnProp.Required])]
    [Description('')]
    Fuser_pin: Int64;
    
    [Column('prihlaseni', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fprihlaseni: String;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cnc_group', [], 'id')]
    [Description('')]
    Fcnc_group: proxy<TCNC_group>;

    [Column('price_prescas', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_prescas: Double;
    
    [Column('pozice', [TColumnProp.Required], 50)]
    [Description('')]
    Fpozice: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('id_nadrizeny', [], 'id')]
    [Description('')]
    Fid_nadrizeny: proxy<Tworker>;

    [Column('id_pracovni_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_pracovni_skupina: Integer;

    [Column('id_ridici_struktura', [TColumnProp.Required])]
    [Description('')]
    Fid_ridici_struktura: Integer;
    
    [Column('id_profese', [TColumnProp.Required])]
    [Description('')]
    Fid_profese: Integer;
    
    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;
    
    [Column('email', [TColumnProp.Required], 150)]
    [Description('')]
    Femail: string;
    
    [Column('telefon', [TColumnProp.Required], 150)]
    [Description('')]
    Ftelefon: string;

    [Column('price_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprice_mzda: Double;
    
    [Column('cnc_servis_datum', [TColumnProp.Required])]
    [Description('')]
    Fcnc_servis_datum: TDateTime;

    [Column('cnc_servis_interval', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcnc_servis_interval: Double;
    
    [Column('cnc_servis_interval_unit', [TColumnProp.Required])]
    [Description('')]
    Fcnc_servis_interval_unit: Integer;
    
    [Column('koef_skut_nakl', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoef_skut_nakl: Double;
    
    [Column('gdpr_zbyva', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_zbyva: Integer;
    
    [Column('gdpr_anonymizovano', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_anonymizovano: Integer;
    
    [Column('pouzeDochazka', [TColumnProp.Required])]
    [Description('')]
    FpouzeDochazka: Integer;
    
    [Column('bezCasu', [TColumnProp.Required])]
    [Description('')]
    FbezCasu: Integer;

    [Column('price_sat_koef', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprice_sat_koef: Double;

    [Column('price_sun_koef', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprice_sun_koef: Double;
    
    [Column('koef_ukol_mzdy', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoef_ukol_mzdy: Double;
    
    [Column('koef_ukol_mzdy_type', [])]
    [Description('')]
    Fkoef_ukol_mzdy_type: Integer;

    [Column('koef_ukol_mzdy2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoef_ukol_mzdy2: Double;
    
    [Column('koef_ukol_mzdy2_type', [TColumnProp.Required])]
    [Description('')]
    Fkoef_ukol_mzdy2_type: Integer;
    
    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('smena_id', [], 'id')]
    [Description('')]
    Fsmena_id: proxy<Tworker_smeny>;

    [Column('thp', [TColumnProp.Required])]
    [Description('')]
    Fthp: Integer;
    
    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('firstname', [TColumnProp.Required], 50)]
    [Description('')]
    Ffirstname: string;

    [Column('lastname', [TColumnProp.Required], 100)]
    [Description('')]
    Flastname: string;
    
    [Column('birthdate', [])]
    [Description('')]
    Fbirthdate: TDateTime;
    
    [Column('pracovni_pomer', [TColumnProp.Required], 50)]
    [Description('')]
    Fpracovni_pomer: string;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('useForMobile', [])]
    [Description('')]
    FuseForMobile: boolean;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('terminzaruky', [TColumnProp.Required])]
    [Description('')]
    Fterminzaruky: TDateTime;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('skupina_id', [], 'id')]
    [Description('')]
    Fskupina_id : proxy<Tworker_skupina>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('pozice_id', [], 'id')]
    [Description('')]
    Fpozice_id : proxy<Tworker_pozice>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('profese_id', [], 'id')]
    [Description('')]
    Fprofese_id : proxy<Tworker_profese>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('misto_prace_id', [], 'id')]
    [Description('')]
    Fmisto_prace_id : proxy<Tworker_misto_prace>;

  {  [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcnc_id')]
    Fcnc_operationList: Proxy<TList<Tref_operation_cnc>>;
    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcnc_id')]
    Fcnc_operationGroupList: Proxy<TList<Tref_operation_group_cnc>>;
   }
    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fworker_id')]
    Fworker_workhoursList: Proxy<TList<Tworker_workhours>>;

    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fworker_id')]
    Fworker_operationList: Proxy<TList<Tref_worker_operation>>;

    FDynCon: TDynamicProperties;

   { function Getcnc_operationList: TList<Tref_operation_cnc>;
    function Getcnc_operationGroupList: TList<Tref_operation_group_cnc>;
    }
    function Getworker_workhoursList: TList<Tworker_workhours>;
    function Getworker_OperationList: TList<Tref_worker_operation>;
  {  function getcnc_group: TCNC_group;
    procedure setcnc_group(const Value : TCNC_group);
   }
    function getid_nadrizeny: Tworker;
    procedure setid_nadrizeny(const Value : Tworker);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
    function getsmena_id: Tworker_smeny;
    procedure setsmena_id(const Value : Tworker_smeny);
    function getskupina_id: Tworker_skupina;
    procedure setskupina_id(const Value : Tworker_skupina);
    function getpozice_id: Tworker_pozice;
    procedure setpozice_id(const Value : Tworker_pozice);
    function getprofese_id: Tworker_profese;
    procedure setprofese_id(const Value : Tworker_profese);
    function getmisto_prace_id: Tworker_misto_prace;
    procedure setmisto_prace_id(const Value : Tworker_misto_prace);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    class procedure checkNewRecord; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property bar_id: string read Fbar_id write Fbar_id;
    property comment: TBlob read Fcomment write Fcomment;
    property start: TDateTime read Fstart write Fstart;
    property active: string read Factive write Factive;
    property finish: TDateTime read Ffinish write Ffinish;
    property user: string read Fuser write Fuser;
    property workerprice: Double read Fworkerprice write Fworkerprice;
    property price_sat: Double read Fprice_sat write Fprice_sat;
    property price_sun: Double read Fprice_sun write Fprice_sun;
    property type_: Integer read Ftype_ write Ftype_;
    property cnc: Integer read Fcnc write Fcnc;
    property card: string read Fcard write Fcard;
    property group_name: string read Fgroup_name write Fgroup_name;
    property profese: string read Fprofese write Fprofese;
    property misto_prace: string read Fmisto_prace write Fmisto_prace;
    property smena: string read Fsmena write fsmena;
    property dostupne_smeny: string read Fdostupne_smeny write Fdostupne_smeny;
    property cnc_start_operation_id: Integer read Fcnc_start_operation_id write Fcnc_start_operation_id;
    property cnc_end_operation_id: Integer read Fcnc_end_operation_id write Fcnc_end_operation_id;
    property cnc_operation_prihlaseni: Integer read Fcnc_operation_prihlaseni write Fcnc_operation_prihlaseni;
    property cnc_operation_kontrola: Integer read Fcnc_operation_kontrola write Fcnc_operation_kontrola;
    property cnc_operation_servis: Integer read Fcnc_operation_servis write Fcnc_operation_servis;
    property cnc_operation_odevzdaniks: Integer read Fcnc_operation_odevzdaniks write Fcnc_operation_odevzdaniks;
    property cnc_operation_idle: Integer read Fcnc_operation_idle write Fcnc_operation_idle;
    property cnc_operation_alarm: Integer read Fcnc_operation_alarm write Fcnc_operation_alarm;
    property cnc_operation_sing: Integer read Fcnc_operation_sing write Fcnc_operation_sing;
    property cnc_operation_feed: Integer read Fcnc_operation_feed write Fcnc_operation_feed;
    property cnc_operation_busy: Integer read Fcnc_operation_busy write Fcnc_operation_busy;
    property card_dmr: string read Fcard_dmr write Fcard_dmr;
    property cnc_operation_udrzba: Integer read Fcnc_operation_udrzba write Fcnc_operation_udrzba;
    property stavCnc: string read FstavCnc write FstavCnc;
    property busyStart: TDateTime read FbusyStart write FbusyStart;
    property lastCycle: TDateTime read FlastCycle write FlastCycle;
    property cnc_operation_konec: Integer read Fcnc_operation_konec write Fcnc_operation_konec;
    property cnc_operation_nedefinovano: Integer read Fcnc_operation_nedefinovano write Fcnc_operation_nedefinovano;
    property cnc_operation_waitkontrola: Integer read Fcnc_operation_waitkontrola write Fcnc_operation_waitkontrola;
    property alias: string read Falias write Falias;
    property priorita: Integer read Fpriorita write Fpriorita;
    property cena_fakturace: Double read Fcena_fakturace write Fcena_fakturace;
    property use_cena_fakturace: Integer read Fuse_cena_fakturace write Fuse_cena_fakturace;
    property user_pin: Int64 read Fuser_pin write Fuser_pin;
    property prihlaseni: String read Fprihlaseni;
 //   property cnc_group: TCNC_group read getcnc_group write setcnc_group;
    property price_prescas: Double read Fprice_prescas write Fprice_prescas;
    property pozice: string read Fpozice write Fpozice;
    property id_nadrizeny: Tworker read getid_nadrizeny write setid_nadrizeny;
    property id_pracovni_skupina: Integer read Fid_pracovni_skupina write Fid_pracovni_skupina;
    property id_ridici_struktura: Integer read Fid_ridici_struktura write Fid_ridici_struktura;
    property id_profese: Integer read Fid_profese write Fid_profese;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property email: string read Femail write Femail;
    property telefon: string read Ftelefon write Ftelefon;
    property price_mzda: Double read Fprice_mzda write Fprice_mzda;
    property cnc_servis_datum: TDateTime read Fcnc_servis_datum write Fcnc_servis_datum;
    property cnc_servis_interval: Double read Fcnc_servis_interval write Fcnc_servis_interval;
    property cnc_servis_interval_unit: Integer read Fcnc_servis_interval_unit write Fcnc_servis_interval_unit;
    property koef_skut_nakl: Double read Fkoef_skut_nakl write Fkoef_skut_nakl;
    property gdpr_zbyva: Integer read Fgdpr_zbyva write Fgdpr_zbyva;
    property gdpr_anonymizovano: Integer read Fgdpr_anonymizovano write Fgdpr_anonymizovano;
    property pouzeDochazka: Integer read FpouzeDochazka write FpouzeDochazka;
    property bezCasu: Integer read FbezCasu write FbezCasu;
    property price_sat_koef: Double read Fprice_sat_koef write Fprice_sat_koef;
    property price_sun_koef: Double read Fprice_sun_koef write Fprice_sun_koef;
    property koef_ukol_mzdy: Double read Fkoef_ukol_mzdy write Fkoef_ukol_mzdy;
    property koef_ukol_mzdy_type: Integer read Fkoef_ukol_mzdy_type write Fkoef_ukol_mzdy_type;
    property koef_ukol_mzdy2: Double read Fkoef_ukol_mzdy2 write Fkoef_ukol_mzdy2;
    property koef_ukol_mzdy2_type: Integer read Fkoef_ukol_mzdy2_type write Fkoef_ukol_mzdy2_type;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property smena_id: Tworker_smeny read getsmena_id write setsmena_id;
    property thp: Integer read Fthp write Fthp;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property firstname: string read Ffirstname write Ffirstname;
    property lastname: string read Flastname write Flastname;
    property birthdate: TDateTime read Fbirthdate write Fbirthdate;
    property pracovni_pomer: string read Fpracovni_pomer write Fpracovni_pomer;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property terminzaruky: TDateTime read Fterminzaruky write Fterminzaruky;
    property useForMobile : boolean read FuseForMobile write FuseForMobile;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property skupina_id : Tworker_skupina read getskupina_id write setskupina_id;
    property pozice_id : Tworker_pozice read getpozice_id write setpozice_id;
    property profese_id : Tworker_profese read getprofese_id write setprofese_id;
    property misto_prace_id :Tworker_misto_prace read getmisto_prace_id write setmisto_prace_id;
 {   property cnc_operationList: TList<Tref_operation_cnc> read Getcnc_operationList;
    property cnc_operationGroupList: TList<Tref_operation_group_cnc> read Getcnc_operationGroupList;
  }
    property worker_workhoursList : TList<Tworker_workhours> read Getworker_workhoursList;
    property worker_operationList: TList<Tref_worker_operation> read Getworker_operationList;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_cidla')]
  [Description('Tabulka pstup pro zamstnance na idlech')]
  [UniqueKey('idCidlo')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_cidla = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('idCidlo', [TColumnProp.Required])]
    [Description('')]
    FidCidlo: Integer;

    [Column('idWorker', [TColumnProp.Required])]
    [Description('')]
    FidWorker: Integer;
    
    [Column('Prava', [TColumnProp.Required])]
    [Description('')]
    FPrava: Integer;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property idCidlo: Integer read FidCidlo write FidCidlo;
    property idWorker: Integer read FidWorker write FidWorker;
    property Prava: Integer read FPrava write FPrava;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_foto')]
  [Description('Tabulka worker foto')]
  [Id('Fworker_id', TIdGenerator.None)]
  Tworker_foto = class(TTMSAGObject)
  private
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('foto_data', [TColumnProp.Lazy])]
    [Description('')]
    Ffoto_data: TBlob;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property foto_data: TBlob read Ffoto_data write Ffoto_data;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_functions')]
  [Description('Povolen funkce terminl u zamstnanc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_functions = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('worker_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fworker_id: string;
    
    [Column('terminal_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fterminal_id: string;

    [Column('function_id', [TColumnProp.Required], 50)]
    [Description('')]
    Ffunction_id: string;
    
    [Column('is_default', [TColumnProp.Required])]
    [Description('')]
    Fis_default: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property worker_id: string read Fworker_id write Fworker_id;
    property terminal_id: string read Fterminal_id write Fterminal_id;
    property function_id: string read Ffunction_id write Ffunction_id;
    property is_default: Integer read Fis_default write Fis_default;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_group')]
  [Description('skupiny zamestnancu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;
    
    [Column('code', [TColumnProp.Required], 50)]
    [Description('')]
    Fcode: string;
    
    [Column('note', [TColumnProp.Required], 255)]
    [Description('')]
    Fnote: string;
    
    [Column('parent_id', [TColumnProp.Required])]
    [Description('')]
    Fparent_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property code: string read Fcode write Fcode;
    property note: string read Fnote write Fnote;
    property parent_id: Integer read Fparent_id write Fparent_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_pracovni_rezim')]
  [Description('Tabulka pracovnch reim')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_pracovni_rezim = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fnazev: string;
    
    [Column('tydenni_max', [], 9, 2)]
    [Description('')]
    Ftydenni_max: Nullable<Double>;
    
    [Column('denni_max', [TColumnProp.Required], 9, 2)]
    [Description('')]
    Fdenni_max: Double;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property tydenni_max: Nullable<Double> read Ftydenni_max write Ftydenni_max;
    property denni_max: Double read Fdenni_max write Fdenni_max;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_prava')]
  [Description('Zamstnanec prva')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_prava = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [], 100)]
    [Description('')]
    Fname: Nullable<string>;
    
    [Column('description', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fdescription: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: Nullable<string> read Fname write Fname;
    property description: TBlob read Fdescription write Fdescription;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_prava_prirazeno')]
  [Description('Zamstnanec prva piazeno')]
  [Id('Fworker_id', TIdGenerator.None)]
  [Id('Fpravo_id', TIdGenerator.None)]
  Tworker_prava_prirazeno = class(TTMSAGObject)
  private
    [Column('worker_id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('pravo_id', [TColumnProp.Required])]
    [Description('')]
    Fpravo_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property pravo_id: Integer read Fpravo_id write Fpravo_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_prescasy')]
  [Description('Schvalovan pesas')]
  [UniqueKey('worker_id')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_prescasy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;
    
    [Column('prichod_vypocteno', [TColumnProp.Required])]
    [Description('')]
    Fprichod_vypocteno: Integer;
    
    [Column('prichod_ignorovat', [TColumnProp.Required])]
    [Description('')]
    Fprichod_ignorovat: Integer;
    
    [Column('prichod_nadpracovani', [TColumnProp.Required])]
    [Description('')]
    Fprichod_nadpracovani: Integer;
    
    [Column('prichod_fond', [TColumnProp.Required])]
    [Description('')]
    Fprichod_fond: Integer;

    [Column('prichod_proplatit', [TColumnProp.Required])]
    [Description('')]
    Fprichod_proplatit: Integer;
    
    [Column('prichod_poznamka', [TColumnProp.Required], 200)]
    [Description('')]
    Fprichod_poznamka: string;
    
    [Column('prichod_user_id', [TColumnProp.Required])]
    [Description('')]
    Fprichod_user_id: Integer;
    
    [Column('prichod_timestamp', [TColumnProp.Required])]
    [Description('')]
    Fprichod_timestamp: TDateTime;
    
    [Column('prichod_vycerpano', [TColumnProp.Required])]
    [Description('')]
    Fprichod_vycerpano: Integer;
    
    [Column('odchod_vypocteno', [TColumnProp.Required])]
    [Description('')]
    Fodchod_vypocteno: Integer;

    [Column('odchod_ignorovat', [TColumnProp.Required])]
    [Description('')]
    Fodchod_ignorovat: Integer;
    
    [Column('odchod_nadpracovani', [TColumnProp.Required])]
    [Description('')]
    Fodchod_nadpracovani: Integer;
    
    [Column('odchod_fond', [TColumnProp.Required])]
    [Description('')]
    Fodchod_fond: Integer;
    
    [Column('odchod_proplatit', [TColumnProp.Required])]
    [Description('')]
    Fodchod_proplatit: Integer;
    
    [Column('odchod_poznamka', [TColumnProp.Required], 200)]
    [Description('')]
    Fodchod_poznamka: string;
    
    [Column('odchod_user_id', [TColumnProp.Required])]
    [Description('')]
    Fodchod_user_id: Integer;
    
    [Column('odchod_timestamp', [TColumnProp.Required])]
    [Description('')]
    Fodchod_timestamp: TDateTime;
    
    [Column('odchod_vycerpano', [TColumnProp.Required])]
    [Description('')]
    Fodchod_vycerpano: Integer;
    
    [Column('prichod_ignorovat_zapocet', [TColumnProp.Required])]
    [Description('')]
    Fprichod_ignorovat_zapocet: Integer;
    
    [Column('prichod_nadpracovani_zapocet', [TColumnProp.Required])]
    [Description('')]
    Fprichod_nadpracovani_zapocet: Integer;
    
    [Column('odchod_ignorovat_zapocet', [TColumnProp.Required])]
    [Description('')]
    Fodchod_ignorovat_zapocet: Integer;
    
    [Column('odchod_nadpracovani_zapocet', [TColumnProp.Required])]
    [Description('')]
    Fodchod_nadpracovani_zapocet: Integer;
    
    [Column('prichod_readdata_id', [TColumnProp.Required])]
    [Description('')]
    Fprichod_readdata_id: Int64;
    
    [Column('odchod_readdata_id', [TColumnProp.Required])]
    [Description('')]
    Fodchod_readdata_id: Int64;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property datum: TDateTime read Fdatum write Fdatum;
    property prichod_vypocteno: Integer read Fprichod_vypocteno write Fprichod_vypocteno;
    property prichod_ignorovat: Integer read Fprichod_ignorovat write Fprichod_ignorovat;
    property prichod_nadpracovani: Integer read Fprichod_nadpracovani write Fprichod_nadpracovani;
    property prichod_fond: Integer read Fprichod_fond write Fprichod_fond;
    property prichod_proplatit: Integer read Fprichod_proplatit write Fprichod_proplatit;
    property prichod_poznamka: string read Fprichod_poznamka write Fprichod_poznamka;
    property prichod_user_id: Integer read Fprichod_user_id write Fprichod_user_id;
    property prichod_timestamp: TDateTime read Fprichod_timestamp write Fprichod_timestamp;
    property prichod_vycerpano: Integer read Fprichod_vycerpano write Fprichod_vycerpano;
    property odchod_vypocteno: Integer read Fodchod_vypocteno write Fodchod_vypocteno;
    property odchod_ignorovat: Integer read Fodchod_ignorovat write Fodchod_ignorovat;
    property odchod_nadpracovani: Integer read Fodchod_nadpracovani write Fodchod_nadpracovani;
    property odchod_fond: Integer read Fodchod_fond write Fodchod_fond;
    property odchod_proplatit: Integer read Fodchod_proplatit write Fodchod_proplatit;
    property odchod_poznamka: string read Fodchod_poznamka write Fodchod_poznamka;
    property odchod_user_id: Integer read Fodchod_user_id write Fodchod_user_id;
    property odchod_timestamp: TDateTime read Fodchod_timestamp write Fodchod_timestamp;
    property odchod_vycerpano: Integer read Fodchod_vycerpano write Fodchod_vycerpano;
    property prichod_ignorovat_zapocet: Integer read Fprichod_ignorovat_zapocet write Fprichod_ignorovat_zapocet;
    property prichod_nadpracovani_zapocet: Integer read Fprichod_nadpracovani_zapocet write Fprichod_nadpracovani_zapocet;
    property odchod_ignorovat_zapocet: Integer read Fodchod_ignorovat_zapocet write Fodchod_ignorovat_zapocet;
    property odchod_nadpracovani_zapocet: Integer read Fodchod_nadpracovani_zapocet write Fodchod_nadpracovani_zapocet;
    property prichod_readdata_id: Int64 read Fprichod_readdata_id write Fprichod_readdata_id;
    property odchod_readdata_id: Int64 read Fodchod_readdata_id write Fodchod_readdata_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_prescasy_dochazka')]
  [Description('erpn pesas z fondu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_prescasy_dochazka = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('worker_prescasy_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_prescasy_id: Integer;
    
    [Column('dochazka_id', [TColumnProp.Required])]
    [Description('')]
    Fdochazka_id: Integer;
    
    [Column('prichod_cerpano', [TColumnProp.Required])]
    [Description('')]
    Fprichod_cerpano: Integer;
    
    [Column('odchod_cerpano', [TColumnProp.Required])]
    [Description('')]
    Fodchod_cerpano: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property worker_prescasy_id: Integer read Fworker_prescasy_id write Fworker_prescasy_id;
    property dochazka_id: Integer read Fdochazka_id write Fdochazka_id;
    property prichod_cerpano: Integer read Fprichod_cerpano write Fprichod_cerpano;
    property odchod_cerpano: Integer read Fodchod_cerpano write Fodchod_cerpano;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_prescasy_prevod')]
  [Description('Pevody pesas z fondu')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_prescasy_prevod = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('rok', [TColumnProp.Required])]
    [Description('')]
    Frok: Integer;
    
    [Column('mesic', [TColumnProp.Required])]
    [Description('')]
    Fmesic: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('datum', [TColumnProp.Required])]
    [Description('')]
    Fdatum: TDateTime;
    
    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    
    [Column('prevedeno', [TColumnProp.Required])]
    [Description('')]
    Fprevedeno: Integer;
    
    [Column('zustava', [TColumnProp.Required])]
    [Description('')]
    Fzustava: Integer;
    
    [Column('note', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fnote: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property rok: Integer read Frok write Frok;
    property mesic: Integer read Fmesic write Fmesic;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property datum: TDateTime read Fdatum write Fdatum;
    property user: string read Fuser write Fuser;
    property prevedeno: Integer read Fprevedeno write Fprevedeno;
    property zustava: Integer read Fzustava write Fzustava;
    property note: TBlob read Fnote write Fnote;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_proskoleni')]
  [Description('WORKER_PROSKOLENI')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_proskoleni = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('id_typ_proskoleni', [TColumnProp.Required])]
    [Description('')]
    Fid_typ_proskoleni: Integer;
    
    [Column('probehlo_dne', [])]
    [Description('')]
    Fprobehlo_dne: Nullable<TDateTime>;
    
    [Column('plati_do', [])]
    [Description('')]
    Fplati_do: Nullable<TDateTime>;
    
    [Column('dokumenty_cesta', [], 300)]
    [Description('')]
    Fdokumenty_cesta: Nullable<string>;
    
    [Column('poznamka', [], 300)]
    [Description('')]
    Fpoznamka: Nullable<string>;
    
    [Column('uroven', [TColumnProp.Required])]
    [Description('')]
    Furoven: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property id_typ_proskoleni: Integer read Fid_typ_proskoleni write Fid_typ_proskoleni;
    property probehlo_dne: Nullable<TDateTime> read Fprobehlo_dne write Fprobehlo_dne;
    property plati_do: Nullable<TDateTime> read Fplati_do write Fplati_do;
    property dokumenty_cesta: Nullable<string> read Fdokumenty_cesta write Fdokumenty_cesta;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property uroven: Integer read Furoven write Furoven;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_proskoleni_druh')]
  [Description('Druhy prokolen')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_proskoleni_druh = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    
    [Column('zkratka', [TColumnProp.Required], 20)]
    [Description('')]
    Fzkratka: string;
    
    [Column('poznamka', [], 300)]
    [Description('')]
    Fpoznamka: Nullable<string>;
    
    [Column('druh', [TColumnProp.Required])]
    [Description('')]
    Fdruh: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property zkratka: string read Fzkratka write Fzkratka;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property druh: Integer read Fdruh write Fdruh;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_proskoleni_readdata')]
  [Description('Uloen data o prokolen')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_proskoleni_readdata = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('proskoleni_typ', [TColumnProp.Required])]
    [Description('')]
    Fproskoleni_typ: Integer;
    
    [Column('proskoleni_uroven', [TColumnProp.Required])]
    [Description('')]
    Fproskoleni_uroven: Integer;

    [Column('proskoleni_datum', [])]
    [Description('')]
    Fproskoleni_datum: Nullable<TDateTime>;
    
    [Column('proskoleni_datum_nasledujici', [])]
    [Description('')]
    Fproskoleni_datum_nasledujici: Nullable<TDateTime>;
    
    [Column('vlozeno', [])]
    [Description('')]
    Fvlozeno: Nullable<TDateTime>;
    
    [Column('editovano', [])]
    [Description('')]
    Feditovano: Nullable<TDateTime>;
    
    [Column('uzivatel', [TColumnProp.Required], 50)]
    [Description('')]
    Fuzivatel: string;
    
    [Column('poznamka', [TColumnProp.Required], 300)]
    [Description('')]
    Fpoznamka: string;
    
    [Column('proskoleni_id', [TColumnProp.Required])]
    [Description('')]
    Fproskoleni_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property proskoleni_typ: Integer read Fproskoleni_typ write Fproskoleni_typ;
    property proskoleni_uroven: Integer read Fproskoleni_uroven write Fproskoleni_uroven;
    property proskoleni_datum: Nullable<TDateTime> read Fproskoleni_datum write Fproskoleni_datum;
    property proskoleni_datum_nasledujici: Nullable<TDateTime> read Fproskoleni_datum_nasledujici write Fproskoleni_datum_nasledujici;
    property vlozeno: Nullable<TDateTime> read Fvlozeno write Fvlozeno;
    property editovano: Nullable<TDateTime> read Feditovano write Feditovano;
    property uzivatel: string read Fuzivatel write Fuzivatel;
    property poznamka: string read Fpoznamka write Fpoznamka;
    property proskoleni_id: Integer read Fproskoleni_id write Fproskoleni_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_proskoleni_typ')]
  [Description('Typy prokolen a poet rovn')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_proskoleni_typ = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;
    
    [Column('pocet_urovni', [TColumnProp.Required])]
    [Description('')]
    Fpocet_urovni: Integer;

    [Column('proskoleni_interval', [TColumnProp.Required])]
    [Description('')]
    Fproskoleni_interval: Integer;
    
    [Column('poznamka', [TColumnProp.Required], 300)]
    [Description('')]
    Fpoznamka: string;
    
    [Column('proskoleni_druh', [TColumnProp.Required])]
    [Description('')]
    Fproskoleni_druh: Integer;
    
    [Column('dokumenty_cesta', [TColumnProp.Required], 300)]
    [Description('')]
    Fdokumenty_cesta: string;
    
    [Column('postupne', [TColumnProp.Required])]
    [Description('')]
    Fpostupne: Integer;
    
    [Column('interval_jednotka', [TColumnProp.Required])]
    [Description('')]
    Finterval_jednotka: Integer;

    [Column('skolitel_nazev', [TColumnProp.Required], 100)]
    [Description('')]
    Fskolitel_nazev: string;
    
    [Column('skolitel_info', [TColumnProp.Required])]
    [Description('')]
    Fskolitel_info: Integer;
    
    [Column('skolitel_email', [TColumnProp.Required], 100)]
    [Description('')]
    Fskolitel_email: string;
    
    [Column('worker_id', [TColumnProp.Required])]
    [Description('')]
    Fworker_id: Integer;
    
    [Column('user_id', [TColumnProp.Required])]
    [Description('')]
    Fuser_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property pocet_urovni: Integer read Fpocet_urovni write Fpocet_urovni;
    property proskoleni_interval: Integer read Fproskoleni_interval write Fproskoleni_interval;
    property poznamka: string read Fpoznamka write Fpoznamka;
    property proskoleni_druh: Integer read Fproskoleni_druh write Fproskoleni_druh;
    property dokumenty_cesta: string read Fdokumenty_cesta write Fdokumenty_cesta;
    property postupne: Integer read Fpostupne write Fpostupne;
    property interval_jednotka: Integer read Finterval_jednotka write Finterval_jednotka;
    property skolitel_nazev: string read Fskolitel_nazev write Fskolitel_nazev;
    property skolitel_info: Integer read Fskolitel_info write Fskolitel_info;
    property skolitel_email: string read Fskolitel_email write Fskolitel_email;
    property worker_id: Integer read Fworker_id write Fworker_id;
    property user_id: Integer read Fuser_id write Fuser_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_role')]
  [Description('Zamstnanec role')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_role = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [], 100)]
    [Description('')]
    Fname: Nullable<string>;
    
    [Column('description', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fdescription: TBlob;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: Nullable<string> read Fname write Fname;
    property description: TBlob read Fdescription write Fdescription;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_smeny')]
  [Description('Tabulka smen')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_smeny = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('po_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fpo_zacatek: TDateTime;
    
    [Column('po_konec', [TColumnProp.Required])]
    [Description('')]
    Fpo_konec: TDateTime;
    
    [Column('po_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fpo_doba: Double;
    
    [Column('ut_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fut_zacatek: TDateTime;
    
    [Column('ut_konec', [TColumnProp.Required])]
    [Description('')]
    Fut_konec: TDateTime;
    
    [Column('ut_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fut_doba: Double;
    
    [Column('st_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fst_zacatek: TDateTime;
    
    [Column('st_konec', [TColumnProp.Required])]
    [Description('')]
    Fst_konec: TDateTime;

    [Column('st_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fst_doba: Double;
    
    [Column('ct_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fct_zacatek: TDateTime;
    
    [Column('ct_konec', [TColumnProp.Required])]
    [Description('')]
    Fct_konec: TDateTime;
    
    [Column('ct_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fct_doba: Double;
    
    [Column('pa_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fpa_zacatek: TDateTime;
    
    [Column('pa_konec', [TColumnProp.Required])]
    [Description('')]
    Fpa_konec: TDateTime;
    
    [Column('pa_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fpa_doba: Double;
    
    [Column('so_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fso_zacatek: TDateTime;
    
    [Column('so_konec', [TColumnProp.Required])]
    [Description('')]
    Fso_konec: TDateTime;
    
    [Column('so_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fso_doba: Double;

    [Column('ne_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fne_zacatek: TDateTime;
    
    [Column('ne_konec', [TColumnProp.Required])]
    [Description('')]
    Fne_konec: TDateTime;
    
    [Column('ne_doba', [TColumnProp.Required], 11, 2)]
    [Description('')]
    Fne_doba: Double;
    
    [Column('roud_work_start', [TColumnProp.Required])]
    [Description('')]
    Froud_work_start: Integer;

    [Column('roud_work_finish', [TColumnProp.Required])]
    [Description('')]
    Froud_work_finish: Integer;
    
    [Column('auto_del_prescas_ifless', [TColumnProp.Required])]
    [Description('')]
    Fauto_del_prescas_ifless: Integer;

    [Column('auto_break_dochazka', [TColumnProp.Required])]
    [Description('')]
    Fauto_break_dochazka: Integer;
    
    [Column('auto_break_if', [TColumnProp.Required])]
    [Description('')]
    Fauto_break_if: Integer;
    
    [Column('penalizace_if_min', [TColumnProp.Required])]
    [Description('')]
    Fpenalizace_if_min: Integer;
    
    [Column('penalizace_minut', [TColumnProp.Required])]
    [Description('')]
    Fpenalizace_minut: Integer;
    
    [Column('ignore_before_work', [TColumnProp.Required])]
    [Description('')]
    Fignore_before_work: Integer;
    
    [Column('use_penalizace', [TColumnProp.Required])]
    [Description('')]
    Fuse_penalizace: Integer;
    
    [Column('nazev', [TColumnProp.Required], 64)]
    [Description('')]
    Fnazev: string;
    
    [Column('prestavka1od', [TColumnProp.Required])]
    [Description('')]
    Fprestavka1od: TDateTime;
    
    [Column('prestavka1do', [TColumnProp.Required])]
    [Description('')]
    Fprestavka1do: TDateTime;
    
    [Column('prestavka2od', [TColumnProp.Required])]
    [Description('')]
    Fprestavka2od: TDateTime;
    
    [Column('prestavka2do', [TColumnProp.Required])]
    [Description('')]
    Fprestavka2do: TDateTime;
    
    [Column('prestavka3od', [TColumnProp.Required])]
    [Description('')]
    Fprestavka3od: TDateTime;
    
    [Column('prestavka3do', [TColumnProp.Required])]
    [Description('')]
    Fprestavka3do: TDateTime;
    
    [Column('upravit_zacatek', [TColumnProp.Required])]
    [Description('')]
    Fupravit_zacatek: Integer;
    
    [Column('auto_break_repeat', [TColumnProp.Required])]
    [Description('')]
    Fauto_break_repeat: Integer;
    
    [Column('barva', [TColumnProp.Required])]
    [Description('')]
    Fbarva: Integer;
    
    [Column('pracovni_rezim_id', [TColumnProp.Required])]
    [Description('')]
    Fpracovni_rezim_id: Integer;

    [Column('skryta', [TColumnProp.Required])]
    [Description('')]
    Fskryta: Integer;
    
    [Column('prestavka_povolena', [TColumnProp.Required])]
    [Description('')]
    Fprestavka_povolena: Integer;
    
    [Column('prestavka_doba', [TColumnProp.Required])]
    [Description('')]
    Fprestavka_doba: Integer;
    
    [Column('zkratka', [TColumnProp.Required], 3)]
    [Description('')]
    Fzkratka: string;
    
    [Column('nerovnomerna', [TColumnProp.Required])]
    [Description('')]
    Fnerovnomerna: Integer;
    
    [Column('prestavka_po', [TColumnProp.Required])]
    [Description('')]
    Fprestavka_po: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property po_zacatek: TDateTime read Fpo_zacatek write Fpo_zacatek;
    property po_konec: TDateTime read Fpo_konec write Fpo_konec;
    property po_doba: Double read Fpo_doba write Fpo_doba;
    property ut_zacatek: TDateTime read Fut_zacatek write Fut_zacatek;
    property ut_konec: TDateTime read Fut_konec write Fut_konec;
    property ut_doba: Double read Fut_doba write Fut_doba;
    property st_zacatek: TDateTime read Fst_zacatek write Fst_zacatek;
    property st_konec: TDateTime read Fst_konec write Fst_konec;
    property st_doba: Double read Fst_doba write Fst_doba;
    property ct_zacatek: TDateTime read Fct_zacatek write Fct_zacatek;
    property ct_konec: TDateTime read Fct_konec write Fct_konec;
    property ct_doba: Double read Fct_doba write Fct_doba;
    property pa_zacatek: TDateTime read Fpa_zacatek write Fpa_zacatek;
    property pa_konec: TDateTime read Fpa_konec write Fpa_konec;
    property pa_doba: Double read Fpa_doba write Fpa_doba;
    property so_zacatek: TDateTime read Fso_zacatek write Fso_zacatek;
    property so_konec: TDateTime read Fso_konec write Fso_konec;
    property so_doba: Double read Fso_doba write Fso_doba;
    property ne_zacatek: TDateTime read Fne_zacatek write Fne_zacatek;
    property ne_konec: TDateTime read Fne_konec write Fne_konec;
    property ne_doba: Double read Fne_doba write Fne_doba;
    property roud_work_start: Integer read Froud_work_start write Froud_work_start;
    property roud_work_finish: Integer read Froud_work_finish write Froud_work_finish;
    property auto_del_prescas_ifless: Integer read Fauto_del_prescas_ifless write Fauto_del_prescas_ifless;
    property auto_break_dochazka: Integer read Fauto_break_dochazka write Fauto_break_dochazka;
    property auto_break_if: Integer read Fauto_break_if write Fauto_break_if;
    property penalizace_if_min: Integer read Fpenalizace_if_min write Fpenalizace_if_min;
    property penalizace_minut: Integer read Fpenalizace_minut write Fpenalizace_minut;
    property ignore_before_work: Integer read Fignore_before_work write Fignore_before_work;
    property use_penalizace: Integer read Fuse_penalizace write Fuse_penalizace;
    property nazev: string read Fnazev write Fnazev;
    property prestavka1od: TDateTime read Fprestavka1od write Fprestavka1od;
    property prestavka1do: TDateTime read Fprestavka1do write Fprestavka1do;
    property prestavka2od: TDateTime read Fprestavka2od write Fprestavka2od;
    property prestavka2do: TDateTime read Fprestavka2do write Fprestavka2do;
    property prestavka3od: TDateTime read Fprestavka3od write Fprestavka3od;
    property prestavka3do: TDateTime read Fprestavka3do write Fprestavka3do;
    property upravit_zacatek: Integer read Fupravit_zacatek write Fupravit_zacatek;
    property auto_break_repeat: Integer read Fauto_break_repeat write Fauto_break_repeat;
    property barva: Integer read Fbarva write Fbarva;
    property pracovni_rezim_id: Integer read Fpracovni_rezim_id write Fpracovni_rezim_id;
    property skryta: Integer read Fskryta write Fskryta;
    property prestavka_povolena: Integer read Fprestavka_povolena write Fprestavka_povolena;
    property prestavka_doba: Integer read Fprestavka_doba write Fprestavka_doba;
    property zkratka: string read Fzkratka write Fzkratka;
    property nerovnomerna: Integer read Fnerovnomerna write Fnerovnomerna;
    property prestavka_po: Integer read Fprestavka_po write Fprestavka_po;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_smeny_sablony')]
  [Description('ablony smn')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_smeny_sablony = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('name', [TColumnProp.Required], 200)]
    [Description('')]
    Fname: string;
    
    [Column('user_created', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_created: string;
    
    [Column('user_lastchange', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser_lastchange: string;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    
    [Column('pracovni_rezim_id', [TColumnProp.Required])]
    [Description('')]
    Fpracovni_rezim_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property user_created: string read Fuser_created write Fuser_created;
    property user_lastchange: string read Fuser_lastchange write Fuser_lastchange;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property pracovni_rezim_id: Integer read Fpracovni_rezim_id write Fpracovni_rezim_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_smeny_sablony_smeny')]
  [Description('ablony smn - smny')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_smeny_sablony_smeny = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('sablona_id', [TColumnProp.Required])]
    [Description('')]
    Fsablona_id: Integer;
    
    [Column('poradi', [TColumnProp.Required])]
    [Description('')]
    Fporadi: Integer;

    [Column('smena_id', [TColumnProp.Required])]
    [Description('')]
    Fsmena_id: Integer;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Integer read Fid write Fid;
    property sablona_id: Integer read Fsablona_id write Fsablona_id;
    property poradi: Integer read Fporadi write Fporadi;
    property smena_id: Integer read Fsmena_id write Fsmena_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('worker_svatky')]
  [Description('Tabulka worker svatky')]
  [Id('Fname_day', TIdGenerator.None)]
  [Id('Fname_month', TIdGenerator.None)]
  [Id('Fcountry_code', TIdGenerator.None)]
  [Id('Ffirst_name', TIdGenerator.None)]
  Tworker_svatky = class(TTMSAGObject)
  private
    [Column('name_date', [TColumnProp.Required])]
    [Description('')]
    Fname_date: TDateTime;
    
    [Column('name_day', [TColumnProp.Required])]
    [Description('')]
    Fname_day: Integer;
    
    [Column('name_month', [TColumnProp.Required])]
    [Description('')]
    Fname_month: Integer;

    [Column('country_code', [TColumnProp.Required], 6)]
    [Description('')]
    Fcountry_code: string;
    
    [Column('first_name', [TColumnProp.Required], 50)]
    [Description('')]
    Ffirst_name: string;
    
    [Column('ts_created', [TColumnProp.Required])]
    [Description('')]
    Fts_created: TDateTime;
    
    [Column('ts_lastchange', [TColumnProp.Required])]
    [Description('')]
    Fts_lastchange: TDateTime;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property name_date: TDateTime read Fname_date write Fname_date;
    property name_day: Integer read Fname_day write Fname_day;
    property name_month: Integer read Fname_month write Fname_month;
    property country_code: string read Fcountry_code write Fcountry_code;
    property first_name: string read Ffirst_name write Ffirst_name;
    property ts_created: TDateTime read Fts_created write Fts_created;
    property ts_lastchange: TDateTime read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_workhours')]
  [Description('Tabulka zmn pracovnho vazku zamstnance')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_workhours = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('worker_id', [], 'id')]
    [Description('')]
    Fworker_id: proxy<Tworker>;

    [Column('start', [])]
    [Description('')]
    Fstart: Nullable<TDateTime>;

    [Column('week_amount', [TColumnProp.Required], 9, 2)]
    [Description('')]
    Fweek_amount: Double;

    [Column('note', [TColumnProp.Required], 200)]
    [Description('')]
    Fnote: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('pracovni_rezim_id', [], 'id')]
    [Description('')]
    Fpracovni_rezim_id : proxy<Tworker_pracovni_rezim>;

    FDynCon: TDynamicProperties;

    function getworker_id: TWorker;
    procedure setworker_id(const Value : TWorker);
    function getpracovni_rezim_id: Tworker_pracovni_rezim;
    procedure setpracovni_rezim_id(const Value : Tworker_pracovni_rezim);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property worker_id: TWorker read getworker_id write setworker_id;
    property start: Nullable<TDateTime> read Fstart write Fstart;
    property week_amount: Double read Fweek_amount write Fweek_amount;
    property note: string read Fnote write Fnote;
    property pracovni_rezim_id: Tworker_pracovni_rezim read getpracovni_rezim_id write setpracovni_rezim_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker')]
  [Description('CNC stroje')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tcnc_stroje = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 50)]
    [Description('')]
    Fname: string;

    [Column('bar_id', [TColumnProp.Required], 50)]
    [Description('')]
    Fbar_id: string;

    [Column('comment', [TColumnProp.Lazy])]
    [Description('')]
    [DBTypeMemo]
    Fcomment: TBlob;

    [Column('start', [TColumnProp.Required])]
    [Description('')]
    Fstart: TDateTime;

    [Column('active', [TColumnProp.Required], 20)]
    [Description('')]
    Factive: string;

    [Column('finish', [TColumnProp.Required])]
    [Description('')]
    Ffinish: TDateTime;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('workerprice', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fworkerprice: Double;

    [Column('price_sat', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_sat: Double;

    [Column('price_sun', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_sun: Double;

    [Column('type', [TColumnProp.Required])]
    [Description('')]
    Ftype_: Integer;

    [Column('cnc', [TColumnProp.Required])]
    [Description('')]
    Fcnc: Integer;

    [Column('card', [TColumnProp.Required], 20)]
    [Description('')]
    Fcard: string;

    [Column('group_name', [TColumnProp.Required], 50)]
    [Description('')]
    Fgroup_name: string;

    [Column('profese', [TColumnProp.Required], 50)]
    [Description('')]
    Fprofese: string;

    [Column('misto_prace', [TColumnProp.Required], 50)]
    [Description('')]
    Fmisto_prace: string;

    [Column('smena', [TColumnProp.Required], 50)]
    [Description('')]
    Fsmena: string;

    [Column('dostupne_smeny', [TColumnProp.Required], 256)]
    [Description('')]
    Fdostupne_smeny: string;

    [Column('cnc_start_operation_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_start_operation_id: Integer;

    [Column('cnc_end_operation_id', [TColumnProp.Required])]
    [Description('')]
    Fcnc_end_operation_id: Integer;

    [Column('cnc_operation_prihlaseni', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_prihlaseni: Integer;

    [Column('cnc_operation_kontrola', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_kontrola: Integer;

    [Column('cnc_operation_servis', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_servis: Integer;

    [Column('cnc_operation_odevzdaniks', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_odevzdaniks: Integer;

    [Column('cnc_operation_idle', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_idle: Integer;

    [Column('cnc_operation_alarm', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_alarm: Integer;

    [Column('cnc_operation_sing', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_sing: Integer;

    [Column('cnc_operation_feed', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_feed: Integer;

    [Column('cnc_operation_busy', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_busy: Integer;

    [Column('card_dmr', [TColumnProp.Required], 64)]
    [Description('')]
    Fcard_dmr: string;

    [Column('cnc_operation_udrzba', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_udrzba: Integer;

    [Column('stavCnc', [TColumnProp.Required], 50)]
    [Description('')]
    FstavCnc: string;

    [Column('busyStart', [TColumnProp.Required])]
    [Description('')]
    FbusyStart: TDateTime;

    [Column('lastCycle', [TColumnProp.Required])]
    [Description('')]
    FlastCycle: TDateTime;

    [Column('cnc_operation_konec', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_konec: Integer;

    [Column('cnc_operation_nedefinovano', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_nedefinovano: Integer;

    [Column('cnc_operation_waitkontrola', [TColumnProp.Required])]
    [Description('')]
    Fcnc_operation_waitkontrola: Integer;

    [Column('alias', [TColumnProp.Required], 50)]
    [Description('')]
    Falias: string;

    [Column('priorita', [TColumnProp.Required])]
    [Description('')]
    Fpriorita: Integer;

    [Column('cena_fakturace', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcena_fakturace: Double;

    [Column('use_cena_fakturace', [TColumnProp.Required])]
    [Description('')]
    Fuse_cena_fakturace: Integer;

    [Column('user_pin', [TColumnProp.Required])]
    [Description('')]
    Fuser_pin: Int64;

    [Column('prihlaseni', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fprihlaseni: String;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cnc_group', [], 'id')]
    [Description('')]
    Fcnc_group: proxy<TCNC_group>;

    [Column('price_prescas', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fprice_prescas: Double;

    [Column('pozice', [TColumnProp.Required], 50)]
    [Description('')]
    Fpozice: string;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('id_nadrizeny', [], 'id')]
    [Description('')]
    Fid_nadrizeny: proxy<Tworker>;

    [Column('id_pracovni_skupina', [TColumnProp.Required])]
    [Description('')]
    Fid_pracovni_skupina: Integer;

    [Column('id_ridici_struktura', [TColumnProp.Required])]
    [Description('')]
    Fid_ridici_struktura: Integer;

    [Column('id_profese', [TColumnProp.Required])]
    [Description('')]
    Fid_profese: Integer;

    [Column('id_misto_prace', [TColumnProp.Required])]
    [Description('')]
    Fid_misto_prace: Integer;

    [Column('email', [TColumnProp.Required], 150)]
    [Description('')]
    Femail: string;

    [Column('telefon', [TColumnProp.Required], 150)]
    [Description('')]
    Ftelefon: string;

    [Column('price_mzda', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprice_mzda: Double;

    [Column('cnc_servis_datum', [TColumnProp.Required])]
    [Description('')]
    Fcnc_servis_datum: TDateTime;

    [Column('cnc_servis_interval', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fcnc_servis_interval: Double;

    [Column('cnc_servis_interval_unit', [TColumnProp.Required])]
    [Description('')]
    Fcnc_servis_interval_unit: Integer;

    [Column('koef_skut_nakl', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoef_skut_nakl: Double;

    [Column('gdpr_zbyva', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_zbyva: Integer;

    [Column('gdpr_anonymizovano', [TColumnProp.Required])]
    [Description('')]
    Fgdpr_anonymizovano: Integer;

    [Column('pouzeDochazka', [TColumnProp.Required])]
    [Description('')]
    FpouzeDochazka: Integer;

    [Column('bezCasu', [TColumnProp.Required])]
    [Description('')]
    FbezCasu: Integer;

    [Column('price_sat_koef', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprice_sat_koef: Double;

    [Column('price_sun_koef', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fprice_sun_koef: Double;

    [Column('koef_ukol_mzdy', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoef_ukol_mzdy: Double;

    [Column('koef_ukol_mzdy_type', [TColumnProp.Required])]
    [Description('')]
    Fkoef_ukol_mzdy_type: Integer;

    [Column('koef_ukol_mzdy2', [TColumnProp.Required], 15, 3)]
    [Description('')]
    Fkoef_ukol_mzdy2: Double;

    [Column('koef_ukol_mzdy2_type', [TColumnProp.Required])]
    [Description('')]
    Fkoef_ukol_mzdy2_type: Integer;

    [Column('group_id', [TColumnProp.Required])]
    [Description('')]
    Fgroup_id: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('smena_id', [], 'id')]
    [Description('')]
    Fsmena_id: proxy<Tworker_smeny>;

    [Column('thp', [TColumnProp.Required])]
    [Description('')]
    Fthp: Integer;

    [Column('externi_id', [TColumnProp.Required], 100)]
    [Description('')]
    Fexterni_id: string;

    [Column('firstname', [TColumnProp.Required], 50)]
    [Description('')]
    Ffirstname: string;

    [Column('lastname', [TColumnProp.Required], 100)]
    [Description('')]
    Flastname: string;

    [Column('birthdate', [TColumnProp.Required])]
    [Description('')]
    Fbirthdate: TDateTime;

    [Column('pracovni_pomer', [TColumnProp.Required], 50)]
    [Description('')]
    Fpracovni_pomer: string;

    [Column('ts_lastChange', [])]
    [Description('')]
    Fts_lastChange: Nullable<TDateTime>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('useForMobile', [])]
    [Description('')]
    FuseForMobile: boolean;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('terminzaruky', [TColumnProp.Required])]
    [Description('')]
    Fterminzaruky: TDateTime;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('ciselna_rada_id', [], 'id')]
    [Description('')]
    Fciselna_rada_id: proxy<Tciselne_rady>;


    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcnc_id')]
    Fcnc_operationList: Proxy<TList<Tref_cnc_stroje_operation>>;
    [ManyValuedAssociation([TAssociationProp.Lazy], CascadeTypeAllRemoveOrphan, 'Fcnc_id')]
    Fcnc_operationGroupList: Proxy<TList<Tref_cnc_stroje_operation_group>>;


    FDynCon: TDynamicProperties;

    function Getcnc_operationList: TList<Tref_cnc_stroje_operation>;
    function Getcnc_operationGroupList: TList<Tref_cnc_stroje_operation_group>;
    function getcnc_group: TCNC_group;
    procedure setcnc_group(const Value : TCNC_group);
    function getid_nadrizeny: Tworker;
    procedure setid_nadrizeny(const Value : Tworker);
    function getciselna_rada_id: Tciselne_rady;
    procedure setciselna_rada_id(const Value : Tciselne_rady);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property bar_id: string read Fbar_id write Fbar_id;
    property comment: TBlob read Fcomment write Fcomment;
    property start: TDateTime read Fstart write Fstart;
    property active: string read Factive write Factive;
    property finish: TDateTime read Ffinish write Ffinish;
    property user: string read Fuser write Fuser;
    property workerprice: Double read Fworkerprice write Fworkerprice;
    property price_sat: Double read Fprice_sat write Fprice_sat;
    property price_sun: Double read Fprice_sun write Fprice_sun;
    property type_: Integer read Ftype_ write Ftype_;
    property cnc: Integer read Fcnc write Fcnc;
    property card: string read Fcard write Fcard;
    property group_name: string read Fgroup_name write Fgroup_name;
    property profese: string read Fprofese write Fprofese;
    property misto_prace: string read Fmisto_prace write Fmisto_prace;
    property smena: string read Fsmena write Fsmena;
    property dostupne_smeny: string read Fdostupne_smeny write Fdostupne_smeny;
    property cnc_start_operation_id: Integer read Fcnc_start_operation_id write Fcnc_start_operation_id;
    property cnc_end_operation_id: Integer read Fcnc_end_operation_id write Fcnc_end_operation_id;
    property cnc_operation_prihlaseni: Integer read Fcnc_operation_prihlaseni write Fcnc_operation_prihlaseni;
    property cnc_operation_kontrola: Integer read Fcnc_operation_kontrola write Fcnc_operation_kontrola;
    property cnc_operation_servis: Integer read Fcnc_operation_servis write Fcnc_operation_servis;
    property cnc_operation_odevzdaniks: Integer read Fcnc_operation_odevzdaniks write Fcnc_operation_odevzdaniks;
    property cnc_operation_idle: Integer read Fcnc_operation_idle write Fcnc_operation_idle;
    property cnc_operation_alarm: Integer read Fcnc_operation_alarm write Fcnc_operation_alarm;
    property cnc_operation_sing: Integer read Fcnc_operation_sing write Fcnc_operation_sing;
    property cnc_operation_feed: Integer read Fcnc_operation_feed write Fcnc_operation_feed;
    property cnc_operation_busy: Integer read Fcnc_operation_busy write Fcnc_operation_busy;
    property card_dmr: string read Fcard_dmr write Fcard_dmr;
    property cnc_operation_udrzba: Integer read Fcnc_operation_udrzba write Fcnc_operation_udrzba;
    property stavCnc: string read FstavCnc write FstavCnc;
    property busyStart: TDateTime read FbusyStart write FbusyStart;
    property lastCycle: TDateTime read FlastCycle write FlastCycle;
    property cnc_operation_konec: Integer read Fcnc_operation_konec write Fcnc_operation_konec;
    property cnc_operation_nedefinovano: Integer read Fcnc_operation_nedefinovano write Fcnc_operation_nedefinovano;
    property cnc_operation_waitkontrola: Integer read Fcnc_operation_waitkontrola write Fcnc_operation_waitkontrola;
    property alias: string read Falias write Falias;
    property priorita: Integer read Fpriorita write Fpriorita;
    property cena_fakturace: Double read Fcena_fakturace write Fcena_fakturace;
    property use_cena_fakturace: Integer read Fuse_cena_fakturace write Fuse_cena_fakturace;
    property user_pin: Int64 read Fuser_pin write Fuser_pin;
    property prihlaseni: String read Fprihlaseni;
    property cnc_group: TCNC_group read getcnc_group write setcnc_group;
    property price_prescas: Double read Fprice_prescas write Fprice_prescas;
    property pozice: string read Fpozice write Fpozice;
    property id_nadrizeny: Tworker read getid_nadrizeny write setid_nadrizeny;
    property id_pracovni_skupina: Integer read Fid_pracovni_skupina write Fid_pracovni_skupina;
    property id_ridici_struktura: Integer read Fid_ridici_struktura write Fid_ridici_struktura;
    property id_profese: Integer read Fid_profese write Fid_profese;
    property id_misto_prace: Integer read Fid_misto_prace write Fid_misto_prace;
    property email: string read Femail write Femail;
    property telefon: string read Ftelefon write Ftelefon;
    property price_mzda: Double read Fprice_mzda write Fprice_mzda;
    property cnc_servis_datum: TDateTime read Fcnc_servis_datum write Fcnc_servis_datum;
    property cnc_servis_interval: Double read Fcnc_servis_interval write Fcnc_servis_interval;
    property cnc_servis_interval_unit: Integer read Fcnc_servis_interval_unit write Fcnc_servis_interval_unit;
    property koef_skut_nakl: Double read Fkoef_skut_nakl write Fkoef_skut_nakl;
    property gdpr_zbyva: Integer read Fgdpr_zbyva write Fgdpr_zbyva;
    property gdpr_anonymizovano: Integer read Fgdpr_anonymizovano write Fgdpr_anonymizovano;
    property pouzeDochazka: Integer read FpouzeDochazka write FpouzeDochazka;
    property bezCasu: Integer read FbezCasu write FbezCasu;
    property price_sat_koef: Double read Fprice_sat_koef write Fprice_sat_koef;
    property price_sun_koef: Double read Fprice_sun_koef write Fprice_sun_koef;
    property koef_ukol_mzdy: Double read Fkoef_ukol_mzdy write Fkoef_ukol_mzdy;
    property koef_ukol_mzdy_type: Integer read Fkoef_ukol_mzdy_type write Fkoef_ukol_mzdy_type;
    property koef_ukol_mzdy2: Double read Fkoef_ukol_mzdy2 write Fkoef_ukol_mzdy2;
    property koef_ukol_mzdy2_type: Integer read Fkoef_ukol_mzdy2_type write Fkoef_ukol_mzdy2_type;
    property group_id: Integer read Fgroup_id write Fgroup_id;
    property thp: Integer read Fthp write Fthp;
    property externi_id: string read Fexterni_id write Fexterni_id;
    property firstname: string read Ffirstname write Ffirstname;
    property lastname: string read Flastname write Flastname;
    property birthdate: TDateTime read Fbirthdate write Fbirthdate;
    property pracovni_pomer: string read Fpracovni_pomer write Fpracovni_pomer;
    property ts_lastChange: Nullable<TDateTime> read Fts_lastChange write Fts_lastChange;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property terminzaruky: TDateTime read Fterminzaruky write Fterminzaruky;
    property useForMobile : boolean read FuseForMobile write FuseForMobile;
    property ciselna_rada_id: Tciselne_rady read getciselna_rada_id write setciselna_rada_id;
    property cnc_operationList: TList<Tref_cnc_stroje_operation> read Getcnc_operationList;
    property cnc_operationGroupList: TList<Tref_cnc_stroje_operation_group> read Getcnc_operationGroupList;
    property DynCon: TDynamicProperties read FDynCon;
  end;


  [Entity]
  [Table('zakazky_objednavky')]
  [Description('Plneni prijatych objednavek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tzakazky_objednavky = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Int64;

    [Column('polozka_prijate_objednavky_id', [TColumnProp.Required])]
    [Description('')]
    Fpolozka_prijate_objednavky_id: Int64;

    [Column('order_id', [], 50)]
    [Description('')]
    Forder_id: Nullable<string>;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    property id: Int64 read Fid write Fid;
    property polozka_prijate_objednavky_id: Int64 read Fpolozka_prijate_objednavky_id write Fpolozka_prijate_objednavky_id;
    property order_id: Nullable<string> read Forder_id write Forder_id;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('zpusob_dopravy')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tzpusob_dopravy = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;
    
    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;

    [Column('platby', [], 50)]
    [Description('')]
    Fplatby: Nullable<string>;

    [Column('poznamka', [], 200)]
    [Description('')]
    Fpoznamka: Nullable<string>;

    [Column('castka', [TColumnProp.Required], 15, 2)]
    [Description('')]
    Fcastka: Double;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    [Column('is_default', [TColumnProp.Required])]
    [Description('')]
    Fis_default: Boolean;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property platby: Nullable<string> read Fplatby write Fplatby;
    property poznamka: Nullable<string> read Fpoznamka write Fpoznamka;
    property castka: Double read Fcastka write Fcastka;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property is_default: Boolean read Fis_default write Fis_default;
    property DynCon: TDynamicProperties read FDynCon;
  end;
  
  [Entity]
  [Table('zpusob_platby')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tzpusob_platby = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('nazev', [TColumnProp.Required], 50)]
    [Description('')]
    Fnazev: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;
    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property nazev: string read Fnazev write Fnazev;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_material_prijemky_doc')]
  [Description('dokumenty Prijemek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_prijemky_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('isfile', [TColumnProp.Required])]
    [Description('')]
    Fisfile: Boolean;

    [Column('defaultdocument', [TColumnProp.Required])]
    [Description('')]
    Fdefaultdocument: Boolean;

    [Column('user', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 200)]
    [Description('')]
    Fusercreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('prijem_id', [TColumnProp.Required], 'id')]
    [Description('')]
    FPrijem_id: proxy<TSklad_material_prijemky>;
    function getPrijem_id: TSklad_material_prijemky;
    procedure setPrijem_id(const Value : TSklad_material_prijemky);
    function getextensionType : integer;
    function getdoctype : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isfile: Boolean read Fisfile write Fisfile;
    property defaultdocument: Boolean read Fdefaultdocument write Fdefaultdocument;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property Prijem_id: TSklad_material_prijemky read getPrijem_id write setPrijem_id;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
  end;

  [Entity]
  [Table('sklad_material_vydejky_doc')]
  [Description('dokumenty Vydejek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_vydejky_doc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('path', [TColumnProp.Required], 255)]
    [Description('')]
    Fpath: string;

    [Column('isfile', [TColumnProp.Required])]
    [Description('')]
    Fisfile: Boolean;

    [Column('defaultdocument', [TColumnProp.Required])]
    [Description('')]
    Fdefaultdocument: Boolean;

    [Column('user', [TColumnProp.Required], 200)]
    [Description('')]
    Fuser: string;

    [Column('usercreated', [TColumnProp.Required], 200)]
    [Description('')]
    Fusercreated: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;
    FDynCon: TDynamicProperties;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('vydej_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fvydej_id: proxy<TSklad_material_vydejky>;
    function getvydej_id: TSklad_material_vydejky;
    procedure setvydej_id(const Value : TSklad_material_vydejky);
    function getextensionType : integer;
    function getdoctype : string;
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property path: string read Fpath write Fpath;
    property isfile: Boolean read Fisfile write Fisfile;
    property defaultdocument: Boolean read Fdefaultdocument write Fdefaultdocument;
    property user: string read Fuser write Fuser;
    property usercreated: string read Fusercreated write Fusercreated;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property DynCon: TDynamicProperties read FDynCon;
    property vydej_id: TSklad_material_vydejky read getvydej_id write setvydej_id;
    property extensionType : integer read getextensionType;
    property docType : string read getdocType;
  end;

  [Entity]
  [Table('ref_operation_stroj')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_operation_stroj = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_id: proxy<Toperation>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('stroj_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fstroj_id: proxy<Tstroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_id: Toperation;
    procedure setoperation_id(const Value : Toperation);
    function getstroj_id: Tstroje;
    procedure setstroj_id(const Value : Tstroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property stroj_id: Tstroje read getstroj_id write setstroj_id;
    property operation_id: Toperation read getoperation_id write setoperation_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;


  [Entity]
  [Table('ref_operation_group_stroj')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_operation_group_stroj = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_group_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_group_id: proxy<TOperation_group>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('stroj_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fstroj_id: proxy<Tstroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_group_id: TOperation_group;
    procedure setoperation_group_id(const Value : TOperation_group);
    function getstroj_id: Tstroje;
    procedure setstroj_id(const Value : Tstroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property operation_group_id: TOperation_group read getoperation_group_id write setoperation_group_id;
    property stroj_id: Tstroje read getstroj_id write setstroj_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_operation_stroj')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_stroj_operation = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_id: proxy<Toperation>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('stroj_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fstroj_id: proxy<Tstroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_id: Toperation;
    procedure setoperation_id(const Value : Toperation);
    function getstroj_id: Tstroje;
    procedure setstroj_id(const Value : Tstroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property stroj_id: Tstroje read getstroj_id write setstroj_id;
    property operation_id: Toperation read getoperation_id write setoperation_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_operation_group_stroj')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_stroj_operation_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_group_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Foperation_group_id: proxy<TOperation_group>;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('stroj_id', [TColumnProp.Required], 'id')]
    [Description('')]
    Fstroj_id: proxy<Tstroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;

    function getoperation_group_id: TOperation_group;
    procedure setoperation_group_id(const Value : TOperation_group);
    function getstroj_id: Tstroje;
    procedure setstroj_id(const Value : Tstroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property operation_group_id: TOperation_group read getoperation_group_id write setoperation_group_id;
    property stroj_id: Tstroje read getstroj_id write setstroj_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;


  [Entity]
  [Table('user_import_button_settings')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tuser_import_button_settings = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('agenda', [])]
    [Description('')]
    Fagenda : Integer;

    [Column('name', [], 50)]
    [Description('')]
    Fname: string;

    [Column('typ', [])]
    [Description('')]
    Ftyp: Integer;

    [Column('link', [], 200)]
    [Description('')]
    Flink: string;

    [Column('params', [], 200)]
    [Description('')]
    Fparams: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property agenda : Integer read Fagenda write Fagenda;
    property name : string read Fname write Fname;
    property typ : Integer read Ftyp write Ftyp;
    property link : string read Flink write Flink;
    property params : string read Fparams write Fparams;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
  end;

  [Entity]
  [Table('doc_create_path')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tdoc_create_path = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('tabulka', [])]
    [Description('')]
    Ftabulka : Integer;

    [Column('path', [], 250)]
    [Description('')]
    Fpath : string;

    [Column('item_name', [])]
    [Description('')]
    Fitem_name : boolean;

    [Column('create_path_sub_order', [])]
    [Description('')]
    Fcreate_path_sub_order : boolean;

    [Column('is_default', [])]
    [Description('')]
    Fis_default : boolean;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property tabulka : Integer read Ftabulka write Ftabulka;
    property path : string read Fpath write Fpath;
    property item_name : boolean read Fitem_name write Fitem_name;
    property create_path_sub_order : boolean read Fcreate_path_sub_order write Fcreate_path_sub_order;
    property is_default : boolean read Fis_default write Fis_default;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
  end;

  [Entity]
  [Table('ref_operation_group_cnc')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_operation_group_cnc = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_group_id', [], 'id')]
    [Description('')]
    Foperation_group_id: proxy<TOperation_group>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cnc_id', [])]
    [Description('')]
    Fcnc_id: proxy<Tcnc_stroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_group_id: TOperation_group;
    procedure setoperation_group_id(const Value : TOperation_group);
    function getcnc_id: Tcnc_stroje;
    procedure setcnc_id(const Value : Tcnc_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property operation_group_id: TOperation_group read getoperation_group_id write setoperation_group_id;
    property cnc_id: Tcnc_stroje read getcnc_id write setcnc_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('ref_operation_group_cnc')]
  [Description('')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tref_cnc_stroje_operation_group = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy, TAssociationProp.Required], CascadeTypeNone)]
    [JoinColumn('operation_group_id', [], 'id')]
    [Description('')]
    Foperation_group_id: proxy<TOperation_group>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('cnc_id', [])]
    [Description('')]
    Fcnc_id: proxy<Tcnc_stroje>;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [TColumnProp.Required], 50)]
    [Description('')]
    FuserCreated: string;

    [Column('user', [TColumnProp.Required], 50)]
    [Description('')]
    Fuser: string;

    FDynCon: TDynamicProperties;
    function getoperation_group_id: TOperation_group;
    procedure setoperation_group_id(const Value : TOperation_group);
    function getcnc_id: Tcnc_stroje;
    procedure setcnc_id(const Value : Tcnc_stroje);
  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property operation_group_id: TOperation_group read getoperation_group_id write setoperation_group_id;
    property cnc_id: Tcnc_stroje read getcnc_id write setcnc_id;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: string read FuserCreated write FuserCreated;
    property user: string read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_skupina')]
  [Description('selnk skupin zamstnanc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_skupina = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_pozice')]
  [Description('selnk pozic zamstnanc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_pozice = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_profese')]
  [Description('selnk profes zamstnanc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_profese = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('worker_misto_prace')]
  [Description('selnk mst prce zamstnanc')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tworker_misto_prace = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Column('name', [TColumnProp.Required], 100)]
    [Description('')]
    Fname: string;

    [Column('ts_created', [])]
    [Description('')]
    Fts_created: Nullable<TDateTime>;

    [Column('ts_lastchange', [])]
    [Description('')]
    Fts_lastchange: Nullable<TDateTime>;

    [Column('userCreated', [], 50)]
    [Description('')]
    FuserCreated: Nullable<string>;

    [Column('user', [], 50)]
    [Description('')]
    Fuser: Nullable<string>;

    FDynCon: TDynamicProperties;
  public
    constructor Create; override;
    destructor Destroy; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    function CheckRequiredFields : boolean; override;
    property id: Integer read Fid write Fid;
    property name: string read Fname write Fname;
    property ts_created: Nullable<TDateTime> read Fts_created write Fts_created;
    property ts_lastchange: Nullable<TDateTime> read Fts_lastchange write Fts_lastchange;
    property userCreated: Nullable<string> read FuserCreated write FuserCreated;
    property user: Nullable<string> read Fuser write Fuser;
    property DynCon: TDynamicProperties read FDynCon;
  end;

  [Entity]
  [Table('sklad_material_coef_unit')]
  [Description('selnk pevodnch koef. jednotek')]
  [Id('Fid', TIdGenerator.IdentityOrSequence)]
  Tsklad_material_coef_unit = class(TTMSAGObject)
  private
    [Column('id', [TColumnProp.Required, TColumnProp.NoInsert, TColumnProp.NoUpdate])]
    [Description('')]
    Fid: Integer;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('material_id', [], 'id')]
    [Description('')]
    Fmaterial_id: proxy<Tsklad_material>;

    [Association([TAssociationProp.Lazy], CascadeTypeNone)]
    [JoinColumn('unit', [], 'id_correct')]
    [Description('')]
    Funit_: proxy<Tjednotky>;

    [Column('coef_unit', [TColumnProp.Required], 15, 4)]
    [Description('')]
    Fcoef_unit: Double;

    [Column('is_default', [TColumnProp.Required])]
    [Description('')]
    Fis_default : Boolean;

    [Column('active', [TColumnProp.Required])]
    [Description('')]
    Factive : Boolean;

    FDynCon: TDynamicProperties;

    function getmaterial_id: Tsklad_material;
    procedure setmaterial_id(const Value : Tsklad_material);
    function getunit_: Tjednotky;
    procedure setunit_(const Value : Tjednotky);

  public
    constructor Create; override;
    destructor Destroy; override;
    procedure Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = ''); override;
    function CheckRequiredFields : boolean; override;
    Function CanDeleteRecord(var aMessage : String) : Boolean; override;
    property id: Integer read Fid write Fid;
    property material_id: Tsklad_material read getmaterial_id write setmaterial_id;
    property unit_: TJednotky read getunit_ write setunit_;
    property coef_unit: double read fcoef_unit write fcoef_unit;
    property is_default: boolean read fis_default write fis_default;
    property active: boolean read factive write factive;

    property DynCon: TDynamicProperties read FDynCon;
  end;


implementation

uses
  uAureliusDict, uDMResourceStrings, RegularExpressions,
  {$IFNDEF ETMSTEST}
    uSQLFunctions,
  {$ENDIF}
  uGlobalVar, Math;

{ Taktualni_stav }

constructor Taktualni_stav.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Taktualni_stav.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Taktualni_stav_details }

constructor Taktualni_stav_details.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Taktualni_stav_details.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tauto_login }

constructor Tauto_login.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tauto_login.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcalc }

constructor Tcalc.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcalc.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcalendar }

constructor Tcalendar.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcalendar.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcalendar_day }

constructor Tcalendar_day.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcalendar_day.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcidla }

constructor Tcidla.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcidla.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tcidla.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  {$IFNDEF ETMSTEST}
  bar_id := TSQLFunctions.GetCidla_NewBar_ID;
  {$ELSE}
  bar_id := 'TST0000001';
  {$ENDIF}
end;

function Tcidla.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty and  not Trim(bar_id).IsEmpty and
                (Trim(bar_id) <> '0')  ;
end;
{ Tcidla_readdata }

constructor Tcidla_readdata.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcidla_readdata.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tciselne_rady }

function Tciselne_rady.CanDeleteRecord(var aMessage: String): Boolean;
var
  Idx : Integer;
begin
  Result := inherited CanDeleteRecord(aMessage);
  Idx := AureliusDict.GetTabulkyIdx(agenda_kod, AureliusDict.TabulkyCiselneRady);
  if AureliusDict.TabulkyCiselneRady[Idx].FieldName = '' then
    Exit;

  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists(AureliusDict.TabulkyCiselneRady[idx].TableName, AureliusDict.TabulkyCiselneRady[idx].FieldName, id.ToString) then
  begin
    Result := False;
    aMessage := aMessage +  message1617;
  end;
  {$ENDIF}
end;

constructor Tciselne_rady.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tciselne_rady.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tciselne_rady.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  cislo := '0000';
  oddelovac := '-';
  prefix := 'ABC';
  aktivni := True;
  isSablona := False;
end;

function Tciselne_rady.CheckRequiredFields : boolean;
begin
  Result := not Trim(cislo).IsEmpty and not Trim(nazev).IsEmpty and
            not Trim(agenda).IsEmpty and  not Trim(Prefix).IsEmpty;
end;
{ Tcis_den }

constructor Tcis_den.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcis_den.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tciselne_rady_doklady_pravidla }

constructor Tciselne_rady_doklady_pravidla.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tciselne_rady_doklady_pravidla.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tciselne_rady_doklady_pravidla.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
end;

function Tciselne_rady_doklady_pravidla.CheckRequiredFields : boolean;
begin
  Result := (doklad_vychozi <> '') and (doklad_vznikajici <> '') and
            assigned(ciselna_rada_id_vychozi) and assigned(ciselna_rada_id_vznikajici);
  if doklad_vychozi = CAgendaPrijemky then Result := Result and assigned(typ_prijemky_id);
  if doklad_vychozi = CAgendavydejky then Result := Result and assigned(typ_vydejky_id);
end;

function Tciselne_rady_doklady_pravidla.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.DuplicatedPravidloExists (doklad_vychozi,ciselna_rada_id_vychozi.id,ID.ToString) then
  begin
    Result := False;
    aMessage := message1840;
  end;
  {$ELSE}
  begin
    Result := False;
    aMessage := message1840;
  end;
  {$ENDIF}
end;

function Tciselne_rady_doklady_pravidla.getciselna_rada_id_vychozi: Tciselne_rady;
begin
  Result := fciselna_rada_id_vychozi.Value;
end;

procedure Tciselne_rady_doklady_pravidla.setciselna_rada_id_vychozi(const Value : Tciselne_rady);
begin
  fciselna_rada_id_vychozi.Value := Value;
end;

function Tciselne_rady_doklady_pravidla.getciselna_rada_id_vznikajici: Tciselne_rady;
begin
  Result := fciselna_rada_id_vznikajici.Value;
end;

procedure Tciselne_rady_doklady_pravidla.setciselna_rada_id_vznikajici(const Value : Tciselne_rady);
begin
  fciselna_rada_id_vznikajici.Value := Value;
end;

function Tciselne_rady_doklady_pravidla.gettyp_prijemky_id: Tsklad_material_prijemky_typy;
begin
  // Result := ftyp_prijemky_id.Value;
  if doklad_vznikajici = CAgendaPrijemky then
  begin
   Result :=MyArManager.Find<Tsklad_material_prijemky_typy>(self.Ftyp_skladovy_doklad_id);
  end else
      Result := nil;
end;

procedure Tciselne_rady_doklady_pravidla.settyp_prijemky_id(const AValue : Tsklad_material_prijemky_typy);
begin
  if doklad_vznikajici = CAgendaPrijemky then
     ftyp_skladovy_doklad_id := AValue.Fid;
end;

function Tciselne_rady_doklady_pravidla.gettyp_vydejky_id: Tsklad_material_vydejky_typy;
begin
  //Result := ftyp_vydejky_id.Value;
  if doklad_vznikajici = CAgendaVydejky then
  begin
   Result :=MyArManager.Find<Tsklad_material_vydejky_typy>(self.Ftyp_skladovy_doklad_id);
  end else
      Result := nil;
end;

procedure Tciselne_rady_doklady_pravidla.settyp_vydejky_id(const AValue : Tsklad_material_vydejky_typy);
begin
  if doklad_vznikajici = CAgendaVydejky then
     ftyp_skladovy_doklad_id := AValue.Fid;
end;

{ Tcis_frekvence }

constructor Tcis_frekvence.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcis_frekvence.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcis_pozice }

constructor Tcis_pozice.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcis_pozice.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcis_pracovni_skupina }

constructor Tcis_pracovni_skupina.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcis_pracovni_skupina.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcis_typ_provoz }

constructor Tcis_typ_provoz.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcis_typ_provoz.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcis_typ_smeny }

constructor Tcis_typ_smeny.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcis_typ_smeny.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcnc_group }

constructor Tcnc_group.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcnc_group.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

Function Tcnc_group.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('worker','cnc_group', id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1604+' '+AnsiLowercase(copy(message1630,1,1)+copy(message1630,2,length(message1630)-1))  +#13#10;
    Exit;
  end;
  {$ELSE}
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1604+' '+AnsiLowercase(copy(message1630,1,1)+copy(message1630,2,length(message1630)-1))  +#13#10;
    Exit;
  end;
  {$ENDIF}
end;

function Tcnc_group.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty;
end;


{ Tcnc_import_casu }

constructor Tcnc_import_casu.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcnc_import_casu.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcolors }

constructor Tcolors.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcolors.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcolumns }

constructor Tcolumns.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcolumns.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcolumns_backup }

constructor Tcolumns_backup.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcolumns_backup.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcolumns_caption }

constructor Tcolumns_caption.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcolumns_caption.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcolumns_change_type }

constructor Tcolumns_change_type.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcolumns_change_type.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcolumns_log }

constructor Tcolumns_log.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcolumns_log.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tconfig }

constructor Tconfig.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tconfig.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tcustomer }

function Tcustomer.getnadrizena_id: Tcustomer;
begin
  Result := fnadrizena_id.Value;
end;

procedure Tcustomer.setnadrizena_id(const Value: Tcustomer);
begin
  fnadrizena_id.Value := Value;
end;

function Tcustomer.getgroup_id: Tcustomer_skupiny;
begin
  Result := fgroup_id.Value;
end;

procedure Tcustomer.setgroup_id(const Value: Tcustomer_skupiny);
begin
  fgroup_id.Value := Value;
  If Assigned(Value) Then
    if Assigned(group_id.ciselna_rada_ID) and
       (ciselna_rada_id <> group_id.Ciselna_rada_id) Then
          ciselna_rada_id := group_id.Ciselna_rada_id;
end;

function Tcustomer.getcm_mena: Tkurz_meny;
begin
  Result := fcm_mena.Value;
end;

procedure Tcustomer.setcm_mena(const Value: Tkurz_meny);
begin
  fcm_mena.Value := Value;
end;

function Tcustomer.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Tcustomer.setciselna_rada_id(const Value: Tciselne_rady);
begin
  If Assigned(Value) AND (fciselna_rada_id.Value <> Value) Then
    {$IFNDEF ETMSTEST}
    Bar_ID := TSQLFunctions.Bar_IDDleRady(Value.ID, 'zakaznici', 'customer', 'bar_id');
    {$ELSE}
    Bar_ID := 'TTST0000001';
    {$ENDIF}
  fciselna_rada_id.Value := Value;
end;

function Tcustomer.getplatba_id: Tzpusob_platby;
begin
  Result := fplatba_id.Value;
end;

procedure Tcustomer.setplatba_id(const Value: Tzpusob_platby);
begin
  fplatba_id.Value := Value;
end;

function Tcustomer.getdoprava_id: Tzpusob_dopravy;
begin
  Result := fdoprava_id.Value;
end;

procedure Tcustomer.setdoprava_id(const Value: Tzpusob_dopravy);
begin
  fdoprava_id.Value := Value;
end;

constructor Tcustomer.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Fcustomer_adresyList.SetInitialValue(TList<Tcustomer_adresy>.Create);
  Fcustomer_osobyList.SetInitialValue(TList<Tcustomer_osoby>.Create);
  Fcustomer_udalostiList.SetInitialValue(TList<Tcustomer_udalosti>.Create);
end;

destructor Tcustomer.Destroy;
begin
  Fcustomer_udalostiList.DestroyValue;
  Fcustomer_osobyList.DestroyValue;
  Fcustomer_adresyList.DestroyValue;
  FDynCon.Free;
  inherited;
end;

procedure Tcustomer.setosoba(const Value : string);
begin
  fosoba := Value;
  fak_osoba := osoba;
end;

procedure Tcustomer.setname(const Value : string);
begin
  fname := Value;
  dod_firma := name;
end;

class procedure TCustomer.checkNewRecord;
begin
  inherited;
    {$IFNDEF ETMSTEST}
  TSQLFunctions.CheckRadaDokladu('Zakaznici');
  {$ENDIF}
end;

function TCustomer.CheckRequiredFields: boolean;
begin
  Result := (Trim(bar_ID) <> '') and
            (Trim(name) <> '') and
            Assigned(Ciselna_rada_ID) and
            (typ <> -1);
end;

procedure TCustomer.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  Ciselna_rada_ID := GetCiselnaRada_Prefill('zakaznici', 0);
end;

function TCustomer.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);
  if Assigned(nadrizena_id) and (nadrizena_id = self) then
    begin
      Result := False;
      aMessage := aMessage + message1635+#13#10;
      Exit;
    end;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.DuplicationExists('customer', 'bar_id', bar_id, id.ToString) Then
    begin
        Result := False;
        aMessage := aMessage + message39+#13#10;
    end;
  {$ENDIF}
end;

Function TCustomer.CanDeleteRecord(var aMessage : String) : Boolean;
begin
  Result := True;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('c_order','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('dodaci_listy','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_material_prijemky','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_material_vydejky','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('objednavky','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('objednavky_prijate','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('customer','nadrizena_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_formy','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_formy','dodavatel_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_material','dodavatel_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_material_dodavatele','dodavatel_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_material_ceniky','customer_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('sklad_naradi','dodavatel_id', id.ToString) then
    Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('packages','customer_id', id.ToString) then
    Result := False;
  {$ENDIF}

  if not Result then
  begin
    if aMessage = ''
      then aMessage := message1749 + #13#10 + Bar_id.QuotedString
      else aMessage := Bar_id;
  end;
end;


function Tcustomer.Getcustomer_adresyList: TList<Tcustomer_adresy>;
begin
  result := Fcustomer_adresyList.Value;
end;

function Tcustomer.Getcustomer_osobyList: TList<Tcustomer_osoby>;
begin
  result := Fcustomer_osobyList.Value;
end;

function Tcustomer.Getcustomer_udalostiList: TList<Tcustomer_udalosti>;
begin
  result := Fcustomer_udalostiList.Value;
end;

{ Tcustomer_adresy }

function Tcustomer_adresy.getcustomer_id: Tcustomer;
begin
  Result := fcustomer_id.Value;
end;

procedure Tcustomer_adresy.setcustomer_id(const Value: Tcustomer);
begin
  fcustomer_id.Value := Value;
end;

constructor Tcustomer_adresy.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcustomer_adresy.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tcustomer_adresy.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
  Begin
    customer_id := Tcustomer(aHeader_Object);
    Tcustomer(aHeader_Object).customer_adresyList.Add(Self);
  End;
  if aHeader_ID <> 0 then
  begin
    customer_id :=  MyarManager.Find<Tcustomer>(aHeader_ID);
  end;

end;

Function Tcustomer_adresy.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('dodaci_listy','dodaciadresa', id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1621+#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('objednavky_prijate','dodaciadresa', id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+  message1557+#13#10;
    Exit;
  end;
  {$ENDIF}
end;

function Tcustomer_adresy.CheckRequiredFields : boolean;
begin
  Result := not Trim(dod_osoba).IsEmpty;
end;

{ Tcustomer_osoby }

function Tcustomer_osoby.getcustomer_id: Tcustomer;
begin
  Result := fcustomer_id.Value;
end;

procedure Tcustomer_osoby.setcustomer_id(const Value: Tcustomer);
begin
  fcustomer_id.Value := Value;
end;

constructor Tcustomer_osoby.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcustomer_osoby.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tcustomer_osoby.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
  Begin
    customer_id := Tcustomer(aHeader_Object);
    Tcustomer(aHeader_Object).customer_osobyList.Add(Self);
    Jmeno := '';
    Prijmeni := '';
  End;
  if aHeader_ID <> 0 then
  begin
    customer_id := MyarManager.Find<Tcustomer>(aHeader_ID);
  end;

end;

function Tcustomer_osoby.CheckRequiredFields : boolean;
begin
  Result := not Trim(jmeno).IsEmpty and not Trim(prijmeni).IsEmpty;
end;

{ Tcustomer_skupiny }

constructor Tcustomer_skupiny.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcustomer_skupiny.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tcustomer_skupiny.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Tcustomer_skupiny.setciselna_rada_id(const Value: Tciselne_rady);
begin
  fciselna_rada_id.Value := Value;
end;

Function Tcustomer_skupiny.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('customer','group_id', id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1563+#13#10;
    Exit;
  end;
  {$ENDIF}

end;

function Tcustomer_skupiny.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty;
end;

{ Tcustomer_udalosti }

function Tcustomer_udalosti.getcustomer_id: Tcustomer;
begin
  Result := fcustomer_id.Value;
end;

procedure Tcustomer_udalosti.setcustomer_id(const Value: Tcustomer);
begin
  fcustomer_id.Value := Value;
end;

function Tcustomer_udalosti.gettyp2 : string;
begin
  case ftyp of
   1 : Result := message1641;
   2 : Result := 'Email';
   3 : Result := message1642;
   else Result := '';
  end;
end;

constructor Tcustomer_udalosti.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcustomer_udalosti.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tcustomer_udalosti.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
  Begin
    customer_id := Tcustomer(aHeader_Object);
    Tcustomer(aHeader_Object).customer_UdalostiList.Add(Self);
  End;
  if aHeader_ID <> 0 then
  begin
    customer_id := MyarManager.Find<Tcustomer>(aHeader_ID);
  end;
  datum := Now;
  typ := 1;

end;

function Tcustomer_udalosti.CheckRequiredFields : boolean;
begin
  Result := not Trim(predmet).IsEmpty and (typ <> 0) and
            (not datum.IsNull) ;
end;
{ Tcustomer_udalosti_typy }

constructor Tcustomer_udalosti_typy.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tcustomer_udalosti_typy.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tc_order }

function Tc_order.getcreated_mat_id: Tsklad_material;
begin
  Result := fcreated_mat_id.Value;
end;

procedure Tc_order.setcreated_mat_id(const Value: Tsklad_material);
begin
  fcreated_mat_id.Value := Value;
end;

constructor Tc_order.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Forder_workList.SetInitialValue(TList<Torder_work>.Create);
end;

destructor Tc_order.Destroy;
begin
  Forder_workList.DestroyValue;
  FDynCon.Free;
  inherited;
end;

function Tc_order.Getorder_workList: TList<Torder_work>;
begin
  result := Forder_workList.Value;
end;

{ Tc_order_calc }

constructor Tc_order_calc.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tc_order_calc.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tc_order_doc }

constructor Tc_order_doc.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tc_order_doc.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tc_order_doc.getextensionType : integer;
begin
  Result := _GetExtensionType(path);
end;

function Tc_order_doc.getdoctype : string;
begin
  Result := _GetDocType(isFile);
end;

{ Tc_order_parameters }

constructor Tc_order_parameters.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tc_order_parameters.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tc_order_parameters_def }

constructor Tc_order_parameters_def.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tc_order_parameters_def.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdatum }

constructor Tdatum.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdatum.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdochazka }

constructor Tdochazka.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdochazka.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdochazka_mirror }

constructor Tdochazka_mirror.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdochazka_mirror.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdochazka_note }

constructor Tdochazka_note.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdochazka_note.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdochazka_typy_operaci }

constructor Tdochazka_typy_operaci.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdochazka_typy_operaci.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

Function Tdochazka_typy_operaci.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Idx: string;
  Text: string;
  Operace, Skupiny: string;
  Chyba: Boolean;
begin
  Result := True;
  Chyba := False;
  aMessage := '';
  Text := message673+' '+message1620;
  Idx :=  id.ToString;
  if self.system then
  begin
     Result := False;
     aMessage := aMessage + message1645+message773+  #13#10;
     Exit;
  end;
  Operace := seznam_operaci;
  Skupiny := seznam_skupin;
  {$IFNDEF ETMSTEST}
  if Operace <> '' then
  begin
    if TSQLFunctions.OperaceExist(Operace) then
      Chyba := True;
  end;
  if Skupiny <> '' then
  begin
    if TSQLFunctions.OperaceSkupinaExist(Skupiny) then
      Chyba := True;
  end;
  {$ENDIF}
  if Chyba then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+  CaptionNactenaData+#13#10;
    Exit;
  end;
end;

function Tdochazka_typy_operaci.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty;
end;

{ Tdochazka_verze }

constructor Tdochazka_verze.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdochazka_verze.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdodaci_listy }

function Tdodaci_listy.gethlavni_mena: Tkurz_meny;
begin
  Result := fhlavni_mena.Value;
end;

procedure Tdodaci_listy.sethlavni_mena(const Value: Tkurz_meny);
begin
  fhlavni_mena.Value := Value;
end;

function Tdodaci_listy.getcm_kurz: Double;
begin
  Result := Fcm_kurz;
  If Result = 0 Then
    Result := 1;
end;

procedure Tdodaci_listy.setcm_kurz(const Value: Double);
var
  dlp : Tdodaci_listy_polozky;
begin
  fcm_kurz := Value;
  if fcm_kurz = 0 then
    fcm_kurz := 1;

  // Zmena kurzu na polozkach
  for var i := 0 to dodaci_listy_polozkyList.Count - 1 do
  begin
    dlp := Tdodaci_listy_polozky(dodaci_listy_polozkyList[i]);
    {$IFNDEF ETMSTEST}
    dlp.cm_price_mj := TSQLFunctions.Local2cm(dlp.price_mj, cm_kurz, hlavni_mena.zkratka) ;
    {$ELSE}
    dlp.cm_price_mj := 1;
    {$ENDIF}
  end;
end;

procedure Tdodaci_listy.setvystaveno(const Value: TDateTime);
begin
  Fvystaveno := Value;
  cm_Mena := cm_Mena;
  splatnostDni := splatnostDni;
end;

procedure Tdodaci_listy.setsplatnostDni(const Value: integer);
begin
  FsplatnostDni := value;
  splatnostDatum := Vystaveno + Value;
end;

function Tdodaci_listy.getcm_mena: Tkurz_meny;
begin
  Result := fcm_mena.Value;
end;

procedure Tdodaci_listy.setcm_mena(const Value: Tkurz_meny);
begin
  If not Assigned(Value) Then
    Exit;
  If assigned(fcm_mena.Value) and assigned(value) and assigned(fcm_mena.Value) and assigned(value) and (fcm_mena.Value.id <> Value.id) AND Assigned(dodaci_listy_polozkyList) AND (dodaci_listy_polozkyList.Count > 0) Then
    Begin
    {$IFNDEF ETMSTEST}
      raise ETMSSetError.Create(message1819);
    {$ENDIF}
    End;
  fcm_mena.Value := Value;
  If Value.is_default or not CIZI_MENA Then
    begin
      cm_kurz := 1;
    end else begin
      {$IFNDEF ETMSTEST}
      cm_kurz := TSQLFunctions.getKurzByDate(Value.Zkratka, Vystaveno, False);
      {$ELSE}
      cm_kurz := 1;
      {$ENDIF}
    end;
end;

function Tdodaci_listy.getdoprava_id: Tzpusob_dopravy;
begin
  Result := fdoprava_id.Value;
end;

procedure Tdodaci_listy.setdoprava_id(const Value: Tzpusob_dopravy);
begin
  fdoprava_id.Value := Value;
end;

function Tdodaci_listy.getstavdokladu: Tstavydokladu;
begin
  Result := fstavdokladu.Value;
end;

procedure Tdodaci_listy.setstavdokladu(const Value: Tstavydokladu);
begin
  fstavdokladu.Value := Value;
end;

function Tdodaci_listy.getzpusob_platby: Tzpusob_platby;
begin
  Result := fzpusob_platby.Value;
end;

procedure Tdodaci_listy.setzpusob_platby(const Value: Tzpusob_platby);
begin
  fzpusob_platby.Value := Value;
end;

function Tdodaci_listy.getdodaciadresa: Tcustomer_adresy;
begin
  Result := fdodaciadresa.Value;
end;

procedure Tdodaci_listy.setdodaciadresa(const Value: Tcustomer_adresy);
begin
  fdodaciadresa.Value := Value;
end;

function Tdodaci_listy.getcustomer_id: Tcustomer;
begin
  Result := fcustomer_id.Value;
end;

procedure Tdodaci_listy.setcustomer_id(const Value: Tcustomer);
begin
  If fCustomer_id.Value.GetID0 = Value.getID0 Then
    Exit;
  If ID <> 0 Then
    Begin
      {$IFNDEF ETMSTEST}
      If TSQLFunctions.RererenceIDExistsJoin('dodaci_listy_polozky', 'dodaci_list_id', id.ToString, 'JOIN objednavky_prijate_polozky opp ON dodaci_listy_polozky.polozka_prijate_objednavky_id = opp.id') Then
        raise ETMSSetError.Create(message1835);
      If TSQLFunctions.RererenceIDExistsJoin('dodaci_listy_polozky', 'dodaci_list_id', id.ToString, 'JOIN c_order co ON dodaci_listy_polozky.order_id = co.bar_id') Then
        raise ETMSSetError.Create(message1834);
      {$ENDIF}
    End;
  If Assigned(Value) Then
    begin
      If Assigned(Value.doprava_id) Then
        Doprava_ID := Value.doprava_id;
      If Assigned(Value.Platba_id) Then
        zpusob_platby := Value.Platba_id;
      If Value.Splatnost_Dni > 0 Then
        splatnostdni := Value.splatnost_dni;
      DodaciAdresa := nil;
      If Assigned(Value.cm_mena) Then
        cm_mena := Value.cm_mena;
    end;
  fcustomer_id.Value := Value;
end;

function Tdodaci_listy.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Tdodaci_listy.setciselna_rada_id(const Value: Tciselne_rady);
begin
  If Assigned(Value) AND (fciselna_rada_id.Value <> Value) Then
    {$IFNDEF ETMSTEST}
    Bar_ID := TSQLFunctions.Bar_IDDleRady(Value.ID, 'Dodaci listy', 'dodaci_listy', 'bar_id');
    {$ELSE}
    Bar_ID := 'TST000001';
    {$ENDIF}
  fciselna_rada_id.Value := Value;
end;

constructor Tdodaci_listy.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Fdodaci_listy_polozkyList.SetInitialValue(TList<Tdodaci_listy_polozky>.Create);
  Fdodaci_listy_docList.SetInitialValue(TList<Tdodaci_listy_doc>.Create);
  Fdodaci_listy_zauctovanoList.SetInitialValue(TList<Tdodaci_listy_zauctovano>.Create);
end;

destructor Tdodaci_listy.Destroy;
begin
  Fdodaci_listy_zauctovanoList.DestroyValue;
  Fdodaci_listy_docList.DestroyValue;
  Fdodaci_listy_polozkyList.DestroyValue;
  FDynCon.Free;
  inherited;
end;

function Tdodaci_listy.GetBar_ID: String;
begin
  Result := Bar_ID;
end;

function Tdodaci_listy.Getdodaci_listy_polozkyList: TList<Tdodaci_listy_polozky>;
begin
  result := Fdodaci_listy_polozkyList.Value;
end;

function Tdodaci_listy.Getdodaci_listy_docList: TList<Tdodaci_listy_doc>;
begin
  result := Fdodaci_listy_docList.Value;
end;

function Tdodaci_listy.Getdodaci_listy_zauctovanoList: TList<Tdodaci_listy_zauctovano>;
begin
  result := Fdodaci_listy_zauctovanoList.Value;
end;

function Tdodaci_listy.CheckRequiredFields: boolean;
begin
  Result := (Trim(Bar_ID) <> '') and
            (vystaveno <> 0);
  if USE_STAVY_DOKLADU then
    Result := Result and Assigned(stavdokladu);
end;

procedure Tdodaci_listy.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  Vystaveno :=  date;
  hlavni_mena := GetHlavniMena_Prefill;
  cm_mena := hlavni_mena;
  cm_kurz := 1;
  Ciselna_rada_ID := GetCiselnaRada_Prefill('Dodaci listy', USER_DL_CISELNARADA);
end;

function Tdodaci_listy.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.DuplicationExists('dodaci_listy', 'bar_id', bar_id, id.ToString) Then
    begin
        Result := False;
        aMessage := aMessage + message39+#13#10;
    end;
  {$ENDIF}
end;

class procedure Tdodaci_listy.checkNewRecord;
begin
  inherited;
  {$IFNDEF ETMSTEST}
  TSQLFunctions.CheckRadaDokladu('dodaci listy');
  {$ENDIF}
end;

{ Tdodaci_listy_doc }

function Tdodaci_listy_doc.getdodaci_list_id: Tdodaci_listy;
begin
  Result := fdodaci_list_id.Value;
end;

procedure Tdodaci_listy_doc.setdodaci_list_id(const Value: Tdodaci_listy);
begin
  fdodaci_list_id.Value := Value;
end;

constructor Tdodaci_listy_doc.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdodaci_listy_doc.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tdodaci_listy_doc.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
  Begin
    dodaci_list_id := Tdodaci_listy(aHeader_Object);
   Tdodaci_listy(aHeader_Object).dodaci_listy_docList.Add(Self);
  End;
  if aHeader_ID <> 0 then
    dodaci_list_id := MyarManager.Find<Tdodaci_listy>(aHeader_ID);
  isFile := True;
  DefaultDocument := False;
end;

function Tdodaci_listy_doc.getextensionType : integer;
begin
  Result := _GetExtensionType(path);
end;

function Tdodaci_listy_doc.getdoctype : string;
begin
  Result := _GetDocType(isFile);
end;
{ Tdodaci_listy_polozky }

function Tdodaci_listy_polozky.getmaterial_id: Tsklad_material;
begin
  Result := fmaterial_id.Value;
end;

procedure Tdodaci_listy_polozky.setmaterial_id(const Value: Tsklad_material);
Var
  Customer_ID : Integer;
begin
  fmaterial_id.Value := Value;
  if typ_polozky <> cDLTypPolozkyMaterial then
    exit;
  If Assigned(Value) Then
    Begin
      if kusu_mj < 0.001 then
        kusu_mj := 1;
      unit_ := Value.unit_;
      bar_id := Value.bar_id;
      name := Value.name;
      If Assigned(dodaci_list_ID) AND Assigned(dodaci_list_id.customer_id)
        Then Customer_ID := dodaci_list_id.customer_id.id
        else Customer_ID := 0;
      {$IFNDEF ETMSTEST}
      cm_price_mj := TSQLFunctions.GetSell_price(Value.id, customer_id, dodaci_list_id.cm_mena.zkratka, dodaci_list_id.cm_kurz, date);
      {$ELSE}
      cm_price_mj := 1;
      {$ENDIF}
    End;
  {if adsMain.FieldByName('typ_polozky').AsInteger <> cDLTypPolozkyMaterial then
    Exit;
  if adsMain.FieldByName('kusu_mj').AsFloat < 0.001 Then
    adsMain.FieldByName('kusu_mj').AsFloat := 1;
  adsMain.FieldByName('unit_').AsInteger := Integer(TSklad_material(Sender.AsInteger).unit_);
  adsMain.FieldByName('bar_id').AsString := TSklad_material(Sender.AsInteger).bar_id;
  adsMain.FieldByName('name').AsString := TSklad_material(Sender.AsInteger).name;
  adsMain.FieldByName('cm_price_mj').AsFloat := dmAureliusLookUp.GetSell_price(TSklad_material(Sender.AsInteger).id, adsMain.FieldByName('dodaci_list_id.customer_id.id').AsInteger, adsMain.FieldByName('dodaci_list_id.cm_mena.zkratka').AsString, adsMain.FieldByName('dodaci_list_id.cm_kurz').AsFloat, date);
   }
end;

function Tdodaci_listy_polozky.getpolozka_prijate_objednavky_id: Tobjednavky_prijate_polozky;
begin
  Result := fpolozka_prijate_objednavky_id.Value;
end;

procedure Tdodaci_listy_polozky.setpolozka_prijate_objednavky_id(const Value: Tobjednavky_prijate_polozky);
begin
  fpolozka_prijate_objednavky_id.Value := Value;
  if typ_polozky <> cDLTypPolozkyPolozkaOP then
    exit;
  If Assigned(Value) Then
    Begin
      if kusu_mj < 0.001 then
        kusu_mj := 1;
      material_id := Value.material_id;
      unit_ := Value.unit_;
      bar_id := Value.objednavka_id.bar_id;
      name := Value.objednavka_id.name;
      cm_price_mj := Value.cm_potvrzena_cena_mj;
    End;

end;

function Tdodaci_listy_polozky.getorder_id: Tc_order;
begin
  Result := forder_id; //.Value;
end;

procedure Tdodaci_listy_polozky.setorder_id(const Value: Tc_order);
begin
  forder_id := Value;
  if typ_polozky <> cDLTypPolozkyOrder then
    Exit;
  if Assigned(Value) then
  begin
    // Kontrola zda to neni zakazka z objednavky
    {$IFNDEF ETMSTEST}
    if TSQLFunctions.ZakazkaZObjednavky(Value.bar_id) then
    begin
    {$IFNDEF ETMSTEST}
      raise ETMSSetError.Create(message1698);
    {$ENDIF}

    end;
    {$ENDIF}
    if assigned(Value.created_mat_id) then
      unit_ := Value.created_mat_id.unit_;
    kusu_mj := Value.kusu;
    Material_ID := Value.created_mat_id;
    bar_id := Value.bar_id;
    name := Value.name;
    if Value.kusu = 0 then
      cm_price_mj := 0
    else
      cm_price_mj := Value.user_price / Value.kusu;
  end;
  {
    end;
    qry := dbContext.GetEmptyFDQuery;
    Try
      qry.SQL.Text := 'Select id  from zakazky_objednavky where order_id = :order_id';
      qry.ParamByName('order_id').AsString := Tc_order(Sender.AsInteger).bar_id;
      dbContext.SQLOpen(qry);
      If not qry.IsEmpty Then
        Begin
          dlge(message1698);
          Abort;
        End;
    Finally
      qry.Free;
    End;
    if assigned(Tc_order(Sender.AsInteger).created_mat_id) then
      adsMain.FieldByName('unit_').AsInteger := Integer(Tc_order(Sender.AsInteger).created_mat_id.unit_);
    adsMain.FieldByName('kusu_mj').AsFloat := Tc_order(sender.AsInteger).kusu;
    adsMain.FieldByName('Material_ID').AsInteger := Integer(Tc_order(sender.AsInteger).created_mat_id);
    adsMain.FieldByName('bar_id').AsString := Tc_order(Sender.AsInteger).bar_id;
    adsMain.FieldByName('name').AsString := Tc_order(Sender.AsInteger).name;
    adsMain.FieldByName('cm_price_mj').AsFloat := Tc_order(sender.AsInteger).user_price / Tc_order(sender.AsInteger).kusu;
   }
end;

function Tdodaci_listy_polozky.getunit_: Tjednotky;
begin
  Result := funit_.Value;
end;

procedure Tdodaci_listy_polozky.setunit_(const Value: Tjednotky);
begin
  funit_.Value := Value;
  If not Assigned(Value) or not assigned(Material_ID) Then
    begin
      setcoef_unit(1);
      exit;
    end;
  setcoef_unit(Material_ID.GetCoef_unit(Value));
end;

function Tdodaci_listy_polozky.getdodaci_list_id: Tdodaci_listy;
begin
  Result := fdodaci_list_id.Value;
end;

procedure Tdodaci_listy_polozky.setdodaci_list_id(const Value: Tdodaci_listy);
begin
  fdodaci_list_id.Value := Value;
end;

constructor Tdodaci_listy_polozky.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdodaci_listy_polozky.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tdodaci_listy_polozky.CheckRequiredFields: boolean;
begin
  case typ_polozky of
    cDLTypPolozkyOrder :  begin  // Zakazka
                            Result := Assigned(order_id);
                          end;
    cDLTypPolozkyText :   begin  // Textova
                            Result := True;
                          end;
    cDLTypPolozkyPolozkaOP : begin  // Polozka OP
                              Result := Assigned(polozka_prijate_objednavky_id);
                            end;
    cDLTypPolozkyMaterial : begin  // Material
                              Result := Assigned(Material_id);
                            end;
    else Result := False;
  end;
end;

procedure Tdodaci_listy_polozky.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
    Begin
      Dodaci_list_ID := Tdodaci_listy(aHeader_Object);
      Tdodaci_listy(aHeader_Object).dodaci_listy_polozkyList.Add(self);
    End;
  if aHeader_ID <> 0 then
  begin
    dodaci_list_id := MyarManager.Find<Tdodaci_listy>(aHeader_ID);
  end;
  // Prirazeni Poradi
  Begin
    var i : Integer;
    var MaxPoradi : Integer;
    MaxPoradi := 0;
    For i := 0 To dodaci_list_ID.dodaci_listy_polozkyList.Count-1 Do
      MaxPoradi := Max(MaxPoradi, dodaci_list_ID.dodaci_listy_polozkyList[i].poradi);
    Poradi := MaxPoradi + 1;
  End;

end;

function Tdodaci_listy_polozky.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);

  if Assigned(unit_) then
  begin
      if coef_unit = 0 then
      begin
        Result := False;
        aMessage := message1779;
      end;
  end;

end;

function Tdodaci_listy_polozky.Getsklad_material_readdataList: TList<Tsklad_material_readdata>;
begin
  result := Fsklad_material_readdataList.Value;
end;

procedure Tdodaci_listy_polozky.setkusu_mj(const Value: double);
begin
  fkusu_mj := Value;
  if (kusu_mj <> 0) then
  begin
    setcm_price(kusu_mj * cm_price_mj);
    setkusu(kusu_mj * coef_unit);
    setprice_mj(price / kusu_mj);
  end else begin
    setcm_price(0);
    setkusu(0);
    setprice_mj(0);
  end;
end;

function Tdodaci_listy_polozky.getcoef_unit: Double;
begin
  Result := fCoef_unit;
end;

procedure Tdodaci_listy_polozky.setcoef_unit(const Value: Double);
begin
  If (Value = 0) and (typ_polozky = cDLTypPolozkyText)
    Then   Fcoef_unit := 1
    Else   Fcoef_unit := Value;
  setkusu(kusu_mj * Fcoef_unit);
  cm_price_mj := cm_unit_price * Fcoef_unit;
end;

procedure Tdodaci_listy_polozky.setkusu(const Value: double);
begin
  fkusu := Value;
  If Value = 0 Then
  begin
    setunit_price(0);
    Exit;
  end;
  setunit_price(price / kusu);
end;

procedure Tdodaci_listy_polozky.setcm_price_mj(const Value: double);
begin
  fcm_price_mj := Value;
  if coef_unit <> 0 then
    setcm_unit_price(fcm_price_mj / coef_unit);
  setcm_price(fcm_price_mj * kusu_mj);
end;

procedure Tdodaci_listy_polozky.setcm_price(const Value: double);
begin
  fcm_price := Value;
  {$IFNDEF ETMSTEST}
  setprice(TSQLFunctions.cm2Local(Value, dodaci_list_id.cm_kurz, dodaci_list_id.Hlavni_mena.zkratka));
  {$ENDIF}
end;

procedure Tdodaci_listy_polozky.setprice(const Value: double);
begin
  fprice := Value;
  if (kusu_mj = 0) then
    setprice_mj(0)
  else
    setprice_mj(Value / kusu_mj);
  if (kusu = 0) then
    setunit_price(0)
  else
    setunit_price(Value / kusu);
  dodaci_list_id.ts_lastchange := now; // To proto, ze aby to vynutilo ulozeni hlavicky
end;

procedure Tdodaci_listy_polozky.setcm_unit_price (const Value: Double);
begin
  fcm_unit_price := Value;
end;

procedure Tdodaci_listy_polozky.setunit_price (const Value: Double);
begin
  funit_price := Value;
end;

procedure Tdodaci_listy_polozky.setprice_mj (const Value: Double);
begin
  fprice_mj := Value;
end;

procedure Tdodaci_listy_polozky.settyp_polozky(const Value: Integer);
begin
  Ftyp_polozky := Value;
  case fTyp_polozky of
    cDLTypPolozkyText : setCoef_unit(1);
  end;
end;

function Tdodaci_listy_polozky.getserial_id : Tserial_code;
begin
  Result := FSerial_id.Value;

end;

procedure Tdodaci_listy_polozky.setserial_id (const Value : Tserial_code);
begin
  FSerial_id.Value := Value;
end;

function Tdodaci_listy_polozky.gettyp_polozky_nazev : string;
begin
  case ftyp_polozky of
    cDLTypPolozkyOrder : Result := message179;
    cDLTypPolozkyText : Result := message1638;
    cDLTypPolozkyPolozkaOP : Result := message1556;
    cDLTypPolozkyMaterial : Result := PrijObjEditstringGridClm1Caption;
    else Result := '';
  end;
end;

function Tdodaci_listy_polozky.getdoklad_bar_id: string;
begin
  Result := '';
  case ftyp_polozky of
    cDLTypPolozkyOrder :
    begin
      if Assigned(order_id) then
        Result := order_id.bar_id;
    end;
    cDLTypPolozkyPolozkaOP :
    begin
      if assigned(polozka_prijate_objednavky_id) and assigned(polozka_prijate_objednavky_id.objednavka_id) then
        Result := polozka_prijate_objednavky_id.objednavka_id.bar_id + '-' + polozka_prijate_objednavky_id.poradi.ToString;
    end;
    cDLTypPolozkyMaterial :
    begin
      if assigned(material_id) then
         Result := material_id.bar_id;
    end;
  end;
end;

function Tdodaci_listy_polozky.getdoklad_name: string;
begin
  Result := '';
  case ftyp_polozky of
    cDLTypPolozkyOrder :
    begin
      if Assigned(order_id) then
        Result := order_id.name;
    end;
    cDLTypPolozkyText : Result :=name;
    cDLTypPolozkyPolozkaOP :
    begin
      if assigned(polozka_prijate_objednavky_id) and assigned(polozka_prijate_objednavky_id.objednavka_id) then
        Result := polozka_prijate_objednavky_id.objednavka_id.name;
    end;
    cDLTypPolozkyMaterial :
    begin
      if assigned(material_id) then
         Result := material_id.name;
    end;
  end;
end;


{ Tdodaci_listy_zauctovano }

function Tdodaci_listy_zauctovano.getdodaci_list_id: Tdodaci_listy;
begin
  Result := fdodaci_list_id.Value;
end;

procedure Tdodaci_listy_zauctovano.Prefill(aHeader_ID: integer;
  aHeader_Object: TObject; AgendaName: string);
begin
  inherited;
  if Assigned(aHeader_Object) then
    Begin
      Dodaci_List_ID := TDodaci_Listy(aHeader_Object);
      TDodaci_Listy(aHeader_Object).dodaci_listy_zauctovanoList.Add(self);
    End;
  if aHeader_ID <> 0 then
  begin
    Dodaci_list_id := MyarManager.Find<TDodaci_Listy>(aHeader_ID);
  end;
end;

procedure Tdodaci_listy_zauctovano.setdodaci_list_id(const Value: Tdodaci_listy);
begin
  fdodaci_list_id.Value := Value;
end;

constructor Tdodaci_listy_zauctovano.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdodaci_listy_zauctovano.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tdoklady_status_log }

constructor Tdoklady_status_log.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tdoklady_status_log.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tep_collision }

function Tep_collision.getep_typ_planu_id: Tep_typ_planu;
begin
  Result := fep_typ_planu_id.Value;
end;

procedure Tep_collision.setep_typ_planu_id(const Value: Tep_typ_planu);
begin
  fep_typ_planu_id.Value := Value;
end;

constructor Tep_collision.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_collision.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tep_collision.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty;
end;

{ Tep_config}

constructor Tep_config.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_config.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tep_resource_plan }

constructor Tep_resource_plan.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_resource_plan.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tep_resource_plan_default }

function Tep_resource_plan_default.getResource_id: Tep_schedulerresource;
begin
  Result := fResource_id.Value;
end;

procedure Tep_resource_plan_default.setResource_id(const Value: Tep_schedulerresource);
begin
  fResource_id.Value := Value;
end;

constructor Tep_resource_plan_default.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_resource_plan_default.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tep_resource_plan_typ }

constructor Tep_resource_plan_typ.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;


destructor Tep_resource_plan_typ.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tref_ep_planjednotka_operation }

function Tref_ep_planjednotka_operation.getoperation_id: TOperation;
begin
  Result := foperation_id.Value;
end;

procedure Tref_ep_planjednotka_operation.setoperation_id(const Value: TOperation);
begin
  foperation_id.Value := Value;
end;

function Tref_ep_planjednotka_operation.getplanjednotka_id: Tep_schedulerresource;
begin
  Result := fplanjednotka_id.Value;
end;

procedure Tref_ep_planjednotka_operation.setplanjednotka_id(const Value: Tep_schedulerresource);
begin
  fplanjednotka_id.Value := Value;
end;

constructor Tref_ep_planjednotka_operation.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tref_ep_planjednotka_operation.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tref_ep_planjednotka_operation.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  operation_type := 0;
  if Assigned(aHeader_Object) then
  Begin
    planjednotka_id  := Tep_schedulerresource(aHeader_Object);
    Tep_schedulerresource(aHeader_Object).ref_ep_planjednotka_operationList.Add(Self);
  End;
  if aHeader_ID <> 0 then
  begin
    planjednotka_id := MyarManager.Find<Tep_schedulerresource>(aHeader_ID);
  end;
end;

function Tref_ep_planjednotka_operation.CheckRequiredFields : boolean;
begin
  Result := Assigned(operation_id);
end;

{ Tep_schedulerresource }

function Tep_schedulerresource.getparent_id: Tep_schedulerresource;
begin
  Result := fparent_id.Value;
end;

procedure Tep_schedulerresource.setparent_id(const Value: Tep_schedulerresource);
begin
  fparent_id.Value := Value;
end;

constructor Tep_schedulerresource.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Fep_resource_plan_defaultList.SetInitialValue(TList<Tep_resource_plan_default>.Create);
  Fref_ep_planjednotka_workerList.SetInitialValue(TList<Tref_ep_planjednotka_worker>.Create);
  Fref_ep_planjednotka_operationList.SetInitialValue(TList<Tref_ep_planjednotka_operation>.Create);
  Fref_ep_planjednotka_operation_groupList.SetInitialValue(TList<Tref_ep_planjednotka_operation_group>.Create);
  Fref_ep_planjednotka_CNCList.SetInitialValue(TList<Tref_ep_planjednotka_cnc>.Create);
end;

destructor Tep_schedulerresource.Destroy;
begin
  Fep_resource_plan_defaultList.DestroyValue;
  Fref_ep_planjednotka_workerList.DestroyValue;
  Fref_ep_planjednotka_operationList.DestroyValue;
  Fref_ep_planjednotka_operation_groupList.DestroyValue;
  Fref_ep_planjednotka_CNCList.DestroyValue;
  FDynCon.Free;
  inherited;
end;

function Tep_schedulerresource.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty;
end;

function Tep_schedulerresource.Getep_resource_plan_defaultList: TList<Tep_resource_plan_default>;
begin
  result := Fep_resource_plan_defaultList.Value;
end;

function Tep_schedulerresource.Getref_ep_planjednotka_workerList: Tlist<Tref_ep_planjednotka_worker>;
begin
  result := Fref_ep_planjednotka_workerList.Value;
end;

function Tep_schedulerresource.Getref_ep_planjednotka_CNCList: Tlist<Tref_ep_planjednotka_cnc>;
begin
  result := Fref_ep_planjednotka_CNCList.Value;
end;

function Tep_schedulerresource.Getref_ep_planjednotka_operationList: Tlist<Tref_ep_planjednotka_operation>;
begin
  result := Fref_ep_planjednotka_operationList.Value;
end;

function Tep_schedulerresource.Getref_ep_planjednotka_operation_groupList: Tlist<Tref_ep_planjednotka_operation_group>;
begin
  result := Fref_ep_planjednotka_operation_groupList.Value;
end;

{ Tep_simulace }

function Tep_simulace.getep_typ_planu_id: Tep_typ_planu;
begin
  Result := fep_typ_planu_id.Value;
end;

procedure Tep_simulace.setep_typ_planu_id(const Value: Tep_typ_planu);
begin
  fep_typ_planu_id.Value := Value;
end;

function Tep_simulace.CanEditRecord(var aMessage: String): Boolean;
begin
  Result := True;
  aMessage := '';
  if id = 1 then
    Begin
      Result := False;
      aMessage := 'Nelze editovat hlavn simulaci';
    End;
end;

constructor Tep_simulace.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_simulace.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tep_simulace.CheckRequiredFields : boolean;
begin
  Result := not Trim(nazev).IsEmpty and not Trim(bar_id).IsEmpty and Assigned(ep_typ_planu_id);
end;

{ Tep_simulace_c_order }

constructor Tep_simulace_c_order.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_simulace_c_order.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tep_simulace_order_work }

constructor Tep_simulace_order_work.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_simulace_order_work.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tep_typ_planu }

constructor Tep_typ_planu.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tep_typ_planu.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tfaktury }

constructor Tfaktury.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tfaktury.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tformy_skupina }

constructor Tformy_skupina.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tformy_skupina.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tform_caption_hook }

constructor Tform_caption_hook.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tform_caption_hook.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tgdpr_fields }

constructor Tgdpr_fields.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tgdpr_fields.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tgdpr_logs }

constructor Tgdpr_logs.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tgdpr_logs.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tgdpr_settings }

constructor Tgdpr_settings.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tgdpr_settings.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tglobal_settings }

constructor Tglobal_settings.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tglobal_settings.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tglobal_settings_global_fields }

constructor Tglobal_settings_global_fields.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tglobal_settings_global_fields.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tglobal_settings_user_fields }

constructor Tglobal_settings_user_fields.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tglobal_settings_user_fields.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tglobal_settings_user_fields.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  name := 'EUC_';
  useinaurelius := True;
  field_length := 1;
  field_precission := 0;
  itemorder := 1;
end;

function Tglobal_settings_user_fields.CheckRequiredFields : boolean;
begin
  Result := not Trim(section).IsEmpty and not Trim(name).IsEmpty and  not Trim(type_).IsEmpty and
            not Trim(caption).IsEmpty
end;

{ Tglobal_settings_user_fields_views }

constructor Tglobal_settings_user_fields_views.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tglobal_settings_user_fields_views.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tglobal_settings_user_fields_views.CheckRequiredFields : boolean;
begin
  Result := not Trim(agenda_name).IsEmpty and not Trim(field_name).IsEmpty and
            not Trim(field_name_as).IsEmpty and not Trim(caption).IsEmpty
end;

{ Thnizda }

constructor Thnizda.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Thnizda.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Thnizda_logins }

constructor Thnizda_logins.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Thnizda_logins.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tinet_filters }

constructor Tinet_filters.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tinet_filters.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tjednotky }

constructor Tjednotky.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tjednotky.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function TJednotky.CheckRequiredFields: boolean;
begin
  Result := not nazev.IsNull;
end;

procedure TJednotky.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  visible := true;
  {$IFNDEF ETMSTEST}
  id_correct := TSQLFunctions.GetMaxField('jednotky','id_correct') + 1;
  poradi := TSQLFunctions.GetMaxField('jednotky','poradi') + 1;
  {$ELSE}
  id_correct := 1;
  poradi := 1;
  {$ENDIF}
end;

function TJednotky.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.DuplicationExists('jednotky', 'nazev', nazev, id.ToString) Then
    begin
        Result := False;
        aMessage := aMessage + message1820+#13#10;
    end;
  {$ELSE}
    Result := false;
    aMessage := aMessage + message1820+#13#10;
  {$ENDIF}
end;

Function TJednotky.CanEditRecord (var aMessage : String): Boolean;
begin
  Result := True;
  if Systemovy then
  begin
    Result := False;
    aMessage := message1825;
    exit;
  end;
end;

Function TJednotky.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('sklad_material','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1625+#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('c_order','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +'  '+message1627+' '+message452 +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('order_work','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text+ '  '+message1627+' '+message1629 +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('operation','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text+ '  '+message1627+' '+message1629 +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('subdodavky','jednotka', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+message1771 +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('objednavky_prijate_polozky','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+message1556 +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('objednavky_polozky','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+message920 +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('sklad_material_readdata','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+CaptionNactenaData +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('sklad_material_coef_unit','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+message1822+#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('sklad_material','second_unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+message1625+#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('dodaci_listy_polozky','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+message722 +#13#10;
    Exit;
  end;

  {$ENDIF}

  {if TSQLFunctions.ReferenceIDExists('sklad_inventura_polozky ','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ +#13#10;
    Exit;
  end;
  if TSQLFunctions.ReferenceIDExists('sklad_inventura_soupisy ','unit', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ +#13#10;
    Exit;
  end; To be done TBD}

  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('material_predpokladany','jednotka', id_correct.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1821+#13#10;
    Exit;
  end;
  {$ENDIF}

  if Systemovy then
  begin
    Result := False;
    aMessage := aMessage + message1824;
    Exit;
  end;

end;


{ Tkraticka }

constructor Tkraticka.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tkraticka.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tkurz }

constructor Tkurz.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tkurz.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tkurz.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  start := Date;
end;

function Tkurz.CheckRequiredFields : boolean;
begin
  Result := (kurz > 0) and
            (Assigned(zkratka)) and
            (start <> 0 )
end;

{ Tkurz_meny }

constructor Tkurz_meny.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

function Tkurz.getzkratka: Tkurz_meny;
begin
  Result := fzkratka.Value;
end;

procedure Tkurz.setzkratka(const Value: Tkurz_meny);
begin
  fzkratka.Value := Value;
end;

destructor Tkurz_meny.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tkurz_meny.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  is_Default :=  False;
end;
{ Tlog }

function Tkurz_meny.CheckRequiredFields : boolean;
begin
  Result := not Trim(zkratka).IsEmpty;
end;

constructor Tlog.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tlog.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tmaterial }

constructor Tmaterial.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmaterial.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tmaterialy }

constructor Tmaterialy.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmaterialy.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

Function Tmaterialy.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('sklad_material','material_from_id', Id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+   message1625+#13#10;
    Exit;
  end;
  {$ENDIF}
end;

function Tmaterialy.CheckRequiredFields : boolean;
begin
  Result := not Trim(nazev).IsEmpty;
end;

{ Tmaterial_predpokladany }

constructor Tmaterial_predpokladany.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmaterial_predpokladany.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tmonitoring_readdata }

constructor Tmonitoring_readdata.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmonitoring_readdata.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tmonitoring_readdata.getsenzor_id: Tmonitoring_senzory;
begin
  Result := Fsenzor_id.Value;
end;

procedure Tmonitoring_readdata.setsenzor_id(const Value : Tmonitoring_senzory);
begin
  Fsenzor_id.Value := Value;
end;

{ Tmonitoring_senzory }

constructor Tmonitoring_senzory.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmonitoring_senzory.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tmonitoring_senzory.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
var
  Ref : TMonitoring_stroje;
begin
  inherited;
  TMonitoring_senzory(Self).ref_mon_stroj_id := TMonitoring_stroje.Create;
  Ref := TMonitoring_senzory(Self).ref_mon_stroj_id;
  Ref.ts_created := Now;
  Ref.ts_changed := Now;

end;

Function TMonitoring_senzory.CanDeleteRecord(var aMessage : String) : Boolean;
begin
  Result := True;
  aMessage := '';
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('monitoring_readdata','senzor_id', id.ToString) then
  begin
    Result := False;
    aMessage := message1749;
    Exit;
  end;
  {$ENDIF}
end;

function TMonitoring_senzory.CheckRequiredFields : boolean;
var
  StrojIsOK : boolean;
begin
  StrojIsOK := False;
  if (ref_mon_stroj_id.typ_stroje = 0) then
    StrojIsOK := Assigned(ref_mon_stroj_id.stroj_id);
  if (ref_mon_stroj_id.typ_stroje = 1) then
    StrojIsOK := Assigned(ref_mon_stroj_id.cnc_id);

  Result := (Assigned(typ)) and (Trim(name) <> '') and
            (Assigned(ref_mon_stroj_id)) and  StrojIsOK;
end;


function Tmonitoring_senzory.gettyp: Tmonitoring_senzory_typy;
begin
  Result := FTyp.Value;
end;

procedure Tmonitoring_senzory.settyp (const Value : Tmonitoring_senzory_typy);
begin
  Ftyp.Value := Value;
end;

function Tmonitoring_senzory.getref_mon_stroj_id: Tmonitoring_stroje;
begin
  Result := Fref_mon_stroj_id.Value;
end;

procedure Tmonitoring_senzory.setref_mon_stroj_id (const Value : Tmonitoring_stroje);
begin
  Fref_mon_stroj_id.Value := Value;
end;

{ Tmonitoring_senzory_typy }

constructor Tmonitoring_senzory_typy.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmonitoring_senzory_typy.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tmonitoring_senzory_typy_parametry }

constructor Tmonitoring_senzory_typy_parametry.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmonitoring_senzory_typy_parametry.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tmonitoring_stroje }

constructor Tmonitoring_stroje.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tmonitoring_stroje.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tmonitoring_stroje.getstroj_id: Tstroje;
begin
  Result := fstroj_id.Value;
end;

procedure Tmonitoring_stroje.setstroj_id(const Value : Tstroje);
begin
  fstroj_id.Value := Value;
end;

function Tmonitoring_stroje.getcnc_id: Tcnc_stroje;
begin
  Result := fcnc_id.Value;
end;

procedure Tmonitoring_stroje.setcnc_id(const Value : Tcnc_stroje);
begin
  fcnc_id.Value := Value;
end;



{ Tnabidka_polozky }

constructor Tnabidka_polozky.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tnabidka_polozky.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tnaradi_skupina }

constructor Tnaradi_skupina.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tnaradi_skupina.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tnotifications }

constructor Tnotifications.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tnotifications.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tobjednavky }

constructor Tobjednavky.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Fobjednavky_docList.SetInitialValue(TList<Tobjednavky_doc>.Create);
  Fobjednavky_polozkyList.SetInitialValue(TList<Tobjednavky_polozky>.Create);
end;

destructor Tobjednavky.Destroy;
begin
  Fobjednavky_docList.DestroyValue;
  Fobjednavky_polozkyList.DestroyValue;
  FDynCon.Free;
  inherited;
end;

class procedure Tobjednavky.checkNewRecord;
begin
  inherited;
  {$IFNDEF ETMSTEST}
  TSQLFunctions.CheckRadaDokladu('objednavky');
  {$ENDIF}
end;

function Tobjednavky.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.DuplicationExists('objednavky', 'bar_id', bar_id, id.ToString) Then
    begin
        Result := False;
        aMessage := aMessage + message39+#13#10;
    end;
  {$ENDIF}
end;

function Tobjednavky.CheckRequiredFields: boolean;
begin
  Result := not Trim(Bar_ID).IsEmpty AND
            (vystaveno <> 0) and
            Assigned(Ciselna_rada_ID);
  if USE_STAVY_DOKLADU then
    Result := Result and Assigned(stavdokladu);
end;

procedure Tobjednavky.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  Vystaveno :=  date;
  dodani :=  date;
  hlavni_mena := GetHlavniMena_Prefill;
  cm_mena := hlavni_mena;
  cm_kurz := 1;
  // Ciselnout radu prosim :)
  Ciselna_rada_ID := GetCiselnaRada_Prefill('Objednavky', USER_OV_CISELNARADA);
end;

function Tobjednavky.getcm_kurz: Double;
begin
  Result := Fcm_kurz;
  If Result = 0 Then
    Result := 1;
end;

procedure Tobjednavky.setcm_kurz(const Value: Double);
var
  opp : Tobjednavky_polozky;
begin
  fcm_kurz := Value;
  if fcm_kurz = 0 then
    fcm_kurz := 1;

  // Zmena kurzu na polozkach
  for var i := 0 to objednavky_polozkyList.Count - 1 do
  begin
    opp := Tobjednavky_polozky(objednavky_polozkyList[i]);
    {$IFNDEF ETMSTEST}
    opp.cm_price_mj :=
              TSQLFunctions.local2cm(opp.price_mj,cm_kurz,Hlavni_mena.zkratka);
    {$ELSE}
    opp.cm_price_mj := 1;
    {$ENDIF}
  end;
end;

procedure Tobjednavky.setvystaveno(const Value: TDateTime);
begin
  Fvystaveno := Value;
  cm_Mena := cm_Mena;
end;

function Tobjednavky.getzpusob_platby_id: Tzpusob_platby;
begin
  Result := fzpusob_platby_id.Value;
end;

procedure Tobjednavky.setzpusob_platby_id(const Value: Tzpusob_platby);
begin
  fzpusob_platby_id.Value := Value;
end;

function Tobjednavky.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Tobjednavky.setciselna_rada_id(const Value: Tciselne_rady);
begin
  If Assigned(Value) AND (fciselna_rada_id.Value <> Value) Then
  {$IFNDEF ETMSTEST}
    Bar_ID := TSQLFunctions.Bar_IDDleRady(Value.ID, 'Objednavky', 'objednavky', 'bar_id');
  {$ELSE}
    Bar_ID := 'OBJ000001';
  {$ENDIF}
  fciselna_rada_id.Value := Value;
end;

function Tobjednavky.getStavDokladu: Tstavydokladu;
begin
  Result := fStavDokladu.Value;
end;

procedure Tobjednavky.setStavDokladu(const Value: Tstavydokladu);
begin
  fStavDokladu.Value := Value;
end;

function Tobjednavky.getcm_mena: Tkurz_meny;
begin
  Result := fcm_mena.Value;
end;

procedure Tobjednavky.setcm_mena(const Value: Tkurz_meny);
begin
  If not Assigned(Value) Then
    Exit;
  If assigned(fcm_mena.Value) and assigned(value) and (fcm_mena.Value.id <> Value.id) AND Assigned(objednavky_polozkyList) AND (objednavky_polozkyList.Count > 0) Then
    Begin
      {$IFNDEF ETMSTEST}
      raise ETMSSetError.Create(message1819);
      {$ENDIF}

    End;
  fcm_mena.Value := Value;
  If Value.is_default or not CIZI_MENA Then
    begin
      cm_kurz := 1;
    end else begin
    {$IFNDEF ETMSTEST}
      cm_kurz := TSQLFunctions.getKurzByDate(Value.Zkratka, Vystaveno, False);
    {$ELSE}
      cm_kurz := 1;
    {$ENDIF}
    end;
end;

function Tobjednavky.getcustomer_id: Tcustomer;
begin
  Result := fcustomer_id.Value;
end;

procedure Tobjednavky.setcustomer_id(const Value: Tcustomer);
begin
  If Assigned(Value) Then
    begin
      If Assigned(Value.doprava_id) Then
        Doprava_ID := Value.doprava_id;
      If Assigned(Value.Platba_id) Then
        zpusob_platby_ID := Value.Platba_id;
      If Assigned(Value.cm_mena) Then
        cm_mena := Value.cm_mena;
    end;
  fcustomer_id.Value := Value;
end;


function Tobjednavky.getorder_id: Tc_order;
begin
  Result := forder_id;
end;

procedure Tobjednavky.setorder_id(const Value: Tc_order);
begin
  forder_id := Value;
end;

function Tobjednavky.getdoprava_id: Tzpusob_dopravy;
begin
  Result := fdoprava_id.Value;
end;

procedure Tobjednavky.setdodani(const Value: TDateTime);
var
  i : Integer;
begin
  If Assigned(Objednavky_PolozkyList) Then
    For i := 0 To Objednavky_PolozkyList.Count - 1 Do
      Begin
        If Objednavky_PolozkyList[i].dodat_do = fDodani Then
          Objednavky_PolozkyList[i].Dodat_do := Value;
      End;
  Fdodani := Value;
end;

procedure Tobjednavky.setdoprava_id(const Value: Tzpusob_dopravy);
begin
  fdoprava_id.Value := Value;
end;

function Tobjednavky.gethlavni_mena: Tkurz_meny;
begin
  Result := fhlavni_mena.Value;
end;

procedure Tobjednavky.sethlavni_mena(const Value: Tkurz_meny);
begin
  fhlavni_mena.Value := Value;
end;

function Tobjednavky.Getobjednavky_docList: TList<Tobjednavky_doc>;
begin
  result := Fobjednavky_docList.Value;
end;

function Tobjednavky.Getobjednavky_polozkyList: TList<Tobjednavky_polozky>;
begin
  result := Fobjednavky_polozkyList.Value;
end;


{ Tobjednavky_doc }

function Tobjednavky_doc.getobjednavka_id: Tobjednavky;
begin
  Result := fobjednavka_id.Value;
end;

procedure Tobjednavky_doc.setobjednavka_id(const Value: Tobjednavky);
begin
  fobjednavka_id.Value := Value;
end;

function Tobjednavky_doc.getextensionType : integer;
begin
  Result := _GetExtensionType(path);
end;

function Tobjednavky_doc.getdoctype : string;
begin
  Result := _GetDocType(isFile);
end;

constructor Tobjednavky_doc.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tobjednavky_doc.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tobjednavky_doc.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
  Begin
    objednavka_id := Tobjednavky(aHeader_Object);
    Tobjednavky(aHeader_Object).objednavky_docList.Add(Self);
  End;
  if aHeader_ID <> 0 then
    objednavka_id := MyarManager.Find<Tobjednavky>(aHeader_ID);
  isFile := True;
  DefaultDocument := False;
end;

{ Tobjednavky_polozky }

function Tobjednavky_polozky.getmaterial_id: Tsklad_material;
begin
  Result := fmaterial_id.Value;
end;

procedure Tobjednavky_polozky.setmaterial_id(const Value: Tsklad_material);
Var
  Customer_ID : Integer;
begin
  fmaterial_id.Value := Value;
  If Assigned(Value) Then
    Begin
      name := Value.name;
      if kusu_mj < 0.001 then
        kusu_mj := 1;
      unit_ := Value.unit_;
      {$IFNDEF ETMSTEST}
      cm_price_mj :=  TSQLFunctions.Local2cm(TSQLFunctions.GetMaterialCena(Value.id), objednavka_id.cm_kurz, objednavka_id.Hlavni_mena.zkratka) * coef_unit;
      {$ELSE}
      cm_price_mj := 1;
      {$ENDIF}
    End;
end;

function Tobjednavky_polozky.getnaradi_id: Tsklad_naradi;
begin
  Result := fnaradi_id.Value;
end;

procedure Tobjednavky_polozky.setnaradi_id(const Value: Tsklad_naradi);
begin
  fnaradi_id.Value := Value;
end;

function Tobjednavky_polozky.getsubdodavka_id: Tsubdodavky;
begin
  Result := fsubdodavka_id.Value;
end;

procedure Tobjednavky_polozky.setsubdodavka_id(const Value: Tsubdodavky);
begin
  fsubdodavka_id.Value := Value;
end;

function Tobjednavky_polozky.getobjednavka_id: Tobjednavky;
begin
  Result := fobjednavka_id.Value;
end;

procedure Tobjednavky_polozky.setobjednavka_id(const Value: Tobjednavky);
begin
  fobjednavka_id.Value := Value;
end;

function Tobjednavky_polozky.getorder_id: Tc_order;
begin
  Result := forder_id;
end;

procedure Tobjednavky_polozky.setorder_id(const Value: Tc_order);
begin
  forder_id := Value;
end;

constructor Tobjednavky_polozky.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

function Tobjednavky_polozky.getunit_: Tjednotky;
begin
  Result := funit_.Value;
end;

procedure Tobjednavky_polozky.setunit_(const Value: Tjednotky);
begin
  funit_.Value := Value;
  If not Assigned(Value) or not assigned(Material_ID) Then
    begin
      setcoef_unit(1);
      exit;
    end;
  setcoef_unit(Material_ID.GetCoef_unit(Value));
end;

destructor Tobjednavky_polozky.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

function Tobjednavky_polozky.getcoef_unit: Double;
begin
  Result := fCoef_unit;
end;

procedure Tobjednavky_polozky.setcoef_unit(const Value: Double);
begin
  Fcoef_unit := Value;
  setkusu(kusu_mj * Fcoef_unit);
  cm_price_mj := cm_unitprice * Fcoef_unit;
end;

procedure Tobjednavky_polozky.setkusu(const Value: Double);
begin
  Fkusu := Value;
  If Value = 0 Then
    begin
      setunitprice(0);
      Exit;
    end;
  setunitprice(price / Value);
end;

procedure Tobjednavky_polozky.setkusu_mj(const Value: Double);
begin
  Fkusu_mj := Value;
  if (Fkusu_mj <> 0) then
  begin
    setkusu    (Fkusu_mj * coef_unit);
    setcm_price(Fkusu_mj * cm_price_mj);
    setprice_mj(price / Fkusu_mj);
  end
  else
  begin
    setkusu    (0);
    setcm_price(0);
    setprice_mj(0);
  end;
end;

procedure Tobjednavky_polozky.setprice(const Value: Double);
begin
  Fprice := Value;
  if (kusu <> 0) then
    setunitprice(Value / kusu);
  if (kusu_mj <> 0) then
    setprice_mj(Value / kusu_mj);
  objednavka_id.ts_lastchange := now; // To proto, ze aby to vynutilo ulozeni hlavicky}
end;

procedure Tobjednavky_polozky.setcm_price(const Value: Double);
begin
  Fcm_price := Value;
  {$IFNDEF ETMSTEST}
  setprice(TSQLFunctions.cm2Local(Value, objednavka_id.cm_kurz, objednavka_id.Hlavni_mena.zkratka));
  {$ENDIF}
end;

procedure Tobjednavky_polozky.setcm_price_mj(const Value: Double);
begin
  Fcm_price_mj := Value;
  if Fcm_price_mj <> 0 then
     setcm_unitprice(Fcm_price_mj / coef_unit);
  setcm_price(Fcm_price_mj* kusu_mj);
end;

procedure Tobjednavky_polozky.setunitprice(const Value: Double);
begin
  funitprice := Value;
  setprice_mj(unitprice * coef_unit);
  //cm_price_mj :=  TSQLFunctions.cm2Local(unitprice, objednavka_id.cm_kurz, objednavka_id.Hlavni_mena.zkratka) * coef_unit;
end;

procedure Tobjednavky_polozky.setcm_unitprice(const Value: Double);
begin
  fcm_unitprice := Value;
end;

procedure Tobjednavky_polozky.setprice_mj(const Value: Double);
begin
  fprice_mj := Value;
end;


procedure Tobjednavky_polozky.settyp_polozky(const Value: integer);
begin
  FTyp_polozky := Value;
  case Value of
    cOVTypPolozkyBezVazby :
    begin // Textova
      bez_vazby := 1;
      material_id := nil;
    end;
    cOVTypPolozkyMaterial :
    begin  // Material
      bez_vazby := 0;
      name := '';
    end;
  end;
end;

procedure Tobjednavky_polozky.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
var
  DodatDatum : TDateTime;
begin
  inherited;
  if Assigned(aHeader_Object) then
    Begin
      Objednavka_ID := Tobjednavky(aHeader_Object);
      Tobjednavky(aHeader_Object).objednavky_polozkyList.Add(self);
    End;
  DodatDatum := 0;
  if aHeader_ID <> 0 then
  begin
    objednavka_id := MyarManager.Find<Tobjednavky>(aHeader_ID);
    DodatDatum := MyarManager.Find<Tobjednavky>(aHeader_ID).dodani;
  end;
  if DodatDatum = 0 then DodatDatum := date;
  dodat_do := DodatDatum;
  // Prirazeni Poradi
  Begin
    var i : Integer;
    var MaxPoradi : Integer;
    MaxPoradi := 0;
    For i := 0 To Objednavka_ID.objednavky_polozkyList.Count-1 Do
      MaxPoradi := Max(MaxPoradi, Objednavka_ID.objednavky_polozkyList[i].poradi);
    Poradi := MaxPoradi + 1;
  End;
end;

function Tobjednavky_polozky.CheckRequiredFields: boolean;
begin
  Result := (dodat_do <> 0);
  case typ_polozky of
    cOVTypPolozkyMaterial : Result := Result and Assigned(Material_ID);
    cOVTypPolozkyBezVazby : Result := Result and not Trim(name).IsEmpty;
  end;
end;

function Tobjednavky_polozky.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);

  if Assigned(unit_) and Assigned(material_id) then
  begin
      if coef_unit = 0 then
      begin
        Result := False;
        aMessage := message1779;
      end;
  end;
end;


{ Tobjednavky_prijate }

function Tobjednavky_prijate.gethlavni_mena: Tkurz_meny;
begin
  Result := fhlavni_mena.Value;
end;

procedure Tobjednavky_prijate.sethlavni_mena(const Value: Tkurz_meny);
begin
  fhlavni_mena.Value := Value;
end;

function Tobjednavky_prijate.getcm_kurz: Double;
begin
  Result := Fcm_kurz;
  If Result = 0 Then
    Result := 1;
end;

function Tobjednavky_prijate.getcm_mena: Tkurz_meny;
begin
  Result := fcm_mena.Value;
end;

procedure Tobjednavky_prijate.setcm_kurz(const Value: Double);
var
  opp : Tobjednavky_prijate_polozky;
  custId : integer;
  matId : integer;
begin
  fcm_kurz := Value;
  if fcm_kurz = 0 then
    fcm_kurz := 1;

  // Zmena kurzu na polozkach
  for var i := 0 to objednavky_prijate_polozkyList.Count - 1 do
  begin
    opp := Tobjednavky_prijate_polozky(objednavky_prijate_polozkyList[i]);
    if assigned(opp.material_id) then
      matId := opp.material_id.id
    else matId := 0;
    if assigned(customer_id) then
      custId := customer_id.id
    else custId := 0;
    var opcp := OBJPRIJATE_PREDVYPLNIT_CENU_POTVRZENOU;
    OBJPRIJATE_PREDVYPLNIT_CENU_POTVRZENOU := False;
    {$IFNDEF ETMSTEST}
    try
      opp.setsell_price_unit(TSQLFunctions.GetSell_price(matId, custId, cm_mena.zkratka, cm_kurz, date));
      opp.setcm_potvrzena_cena_mj(TSQLFunctions.Local2cm(opp.potvrzena_cena_mj, cm_kurz, hlavni_mena.zkratka));
    finally
      OBJPRIJATE_PREDVYPLNIT_CENU_POTVRZENOU := opcp;
    end;
    {$ENDIF}
  end;
end;

procedure Tobjednavky_prijate.setcm_mena(const Value: Tkurz_meny);
begin
  If not Assigned(Value) Then
    Exit;
  If assigned(fcm_mena.Value) and assigned(value) and (fcm_mena.Value.id <> Value.id) AND Assigned(objednavky_prijate_polozkyList) AND (objednavky_prijate_polozkyList.Count > 0) Then
    Begin
    {$IFNDEF ETMSTEST}
      raise ETMSSetError.Create(message1819);
      {$ENDIF}
    End;
  fcm_mena.Value := Value;
  If Value.is_default or not CIZI_MENA Then
    begin
      cm_kurz := 1;
    end else begin
      {$IFNDEF ETMSTEST}
      cm_kurz := TSQLFunctions.getKurzByDate(Value.Zkratka, Vystaveno, False);
      {$ELSE}
      cm_kurz := 1;
      {$ENDIF}
    end;
end;

function Tobjednavky_prijate.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Tobjednavky_prijate.setciselna_rada_id(const Value: Tciselne_rady);
begin

  If Assigned(Value) AND (fciselna_rada_id.Value <> Value) Then
  {$IFNDEF ETMSTEST}
    Bar_ID := TSQLFunctions.Bar_IDDleRady(Value.ID, 'Objednavky prijate', 'objednavky_prijate', 'bar_id');
  {$ELSE}
    Bar_ID := 'OBP0000001';
  {$ENDIF}
  fciselna_rada_id.Value := Value;
end;

function Tobjednavky_prijate.getdodaciadresa: Tcustomer_adresy;
begin
  Result := fdodaciadresa.Value;
end;

procedure Tobjednavky_prijate.setdodaciadresa(const Value: Tcustomer_adresy);
begin
  fdodaciadresa.Value := Value;
end;

procedure Tobjednavky_prijate.setdodat(const Value: TDateTime);
var
  i : Integer;
begin
  If Assigned(Objednavky_Prijate_PolozkyList) Then
    For i := 0 To Objednavky_Prijate_PolozkyList.Count - 1 Do
      Begin
        If Objednavky_Prijate_PolozkyList[i].pozadovene_datum = fDodat Then
          Objednavky_Prijate_PolozkyList[i].pozadovene_datum := Value;
      End;
  Fdodat := Value;
end;

function Tobjednavky_prijate.getStavDokladu: Tstavydokladu;
begin
  Result := fStavDokladu.Value;
end;

procedure Tobjednavky_prijate.setStavDokladu(const Value: Tstavydokladu);
begin
  fStavDokladu.Value := Value;
end;

procedure Tobjednavky_prijate.setvystaveno(const Value: TDateTime);
begin
  Fvystaveno := Value;
  cm_Mena := cm_Mena;
end;

function Tobjednavky_prijate.getcustomer_id: Tcustomer;
begin
  Result := fcustomer_id.Value;
end;

procedure Tobjednavky_prijate.setcustomer_id(const Value: Tcustomer);
begin
  If fCustomer_id.Value.GetID0 = Value.getID0 Then
    Exit;
  If ID <> 0 Then
    Begin
      {$IFNDEF ETMSTEST}
      If TSQLFunctions.RererenceIDExistsJoin('objednavky_prijate_polozky', 'objednavka_id', id.ToString, 'JOIN dodaci_listy_polozky dlp ON dlp.polozka_prijate_objednavky_id = objednavky_prijate_polozky.id') Then
        raise ETMSSetError.Create(message1833);
      If TSQLFunctions.RererenceIDExistsJoin('objednavky_prijate_polozky', 'objednavka_id', id.ToString, 'JOIN zakazky_objednavky zo ON zo.polozka_prijate_objednavky_id = objednavky_prijate_polozky.id') Then
        raise ETMSSetError.Create(message1834);
      {$ENDIF}
    End;

  If Assigned(Value) Then
    begin
      If Assigned(Value.cm_mena) Then
        cm_mena := Value.cm_mena;
      If Assigned(Value.doprava_id) Then
        Doprava_ID := Value.doprava_id;
      If Assigned(Value.Platba_id) Then
        zpusob_platby_ID := Value.Platba_id;
      DodaciAdresa := nil;
    end;
  fcustomer_id.Value := Value;
end;

function Tobjednavky_prijate.getdoprava_id: Tzpusob_dopravy;
begin
  Result := fdoprava_id.Value;
end;

procedure Tobjednavky_prijate.setdoprava_id(const Value: Tzpusob_dopravy);
begin
  fdoprava_id.Value := Value;
end;

class procedure Tobjednavky_prijate.checkNewRecord;
begin
  inherited;
  {$IFNDEF ETMSTEST}
  TSQLFunctions.CheckRadaDokladu('objednavky prijate');
  {$ENDIF}
end;

function Tobjednavky_prijate.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.DuplicationExists('objednavky_prijate', 'bar_id', bar_id, id.ToString) Then
    begin
        Result := False;
        aMessage := aMessage + message39+#13#10;
    end;
  {$ENDIF}
end;

function Tobjednavky_prijate.CheckRequiredFields: boolean;
begin
  Result := not Trim(Bar_ID).IsEmpty AND
            (vystaveno <> 0) and
            Assigned(Ciselna_rada_ID);
  if USE_STAVY_DOKLADU then
    Result := Result and Assigned(stavdokladu);
end;

constructor Tobjednavky_prijate.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Fobjednavky_prijate_polozkyList.SetInitialValue(TList<Tobjednavky_prijate_polozky>.Create);
  Fobjednavky_prijate_docList.SetInitialValue(TList<Tobjednavky_prijate_doc>.Create);
end;

destructor Tobjednavky_prijate.Destroy;
begin
  Fobjednavky_prijate_docList.DestroyValue;
  Fobjednavky_prijate_polozkyList.DestroyValue;
  FDynCon.Free;
  inherited;
end;

function Tobjednavky_prijate.GetBar_ID: String;
begin
  Result := Bar_ID;
end;

function Tobjednavky_prijate.Getobjednavky_prijate_polozkyList: TList<Tobjednavky_prijate_polozky>;
begin
  result := Fobjednavky_prijate_polozkyList.Value;
end;

function Tobjednavky_prijate.Getobjednavky_prijate_docList: TList<Tobjednavky_prijate_doc>;
begin
  result := Fobjednavky_prijate_docList.Value;
end;

function Tobjednavky_prijate.getzpusob_platby_id: Tzpusob_platby;
begin
  Result := fzpusob_platby_id.Value;
end;

procedure Tobjednavky_prijate.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  Vystaveno :=  date;
  Dodat :=  date;
  hlavni_mena := GetHlavniMena_Prefill;
  cm_mena := hlavni_mena;
  cena_celkem := 0;
  cm_cena_celkem := 0;
  // Ciselnout radu prosim :)
  Ciselna_rada_ID := GetCiselnaRada_Prefill('Objednavky prijate', USER_OP_CISELNARADA);
end;

procedure Tobjednavky_prijate.setzpusob_platby_id(const Value: Tzpusob_platby);
begin
  fzpusob_platby_id.Value := Value;
end;


{ Tobjednavky_prijate_doc }

function Tobjednavky_prijate_doc.getobjednavka_prijata_id: Tobjednavky_prijate;
begin
  Result := fobjednavka_prijata_id.Value;
end;

procedure Tobjednavky_prijate_doc.setobjednavka_prijata_id(const Value: Tobjednavky_prijate);
begin
  fobjednavka_prijata_id.Value := Value;
end;

constructor Tobjednavky_prijate_doc.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tobjednavky_prijate_doc.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tobjednavky_prijate_doc.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
  Begin
     objednavka_prijata_id := Tobjednavky_prijate(aHeader_Object);
     Tobjednavky_prijate(aHeader_Object).objednavky_prijate_docList.Add(Self);
  End;
  if aHeader_ID <> 0 then
    objednavka_prijata_id := MyarManager.Find<Tobjednavky_prijate>(aHeader_ID);
  isFile := True;
  DefaultDocument := False;
end;

function Tobjednavky_prijate_doc.GetBar_ID: String;
begin
  Result := Objednavka_Prijata_ID.Bar_ID;
end;

function Tobjednavky_prijate_doc.getextensionType : integer;
begin
  Result := _GetExtensionType(path);
end;

function Tobjednavky_prijate_doc.getdoctype : string;
begin
  Result := _GetDocType(isFile);
end;

{ Tobjednavky_prijate_polozky }

function Tobjednavky_prijate_polozky.getunit_: Tjednotky;
begin
  Result := funit_.Value;
end;

procedure Tobjednavky_prijate_polozky.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  if Assigned(aHeader_Object) then
    Begin
      Objednavka_ID := Tobjednavky_prijate(aHeader_Object);
      Tobjednavky_prijate(aHeader_Object).objednavky_prijate_polozkyList.Add(self);
    End;
  if aHeader_ID <> 0 then
  begin
    objednavka_id := MyarManager.Find<Tobjednavky_prijate>(aHeader_ID);
  end;
  pozadovene_datum := Objednavka_ID.dodat;
  If pozadovene_datum = 0 Then
    pozadovene_datum := date;

  potvrzene_datum := pozadovene_datum;
  // Prirazeni Poradi
  Begin
    var i : Integer;
    var MaxPoradi : Integer;
    MaxPoradi := 0;
    For i := 0 To Objednavka_ID.objednavky_prijate_polozkyList.Count-1 Do
      MaxPoradi := Max(MaxPoradi, Objednavka_ID.objednavky_prijate_polozkyList[i].poradi);
    Poradi := MaxPoradi + 1;
  End;
end;

procedure Tobjednavky_prijate_polozky.setunit_(const Value: Tjednotky);
begin
  funit_.Value := Value;
  If not Assigned(Value) or not assigned(Material_ID) Then
    begin
      setcoef_unit(1);
      exit;
    end;
  setcoef_unit(Material_ID.GetCoef_unit(Value));
end;

function Tobjednavky_prijate_polozky.getcoef_unit: Double;
begin
  Result := fCoef_unit;
end;

function Tobjednavky_prijate_polozky.getmaterial_id: Tsklad_material;
begin
  Result := fmaterial_id.Value;
end;

procedure Tobjednavky_prijate_polozky.setcm_potvrzena_cena(const Value: Double);
begin
  Fcm_potvrzena_cena := Value;
  {$IFNDEF ETMSTEST}
  setpotvrzena_cena(TSQLFunctions.cm2Local(Value, objednavka_id.cm_kurz, objednavka_id.Hlavni_mena.zkratka));
  {$ENDIF}
end;

procedure Tobjednavky_prijate_polozky.setcm_potvrzena_cena_mj(
  const Value: Double);
begin
  Fcm_potvrzena_cena_mj := Value;
  if Fcoef_unit <> 0 then
     setcm_potvrzena_cena_jednotka(Fcm_potvrzena_cena_mj / coef_unit);
  setcm_potvrzena_cena         (Fcm_potvrzena_cena_mj * kusu_mj);
end;

procedure Tobjednavky_prijate_polozky.setcoef_unit(const Value: Double);
begin
  Fcoef_unit := Value;
  SetKusu(kusu_mj * Fcoef_unit);
  setsell_price_mj(sell_price_unit * Fcoef_unit);
  cm_potvrzena_cena_mj := cm_potvrzena_cena_jednotka * Fcoef_unit;
end;

procedure Tobjednavky_prijate_polozky.setkusu(const Value: Double);
begin
  Fkusu := Value;
  If Value = 0 Then
    begin
      setsell_price(0);
      setpotvrzena_cena_jednotka(0);
      Exit;
    end;
  setsell_price(sell_price_unit * Value);
  setpotvrzena_cena_jednotka(potvrzena_cena / Value);
end;

procedure Tobjednavky_prijate_polozky.setkusu_mj(const Value: Double);
begin
  Fkusu_mj := Value;
  if (value <> 0) then
  begin
    setKusu(Fkusu_mj * coef_unit);
    setcm_potvrzena_cena(Fkusu_mj * cm_potvrzena_cena_mj);
    setpotvrzena_cena_mj(potvrzena_cena / Fkusu_mj);
  end
  else
  begin
//    kusu              := 0;
    SetKusu(0);
    setcm_potvrzena_cena(0);
    setpotvrzena_cena_mj(0);
  end;
end;

procedure Tobjednavky_prijate_polozky.setmaterial_id(const Value: Tsklad_material);
Var
  Customer_ID : Integer;
begin
  fmaterial_id.Value := Value;
  If Assigned(Value) Then
    Begin
      if kusu_mj < 0.001 then
        kusu_mj := 1;
      name := Value.name;
      unit_ := Value.unit_;
      If Assigned(Objednavka_ID) AND Assigned(objednavka_id.customer_id)
        Then Customer_ID := objednavka_id.customer_id.id
        else Customer_ID := 0;
      {$IFNDEF ETMSTEST}
      setsell_price_unit(TSQLFunctions.GetSell_price(Value.id, customer_id, objednavka_id.cm_mena.zkratka, objednavka_id.cm_kurz, date));
      {$ENDIF}
    End;
end;

function Tobjednavky_prijate_polozky.getobjednavka_id: Tobjednavky_prijate;
begin
  Result := fobjednavka_id.Value;
end;

procedure Tobjednavky_prijate_polozky.setobjednavka_id(const Value: Tobjednavky_prijate);
begin
  fobjednavka_id.Value := Value;
end;

procedure Tobjednavky_prijate_polozky.setpotvrzena_cena(const Value: Double);
begin
  Fpotvrzena_cena := Value;
  if (kusu_mj = 0) or (kusu = 0) then
  begin
    setpotvrzena_cena_mj      (0);
    setpotvrzena_cena_jednotka(0);
  end
  else
  begin
    setpotvrzena_cena_mj      (Value / kusu_mj);
    setpotvrzena_cena_jednotka(Value / Kusu);
  end;
  objednavka_id.ts_lastchange := now; // To proto, ze aby to vynutilo ulozeni hlavicky
end;

procedure Tobjednavky_prijate_polozky.setsell_price_unit(const Value: Double);
var
  cu : Double;
begin
  Fsell_price_unit := Value;
  cu := coef_unit;
  If cu = 0 Then
    cu := 1;
  setsell_price(kusu * Fsell_price_unit);
  setsell_price_mj(Fsell_price_unit * cu);
  if OBJPRIJATE_PREDVYPLNIT_CENU_POTVRZENOU then
    cm_potvrzena_cena_mj := Fsell_price_unit * cu;
end;

procedure Tobjednavky_prijate_polozky.setpotvrzena_cena_jednotka(const Value: Double);
begin
  fpotvrzena_cena_jednotka := Value;
end;

procedure Tobjednavky_prijate_polozky.setpotvrzena_cena_mj(const Value: Double);
begin
  fpotvrzena_cena_mj := Value;
end;

procedure Tobjednavky_prijate_polozky.setsell_price_mj(const Value: Double);
begin
 fsell_price_mj := Value;
end;

procedure Tobjednavky_prijate_polozky.setsell_price(const Value: Double);
begin
  fsell_price := Value;
end;

procedure Tobjednavky_prijate_polozky.setcm_potvrzena_cena_jednotka(const Value: Double);
begin
  fcm_potvrzena_cena_jednotka := Value;
end;

function Tobjednavky_prijate_polozky.CheckRecord(var aMessage: String): Boolean;
begin
  Result := inherited CheckRecord(aMessage);

  if Assigned(unit_) then
  begin
      if coef_unit = 0 then
      begin
        Result := False;
        aMessage := message1779;
      end;
  end;
end;

function Tobjednavky_prijate_polozky.CheckRequiredFields: boolean;
begin
  Result := (potvrzena_cena_mj > 0) and (potvrzene_datum <> 0);
  case typ_polozky of
    cOVTypPolozkyMaterial : Result := Result and Assigned(Material_ID);
    cOVTypPolozkyBezVazby : Result := Result and not Trim(name).IsEmpty;
  end;
end;

constructor Tobjednavky_prijate_polozky.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tobjednavky_prijate_polozky.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Tobjednavky_prijate_polozky.settyp_polozky(const Value: integer);
begin
  FTyp_polozky := Value;
  case Value of
    cOVTypPolozkyBezVazby :
    begin // Textova
      material_id := nil;
    end;
    cOVTypPolozkyMaterial :
    begin  // Material
      name := '';
    end;
  end;
end;

function Tobjednavky_prijate_polozky.GetBar_ID: String;
begin
  Result := Objednavka_ID.bar_id+' - '+Poradi.ToString;
end;

{ Toperation }

function Toperation.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Toperation.setciselna_rada_id(const Value: Tciselne_rady);
begin
  fciselna_rada_id.Value := Value;
end;

function Toperation.gettyp_vypoctu: Tukolmzda_typ;
begin
  Result := ftyp_vypoctu.Value;
end;

procedure Toperation.settyp_vypoctu(const Value: Tukolmzda_typ);
begin
  ftyp_vypoctu.Value := Value;
end;

function Toperation.getcnc_id: Tcnc_stroje;
begin
  Result := fcnc_id.Value;
end;

procedure Toperation.setcnc_id(const Value: Tcnc_stroje);
begin
  fcnc_id.Value := Value;
end;

function Toperation.getorderstav_id: Torder_stav;
begin
  Result := forderstav_id.Value;
end;

procedure Toperation.setorderstav_id(const Value: Torder_stav);
begin
  forderstav_id.Value := Value;
end;

function Toperation.getunit_: TJednotky;
begin
  Result := funit_.Value;
end;

procedure Toperation.setunit_(const Value: TJednotky);
begin
  funit_.Value := Value;
end;

function Toperation.getid_employee: Tworker;
begin
  Result := fid_employee.Value;
end;

procedure Toperation.setid_employee(const Value: Tworker);
begin
  fid_employee.Value := Value;
end;

function Toperation.getgroup_id: Toperation_group;
begin
  Result := fgroup_id.Value;
end;

procedure Toperation.setgroup_id(const Value: Toperation_group);
begin
  fgroup_id.Value := Value;
end;

constructor Toperation.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Fref_operation_workerList.SetInitialValue(TList<Tref_operation_worker>.Create);
  Foperation_strojeList.SetInitialValue(TList<Tref_operation_stroj>.Create);
  Foperation_cncList.SetInitialValue(TList<Tref_operation_cnc>.Create);
end;

destructor Toperation.Destroy;
begin
  FDynCon.Free;
  Fref_operation_workerList.DestroyValue;
  Foperation_strojeList.DestroyValue;
  Foperation_cncList.DestroyValue;
  inherited;
end;

class procedure TOperation.checkNewRecord;
begin
  inherited;
  {$IFNDEF ETMSTEST}
  TSQLFunctions.CheckRadaDokladu('Operace');
  {$ENDIF}
end;

Function TOperation.CanDeleteRecord(var aMessage : String) : Boolean;
begin
  Result := True;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('aktualni_stav','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('cnc_import_casu','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ep_schedulertable','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('operation_default','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('order_work','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('order_work_plan','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('pausal','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('plan_na_den','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('pruv_list','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('readdata','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('readdata_ceny','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('readdata_item_action','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('readdata_stroj','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ref_ep_planjednotka_operation','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ref_operation_cnc','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ref_operation_stroj','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ref_operation_worker','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ref_planjednotka_operation','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('schedulertable','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('servis_typ_ref_stroje','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('swterm_rozdel','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('tech_postup_polozky','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('terminal','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('ukoly_druhy','operation_id', ID.ToString) then Result := False;
  if Result and TSQLFunctions.ReferenceIDExists('uzavreni_zakazek','operation_id', ID.ToString) then Result := False;
  {$ENDIF}

  if not Result then
  begin
    if aMessage = ''
      then aMessage := message1749 + #13#10 + Bar_id.QuotedString
      else aMessage := Bar_id;
  end;

end;

function TOperation.CheckRequiredFields : boolean;
begin
  Result := True;
  if (Trim(bar_id) = '') or (Trim(name) = '') or  (not Assigned(group_id)) then
     Result := False;

  if not Is_dochazka  and (not(Assigned(unit_))) then
    Result := False;

end;


function TOperation.Getref_operation_workerList: TList<Tref_operation_worker>;
begin
  result := Fref_operation_workerList.value;
end;

function Toperation.Getoperation_strojeList: TList<Tref_operation_stroj>;
begin
  result := Foperation_strojeList.Value;
end;

function Toperation.Getoperation_cncList: TList<Tref_operation_cnc>;
begin
  result := Foperation_cncList.Value;
end;


{ Toperation_default }

constructor Toperation_default.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Toperation_default.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Toperation_group }

constructor Toperation_group.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
  Foperation_group_strojeList.SetInitialValue(TList<Tref_operation_group_stroj>.Create);
  Foperation_group_cncList.SetInitialValue(TList<Tref_operation_group_cnc>.Create);
end;

destructor Toperation_group.Destroy;
begin
  FDynCon.Free;
  Foperation_group_strojeList.DestroyValue;
  Foperation_group_cncList.DestroyValue;
  inherited;
end;

Function Toperation_group.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('operation','group_id', Id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+ message1627+' '+message1629+#13#10;
    Exit;
  end;
  {$ENDIF}
end;

function Toperation_group.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty;
end;

function Toperation_group.Getoperation_group_strojeList: TList<Tref_operation_group_stroj>;
begin
  result := Foperation_group_strojeList.Value;
end;

function Toperation_group.Getoperation_group_CNCList: TList<Tref_operation_group_cnc>;
begin
  result := Foperation_group_cncList.Value;
end;

function Toperation_group.getciselna_rada_id: Tciselne_rady;
begin
  Result := fciselna_rada_id.Value;
end;

procedure Toperation_group.setciselna_rada_id(const Value: Tciselne_rady);
begin
  fciselna_rada_id.Value := Value;
end;
{ Torder_calc_list }

constructor Torder_calc_list.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_calc_list.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Torder_filter }

constructor Torder_filter.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_filter.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Torder_priority_font }

constructor Torder_priority_font.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_priority_font.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Torder_stav }

constructor Torder_stav.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_stav.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

procedure Torder_stav.Prefill(aHeader_ID : integer = 0; aHeader_Object : TObject = nil; AgendaName : string = '');
begin
  inherited;
  {$IFNDEF ETMSTEST}
  cislo := TSQLFunctions.GetOrderStavyRadaCislo.ToString;
  {$ELSE}
  cislo := '1';
  {$ENDIF}
end;

Function Torder_stav.CanDeleteRecord(var aMessage : String) : Boolean;
var
  Text: string;
begin
  Result := True;
  aMessage := '';
  Text := message673+' '+message1620;
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.ReferenceIDExists('c_order','active', Id.ToString) then
  begin
    Result := False;
    aMessage := aMessage + Text +' '+   message1633+#13#10;
    Exit;
  end;
  {$ENDIF}
end;

function Torder_stav.CheckRequiredFields : boolean;
begin
  Result := not Trim(name).IsEmpty and not Trim(cislo).IsEmpty;
end;

{ Torder_urovne }

constructor Torder_urovne.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_urovne.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Torder_work }

function Torder_work.getorder_id: Tc_order;
begin
  Result := forder_id.Value;
end;

procedure Torder_work.setorder_id(const Value: Tc_order);
begin
  forder_id.Value := Value;
end;

constructor Torder_work.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_work.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Torder_work_plan }

constructor Torder_work_plan.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Torder_work_plan.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tpackages }

constructor Tpackages.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tpackages.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tpausal }

function Tpausal.getoperation_id: Toperation;
begin
  Result := foperation_id.Value;
end;

procedure Tpausal.setoperation_id(const Value: Toperation);
begin
  foperation_id.Value := Value;
end;

constructor Tpausal.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tpausal.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

Function TPausal.CanDeleteRecord(var aMessage : String) : Boolean;
begin
  Result := True;
  aMessage := '';
  {$IFNDEF ETMSTEST}
  if TSQLFunctions.TerminalOperace(ID,Bar_Id) then
  begin
    Result := False;
    aMessage := aMessage + message851+ Bar_id+message852 + message1247;
  end;
  {$ENDIF}
end;

function TPausal.CheckRequiredFields : boolean;
begin
   Result := (name <> '') and (bar_id <> '') and
         (Assigned(operation_id)) and
         (FormatDateTime('hh:mm:ss',time) <>'00:00:00')
end;

{ Tplan_group_smeny }

constructor Tplan_group_smeny.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tplan_group_smeny.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tplan_misto_prace }

constructor Tplan_misto_prace.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tplan_misto_prace.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tplan_na_den }

constructor Tplan_na_den.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tplan_na_den.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tplan_smena }

constructor Tplan_smena.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tplan_smena.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tplan_smena_na_den }

constructor Tplan_smena_na_den.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tplan_smena_na_den.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tplan_smena_skupina }

constructor Tplan_smena_skupina.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

destructor Tplan_smena_skupina.Destroy;
begin
  FDynCon.Free;
  inherited;
end;

{ Tplan_standardni_smena }

constructor Tplan_standardni_smena.Create;
begin
  inherited;
  FDynCon := TDynamicProperties.Create;
end;

d