unit Model2Service;

interface

uses
  Aurelius.Mapping.Attributes,
  XData.Server.Module,
  XData.Service.Common,
  eMISTRDataModel,
  System.Generics.Collections;

type
  [ServiceContract]
  [Model('Model2')]
  IModel2Service = interface(IInvokable)
    ['{1118D7AB-B451-4C6B-87EF-7C5FA649FDCC}']
    [HttpGet] function Value: TList<Tc_order>;
  end;

  [ServiceImplementation]
  TModel2Service = class(TInterfacedObject, IModel2Service)
    function Value: TList<Tc_order>;
  end;

implementation


{ TModel2Service }

function TModel2Service.Value: TList<Tc_order>;
begin
  var fOrderList := Tlist<tc_order>.create;
  var fOrder := Tc_order.Create;

  fOrder.bar_id := '0000001';
  fOrderList.Add(fOrder);

  Result := fOrderList;
end;

initialization
  RegisterServiceType(TypeInfo(IModel2Service));
  RegisterServiceType(TModel2Service);

end.
