unit ApiFunctionsService;

interface

uses
  System.Classes, Generics.Collections,
  XData.Service.Common,
  Aurelius.Mapping.Attributes,
  XData.Server.Module;

type
  [ServiceContract]
  [Model('functions')]
  //[Model('MyFunctions')]
  //[Route('/Functions')]
  IMyService = interface(IInvokable)
  ['{BAD477A2-86EC-45B9-A1B1-C896C58DD5E0}']
    [HttpGet]
    function Sum(A, B: double): double;
    [HttpGet]
    function HelloWorld: string;
  end;

    [ServiceImplementation]
  TMyService = class(TInterfacedObject, IMyService)
  public
    function Sum(A, B: Double): Double;
    function HelloWorld:String;

  end;

implementation

function TMyService.HelloWorld: String;
begin
  result := 'aaaaa';
end;

function TMyService.Sum(A, B: Double): Double;
begin
  result := a+b;
end;

initialization
  RegisterServiceType(TypeInfo(IMyService));
  RegisterServiceType(TMyService);
end.
