unit UMultiSelectCheckBox;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  FMX.TMSFNCTypes, FMX.TMSFNCUtils, FMX.TMSFNCGraphics, FMX.TMSFNCGraphicsTypes,
  System.Rtti, FMX.TMSFNCDataGridCell, FMX.TMSFNCDataGridData,
  FMX.TMSFNCDataGridBase, FMX.TMSFNCDataGridCore, FMX.TMSFNCDataGridRenderer,
  FMX.TMSFNCCustomControl, FMX.TMSFNCDataGrid;

type
  TForm92 = class(TForm)
    TMSFNCDataGrid1: TTMSFNCDataGrid;
    procedure FormCreate(Sender: TObject);
    procedure TMSFNCDataGrid1CellCheckBoxChange(Sender: TObject; AColumn,
      ARow: Integer);
    procedure TMSFNCDataGrid1GetCellDataProperties(Sender: TObject;
      ACell: TTMSFNCDataGridCellCoord; ACellItem: TTMSFNCDataGridCellItem);
    procedure TMSFNCDataGrid1SelectCell(Sender: TObject; AStartCell,
      AEndCell: TTMSFNCDataGridCellCoord);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form92: TForm92;

implementation

{$R *.fmx}

procedure TForm92.FormCreate(Sender: TObject);
begin
  TMSFNCDataGrid1.Options.Selection.Mode := gsmDisjunctRow;
end;

procedure TForm92.TMSFNCDataGrid1CellCheckBoxChange(Sender: TObject; AColumn,
  ARow: Integer);
begin
  TMSFNCDataGrid1.SelectedRows[ARow] := TMSFNCDataGrid1.Booleans[AColumn, ARow];
  TMSFNCDataGrid1.RefreshData;
end;

procedure TForm92.TMSFNCDataGrid1GetCellDataProperties(Sender: TObject;
  ACell: TTMSFNCDataGridCellCoord; ACellItem: TTMSFNCDataGridCellItem);
begin
  if IsExtendedCell(ACellItem) then
    AsExtendedCell(ACellItem).BooleanValue := TMSFNCDataGrid1.SelectedRows[ACell.Row];
end;

procedure TForm92.TMSFNCDataGrid1SelectCell(Sender: TObject; AStartCell,
  AEndCell: TTMSFNCDataGridCellCoord);
var
  I: Integer;
begin
  for I := AStartCell.Row to AEndCell.Row do
    TMSFNCDataGrid1.Booleans[0, I] := True;

  TMSFNCDataGrid1.RefreshData;
end;

end.
