unit USample;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, Data.DB,
  FireDAC.Stan.Intf, FireDAC.Stan.Option, FireDAC.Stan.Error, FireDAC.UI.Intf,
  FireDAC.Phys.Intf, FireDAC.Stan.Def, FireDAC.Stan.Pool, FireDAC.Stan.Async,
  FireDAC.Phys, FireDAC.Phys.SQLite, FireDAC.Phys.SQLiteDef,
  FireDAC.Stan.ExprFuncs, FireDAC.Phys.SQLiteWrapper.Stat, FireDAC.FMXUI.Wait,
  FireDAC.Stan.Param, FireDAC.DatS, FireDAC.DApt.Intf, FireDAC.DApt,
  FMX.ListBox, FMX.TMSFNCDataGridData, FMX.TMSFNCDataGridRenderer,
  FMX.TMSFNCDataGridDatabaseAdapter, FireDAC.Comp.Client, FireDAC.Comp.DataSet,
  FMX.TMSFNCCustomComponent, FMX.TMSFNCDataBinding, FMX.TMSFNCPersistence,
  System.Rtti, FMX.Grid.Style, Data.Bind.EngExt, Fmx.Bind.DBEngExt,
  Fmx.Bind.Grid, System.Bindings.Outputs, Fmx.Bind.Editors,
  Data.Bind.Components, Data.Bind.Grid, Data.Bind.DBScope,
  FMX.Controls.Presentation, FMX.ScrollBox, FMX.Grid;

type
  TForm6 = class(TForm)
    TMSFNCDataBinder1: TTMSFNCDataBinder;
    DataSource1: TDataSource;
    FDConnection1: TFDConnection;
    FDTable1: TFDTable;
    FDQuery1: TFDQuery;
    DataSource2: TDataSource;
    TMSFNCDataGridDatabaseAdapter1: TTMSFNCDataGridDatabaseAdapter;
    ComboBox1: TComboBox;
    Grid1: TGrid;
    BindSourceDB1: TBindSourceDB;
    BindingsList1: TBindingsList;
    LinkGridToDataSourceBindSourceDB1: TLinkGridToDataSource;
    procedure FormCreate(Sender: TObject);
    procedure TMSFNCDataBinder1BeforeWriteFieldToProperty(Sender,
      AObject: TObject; AItem: TTMSFNCDataBinderItem;
      APropertyInfo: TTMSFNCPropertyInfo; APropertyName: string;
      APropertyKind: TTypeKind; AField: TField; var AAllow: Boolean);
    procedure TMSFNCDataBinder1BeforeWritePropertyToField(Sender,
      AObject: TObject; AItem: TTMSFNCDataBinderItem;
      APropertyInfo: TTMSFNCPropertyInfo; APropertyName: string;
      APropertyKind: TTypeKind; AField: TField; var AAllow: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form6: TForm6;

implementation

{$R *.fmx}

procedure TForm6.FormCreate(Sender: TObject);
begin
  FDConnection1.Params.Database := '..\..\cars.sdb';
  FDConnection1.Connected := True;
  FDTable1.Active := True;
  FDQuery1.Active := True;
  TMSFNCDataBinder1.ConnectList(ComboBox1, DataSource2, 'Items', 'make');
  TMSFNCDataBinder1.ConnectSingle(ComboBox1, DataSource1, 'ItemIndex', 'make').Name := 'Lookup';
  TMSFNCDataBinder1.Active := True;
end;

procedure TForm6.TMSFNCDataBinder1BeforeWriteFieldToProperty(Sender,
  AObject: TObject; AItem: TTMSFNCDataBinderItem;
  APropertyInfo: TTMSFNCPropertyInfo; APropertyName: string;
  APropertyKind: TTypeKind; AField: TField; var AAllow: Boolean);
begin
  if (AItem.Name = 'Lookup') or (AItem.Name = 'InplaceCombo') then
  begin
    AAllow := False;
    (AObject as TComboBox).ItemIndex := (AObject as TComboBox).Items.IndexOf(AField.AsString);
  end;
end;

procedure TForm6.TMSFNCDataBinder1BeforeWritePropertyToField(Sender,
  AObject: TObject; AItem: TTMSFNCDataBinderItem;
  APropertyInfo: TTMSFNCPropertyInfo; APropertyName: string;
  APropertyKind: TTypeKind; AField: TField; var AAllow: Boolean);
begin
  if (AItem.Name = 'Lookup') then
  begin
    AAllow := False;
    AField.AsString := (AObject as TComboBox).Text;
  end;
end;

end.
