unit Main;

interface

uses
  System.SysUtils, System.Classes, JS, Web, WEBLib.Graphics, WEBLib.Controls,
  WEBLib.Forms, WEBLib.Dialogs, Vcl.StdCtrls, WEBLib.StdCtrls, WEBLib.ExtCtrls, Vcl.Controls;

type
  TForm1 = class(TWebForm)
    VideoPanel: TWebPanel;
    VideoPlayer: TWebMultimediaPlayer;
    BottomPanel: TWebPanel;
    BtnLoadVideo: TWebButton;
    DlgOpenVideo: TWebOpenDialog;
    BtnPlay: TWebButton;
    procedure BtnLoadVideoClick(Sender: TObject);
    procedure DlgOpenVideoChange(Sender: TObject);
    procedure BtnPlayClick(Sender: TObject);
    procedure WebFormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure EnableInlinePlayback(const APlayer: TWebMultimediaPlayer; HideFullscreenBtn: Boolean);
    procedure VideoLoaded;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.BtnLoadVideoClick(Sender: TObject);
begin
  DlgOpenVideo.Execute;
end;

procedure TForm1.BtnPlayClick(Sender: TObject);
begin
  VideoPlayer.Play;
end;

procedure TForm1.DlgOpenVideoChange(Sender: TObject);
var mimeType: string;
begin
  if Pos('.avi', DlgOpenVideo.Files[0].Name) >= 1 then
    mimeType := 'data:video/x-msvideo;base64,'
  else
    mimeType := 'data:video/mp4;base64,';
{$IFDEF WEBLIB}

  DlgOpenVideo.Files[0].GetFileAsBase64(procedure (ABase64: string)
                                          var vidbase64: string;
                                          begin
                                            try
                                              vidbase64 := mimeType + ABase64;
                                              VideoPlayer.URL := vidbase64;
                                             except
                                              ShowMessage('DlgOpenVideo: Failed');
                                            end;
                                          end);
{$ENDIF}

end;

procedure TForm1.EnableInlinePlayback(const APlayer: TWebMultimediaPlayer; HideFullscreenBtn: Boolean);
var
{$IFDEF WEBLIB}
  V: TJSHTMLVideoElement;
{$ENDIF}
  HeadEl, StyleEl: TJSHTMLElement;
begin
  if not Assigned(APlayer.ElementHandle) then
  begin
{$IFDEF WEBLIB}
    asm
      requestAnimationFrame(function() {
        $mod.Form1.EnableInlinePlayback($mod.Form1.VideoPlayer, HideFullscreenBtn);
      });
    end;
{$ENDIF}
    Exit;
  end;

{$IFDEF WEBLIB}
  V := TJSHTMLVideoElement(APlayer.ElementHandle);

  // --- Inline playback attributes for iOS Safari ---
  V.setAttribute('playsinline', '');          // iOS inline playback
  V.setAttribute('webkit-playsinline', '');   // Legacy WebKit variant
  if HideFullscreenBtn then
    V.setAttribute('controlslist', 'nofullscreen');
{$ENDIF}

  // iOS blocks autoplay unless muted
  if APlayer.AutoPlay and not APlayer.Muted then
    APlayer.Muted := True;

  // --- Optional: CSS to hide fullscreen button ---
  if HideFullscreenBtn and Assigned(Document.head) then
  begin
    HeadEl := TJSHTMLElement(Document.head);
    if Document.querySelector('style[data-inlinevideo-css]') = nil then
    begin
      StyleEl := TJSHTMLElement(Document.createElement('style'));
      StyleEl.setAttribute('data-inlinevideo-css', '1');
      StyleEl.innerHTML :=
        'video::-webkit-media-controls-fullscreen-button{display:none}'#10 +
        'video::-webkit-media-controls-enclosure{overflow:hidden}';
      HeadEl.appendChild(StyleEl);
    end;
  end;

  // Optional: ensure click plays inline
//  V.addEventListener('click',
//    procedure(_ : TJSEvent)
//    begin
//      APlayer.Play;
//    end);
end;

procedure TForm1.WebFormCreate(Sender: TObject);
begin
{$IFDEF WEBLIB}
  asm
    this.VideoPlayer.FElement.onloadeddata = rtl.createCallback(this,"VideoLoaded");

    requestAnimationFrame(function() {
      $mod.Form1.EnableInlinePlayback($mod.Form1.VideoPlayer, true);
    });

  end;
{$ENDIF}
end;

procedure TForm1.VideoLoaded;
var cw1, cw2: Integer;
    ch1, ch2: Integer;
    vw1, vw2: Integer;
    vh1, vh2: Integer;
    svw1, svw2: Integer;
    svh1, svh2: Integer;
    px_ratio: Double;
    m_ratio: Double;
begin
  if VideoPlayer.Paused then
  begin

    {$IFDEF WEBLIB}
    asm
      vw1 = this.VideoPlayer.FElement.videoWidth;
      vh1 = this.VideoPlayer.FElement.videoHeight;
      cw1 = this.VideoPlayer.FElement.clientWidth;
      ch1 = this.VideoPlayer.FElement.clientHeight;
      this.VideoPlayer.FElement.playsInline = true;
      px_ratio = window.devicePixelRatio || window.screen.availWidth / document.documentElement.clientWidth;
    end;
    {$ENDIF}

    if (vw1 = 0) or (vh1 = 0) or (cw1 = 0 ) or (ch1 = 0 ) then
      exit;

//    VectorDraw1.Align := alNone;
//    VectorDraw1.LiveOverlay := false;

    svw1 := Round( (ch1 / vh1 * vw1));
    svh1 := Round( (cw1 / vw1 * vh1));

    if svw1 > cw1 then
      svw1 := cw1;
    if svh1 > ch1 then
      svh1 := ch1;


//    if (svh1 = ch1) then
//    begin
//        VectorDraw1.Top := 0;
//        VectorDraw1.Left := (cw1 div 2) - (svw1 div 2);
//    end
//    else
//    begin
//      VectorDraw1.Left := 0;
//      VectorDraw1.Top := (ch1 div 2) - (svh1 div 2);
//    end;
//
//    VectorDraw1.Height := svh1;
//    VectorDraw1.Width := svw1;
//
//    // this is a hack to fix the drawing when the browswer is zoomed < 100%
//    m_ratio := (1.0 + (1.0 - px_ratio));
//    if (px_ratio < 1.0) then
//    begin
//      VectorDraw1.Height := svh1 + Round(svh1 * m_ratio);
//      VectorDraw1.Width := svw1 + Round(svw1 * m_ratio);
//    end;
//
//    if FGridOn then
//    begin
//      VectorDraw1.DeleteGrid;
//      VectorDraw1.CreateGrid(70, 2, DrawColorSel.Color, TPenStyle(2), 255, 70, 70);
//    end;

  end;

  VideoPlayer.CurrentTime := 0;

end;

end.