unit USample;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs,
  FMX.TMSFNCTypes, FMX.TMSFNCUtils, FMX.TMSFNCGraphics, FMX.TMSFNCGraphicsTypes,
  System.Rtti, FMX.TMSFNCDataGridCell, FMX.TMSFNCDataGridData,
  FMX.TMSFNCDataGridBase, FMX.TMSFNCDataGridCore, FMX.TMSFNCDataGridRenderer,
  Data.Bind.Controls, FMX.Controls.Presentation, FMX.StdCtrls, Data.DB,
  Datasnap.DBClient, FMX.TMSFNCCustomComponent,
  FMX.TMSFNCDataGridDatabaseAdapter, Data.Bind.Components, Data.Bind.DBScope,
  FMX.Layouts, Fmx.Bind.Navigator, FMX.TMSFNCCustomControl, FMX.TMSFNCDataGrid;

type
  TForm7 = class(TForm)
    TMSFNCDataGrid1: TTMSFNCDataGrid;
    BindNavigator1: TBindNavigator;
    BindSourceDB1: TBindSourceDB;
    TMSFNCDataGridDatabaseAdapter1: TTMSFNCDataGridDatabaseAdapter;
    DataSource1: TDataSource;
    ClientDataSet1: TClientDataSet;
    Button1: TButton;
    procedure TMSFNCDataGrid1GetCellLayout(Sender: TObject;
      ACell: TTMSFNCDataGridCell);
    procedure FormCreate(Sender: TObject);
    procedure TMSFNCDataGrid1BeforeDrawCell(Sender: TObject;
      AGraphics: TTMSFNCGraphics; ACell: TTMSFNCDataGridCell;
      var ACanDraw: Boolean);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    FColorColumn: TTMSFNCDataGridColumn;
    FAdapterColorColumn: TTMSFNCDataGridDatabaseAdapterColumn;
  public
    { Public declarations }
  end;

var
  Form7: TForm7;

implementation

{$R *.fmx}

procedure TForm7.Button1Click(Sender: TObject);
begin
  ClientDataSet1.Active := not ClientDataSet1.Active;
end;

procedure TForm7.FormCreate(Sender: TObject);
begin
  ClientDataSet1.FieldDefs.Add('Id', ftAutoInc);
  ClientDataSet1.FieldDefs.Add('Resource', ftString, 10);
  ClientDataSet1.FieldDefs.Add('Title', ftString, 10);
  ClientDataSet1.FieldDefs.Add('Text', ftString, 255);
  ClientDataSet1.FieldDefs.Add('StartTime', ftDateTime);
  ClientDataSet1.FieldDefs.Add('EndTime', ftDateTime);
  ClientDataSet1.FieldDefs.Add('Recurrency', ftString, 255);
  ClientDataSet1.FieldDefs.Add('Color', ftLongWord);
  ClientDataSet1.CreateDataSet;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + EncodeTime(12, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + EncodeTime(20, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 0;
  ClientDataSet1.FieldByName('Title').AsString := 'New York';
  ClientDataSet1.FieldByName('Text').AsString := 'Shoe model';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcOrange;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 1 + EncodeTime(11, 30, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 1 + EncodeTime(16, 15, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 0;
  ClientDataSet1.FieldByName('Title').AsString := 'L.A.';
  ClientDataSet1.FieldByName('Text').AsString := 'Audition for movie';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcOrange;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 3 + EncodeTime(11, 30, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 3 + EncodeTime(17, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 0;
  ClientDataSet1.FieldByName('Title').AsString := 'Antwerp';
  ClientDataSet1.FieldByName('Text').AsString := 'Clothing line shoot';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcOrange;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 4 + EncodeTime(8, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 5 + EncodeTime(15, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 0;
  ClientDataSet1.FieldByName('Title').AsString := 'Milan';
  ClientDataSet1.FieldByName('Text').AsString := 'Fashion Show';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcOrange;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + EncodeTime(8, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + EncodeTime(12, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 1;
  ClientDataSet1.FieldByName('Title').AsString := 'Instagram';
  ClientDataSet1.FieldByName('Text').AsString := 'Create new content for page';
  ClientDataSet1.FieldByName('Recurrency').AsString := 'RRULE:FREQ=WEEKLY;BYDAY=TU,TH';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcDarkgray;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 2 + EncodeTime(14, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 2 + EncodeTime(22, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 1;
  ClientDataSet1.FieldByName('Title').AsString := 'Miami';
  ClientDataSet1.FieldByName('Text').AsString := 'Weekly shoot at the beach';
  ClientDataSet1.FieldByName('Recurrency').AsString := 'RRULE:FREQ=WEEKLY';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcDarkgray;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + EncodeTime(10, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + EncodeTime(20, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 2;
  ClientDataSet1.FieldByName('Title').AsString := 'TV Ad';
  ClientDataSet1.FieldByName('Text').AsString := 'Advertisement for toothpaste';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSteelblue;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 5 + EncodeTime(8, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 5 + EncodeTime(16, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 2;
  ClientDataSet1.FieldByName('Title').AsString := 'Prada Casting';
  ClientDataSet1.FieldByName('Text').AsString := 'Casting to become this years face of Prada';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSteelblue;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 2 + EncodeTime(4, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 3 + EncodeTime(20, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 2;
  ClientDataSet1.FieldByName('Title').AsString := 'Barcelona';
  ClientDataSet1.FieldByName('Text').AsString := 'Meet with Daniel Harris for audition';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSteelblue;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 3 + EncodeTime(11, 30, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 3 + EncodeTime(21, 30, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 4;
  ClientDataSet1.FieldByName('Title').AsString := 'Clothes';
  ClientDataSet1.FieldByName('Text').AsString := 'New clothes line presentation in Milan';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSeagreen;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 5 + EncodeTime(8, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 5 + EncodeTime(16, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 4;
  ClientDataSet1.FieldByName('Title').AsString := 'Prada Casting';
  ClientDataSet1.FieldByName('Text').AsString := 'Casting to become this years face of Prada';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSeagreen;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 8 + EncodeTime(9, 15, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 8 + EncodeTime(18, 45, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 4;
  ClientDataSet1.FieldByName('Title').AsString := 'Extras';
  ClientDataSet1.FieldByName('Text').AsString := 'Extras role in new sitcom';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSeagreen;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + EncodeTime(4, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + EncodeTime(22, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 3;
  ClientDataSet1.FieldByName('Title').AsString := 'Photoshoot';
  ClientDataSet1.FieldByName('Text').AsString := 'Photoshoot for bikini magazine';
  ClientDataSet1.FieldByName('Recurrency').AsString := 'RRULE:FREQ=DAILY;BYDAY=MO,FR';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSkyblue;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 1 + EncodeTime(12, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 1 + EncodeTime(20, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 3;
  ClientDataSet1.FieldByName('Title').AsString := 'Mall Model';
  ClientDataSet1.FieldByName('Text').AsString := 'Live model in Haute Couture';
  ClientDataSet1.FieldByName('Recurrency').AsString := 'RRULE:FREQ=DAILY;BYDAY=SA,SU';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcSkyblue;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 1 + EncodeTime(12, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 2 + EncodeTime(20, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 5;
  ClientDataSet1.FieldByName('Title').AsString := 'Catwalk';
  ClientDataSet1.FieldByName('Text').AsString := 'Catwalk in Paris';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcPlum;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + EncodeTime(4, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 1 + EncodeTime(16, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 6;
  ClientDataSet1.FieldByName('Title').AsString := 'TV Ad';
  ClientDataSet1.FieldByName('Text').AsString := 'Dinner with friends at the seafood restaurant while shooting a new advertisement';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcLightpink;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 4 + EncodeTime(4, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 4 + EncodeTime(20, 30, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 6;
  ClientDataSet1.FieldByName('Title').AsString := 'Catwalk';
  ClientDataSet1.FieldByName('Text').AsString := 'Catwalk in Barcelona';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcLightpink;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 5 + EncodeTime(8, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 5 + EncodeTime(16, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 6;
  ClientDataSet1.FieldByName('Title').AsString := 'Prada Casting';
  ClientDataSet1.FieldByName('Text').AsString := 'Casting to become this years face of Prada';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcLightpink;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 1;
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now) + 1 + EncodeTime(12, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 7;
  ClientDataSet1.FieldByName('Title').AsString := 'Portfolio Update';
  ClientDataSet1.FieldByName('Text').AsString := 'Shoot at the market in Phuket';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcDarkkhaki;

  ClientDataSet1.Append;
  ClientDataSet1.FieldByName('StartTime').AsDateTime := Int(Now) + 3.5 + EncodeTime(4, 0, 0, 0);
  ClientDataSet1.FieldByName('EndTime').AsDateTime := Int(Now)+ 3.5 + EncodeTime(22, 0, 0, 0);
  ClientDataSet1.FieldByName('Resource').AsInteger := 7;
  ClientDataSet1.FieldByName('Title').AsString := 'Exclusive Night';
  ClientDataSet1.FieldByName('Text').AsString := 'Steward on Exclusive Night event';
  ClientDataSet1.FieldByName('Color').AsLongWord := gcDarkkhaki;

  ClientDataSet1.Post;
  ClientDataSet1.First;

  TMSFNCDataGrid1.Options.Column.Stretching.Enabled := True;
  TMSFNCDataGridDatabaseAdapter1.Active := True;

  TMSFNCDataGridDatabaseAdapter1.AutoRemoveColumns := False;
  FAdapterColorColumn := TMSFNCDataGridDatabaseAdapter1.ColumnAtField['Color'];
  FColorColumn := FAdapterColorColumn.GridColumn;
  FAdapterColorColumn.UseColumnEditor := True;
  FColorColumn.AddSetting(gcsEditor);
  FColorColumn.Editor := getColorPicker;
  FColorColumn.AddSetting(gcsEditorTarget);
  FColorColumn.EditorTarget := getCellValue;
end;

procedure TForm7.TMSFNCDataGrid1BeforeDrawCell(Sender: TObject;
  AGraphics: TTMSFNCGraphics; ACell: TTMSFNCDataGridCell;
  var ACanDraw: Boolean);
begin
  if ACell.Row = 0 Then
    Exit;

  if ACell.Column = FColorColumn.Index Then
    ACell.DrawElements := ACell.DrawElements - [gcdText];
end;

procedure TForm7.TMSFNCDataGrid1GetCellLayout(Sender: TObject;
  ACell: TTMSFNCDataGridCell);
var
  r: Integer;
begin
  if not Assigned(TMSFNCDataGridDatabaseAdapter1) or not TMSFNCDataGridDatabaseAdapter1.CheckDataSet then
    Exit;

  if TMSFNCDataGrid1.States[ACell.Column, ACell.Row] in [gcsFocused] then
    Exit;

  if not Assigned(FAdapterColorColumn) or not Assigned(FColorColumn) or (ACell.Column <> FColorColumn.Index) then
    Exit;

  r := TMSFNCDataGridDatabaseAdapter1.DataLink.ActiveRecord;
  try
    if TMSFNCDataGridDatabaseAdapter1.SetActiveRecord(ACell.Row) then
      ACell.Layout.Fill.Color := FAdapterColorColumn.Field.AsLargeInt;

  finally
    TMSFNCDataGridDatabaseAdapter1.DataLink.ActiveRecord := r;
  end;
end;

end.
