{********************************************************************}
{                                                                    }
{ written by TMS Software                                            }
{            copyright (c) 2025                                      }
{            Email : info@tmssoftware.com                            }
{            Web : http://www.tmssoftware.com                        }
{                                                                    }
{ The source code is given as is. The author is not responsible      }
{ for any possible damage done due to the use of this code.          }
{ The complete source code remains property of the author and may    }
{ not be distributed, published, given or sold in any form as such.  }
{ No parts of the source code can be included in any other component }
{ or application without written authorization of the author.        }
{********************************************************************}

unit Uaikeys;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  Vcl.Controls, Vcl.Forms, Vcl.Graphics, Vcl.Dialogs,
  Vcl.StdCtrls, TMS.MCP.CustomComponent,
  TMS.MCP.CloudBase, TMS.MCP.CloudAI;

type
  TAIKeysForm = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Button2: TButton;
    Button1: TButton;
    TMSMCPCloudAI1: TTMSMCPCloudAI;
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

const
  keysfile = '.\aikeys.cfg';
  keyspwd = 'tmssoftware.com';


var
  AIKeysForm: TAIKeysForm;

implementation

{$R *.dfm}


procedure TAIKeysForm.Button1Click(Sender: TObject);
begin
  Close;
end;

procedure TAIKeysForm.Button2Click(Sender: TObject);
begin
  TMSMCPCloudAI1.APIKeys.Claude := Edit1.Text;
  TMSMCPCloudAI1.APIKeys.DeepSeek := Edit2.Text;
  TMSMCPCloudAI1.APIKeys.Gemini := Edit3.Text;
  TMSMCPCloudAI1.APIKeys.Grok := Edit4.Text;
  TMSMCPCloudAI1.APIKeys.Mistral := Edit5.Text;
  TMSMCPCloudAI1.APIKeys.OpenAI := Edit6.Text;
  TMSMCPCloudAI1.APIKeys.Perplexity := Edit7.Text;

  TMSMCPCloudAI1.APIKeys.SaveToFile(keysfile, keyspwd);
end;

procedure TAIKeysForm.FormCreate(Sender: TObject);
begin
  TMSMCPCloudAI1.APIKeys.LoadFromFile(keysfile, keyspwd);

  Edit1.Text := TMSMCPCloudAI1.APIKeys.Claude;
  Edit2.Text := TMSMCPCloudAI1.APIKeys.DeepSeek;
  Edit3.Text := TMSMCPCloudAI1.APIKeys.Gemini;
  Edit4.Text := TMSMCPCloudAI1.APIKeys.Grok;
  Edit5.Text := TMSMCPCloudAI1.APIKeys.Mistral;
  Edit6.Text := TMSMCPCloudAI1.APIKeys.OpenAI;
  Edit7.Text := TMSMCPCloudAI1.APIKeys.Perplexity;

end;

end.
